#!/usr/local/bin/perl
BEGIN
{
    use Test::More qw( no_plan );
    use_ok( 'Regexp::Common::Apache2' ) || BAIL_OUT( "Unable to load Regexp::Common::Apache2" );
    use lib './lib';
    use Regexp::Common qw( Apache2 );
    require( "./t/functions.pl" ) || BAIL_OUT( "Unable to find library \"functions.pl\"." );
};

my $tests = 
[
    {
        name            => q{regex},
        regany          => q{/\w+\.\w+\;?/i},
        regany_regex    => q{/\w+\.\w+\;?/i},
        regex           => q{/\w+\.\w+\;?/i},
        regflags        => q{i},
        regpattern      => q{\w+\.\w+\;?},
        test            => q{/\w+\.\w+\;?/i},
    },
    {
        name            => q{m-regex using /},
        regany          => q{m/w+/i},
        regany_regex    => q{m/w+/i},
        regex           => q{m/w+/i},
        regflags        => q{i},
        regpattern      => q{w+},
        regsep          => q{/},
        test            => q{m/w+/i},
    },
    {
        name            => q{m-regex using #},
        regany          => q{m#\w+#i},
        regany_regex    => q{m#\w+#i},
        regex           => q{m#\w+#i},
        regflags        => q{i},
        regpattern      => q{\w+},
        regsep          => q{#},
        test            => q{m#\w+#i},
    },
    {
        name            => q{m-regex using $},
        regany          => q{m$\w+$i},
        regany_regex    => q{m$\w+$i},
        regex           => q{m$\w+$i},
        regflags        => q{i},
        regpattern      => q{\w+},
        regsep          => q{$},
        test            => q{m$\w+$i},
    },
    {
        name            => q{m-regex using %},
        regany          => q{m%\w+%i},
        regany_regex    => q{m%\w+%i},
        regex           => q{m%\w+%i},
        regflags        => q{i},
        regpattern      => q{\w+},
        regsep          => q{%},
        test            => q{m%\w+%i},
    },
    {
        name            => q{m-regex using ^},
        regany          => q{m^\w+^i},
        regany_regex    => q{m^\w+^i},
        regex           => q{m^\w+^i},
        regflags        => q{i},
        regpattern      => q{\w+},
        regsep          => q{^},
        test            => q{m^\w+^i},
    },
    {
        name            => q{m-regex using |},
        regany          => q{m|\w+|i},
        regany_regex    => q{m|\w+|i},
        regex           => q{m|\w+|i},
        regflags        => q{i},
        regpattern      => q{\w+},
        regsep          => q{|},
        test            => q{m|\w+|i},
    },
    {
        name            => q{m-regex using ?},
        regany          => q{m?\w+?i},
        regany_regex    => q{m?\w+?i},
        regex           => q{m?\w+?i},
        regflags        => q{i},
        regpattern      => q{\w+},
        regsep          => q{?},
        test            => q{m?\w+?i},
    },
    {
        name            => q{m-regex using !},
        regany          => q{m!\w+!i},
        regany_regex    => q{m!\w+!i},
        regex           => q{m!\w+!i},
        regflags        => q{i},
        regpattern      => q{\w+},
        regsep          => q{!},
        test            => q{m!\w+!i},
    },
    {
        name            => q{m-regex using '},
        regany          => q{m'\w+'i},
        regany_regex    => q{m'\w+'i},
        regex           => q{m'\w+'i},
        regflags        => q{i},
        regpattern      => q{\w+},
        regsep          => q{'},
        test            => q{m'\w+'i},
    },
    {
        name            => q{m-regex using "},
        regany          => q{m"\w+"i},
        regany_regex    => q{m"\w+"i},
        regex           => q{m"\w+"i},
        regflags        => q{i},
        regpattern      => q{\w+},
        regsep          => q{"},
        test            => q{m"\w+"i},
    },
    {
        name            => q{m-regex using ,},
        regany          => q{m,\w+,i},
        regany_regex    => q{m,\w+,i},
        regex           => q{m,\w+,i},
        regflags        => q{i},
        regpattern      => q{\w+},
        regsep          => q{,},
        test            => q{m,\w+,i},
    },
    {
        name            => q{m-regex using ;},
        regany          => q{m;\w+;i},
        regany_regex    => q{m;\w+;i},
        regex           => q{m;\w+;i},
        regflags        => q{i},
        regpattern      => q{\w+},
        regsep          => q{;},
        test            => q{m;\w+;i},
    },
    {
        name            => q{m-regex using :},
        regany          => q{m:\w+:i},
        regany_regex    => q{m:\w+:i},
        regex           => q{m:\w+:i},
        regflags        => q{i},
        regpattern      => q{\w+},
        regsep          => q{:},
        test            => q{m:\w+:i},
    },
    {
        name            => q{m-regex using .},
        regany          => q{m.\w+.i},
        regany_regex    => q{m.\w+.i},
        regex           => q{m.\w+.i},
        regflags        => q{i},
        regpattern      => q{\w+},
        regsep          => q{.},
        test            => q{m.\w+.i},
    },
    {
        name            => q{m-regex using _},
        regany          => q{m_\w+_i},
        regany_regex    => q{m_\w+_i},
        regex           => q{m_\w+_i},
        regflags        => q{i},
        regpattern      => q{\w+},
        regsep          => q{_},
        test            => q{m_\w+_i},
    },
    {
        name            => q{m-regex using -},
        regany          => q{m-\w+-i},
        regany_regex    => q{m-\w+-i},
        regex           => q{m-\w+-i},
        regflags        => q{i},
        regpattern      => q{\w+},
        regsep          => q{-},
        test            => q{m-\w+-i},
    },
];

my $sub = $ENV{AUTHOR_TESTING} ? \&dump_tests : \&run_tests;
$sub->( $tests,
{
    type => 'Regany (Trunk)',
    re => $RE{Apache2}{TrunkRegany},
});
