
package Apache::MP3::L10N::ja;  # Japanese
# Encoded in Shift_JIS, de facto standard of MP3 tags in Japan
use strict;
use Apache::MP3::L10N;
use vars qw($VERSION @ISA %Lexicon);
@ISA = qw(Apache::MP3::L10N);

# Translator: miyagawa@bulknews.net

sub encoding {'shift_jis'} # Shift-JIS
sub language_tag {__PACKAGE__->SUPER::language_tag}

sub sworp {
  # Treat [ and ] as literal; use { and } as the metacharacters.
  my @in = @_;
  foreach my $x (@in) {
    $x =~ s/\[/~[/g;
    $x =~ s/\]/~]/g;
    $x =~ tr<{}><[]>;
  }
  @in;
}

%Lexicon = (sworp(
 '_VERSION' => __PACKAGE__ . ' v' . ($VERSION =
   '20020612'), # Last modified

 # These are links as well as button text:
 'Play All' => 'vC',
 'Shuffle All' => 'Vbt',  # Stream all in random order
 'Stream All' => 'Xg[~O',

 # This one in just button text
 'Play Selected' => '`FbN̂vC',
 
 "In this demo, streaming is limited to approximately {quant,_1,second,seconds}."
  => "̃fł́AXg[~O {quant,_1,b,b} Ɍ肳Ă܂B",
  # In [quant,_1,seconde,secondes], the seconde is the singular form, and the secondes is the plural.
 
 # Headings:
 'CD Directories ({_1})' => 'CD fBNg ({_1})',
 'Playlists ({_1})' => 'vCXg ({_1})',
 'Song List ({_1})' => 't@CXg ({_1})',

 'Playlist' => 'vCXg',
 'Select' => 'I',
 
 'fetch'  => '_E[h',   # this file
 'stream' => 'Xg[~O',    # this file
 
 'Shuffle'  => 'Vbt',  # a subdirectory, recursively
 'Stream'   => 'Xg[~O',            # a subdirectory, recursively
 
 # Label for a link to "http://[servername]/"
 'Home' => 'Home',

 # Credits
 "_CREDITS_before_author" => "Apache::MP3 by ",
 "_CREDITS_author"        => "Lincoln D. Stein", 
 "_CREDITS_after_author"  => ".",


 'unknown' => 'unknown',

 # Metadata fields:
 'Artist' => 'A[eBXg',
 'Comment' => 'Rg',
 'Duration' => 't',
 'Filename' => 't@C',
 'Genre' => 'W',
 'Album' => 'Ao',
 'Min' => '',
 'Track' => 'gbN',  # just the track number (not the track name)
 'Samplerate' => 'Tv[g',
 'Bitrate' => 'rbg[g',
 'Sec' => 'b',
 'Seconds' => 'b',
 'Title' => '^Cg',
 'Year' => 'N',


 # Now the stuff for the help page:

 'Quick Help Summary' => 'NCbNwv',
  # page title as well as the text we use for linking to that page

 "= Stream all songs" => '= ׂĂ̋ȂXg[~O',
 "= Shuffle-play all Songs" => '= ׂĂ̋ȂVbtĉt',
 "= Go to earlier directory" => '= ̃fBNg',
 "= Stream contents" => '= RecXg[~O',
 "= Enter directory" => '= fBNgJ',
 "= Stream this song" => '= ̋ȂXg[~O',
 "= Select for streaming" => '= Xg[~OpɃ`FbN',
 "= Download this song" => '= ̋Ȃ_E[h',
 "= Stream this song" => '= ̋ȂXg[~O',
 "= Sort by field" => '= tB[hŃ\[g',

));

1;

