use lib 'lib';
use utf8;
use Text::WagnerFischer::Armenian qw{ distance };
use Test::More tests => 26;
binmode STDOUT, ":utf8";
is( distance( "կինք", "կին" ), 0.5, "Armenian suffix" );
is( distance( "զկին", "կին" ), 0.5, "Armenian prefix" );
is( distance( "Æble", "Able" ), 1, "normal substitution" );
is( distance( "Able", "ble" ), 1, "normal deletion" );
is( distance( "able", "able" ), 0, "identical strings" );
is( distance( "Հա՛ոց", "Հայոց" ), 0.5, "Armenian vocalic equivlaence" );
is( distance( "զձեռն", "ձեռնն" ), 1, "Armenian prefix + suffix" );
is( distance( "ձեռն", "ձեռան" ), 1, "normal Arm insertion" );
is( distance( "աղօթեալ", "ախօթեալք" ), 1.5, "Armenian suffix + substitution" );
is( distance( "զզօրս", "զորս" ), 1, "Armenian prefix + vocalic equivalence" );
is( distance( "ձեռն", "Ձեռն" ), 0.25, "case mismatch for Armenian words" );
is( distance( "Able", "able" ), 1, "case mismatch for normal words" );
is( distance( "apple", "a*ple" ), 1, "Pattern metacharacters are safe" );

my $new_distances = [ 0, 2, 2, 0.5, 1, 1, 1 ];
is( distance( $new_distances, "կին", "կինք" ), 1, "Armenian suffix doubled" );
is( distance( $new_distances, "կին", "զկին" ), 1, "Armenian prefix doubled" );
is( distance( $new_distances, "Able", "Æble" ), 2, "normal substitution doubled" );
is( distance( $new_distances, "ble", "Able" ), 2, "normal deletion doubled" );
is( distance( $new_distances, "able", "able" ), 0, "identical strings doubled" );
is( distance( $new_distances, "Հայոց", "Հա՛ոց" ), 1, "Armenian vocalic equivalence doubled" );
is( distance( $new_distances, "ձեռնն", "զձեռն" ), 2, "Armenian prefix + suffix doubled" );
is( distance( $new_distances, "ձեռան", "ձեռն" ), 2, "normal Arm insertion doubled" );
is( distance( $new_distances, "ախօթեալք", "աղօթեալ" ), 3, "Armenian suffix + substitution doubled" );
is( distance( $new_distances, "զորս", "զզօրս" ), 2, "Armenian prefix + vocalic equivalence doubled" );
is( distance( $new_distances, "Ձեռն", "ձեռն" ), 0.5, "case mismatch for Armenian words doubled" );
is( distance( $new_distances, "able", "Able" ), 2, "case mismatch for normal words doubled" );
is( distance( $new_distances, "a*ple", "apple" ), 2, "Pattern metacharacters are safe doubled" );
