#
# Patch given file with DATA hunks and print to STDOUT.
#
use strict;
use warnings;
use Text::Patch 'patch';

my $in = $ARGV[0];

my ($txt, $patch);
{
    local $/;
    open my $fh, '<', $in or die "open: $in: $!";
    $txt   = <$fh>;
    $patch = <DATA>;
}

#print $txt,"\n";
#exit;

my $out = patch( $txt, $patch, STYLE => 'Unified' );

print $out;
exit 0;

__END__
--- usrc/uuid/gen_uuid.c	2023-11-25 08:55:26.315363099 -0500
+++ gen_uuid.c	2023-11-26 18:16:15.432573120 -0500
@@ -259,11 +259,17 @@
 	for (i = 0; i < n; i+= ifreq_size(*ifrp) ) {
 		ifrp = (struct ifreq *)((char *) ifc.ifc_buf+i);
 		strncpy(ifr.ifr_name, ifrp->ifr_name, IFNAMSIZ);
-#ifdef SIOCGIFHWADDR
+#if defined(SIOCGIFHWADDR) && ( defined(ifr_hwaddr) || defined(ifr_addr) )
 		if (ioctl(sd, SIOCGIFHWADDR, &ifr) < 0)
 			continue;
+#ifdef ifr_hwaddr
 		a = (unsigned char *) &ifr.ifr_hwaddr.sa_data;
 #else
+#ifdef ifr_addr
+		a = (unsigned char *) &ifr.ifr_addr.sa_data;
+#endif /* ifr_addr */
+#endif /* ifr_hwaddr */
+#else
 #ifdef SIOCGENADDR
 		if (ioctl(sd, SIOCGENADDR, &ifr) < 0)
 			continue;
