/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.phantomjs;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.logging.Logger;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.Proxy;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.net.PortProber;
import org.openqa.selenium.os.ExecutableFinder;
import org.openqa.selenium.remote.service.DriverService;

public class PhantomJSDriverService
extends DriverService {
    private static final Logger LOG = Logger.getLogger(PhantomJSDriverService.class.getName());
    public static final String PHANTOMJS_EXECUTABLE_PATH_PROPERTY = "phantomjs.binary.path";
    public static final String PHANTOMJS_GHOSTDRIVER_PATH_PROPERTY = "phantomjs.ghostdriver.path";
    public static final String PHANTOMJS_CLI_ARGS = "phantomjs.cli.args";
    public static final String PHANTOMJS_GHOSTDRIVER_CLI_ARGS = "phantomjs.ghostdriver.cli.args";
    public static final String PHANTOMJS_PAGE_SETTINGS_PREFIX = "phantomjs.page.settings.";
    public static final String PHANTOMJS_PAGE_CUSTOMHEADERS_PREFIX = "phantomjs.page.customHeaders.";
    private static final String PHANTOMJS_DEFAULT_LOGFILE = "phantomjsdriver.log";
    private static final String PHANTOMJS_DEFAULT_EXECUTABLE = "phantomjs";
    private static final String PHANTOMJS_DOC_LINK = "https://github.com/ariya/phantomjs/wiki";
    private static final String PHANTOMJS_DOWNLOAD_LINK = "http://phantomjs.org/download.html";
    private static final String GHOSTDRIVER_DOC_LINK = "https://github.com/detro/ghostdriver/blob/master/README.md";
    private static final String GHOSTDRIVER_DOWNLOAD_LINK = "https://github.com/detro/ghostdriver/downloads";

    private PhantomJSDriverService(File executable, int port, ImmutableList<String> args, ImmutableMap<String, String> environment) throws IOException {
        super(executable, port, args, environment);
        LOG.info("executable: " + executable.getAbsolutePath());
        LOG.info("port: " + port);
        LOG.info("arguments: " + args.toString());
        LOG.info("environment: " + environment.toString());
    }

    public static PhantomJSDriverService createDefaultService(Capabilities desiredCapabilities) {
        Proxy proxy = null;
        if (desiredCapabilities != null) {
            proxy = Proxy.extractFrom(desiredCapabilities);
        }
        File phantomjsfile = PhantomJSDriverService.findPhantomJS(desiredCapabilities, PHANTOMJS_DOC_LINK, PHANTOMJS_DOWNLOAD_LINK);
        File ghostDriverfile = PhantomJSDriverService.findGhostDriver(desiredCapabilities, GHOSTDRIVER_DOC_LINK, GHOSTDRIVER_DOWNLOAD_LINK);
        return new Builder().usingPhantomJSExecutable(phantomjsfile).usingGhostDriver(ghostDriverfile).usingAnyFreePort().withProxy(proxy).withLogFile(new File(PHANTOMJS_DEFAULT_LOGFILE)).usingCommandLineArguments(PhantomJSDriverService.findCLIArgumentsFromCaps(desiredCapabilities, PHANTOMJS_CLI_ARGS)).usingGhostDriverCommandLineArguments(PhantomJSDriverService.findCLIArgumentsFromCaps(desiredCapabilities, PHANTOMJS_GHOSTDRIVER_CLI_ARGS)).build();
    }

    public static PhantomJSDriverService createDefaultService() {
        return PhantomJSDriverService.createDefaultService(null);
    }

    protected static File findPhantomJS(Capabilities desiredCapabilities, String docsLink, String downloadLink) {
        String phantomjspath;
        if (desiredCapabilities != null && desiredCapabilities.getCapability(PHANTOMJS_EXECUTABLE_PATH_PROPERTY) != null) {
            phantomjspath = (String)desiredCapabilities.getCapability(PHANTOMJS_EXECUTABLE_PATH_PROPERTY);
        } else {
            phantomjspath = new ExecutableFinder().find(PHANTOMJS_DEFAULT_EXECUTABLE);
            phantomjspath = System.getProperty(PHANTOMJS_EXECUTABLE_PATH_PROPERTY, phantomjspath);
        }
        Preconditions.checkState(phantomjspath != null, "The path to the driver executable must be set by the %s capability/system property/PATH variable; for more information, see %s. The latest version can be downloaded from %s", (Object)PHANTOMJS_EXECUTABLE_PATH_PROPERTY, (Object)docsLink, (Object)downloadLink);
        File phantomjs = new File(phantomjspath);
        PhantomJSDriverService.checkExecutable(phantomjs);
        return phantomjs;
    }

    protected static File findGhostDriver(Capabilities desiredCapabilities, String docsLink, String downloadLink) {
        String ghostdriverpath = desiredCapabilities != null && desiredCapabilities.getCapability(PHANTOMJS_GHOSTDRIVER_PATH_PROPERTY) != null ? (String)desiredCapabilities.getCapability(PHANTOMJS_GHOSTDRIVER_PATH_PROPERTY) : System.getProperty(PHANTOMJS_GHOSTDRIVER_PATH_PROPERTY);
        if (ghostdriverpath != null) {
            File ghostdriver = new File(ghostdriverpath);
            Preconditions.checkState(ghostdriver.exists(), "The GhostDriver does not exist: %s", (Object)ghostdriver.getAbsolutePath());
            Preconditions.checkState(ghostdriver.isFile(), "The GhostDriver is a directory: %s", (Object)ghostdriver.getAbsolutePath());
            Preconditions.checkState(ghostdriver.canRead(), "The GhostDriver is not a readable file: %s", (Object)ghostdriver.getAbsolutePath());
            return ghostdriver;
        }
        return null;
    }

    private static String[] findCLIArgumentsFromCaps(Capabilities desiredCapabilities, String capabilityName) {
        Object cap;
        if (desiredCapabilities != null && (cap = desiredCapabilities.getCapability(capabilityName)) != null) {
            if (cap instanceof String[]) {
                return (String[])cap;
            }
            if (cap instanceof Collection) {
                try {
                    Collection capCollection = (Collection)cap;
                    return capCollection.toArray(new String[capCollection.size()]);
                }
                catch (Exception e) {
                    LOG.warning(String.format("Unable to set Capability '%s' as it was neither a String[] or a Collection<String>", capabilityName));
                }
            }
        }
        return new String[0];
    }

    public static class Builder {
        private int port = 0;
        private File phantomjs = null;
        private File ghostdriver = null;
        private ImmutableMap<String, String> environment = ImmutableMap.of();
        private File logFile;
        private Proxy proxy = null;
        private String[] commandLineArguments = null;
        private String[] ghostdriverCommandLineArguments = null;

        public Builder usingPhantomJSExecutable(File file) {
            Preconditions.checkNotNull(file);
            PhantomJSDriverService.checkExecutable(file);
            this.phantomjs = file;
            return this;
        }

        public Builder usingGhostDriver(File file) {
            this.ghostdriver = file;
            return this;
        }

        public Builder usingPort(int port) {
            Preconditions.checkArgument(port >= 0, "Invalid port number: %d", port);
            this.port = port;
            return this;
        }

        public Builder usingAnyFreePort() {
            this.port = 0;
            return this;
        }

        public Builder withEnvironment(Map<String, String> environment) {
            this.environment = ImmutableMap.copyOf(environment);
            return this;
        }

        public Builder withLogFile(File logFile) {
            this.logFile = logFile;
            return this;
        }

        public Builder withProxy(Proxy proxy) {
            this.proxy = proxy;
            return this;
        }

        public Builder usingCommandLineArguments(String[] commandLineArguments) {
            this.commandLineArguments = commandLineArguments;
            return this;
        }

        public Builder usingGhostDriverCommandLineArguments(String[] ghostdriverCommandLineArguments) {
            this.ghostdriverCommandLineArguments = ghostdriverCommandLineArguments;
            return this;
        }

        public PhantomJSDriverService build() {
            this.port = this.port == 0 ? PortProber.findFreePort() : this.port;
            Preconditions.checkState(this.phantomjs != null, "Path to PhantomJS executable not specified");
            try {
                ImmutableList.Builder argsBuilder = ImmutableList.builder();
                if (this.proxy != null) {
                    switch (this.proxy.getProxyType()) {
                        case MANUAL: {
                            if (this.proxy.getHttpProxy() != null && !this.proxy.getHttpProxy().isEmpty()) {
                                argsBuilder.add("--proxy-type=http");
                                argsBuilder.add(String.format("--proxy=%s", this.proxy.getHttpProxy()));
                                break;
                            }
                            if (this.proxy.getSocksProxy() != null && !this.proxy.getSocksProxy().isEmpty()) {
                                argsBuilder.add("--proxy-type=socks5");
                                argsBuilder.add(String.format("--proxy=%s", this.proxy.getSocksProxy()));
                                if (this.proxy.getSocksUsername() == null || this.proxy.getSocksUsername().isEmpty() || this.proxy.getSocksPassword() == null || this.proxy.getSocksPassword().isEmpty()) break;
                                argsBuilder.add(String.format("--proxy-auth=%s:%s", this.proxy.getSocksUsername(), this.proxy.getSocksPassword()));
                                break;
                            }
                            Preconditions.checkArgument(true, "PhantomJS supports only HTTP and Socks5 Proxy currently");
                            break;
                        }
                        case PAC: {
                            Preconditions.checkArgument(true, "PhantomJS doesn't support Proxy PAC files");
                            break;
                        }
                        case SYSTEM: {
                            argsBuilder.add("--proxy-type=system");
                            break;
                        }
                        case AUTODETECT: {
                            Preconditions.checkArgument(true, "PhantomJS doesn't support Proxy Auto-configuration");
                            break;
                        }
                        default: {
                            argsBuilder.add("--proxy-type=none");
                        }
                    }
                }
                if (this.commandLineArguments != null) {
                    argsBuilder.add(this.commandLineArguments);
                }
                if (this.ghostdriver != null) {
                    argsBuilder.add(this.ghostdriver.getCanonicalPath());
                    if (!this.argsContains(this.ghostdriverCommandLineArguments, "port")) {
                        argsBuilder.add(String.format("--port=%d", this.port));
                    }
                    if (this.logFile != null && !this.argsContains(this.ghostdriverCommandLineArguments, "logFile")) {
                        argsBuilder.add(String.format("--logFile=%s", this.logFile.getAbsolutePath()));
                    }
                    if (this.ghostdriverCommandLineArguments != null) {
                        argsBuilder.add(this.ghostdriverCommandLineArguments);
                    }
                } else {
                    if (!this.argsContains(this.commandLineArguments, "webdriver")) {
                        argsBuilder.add(String.format("--webdriver=%d", this.port));
                    }
                    if (this.logFile != null && !this.argsContains(this.commandLineArguments, "webdriver-logfile")) {
                        argsBuilder.add(String.format("--webdriver-logfile=%s", this.logFile.getAbsolutePath()));
                    }
                }
                return new PhantomJSDriverService(this.phantomjs, this.port, (ImmutableList)argsBuilder.build(), this.environment);
            }
            catch (IOException e) {
                throw new WebDriverException(e);
            }
        }

        private boolean argsContains(String[] args, String targetArg) {
            if (args != null) {
                for (int i = 0; i < args.length; ++i) {
                    String arg = args[i];
                    if (!arg.startsWith("--" + targetArg + "=")) continue;
                    return true;
                }
            }
            return false;
        }
    }
}

