
######################################################################
## $Id: Select.pm 12431 2009-01-13 18:29:49Z spadkins $
######################################################################

package App::Widget::Select;
$VERSION = (q$Revision: 12431 $ =~ /(\d[\d\.]*)/)[0];  # VERSION numbers generated by svn

use App::Widget::Stylizable;
@ISA = ( "App::Widget::Stylizable" );

use strict;

=head1 NAME

App::Widget::Select - Generic HTML element can be anything with proper configuration

=head1 SYNOPSIS

   use App::Widget::Select;

   $name = "gobutton";
   $config = { };
   $state = CGI->new({});
   $w = App::Widget::Select->new($config,$state,"gobutton", $config, $state);

=cut

######################################################################
# CONSTANTS
######################################################################

######################################################################
# ATTRIBUTES
######################################################################

# INPUTS FROM THE ENVIRONMENT

=head1 DESCRIPTION

This class is a <select> HTML element.

=cut

######################################################################
# CONSTRUCTOR
######################################################################

# uncomment this when I need to do more than just call SUPER::_init()
sub _init {
    my $self = shift;
    my $context = $self->{context};
    my $name = $self->{name};
    my $value = $context->so_get($name);
    my ($values, $labels);
    if (! defined $value && $self->{init_default}) {
        ($values, $labels) = $self->values_labels();
        if ($#$values > -1) {
            $value = $values->[0];
            $context->so_set($name, undef, $value);
        }
    }
    elsif (defined $value && $value eq "EACH") {
        ($values, $labels) = $self->values_labels();
        $value = join(",", @$values);
        $context->so_set($name, undef, $value);
    }
    $self->SUPER::_init(@_);
}

######################################################################
# METHODS
######################################################################

######################################################################
# OUTPUT METHODS
######################################################################

sub unstyled_html {
    my $self = shift;
    my ($context, $name, @currvalues, $values, @values, $labels);
    my ($tagname, $nullable, $size, $multiple, $tabindex, $onchange, $enablewarn, $enable_warning_widget);

    $context       = $self->{context};
    $name     = $self->{name};

    $nullable = $self->get("nullable");
    $size     = $self->get("size");
    $multiple = $self->get("multiple");
    $tabindex = $self->get("tabindex");
    $onchange = $self->get("submit_on_change");
    $enablewarn = $self->get("enable_warning");
    $enable_warning_widget = $self->get("enable_warning_widget");

    ($values, $labels) = $self->values_labels();

    if ($nullable) {
        $values = [ "", @$values ];
    }

    $size     = (defined $size && $size ne "") ? " size='$size'" : "";
    $tabindex = (defined $tabindex && $tabindex ne "") ? " tabindex='$tabindex'" : "";
    $multiple = $multiple ? " multiple" : "";
    $tagname  = $multiple ? "$name\[]" : $name;
    $onchange = $onchange ? " onchange=\"document.forms[0].submit();\"" : "";

    if($enablewarn) {
        $onchange = " onchange=\"javascript: var enable_warning = context.getElementByName('" . $enable_warning_widget . "'); ";
        $onchange .= " enable_warning.value = 'enabled';\" ";
    }

    my ($value, $v, %value_exists, $value_exists, @html);
    @currvalues = $self->get_values();
    foreach $value (@currvalues) {
        if (defined $value) {
            $value_exists{$value} = 1;
            $value_exists = 1;
        }
    }
    for ($v = 0; $v <= $#$values; $v++) {
        $value = $values->[$v];
        my $convert_value = $self->html_escape($value);
        push(@html,"  <option value='$convert_value'" .
            ($value_exists{$value} ? " selected>" : ">") .
            ((defined $labels->{$value}) ? $self->html_escape($labels->{$value}) : $convert_value) .
            "</option>\n");   
    }
    my $html_attribs = $self->html_attribs();
    return "<select name='$tagname'${size}${multiple}${tabindex}${onchange}$html_attribs>\n" . join("",@html) . "</select>";
}

1;

