/*
 * Decompiled with CFR 0.152.
 */
package org.couchbase.mock.memcached;

import org.couchbase.mock.Bucket;
import org.couchbase.mock.memcached.CommandExecutor;
import org.couchbase.mock.memcached.MemcachedConnection;
import org.couchbase.mock.memcached.MemcachedServer;
import org.couchbase.mock.memcached.protocol.BinaryCommand;
import org.couchbase.mock.memcached.protocol.BinarySaslResponse;
import org.couchbase.mock.memcached.protocol.CommandCode;
import org.couchbase.mock.memcached.protocol.ErrorCode;

public class SaslCommandExecutor
implements CommandExecutor {
    @Override
    public void execute(BinaryCommand cmd, MemcachedServer server, MemcachedConnection client) {
        CommandCode cc = cmd.getComCode();
        switch (cc) {
            case SASL_LIST_MECHS: {
                client.sendResponse(new BinarySaslResponse(cmd, "PLAIN"));
                break;
            }
            case SASL_AUTH: {
                String[] clientin = new String(cmd.getValue()).split("\u0000");
                Bucket bucket = server.getBucket();
                if (bucket.getName().equals(clientin[1]) && bucket.getPassword().equals(clientin[2])) {
                    client.sendResponse(new BinarySaslResponse(cmd, "Authenticated"));
                    client.setAuthenticated(true);
                    break;
                }
                client.sendResponse(new BinarySaslResponse(cmd, ErrorCode.AUTH_ERROR));
                break;
            }
            case SASL_STEP: {
                client.sendResponse(new BinarySaslResponse(cmd, ErrorCode.AUTH_ERROR));
                break;
            }
            default: {
                client.sendResponse(new BinarySaslResponse(cmd, ErrorCode.AUTH_ERROR));
            }
        }
    }
}

