# Generated by default/object.tt
package Paws::EKS::OidcIdentityProviderConfigRequest;
  use Moose;
  has ClientId => (is => 'ro', isa => 'Str', request_name => 'clientId', traits => ['NameInRequest'], required => 1);
  has GroupsClaim => (is => 'ro', isa => 'Str', request_name => 'groupsClaim', traits => ['NameInRequest']);
  has GroupsPrefix => (is => 'ro', isa => 'Str', request_name => 'groupsPrefix', traits => ['NameInRequest']);
  has IdentityProviderConfigName => (is => 'ro', isa => 'Str', request_name => 'identityProviderConfigName', traits => ['NameInRequest'], required => 1);
  has IssuerUrl => (is => 'ro', isa => 'Str', request_name => 'issuerUrl', traits => ['NameInRequest'], required => 1);
  has RequiredClaims => (is => 'ro', isa => 'Paws::EKS::RequiredClaimsMap', request_name => 'requiredClaims', traits => ['NameInRequest']);
  has UsernameClaim => (is => 'ro', isa => 'Str', request_name => 'usernameClaim', traits => ['NameInRequest']);
  has UsernamePrefix => (is => 'ro', isa => 'Str', request_name => 'usernamePrefix', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::EKS::OidcIdentityProviderConfigRequest

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::EKS::OidcIdentityProviderConfigRequest object:

  $service_obj->Method(Att1 => { ClientId => $value, ..., UsernamePrefix => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::EKS::OidcIdentityProviderConfigRequest object:

  $result = $service_obj->Method(...);
  $result->Att1->ClientId

=head1 DESCRIPTION

An object representing an OpenID Connect (OIDC) configuration. Before
associating an OIDC identity provider to your cluster, review the
considerations in Authenticating users for your cluster from an OpenID
Connect identity provider
(https://docs.aws.amazon.com/eks/latest/userguide/authenticate-oidc-identity-provider.html)
in the I<Amazon EKS User Guide>.

=head1 ATTRIBUTES


=head2 B<REQUIRED> ClientId => Str

This is also known as I<audience>. The ID for the client application
that makes authentication requests to the OpenID identity provider.


=head2 GroupsClaim => Str

The JWT claim that the provider uses to return your groups.


=head2 GroupsPrefix => Str

The prefix that is prepended to group claims to prevent clashes with
existing names (such as C<system:> groups). For example, the valueC<
oidc:> will create group names like C<oidc:engineering> and
C<oidc:infra>.


=head2 B<REQUIRED> IdentityProviderConfigName => Str

The name of the OIDC provider configuration.


=head2 B<REQUIRED> IssuerUrl => Str

The URL of the OpenID identity provider that allows the API server to
discover public signing keys for verifying tokens. The URL must begin
with C<https://> and should correspond to the C<iss> claim in the
provider's OIDC ID tokens. Per the OIDC standard, path components are
allowed but query parameters are not. Typically the URL consists of
only a hostname, like C<https://server.example.org> or
C<https://example.com>. This URL should point to the level below
C<.well-known/openid-configuration> and must be publicly accessible
over the internet.


=head2 RequiredClaims => L<Paws::EKS::RequiredClaimsMap>

The key value pairs that describe required claims in the identity
token. If set, each claim is verified to be present in the token with a
matching value. For the maximum number of claims that you can require,
see Amazon EKS service quotas
(https://docs.aws.amazon.com/eks/latest/userguide/service-quotas.html)
in the I<Amazon EKS User Guide>.


=head2 UsernameClaim => Str

The JSON Web Token (JWT) claim to use as the username. The default is
C<sub>, which is expected to be a unique identifier of the end user.
You can choose other claims, such as C<email> or C<name>, depending on
the OpenID identity provider. Claims other than C<email> are prefixed
with the issuer URL to prevent naming clashes with other plug-ins.


=head2 UsernamePrefix => Str

The prefix that is prepended to username claims to prevent clashes with
existing names. If you do not provide this field, and C<username> is a
value other than C<email>, the prefix defaults to C<issuerurl#>. You
can use the value C<-> to disable all prefixing.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::EKS>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

