# Generated by default/object.tt
package Paws::SSMIncidents::IncidentRecordSummary;
  use Moose;
  has Arn => (is => 'ro', isa => 'Str', request_name => 'arn', traits => ['NameInRequest'], required => 1);
  has CreationTime => (is => 'ro', isa => 'Str', request_name => 'creationTime', traits => ['NameInRequest'], required => 1);
  has Impact => (is => 'ro', isa => 'Int', request_name => 'impact', traits => ['NameInRequest'], required => 1);
  has IncidentRecordSource => (is => 'ro', isa => 'Paws::SSMIncidents::IncidentRecordSource', request_name => 'incidentRecordSource', traits => ['NameInRequest'], required => 1);
  has ResolvedTime => (is => 'ro', isa => 'Str', request_name => 'resolvedTime', traits => ['NameInRequest']);
  has Status => (is => 'ro', isa => 'Str', request_name => 'status', traits => ['NameInRequest'], required => 1);
  has Title => (is => 'ro', isa => 'Str', request_name => 'title', traits => ['NameInRequest'], required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::SSMIncidents::IncidentRecordSummary

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::SSMIncidents::IncidentRecordSummary object:

  $service_obj->Method(Att1 => { Arn => $value, ..., Title => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::SSMIncidents::IncidentRecordSummary object:

  $result = $service_obj->Method(...);
  $result->Att1->Arn

=head1 DESCRIPTION

Details describing an incident record.

=head1 ATTRIBUTES


=head2 B<REQUIRED> Arn => Str

The Amazon Resource Name (ARN) of the incident.


=head2 B<REQUIRED> CreationTime => Str

The time the incident was created.


=head2 B<REQUIRED> Impact => Int

Defines the impact to customers and applications.


=head2 B<REQUIRED> IncidentRecordSource => L<Paws::SSMIncidents::IncidentRecordSource>

What caused Incident Manager to create the incident.


=head2 ResolvedTime => Str

The time the incident was resolved.


=head2 B<REQUIRED> Status => Str

The current status of the incident.


=head2 B<REQUIRED> Title => Str

The title of the incident. This value is either provided by the
response plan or overwritten on creation.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::SSMIncidents>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

