package OpenInteract::Handler::PageDirectory;

# $Id: PageDirectory.pm,v 1.3 2003/11/15 02:02:33 lachoy Exp $

use strict;
use OpenInteract::CommonHandler qw( OK ERROR );
use OpenInteract::Handler::GenericDispatcher qw( DEFAULT_SECURITY_KEY );
use SPOPS::Secure qw( :level );

@OpenInteract::Handler::PageDirectory::ISA     = qw( OpenInteract::CommonHandler  SPOPS::Secure );
$OpenInteract::Handler::PageDirectory::VERSION = sprintf("%d.%02d", q$Revision: 1.3 $ =~ /(\d+)\.(\d+)/);
$OpenInteract::Handler::PageDirectory::author            = 'chris@cwinters.com';
$OpenInteract::Handler::PageDirectory::default_method    = 'search';
@OpenInteract::Handler::PageDirectory::forbidden_methods = ();
%OpenInteract::Handler::PageDirectory::security          = (
   DEFAULT_SECURITY_KEY() => SEC_LEVEL_WRITE,
);


sub MY_PACKAGE                 { return 'base_page' }
sub MY_HANDLER_PATH            { return '/PageDirectory' }
sub MY_OBJECT_TYPE             { return 'page_directory' }
sub MY_OBJECT_CLASS            { return OpenInteract::Request->instance->page_directory }

sub MY_ALLOW_SEARCH_FORM       { return undef }

sub MY_SEARCH_FIELDS           { return () }
sub MY_SEARCH_RESULTS_TITLE    { return 'Directory Handlers Available' }
sub MY_SEARCH_RESULTS_TEMPLATE { return 'page_directory_handler_list' }
sub MY_ALLOW_SEARCH            { return 1 }

sub MY_ALLOW_CREATE            { return 1 }
sub MY_OBJECT_CREATE_SECURITY  { return SEC_LEVEL_WRITE }
sub MY_ALLOW_SHOW              { return 1 }
sub MY_OBJECT_FORM_TEMPLATE    { return 'page_directory_form' }
sub MY_OBJECT_FORM_TITLE       { return 'Modify a Directory Handler' }

sub MY_EDIT_RETURN_URL         { return '/PageDirectory/' }
sub MY_EDIT_FAIL_TASK          { return 'search' }
sub MY_EDIT_DISPLAY_TASK       { return 'show' }
sub MY_EDIT_FIELDS             { return qw( directory action ) }
sub MY_EDIT_FIELDS_TOGGLED     { return qw( subdirs_inherit ) }
sub MY_ALLOW_EDIT              { return 1 }

sub MY_REMOVE_FAIL_TASK        { return 'show' }
sub MY_REMOVE_DISPLAY_TASK     { return 'search' }
sub MY_ALLOW_REMOVE            { return 1 }

sub MY_ALLOW_NOTIFY            { return undef }
sub MY_ALLOW_WIZARD            { return undef }

# Just grab all the actions available

sub _show_customize {
    my ( $class, $params ) = @_;
    my $R = OpenInteract::Request->instance;
    $params->{action_list} = $R->page_directory->list_directory_actions;
}


sub _edit_customize {
    my ( $class, $dir, $old_data ) = @_;

    # We only want to work with updates...

    return ( OK, {} ) unless ( $dir->is_saved );

    my $R = OpenInteract::Request->instance;
    my %opts = ();

    # If the user changed the directory, then we need to set the ID so
    # the UPDATE works properly.

    if ( $old_data->{directory} and $dir->{directory} ne $old_data->{directory} ) {
        $R->DEBUG && $R->scrib( 1, "User changed directory from ($old_data->{directory})",
                                   "to ($dir->{directory})" );
        $opts{use_id} = $old_data->{directory};
    }

    return ( OK, \%opts );
}

1;


