/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.compiler.LocalField;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.services.loader.ClassFactory;
import org.apache.derby.iapi.sql.compile.TypeCompiler;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.TypeId;
import org.apache.derby.impl.sql.compile.TypeCompilerFactoryImpl;

abstract class BaseTypeCompiler
implements TypeCompiler {
    private TypeId correspondingTypeId;

    BaseTypeCompiler() {
    }

    public String getPrimitiveMethodName() {
        return null;
    }

    public String getMatchingNationalCharTypeName() {
        return "NATIONAL CHAR";
    }

    public DataTypeDescriptor resolveArithmeticOperation(DataTypeDescriptor dataTypeDescriptor, DataTypeDescriptor dataTypeDescriptor2, String string) throws StandardException {
        throw StandardException.newException("42Y95", string, (Object)dataTypeDescriptor.getTypeId().getSQLTypeName(), (Object)dataTypeDescriptor2.getTypeId().getSQLTypeName());
    }

    public void generateNull(MethodBuilder methodBuilder) {
        methodBuilder.callMethod((short)185, null, this.nullMethodName(), this.interfaceName(), 1);
    }

    public void generateDataValue(MethodBuilder methodBuilder, LocalField localField) {
        String string = this.interfaceName();
        if (localField == null) {
            methodBuilder.pushNull(string);
        } else {
            methodBuilder.getField(localField);
        }
        methodBuilder.callMethod((short)185, null, this.dataValueMethodName(), string, 2);
        if (localField != null) {
            methodBuilder.putField(localField);
        }
    }

    protected abstract String nullMethodName();

    protected String dataValueMethodName() {
        return "getDataValue";
    }

    protected boolean userTypeStorable(TypeId typeId, TypeId typeId2, ClassFactory classFactory) {
        if (!typeId2.builtIn()) {
            return classFactory.getClassInspector().assignableTo(typeId.getCorrespondingJavaTypeName(), typeId2.getCorrespondingJavaTypeName());
        }
        return false;
    }

    public boolean numberComparable(TypeId typeId, boolean bl, ClassFactory classFactory) {
        TypeCompiler typeCompiler = this.getTypeCompiler(typeId);
        return typeId.isNumericTypeId() || typeId.isBooleanTypeId() || typeId.userType() && typeCompiler.comparable(typeId, bl, classFactory);
    }

    public boolean numberConvertible(TypeId typeId, boolean bl) {
        boolean bl2;
        if (typeId.isLongConcatableTypeId()) {
            return false;
        }
        boolean bl3 = bl2 = typeId.isNumericTypeId() || typeId.isBooleanTypeId() || typeId.userType();
        if (bl) {
            bl2 = bl2 || typeId.isFixedStringTypeId() && this.getTypeId().isFloatingPointTypeId();
        }
        bl2 = bl2 || typeId.isFixedStringTypeId() && !this.getTypeId().isFloatingPointTypeId();
        return bl2;
    }

    public boolean numberStorable(TypeId typeId, TypeId typeId2, ClassFactory classFactory) {
        if (typeId2.isNumericTypeId() || typeId2.isBooleanTypeId()) {
            return true;
        }
        return this.userTypeStorable(typeId, typeId2, classFactory);
    }

    protected TypeId getTypeId() {
        return this.correspondingTypeId;
    }

    protected TypeCompiler getTypeCompiler(TypeId typeId) {
        return TypeCompilerFactoryImpl.staticGetTypeCompiler(typeId);
    }

    void setTypeId(TypeId typeId) {
        this.correspondingTypeId = typeId;
    }

    protected int getStoredFormatIdFromTypeId() {
        return this.getTypeId().getTypeFormatId();
    }
}

