# Generated by default/object.tt
package Paws::LocationService::GeofenceGeometry;
  use Moose;
  has Polygon => (is => 'ro', isa => 'ArrayRef[ArrayRef[ArrayRef[Num]]]');

1;

### main pod documentation begin ###

=head1 NAME

Paws::LocationService::GeofenceGeometry

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::LocationService::GeofenceGeometry object:

  $service_obj->Method(Att1 => { Polygon => $value, ..., Polygon => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::LocationService::GeofenceGeometry object:

  $result = $service_obj->Method(...);
  $result->Att1->Polygon

=head1 DESCRIPTION

Contains the geofence geometry details.

Amazon Location doesn't currently support polygons with holes,
multipolygons, polygons that are wound clockwise, or that cross the
antimeridian.

=head1 ATTRIBUTES


=head2 Polygon => ArrayRef[ArrayRef[ArrayRef[Num]]]

An array of 1 or more linear rings. A linear ring is an array of 4 or
more vertices, where the first and last vertex are the same to form a
closed boundary. Each vertex is a 2-dimensional point of the form:
C<[longitude, latitude]>.

The first linear ring is an outer ring, describing the polygon's
boundary. Subsequent linear rings may be inner or outer rings to
describe holes and islands. Outer rings must list their vertices in
counter-clockwise order around the ring's center, where the left side
is the polygon's exterior. Inner rings must list their vertices in
clockwise order, where the left side is the polygon's interior.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::LocationService>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

