# Generated by default/object.tt
package Paws::Firehose::HttpEndpointCommonAttribute;
  use Moose;
  has AttributeName => (is => 'ro', isa => 'Str', required => 1);
  has AttributeValue => (is => 'ro', isa => 'Str', required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::Firehose::HttpEndpointCommonAttribute

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Firehose::HttpEndpointCommonAttribute object:

  $service_obj->Method(Att1 => { AttributeName => $value, ..., AttributeValue => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Firehose::HttpEndpointCommonAttribute object:

  $result = $service_obj->Method(...);
  $result->Att1->AttributeName

=head1 DESCRIPTION

Describes the metadata that's delivered to the specified HTTP endpoint
destination.

=head1 ATTRIBUTES


=head2 B<REQUIRED> AttributeName => Str

The name of the HTTP endpoint common attribute.


=head2 B<REQUIRED> AttributeValue => Str

The value of the HTTP endpoint common attribute.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Firehose>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

