package SVG::Rasterize::Specification;
use strict;
use warnings;

use Exporter 'import';

use SVG::Rasterize::Regexes qw(:numbers :lengths);

# $Id: Specification.pm 5550 2010-05-12 08:49:52Z mullet $

=head1 NAME

C<SVG::Rasterize::Specification> - data structures derived from DTD

=head1 VERSION

Version 0.000009

=cut

our $VERSION = '0.000009';

our @EXPORT    = qw(%CHILDREN %ATTR_VAL %ATTR_HINTS);
our @EXPORT_OK = qw(%DATATYPES_REGEX);

our %DATATYPE_REGEX =
    ('BaselineShiftValue.datatype'              => qr//,
     'ClassList.datatype'                       => qr//,
     'ClipPathValue.datatype'                   => qr//,
     'ClipValue.datatype'                       => qr//,
     'Color.datatype'                           => qr//,
     'ContentType.datatype'                     => qr//,
     'Coordinate.datatype'                      => $p_A_LENGTH,
     'Coordinates.datatype'                     => qr//,
     'CursorValue.datatype'                     => qr//,
     'EnableBackgroundValue.datatype'           => qr//,
     'ExtensionList.datatype'                   => qr//,
     'FeatureList.datatype'                     => qr//,
     'FilterValue.datatype'                     => qr//,
     'FontFamilyValue.datatype'                 => qr//,
     'FontSizeAdjustValue.datatype'             => qr//,
     'FontSizeValue.datatype'                   => qr//,
     'GlyphOrientationHorizontalValue.datatype' => qr//,
     'GlyphOrientationVerticalValue.datatype'   => qr//,
     'Integer.datatype'                         => qr//,
     'KerningValue.datatype'                    => qr//,
     'LanguageCodes.datatype'                   => qr//,
     'Length.datatype'                          => $p_A_LENGTH,
     'Lengths.datatype'                         => qr//,
     'MarkerValue.datatype'                     => qr//,
     'MaskValue.datatype'                       => qr//,
     'MediaDesc.datatype'                       => qr//,
     'Number.datatype'                          => $p_A_NUMBER,
     'NumberOptionalNumber.datatype'            => qr//,
     'NumberOrPercentage.datatype'              => qr//,
     'Numbers.datatype'                         => qr//,
     'OpacityValue.datatype'                    => qr//,
     'Paint.datatype'                           => qr//,
     'PathData.datatype'                        => qr//,
     'Points.datatype'                          => qr//,
     'PreserveAspectRatioSpec.datatype'         => qr//,
     'SVGColor.datatype'                        => qr//,
     'Script.datatype'                          => qr//,
     'SpacingValue.datatype'                    => qr//,
     'StrokeDashArrayValue.datatype'            => qr//,
     'StrokeDashOffsetValue.datatype'           => qr//,
     'StrokeMiterLimitValue.datatype'           => qr//,
     'StrokeWidthValue.datatype'                => $p_A_LENGTH,
     'StyleSheet.datatype'                      => qr//,
     'Text.datatype'                            => qr//,
     'TextDecorationValue.datatype'             => qr//,
     'TransformList.datatype'                   => qr//,
     'URI.datatype'                             => qr//,
     'ViewBoxSpec.datatype'                     => qr//);

our %CHILDREN =
    ('a'                   => {'a'                   => 1,
                               'altGlyphDef'         => 1,
                               'animate'             => 1,
                               'animateColor'        => 1,
                               'animateMotion'       => 1,
                               'animateTransform'    => 1,
                               'circle'              => 1,
                               'clipPath'            => 1,
                               'color-profile'       => 1,
                               'cursor'              => 1,
                               'defs'                => 1,
                               'desc'                => 1,
                               'ellipse'             => 1,
                               'filter'              => 1,
                               'font'                => 1,
                               'font-face'           => 1,
                               'g'                   => 1,
                               'image'               => 1,
                               'line'                => 1,
                               'linearGradient'      => 1,
                               'marker'              => 1,
                               'mask'                => 1,
                               'metadata'            => 1,
                               'path'                => 1,
                               'pattern'             => 1,
                               'polygon'             => 1,
                               'polyline'            => 1,
                               'radialGradient'      => 1,
                               'rect'                => 1,
                               'script'              => 1,
                               'set'                 => 1,
                               'style'               => 1,
                               'svg'                 => 1,
                               'switch'              => 1,
                               'symbol'              => 1,
                               'text'                => 1,
                               'title'               => 1,
                               'use'                 => 1,
                               'view'                => 1},
     'altGlyph'            => {},
     'altGlyphDef'         => {'altGlyphItem'        => 1,
                               'glyphRef'            => 1},
     'altGlyphItem'        => {'glyphRef'            => 1},
     'animate'             => {'desc'                => 1,
                               'metadata'            => 1,
                               'title'               => 1},
     'animateColor'        => {'desc'                => 1,
                               'metadata'            => 1,
                               'title'               => 1},
     'animateMotion'       => {'desc'                => 1,
                               'metadata'            => 1,
                               'mpath'               => 1,
                               'title'               => 1},
     'animateTransform'    => {'desc'                => 1,
                               'metadata'            => 1,
                               'title'               => 1},
     'circle'              => {'animate'             => 1,
                               'animateColor'        => 1,
                               'animateMotion'       => 1,
                               'animateTransform'    => 1,
                               'desc'                => 1,
                               'metadata'            => 1,
                               'set'                 => 1,
                               'title'               => 1},
     'clipPath'            => {'altGlyphDef'         => 1,
                               'animate'             => 1,
                               'animateColor'        => 1,
                               'animateMotion'       => 1,
                               'animateTransform'    => 1,
                               'circle'              => 1,
                               'desc'                => 1,
                               'ellipse'             => 1,
                               'line'                => 1,
                               'metadata'            => 1,
                               'path'                => 1,
                               'polygon'             => 1,
                               'polyline'            => 1,
                               'rect'                => 1,
                               'set'                 => 1,
                               'text'                => 1,
                               'title'               => 1,
                               'use'                 => 1},
     'color-profile'       => {'desc'                => 1,
                               'metadata'            => 1,
                               'title'               => 1},
     'cursor'              => {'desc'                => 1,
                               'metadata'            => 1,
                               'title'               => 1},
     'definition-src'      => {},
     'defs'                => {'a'                   => 1,
                               'altGlyphDef'         => 1,
                               'animate'             => 1,
                               'animateColor'        => 1,
                               'animateMotion'       => 1,
                               'animateTransform'    => 1,
                               'circle'              => 1,
                               'clipPath'            => 1,
                               'color-profile'       => 1,
                               'cursor'              => 1,
                               'defs'                => 1,
                               'desc'                => 1,
                               'ellipse'             => 1,
                               'filter'              => 1,
                               'font'                => 1,
                               'font-face'           => 1,
                               'g'                   => 1,
                               'image'               => 1,
                               'line'                => 1,
                               'linearGradient'      => 1,
                               'marker'              => 1,
                               'mask'                => 1,
                               'metadata'            => 1,
                               'path'                => 1,
                               'pattern'             => 1,
                               'polygon'             => 1,
                               'polyline'            => 1,
                               'radialGradient'      => 1,
                               'rect'                => 1,
                               'script'              => 1,
                               'set'                 => 1,
                               'style'               => 1,
                               'svg'                 => 1,
                               'switch'              => 1,
                               'symbol'              => 1,
                               'text'                => 1,
                               'title'               => 1,
                               'use'                 => 1,
                               'view'                => 1},
     'desc'                => {},
     'ellipse'             => {'animate'             => 1,
                               'animateColor'        => 1,
                               'animateMotion'       => 1,
                               'animateTransform'    => 1,
                               'desc'                => 1,
                               'metadata'            => 1,
                               'set'                 => 1,
                               'title'               => 1},
     'feBlend'             => {'animate'             => 1,
                               'set'                 => 1},
     'feColorMatrix'       => {'animate'             => 1,
                               'set'                 => 1},
     'feComponentTransfer' => {'feFuncA'             => 1,
                               'feFuncB'             => 1,
                               'feFuncG'             => 1,
                               'feFuncR'             => 1},
     'feComposite'         => {'animate'             => 1,
                               'set'                 => 1},
     'feConvolveMatrix'    => {'animate'             => 1,
                               'set'                 => 1},
     'feDiffuseLighting'   => {'animate'             => 1,
                               'animateColor'        => 1,
                               'feDistantLight'      => 1,
                               'fePointLight'        => 1,
                               'feSpotLight'         => 1,
                               'set'                 => 1},
     'feDisplacementMap'   => {'animate'             => 1,
                               'set'                 => 1},
     'feDistantLight'      => {'animate'             => 1,
                               'set'                 => 1},
     'feFlood'             => {'animate'             => 1,
                               'animateColor'        => 1,
                               'set'                 => 1},
     'feFuncA'             => {'animate'             => 1,
                               'set'                 => 1},
     'feFuncB'             => {'animate'             => 1,
                               'set'                 => 1},
     'feFuncG'             => {'animate'             => 1,
                               'set'                 => 1},
     'feFuncR'             => {'animate'             => 1,
                               'set'                 => 1},
     'feGaussianBlur'      => {'animate'             => 1,
                               'set'                 => 1},
     'feImage'             => {'animate'             => 1,
                               'animateTransform'    => 1,
                               'set'                 => 1},
     'feMerge'             => {'feMergeNode'         => 1},
     'feMergeNode'         => {'animate'             => 1,
                               'set'                 => 1},
     'feMorphology'        => {'animate'             => 1,
                               'set'                 => 1},
     'feOffset'            => {'animate'             => 1,
                               'set'                 => 1},
     'fePointLight'        => {'animate'             => 1,
                               'set'                 => 1},
     'feSpecularLighting'  => {'animate'             => 1,
                               'animateColor'        => 1,
                               'feDistantLight'      => 1,
                               'fePointLight'        => 1,
                               'feSpotLight'         => 1,
                               'set'                 => 1},
     'feSpotLight'         => {'animate'             => 1,
                               'set'                 => 1},
     'feTile'              => {'animate'             => 1,
                               'set'                 => 1},
     'feTurbulence'        => {'animate'             => 1,
                               'set'                 => 1},
     'filter'              => {'animate'             => 1,
                               'desc'                => 1,
                               'feBlend'             => 1,
                               'feColorMatrix'       => 1,
                               'feComponentTransfer' => 1,
                               'feComposite'         => 1,
                               'feConvolveMatrix'    => 1,
                               'feDiffuseLighting'   => 1,
                               'feDisplacementMap'   => 1,
                               'feFlood'             => 1,
                               'feGaussianBlur'      => 1,
                               'feImage'             => 1,
                               'feMerge'             => 1,
                               'feMorphology'        => 1,
                               'feOffset'            => 1,
                               'feSpecularLighting'  => 1,
                               'feTile'              => 1,
                               'feTurbulence'        => 1,
                               'metadata'            => 1,
                               'set'                 => 1,
                               'title'               => 1},
     'font'                => {'desc'                => 1,
                               'font-face'           => 1,
                               'glyph'               => 1,
                               'hkern'               => 1,
                               'metadata'            => 1,
                               'missing-glyph'       => 1,
                               'title'               => 1,
                               'vkern'               => 1},
     'font-face'           => {'definition-src'      => 1,
                               'desc'                => 1,
                               'font-face-src'       => 1,
                               'metadata'            => 1,
                               'title'               => 1},
     'font-face-format'    => {},
     'font-face-name'      => {},
     'font-face-src'       => {'font-face-name'      => 1,
                               'font-face-uri'       => 1},
     'font-face-uri'       => {'font-face-format'    => 1},
     'foreignObject'       => {},
     'g'                   => {'a'                   => 1,
                               'altGlyphDef'         => 1,
                               'animate'             => 1,
                               'animateColor'        => 1,
                               'animateMotion'       => 1,
                               'animateTransform'    => 1,
                               'circle'              => 1,
                               'clipPath'            => 1,
                               'color-profile'       => 1,
                               'cursor'              => 1,
                               'defs'                => 1,
                               'desc'                => 1,
                               'ellipse'             => 1,
                               'filter'              => 1,
                               'font'                => 1,
                               'font-face'           => 1,
                               'g'                   => 1,
                               'image'               => 1,
                               'line'                => 1,
                               'linearGradient'      => 1,
                               'marker'              => 1,
                               'mask'                => 1,
                               'metadata'            => 1,
                               'path'                => 1,
                               'pattern'             => 1,
                               'polygon'             => 1,
                               'polyline'            => 1,
                               'radialGradient'      => 1,
                               'rect'                => 1,
                               'script'              => 1,
                               'set'                 => 1,
                               'style'               => 1,
                               'svg'                 => 1,
                               'switch'              => 1,
                               'symbol'              => 1,
                               'text'                => 1,
                               'title'               => 1,
                               'use'                 => 1,
                               'view'                => 1},
     'glyph'               => {'a'                   => 1,
                               'altGlyphDef'         => 1,
                               'animate'             => 1,
                               'animateColor'        => 1,
                               'animateMotion'       => 1,
                               'animateTransform'    => 1,
                               'circle'              => 1,
                               'clipPath'            => 1,
                               'color-profile'       => 1,
                               'cursor'              => 1,
                               'defs'                => 1,
                               'desc'                => 1,
                               'ellipse'             => 1,
                               'filter'              => 1,
                               'font'                => 1,
                               'font-face'           => 1,
                               'g'                   => 1,
                               'image'               => 1,
                               'line'                => 1,
                               'linearGradient'      => 1,
                               'marker'              => 1,
                               'mask'                => 1,
                               'metadata'            => 1,
                               'path'                => 1,
                               'pattern'             => 1,
                               'polygon'             => 1,
                               'polyline'            => 1,
                               'radialGradient'      => 1,
                               'rect'                => 1,
                               'script'              => 1,
                               'set'                 => 1,
                               'style'               => 1,
                               'svg'                 => 1,
                               'switch'              => 1,
                               'symbol'              => 1,
                               'text'                => 1,
                               'title'               => 1,
                               'use'                 => 1,
                               'view'                => 1},
     'glyphRef'            => {},
     'hkern'               => {},
     'image'               => {'animate'             => 1,
                               'animateColor'        => 1,
                               'animateMotion'       => 1,
                               'animateTransform'    => 1,
                               'desc'                => 1,
                               'metadata'            => 1,
                               'set'                 => 1,
                               'title'               => 1},
     'line'                => {'animate'             => 1,
                               'animateColor'        => 1,
                               'animateMotion'       => 1,
                               'animateTransform'    => 1,
                               'desc'                => 1,
                               'metadata'            => 1,
                               'set'                 => 1,
                               'title'               => 1},
     'linearGradient'      => {'animate'             => 1,
                               'animateTransform'    => 1,
                               'desc'                => 1,
                               'metadata'            => 1,
                               'set'                 => 1,
                               'stop'                => 1,
                               'title'               => 1},
     'marker'              => {'a'                   => 1,
                               'altGlyphDef'         => 1,
                               'animate'             => 1,
                               'animateColor'        => 1,
                               'animateMotion'       => 1,
                               'animateTransform'    => 1,
                               'circle'              => 1,
                               'clipPath'            => 1,
                               'color-profile'       => 1,
                               'cursor'              => 1,
                               'defs'                => 1,
                               'desc'                => 1,
                               'ellipse'             => 1,
                               'filter'              => 1,
                               'font'                => 1,
                               'font-face'           => 1,
                               'g'                   => 1,
                               'image'               => 1,
                               'line'                => 1,
                               'linearGradient'      => 1,
                               'marker'              => 1,
                               'mask'                => 1,
                               'metadata'            => 1,
                               'path'                => 1,
                               'pattern'             => 1,
                               'polygon'             => 1,
                               'polyline'            => 1,
                               'radialGradient'      => 1,
                               'rect'                => 1,
                               'script'              => 1,
                               'set'                 => 1,
                               'style'               => 1,
                               'svg'                 => 1,
                               'switch'              => 1,
                               'symbol'              => 1,
                               'text'                => 1,
                               'title'               => 1,
                               'use'                 => 1,
                               'view'                => 1},
     'mask'                => {'a'                   => 1,
                               'altGlyphDef'         => 1,
                               'animate'             => 1,
                               'animateColor'        => 1,
                               'animateMotion'       => 1,
                               'animateTransform'    => 1,
                               'circle'              => 1,
                               'clipPath'            => 1,
                               'color-profile'       => 1,
                               'cursor'              => 1,
                               'defs'                => 1,
                               'desc'                => 1,
                               'ellipse'             => 1,
                               'filter'              => 1,
                               'font'                => 1,
                               'font-face'           => 1,
                               'g'                   => 1,
                               'image'               => 1,
                               'line'                => 1,
                               'linearGradient'      => 1,
                               'marker'              => 1,
                               'mask'                => 1,
                               'metadata'            => 1,
                               'path'                => 1,
                               'pattern'             => 1,
                               'polygon'             => 1,
                               'polyline'            => 1,
                               'radialGradient'      => 1,
                               'rect'                => 1,
                               'script'              => 1,
                               'set'                 => 1,
                               'style'               => 1,
                               'svg'                 => 1,
                               'switch'              => 1,
                               'symbol'              => 1,
                               'text'                => 1,
                               'title'               => 1,
                               'use'                 => 1,
                               'view'                => 1},
     'metadata'            => {},
     'missing-glyph'       => {'a'                   => 1,
                               'altGlyphDef'         => 1,
                               'animate'             => 1,
                               'animateColor'        => 1,
                               'animateMotion'       => 1,
                               'animateTransform'    => 1,
                               'circle'              => 1,
                               'clipPath'            => 1,
                               'color-profile'       => 1,
                               'cursor'              => 1,
                               'defs'                => 1,
                               'desc'                => 1,
                               'ellipse'             => 1,
                               'filter'              => 1,
                               'font'                => 1,
                               'font-face'           => 1,
                               'g'                   => 1,
                               'image'               => 1,
                               'line'                => 1,
                               'linearGradient'      => 1,
                               'marker'              => 1,
                               'mask'                => 1,
                               'metadata'            => 1,
                               'path'                => 1,
                               'pattern'             => 1,
                               'polygon'             => 1,
                               'polyline'            => 1,
                               'radialGradient'      => 1,
                               'rect'                => 1,
                               'script'              => 1,
                               'set'                 => 1,
                               'style'               => 1,
                               'svg'                 => 1,
                               'switch'              => 1,
                               'symbol'              => 1,
                               'text'                => 1,
                               'title'               => 1,
                               'use'                 => 1,
                               'view'                => 1},
     'mpath'               => {'desc'                => 1,
                               'metadata'            => 1,
                               'title'               => 1},
     'path'                => {'animate'             => 1,
                               'animateColor'        => 1,
                               'animateMotion'       => 1,
                               'animateTransform'    => 1,
                               'desc'                => 1,
                               'metadata'            => 1,
                               'set'                 => 1,
                               'title'               => 1},
     'pattern'             => {'a'                   => 1,
                               'altGlyphDef'         => 1,
                               'animate'             => 1,
                               'animateColor'        => 1,
                               'animateMotion'       => 1,
                               'animateTransform'    => 1,
                               'circle'              => 1,
                               'clipPath'            => 1,
                               'color-profile'       => 1,
                               'cursor'              => 1,
                               'defs'                => 1,
                               'desc'                => 1,
                               'ellipse'             => 1,
                               'filter'              => 1,
                               'font'                => 1,
                               'font-face'           => 1,
                               'g'                   => 1,
                               'image'               => 1,
                               'line'                => 1,
                               'linearGradient'      => 1,
                               'marker'              => 1,
                               'mask'                => 1,
                               'metadata'            => 1,
                               'path'                => 1,
                               'pattern'             => 1,
                               'polygon'             => 1,
                               'polyline'            => 1,
                               'radialGradient'      => 1,
                               'rect'                => 1,
                               'script'              => 1,
                               'set'                 => 1,
                               'style'               => 1,
                               'svg'                 => 1,
                               'switch'              => 1,
                               'symbol'              => 1,
                               'text'                => 1,
                               'title'               => 1,
                               'use'                 => 1,
                               'view'                => 1},
     'polygon'             => {'animate'             => 1,
                               'animateColor'        => 1,
                               'animateMotion'       => 1,
                               'animateTransform'    => 1,
                               'desc'                => 1,
                               'metadata'            => 1,
                               'set'                 => 1,
                               'title'               => 1},
     'polyline'            => {'animate'             => 1,
                               'animateColor'        => 1,
                               'animateMotion'       => 1,
                               'animateTransform'    => 1,
                               'desc'                => 1,
                               'metadata'            => 1,
                               'set'                 => 1,
                               'title'               => 1},
     'radialGradient'      => {'animate'             => 1,
                               'animateTransform'    => 1,
                               'desc'                => 1,
                               'metadata'            => 1,
                               'set'                 => 1,
                               'stop'                => 1,
                               'title'               => 1},
     'rect'                => {'animate'             => 1,
                               'animateColor'        => 1,
                               'animateMotion'       => 1,
                               'animateTransform'    => 1,
                               'desc'                => 1,
                               'metadata'            => 1,
                               'set'                 => 1,
                               'title'               => 1},
     'script'              => {},
     'set'                 => {'desc'                => 1,
                               'metadata'            => 1,
                               'title'               => 1},
     'stop'                => {'animate'             => 1,
                               'animateColor'        => 1,
                               'set'                 => 1},
     'style'               => {},
     'svg'                 => {'a'                   => 1,
                               'altGlyphDef'         => 1,
                               'animate'             => 1,
                               'animateColor'        => 1,
                               'animateMotion'       => 1,
                               'animateTransform'    => 1,
                               'circle'              => 1,
                               'clipPath'            => 1,
                               'color-profile'       => 1,
                               'cursor'              => 1,
                               'defs'                => 1,
                               'desc'                => 1,
                               'ellipse'             => 1,
                               'filter'              => 1,
                               'font'                => 1,
                               'font-face'           => 1,
                               'g'                   => 1,
                               'image'               => 1,
                               'line'                => 1,
                               'linearGradient'      => 1,
                               'marker'              => 1,
                               'mask'                => 1,
                               'metadata'            => 1,
                               'path'                => 1,
                               'pattern'             => 1,
                               'polygon'             => 1,
                               'polyline'            => 1,
                               'radialGradient'      => 1,
                               'rect'                => 1,
                               'script'              => 1,
                               'set'                 => 1,
                               'style'               => 1,
                               'svg'                 => 1,
                               'switch'              => 1,
                               'symbol'              => 1,
                               'text'                => 1,
                               'title'               => 1,
                               'use'                 => 1,
                               'view'                => 1},
     'switch'              => {'a'                   => 1,
                               'animate'             => 1,
                               'animateColor'        => 1,
                               'animateMotion'       => 1,
                               'animateTransform'    => 1,
                               'circle'              => 1,
                               'desc'                => 1,
                               'ellipse'             => 1,
                               'foreignObject'       => 1,
                               'g'                   => 1,
                               'image'               => 1,
                               'line'                => 1,
                               'metadata'            => 1,
                               'path'                => 1,
                               'polygon'             => 1,
                               'polyline'            => 1,
                               'rect'                => 1,
                               'set'                 => 1,
                               'svg'                 => 1,
                               'switch'              => 1,
                               'text'                => 1,
                               'title'               => 1,
                               'use'                 => 1},
     'symbol'              => {'a'                   => 1,
                               'altGlyphDef'         => 1,
                               'animate'             => 1,
                               'animateColor'        => 1,
                               'animateMotion'       => 1,
                               'animateTransform'    => 1,
                               'circle'              => 1,
                               'clipPath'            => 1,
                               'color-profile'       => 1,
                               'cursor'              => 1,
                               'defs'                => 1,
                               'desc'                => 1,
                               'ellipse'             => 1,
                               'filter'              => 1,
                               'font'                => 1,
                               'font-face'           => 1,
                               'g'                   => 1,
                               'image'               => 1,
                               'line'                => 1,
                               'linearGradient'      => 1,
                               'marker'              => 1,
                               'mask'                => 1,
                               'metadata'            => 1,
                               'path'                => 1,
                               'pattern'             => 1,
                               'polygon'             => 1,
                               'polyline'            => 1,
                               'radialGradient'      => 1,
                               'rect'                => 1,
                               'script'              => 1,
                               'set'                 => 1,
                               'style'               => 1,
                               'svg'                 => 1,
                               'switch'              => 1,
                               'symbol'              => 1,
                               'text'                => 1,
                               'title'               => 1,
                               'use'                 => 1,
                               'view'                => 1},
     'text'                => {'a'                   => 1,
                               'altGlyph'            => 1,
                               'animate'             => 1,
                               'animateColor'        => 1,
                               'animateMotion'       => 1,
                               'animateTransform'    => 1,
                               'desc'                => 1,
                               'metadata'            => 1,
                               'set'                 => 1,
                               'textPath'            => 1,
                               'title'               => 1,
                               'tref'                => 1,
                               'tspan'               => 1},
     'textPath'            => {'a'                   => 1,
                               'altGlyph'            => 1,
                               'animate'             => 1,
                               'animateColor'        => 1,
                               'desc'                => 1,
                               'metadata'            => 1,
                               'set'                 => 1,
                               'title'               => 1,
                               'tref'                => 1,
                               'tspan'               => 1},
     'title'               => {},
     'tref'                => {'animate'             => 1,
                               'animateColor'        => 1,
                               'desc'                => 1,
                               'metadata'            => 1,
                               'set'                 => 1,
                               'title'               => 1},
     'tspan'               => {'a'                   => 1,
                               'altGlyph'            => 1,
                               'animate'             => 1,
                               'animateColor'        => 1,
                               'desc'                => 1,
                               'metadata'            => 1,
                               'set'                 => 1,
                               'title'               => 1,
                               'tref'                => 1,
                               'tspan'               => 1},
     'use'                 => {'animate'             => 1,
                               'animateColor'        => 1,
                               'animateMotion'       => 1,
                               'animateTransform'    => 1,
                               'desc'                => 1,
                               'metadata'            => 1,
                               'set'                 => 1,
                               'title'               => 1},
     'view'                => {'desc'                => 1,
                               'metadata'            => 1,
                               'title'               => 1},
     'vkern'               => {});

our %ATTR_VAL =
    ('a'                   => {'alignment-baseline'           => {optional => 1},
                               'baseline-shift'               => {optional => 1},
                               'class'                        => {optional => 1},
                               'clip'                         => {optional => 1},
                               'clip-path'                    => {optional => 1},
                               'clip-rule'                    => {optional => 1},
                               'color'                        => {optional => 1},
                               'color-interpolation'          => {optional => 1},
                               'color-interpolation-filters'  => {optional => 1},
                               'color-profile'                => {optional => 1},
                               'color-rendering'              => {optional => 1},
                               'cursor'                       => {optional => 1},
                               'direction'                    => {optional => 1},
                               'display'                      => {optional => 1},
                               'dominant-baseline'            => {optional => 1},
                               'enable-background'            => {optional => 1},
                               'externalResourcesRequired'    => {optional => 1},
                               'fill'                         => {optional => 1},
                               'fill-opacity'                 => {optional => 1},
                               'fill-rule'                    => {optional => 1},
                               'filter'                       => {optional => 1},
                               'flood-color'                  => {optional => 1},
                               'flood-opacity'                => {optional => 1},
                               'font-family'                  => {optional => 1},
                               'font-size'                    => {optional => 1},
                               'font-size-adjust'             => {optional => 1},
                               'font-stretch'                 => {optional => 1},
                               'font-style'                   => {optional => 1},
                               'font-variant'                 => {optional => 1},
                               'font-weight'                  => {optional => 1},
                               'glyph-orientation-horizontal' => {optional => 1},
                               'glyph-orientation-vertical'   => {optional => 1},
                               'id'                           => {optional => 1},
                               'image-rendering'              => {optional => 1},
                               'kerning'                      => {optional => 1},
                               'letter-spacing'               => {optional => 1},
                               'lighting-color'               => {optional => 1},
                               'marker-end'                   => {optional => 1},
                               'marker-mid'                   => {optional => 1},
                               'marker-start'                 => {optional => 1},
                               'mask'                         => {optional => 1},
                               'onactivate'                   => {optional => 1},
                               'onclick'                      => {optional => 1},
                               'onfocusin'                    => {optional => 1},
                               'onfocusout'                   => {optional => 1},
                               'onload'                       => {optional => 1},
                               'onmousedown'                  => {optional => 1},
                               'onmousemove'                  => {optional => 1},
                               'onmouseout'                   => {optional => 1},
                               'onmouseover'                  => {optional => 1},
                               'onmouseup'                    => {optional => 1},
                               'opacity'                      => {optional => 1},
                               'overflow'                     => {optional => 1},
                               'pointer-events'               => {optional => 1},
                               'requiredExtensions'           => {optional => 1},
                               'requiredFeatures'             => {optional => 1},
                               'shape-rendering'              => {optional => 1},
                               'stop-color'                   => {optional => 1},
                               'stop-opacity'                 => {optional => 1},
                               'stroke'                       => {optional => 1},
                               'stroke-dasharray'             => {optional => 1},
                               'stroke-dashoffset'            => {optional => 1},
                               'stroke-linecap'               => {optional => 1},
                               'stroke-linejoin'              => {optional => 1},
                               'stroke-miterlimit'            => {optional => 1},
                               'stroke-opacity'               => {optional => 1},
                               'stroke-width'                 => {optional => 1},
                               'style'                        => {optional => 1},
                               'systemLanguage'               => {optional => 1},
                               'target'                       => {optional => 1},
                               'text-anchor'                  => {optional => 1},
                               'text-decoration'              => {optional => 1},
                               'text-rendering'               => {optional => 1},
                               'transform'                    => {optional => 1},
                               'unicode-bidi'                 => {optional => 1},
                               'visibility'                   => {optional => 1},
                               'word-spacing'                 => {optional => 1},
                               'writing-mode'                 => {optional => 1},
                               'xlink:actuate'                => {default  => 'onRequest'},
                               'xlink:arcrole'                => {optional => 1},
                               'xlink:href'                   => {optional => 0},
                               'xlink:role'                   => {optional => 1},
                               'xlink:show'                   => {default  => 'replace'},
                               'xlink:title'                  => {optional => 1},
                               'xlink:type'                   => {default  => 'simple'},
                               'xml:base'                     => {optional => 1},
                               'xml:lang'                     => {optional => 1},
                               'xml:space'                    => {optional => 1},
                               'xmlns:xlink'                  => {default  => 'http://www.w3.org/1999/xlink'}},
     'altGlyph'            => {'alignment-baseline'           => {optional => 1},
                               'baseline-shift'               => {optional => 1},
                               'class'                        => {optional => 1},
                               'clip-path'                    => {optional => 1},
                               'clip-rule'                    => {optional => 1},
                               'color'                        => {optional => 1},
                               'color-interpolation'          => {optional => 1},
                               'color-rendering'              => {optional => 1},
                               'cursor'                       => {optional => 1},
                               'direction'                    => {optional => 1},
                               'display'                      => {optional => 1},
                               'dominant-baseline'            => {optional => 1},
                               'dx'                           => {optional => 1},
                               'dy'                           => {optional => 1},
                               'externalResourcesRequired'    => {optional => 1},
                               'fill'                         => {optional => 1},
                               'fill-opacity'                 => {optional => 1},
                               'fill-rule'                    => {optional => 1},
                               'filter'                       => {optional => 1},
                               'font-family'                  => {optional => 1},
                               'font-size'                    => {optional => 1},
                               'font-size-adjust'             => {optional => 1},
                               'font-stretch'                 => {optional => 1},
                               'font-style'                   => {optional => 1},
                               'font-variant'                 => {optional => 1},
                               'font-weight'                  => {optional => 1},
                               'format'                       => {optional => 1},
                               'glyph-orientation-horizontal' => {optional => 1},
                               'glyph-orientation-vertical'   => {optional => 1},
                               'glyphRef'                     => {optional => 1},
                               'id'                           => {optional => 1},
                               'image-rendering'              => {optional => 1},
                               'kerning'                      => {optional => 1},
                               'letter-spacing'               => {optional => 1},
                               'mask'                         => {optional => 1},
                               'onactivate'                   => {optional => 1},
                               'onclick'                      => {optional => 1},
                               'onfocusin'                    => {optional => 1},
                               'onfocusout'                   => {optional => 1},
                               'onload'                       => {optional => 1},
                               'onmousedown'                  => {optional => 1},
                               'onmousemove'                  => {optional => 1},
                               'onmouseout'                   => {optional => 1},
                               'onmouseover'                  => {optional => 1},
                               'onmouseup'                    => {optional => 1},
                               'opacity'                      => {optional => 1},
                               'pointer-events'               => {optional => 1},
                               'requiredExtensions'           => {optional => 1},
                               'requiredFeatures'             => {optional => 1},
                               'rotate'                       => {optional => 1},
                               'shape-rendering'              => {optional => 1},
                               'stroke'                       => {optional => 1},
                               'stroke-dasharray'             => {optional => 1},
                               'stroke-dashoffset'            => {optional => 1},
                               'stroke-linecap'               => {optional => 1},
                               'stroke-linejoin'              => {optional => 1},
                               'stroke-miterlimit'            => {optional => 1},
                               'stroke-opacity'               => {optional => 1},
                               'stroke-width'                 => {optional => 1},
                               'style'                        => {optional => 1},
                               'systemLanguage'               => {optional => 1},
                               'text-anchor'                  => {optional => 1},
                               'text-decoration'              => {optional => 1},
                               'text-rendering'               => {optional => 1},
                               'unicode-bidi'                 => {optional => 1},
                               'visibility'                   => {optional => 1},
                               'word-spacing'                 => {optional => 1},
                               'x'                            => {optional => 1},
                               'xlink:actuate'                => {default  => 'onLoad'},
                               'xlink:arcrole'                => {optional => 1},
                               'xlink:href'                   => {optional => 1},
                               'xlink:role'                   => {optional => 1},
                               'xlink:show'                   => {default  => 'other'},
                               'xlink:title'                  => {optional => 1},
                               'xlink:type'                   => {default  => 'simple'},
                               'xml:base'                     => {optional => 1},
                               'xml:lang'                     => {optional => 1},
                               'xml:space'                    => {optional => 1},
                               'xmlns:xlink'                  => {default  => 'http://www.w3.org/1999/xlink'},
                               'y'                            => {optional => 1}},
     'altGlyphDef'         => {'id'                           => {optional => 1},
                               'xml:base'                     => {optional => 1},
                               'xml:lang'                     => {optional => 1},
                               'xml:space'                    => {optional => 1}},
     'altGlyphItem'        => {'id'                           => {optional => 1},
                               'xml:base'                     => {optional => 1},
                               'xml:lang'                     => {optional => 1},
                               'xml:space'                    => {optional => 1}},
     'animate'             => {'accumulate'                   => {default  => 'none'},
                               'additive'                     => {default  => 'replace'},
                               'attributeName'                => {optional => 0},
                               'attributeType'                => {optional => 1},
                               'begin'                        => {optional => 1},
                               'by'                           => {optional => 1},
                               'calcMode'                     => {default  => 'linear'},
                               'dur'                          => {optional => 1},
                               'end'                          => {optional => 1},
                               'externalResourcesRequired'    => {optional => 1},
                               'fill'                         => {default  => 'remove'},
                               'from'                         => {optional => 1},
                               'id'                           => {optional => 1},
                               'keySplines'                   => {optional => 1},
                               'keyTimes'                     => {optional => 1},
                               'max'                          => {optional => 1},
                               'min'                          => {optional => 1},
                               'onbegin'                      => {optional => 1},
                               'onend'                        => {optional => 1},
                               'onload'                       => {optional => 1},
                               'onrepeat'                     => {optional => 1},
                               'repeatCount'                  => {optional => 1},
                               'repeatDur'                    => {optional => 1},
                               'requiredExtensions'           => {optional => 1},
                               'requiredFeatures'             => {optional => 1},
                               'restart'                      => {default  => 'always'},
                               'systemLanguage'               => {optional => 1},
                               'to'                           => {optional => 1},
                               'values'                       => {optional => 1},
                               'xlink:actuate'                => {default  => 'onLoad'},
                               'xlink:arcrole'                => {optional => 1},
                               'xlink:href'                   => {optional => 1},
                               'xlink:role'                   => {optional => 1},
                               'xlink:show'                   => {default  => 'other'},
                               'xlink:title'                  => {optional => 1},
                               'xlink:type'                   => {default  => 'simple'},
                               'xml:base'                     => {optional => 1},
                               'xml:lang'                     => {optional => 1},
                               'xml:space'                    => {optional => 1},
                               'xmlns:xlink'                  => {default  => 'http://www.w3.org/1999/xlink'}},
     'animateColor'        => {'accumulate'                   => {default  => 'none'},
                               'additive'                     => {default  => 'replace'},
                               'attributeName'                => {optional => 0},
                               'attributeType'                => {optional => 1},
                               'begin'                        => {optional => 1},
                               'by'                           => {optional => 1},
                               'calcMode'                     => {default  => 'linear'},
                               'dur'                          => {optional => 1},
                               'end'                          => {optional => 1},
                               'externalResourcesRequired'    => {optional => 1},
                               'fill'                         => {default  => 'remove'},
                               'from'                         => {optional => 1},
                               'id'                           => {optional => 1},
                               'keySplines'                   => {optional => 1},
                               'keyTimes'                     => {optional => 1},
                               'max'                          => {optional => 1},
                               'min'                          => {optional => 1},
                               'onbegin'                      => {optional => 1},
                               'onend'                        => {optional => 1},
                               'onload'                       => {optional => 1},
                               'onrepeat'                     => {optional => 1},
                               'repeatCount'                  => {optional => 1},
                               'repeatDur'                    => {optional => 1},
                               'requiredExtensions'           => {optional => 1},
                               'requiredFeatures'             => {optional => 1},
                               'restart'                      => {default  => 'always'},
                               'systemLanguage'               => {optional => 1},
                               'to'                           => {optional => 1},
                               'values'                       => {optional => 1},
                               'xlink:actuate'                => {default  => 'onLoad'},
                               'xlink:arcrole'                => {optional => 1},
                               'xlink:href'                   => {optional => 1},
                               'xlink:role'                   => {optional => 1},
                               'xlink:show'                   => {default  => 'other'},
                               'xlink:title'                  => {optional => 1},
                               'xlink:type'                   => {default  => 'simple'},
                               'xml:base'                     => {optional => 1},
                               'xml:lang'                     => {optional => 1},
                               'xml:space'                    => {optional => 1},
                               'xmlns:xlink'                  => {default  => 'http://www.w3.org/1999/xlink'}},
     'animateMotion'       => {'accumulate'                   => {default  => 'none'},
                               'additive'                     => {default  => 'replace'},
                               'begin'                        => {optional => 1},
                               'by'                           => {optional => 1},
                               'calcMode'                     => {default  => 'paced'},
                               'dur'                          => {optional => 1},
                               'end'                          => {optional => 1},
                               'externalResourcesRequired'    => {optional => 1},
                               'fill'                         => {default  => 'remove'},
                               'from'                         => {optional => 1},
                               'id'                           => {optional => 1},
                               'keyPoints'                    => {optional => 1},
                               'keySplines'                   => {optional => 1},
                               'keyTimes'                     => {optional => 1},
                               'max'                          => {optional => 1},
                               'min'                          => {optional => 1},
                               'onbegin'                      => {optional => 1},
                               'onend'                        => {optional => 1},
                               'onload'                       => {optional => 1},
                               'onrepeat'                     => {optional => 1},
                               'origin'                       => {optional => 1},
                               'path'                         => {optional => 1},
                               'repeatCount'                  => {optional => 1},
                               'repeatDur'                    => {optional => 1},
                               'requiredExtensions'           => {optional => 1},
                               'requiredFeatures'             => {optional => 1},
                               'restart'                      => {default  => 'always'},
                               'rotate'                       => {optional => 1},
                               'systemLanguage'               => {optional => 1},
                               'to'                           => {optional => 1},
                               'values'                       => {optional => 1},
                               'xlink:actuate'                => {default  => 'onLoad'},
                               'xlink:arcrole'                => {optional => 1},
                               'xlink:href'                   => {optional => 1},
                               'xlink:role'                   => {optional => 1},
                               'xlink:show'                   => {default  => 'other'},
                               'xlink:title'                  => {optional => 1},
                               'xlink:type'                   => {default  => 'simple'},
                               'xml:base'                     => {optional => 1},
                               'xml:lang'                     => {optional => 1},
                               'xml:space'                    => {optional => 1},
                               'xmlns:xlink'                  => {default  => 'http://www.w3.org/1999/xlink'}},
     'animateTransform'    => {'accumulate'                   => {default  => 'none'},
                               'additive'                     => {default  => 'replace'},
                               'attributeName'                => {optional => 0},
                               'attributeType'                => {optional => 1},
                               'begin'                        => {optional => 1},
                               'by'                           => {optional => 1},
                               'calcMode'                     => {default  => 'linear'},
                               'dur'                          => {optional => 1},
                               'end'                          => {optional => 1},
                               'externalResourcesRequired'    => {optional => 1},
                               'fill'                         => {default  => 'remove'},
                               'from'                         => {optional => 1},
                               'id'                           => {optional => 1},
                               'keySplines'                   => {optional => 1},
                               'keyTimes'                     => {optional => 1},
                               'max'                          => {optional => 1},
                               'min'                          => {optional => 1},
                               'onbegin'                      => {optional => 1},
                               'onend'                        => {optional => 1},
                               'onload'                       => {optional => 1},
                               'onrepeat'                     => {optional => 1},
                               'repeatCount'                  => {optional => 1},
                               'repeatDur'                    => {optional => 1},
                               'requiredExtensions'           => {optional => 1},
                               'requiredFeatures'             => {optional => 1},
                               'restart'                      => {default  => 'always'},
                               'systemLanguage'               => {optional => 1},
                               'to'                           => {optional => 1},
                               'type'                         => {default  => 'translate'},
                               'values'                       => {optional => 1},
                               'xlink:actuate'                => {default  => 'onLoad'},
                               'xlink:arcrole'                => {optional => 1},
                               'xlink:href'                   => {optional => 1},
                               'xlink:role'                   => {optional => 1},
                               'xlink:show'                   => {default  => 'other'},
                               'xlink:title'                  => {optional => 1},
                               'xlink:type'                   => {default  => 'simple'},
                               'xml:base'                     => {optional => 1},
                               'xml:lang'                     => {optional => 1},
                               'xml:space'                    => {optional => 1},
                               'xmlns:xlink'                  => {default  => 'http://www.w3.org/1999/xlink'}},
     'circle'              => {'class'                        => {optional => 1},
                               'clip-path'                    => {optional => 1},
                               'clip-rule'                    => {optional => 1},
                               'color'                        => {optional => 1},
                               'color-interpolation'          => {optional => 1},
                               'color-rendering'              => {optional => 1},
                               'cursor'                       => {optional => 1},
                               'cx'                           => {optional => 1},
                               'cy'                           => {optional => 1},
                               'display'                      => {optional => 1},
                               'externalResourcesRequired'    => {optional => 1},
                               'fill'                         => {optional => 1},
                               'fill-opacity'                 => {optional => 1},
                               'fill-rule'                    => {optional => 1},
                               'filter'                       => {optional => 1},
                               'id'                           => {optional => 1},
                               'image-rendering'              => {optional => 1},
                               'mask'                         => {optional => 1},
                               'onactivate'                   => {optional => 1},
                               'onclick'                      => {optional => 1},
                               'onfocusin'                    => {optional => 1},
                               'onfocusout'                   => {optional => 1},
                               'onload'                       => {optional => 1},
                               'onmousedown'                  => {optional => 1},
                               'onmousemove'                  => {optional => 1},
                               'onmouseout'                   => {optional => 1},
                               'onmouseover'                  => {optional => 1},
                               'onmouseup'                    => {optional => 1},
                               'opacity'                      => {optional => 1},
                               'pointer-events'               => {optional => 1},
                               'r'                            => {optional => 0},
                               'requiredExtensions'           => {optional => 1},
                               'requiredFeatures'             => {optional => 1},
                               'shape-rendering'              => {optional => 1},
                               'stroke'                       => {optional => 1},
                               'stroke-dasharray'             => {optional => 1},
                               'stroke-dashoffset'            => {optional => 1},
                               'stroke-linecap'               => {optional => 1},
                               'stroke-linejoin'              => {optional => 1},
                               'stroke-miterlimit'            => {optional => 1},
                               'stroke-opacity'               => {optional => 1},
                               'stroke-width'                 => {optional => 1},
                               'style'                        => {optional => 1},
                               'systemLanguage'               => {optional => 1},
                               'text-rendering'               => {optional => 1},
                               'transform'                    => {optional => 1},
                               'visibility'                   => {optional => 1},
                               'xml:base'                     => {optional => 1},
                               'xml:lang'                     => {optional => 1},
                               'xml:space'                    => {optional => 1}},
     'clipPath'            => {'alignment-baseline'           => {optional => 1},
                               'baseline-shift'               => {optional => 1},
                               'class'                        => {optional => 1},
                               'clip-path'                    => {optional => 1},
                               'clip-rule'                    => {optional => 1},
                               'clipPathUnits'                => {optional => 1},
                               'color'                        => {optional => 1},
                               'color-interpolation'          => {optional => 1},
                               'color-rendering'              => {optional => 1},
                               'cursor'                       => {optional => 1},
                               'direction'                    => {optional => 1},
                               'display'                      => {optional => 1},
                               'dominant-baseline'            => {optional => 1},
                               'externalResourcesRequired'    => {optional => 1},
                               'fill'                         => {optional => 1},
                               'fill-opacity'                 => {optional => 1},
                               'fill-rule'                    => {optional => 1},
                               'filter'                       => {optional => 1},
                               'font-family'                  => {optional => 1},
                               'font-size'                    => {optional => 1},
                               'font-size-adjust'             => {optional => 1},
                               'font-stretch'                 => {optional => 1},
                               'font-style'                   => {optional => 1},
                               'font-variant'                 => {optional => 1},
                               'font-weight'                  => {optional => 1},
                               'glyph-orientation-horizontal' => {optional => 1},
                               'glyph-orientation-vertical'   => {optional => 1},
                               'id'                           => {optional => 1},
                               'image-rendering'              => {optional => 1},
                               'kerning'                      => {optional => 1},
                               'letter-spacing'               => {optional => 1},
                               'mask'                         => {optional => 1},
                               'opacity'                      => {optional => 1},
                               'pointer-events'               => {optional => 1},
                               'requiredExtensions'           => {optional => 1},
                               'requiredFeatures'             => {optional => 1},
                               'shape-rendering'              => {optional => 1},
                               'stroke'                       => {optional => 1},
                               'stroke-dasharray'             => {optional => 1},
                               'stroke-dashoffset'            => {optional => 1},
                               'stroke-linecap'               => {optional => 1},
                               'stroke-linejoin'              => {optional => 1},
                               'stroke-miterlimit'            => {optional => 1},
                               'stroke-opacity'               => {optional => 1},
                               'stroke-width'                 => {optional => 1},
                               'style'                        => {optional => 1},
                               'systemLanguage'               => {optional => 1},
                               'text-anchor'                  => {optional => 1},
                               'text-decoration'              => {optional => 1},
                               'text-rendering'               => {optional => 1},
                               'transform'                    => {optional => 1},
                               'unicode-bidi'                 => {optional => 1},
                               'visibility'                   => {optional => 1},
                               'word-spacing'                 => {optional => 1},
                               'writing-mode'                 => {optional => 1},
                               'xml:base'                     => {optional => 1},
                               'xml:lang'                     => {optional => 1},
                               'xml:space'                    => {optional => 1}},
     'color-profile'       => {'id'                           => {optional => 1},
                               'local'                        => {optional => 1},
                               'name'                         => {optional => 0},
                               'rendering-intent'             => {default  => 'auto'},
                               'xlink:actuate'                => {default  => 'onLoad'},
                               'xlink:arcrole'                => {optional => 1},
                               'xlink:href'                   => {optional => 1},
                               'xlink:role'                   => {optional => 1},
                               'xlink:show'                   => {default  => 'other'},
                               'xlink:title'                  => {optional => 1},
                               'xlink:type'                   => {default  => 'simple'},
                               'xml:base'                     => {optional => 1},
                               'xml:lang'                     => {optional => 1},
                               'xml:space'                    => {optional => 1},
                               'xmlns:xlink'                  => {default  => 'http://www.w3.org/1999/xlink'}},
     'cursor'              => {'externalResourcesRequired'    => {optional => 1},
                               'id'                           => {optional => 1},
                               'requiredExtensions'           => {optional => 1},
                               'requiredFeatures'             => {optional => 1},
                               'systemLanguage'               => {optional => 1},
                               'x'                            => {optional => 1},
                               'xlink:actuate'                => {default  => 'onLoad'},
                               'xlink:arcrole'                => {optional => 1},
                               'xlink:href'                   => {optional => 0},
                               'xlink:role'                   => {optional => 1},
                               'xlink:show'                   => {default  => 'other'},
                               'xlink:title'                  => {optional => 1},
                               'xlink:type'                   => {default  => 'simple'},
                               'xml:base'                     => {optional => 1},
                               'xml:lang'                     => {optional => 1},
                               'xml:space'                    => {optional => 1},
                               'xmlns:xlink'                  => {default  => 'http://www.w3.org/1999/xlink'},
                               'y'                            => {optional => 1}},
     'definition-src'      => {'id'                           => {optional => 1},
                               'xlink:actuate'                => {default  => 'onLoad'},
                               'xlink:arcrole'                => {optional => 1},
                               'xlink:href'                   => {optional => 0},
                               'xlink:role'                   => {optional => 1},
                               'xlink:show'                   => {default  => 'other'},
                               'xlink:title'                  => {optional => 1},
                               'xlink:type'                   => {default  => 'simple'},
                               'xml:base'                     => {optional => 1},
                               'xml:lang'                     => {optional => 1},
                               'xml:space'                    => {optional => 1},
                               'xmlns:xlink'                  => {default  => 'http://www.w3.org/1999/xlink'}},
     'defs'                => {'alignment-baseline'           => {optional => 1},
                               'baseline-shift'               => {optional => 1},
                               'class'                        => {optional => 1},
                               'clip'                         => {optional => 1},
                               'clip-path'                    => {optional => 1},
                               'clip-rule'                    => {optional => 1},
                               'color'                        => {optional => 1},
                               'color-interpolation'          => {optional => 1},
                               'color-interpolation-filters'  => {optional => 1},
                               'color-profile'                => {optional => 1},
                               'color-rendering'              => {optional => 1},
                               'cursor'                       => {optional => 1},
                               'direction'                    => {optional => 1},
                               'display'                      => {optional => 1},
                               'dominant-baseline'            => {optional => 1},
                               'enable-background'            => {optional => 1},
                               'externalResourcesRequired'    => {optional => 1},
                               'fill'                         => {optional => 1},
                               'fill-opacity'                 => {optional => 1},
                               'fill-rule'                    => {optional => 1},
                               'filter'                       => {optional => 1},
                               'flood-color'                  => {optional => 1},
                               'flood-opacity'                => {optional => 1},
                               'font-family'                  => {optional => 1},
                               'font-size'                    => {optional => 1},
                               'font-size-adjust'             => {optional => 1},
                               'font-stretch'                 => {optional => 1},
                               'font-style'                   => {optional => 1},
                               'font-variant'                 => {optional => 1},
                               'font-weight'                  => {optional => 1},
                               'glyph-orientation-horizontal' => {optional => 1},
                               'glyph-orientation-vertical'   => {optional => 1},
                               'id'                           => {optional => 1},
                               'image-rendering'              => {optional => 1},
                               'kerning'                      => {optional => 1},
                               'letter-spacing'               => {optional => 1},
                               'lighting-color'               => {optional => 1},
                               'marker-end'                   => {optional => 1},
                               'marker-mid'                   => {optional => 1},
                               'marker-start'                 => {optional => 1},
                               'mask'                         => {optional => 1},
                               'onactivate'                   => {optional => 1},
                               'onclick'                      => {optional => 1},
                               'onfocusin'                    => {optional => 1},
                               'onfocusout'                   => {optional => 1},
                               'onload'                       => {optional => 1},
                               'onmousedown'                  => {optional => 1},
                               'onmousemove'                  => {optional => 1},
                               'onmouseout'                   => {optional => 1},
                               'onmouseover'                  => {optional => 1},
                               'onmouseup'                    => {optional => 1},
                               'opacity'                      => {optional => 1},
                               'overflow'                     => {optional => 1},
                               'pointer-events'               => {optional => 1},
                               'requiredExtensions'           => {optional => 1},
                               'requiredFeatures'             => {optional => 1},
                               'shape-rendering'              => {optional => 1},
                               'stop-color'                   => {optional => 1},
                               'stop-opacity'                 => {optional => 1},
                               'stroke'                       => {optional => 1},
                               'stroke-dasharray'             => {optional => 1},
                               'stroke-dashoffset'            => {optional => 1},
                               'stroke-linecap'               => {optional => 1},
                               'stroke-linejoin'              => {optional => 1},
                               'stroke-miterlimit'            => {optional => 1},
                               'stroke-opacity'               => {optional => 1},
                               'stroke-width'                 => {optional => 1},
                               'style'                        => {optional => 1},
                               'systemLanguage'               => {optional => 1},
                               'text-anchor'                  => {optional => 1},
                               'text-decoration'              => {optional => 1},
                               'text-rendering'               => {optional => 1},
                               'transform'                    => {optional => 1},
                               'unicode-bidi'                 => {optional => 1},
                               'visibility'                   => {optional => 1},
                               'word-spacing'                 => {optional => 1},
                               'writing-mode'                 => {optional => 1},
                               'xml:base'                     => {optional => 1},
                               'xml:lang'                     => {optional => 1},
                               'xml:space'                    => {optional => 1}},
     'desc'                => {'class'                        => {optional => 1},
                               'id'                           => {optional => 1},
                               'style'                        => {optional => 1},
                               'xml:base'                     => {optional => 1},
                               'xml:lang'                     => {optional => 1},
                               'xml:space'                    => {optional => 1}},
     'ellipse'             => {'class'                        => {optional => 1},
                               'clip-path'                    => {optional => 1},
                               'clip-rule'                    => {optional => 1},
                               'color'                        => {optional => 1},
                               'color-interpolation'          => {optional => 1},
                               'color-rendering'              => {optional => 1},
                               'cursor'                       => {optional => 1},
                               'cx'                           => {optional => 1},
                               'cy'                           => {optional => 1},
                               'display'                      => {optional => 1},
                               'externalResourcesRequired'    => {optional => 1},
                               'fill'                         => {optional => 1},
                               'fill-opacity'                 => {optional => 1},
                               'fill-rule'                    => {optional => 1},
                               'filter'                       => {optional => 1},
                               'id'                           => {optional => 1},
                               'image-rendering'              => {optional => 1},
                               'mask'                         => {optional => 1},
                               'onactivate'                   => {optional => 1},
                               'onclick'                      => {optional => 1},
                               'onfocusin'                    => {optional => 1},
                               'onfocusout'                   => {optional => 1},
                               'onload'                       => {optional => 1},
                               'onmousedown'                  => {optional => 1},
                               'onmousemove'                  => {optional => 1},
                               'onmouseout'                   => {optional => 1},
                               'onmouseover'                  => {optional => 1},
                               'onmouseup'                    => {optional => 1},
                               'opacity'                      => {optional => 1},
                               'pointer-events'               => {optional => 1},
                               'requiredExtensions'           => {optional => 1},
                               'requiredFeatures'             => {optional => 1},
                               'rx'                           => {optional => 0},
                               'ry'                           => {optional => 0},
                               'shape-rendering'              => {optional => 1},
                               'stroke'                       => {optional => 1},
                               'stroke-dasharray'             => {optional => 1},
                               'stroke-dashoffset'            => {optional => 1},
                               'stroke-linecap'               => {optional => 1},
                               'stroke-linejoin'              => {optional => 1},
                               'stroke-miterlimit'            => {optional => 1},
                               'stroke-opacity'               => {optional => 1},
                               'stroke-width'                 => {optional => 1},
                               'style'                        => {optional => 1},
                               'systemLanguage'               => {optional => 1},
                               'text-rendering'               => {optional => 1},
                               'transform'                    => {optional => 1},
                               'visibility'                   => {optional => 1},
                               'xml:base'                     => {optional => 1},
                               'xml:lang'                     => {optional => 1},
                               'xml:space'                    => {optional => 1}},
     'feBlend'             => {'color-interpolation-filters'  => {optional => 1},
                               'height'                       => {optional => 1},
                               'id'                           => {optional => 1},
                               'in'                           => {optional => 1},
                               'in2'                          => {optional => 0},
                               'mode'                         => {default  => 'normal'},
                               'result'                       => {optional => 1},
                               'width'                        => {optional => 1},
                               'x'                            => {optional => 1},
                               'xml:base'                     => {optional => 1},
                               'xml:lang'                     => {optional => 1},
                               'xml:space'                    => {optional => 1},
                               'y'                            => {optional => 1}},
     'feColorMatrix'       => {'color-interpolation-filters'  => {optional => 1},
                               'height'                       => {optional => 1},
                               'id'                           => {optional => 1},
                               'in'                           => {optional => 1},
                               'result'                       => {optional => 1},
                               'type'                         => {default  => 'matrix'},
                               'values'                       => {optional => 1},
                               'width'                        => {optional => 1},
                               'x'                            => {optional => 1},
                               'xml:base'                     => {optional => 1},
                               'xml:lang'                     => {optional => 1},
                               'xml:space'                    => {optional => 1},
                               'y'                            => {optional => 1}},
     'feComponentTransfer' => {'color-interpolation-filters'  => {optional => 1},
                               'height'                       => {optional => 1},
                               'id'                           => {optional => 1},
                               'in'                           => {optional => 1},
                               'result'                       => {optional => 1},
                               'width'                        => {optional => 1},
                               'x'                            => {optional => 1},
                               'xml:base'                     => {optional => 1},
                               'xml:lang'                     => {optional => 1},
                               'xml:space'                    => {optional => 1},
                               'y'                            => {optional => 1}},
     'feComposite'         => {'color-interpolation-filters'  => {optional => 1},
                               'height'                       => {optional => 1},
                               'id'                           => {optional => 1},
                               'in'                           => {optional => 1},
                               'in2'                          => {optional => 0},
                               'k1'                           => {optional => 1},
                               'k2'                           => {optional => 1},
                               'k3'                           => {optional => 1},
                               'k4'                           => {optional => 1},
                               'operator'                     => {default  => 'over'},
                               'result'                       => {optional => 1},
                               'width'                        => {optional => 1},
                               'x'                            => {optional => 1},
                               'xml:base'                     => {optional => 1},
                               'xml:lang'                     => {optional => 1},
                               'xml:space'                    => {optional => 1},
                               'y'                            => {optional => 1}},
     'feConvolveMatrix'    => {'bias'                         => {optional => 1},
                               'color-interpolation-filters'  => {optional => 1},
                               'divisor'                      => {optional => 1},
                               'edgeMode'                     => {default  => 'duplicate'},
                               'height'                       => {optional => 1},
                               'id'                           => {optional => 1},
                               'in'                           => {optional => 1},
                               'kernelMatrix'                 => {optional => 0},
                               'kernelUnitLength'             => {optional => 1},
                               'order'                        => {optional => 0},
                               'preserveAlpha'                => {optional => 1},
                               'result'                       => {optional => 1},
                               'targetX'                      => {optional => 1},
                               'targetY'                      => {optional => 1},
                               'width'                        => {optional => 1},
                               'x'                            => {optional => 1},
                               'xml:base'                     => {optional => 1},
                               'xml:lang'                     => {optional => 1},
                               'xml:space'                    => {optional => 1},
                               'y'                            => {optional => 1}},
     'feDiffuseLighting'   => {'class'                        => {optional => 1},
                               'color'                        => {optional => 1},
                               'color-interpolation'          => {optional => 1},
                               'color-interpolation-filters'  => {optional => 1},
                               'color-rendering'              => {optional => 1},
                               'diffuseConstant'              => {optional => 1},
                               'height'                       => {optional => 1},
                               'id'                           => {optional => 1},
                               'in'                           => {optional => 1},
                               'kernelUnitLength'             => {optional => 1},
                               'lighting-color'               => {optional => 1},
                               'result'                       => {optional => 1},
                               'style'                        => {optional => 1},
                               'surfaceScale'                 => {optional => 1},
                               'width'                        => {optional => 1},
                               'x'                            => {optional => 1},
                               'xml:base'                     => {optional => 1},
                               'xml:lang'                     => {optional => 1},
                               'xml:space'                    => {optional => 1},
                               'y'                            => {optional => 1}},
     'feDisplacementMap'   => {'color-interpolation-filters'  => {optional => 1},
                               'height'                       => {optional => 1},
                               'id'                           => {optional => 1},
                               'in'                           => {optional => 1},
                               'in2'                          => {optional => 0},
                               'result'                       => {optional => 1},
                               'scale'                        => {optional => 1},
                               'width'                        => {optional => 1},
                               'x'                            => {optional => 1},
                               'xChannelSelector'             => {default  => 'A'},
                               'xml:base'                     => {optional => 1},
                               'xml:lang'                     => {optional => 1},
                               'xml:space'                    => {optional => 1},
                               'y'                            => {optional => 1},
                               'yChannelSelector'             => {default  => 'A'}},
     'feDistantLight'      => {'azimuth'                      => {optional => 1},
                               'elevation'                    => {optional => 1},
                               'id'                           => {optional => 1},
                               'xml:base'                     => {optional => 1},
                               'xml:lang'                     => {optional => 1},
                               'xml:space'                    => {optional => 1}},
     'feFlood'             => {'class'                        => {optional => 1},
                               'color'                        => {optional => 1},
                               'color-interpolation'          => {optional => 1},
                               'color-interpolation-filters'  => {optional => 1},
                               'color-rendering'              => {optional => 1},
                               'flood-color'                  => {optional => 1},
                               'flood-opacity'                => {optional => 1},
                               'height'                       => {optional => 1},
                               'id'                           => {optional => 1},
                               'in'                           => {optional => 1},
                               'result'                       => {optional => 1},
                               'style'                        => {optional => 1},
                               'width'                        => {optional => 1},
                               'x'                            => {optional => 1},
                               'xml:base'                     => {optional => 1},
                               'xml:lang'                     => {optional => 1},
                               'xml:space'                    => {optional => 1},
                               'y'                            => {optional => 1}},
     'feFuncA'             => {'amplitude'                    => {optional => 1},
                               'exponent'                     => {optional => 1},
                               'id'                           => {optional => 1},
                               'intercept'                    => {optional => 1},
                               'offset'                       => {optional => 1},
                               'slope'                        => {optional => 1},
                               'tableValues'                  => {optional => 1},
                               'type'                         => {optional => 0},
                               'xml:base'                     => {optional => 1},
                               'xml:lang'                     => {optional => 1},
                               'xml:space'                    => {optional => 1}},
     'feFuncB'             => {'amplitude'                    => {optional => 1},
                               'exponent'                     => {optional => 1},
                               'id'                           => {optional => 1},
                               'intercept'                    => {optional => 1},
                               'offset'                       => {optional => 1},
                               'slope'                        => {optional => 1},
                               'tableValues'                  => {optional => 1},
                               'type'                         => {optional => 0},
                               'xml:base'                     => {optional => 1},
                               'xml:lang'                     => {optional => 1},
                               'xml:space'                    => {optional => 1}},
     'feFuncG'             => {'amplitude'                    => {optional => 1},
                               'exponent'                     => {optional => 1},
                               'id'                           => {optional => 1},
                               'intercept'                    => {optional => 1},
                               'offset'                       => {optional => 1},
                               'slope'                        => {optional => 1},
                               'tableValues'                  => {optional => 1},
                               'type'                         => {optional => 0},
                               'xml:base'                     => {optional => 1},
                               'xml:lang'                     => {optional => 1},
                               'xml:space'                    => {optional => 1}},
     'feFuncR'             => {'amplitude'                    => {optional => 1},
                               'exponent'                     => {optional => 1},
                               'id'                           => {optional => 1},
                               'intercept'                    => {optional => 1},
                               'offset'                       => {optional => 1},
                               'slope'                        => {optional => 1},
                               'tableValues'                  => {optional => 1},
                               'type'                         => {optional => 0},
                               'xml:base'                     => {optional => 1},
                               'xml:lang'                     => {optional => 1},
                               'xml:space'                    => {optional => 1}},
     'feGaussianBlur'      => {'color-interpolation-filters'  => {optional => 1},
                               'height'                       => {optional => 1},
                               'id'                           => {optional => 1},
                               'in'                           => {optional => 1},
                               'result'                       => {optional => 1},
                               'stdDeviation'                 => {optional => 1},
                               'width'                        => {optional => 1},
                               'x'                            => {optional => 1},
                               'xml:base'                     => {optional => 1},
                               'xml:lang'                     => {optional => 1},
                               'xml:space'                    => {optional => 1},
                               'y'                            => {optional => 1}},
     'feImage'             => {'alignment-baseline'           => {optional => 1},
                               'baseline-shift'               => {optional => 1},
                               'class'                        => {optional => 1},
                               'clip'                         => {optional => 1},
                               'clip-path'                    => {optional => 1},
                               'clip-rule'                    => {optional => 1},
                               'color'                        => {optional => 1},
                               'color-interpolation'          => {optional => 1},
                               'color-interpolation-filters'  => {optional => 1},
                               'color-profile'                => {optional => 1},
                               'color-rendering'              => {optional => 1},
                               'cursor'                       => {optional => 1},
                               'direction'                    => {optional => 1},
                               'display'                      => {optional => 1},
                               'dominant-baseline'            => {optional => 1},
                               'enable-background'            => {optional => 1},
                               'externalResourcesRequired'    => {optional => 1},
                               'fill'                         => {optional => 1},
                               'fill-opacity'                 => {optional => 1},
                               'fill-rule'                    => {optional => 1},
                               'filter'                       => {optional => 1},
                               'flood-color'                  => {optional => 1},
                               'flood-opacity'                => {optional => 1},
                               'font-family'                  => {optional => 1},
                               'font-size'                    => {optional => 1},
                               'font-size-adjust'             => {optional => 1},
                               'font-stretch'                 => {optional => 1},
                               'font-style'                   => {optional => 1},
                               'font-variant'                 => {optional => 1},
                               'font-weight'                  => {optional => 1},
                               'glyph-orientation-horizontal' => {optional => 1},
                               'glyph-orientation-vertical'   => {optional => 1},
                               'height'                       => {optional => 1},
                               'id'                           => {optional => 1},
                               'image-rendering'              => {optional => 1},
                               'kerning'                      => {optional => 1},
                               'letter-spacing'               => {optional => 1},
                               'lighting-color'               => {optional => 1},
                               'marker-end'                   => {optional => 1},
                               'marker-mid'                   => {optional => 1},
                               'marker-start'                 => {optional => 1},
                               'mask'                         => {optional => 1},
                               'opacity'                      => {optional => 1},
                               'overflow'                     => {optional => 1},
                               'pointer-events'               => {optional => 1},
                               'preserveAspectRatio'          => {default  => 'xMidYMid meet'},
                               'result'                       => {optional => 1},
                               'shape-rendering'              => {optional => 1},
                               'stop-color'                   => {optional => 1},
                               'stop-opacity'                 => {optional => 1},
                               'stroke'                       => {optional => 1},
                               'stroke-dasharray'             => {optional => 1},
                               'stroke-dashoffset'            => {optional => 1},
                               'stroke-linecap'               => {optional => 1},
                               'stroke-linejoin'              => {optional => 1},
                               'stroke-miterlimit'            => {optional => 1},
                               'stroke-opacity'               => {optional => 1},
                               'stroke-width'                 => {optional => 1},
                               'style'                        => {optional => 1},
                               'text-anchor'                  => {optional => 1},
                               'text-decoration'              => {optional => 1},
                               'text-rendering'               => {optional => 1},
                               'unicode-bidi'                 => {optional => 1},
                               'visibility'                   => {optional => 1},
                               'width'                        => {optional => 1},
                               'word-spacing'                 => {optional => 1},
                               'writing-mode'                 => {optional => 1},
                               'x'                            => {optional => 1},
                               'xlink:actuate'                => {default  => 'onLoad'},
                               'xlink:arcrole'                => {optional => 1},
                               'xlink:href'                   => {optional => 0},
                               'xlink:role'                   => {optional => 1},
                               'xlink:show'                   => {default  => 'embed'},
                               'xlink:title'                  => {optional => 1},
                               'xlink:type'                   => {default  => 'simple'},
                               'xml:base'                     => {optional => 1},
                               'xml:lang'                     => {optional => 1},
                               'xml:space'                    => {optional => 1},
                               'xmlns:xlink'                  => {default  => 'http://www.w3.org/1999/xlink'},
                               'y'                            => {optional => 1}},
     'feMerge'             => {'color-interpolation-filters'  => {optional => 1},
                               'height'                       => {optional => 1},
                               'id'                           => {optional => 1},
                               'result'                       => {optional => 1},
                               'width'                        => {optional => 1},
                               'x'                            => {optional => 1},
                               'xml:base'                     => {optional => 1},
                               'xml:lang'                     => {optional => 1},
                               'xml:space'                    => {optional => 1},
                               'y'                            => {optional => 1}},
     'feMergeNode'         => {'id'                           => {optional => 1},
                               'in'                           => {optional => 1},
                               'xml:base'                     => {optional => 1},
                               'xml:lang'                     => {optional => 1},
                               'xml:space'                    => {optional => 1}},
     'feMorphology'        => {'color-interpolation-filters'  => {optional => 1},
                               'height'                       => {optional => 1},
                               'id'                           => {optional => 1},
                               'in'                           => {optional => 1},
                               'operator'                     => {default  => 'erode'},
                               'radius'                       => {optional => 1},
                               'result'                       => {optional => 1},
                               'width'                        => {optional => 1},
                               'x'                            => {optional => 1},
                               'xml:base'                     => {optional => 1},
                               'xml:lang'                     => {optional => 1},
                               'xml:space'                    => {optional => 1},
                               'y'                            => {optional => 1}},
     'feOffset'            => {'color-interpolation-filters'  => {optional => 1},
                               'dx'                           => {optional => 1},
                               'dy'                           => {optional => 1},
                               'height'                       => {optional => 1},
                               'id'                           => {optional => 1},
                               'in'                           => {optional => 1},
                               'result'                       => {optional => 1},
                               'width'                        => {optional => 1},
                               'x'                            => {optional => 1},
                               'xml:base'                     => {optional => 1},
                               'xml:lang'                     => {optional => 1},
                               'xml:space'                    => {optional => 1},
                               'y'                            => {optional => 1}},
     'fePointLight'        => {'id'                           => {optional => 1},
                               'x'                            => {optional => 1},
                               'xml:base'                     => {optional => 1},
                               'xml:lang'                     => {optional => 1},
                               'xml:space'                    => {optional => 1},
                               'y'                            => {optional => 1},
                               'z'                            => {optional => 1}},
     'feSpecularLighting'  => {'class'                        => {optional => 1},
                               'color'                        => {optional => 1},
                               'color-interpolation'          => {optional => 1},
                               'color-interpolation-filters'  => {optional => 1},
                               'color-rendering'              => {optional => 1},
                               'height'                       => {optional => 1},
                               'id'                           => {optional => 1},
                               'in'                           => {optional => 1},
                               'kernelUnitLength'             => {optional => 1},
                               'lighting-color'               => {optional => 1},
                               'result'                       => {optional => 1},
                               'specularConstant'             => {optional => 1},
                               'specularExponent'             => {optional => 1},
                               'style'                        => {optional => 1},
                               'surfaceScale'                 => {optional => 1},
                               'width'                        => {optional => 1},
                               'x'                            => {optional => 1},
                               'xml:base'                     => {optional => 1},
                               'xml:lang'                     => {optional => 1},
                               'xml:space'                    => {optional => 1},
                               'y'                            => {optional => 1}},
     'feSpotLight'         => {'id'                           => {optional => 1},
                               'limitingConeAngle'            => {optional => 1},
                               'pointsAtX'                    => {optional => 1},
                               'pointsAtY'                    => {optional => 1},
                               'pointsAtZ'                    => {optional => 1},
                               'specularExponent'             => {optional => 1},
                               'x'                            => {optional => 1},
                               'xml:base'                     => {optional => 1},
                               'xml:lang'                     => {optional => 1},
                               'xml:space'                    => {optional => 1},
                               'y'                            => {optional => 1},
                               'z'                            => {optional => 1}},
     'feTile'              => {'color-interpolation-filters'  => {optional => 1},
                               'height'                       => {optional => 1},
                               'id'                           => {optional => 1},
                               'in'                           => {optional => 1},
                               'result'                       => {optional => 1},
                               'width'                        => {optional => 1},
                               'x'                            => {optional => 1},
                               'xml:base'                     => {optional => 1},
                               'xml:lang'                     => {optional => 1},
                               'xml:space'                    => {optional => 1},
                               'y'                            => {optional => 1}},
     'feTurbulence'        => {'baseFrequency'                => {optional => 1},
                               'color-interpolation-filters'  => {optional => 1},
                               'height'                       => {optional => 1},
                               'id'                           => {optional => 1},
                               'numOctaves'                   => {optional => 1},
                               'result'                       => {optional => 1},
                               'seed'                         => {optional => 1},
                               'stitchTiles'                  => {default  => 'noStitch'},
                               'type'                         => {default  => 'turbulence'},
                               'width'                        => {optional => 1},
                               'x'                            => {optional => 1},
                               'xml:base'                     => {optional => 1},
                               'xml:lang'                     => {optional => 1},
                               'xml:space'                    => {optional => 1},
                               'y'                            => {optional => 1}},
     'filter'              => {'alignment-baseline'           => {optional => 1},
                               'baseline-shift'               => {optional => 1},
                               'class'                        => {optional => 1},
                               'clip'                         => {optional => 1},
                               'clip-path'                    => {optional => 1},
                               'clip-rule'                    => {optional => 1},
                               'color'                        => {optional => 1},
                               'color-interpolation'          => {optional => 1},
                               'color-interpolation-filters'  => {optional => 1},
                               'color-profile'                => {optional => 1},
                               'color-rendering'              => {optional => 1},
                               'cursor'                       => {optional => 1},
                               'direction'                    => {optional => 1},
                               'display'                      => {optional => 1},
                               'dominant-baseline'            => {optional => 1},
                               'enable-background'            => {optional => 1},
                               'externalResourcesRequired'    => {optional => 1},
                               'fill'                         => {optional => 1},
                               'fill-opacity'                 => {optional => 1},
                               'fill-rule'                    => {optional => 1},
                               'filter'                       => {optional => 1},
                               'filterRes'                    => {optional => 1},
                               'filterUnits'                  => {optional => 1},
                               'flood-color'                  => {optional => 1},
                               'flood-opacity'                => {optional => 1},
                               'font-family'                  => {optional => 1},
                               'font-size'                    => {optional => 1},
                               'font-size-adjust'             => {optional => 1},
                               'font-stretch'                 => {optional => 1},
                               'font-style'                   => {optional => 1},
                               'font-variant'                 => {optional => 1},
                               'font-weight'                  => {optional => 1},
                               'glyph-orientation-horizontal' => {optional => 1},
                               'glyph-orientation-vertical'   => {optional => 1},
                               'height'                       => {optional => 1},
                               'id'                           => {optional => 1},
                               'image-rendering'              => {optional => 1},
                               'kerning'                      => {optional => 1},
                               'letter-spacing'               => {optional => 1},
                               'lighting-color'               => {optional => 1},
                               'marker-end'                   => {optional => 1},
                               'marker-mid'                   => {optional => 1},
                               'marker-start'                 => {optional => 1},
                               'mask'                         => {optional => 1},
                               'opacity'                      => {optional => 1},
                               'overflow'                     => {optional => 1},
                               'pointer-events'               => {optional => 1},
                               'primitiveUnits'               => {optional => 1},
                               'shape-rendering'              => {optional => 1},
                               'stop-color'                   => {optional => 1},
                               'stop-opacity'                 => {optional => 1},
                               'stroke'                       => {optional => 1},
                               'stroke-dasharray'             => {optional => 1},
                               'stroke-dashoffset'            => {optional => 1},
                               'stroke-linecap'               => {optional => 1},
                               'stroke-linejoin'              => {optional => 1},
                               'stroke-miterlimit'            => {optional => 1},
                               'stroke-opacity'               => {optional => 1},
                               'stroke-width'                 => {optional => 1},
                               'style'                        => {optional => 1},
                               'text-anchor'                  => {optional => 1},
                               'text-decoration'              => {optional => 1},
                               'text-rendering'               => {optional => 1},
                               'unicode-bidi'                 => {optional => 1},
                               'visibility'                   => {optional => 1},
                               'width'                        => {optional => 1},
                               'word-spacing'                 => {optional => 1},
                               'writing-mode'                 => {optional => 1},
                               'x'                            => {optional => 1},
                               'xlink:actuate'                => {default  => 'onLoad'},
                               'xlink:arcrole'                => {optional => 1},
                               'xlink:href'                   => {optional => 1},
                               'xlink:role'                   => {optional => 1},
                               'xlink:show'                   => {default  => 'other'},
                               'xlink:title'                  => {optional => 1},
                               'xlink:type'                   => {default  => 'simple'},
                               'xml:base'                     => {optional => 1},
                               'xml:lang'                     => {optional => 1},
                               'xml:space'                    => {optional => 1},
                               'xmlns:xlink'                  => {default  => 'http://www.w3.org/1999/xlink'},
                               'y'                            => {optional => 1}},
     'font'                => {'alignment-baseline'           => {optional => 1},
                               'baseline-shift'               => {optional => 1},
                               'class'                        => {optional => 1},
                               'clip'                         => {optional => 1},
                               'clip-path'                    => {optional => 1},
                               'clip-rule'                    => {optional => 1},
                               'color'                        => {optional => 1},
                               'color-interpolation'          => {optional => 1},
                               'color-interpolation-filters'  => {optional => 1},
                               'color-profile'                => {optional => 1},
                               'color-rendering'              => {optional => 1},
                               'cursor'                       => {optional => 1},
                               'direction'                    => {optional => 1},
                               'display'                      => {optional => 1},
                               'dominant-baseline'            => {optional => 1},
                               'enable-background'            => {optional => 1},
                               'externalResourcesRequired'    => {optional => 1},
                               'fill'                         => {optional => 1},
                               'fill-opacity'                 => {optional => 1},
                               'fill-rule'                    => {optional => 1},
                               'filter'                       => {optional => 1},
                               'flood-color'                  => {optional => 1},
                               'flood-opacity'                => {optional => 1},
                               'font-family'                  => {optional => 1},
                               'font-size'                    => {optional => 1},
                               'font-size-adjust'             => {optional => 1},
                               'font-stretch'                 => {optional => 1},
                               'font-style'                   => {optional => 1},
                               'font-variant'                 => {optional => 1},
                               'font-weight'                  => {optional => 1},
                               'glyph-orientation-horizontal' => {optional => 1},
                               'glyph-orientation-vertical'   => {optional => 1},
                               'horiz-adv-x'                  => {optional => 0},
                               'horiz-origin-x'               => {optional => 1},
                               'horiz-origin-y'               => {optional => 1},
                               'id'                           => {optional => 1},
                               'image-rendering'              => {optional => 1},
                               'kerning'                      => {optional => 1},
                               'letter-spacing'               => {optional => 1},
                               'lighting-color'               => {optional => 1},
                               'marker-end'                   => {optional => 1},
                               'marker-mid'                   => {optional => 1},
                               'marker-start'                 => {optional => 1},
                               'mask'                         => {optional => 1},
                               'opacity'                      => {optional => 1},
                               'overflow'                     => {optional => 1},
                               'pointer-events'               => {optional => 1},
                               'shape-rendering'              => {optional => 1},
                               'stop-color'                   => {optional => 1},
                               'stop-opacity'                 => {optional => 1},
                               'stroke'                       => {optional => 1},
                               'stroke-dasharray'             => {optional => 1},
                               'stroke-dashoffset'            => {optional => 1},
                               'stroke-linecap'               => {optional => 1},
                               'stroke-linejoin'              => {optional => 1},
                               'stroke-miterlimit'            => {optional => 1},
                               'stroke-opacity'               => {optional => 1},
                               'stroke-width'                 => {optional => 1},
                               'style'                        => {optional => 1},
                               'text-anchor'                  => {optional => 1},
                               'text-decoration'              => {optional => 1},
                               'text-rendering'               => {optional => 1},
                               'unicode-bidi'                 => {optional => 1},
                               'vert-adv-y'                   => {optional => 1},
                               'vert-origin-x'                => {optional => 1},
                               'vert-origin-y'                => {optional => 1},
                               'visibility'                   => {optional => 1},
                               'word-spacing'                 => {optional => 1},
                               'writing-mode'                 => {optional => 1},
                               'xml:base'                     => {optional => 1},
                               'xml:lang'                     => {optional => 1},
                               'xml:space'                    => {optional => 1}},
     'font-face'           => {'accent-height'                => {optional => 1},
                               'alphabetic'                   => {optional => 1},
                               'ascent'                       => {optional => 1},
                               'bbox'                         => {optional => 1},
                               'cap-height'                   => {optional => 1},
                               'descent'                      => {optional => 1},
                               'font-family'                  => {optional => 1},
                               'font-size'                    => {optional => 1},
                               'font-stretch'                 => {optional => 1},
                               'font-style'                   => {optional => 1},
                               'font-variant'                 => {optional => 1},
                               'font-weight'                  => {optional => 1},
                               'hanging'                      => {optional => 1},
                               'id'                           => {optional => 1},
                               'ideographic'                  => {optional => 1},
                               'mathematical'                 => {optional => 1},
                               'overline-position'            => {optional => 1},
                               'overline-thickness'           => {optional => 1},
                               'panose-1'                     => {optional => 1},
                               'slope'                        => {optional => 1},
                               'stemh'                        => {optional => 1},
                               'stemv'                        => {optional => 1},
                               'strikethrough-position'       => {optional => 1},
                               'strikethrough-thickness'      => {optional => 1},
                               'underline-position'           => {optional => 1},
                               'underline-thickness'          => {optional => 1},
                               'unicode-range'                => {optional => 1},
                               'units-per-em'                 => {optional => 1},
                               'v-alphabetic'                 => {optional => 1},
                               'v-hanging'                    => {optional => 1},
                               'v-ideographic'                => {optional => 1},
                               'v-mathematical'               => {optional => 1},
                               'widths'                       => {optional => 1},
                               'x-height'                     => {optional => 1},
                               'xml:base'                     => {optional => 1},
                               'xml:lang'                     => {optional => 1},
                               'xml:space'                    => {optional => 1}},
     'font-face-format'    => {'id'                           => {optional => 1},
                               'string'                       => {optional => 1},
                               'xml:base'                     => {optional => 1},
                               'xml:lang'                     => {optional => 1},
                               'xml:space'                    => {optional => 1}},
     'font-face-name'      => {'id'                           => {optional => 1},
                               'name'                         => {optional => 1},
                               'xml:base'                     => {optional => 1},
                               'xml:lang'                     => {optional => 1},
                               'xml:space'                    => {optional => 1}},
     'font-face-src'       => {'id'                           => {optional => 1},
                               'xml:base'                     => {optional => 1},
                               'xml:lang'                     => {optional => 1},
                               'xml:space'                    => {optional => 1}},
     'font-face-uri'       => {'id'                           => {optional => 1},
                               'xlink:actuate'                => {default  => 'onLoad'},
                               'xlink:arcrole'                => {optional => 1},
                               'xlink:href'                   => {optional => 0},
                               'xlink:role'                   => {optional => 1},
                               'xlink:show'                   => {default  => 'other'},
                               'xlink:title'                  => {optional => 1},
                               'xlink:type'                   => {default  => 'simple'},
                               'xml:base'                     => {optional => 1},
                               'xml:lang'                     => {optional => 1},
                               'xml:space'                    => {optional => 1},
                               'xmlns:xlink'                  => {default  => 'http://www.w3.org/1999/xlink'}},
     'foreignObject'       => {'alignment-baseline'           => {optional => 1},
                               'baseline-shift'               => {optional => 1},
                               'class'                        => {optional => 1},
                               'clip'                         => {optional => 1},
                               'clip-path'                    => {optional => 1},
                               'clip-rule'                    => {optional => 1},
                               'color'                        => {optional => 1},
                               'color-interpolation'          => {optional => 1},
                               'color-interpolation-filters'  => {optional => 1},
                               'color-profile'                => {optional => 1},
                               'color-rendering'              => {optional => 1},
                               'cursor'                       => {optional => 1},
                               'direction'                    => {optional => 1},
                               'display'                      => {optional => 1},
                               'dominant-baseline'            => {optional => 1},
                               'enable-background'            => {optional => 1},
                               'externalResourcesRequired'    => {optional => 1},
                               'fill'                         => {optional => 1},
                               'fill-opacity'                 => {optional => 1},
                               'fill-rule'                    => {optional => 1},
                               'filter'                       => {optional => 1},
                               'flood-color'                  => {optional => 1},
                               'flood-opacity'                => {optional => 1},
                               'font-family'                  => {optional => 1},
                               'font-size'                    => {optional => 1},
                               'font-size-adjust'             => {optional => 1},
                               'font-stretch'                 => {optional => 1},
                               'font-style'                   => {optional => 1},
                               'font-variant'                 => {optional => 1},
                               'font-weight'                  => {optional => 1},
                               'glyph-orientation-horizontal' => {optional => 1},
                               'glyph-orientation-vertical'   => {optional => 1},
                               'height'                       => {optional => 0},
                               'id'                           => {optional => 1},
                               'image-rendering'              => {optional => 1},
                               'kerning'                      => {optional => 1},
                               'letter-spacing'               => {optional => 1},
                               'lighting-color'               => {optional => 1},
                               'marker-end'                   => {optional => 1},
                               'marker-mid'                   => {optional => 1},
                               'marker-start'                 => {optional => 1},
                               'mask'                         => {optional => 1},
                               'onactivate'                   => {optional => 1},
                               'onclick'                      => {optional => 1},
                               'onfocusin'                    => {optional => 1},
                               'onfocusout'                   => {optional => 1},
                               'onload'                       => {optional => 1},
                               'onmousedown'                  => {optional => 1},
                               'onmousemove'                  => {optional => 1},
                               'onmouseout'                   => {optional => 1},
                               'onmouseover'                  => {optional => 1},
                               'onmouseup'                    => {optional => 1},
                               'opacity'                      => {optional => 1},
                               'overflow'                     => {optional => 1},
                               'pointer-events'               => {optional => 1},
                               'requiredExtensions'           => {optional => 1},
                               'requiredFeatures'             => {optional => 1},
                               'shape-rendering'              => {optional => 1},
                               'stop-color'                   => {optional => 1},
                               'stop-opacity'                 => {optional => 1},
                               'stroke'                       => {optional => 1},
                               'stroke-dasharray'             => {optional => 1},
                               'stroke-dashoffset'            => {optional => 1},
                               'stroke-linecap'               => {optional => 1},
                               'stroke-linejoin'              => {optional => 1},
                               'stroke-miterlimit'            => {optional => 1},
                               'stroke-opacity'               => {optional => 1},
                               'stroke-width'                 => {optional => 1},
                               'style'                        => {optional => 1},
                               'systemLanguage'               => {optional => 1},
                               'text-anchor'                  => {optional => 1},
                               'text-decoration'              => {optional => 1},
                               'text-rendering'               => {optional => 1},
                               'transform'                    => {optional => 1},
                               'unicode-bidi'                 => {optional => 1},
                               'visibility'                   => {optional => 1},
                               'width'                        => {optional => 0},
                               'word-spacing'                 => {optional => 1},
                               'writing-mode'                 => {optional => 1},
                               'x'                            => {optional => 1},
                               'xml:base'                     => {optional => 1},
                               'xml:lang'                     => {optional => 1},
                               'xml:space'                    => {optional => 1},
                               'y'                            => {optional => 1}},
     'g'                   => {'alignment-baseline'           => {optional => 1},
                               'baseline-shift'               => {optional => 1},
                               'class'                        => {optional => 1},
                               'clip'                         => {optional => 1},
                               'clip-path'                    => {optional => 1},
                               'clip-rule'                    => {optional => 1},
                               'color'                        => {optional => 1},
                               'color-interpolation'          => {optional => 1},
                               'color-interpolation-filters'  => {optional => 1},
                               'color-profile'                => {optional => 1},
                               'color-rendering'              => {optional => 1},
                               'cursor'                       => {optional => 1},
                               'direction'                    => {optional => 1},
                               'display'                      => {optional => 1},
                               'dominant-baseline'            => {optional => 1},
                               'enable-background'            => {optional => 1},
                               'externalResourcesRequired'    => {optional => 1},
                               'fill'                         => {optional => 1},
                               'fill-opacity'                 => {optional => 1},
                               'fill-rule'                    => {optional => 1},
                               'filter'                       => {optional => 1},
                               'flood-color'                  => {optional => 1},
                               'flood-opacity'                => {optional => 1},
                               'font-family'                  => {optional => 1},
                               'font-size'                    => {optional => 1},
                               'font-size-adjust'             => {optional => 1},
                               'font-stretch'                 => {optional => 1},
                               'font-style'                   => {optional => 1},
                               'font-variant'                 => {optional => 1},
                               'font-weight'                  => {optional => 1},
                               'glyph-orientation-horizontal' => {optional => 1},
                               'glyph-orientation-vertical'   => {optional => 1},
                               'id'                           => {optional => 1},
                               'image-rendering'              => {optional => 1},
                               'kerning'                      => {optional => 1},
                               'letter-spacing'               => {optional => 1},
                               'lighting-color'               => {optional => 1},
                               'marker-end'                   => {optional => 1},
                               'marker-mid'                   => {optional => 1},
                               'marker-start'                 => {optional => 1},
                               'mask'                         => {optional => 1},
                               'onactivate'                   => {optional => 1},
                               'onclick'                      => {optional => 1},
                               'onfocusin'                    => {optional => 1},
                               'onfocusout'                   => {optional => 1},
                               'onload'                       => {optional => 1},
                               'onmousedown'                  => {optional => 1},
                               'onmousemove'                  => {optional => 1},
                               'onmouseout'                   => {optional => 1},
                               'onmouseover'                  => {optional => 1},
                               'onmouseup'                    => {optional => 1},
                               'opacity'                      => {optional => 1},
                               'overflow'                     => {optional => 1},
                               'pointer-events'               => {optional => 1},
                               'requiredExtensions'           => {optional => 1},
                               'requiredFeatures'             => {optional => 1},
                               'shape-rendering'              => {optional => 1},
                               'stop-color'                   => {optional => 1},
                               'stop-opacity'                 => {optional => 1},
                               'stroke'                       => {optional => 1},
                               'stroke-dasharray'             => {optional => 1},
                               'stroke-dashoffset'            => {optional => 1},
                               'stroke-linecap'               => {optional => 1},
                               'stroke-linejoin'              => {optional => 1},
                               'stroke-miterlimit'            => {optional => 1},
                               'stroke-opacity'               => {optional => 1},
                               'stroke-width'                 => {optional => 1},
                               'style'                        => {optional => 1},
                               'systemLanguage'               => {optional => 1},
                               'text-anchor'                  => {optional => 1},
                               'text-decoration'              => {optional => 1},
                               'text-rendering'               => {optional => 1},
                               'transform'                    => {optional => 1},
                               'unicode-bidi'                 => {optional => 1},
                               'visibility'                   => {optional => 1},
                               'word-spacing'                 => {optional => 1},
                               'writing-mode'                 => {optional => 1},
                               'xml:base'                     => {optional => 1},
                               'xml:lang'                     => {optional => 1},
                               'xml:space'                    => {optional => 1}},
     'glyph'               => {'alignment-baseline'           => {optional => 1},
                               'arabic-form'                  => {optional => 1},
                               'baseline-shift'               => {optional => 1},
                               'class'                        => {optional => 1},
                               'clip'                         => {optional => 1},
                               'clip-path'                    => {optional => 1},
                               'clip-rule'                    => {optional => 1},
                               'color'                        => {optional => 1},
                               'color-interpolation'          => {optional => 1},
                               'color-interpolation-filters'  => {optional => 1},
                               'color-profile'                => {optional => 1},
                               'color-rendering'              => {optional => 1},
                               'cursor'                       => {optional => 1},
                               'd'                            => {optional => 1},
                               'direction'                    => {optional => 1},
                               'display'                      => {optional => 1},
                               'dominant-baseline'            => {optional => 1},
                               'enable-background'            => {optional => 1},
                               'fill'                         => {optional => 1},
                               'fill-opacity'                 => {optional => 1},
                               'fill-rule'                    => {optional => 1},
                               'filter'                       => {optional => 1},
                               'flood-color'                  => {optional => 1},
                               'flood-opacity'                => {optional => 1},
                               'font-family'                  => {optional => 1},
                               'font-size'                    => {optional => 1},
                               'font-size-adjust'             => {optional => 1},
                               'font-stretch'                 => {optional => 1},
                               'font-style'                   => {optional => 1},
                               'font-variant'                 => {optional => 1},
                               'font-weight'                  => {optional => 1},
                               'glyph-name'                   => {optional => 1},
                               'glyph-orientation-horizontal' => {optional => 1},
                               'glyph-orientation-vertical'   => {optional => 1},
                               'horiz-adv-x'                  => {optional => 1},
                               'id'                           => {optional => 1},
                               'image-rendering'              => {optional => 1},
                               'kerning'                      => {optional => 1},
                               'lang'                         => {optional => 1},
                               'letter-spacing'               => {optional => 1},
                               'lighting-color'               => {optional => 1},
                               'marker-end'                   => {optional => 1},
                               'marker-mid'                   => {optional => 1},
                               'marker-start'                 => {optional => 1},
                               'mask'                         => {optional => 1},
                               'opacity'                      => {optional => 1},
                               'orientation'                  => {optional => 1},
                               'overflow'                     => {optional => 1},
                               'pointer-events'               => {optional => 1},
                               'shape-rendering'              => {optional => 1},
                               'stop-color'                   => {optional => 1},
                               'stop-opacity'                 => {optional => 1},
                               'stroke'                       => {optional => 1},
                               'stroke-dasharray'             => {optional => 1},
                               'stroke-dashoffset'            => {optional => 1},
                               'stroke-linecap'               => {optional => 1},
                               'stroke-linejoin'              => {optional => 1},
                               'stroke-miterlimit'            => {optional => 1},
                               'stroke-opacity'               => {optional => 1},
                               'stroke-width'                 => {optional => 1},
                               'style'                        => {optional => 1},
                               'text-anchor'                  => {optional => 1},
                               'text-decoration'              => {optional => 1},
                               'text-rendering'               => {optional => 1},
                               'unicode'                      => {optional => 1},
                               'unicode-bidi'                 => {optional => 1},
                               'vert-adv-y'                   => {optional => 1},
                               'vert-origin-x'                => {optional => 1},
                               'vert-origin-y'                => {optional => 1},
                               'visibility'                   => {optional => 1},
                               'word-spacing'                 => {optional => 1},
                               'writing-mode'                 => {optional => 1},
                               'xml:base'                     => {optional => 1},
                               'xml:lang'                     => {optional => 1},
                               'xml:space'                    => {optional => 1}},
     'glyphRef'            => {'class'                        => {optional => 1},
                               'dx'                           => {optional => 1},
                               'dy'                           => {optional => 1},
                               'font-family'                  => {optional => 1},
                               'font-size'                    => {optional => 1},
                               'font-size-adjust'             => {optional => 1},
                               'font-stretch'                 => {optional => 1},
                               'font-style'                   => {optional => 1},
                               'font-variant'                 => {optional => 1},
                               'font-weight'                  => {optional => 1},
                               'format'                       => {optional => 1},
                               'glyphRef'                     => {optional => 1},
                               'id'                           => {optional => 1},
                               'style'                        => {optional => 1},
                               'x'                            => {optional => 1},
                               'xlink:actuate'                => {default  => 'onLoad'},
                               'xlink:arcrole'                => {optional => 1},
                               'xlink:href'                   => {optional => 1},
                               'xlink:role'                   => {optional => 1},
                               'xlink:show'                   => {default  => 'other'},
                               'xlink:title'                  => {optional => 1},
                               'xlink:type'                   => {default  => 'simple'},
                               'xml:base'                     => {optional => 1},
                               'xml:lang'                     => {optional => 1},
                               'xml:space'                    => {optional => 1},
                               'xmlns:xlink'                  => {default  => 'http://www.w3.org/1999/xlink'},
                               'y'                            => {optional => 1}},
     'hkern'               => {'g1'                           => {optional => 1},
                               'g2'                           => {optional => 1},
                               'id'                           => {optional => 1},
                               'k'                            => {optional => 0},
                               'u1'                           => {optional => 1},
                               'u2'                           => {optional => 1},
                               'xml:base'                     => {optional => 1},
                               'xml:lang'                     => {optional => 1},
                               'xml:space'                    => {optional => 1}},
     'image'               => {'class'                        => {optional => 1},
                               'clip'                         => {optional => 1},
                               'clip-path'                    => {optional => 1},
                               'clip-rule'                    => {optional => 1},
                               'color'                        => {optional => 1},
                               'color-interpolation'          => {optional => 1},
                               'color-profile'                => {optional => 1},
                               'color-rendering'              => {optional => 1},
                               'cursor'                       => {optional => 1},
                               'display'                      => {optional => 1},
                               'externalResourcesRequired'    => {optional => 1},
                               'fill-opacity'                 => {optional => 1},
                               'filter'                       => {optional => 1},
                               'height'                       => {optional => 0},
                               'id'                           => {optional => 1},
                               'image-rendering'              => {optional => 1},
                               'mask'                         => {optional => 1},
                               'onactivate'                   => {optional => 1},
                               'onclick'                      => {optional => 1},
                               'onfocusin'                    => {optional => 1},
                               'onfocusout'                   => {optional => 1},
                               'onload'                       => {optional => 1},
                               'onmousedown'                  => {optional => 1},
                               'onmousemove'                  => {optional => 1},
                               'onmouseout'                   => {optional => 1},
                               'onmouseover'                  => {optional => 1},
                               'onmouseup'                    => {optional => 1},
                               'opacity'                      => {optional => 1},
                               'overflow'                     => {optional => 1},
                               'pointer-events'               => {optional => 1},
                               'preserveAspectRatio'          => {default  => 'xMidYMid meet'},
                               'requiredExtensions'           => {optional => 1},
                               'requiredFeatures'             => {optional => 1},
                               'shape-rendering'              => {optional => 1},
                               'stroke-opacity'               => {optional => 1},
                               'style'                        => {optional => 1},
                               'systemLanguage'               => {optional => 1},
                               'text-rendering'               => {optional => 1},
                               'transform'                    => {optional => 1},
                               'visibility'                   => {optional => 1},
                               'width'                        => {optional => 0},
                               'x'                            => {optional => 1},
                               'xlink:actuate'                => {default  => 'onLoad'},
                               'xlink:arcrole'                => {optional => 1},
                               'xlink:href'                   => {optional => 0},
                               'xlink:role'                   => {optional => 1},
                               'xlink:show'                   => {default  => 'embed'},
                               'xlink:title'                  => {optional => 1},
                               'xlink:type'                   => {default  => 'simple'},
                               'xml:base'                     => {optional => 1},
                               'xml:lang'                     => {optional => 1},
                               'xml:space'                    => {optional => 1},
                               'xmlns:xlink'                  => {default  => 'http://www.w3.org/1999/xlink'},
                               'y'                            => {optional => 1}},
     'line'                => {'class'                        => {optional => 1},
                               'clip-path'                    => {optional => 1},
                               'clip-rule'                    => {optional => 1},
                               'color'                        => {optional => 1},
                               'color-interpolation'          => {optional => 1},
                               'color-rendering'              => {optional => 1},
                               'cursor'                       => {optional => 1},
                               'display'                      => {optional => 1},
                               'externalResourcesRequired'    => {optional => 1},
                               'fill'                         => {optional => 1},
                               'fill-opacity'                 => {optional => 1},
                               'fill-rule'                    => {optional => 1},
                               'filter'                       => {optional => 1},
                               'id'                           => {optional => 1},
                               'image-rendering'              => {optional => 1},
                               'marker-end'                   => {optional => 1},
                               'marker-mid'                   => {optional => 1},
                               'marker-start'                 => {optional => 1},
                               'mask'                         => {optional => 1},
                               'onactivate'                   => {optional => 1},
                               'onclick'                      => {optional => 1},
                               'onfocusin'                    => {optional => 1},
                               'onfocusout'                   => {optional => 1},
                               'onload'                       => {optional => 1},
                               'onmousedown'                  => {optional => 1},
                               'onmousemove'                  => {optional => 1},
                               'onmouseout'                   => {optional => 1},
                               'onmouseover'                  => {optional => 1},
                               'onmouseup'                    => {optional => 1},
                               'opacity'                      => {optional => 1},
                               'pointer-events'               => {optional => 1},
                               'requiredExtensions'           => {optional => 1},
                               'requiredFeatures'             => {optional => 1},
                               'shape-rendering'              => {optional => 1},
                               'stroke'                       => {optional => 1},
                               'stroke-dasharray'             => {optional => 1},
                               'stroke-dashoffset'            => {optional => 1},
                               'stroke-linecap'               => {optional => 1},
                               'stroke-linejoin'              => {optional => 1},
                               'stroke-miterlimit'            => {optional => 1},
                               'stroke-opacity'               => {optional => 1},
                               'stroke-width'                 => {optional => 1},
                               'style'                        => {optional => 1},
                               'systemLanguage'               => {optional => 1},
                               'text-rendering'               => {optional => 1},
                               'transform'                    => {optional => 1},
                               'visibility'                   => {optional => 1},
                               'x1'                           => {optional => 1},
                               'x2'                           => {optional => 1},
                               'xml:base'                     => {optional => 1},
                               'xml:lang'                     => {optional => 1},
                               'xml:space'                    => {optional => 1},
                               'y1'                           => {optional => 1},
                               'y2'                           => {optional => 1}},
     'linearGradient'      => {'class'                        => {optional => 1},
                               'color'                        => {optional => 1},
                               'color-interpolation'          => {optional => 1},
                               'color-rendering'              => {optional => 1},
                               'externalResourcesRequired'    => {optional => 1},
                               'gradientTransform'            => {optional => 1},
                               'gradientUnits'                => {optional => 1},
                               'id'                           => {optional => 1},
                               'spreadMethod'                 => {optional => 1},
                               'stop-color'                   => {optional => 1},
                               'stop-opacity'                 => {optional => 1},
                               'style'                        => {optional => 1},
                               'x1'                           => {optional => 1},
                               'x2'                           => {optional => 1},
                               'xlink:actuate'                => {default  => 'onLoad'},
                               'xlink:arcrole'                => {optional => 1},
                               'xlink:href'                   => {optional => 1},
                               'xlink:role'                   => {optional => 1},
                               'xlink:show'                   => {default  => 'other'},
                               'xlink:title'                  => {optional => 1},
                               'xlink:type'                   => {default  => 'simple'},
                               'xml:base'                     => {optional => 1},
                               'xml:lang'                     => {optional => 1},
                               'xml:space'                    => {optional => 1},
                               'xmlns:xlink'                  => {default  => 'http://www.w3.org/1999/xlink'},
                               'y1'                           => {optional => 1},
                               'y2'                           => {optional => 1}},
     'marker'              => {'alignment-baseline'           => {optional => 1},
                               'baseline-shift'               => {optional => 1},
                               'class'                        => {optional => 1},
                               'clip'                         => {optional => 1},
                               'clip-path'                    => {optional => 1},
                               'clip-rule'                    => {optional => 1},
                               'color'                        => {optional => 1},
                               'color-interpolation'          => {optional => 1},
                               'color-interpolation-filters'  => {optional => 1},
                               'color-profile'                => {optional => 1},
                               'color-rendering'              => {optional => 1},
                               'cursor'                       => {optional => 1},
                               'direction'                    => {optional => 1},
                               'display'                      => {optional => 1},
                               'dominant-baseline'            => {optional => 1},
                               'enable-background'            => {optional => 1},
                               'externalResourcesRequired'    => {optional => 1},
                               'fill'                         => {optional => 1},
                               'fill-opacity'                 => {optional => 1},
                               'fill-rule'                    => {optional => 1},
                               'filter'                       => {optional => 1},
                               'flood-color'                  => {optional => 1},
                               'flood-opacity'                => {optional => 1},
                               'font-family'                  => {optional => 1},
                               'font-size'                    => {optional => 1},
                               'font-size-adjust'             => {optional => 1},
                               'font-stretch'                 => {optional => 1},
                               'font-style'                   => {optional => 1},
                               'font-variant'                 => {optional => 1},
                               'font-weight'                  => {optional => 1},
                               'glyph-orientation-horizontal' => {optional => 1},
                               'glyph-orientation-vertical'   => {optional => 1},
                               'id'                           => {optional => 1},
                               'image-rendering'              => {optional => 1},
                               'kerning'                      => {optional => 1},
                               'letter-spacing'               => {optional => 1},
                               'lighting-color'               => {optional => 1},
                               'marker-end'                   => {optional => 1},
                               'marker-mid'                   => {optional => 1},
                               'marker-start'                 => {optional => 1},
                               'markerHeight'                 => {optional => 1},
                               'markerUnits'                  => {optional => 1},
                               'markerWidth'                  => {optional => 1},
                               'mask'                         => {optional => 1},
                               'opacity'                      => {optional => 1},
                               'orient'                       => {optional => 1},
                               'overflow'                     => {optional => 1},
                               'pointer-events'               => {optional => 1},
                               'preserveAspectRatio'          => {default  => 'xMidYMid meet'},
                               'refX'                         => {optional => 1},
                               'refY'                         => {optional => 1},
                               'shape-rendering'              => {optional => 1},
                               'stop-color'                   => {optional => 1},
                               'stop-opacity'                 => {optional => 1},
                               'stroke'                       => {optional => 1},
                               'stroke-dasharray'             => {optional => 1},
                               'stroke-dashoffset'            => {optional => 1},
                               'stroke-linecap'               => {optional => 1},
                               'stroke-linejoin'              => {optional => 1},
                               'stroke-miterlimit'            => {optional => 1},
                               'stroke-opacity'               => {optional => 1},
                               'stroke-width'                 => {optional => 1},
                               'style'                        => {optional => 1},
                               'text-anchor'                  => {optional => 1},
                               'text-decoration'              => {optional => 1},
                               'text-rendering'               => {optional => 1},
                               'unicode-bidi'                 => {optional => 1},
                               'viewBox'                      => {optional => 1},
                               'visibility'                   => {optional => 1},
                               'word-spacing'                 => {optional => 1},
                               'writing-mode'                 => {optional => 1},
                               'xml:base'                     => {optional => 1},
                               'xml:lang'                     => {optional => 1},
                               'xml:space'                    => {optional => 1}},
     'mask'                => {'alignment-baseline'           => {optional => 1},
                               'baseline-shift'               => {optional => 1},
                               'class'                        => {optional => 1},
                               'clip'                         => {optional => 1},
                               'clip-path'                    => {optional => 1},
                               'clip-rule'                    => {optional => 1},
                               'color'                        => {optional => 1},
                               'color-interpolation'          => {optional => 1},
                               'color-interpolation-filters'  => {optional => 1},
                               'color-profile'                => {optional => 1},
                               'color-rendering'              => {optional => 1},
                               'cursor'                       => {optional => 1},
                               'direction'                    => {optional => 1},
                               'display'                      => {optional => 1},
                               'dominant-baseline'            => {optional => 1},
                               'enable-background'            => {optional => 1},
                               'externalResourcesRequired'    => {optional => 1},
                               'fill'                         => {optional => 1},
                               'fill-opacity'                 => {optional => 1},
                               'fill-rule'                    => {optional => 1},
                               'filter'                       => {optional => 1},
                               'flood-color'                  => {optional => 1},
                               'flood-opacity'                => {optional => 1},
                               'font-family'                  => {optional => 1},
                               'font-size'                    => {optional => 1},
                               'font-size-adjust'             => {optional => 1},
                               'font-stretch'                 => {optional => 1},
                               'font-style'                   => {optional => 1},
                               'font-variant'                 => {optional => 1},
                               'font-weight'                  => {optional => 1},
                               'glyph-orientation-horizontal' => {optional => 1},
                               'glyph-orientation-vertical'   => {optional => 1},
                               'height'                       => {optional => 1},
                               'id'                           => {optional => 1},
                               'image-rendering'              => {optional => 1},
                               'kerning'                      => {optional => 1},
                               'letter-spacing'               => {optional => 1},
                               'lighting-color'               => {optional => 1},
                               'marker-end'                   => {optional => 1},
                               'marker-mid'                   => {optional => 1},
                               'marker-start'                 => {optional => 1},
                               'mask'                         => {optional => 1},
                               'maskContentUnits'             => {optional => 1},
                               'maskUnits'                    => {optional => 1},
                               'opacity'                      => {optional => 1},
                               'overflow'                     => {optional => 1},
                               'pointer-events'               => {optional => 1},
                               'requiredExtensions'           => {optional => 1},
                               'requiredFeatures'             => {optional => 1},
                               'shape-rendering'              => {optional => 1},
                               'stop-color'                   => {optional => 1},
                               'stop-opacity'                 => {optional => 1},
                               'stroke'                       => {optional => 1},
                               'stroke-dasharray'             => {optional => 1},
                               'stroke-dashoffset'            => {optional => 1},
                               'stroke-linecap'               => {optional => 1},
                               'stroke-linejoin'              => {optional => 1},
                               'stroke-miterlimit'            => {optional => 1},
                               'stroke-opacity'               => {optional => 1},
                               'stroke-width'                 => {optional => 1},
                               'style'                        => {optional => 1},
                               'systemLanguage'               => {optional => 1},
                               'text-anchor'                  => {optional => 1},
                               'text-decoration'              => {optional => 1},
                               'text-rendering'               => {optional => 1},
                               'unicode-bidi'                 => {optional => 1},
                               'visibility'                   => {optional => 1},
                               'width'                        => {optional => 1},
                               'word-spacing'                 => {optional => 1},
                               'writing-mode'                 => {optional => 1},
                               'x'                            => {optional => 1},
                               'xml:base'                     => {optional => 1},
                               'xml:lang'                     => {optional => 1},
                               'xml:space'                    => {optional => 1},
                               'y'                            => {optional => 1}},
     'metadata'            => {'id'                           => {optional => 1},
                               'xml:base'                     => {optional => 1},
                               'xml:lang'                     => {optional => 1},
                               'xml:space'                    => {optional => 1}},
     'missing-glyph'       => {'alignment-baseline'           => {optional => 1},
                               'baseline-shift'               => {optional => 1},
                               'class'                        => {optional => 1},
                               'clip'                         => {optional => 1},
                               'clip-path'                    => {optional => 1},
                               'clip-rule'                    => {optional => 1},
                               'color'                        => {optional => 1},
                               'color-interpolation'          => {optional => 1},
                               'color-interpolation-filters'  => {optional => 1},
                               'color-profile'                => {optional => 1},
                               'color-rendering'              => {optional => 1},
                               'cursor'                       => {optional => 1},
                               'd'                            => {optional => 1},
                               'direction'                    => {optional => 1},
                               'display'                      => {optional => 1},
                               'dominant-baseline'            => {optional => 1},
                               'enable-background'            => {optional => 1},
                               'fill'                         => {optional => 1},
                               'fill-opacity'                 => {optional => 1},
                               'fill-rule'                    => {optional => 1},
                               'filter'                       => {optional => 1},
                               'flood-color'                  => {optional => 1},
                               'flood-opacity'                => {optional => 1},
                               'font-family'                  => {optional => 1},
                               'font-size'                    => {optional => 1},
                               'font-size-adjust'             => {optional => 1},
                               'font-stretch'                 => {optional => 1},
                               'font-style'                   => {optional => 1},
                               'font-variant'                 => {optional => 1},
                               'font-weight'                  => {optional => 1},
                               'glyph-orientation-horizontal' => {optional => 1},
                               'glyph-orientation-vertical'   => {optional => 1},
                               'horiz-adv-x'                  => {optional => 1},
                               'id'                           => {optional => 1},
                               'image-rendering'              => {optional => 1},
                               'kerning'                      => {optional => 1},
                               'letter-spacing'               => {optional => 1},
                               'lighting-color'               => {optional => 1},
                               'marker-end'                   => {optional => 1},
                               'marker-mid'                   => {optional => 1},
                               'marker-start'                 => {optional => 1},
                               'mask'                         => {optional => 1},
                               'opacity'                      => {optional => 1},
                               'overflow'                     => {optional => 1},
                               'pointer-events'               => {optional => 1},
                               'shape-rendering'              => {optional => 1},
                               'stop-color'                   => {optional => 1},
                               'stop-opacity'                 => {optional => 1},
                               'stroke'                       => {optional => 1},
                               'stroke-dasharray'             => {optional => 1},
                               'stroke-dashoffset'            => {optional => 1},
                               'stroke-linecap'               => {optional => 1},
                               'stroke-linejoin'              => {optional => 1},
                               'stroke-miterlimit'            => {optional => 1},
                               'stroke-opacity'               => {optional => 1},
                               'stroke-width'                 => {optional => 1},
                               'style'                        => {optional => 1},
                               'text-anchor'                  => {optional => 1},
                               'text-decoration'              => {optional => 1},
                               'text-rendering'               => {optional => 1},
                               'unicode-bidi'                 => {optional => 1},
                               'vert-adv-y'                   => {optional => 1},
                               'vert-origin-x'                => {optional => 1},
                               'vert-origin-y'                => {optional => 1},
                               'visibility'                   => {optional => 1},
                               'word-spacing'                 => {optional => 1},
                               'writing-mode'                 => {optional => 1},
                               'xml:base'                     => {optional => 1},
                               'xml:lang'                     => {optional => 1},
                               'xml:space'                    => {optional => 1}},
     'mpath'               => {'externalResourcesRequired'    => {optional => 1},
                               'id'                           => {optional => 1},
                               'xlink:actuate'                => {default  => 'onLoad'},
                               'xlink:arcrole'                => {optional => 1},
                               'xlink:href'                   => {optional => 0},
                               'xlink:role'                   => {optional => 1},
                               'xlink:show'                   => {default  => 'other'},
                               'xlink:title'                  => {optional => 1},
                               'xlink:type'                   => {default  => 'simple'},
                               'xml:base'                     => {optional => 1},
                               'xml:lang'                     => {optional => 1},
                               'xml:space'                    => {optional => 1},
                               'xmlns:xlink'                  => {default  => 'http://www.w3.org/1999/xlink'}},
     'path'                => {'class'                        => {optional => 1},
                               'clip-path'                    => {optional => 1},
                               'clip-rule'                    => {optional => 1},
                               'color'                        => {optional => 1},
                               'color-interpolation'          => {optional => 1},
                               'color-rendering'              => {optional => 1},
                               'cursor'                       => {optional => 1},
                               'd'                            => {optional => 0},
                               'display'                      => {optional => 1},
                               'externalResourcesRequired'    => {optional => 1},
                               'fill'                         => {optional => 1},
                               'fill-opacity'                 => {optional => 1},
                               'fill-rule'                    => {optional => 1},
                               'filter'                       => {optional => 1},
                               'id'                           => {optional => 1},
                               'image-rendering'              => {optional => 1},
                               'marker-end'                   => {optional => 1},
                               'marker-mid'                   => {optional => 1},
                               'marker-start'                 => {optional => 1},
                               'mask'                         => {optional => 1},
                               'onactivate'                   => {optional => 1},
                               'onclick'                      => {optional => 1},
                               'onfocusin'                    => {optional => 1},
                               'onfocusout'                   => {optional => 1},
                               'onload'                       => {optional => 1},
                               'onmousedown'                  => {optional => 1},
                               'onmousemove'                  => {optional => 1},
                               'onmouseout'                   => {optional => 1},
                               'onmouseover'                  => {optional => 1},
                               'onmouseup'                    => {optional => 1},
                               'opacity'                      => {optional => 1},
                               'pathLength'                   => {optional => 1},
                               'pointer-events'               => {optional => 1},
                               'requiredExtensions'           => {optional => 1},
                               'requiredFeatures'             => {optional => 1},
                               'shape-rendering'              => {optional => 1},
                               'stroke'                       => {optional => 1},
                               'stroke-dasharray'             => {optional => 1},
                               'stroke-dashoffset'            => {optional => 1},
                               'stroke-linecap'               => {optional => 1},
                               'stroke-linejoin'              => {optional => 1},
                               'stroke-miterlimit'            => {optional => 1},
                               'stroke-opacity'               => {optional => 1},
                               'stroke-width'                 => {optional => 1},
                               'style'                        => {optional => 1},
                               'systemLanguage'               => {optional => 1},
                               'text-rendering'               => {optional => 1},
                               'transform'                    => {optional => 1},
                               'visibility'                   => {optional => 1},
                               'xml:base'                     => {optional => 1},
                               'xml:lang'                     => {optional => 1},
                               'xml:space'                    => {optional => 1}},
     'pattern'             => {'alignment-baseline'           => {optional => 1},
                               'baseline-shift'               => {optional => 1},
                               'class'                        => {optional => 1},
                               'clip'                         => {optional => 1},
                               'clip-path'                    => {optional => 1},
                               'clip-rule'                    => {optional => 1},
                               'color'                        => {optional => 1},
                               'color-interpolation'          => {optional => 1},
                               'color-interpolation-filters'  => {optional => 1},
                               'color-profile'                => {optional => 1},
                               'color-rendering'              => {optional => 1},
                               'cursor'                       => {optional => 1},
                               'direction'                    => {optional => 1},
                               'display'                      => {optional => 1},
                               'dominant-baseline'            => {optional => 1},
                               'enable-background'            => {optional => 1},
                               'externalResourcesRequired'    => {optional => 1},
                               'fill'                         => {optional => 1},
                               'fill-opacity'                 => {optional => 1},
                               'fill-rule'                    => {optional => 1},
                               'filter'                       => {optional => 1},
                               'flood-color'                  => {optional => 1},
                               'flood-opacity'                => {optional => 1},
                               'font-family'                  => {optional => 1},
                               'font-size'                    => {optional => 1},
                               'font-size-adjust'             => {optional => 1},
                               'font-stretch'                 => {optional => 1},
                               'font-style'                   => {optional => 1},
                               'font-variant'                 => {optional => 1},
                               'font-weight'                  => {optional => 1},
                               'glyph-orientation-horizontal' => {optional => 1},
                               'glyph-orientation-vertical'   => {optional => 1},
                               'height'                       => {optional => 1},
                               'id'                           => {optional => 1},
                               'image-rendering'              => {optional => 1},
                               'kerning'                      => {optional => 1},
                               'letter-spacing'               => {optional => 1},
                               'lighting-color'               => {optional => 1},
                               'marker-end'                   => {optional => 1},
                               'marker-mid'                   => {optional => 1},
                               'marker-start'                 => {optional => 1},
                               'mask'                         => {optional => 1},
                               'opacity'                      => {optional => 1},
                               'overflow'                     => {optional => 1},
                               'patternContentUnits'          => {optional => 1},
                               'patternTransform'             => {optional => 1},
                               'patternUnits'                 => {optional => 1},
                               'pointer-events'               => {optional => 1},
                               'preserveAspectRatio'          => {default  => 'xMidYMid meet'},
                               'requiredExtensions'           => {optional => 1},
                               'requiredFeatures'             => {optional => 1},
                               'shape-rendering'              => {optional => 1},
                               'stop-color'                   => {optional => 1},
                               'stop-opacity'                 => {optional => 1},
                               'stroke'                       => {optional => 1},
                               'stroke-dasharray'             => {optional => 1},
                               'stroke-dashoffset'            => {optional => 1},
                               'stroke-linecap'               => {optional => 1},
                               'stroke-linejoin'              => {optional => 1},
                               'stroke-miterlimit'            => {optional => 1},
                               'stroke-opacity'               => {optional => 1},
                               'stroke-width'                 => {optional => 1},
                               'style'                        => {optional => 1},
                               'systemLanguage'               => {optional => 1},
                               'text-anchor'                  => {optional => 1},
                               'text-decoration'              => {optional => 1},
                               'text-rendering'               => {optional => 1},
                               'unicode-bidi'                 => {optional => 1},
                               'viewBox'                      => {optional => 1},
                               'visibility'                   => {optional => 1},
                               'width'                        => {optional => 1},
                               'word-spacing'                 => {optional => 1},
                               'writing-mode'                 => {optional => 1},
                               'x'                            => {optional => 1},
                               'xlink:actuate'                => {default  => 'onLoad'},
                               'xlink:arcrole'                => {optional => 1},
                               'xlink:href'                   => {optional => 1},
                               'xlink:role'                   => {optional => 1},
                               'xlink:show'                   => {default  => 'other'},
                               'xlink:title'                  => {optional => 1},
                               'xlink:type'                   => {default  => 'simple'},
                               'xml:base'                     => {optional => 1},
                               'xml:lang'                     => {optional => 1},
                               'xml:space'                    => {optional => 1},
                               'xmlns:xlink'                  => {default  => 'http://www.w3.org/1999/xlink'},
                               'y'                            => {optional => 1}},
     'polygon'             => {'class'                        => {optional => 1},
                               'clip-path'                    => {optional => 1},
                               'clip-rule'                    => {optional => 1},
                               'color'                        => {optional => 1},
                               'color-interpolation'          => {optional => 1},
                               'color-rendering'              => {optional => 1},
                               'cursor'                       => {optional => 1},
                               'display'                      => {optional => 1},
                               'externalResourcesRequired'    => {optional => 1},
                               'fill'                         => {optional => 1},
                               'fill-opacity'                 => {optional => 1},
                               'fill-rule'                    => {optional => 1},
                               'filter'                       => {optional => 1},
                               'id'                           => {optional => 1},
                               'image-rendering'              => {optional => 1},
                               'marker-end'                   => {optional => 1},
                               'marker-mid'                   => {optional => 1},
                               'marker-start'                 => {optional => 1},
                               'mask'                         => {optional => 1},
                               'onactivate'                   => {optional => 1},
                               'onclick'                      => {optional => 1},
                               'onfocusin'                    => {optional => 1},
                               'onfocusout'                   => {optional => 1},
                               'onload'                       => {optional => 1},
                               'onmousedown'                  => {optional => 1},
                               'onmousemove'                  => {optional => 1},
                               'onmouseout'                   => {optional => 1},
                               'onmouseover'                  => {optional => 1},
                               'onmouseup'                    => {optional => 1},
                               'opacity'                      => {optional => 1},
                               'pointer-events'               => {optional => 1},
                               'points'                       => {optional => 0},
                               'requiredExtensions'           => {optional => 1},
                               'requiredFeatures'             => {optional => 1},
                               'shape-rendering'              => {optional => 1},
                               'stroke'                       => {optional => 1},
                               'stroke-dasharray'             => {optional => 1},
                               'stroke-dashoffset'            => {optional => 1},
                               'stroke-linecap'               => {optional => 1},
                               'stroke-linejoin'              => {optional => 1},
                               'stroke-miterlimit'            => {optional => 1},
                               'stroke-opacity'               => {optional => 1},
                               'stroke-width'                 => {optional => 1},
                               'style'                        => {optional => 1},
                               'systemLanguage'               => {optional => 1},
                               'text-rendering'               => {optional => 1},
                               'transform'                    => {optional => 1},
                               'visibility'                   => {optional => 1},
                               'xml:base'                     => {optional => 1},
                               'xml:lang'                     => {optional => 1},
                               'xml:space'                    => {optional => 1}},
     'polyline'            => {'class'                        => {optional => 1},
                               'clip-path'                    => {optional => 1},
                               'clip-rule'                    => {optional => 1},
                               'color'                        => {optional => 1},
                               'color-interpolation'          => {optional => 1},
                               'color-rendering'              => {optional => 1},
                               'cursor'                       => {optional => 1},
                               'display'                      => {optional => 1},
                               'externalResourcesRequired'    => {optional => 1},
                               'fill'                         => {optional => 1},
                               'fill-opacity'                 => {optional => 1},
                               'fill-rule'                    => {optional => 1},
                               'filter'                       => {optional => 1},
                               'id'                           => {optional => 1},
                               'image-rendering'              => {optional => 1},
                               'marker-end'                   => {optional => 1},
                               'marker-mid'                   => {optional => 1},
                               'marker-start'                 => {optional => 1},
                               'mask'                         => {optional => 1},
                               'onactivate'                   => {optional => 1},
                               'onclick'                      => {optional => 1},
                               'onfocusin'                    => {optional => 1},
                               'onfocusout'                   => {optional => 1},
                               'onload'                       => {optional => 1},
                               'onmousedown'                  => {optional => 1},
                               'onmousemove'                  => {optional => 1},
                               'onmouseout'                   => {optional => 1},
                               'onmouseover'                  => {optional => 1},
                               'onmouseup'                    => {optional => 1},
                               'opacity'                      => {optional => 1},
                               'pointer-events'               => {optional => 1},
                               'points'                       => {optional => 0},
                               'requiredExtensions'           => {optional => 1},
                               'requiredFeatures'             => {optional => 1},
                               'shape-rendering'              => {optional => 1},
                               'stroke'                       => {optional => 1},
                               'stroke-dasharray'             => {optional => 1},
                               'stroke-dashoffset'            => {optional => 1},
                               'stroke-linecap'               => {optional => 1},
                               'stroke-linejoin'              => {optional => 1},
                               'stroke-miterlimit'            => {optional => 1},
                               'stroke-opacity'               => {optional => 1},
                               'stroke-width'                 => {optional => 1},
                               'style'                        => {optional => 1},
                               'systemLanguage'               => {optional => 1},
                               'text-rendering'               => {optional => 1},
                               'transform'                    => {optional => 1},
                               'visibility'                   => {optional => 1},
                               'xml:base'                     => {optional => 1},
                               'xml:lang'                     => {optional => 1},
                               'xml:space'                    => {optional => 1}},
     'radialGradient'      => {'class'                        => {optional => 1},
                               'color'                        => {optional => 1},
                               'color-interpolation'          => {optional => 1},
                               'color-rendering'              => {optional => 1},
                               'cx'                           => {optional => 1},
                               'cy'                           => {optional => 1},
                               'externalResourcesRequired'    => {optional => 1},
                               'fx'                           => {optional => 1},
                               'fy'                           => {optional => 1},
                               'gradientTransform'            => {optional => 1},
                               'gradientUnits'                => {optional => 1},
                               'id'                           => {optional => 1},
                               'r'                            => {optional => 1},
                               'spreadMethod'                 => {optional => 1},
                               'stop-color'                   => {optional => 1},
                               'stop-opacity'                 => {optional => 1},
                               'style'                        => {optional => 1},
                               'xlink:actuate'                => {default  => 'onLoad'},
                               'xlink:arcrole'                => {optional => 1},
                               'xlink:href'                   => {optional => 1},
                               'xlink:role'                   => {optional => 1},
                               'xlink:show'                   => {default  => 'other'},
                               'xlink:title'                  => {optional => 1},
                               'xlink:type'                   => {default  => 'simple'},
                               'xml:base'                     => {optional => 1},
                               'xml:lang'                     => {optional => 1},
                               'xml:space'                    => {optional => 1},
                               'xmlns:xlink'                  => {default  => 'http://www.w3.org/1999/xlink'}},
     'rect'                => {'class'                        => {optional => 1},
                               'clip-path'                    => {optional => 1},
                               'clip-rule'                    => {optional => 1},
                               'color'                        => {optional => 1},
                               'color-interpolation'          => {optional => 1},
                               'color-rendering'              => {optional => 1},
                               'cursor'                       => {optional => 1},
                               'display'                      => {optional => 1},
                               'externalResourcesRequired'    => {optional => 1},
                               'fill'                         => {optional => 1},
                               'fill-opacity'                 => {optional => 1},
                               'fill-rule'                    => {optional => 1},
                               'filter'                       => {optional => 1},
                               'height'                       => {optional => 0},
                               'id'                           => {optional => 1},
                               'image-rendering'              => {optional => 1},
                               'mask'                         => {optional => 1},
                               'onactivate'                   => {optional => 1},
                               'onclick'                      => {optional => 1},
                               'onfocusin'                    => {optional => 1},
                               'onfocusout'                   => {optional => 1},
                               'onload'                       => {optional => 1},
                               'onmousedown'                  => {optional => 1},
                               'onmousemove'                  => {optional => 1},
                               'onmouseout'                   => {optional => 1},
                               'onmouseover'                  => {optional => 1},
                               'onmouseup'                    => {optional => 1},
                               'opacity'                      => {optional => 1},
                               'pointer-events'               => {optional => 1},
                               'requiredExtensions'           => {optional => 1},
                               'requiredFeatures'             => {optional => 1},
                               'rx'                           => {optional => 1},
                               'ry'                           => {optional => 1},
                               'shape-rendering'              => {optional => 1},
                               'stroke'                       => {optional => 1},
                               'stroke-dasharray'             => {optional => 1},
                               'stroke-dashoffset'            => {optional => 1},
                               'stroke-linecap'               => {optional => 1},
                               'stroke-linejoin'              => {optional => 1},
                               'stroke-miterlimit'            => {optional => 1},
                               'stroke-opacity'               => {optional => 1},
                               'stroke-width'                 => {optional => 1},
                               'style'                        => {optional => 1},
                               'systemLanguage'               => {optional => 1},
                               'text-rendering'               => {optional => 1},
                               'transform'                    => {optional => 1},
                               'visibility'                   => {optional => 1},
                               'width'                        => {optional => 0},
                               'x'                            => {optional => 1},
                               'xml:base'                     => {optional => 1},
                               'xml:lang'                     => {optional => 1},
                               'xml:space'                    => {optional => 1},
                               'y'                            => {optional => 1}},
     'script'              => {'externalResourcesRequired'    => {optional => 1},
                               'id'                           => {optional => 1},
                               'type'                         => {optional => 0},
                               'xlink:actuate'                => {default  => 'onLoad'},
                               'xlink:arcrole'                => {optional => 1},
                               'xlink:href'                   => {optional => 1},
                               'xlink:role'                   => {optional => 1},
                               'xlink:show'                   => {default  => 'other'},
                               'xlink:title'                  => {optional => 1},
                               'xlink:type'                   => {default  => 'simple'},
                               'xml:base'                     => {optional => 1},
                               'xml:lang'                     => {optional => 1},
                               'xml:space'                    => {optional => 1},
                               'xmlns:xlink'                  => {default  => 'http://www.w3.org/1999/xlink'}},
     'set'                 => {'attributeName'                => {optional => 0},
                               'attributeType'                => {optional => 1},
                               'begin'                        => {optional => 1},
                               'dur'                          => {optional => 1},
                               'end'                          => {optional => 1},
                               'externalResourcesRequired'    => {optional => 1},
                               'fill'                         => {default  => 'remove'},
                               'id'                           => {optional => 1},
                               'max'                          => {optional => 1},
                               'min'                          => {optional => 1},
                               'onbegin'                      => {optional => 1},
                               'onend'                        => {optional => 1},
                               'onload'                       => {optional => 1},
                               'onrepeat'                     => {optional => 1},
                               'repeatCount'                  => {optional => 1},
                               'repeatDur'                    => {optional => 1},
                               'requiredExtensions'           => {optional => 1},
                               'requiredFeatures'             => {optional => 1},
                               'restart'                      => {default  => 'always'},
                               'systemLanguage'               => {optional => 1},
                               'to'                           => {optional => 1},
                               'xlink:actuate'                => {default  => 'onLoad'},
                               'xlink:arcrole'                => {optional => 1},
                               'xlink:href'                   => {optional => 1},
                               'xlink:role'                   => {optional => 1},
                               'xlink:show'                   => {default  => 'other'},
                               'xlink:title'                  => {optional => 1},
                               'xlink:type'                   => {default  => 'simple'},
                               'xml:base'                     => {optional => 1},
                               'xml:lang'                     => {optional => 1},
                               'xml:space'                    => {optional => 1},
                               'xmlns:xlink'                  => {default  => 'http://www.w3.org/1999/xlink'}},
     'stop'                => {'class'                        => {optional => 1},
                               'color'                        => {optional => 1},
                               'color-interpolation'          => {optional => 1},
                               'color-rendering'              => {optional => 1},
                               'id'                           => {optional => 1},
                               'offset'                       => {optional => 0},
                               'stop-color'                   => {optional => 1},
                               'stop-opacity'                 => {optional => 1},
                               'style'                        => {optional => 1},
                               'xml:base'                     => {optional => 1},
                               'xml:lang'                     => {optional => 1},
                               'xml:space'                    => {optional => 1}},
     'style'               => {'id'                           => {optional => 1},
                               'media'                        => {optional => 1},
                               'title'                        => {optional => 1},
                               'type'                         => {optional => 0},
                               'xml:base'                     => {optional => 1},
                               'xml:lang'                     => {optional => 1},
                               'xml:space'                    => {default  => 'preserve'}},
     'svg'                 => {'alignment-baseline'           => {optional => 1},
                               'baseProfile'                  => {optional => 1},
                               'baseline-shift'               => {optional => 1},
                               'class'                        => {optional => 1},
                               'clip'                         => {optional => 1},
                               'clip-path'                    => {optional => 1},
                               'clip-rule'                    => {optional => 1},
                               'color'                        => {optional => 1},
                               'color-interpolation'          => {optional => 1},
                               'color-interpolation-filters'  => {optional => 1},
                               'color-profile'                => {optional => 1},
                               'color-rendering'              => {optional => 1},
                               'contentScriptType'            => {default  => 'text/ecmascript'},
                               'contentStyleType'             => {default  => 'text/css'},
                               'cursor'                       => {optional => 1},
                               'direction'                    => {optional => 1},
                               'display'                      => {optional => 1},
                               'dominant-baseline'            => {optional => 1},
                               'enable-background'            => {optional => 1},
                               'externalResourcesRequired'    => {optional => 1},
                               'fill'                         => {optional => 1},
                               'fill-opacity'                 => {optional => 1},
                               'fill-rule'                    => {optional => 1},
                               'filter'                       => {optional => 1},
                               'flood-color'                  => {optional => 1},
                               'flood-opacity'                => {optional => 1},
                               'font-family'                  => {optional => 1},
                               'font-size'                    => {optional => 1},
                               'font-size-adjust'             => {optional => 1},
                               'font-stretch'                 => {optional => 1},
                               'font-style'                   => {optional => 1},
                               'font-variant'                 => {optional => 1},
                               'font-weight'                  => {optional => 1},
                               'glyph-orientation-horizontal' => {optional => 1},
                               'glyph-orientation-vertical'   => {optional => 1},
                               'height'                       => {optional => 1},
                               'id'                           => {optional => 1},
                               'image-rendering'              => {optional => 1},
                               'kerning'                      => {optional => 1},
                               'letter-spacing'               => {optional => 1},
                               'lighting-color'               => {optional => 1},
                               'marker-end'                   => {optional => 1},
                               'marker-mid'                   => {optional => 1},
                               'marker-start'                 => {optional => 1},
                               'mask'                         => {optional => 1},
                               'onabort'                      => {optional => 1},
                               'onactivate'                   => {optional => 1},
                               'onclick'                      => {optional => 1},
                               'onerror'                      => {optional => 1},
                               'onfocusin'                    => {optional => 1},
                               'onfocusout'                   => {optional => 1},
                               'onload'                       => {optional => 1},
                               'onmousedown'                  => {optional => 1},
                               'onmousemove'                  => {optional => 1},
                               'onmouseout'                   => {optional => 1},
                               'onmouseover'                  => {optional => 1},
                               'onmouseup'                    => {optional => 1},
                               'onresize'                     => {optional => 1},
                               'onscroll'                     => {optional => 1},
                               'onunload'                     => {optional => 1},
                               'onzoom'                       => {optional => 1},
                               'opacity'                      => {optional => 1},
                               'overflow'                     => {optional => 1},
                               'pointer-events'               => {optional => 1},
                               'preserveAspectRatio'          => {default  => 'xMidYMid meet'},
                               'requiredExtensions'           => {optional => 1},
                               'requiredFeatures'             => {optional => 1},
                               'shape-rendering'              => {optional => 1},
                               'stop-color'                   => {optional => 1},
                               'stop-opacity'                 => {optional => 1},
                               'stroke'                       => {optional => 1},
                               'stroke-dasharray'             => {optional => 1},
                               'stroke-dashoffset'            => {optional => 1},
                               'stroke-linecap'               => {optional => 1},
                               'stroke-linejoin'              => {optional => 1},
                               'stroke-miterlimit'            => {optional => 1},
                               'stroke-opacity'               => {optional => 1},
                               'stroke-width'                 => {optional => 1},
                               'style'                        => {optional => 1},
                               'systemLanguage'               => {optional => 1},
                               'text-anchor'                  => {optional => 1},
                               'text-decoration'              => {optional => 1},
                               'text-rendering'               => {optional => 1},
                               'unicode-bidi'                 => {optional => 1},
                               'version'                      => {default  => '1.1'},
                               'viewBox'                      => {optional => 1},
                               'visibility'                   => {optional => 1},
                               'width'                        => {optional => 1},
                               'word-spacing'                 => {optional => 1},
                               'writing-mode'                 => {optional => 1},
                               'x'                            => {optional => 1},
                               'xml:base'                     => {optional => 1},
                               'xml:lang'                     => {optional => 1},
                               'xml:space'                    => {optional => 1},
                               'xmlns'                        => {default  => 'http://www.w3.org/2000/svg'},
                               'xmlns:xlink'                  => {default  => 'http://www.w3.org/1999/xlink'},
                               'y'                            => {optional => 1},
                               'zoomAndPan'                   => {default  => 'magnify'}},
     'switch'              => {'alignment-baseline'           => {optional => 1},
                               'baseline-shift'               => {optional => 1},
                               'class'                        => {optional => 1},
                               'clip'                         => {optional => 1},
                               'clip-path'                    => {optional => 1},
                               'clip-rule'                    => {optional => 1},
                               'color'                        => {optional => 1},
                               'color-interpolation'          => {optional => 1},
                               'color-interpolation-filters'  => {optional => 1},
                               'color-profile'                => {optional => 1},
                               'color-rendering'              => {optional => 1},
                               'cursor'                       => {optional => 1},
                               'direction'                    => {optional => 1},
                               'display'                      => {optional => 1},
                               'dominant-baseline'            => {optional => 1},
                               'enable-background'            => {optional => 1},
                               'externalResourcesRequired'    => {optional => 1},
                               'fill'                         => {optional => 1},
                               'fill-opacity'                 => {optional => 1},
                               'fill-rule'                    => {optional => 1},
                               'filter'                       => {optional => 1},
                               'flood-color'                  => {optional => 1},
                               'flood-opacity'                => {optional => 1},
                               'font-family'                  => {optional => 1},
                               'font-size'                    => {optional => 1},
                               'font-size-adjust'             => {optional => 1},
                               'font-stretch'                 => {optional => 1},
                               'font-style'                   => {optional => 1},
                               'font-variant'                 => {optional => 1},
                               'font-weight'                  => {optional => 1},
                               'glyph-orientation-horizontal' => {optional => 1},
                               'glyph-orientation-vertical'   => {optional => 1},
                               'id'                           => {optional => 1},
                               'image-rendering'              => {optional => 1},
                               'kerning'                      => {optional => 1},
                               'letter-spacing'               => {optional => 1},
                               'lighting-color'               => {optional => 1},
                               'marker-end'                   => {optional => 1},
                               'marker-mid'                   => {optional => 1},
                               'marker-start'                 => {optional => 1},
                               'mask'                         => {optional => 1},
                               'onactivate'                   => {optional => 1},
                               'onclick'                      => {optional => 1},
                               'onfocusin'                    => {optional => 1},
                               'onfocusout'                   => {optional => 1},
                               'onload'                       => {optional => 1},
                               'onmousedown'                  => {optional => 1},
                               'onmousemove'                  => {optional => 1},
                               'onmouseout'                   => {optional => 1},
                               'onmouseover'                  => {optional => 1},
                               'onmouseup'                    => {optional => 1},
                               'opacity'                      => {optional => 1},
                               'overflow'                     => {optional => 1},
                               'pointer-events'               => {optional => 1},
                               'requiredExtensions'           => {optional => 1},
                               'requiredFeatures'             => {optional => 1},
                               'shape-rendering'              => {optional => 1},
                               'stop-color'                   => {optional => 1},
                               'stop-opacity'                 => {optional => 1},
                               'stroke'                       => {optional => 1},
                               'stroke-dasharray'             => {optional => 1},
                               'stroke-dashoffset'            => {optional => 1},
                               'stroke-linecap'               => {optional => 1},
                               'stroke-linejoin'              => {optional => 1},
                               'stroke-miterlimit'            => {optional => 1},
                               'stroke-opacity'               => {optional => 1},
                               'stroke-width'                 => {optional => 1},
                               'style'                        => {optional => 1},
                               'systemLanguage'               => {optional => 1},
                               'text-anchor'                  => {optional => 1},
                               'text-decoration'              => {optional => 1},
                               'text-rendering'               => {optional => 1},
                               'transform'                    => {optional => 1},
                               'unicode-bidi'                 => {optional => 1},
                               'visibility'                   => {optional => 1},
                               'word-spacing'                 => {optional => 1},
                               'writing-mode'                 => {optional => 1},
                               'xml:base'                     => {optional => 1},
                               'xml:lang'                     => {optional => 1},
                               'xml:space'                    => {optional => 1}},
     'symbol'              => {'alignment-baseline'           => {optional => 1},
                               'baseline-shift'               => {optional => 1},
                               'class'                        => {optional => 1},
                               'clip'                         => {optional => 1},
                               'clip-path'                    => {optional => 1},
                               'clip-rule'                    => {optional => 1},
                               'color'                        => {optional => 1},
                               'color-interpolation'          => {optional => 1},
                               'color-interpolation-filters'  => {optional => 1},
                               'color-profile'                => {optional => 1},
                               'color-rendering'              => {optional => 1},
                               'cursor'                       => {optional => 1},
                               'direction'                    => {optional => 1},
                               'display'                      => {optional => 1},
                               'dominant-baseline'            => {optional => 1},
                               'enable-background'            => {optional => 1},
                               'externalResourcesRequired'    => {optional => 1},
                               'fill'                         => {optional => 1},
                               'fill-opacity'                 => {optional => 1},
                               'fill-rule'                    => {optional => 1},
                               'filter'                       => {optional => 1},
                               'flood-color'                  => {optional => 1},
                               'flood-opacity'                => {optional => 1},
                               'font-family'                  => {optional => 1},
                               'font-size'                    => {optional => 1},
                               'font-size-adjust'             => {optional => 1},
                               'font-stretch'                 => {optional => 1},
                               'font-style'                   => {optional => 1},
                               'font-variant'                 => {optional => 1},
                               'font-weight'                  => {optional => 1},
                               'glyph-orientation-horizontal' => {optional => 1},
                               'glyph-orientation-vertical'   => {optional => 1},
                               'id'                           => {optional => 1},
                               'image-rendering'              => {optional => 1},
                               'kerning'                      => {optional => 1},
                               'letter-spacing'               => {optional => 1},
                               'lighting-color'               => {optional => 1},
                               'marker-end'                   => {optional => 1},
                               'marker-mid'                   => {optional => 1},
                               'marker-start'                 => {optional => 1},
                               'mask'                         => {optional => 1},
                               'onactivate'                   => {optional => 1},
                               'onclick'                      => {optional => 1},
                               'onfocusin'                    => {optional => 1},
                               'onfocusout'                   => {optional => 1},
                               'onload'                       => {optional => 1},
                               'onmousedown'                  => {optional => 1},
                               'onmousemove'                  => {optional => 1},
                               'onmouseout'                   => {optional => 1},
                               'onmouseover'                  => {optional => 1},
                               'onmouseup'                    => {optional => 1},
                               'opacity'                      => {optional => 1},
                               'overflow'                     => {optional => 1},
                               'pointer-events'               => {optional => 1},
                               'preserveAspectRatio'          => {default  => 'xMidYMid meet'},
                               'shape-rendering'              => {optional => 1},
                               'stop-color'                   => {optional => 1},
                               'stop-opacity'                 => {optional => 1},
                               'stroke'                       => {optional => 1},
                               'stroke-dasharray'             => {optional => 1},
                               'stroke-dashoffset'            => {optional => 1},
                               'stroke-linecap'               => {optional => 1},
                               'stroke-linejoin'              => {optional => 1},
                               'stroke-miterlimit'            => {optional => 1},
                               'stroke-opacity'               => {optional => 1},
                               'stroke-width'                 => {optional => 1},
                               'style'                        => {optional => 1},
                               'text-anchor'                  => {optional => 1},
                               'text-decoration'              => {optional => 1},
                               'text-rendering'               => {optional => 1},
                               'unicode-bidi'                 => {optional => 1},
                               'viewBox'                      => {optional => 1},
                               'visibility'                   => {optional => 1},
                               'word-spacing'                 => {optional => 1},
                               'writing-mode'                 => {optional => 1},
                               'xml:base'                     => {optional => 1},
                               'xml:lang'                     => {optional => 1},
                               'xml:space'                    => {optional => 1}},
     'text'                => {'alignment-baseline'           => {optional => 1},
                               'baseline-shift'               => {optional => 1},
                               'class'                        => {optional => 1},
                               'clip-path'                    => {optional => 1},
                               'clip-rule'                    => {optional => 1},
                               'color'                        => {optional => 1},
                               'color-interpolation'          => {optional => 1},
                               'color-rendering'              => {optional => 1},
                               'cursor'                       => {optional => 1},
                               'direction'                    => {optional => 1},
                               'display'                      => {optional => 1},
                               'dominant-baseline'            => {optional => 1},
                               'dx'                           => {optional => 1},
                               'dy'                           => {optional => 1},
                               'externalResourcesRequired'    => {optional => 1},
                               'fill'                         => {optional => 1},
                               'fill-opacity'                 => {optional => 1},
                               'fill-rule'                    => {optional => 1},
                               'filter'                       => {optional => 1},
                               'font-family'                  => {optional => 1},
                               'font-size'                    => {optional => 1},
                               'font-size-adjust'             => {optional => 1},
                               'font-stretch'                 => {optional => 1},
                               'font-style'                   => {optional => 1},
                               'font-variant'                 => {optional => 1},
                               'font-weight'                  => {optional => 1},
                               'glyph-orientation-horizontal' => {optional => 1},
                               'glyph-orientation-vertical'   => {optional => 1},
                               'id'                           => {optional => 1},
                               'image-rendering'              => {optional => 1},
                               'kerning'                      => {optional => 1},
                               'lengthAdjust'                 => {optional => 1},
                               'letter-spacing'               => {optional => 1},
                               'mask'                         => {optional => 1},
                               'onactivate'                   => {optional => 1},
                               'onclick'                      => {optional => 1},
                               'onfocusin'                    => {optional => 1},
                               'onfocusout'                   => {optional => 1},
                               'onload'                       => {optional => 1},
                               'onmousedown'                  => {optional => 1},
                               'onmousemove'                  => {optional => 1},
                               'onmouseout'                   => {optional => 1},
                               'onmouseover'                  => {optional => 1},
                               'onmouseup'                    => {optional => 1},
                               'opacity'                      => {optional => 1},
                               'pointer-events'               => {optional => 1},
                               'requiredExtensions'           => {optional => 1},
                               'requiredFeatures'             => {optional => 1},
                               'rotate'                       => {optional => 1},
                               'shape-rendering'              => {optional => 1},
                               'stroke'                       => {optional => 1},
                               'stroke-dasharray'             => {optional => 1},
                               'stroke-dashoffset'            => {optional => 1},
                               'stroke-linecap'               => {optional => 1},
                               'stroke-linejoin'              => {optional => 1},
                               'stroke-miterlimit'            => {optional => 1},
                               'stroke-opacity'               => {optional => 1},
                               'stroke-width'                 => {optional => 1},
                               'style'                        => {optional => 1},
                               'systemLanguage'               => {optional => 1},
                               'text-anchor'                  => {optional => 1},
                               'text-decoration'              => {optional => 1},
                               'text-rendering'               => {optional => 1},
                               'textLength'                   => {optional => 1},
                               'transform'                    => {optional => 1},
                               'unicode-bidi'                 => {optional => 1},
                               'visibility'                   => {optional => 1},
                               'word-spacing'                 => {optional => 1},
                               'writing-mode'                 => {optional => 1},
                               'x'                            => {optional => 1},
                               'xml:base'                     => {optional => 1},
                               'xml:lang'                     => {optional => 1},
                               'xml:space'                    => {optional => 1},
                               'y'                            => {optional => 1}},
     'textPath'            => {'alignment-baseline'           => {optional => 1},
                               'baseline-shift'               => {optional => 1},
                               'class'                        => {optional => 1},
                               'clip-path'                    => {optional => 1},
                               'clip-rule'                    => {optional => 1},
                               'color'                        => {optional => 1},
                               'color-interpolation'          => {optional => 1},
                               'color-rendering'              => {optional => 1},
                               'cursor'                       => {optional => 1},
                               'direction'                    => {optional => 1},
                               'display'                      => {optional => 1},
                               'dominant-baseline'            => {optional => 1},
                               'externalResourcesRequired'    => {optional => 1},
                               'fill'                         => {optional => 1},
                               'fill-opacity'                 => {optional => 1},
                               'fill-rule'                    => {optional => 1},
                               'filter'                       => {optional => 1},
                               'font-family'                  => {optional => 1},
                               'font-size'                    => {optional => 1},
                               'font-size-adjust'             => {optional => 1},
                               'font-stretch'                 => {optional => 1},
                               'font-style'                   => {optional => 1},
                               'font-variant'                 => {optional => 1},
                               'font-weight'                  => {optional => 1},
                               'glyph-orientation-horizontal' => {optional => 1},
                               'glyph-orientation-vertical'   => {optional => 1},
                               'id'                           => {optional => 1},
                               'image-rendering'              => {optional => 1},
                               'kerning'                      => {optional => 1},
                               'lengthAdjust'                 => {optional => 1},
                               'letter-spacing'               => {optional => 1},
                               'mask'                         => {optional => 1},
                               'method'                       => {optional => 1},
                               'onactivate'                   => {optional => 1},
                               'onclick'                      => {optional => 1},
                               'onfocusin'                    => {optional => 1},
                               'onfocusout'                   => {optional => 1},
                               'onload'                       => {optional => 1},
                               'onmousedown'                  => {optional => 1},
                               'onmousemove'                  => {optional => 1},
                               'onmouseout'                   => {optional => 1},
                               'onmouseover'                  => {optional => 1},
                               'onmouseup'                    => {optional => 1},
                               'opacity'                      => {optional => 1},
                               'pointer-events'               => {optional => 1},
                               'requiredExtensions'           => {optional => 1},
                               'requiredFeatures'             => {optional => 1},
                               'shape-rendering'              => {optional => 1},
                               'spacing'                      => {optional => 1},
                               'startOffset'                  => {optional => 1},
                               'stroke'                       => {optional => 1},
                               'stroke-dasharray'             => {optional => 1},
                               'stroke-dashoffset'            => {optional => 1},
                               'stroke-linecap'               => {optional => 1},
                               'stroke-linejoin'              => {optional => 1},
                               'stroke-miterlimit'            => {optional => 1},
                               'stroke-opacity'               => {optional => 1},
                               'stroke-width'                 => {optional => 1},
                               'style'                        => {optional => 1},
                               'systemLanguage'               => {optional => 1},
                               'text-anchor'                  => {optional => 1},
                               'text-decoration'              => {optional => 1},
                               'text-rendering'               => {optional => 1},
                               'textLength'                   => {optional => 1},
                               'unicode-bidi'                 => {optional => 1},
                               'visibility'                   => {optional => 1},
                               'word-spacing'                 => {optional => 1},
                               'xlink:actuate'                => {default  => 'onLoad'},
                               'xlink:arcrole'                => {optional => 1},
                               'xlink:href'                   => {optional => 0},
                               'xlink:role'                   => {optional => 1},
                               'xlink:show'                   => {default  => 'other'},
                               'xlink:title'                  => {optional => 1},
                               'xlink:type'                   => {default  => 'simple'},
                               'xml:base'                     => {optional => 1},
                               'xml:lang'                     => {optional => 1},
                               'xml:space'                    => {optional => 1},
                               'xmlns:xlink'                  => {default  => 'http://www.w3.org/1999/xlink'}},
     'title'               => {'class'                        => {optional => 1},
                               'id'                           => {optional => 1},
                               'style'                        => {optional => 1},
                               'xml:base'                     => {optional => 1},
                               'xml:lang'                     => {optional => 1},
                               'xml:space'                    => {optional => 1}},
     'tref'                => {'alignment-baseline'           => {optional => 1},
                               'baseline-shift'               => {optional => 1},
                               'class'                        => {optional => 1},
                               'clip-path'                    => {optional => 1},
                               'clip-rule'                    => {optional => 1},
                               'color'                        => {optional => 1},
                               'color-interpolation'          => {optional => 1},
                               'color-rendering'              => {optional => 1},
                               'cursor'                       => {optional => 1},
                               'direction'                    => {optional => 1},
                               'display'                      => {optional => 1},
                               'dominant-baseline'            => {optional => 1},
                               'dx'                           => {optional => 1},
                               'dy'                           => {optional => 1},
                               'externalResourcesRequired'    => {optional => 1},
                               'fill'                         => {optional => 1},
                               'fill-opacity'                 => {optional => 1},
                               'fill-rule'                    => {optional => 1},
                               'filter'                       => {optional => 1},
                               'font-family'                  => {optional => 1},
                               'font-size'                    => {optional => 1},
                               'font-size-adjust'             => {optional => 1},
                               'font-stretch'                 => {optional => 1},
                               'font-style'                   => {optional => 1},
                               'font-variant'                 => {optional => 1},
                               'font-weight'                  => {optional => 1},
                               'glyph-orientation-horizontal' => {optional => 1},
                               'glyph-orientation-vertical'   => {optional => 1},
                               'id'                           => {optional => 1},
                               'image-rendering'              => {optional => 1},
                               'kerning'                      => {optional => 1},
                               'lengthAdjust'                 => {optional => 1},
                               'letter-spacing'               => {optional => 1},
                               'mask'                         => {optional => 1},
                               'onactivate'                   => {optional => 1},
                               'onclick'                      => {optional => 1},
                               'onfocusin'                    => {optional => 1},
                               'onfocusout'                   => {optional => 1},
                               'onload'                       => {optional => 1},
                               'onmousedown'                  => {optional => 1},
                               'onmousemove'                  => {optional => 1},
                               'onmouseout'                   => {optional => 1},
                               'onmouseover'                  => {optional => 1},
                               'onmouseup'                    => {optional => 1},
                               'opacity'                      => {optional => 1},
                               'pointer-events'               => {optional => 1},
                               'requiredExtensions'           => {optional => 1},
                               'requiredFeatures'             => {optional => 1},
                               'rotate'                       => {optional => 1},
                               'shape-rendering'              => {optional => 1},
                               'stroke'                       => {optional => 1},
                               'stroke-dasharray'             => {optional => 1},
                               'stroke-dashoffset'            => {optional => 1},
                               'stroke-linecap'               => {optional => 1},
                               'stroke-linejoin'              => {optional => 1},
                               'stroke-miterlimit'            => {optional => 1},
                               'stroke-opacity'               => {optional => 1},
                               'stroke-width'                 => {optional => 1},
                               'style'                        => {optional => 1},
                               'systemLanguage'               => {optional => 1},
                               'text-anchor'                  => {optional => 1},
                               'text-decoration'              => {optional => 1},
                               'text-rendering'               => {optional => 1},
                               'textLength'                   => {optional => 1},
                               'unicode-bidi'                 => {optional => 1},
                               'visibility'                   => {optional => 1},
                               'word-spacing'                 => {optional => 1},
                               'x'                            => {optional => 1},
                               'xlink:actuate'                => {default  => 'onLoad'},
                               'xlink:arcrole'                => {optional => 1},
                               'xlink:href'                   => {optional => 0},
                               'xlink:role'                   => {optional => 1},
                               'xlink:show'                   => {default  => 'other'},
                               'xlink:title'                  => {optional => 1},
                               'xlink:type'                   => {default  => 'simple'},
                               'xml:base'                     => {optional => 1},
                               'xml:lang'                     => {optional => 1},
                               'xml:space'                    => {optional => 1},
                               'xmlns:xlink'                  => {default  => 'http://www.w3.org/1999/xlink'},
                               'y'                            => {optional => 1}},
     'tspan'               => {'alignment-baseline'           => {optional => 1},
                               'baseline-shift'               => {optional => 1},
                               'class'                        => {optional => 1},
                               'clip-path'                    => {optional => 1},
                               'clip-rule'                    => {optional => 1},
                               'color'                        => {optional => 1},
                               'color-interpolation'          => {optional => 1},
                               'color-rendering'              => {optional => 1},
                               'cursor'                       => {optional => 1},
                               'direction'                    => {optional => 1},
                               'display'                      => {optional => 1},
                               'dominant-baseline'            => {optional => 1},
                               'dx'                           => {optional => 1},
                               'dy'                           => {optional => 1},
                               'externalResourcesRequired'    => {optional => 1},
                               'fill'                         => {optional => 1},
                               'fill-opacity'                 => {optional => 1},
                               'fill-rule'                    => {optional => 1},
                               'filter'                       => {optional => 1},
                               'font-family'                  => {optional => 1},
                               'font-size'                    => {optional => 1},
                               'font-size-adjust'             => {optional => 1},
                               'font-stretch'                 => {optional => 1},
                               'font-style'                   => {optional => 1},
                               'font-variant'                 => {optional => 1},
                               'font-weight'                  => {optional => 1},
                               'glyph-orientation-horizontal' => {optional => 1},
                               'glyph-orientation-vertical'   => {optional => 1},
                               'id'                           => {optional => 1},
                               'image-rendering'              => {optional => 1},
                               'kerning'                      => {optional => 1},
                               'lengthAdjust'                 => {optional => 1},
                               'letter-spacing'               => {optional => 1},
                               'mask'                         => {optional => 1},
                               'onactivate'                   => {optional => 1},
                               'onclick'                      => {optional => 1},
                               'onfocusin'                    => {optional => 1},
                               'onfocusout'                   => {optional => 1},
                               'onload'                       => {optional => 1},
                               'onmousedown'                  => {optional => 1},
                               'onmousemove'                  => {optional => 1},
                               'onmouseout'                   => {optional => 1},
                               'onmouseover'                  => {optional => 1},
                               'onmouseup'                    => {optional => 1},
                               'opacity'                      => {optional => 1},
                               'pointer-events'               => {optional => 1},
                               'requiredExtensions'           => {optional => 1},
                               'requiredFeatures'             => {optional => 1},
                               'rotate'                       => {optional => 1},
                               'shape-rendering'              => {optional => 1},
                               'stroke'                       => {optional => 1},
                               'stroke-dasharray'             => {optional => 1},
                               'stroke-dashoffset'            => {optional => 1},
                               'stroke-linecap'               => {optional => 1},
                               'stroke-linejoin'              => {optional => 1},
                               'stroke-miterlimit'            => {optional => 1},
                               'stroke-opacity'               => {optional => 1},
                               'stroke-width'                 => {optional => 1},
                               'style'                        => {optional => 1},
                               'systemLanguage'               => {optional => 1},
                               'text-anchor'                  => {optional => 1},
                               'text-decoration'              => {optional => 1},
                               'text-rendering'               => {optional => 1},
                               'textLength'                   => {optional => 1},
                               'unicode-bidi'                 => {optional => 1},
                               'visibility'                   => {optional => 1},
                               'word-spacing'                 => {optional => 1},
                               'x'                            => {optional => 1},
                               'xml:base'                     => {optional => 1},
                               'xml:lang'                     => {optional => 1},
                               'xml:space'                    => {optional => 1},
                               'y'                            => {optional => 1}},
     'use'                 => {'alignment-baseline'           => {optional => 1},
                               'baseline-shift'               => {optional => 1},
                               'class'                        => {optional => 1},
                               'clip'                         => {optional => 1},
                               'clip-path'                    => {optional => 1},
                               'clip-rule'                    => {optional => 1},
                               'color'                        => {optional => 1},
                               'color-interpolation'          => {optional => 1},
                               'color-interpolation-filters'  => {optional => 1},
                               'color-profile'                => {optional => 1},
                               'color-rendering'              => {optional => 1},
                               'cursor'                       => {optional => 1},
                               'direction'                    => {optional => 1},
                               'display'                      => {optional => 1},
                               'dominant-baseline'            => {optional => 1},
                               'enable-background'            => {optional => 1},
                               'externalResourcesRequired'    => {optional => 1},
                               'fill'                         => {optional => 1},
                               'fill-opacity'                 => {optional => 1},
                               'fill-rule'                    => {optional => 1},
                               'filter'                       => {optional => 1},
                               'flood-color'                  => {optional => 1},
                               'flood-opacity'                => {optional => 1},
                               'font-family'                  => {optional => 1},
                               'font-size'                    => {optional => 1},
                               'font-size-adjust'             => {optional => 1},
                               'font-stretch'                 => {optional => 1},
                               'font-style'                   => {optional => 1},
                               'font-variant'                 => {optional => 1},
                               'font-weight'                  => {optional => 1},
                               'glyph-orientation-horizontal' => {optional => 1},
                               'glyph-orientation-vertical'   => {optional => 1},
                               'height'                       => {optional => 1},
                               'id'                           => {optional => 1},
                               'image-rendering'              => {optional => 1},
                               'kerning'                      => {optional => 1},
                               'letter-spacing'               => {optional => 1},
                               'lighting-color'               => {optional => 1},
                               'marker-end'                   => {optional => 1},
                               'marker-mid'                   => {optional => 1},
                               'marker-start'                 => {optional => 1},
                               'mask'                         => {optional => 1},
                               'onactivate'                   => {optional => 1},
                               'onclick'                      => {optional => 1},
                               'onfocusin'                    => {optional => 1},
                               'onfocusout'                   => {optional => 1},
                               'onload'                       => {optional => 1},
                               'onmousedown'                  => {optional => 1},
                               'onmousemove'                  => {optional => 1},
                               'onmouseout'                   => {optional => 1},
                               'onmouseover'                  => {optional => 1},
                               'onmouseup'                    => {optional => 1},
                               'opacity'                      => {optional => 1},
                               'overflow'                     => {optional => 1},
                               'pointer-events'               => {optional => 1},
                               'requiredExtensions'           => {optional => 1},
                               'requiredFeatures'             => {optional => 1},
                               'shape-rendering'              => {optional => 1},
                               'stop-color'                   => {optional => 1},
                               'stop-opacity'                 => {optional => 1},
                               'stroke'                       => {optional => 1},
                               'stroke-dasharray'             => {optional => 1},
                               'stroke-dashoffset'            => {optional => 1},
                               'stroke-linecap'               => {optional => 1},
                               'stroke-linejoin'              => {optional => 1},
                               'stroke-miterlimit'            => {optional => 1},
                               'stroke-opacity'               => {optional => 1},
                               'stroke-width'                 => {optional => 1},
                               'style'                        => {optional => 1},
                               'systemLanguage'               => {optional => 1},
                               'text-anchor'                  => {optional => 1},
                               'text-decoration'              => {optional => 1},
                               'text-rendering'               => {optional => 1},
                               'transform'                    => {optional => 1},
                               'unicode-bidi'                 => {optional => 1},
                               'visibility'                   => {optional => 1},
                               'width'                        => {optional => 1},
                               'word-spacing'                 => {optional => 1},
                               'writing-mode'                 => {optional => 1},
                               'x'                            => {optional => 1},
                               'xlink:actuate'                => {default  => 'onLoad'},
                               'xlink:arcrole'                => {optional => 1},
                               'xlink:href'                   => {optional => 0},
                               'xlink:role'                   => {optional => 1},
                               'xlink:show'                   => {default  => 'embed'},
                               'xlink:title'                  => {optional => 1},
                               'xlink:type'                   => {default  => 'simple'},
                               'xml:base'                     => {optional => 1},
                               'xml:lang'                     => {optional => 1},
                               'xml:space'                    => {optional => 1},
                               'xmlns:xlink'                  => {default  => 'http://www.w3.org/1999/xlink'},
                               'y'                            => {optional => 1}},
     'view'                => {'externalResourcesRequired'    => {optional => 1},
                               'id'                           => {optional => 1},
                               'preserveAspectRatio'          => {default  => 'xMidYMid meet'},
                               'viewBox'                      => {optional => 1},
                               'viewTarget'                   => {optional => 1},
                               'xml:base'                     => {optional => 1},
                               'xml:lang'                     => {optional => 1},
                               'xml:space'                    => {optional => 1},
                               'zoomAndPan'                   => {default  => 'magnify'}},
     'vkern'               => {'g1'                           => {optional => 1},
                               'g2'                           => {optional => 1},
                               'id'                           => {optional => 1},
                               'k'                            => {optional => 0},
                               'u1'                           => {optional => 1},
                               'u2'                           => {optional => 1},
                               'xml:base'                     => {optional => 1},
                               'xml:lang'                     => {optional => 1},
                               'xml:space'                    => {optional => 1}});

our %ATTR_HINTS =
    ('a'                   => {'alignment-baseline'           => {},
                               'baseline-shift'               => {},
                               'class'                        => {},
                               'clip'                         => {},
                               'clip-path'                    => {},
                               'clip-rule'                    => {},
                               'color'                        => {color  => 1},
                               'color-interpolation'          => {},
                               'color-interpolation-filters'  => {},
                               'color-profile'                => {},
                               'color-rendering'              => {},
                               'cursor'                       => {},
                               'direction'                    => {},
                               'display'                      => {},
                               'dominant-baseline'            => {},
                               'enable-background'            => {},
                               'externalResourcesRequired'    => {},
                               'fill'                         => {color  => 1},
                               'fill-opacity'                 => {},
                               'fill-rule'                    => {},
                               'filter'                       => {},
                               'flood-color'                  => {},
                               'flood-opacity'                => {},
                               'font-family'                  => {},
                               'font-size'                    => {},
                               'font-size-adjust'             => {},
                               'font-stretch'                 => {},
                               'font-style'                   => {},
                               'font-variant'                 => {},
                               'font-weight'                  => {},
                               'glyph-orientation-horizontal' => {},
                               'glyph-orientation-vertical'   => {},
                               'id'                           => {},
                               'image-rendering'              => {},
                               'kerning'                      => {},
                               'letter-spacing'               => {},
                               'lighting-color'               => {},
                               'marker-end'                   => {},
                               'marker-mid'                   => {},
                               'marker-start'                 => {},
                               'mask'                         => {},
                               'onactivate'                   => {},
                               'onclick'                      => {},
                               'onfocusin'                    => {},
                               'onfocusout'                   => {},
                               'onload'                       => {},
                               'onmousedown'                  => {},
                               'onmousemove'                  => {},
                               'onmouseout'                   => {},
                               'onmouseover'                  => {},
                               'onmouseup'                    => {},
                               'opacity'                      => {},
                               'overflow'                     => {},
                               'pointer-events'               => {},
                               'requiredExtensions'           => {},
                               'requiredFeatures'             => {},
                               'shape-rendering'              => {},
                               'stop-color'                   => {},
                               'stop-opacity'                 => {},
                               'stroke'                       => {color  => 1},
                               'stroke-dasharray'             => {},
                               'stroke-dashoffset'            => {},
                               'stroke-linecap'               => {},
                               'stroke-linejoin'              => {},
                               'stroke-miterlimit'            => {},
                               'stroke-opacity'               => {},
                               'stroke-width'                 => {length => 1},
                               'style'                        => {},
                               'systemLanguage'               => {},
                               'target'                       => {},
                               'text-anchor'                  => {},
                               'text-decoration'              => {},
                               'text-rendering'               => {},
                               'transform'                    => {},
                               'unicode-bidi'                 => {},
                               'visibility'                   => {},
                               'word-spacing'                 => {},
                               'writing-mode'                 => {},
                               'xlink:actuate'                => {},
                               'xlink:arcrole'                => {},
                               'xlink:href'                   => {},
                               'xlink:role'                   => {},
                               'xlink:show'                   => {},
                               'xlink:title'                  => {},
                               'xlink:type'                   => {},
                               'xml:base'                     => {},
                               'xml:lang'                     => {},
                               'xml:space'                    => {},
                               'xmlns:xlink'                  => {}},
     'altGlyph'            => {'alignment-baseline'           => {},
                               'baseline-shift'               => {},
                               'class'                        => {},
                               'clip-path'                    => {},
                               'clip-rule'                    => {},
                               'color'                        => {color  => 1},
                               'color-interpolation'          => {},
                               'color-rendering'              => {},
                               'cursor'                       => {},
                               'direction'                    => {},
                               'display'                      => {},
                               'dominant-baseline'            => {},
                               'dx'                           => {},
                               'dy'                           => {},
                               'externalResourcesRequired'    => {},
                               'fill'                         => {color  => 1},
                               'fill-opacity'                 => {},
                               'fill-rule'                    => {},
                               'filter'                       => {},
                               'font-family'                  => {},
                               'font-size'                    => {},
                               'font-size-adjust'             => {},
                               'font-stretch'                 => {},
                               'font-style'                   => {},
                               'font-variant'                 => {},
                               'font-weight'                  => {},
                               'format'                       => {},
                               'glyph-orientation-horizontal' => {},
                               'glyph-orientation-vertical'   => {},
                               'glyphRef'                     => {},
                               'id'                           => {},
                               'image-rendering'              => {},
                               'kerning'                      => {},
                               'letter-spacing'               => {},
                               'mask'                         => {},
                               'onactivate'                   => {},
                               'onclick'                      => {},
                               'onfocusin'                    => {},
                               'onfocusout'                   => {},
                               'onload'                       => {},
                               'onmousedown'                  => {},
                               'onmousemove'                  => {},
                               'onmouseout'                   => {},
                               'onmouseover'                  => {},
                               'onmouseup'                    => {},
                               'opacity'                      => {},
                               'pointer-events'               => {},
                               'requiredExtensions'           => {},
                               'requiredFeatures'             => {},
                               'rotate'                       => {},
                               'shape-rendering'              => {},
                               'stroke'                       => {color  => 1},
                               'stroke-dasharray'             => {},
                               'stroke-dashoffset'            => {},
                               'stroke-linecap'               => {},
                               'stroke-linejoin'              => {},
                               'stroke-miterlimit'            => {},
                               'stroke-opacity'               => {},
                               'stroke-width'                 => {length => 1},
                               'style'                        => {},
                               'systemLanguage'               => {},
                               'text-anchor'                  => {},
                               'text-decoration'              => {},
                               'text-rendering'               => {},
                               'unicode-bidi'                 => {},
                               'visibility'                   => {},
                               'word-spacing'                 => {},
                               'x'                            => {},
                               'xlink:actuate'                => {},
                               'xlink:arcrole'                => {},
                               'xlink:href'                   => {},
                               'xlink:role'                   => {},
                               'xlink:show'                   => {},
                               'xlink:title'                  => {},
                               'xlink:type'                   => {},
                               'xml:base'                     => {},
                               'xml:lang'                     => {},
                               'xml:space'                    => {},
                               'xmlns:xlink'                  => {},
                               'y'                            => {}},
     'altGlyphDef'         => {'id'                           => {},
                               'xml:base'                     => {},
                               'xml:lang'                     => {},
                               'xml:space'                    => {}},
     'altGlyphItem'        => {'id'                           => {},
                               'xml:base'                     => {},
                               'xml:lang'                     => {},
                               'xml:space'                    => {}},
     'animate'             => {'accumulate'                   => {},
                               'additive'                     => {},
                               'attributeName'                => {},
                               'attributeType'                => {},
                               'begin'                        => {},
                               'by'                           => {},
                               'calcMode'                     => {},
                               'dur'                          => {},
                               'end'                          => {},
                               'externalResourcesRequired'    => {},
                               'fill'                         => {},
                               'from'                         => {},
                               'id'                           => {},
                               'keySplines'                   => {},
                               'keyTimes'                     => {},
                               'max'                          => {},
                               'min'                          => {},
                               'onbegin'                      => {},
                               'onend'                        => {},
                               'onload'                       => {},
                               'onrepeat'                     => {},
                               'repeatCount'                  => {},
                               'repeatDur'                    => {},
                               'requiredExtensions'           => {},
                               'requiredFeatures'             => {},
                               'restart'                      => {},
                               'systemLanguage'               => {},
                               'to'                           => {},
                               'values'                       => {},
                               'xlink:actuate'                => {},
                               'xlink:arcrole'                => {},
                               'xlink:href'                   => {},
                               'xlink:role'                   => {},
                               'xlink:show'                   => {},
                               'xlink:title'                  => {},
                               'xlink:type'                   => {},
                               'xml:base'                     => {},
                               'xml:lang'                     => {},
                               'xml:space'                    => {},
                               'xmlns:xlink'                  => {}},
     'animateColor'        => {'accumulate'                   => {},
                               'additive'                     => {},
                               'attributeName'                => {},
                               'attributeType'                => {},
                               'begin'                        => {},
                               'by'                           => {},
                               'calcMode'                     => {},
                               'dur'                          => {},
                               'end'                          => {},
                               'externalResourcesRequired'    => {},
                               'fill'                         => {},
                               'from'                         => {},
                               'id'                           => {},
                               'keySplines'                   => {},
                               'keyTimes'                     => {},
                               'max'                          => {},
                               'min'                          => {},
                               'onbegin'                      => {},
                               'onend'                        => {},
                               'onload'                       => {},
                               'onrepeat'                     => {},
                               'repeatCount'                  => {},
                               'repeatDur'                    => {},
                               'requiredExtensions'           => {},
                               'requiredFeatures'             => {},
                               'restart'                      => {},
                               'systemLanguage'               => {},
                               'to'                           => {},
                               'values'                       => {},
                               'xlink:actuate'                => {},
                               'xlink:arcrole'                => {},
                               'xlink:href'                   => {},
                               'xlink:role'                   => {},
                               'xlink:show'                   => {},
                               'xlink:title'                  => {},
                               'xlink:type'                   => {},
                               'xml:base'                     => {},
                               'xml:lang'                     => {},
                               'xml:space'                    => {},
                               'xmlns:xlink'                  => {}},
     'animateMotion'       => {'accumulate'                   => {},
                               'additive'                     => {},
                               'begin'                        => {},
                               'by'                           => {},
                               'calcMode'                     => {},
                               'dur'                          => {},
                               'end'                          => {},
                               'externalResourcesRequired'    => {},
                               'fill'                         => {},
                               'from'                         => {},
                               'id'                           => {},
                               'keyPoints'                    => {},
                               'keySplines'                   => {},
                               'keyTimes'                     => {},
                               'max'                          => {},
                               'min'                          => {},
                               'onbegin'                      => {},
                               'onend'                        => {},
                               'onload'                       => {},
                               'onrepeat'                     => {},
                               'origin'                       => {},
                               'path'                         => {},
                               'repeatCount'                  => {},
                               'repeatDur'                    => {},
                               'requiredExtensions'           => {},
                               'requiredFeatures'             => {},
                               'restart'                      => {},
                               'rotate'                       => {},
                               'systemLanguage'               => {},
                               'to'                           => {},
                               'values'                       => {},
                               'xlink:actuate'                => {},
                               'xlink:arcrole'                => {},
                               'xlink:href'                   => {},
                               'xlink:role'                   => {},
                               'xlink:show'                   => {},
                               'xlink:title'                  => {},
                               'xlink:type'                   => {},
                               'xml:base'                     => {},
                               'xml:lang'                     => {},
                               'xml:space'                    => {},
                               'xmlns:xlink'                  => {}},
     'animateTransform'    => {'accumulate'                   => {},
                               'additive'                     => {},
                               'attributeName'                => {},
                               'attributeType'                => {},
                               'begin'                        => {},
                               'by'                           => {},
                               'calcMode'                     => {},
                               'dur'                          => {},
                               'end'                          => {},
                               'externalResourcesRequired'    => {},
                               'fill'                         => {},
                               'from'                         => {},
                               'id'                           => {},
                               'keySplines'                   => {},
                               'keyTimes'                     => {},
                               'max'                          => {},
                               'min'                          => {},
                               'onbegin'                      => {},
                               'onend'                        => {},
                               'onload'                       => {},
                               'onrepeat'                     => {},
                               'repeatCount'                  => {},
                               'repeatDur'                    => {},
                               'requiredExtensions'           => {},
                               'requiredFeatures'             => {},
                               'restart'                      => {},
                               'systemLanguage'               => {},
                               'to'                           => {},
                               'type'                         => {},
                               'values'                       => {},
                               'xlink:actuate'                => {},
                               'xlink:arcrole'                => {},
                               'xlink:href'                   => {},
                               'xlink:role'                   => {},
                               'xlink:show'                   => {},
                               'xlink:title'                  => {},
                               'xlink:type'                   => {},
                               'xml:base'                     => {},
                               'xml:lang'                     => {},
                               'xml:space'                    => {},
                               'xmlns:xlink'                  => {}},
     'circle'              => {'class'                        => {},
                               'clip-path'                    => {},
                               'clip-rule'                    => {},
                               'color'                        => {color  => 1},
                               'color-interpolation'          => {},
                               'color-rendering'              => {},
                               'cursor'                       => {},
                               'cx'                           => {length => 1},
                               'cy'                           => {length => 1},
                               'display'                      => {},
                               'externalResourcesRequired'    => {},
                               'fill'                         => {color  => 1},
                               'fill-opacity'                 => {},
                               'fill-rule'                    => {},
                               'filter'                       => {},
                               'id'                           => {},
                               'image-rendering'              => {},
                               'mask'                         => {},
                               'onactivate'                   => {},
                               'onclick'                      => {},
                               'onfocusin'                    => {},
                               'onfocusout'                   => {},
                               'onload'                       => {},
                               'onmousedown'                  => {},
                               'onmousemove'                  => {},
                               'onmouseout'                   => {},
                               'onmouseover'                  => {},
                               'onmouseup'                    => {},
                               'opacity'                      => {},
                               'pointer-events'               => {},
                               'r'                            => {length => 1},
                               'requiredExtensions'           => {},
                               'requiredFeatures'             => {},
                               'shape-rendering'              => {},
                               'stroke'                       => {color  => 1},
                               'stroke-dasharray'             => {},
                               'stroke-dashoffset'            => {},
                               'stroke-linecap'               => {},
                               'stroke-linejoin'              => {},
                               'stroke-miterlimit'            => {},
                               'stroke-opacity'               => {},
                               'stroke-width'                 => {length => 1},
                               'style'                        => {},
                               'systemLanguage'               => {},
                               'text-rendering'               => {},
                               'transform'                    => {},
                               'visibility'                   => {},
                               'xml:base'                     => {},
                               'xml:lang'                     => {},
                               'xml:space'                    => {}},
     'clipPath'            => {'alignment-baseline'           => {},
                               'baseline-shift'               => {},
                               'class'                        => {},
                               'clip-path'                    => {},
                               'clip-rule'                    => {},
                               'clipPathUnits'                => {},
                               'color'                        => {color  => 1},
                               'color-interpolation'          => {},
                               'color-rendering'              => {},
                               'cursor'                       => {},
                               'direction'                    => {},
                               'display'                      => {},
                               'dominant-baseline'            => {},
                               'externalResourcesRequired'    => {},
                               'fill'                         => {color  => 1},
                               'fill-opacity'                 => {},
                               'fill-rule'                    => {},
                               'filter'                       => {},
                               'font-family'                  => {},
                               'font-size'                    => {},
                               'font-size-adjust'             => {},
                               'font-stretch'                 => {},
                               'font-style'                   => {},
                               'font-variant'                 => {},
                               'font-weight'                  => {},
                               'glyph-orientation-horizontal' => {},
                               'glyph-orientation-vertical'   => {},
                               'id'                           => {},
                               'image-rendering'              => {},
                               'kerning'                      => {},
                               'letter-spacing'               => {},
                               'mask'                         => {},
                               'opacity'                      => {},
                               'pointer-events'               => {},
                               'requiredExtensions'           => {},
                               'requiredFeatures'             => {},
                               'shape-rendering'              => {},
                               'stroke'                       => {color  => 1},
                               'stroke-dasharray'             => {},
                               'stroke-dashoffset'            => {},
                               'stroke-linecap'               => {},
                               'stroke-linejoin'              => {},
                               'stroke-miterlimit'            => {},
                               'stroke-opacity'               => {},
                               'stroke-width'                 => {length => 1},
                               'style'                        => {},
                               'systemLanguage'               => {},
                               'text-anchor'                  => {},
                               'text-decoration'              => {},
                               'text-rendering'               => {},
                               'transform'                    => {},
                               'unicode-bidi'                 => {},
                               'visibility'                   => {},
                               'word-spacing'                 => {},
                               'writing-mode'                 => {},
                               'xml:base'                     => {},
                               'xml:lang'                     => {},
                               'xml:space'                    => {}},
     'color-profile'       => {'id'                           => {},
                               'local'                        => {},
                               'name'                         => {},
                               'rendering-intent'             => {},
                               'xlink:actuate'                => {},
                               'xlink:arcrole'                => {},
                               'xlink:href'                   => {},
                               'xlink:role'                   => {},
                               'xlink:show'                   => {},
                               'xlink:title'                  => {},
                               'xlink:type'                   => {},
                               'xml:base'                     => {},
                               'xml:lang'                     => {},
                               'xml:space'                    => {},
                               'xmlns:xlink'                  => {}},
     'cursor'              => {'externalResourcesRequired'    => {},
                               'id'                           => {},
                               'requiredExtensions'           => {},
                               'requiredFeatures'             => {},
                               'systemLanguage'               => {},
                               'x'                            => {length => 1},
                               'xlink:actuate'                => {},
                               'xlink:arcrole'                => {},
                               'xlink:href'                   => {},
                               'xlink:role'                   => {},
                               'xlink:show'                   => {},
                               'xlink:title'                  => {},
                               'xlink:type'                   => {},
                               'xml:base'                     => {},
                               'xml:lang'                     => {},
                               'xml:space'                    => {},
                               'xmlns:xlink'                  => {},
                               'y'                            => {length => 1}},
     'definition-src'      => {'id'                           => {},
                               'xlink:actuate'                => {},
                               'xlink:arcrole'                => {},
                               'xlink:href'                   => {},
                               'xlink:role'                   => {},
                               'xlink:show'                   => {},
                               'xlink:title'                  => {},
                               'xlink:type'                   => {},
                               'xml:base'                     => {},
                               'xml:lang'                     => {},
                               'xml:space'                    => {},
                               'xmlns:xlink'                  => {}},
     'defs'                => {'alignment-baseline'           => {},
                               'baseline-shift'               => {},
                               'class'                        => {},
                               'clip'                         => {},
                               'clip-path'                    => {},
                               'clip-rule'                    => {},
                               'color'                        => {color  => 1},
                               'color-interpolation'          => {},
                               'color-interpolation-filters'  => {},
                               'color-profile'                => {},
                               'color-rendering'              => {},
                               'cursor'                       => {},
                               'direction'                    => {},
                               'display'                      => {},
                               'dominant-baseline'            => {},
                               'enable-background'            => {},
                               'externalResourcesRequired'    => {},
                               'fill'                         => {color  => 1},
                               'fill-opacity'                 => {},
                               'fill-rule'                    => {},
                               'filter'                       => {},
                               'flood-color'                  => {},
                               'flood-opacity'                => {},
                               'font-family'                  => {},
                               'font-size'                    => {},
                               'font-size-adjust'             => {},
                               'font-stretch'                 => {},
                               'font-style'                   => {},
                               'font-variant'                 => {},
                               'font-weight'                  => {},
                               'glyph-orientation-horizontal' => {},
                               'glyph-orientation-vertical'   => {},
                               'id'                           => {},
                               'image-rendering'              => {},
                               'kerning'                      => {},
                               'letter-spacing'               => {},
                               'lighting-color'               => {},
                               'marker-end'                   => {},
                               'marker-mid'                   => {},
                               'marker-start'                 => {},
                               'mask'                         => {},
                               'onactivate'                   => {},
                               'onclick'                      => {},
                               'onfocusin'                    => {},
                               'onfocusout'                   => {},
                               'onload'                       => {},
                               'onmousedown'                  => {},
                               'onmousemove'                  => {},
                               'onmouseout'                   => {},
                               'onmouseover'                  => {},
                               'onmouseup'                    => {},
                               'opacity'                      => {},
                               'overflow'                     => {},
                               'pointer-events'               => {},
                               'requiredExtensions'           => {},
                               'requiredFeatures'             => {},
                               'shape-rendering'              => {},
                               'stop-color'                   => {},
                               'stop-opacity'                 => {},
                               'stroke'                       => {color  => 1},
                               'stroke-dasharray'             => {},
                               'stroke-dashoffset'            => {},
                               'stroke-linecap'               => {},
                               'stroke-linejoin'              => {},
                               'stroke-miterlimit'            => {},
                               'stroke-opacity'               => {},
                               'stroke-width'                 => {length => 1},
                               'style'                        => {},
                               'systemLanguage'               => {},
                               'text-anchor'                  => {},
                               'text-decoration'              => {},
                               'text-rendering'               => {},
                               'transform'                    => {},
                               'unicode-bidi'                 => {},
                               'visibility'                   => {},
                               'word-spacing'                 => {},
                               'writing-mode'                 => {},
                               'xml:base'                     => {},
                               'xml:lang'                     => {},
                               'xml:space'                    => {}},
     'desc'                => {'class'                        => {},
                               'id'                           => {},
                               'style'                        => {},
                               'xml:base'                     => {},
                               'xml:lang'                     => {},
                               'xml:space'                    => {}},
     'ellipse'             => {'class'                        => {},
                               'clip-path'                    => {},
                               'clip-rule'                    => {},
                               'color'                        => {color  => 1},
                               'color-interpolation'          => {},
                               'color-rendering'              => {},
                               'cursor'                       => {},
                               'cx'                           => {length => 1},
                               'cy'                           => {length => 1},
                               'display'                      => {},
                               'externalResourcesRequired'    => {},
                               'fill'                         => {color  => 1},
                               'fill-opacity'                 => {},
                               'fill-rule'                    => {},
                               'filter'                       => {},
                               'id'                           => {},
                               'image-rendering'              => {},
                               'mask'                         => {},
                               'onactivate'                   => {},
                               'onclick'                      => {},
                               'onfocusin'                    => {},
                               'onfocusout'                   => {},
                               'onload'                       => {},
                               'onmousedown'                  => {},
                               'onmousemove'                  => {},
                               'onmouseout'                   => {},
                               'onmouseover'                  => {},
                               'onmouseup'                    => {},
                               'opacity'                      => {},
                               'pointer-events'               => {},
                               'requiredExtensions'           => {},
                               'requiredFeatures'             => {},
                               'rx'                           => {length => 1},
                               'ry'                           => {length => 1},
                               'shape-rendering'              => {},
                               'stroke'                       => {color  => 1},
                               'stroke-dasharray'             => {},
                               'stroke-dashoffset'            => {},
                               'stroke-linecap'               => {},
                               'stroke-linejoin'              => {},
                               'stroke-miterlimit'            => {},
                               'stroke-opacity'               => {},
                               'stroke-width'                 => {length => 1},
                               'style'                        => {},
                               'systemLanguage'               => {},
                               'text-rendering'               => {},
                               'transform'                    => {},
                               'visibility'                   => {},
                               'xml:base'                     => {},
                               'xml:lang'                     => {},
                               'xml:space'                    => {}},
     'feBlend'             => {'color-interpolation-filters'  => {},
                               'height'                       => {length => 1},
                               'id'                           => {},
                               'in'                           => {},
                               'in2'                          => {},
                               'mode'                         => {},
                               'result'                       => {},
                               'width'                        => {length => 1},
                               'x'                            => {length => 1},
                               'xml:base'                     => {},
                               'xml:lang'                     => {},
                               'xml:space'                    => {},
                               'y'                            => {length => 1}},
     'feColorMatrix'       => {'color-interpolation-filters'  => {},
                               'height'                       => {length => 1},
                               'id'                           => {},
                               'in'                           => {},
                               'result'                       => {},
                               'type'                         => {},
                               'values'                       => {},
                               'width'                        => {length => 1},
                               'x'                            => {length => 1},
                               'xml:base'                     => {},
                               'xml:lang'                     => {},
                               'xml:space'                    => {},
                               'y'                            => {length => 1}},
     'feComponentTransfer' => {'color-interpolation-filters'  => {},
                               'height'                       => {length => 1},
                               'id'                           => {},
                               'in'                           => {},
                               'result'                       => {},
                               'width'                        => {length => 1},
                               'x'                            => {length => 1},
                               'xml:base'                     => {},
                               'xml:lang'                     => {},
                               'xml:space'                    => {},
                               'y'                            => {length => 1}},
     'feComposite'         => {'color-interpolation-filters'  => {},
                               'height'                       => {length => 1},
                               'id'                           => {},
                               'in'                           => {},
                               'in2'                          => {},
                               'k1'                           => {},
                               'k2'                           => {},
                               'k3'                           => {},
                               'k4'                           => {},
                               'operator'                     => {},
                               'result'                       => {},
                               'width'                        => {length => 1},
                               'x'                            => {length => 1},
                               'xml:base'                     => {},
                               'xml:lang'                     => {},
                               'xml:space'                    => {},
                               'y'                            => {length => 1}},
     'feConvolveMatrix'    => {'bias'                         => {},
                               'color-interpolation-filters'  => {},
                               'divisor'                      => {},
                               'edgeMode'                     => {},
                               'height'                       => {length => 1},
                               'id'                           => {},
                               'in'                           => {},
                               'kernelMatrix'                 => {},
                               'kernelUnitLength'             => {},
                               'order'                        => {},
                               'preserveAlpha'                => {},
                               'result'                       => {},
                               'targetX'                      => {},
                               'targetY'                      => {},
                               'width'                        => {length => 1},
                               'x'                            => {length => 1},
                               'xml:base'                     => {},
                               'xml:lang'                     => {},
                               'xml:space'                    => {},
                               'y'                            => {length => 1}},
     'feDiffuseLighting'   => {'class'                        => {},
                               'color'                        => {color  => 1},
                               'color-interpolation'          => {},
                               'color-interpolation-filters'  => {},
                               'color-rendering'              => {},
                               'diffuseConstant'              => {},
                               'height'                       => {length => 1},
                               'id'                           => {},
                               'in'                           => {},
                               'kernelUnitLength'             => {},
                               'lighting-color'               => {},
                               'result'                       => {},
                               'style'                        => {},
                               'surfaceScale'                 => {},
                               'width'                        => {length => 1},
                               'x'                            => {length => 1},
                               'xml:base'                     => {},
                               'xml:lang'                     => {},
                               'xml:space'                    => {},
                               'y'                            => {length => 1}},
     'feDisplacementMap'   => {'color-interpolation-filters'  => {},
                               'height'                       => {length => 1},
                               'id'                           => {},
                               'in'                           => {},
                               'in2'                          => {},
                               'result'                       => {},
                               'scale'                        => {},
                               'width'                        => {length => 1},
                               'x'                            => {length => 1},
                               'xChannelSelector'             => {},
                               'xml:base'                     => {},
                               'xml:lang'                     => {},
                               'xml:space'                    => {},
                               'y'                            => {length => 1},
                               'yChannelSelector'             => {}},
     'feDistantLight'      => {'azimuth'                      => {},
                               'elevation'                    => {},
                               'id'                           => {},
                               'xml:base'                     => {},
                               'xml:lang'                     => {},
                               'xml:space'                    => {}},
     'feFlood'             => {'class'                        => {},
                               'color'                        => {color  => 1},
                               'color-interpolation'          => {},
                               'color-interpolation-filters'  => {},
                               'color-rendering'              => {},
                               'flood-color'                  => {},
                               'flood-opacity'                => {},
                               'height'                       => {length => 1},
                               'id'                           => {},
                               'in'                           => {},
                               'result'                       => {},
                               'style'                        => {},
                               'width'                        => {length => 1},
                               'x'                            => {length => 1},
                               'xml:base'                     => {},
                               'xml:lang'                     => {},
                               'xml:space'                    => {},
                               'y'                            => {length => 1}},
     'feFuncA'             => {'amplitude'                    => {},
                               'exponent'                     => {},
                               'id'                           => {},
                               'intercept'                    => {},
                               'offset'                       => {},
                               'slope'                        => {},
                               'tableValues'                  => {},
                               'type'                         => {},
                               'xml:base'                     => {},
                               'xml:lang'                     => {},
                               'xml:space'                    => {}},
     'feFuncB'             => {'amplitude'                    => {},
                               'exponent'                     => {},
                               'id'                           => {},
                               'intercept'                    => {},
                               'offset'                       => {},
                               'slope'                        => {},
                               'tableValues'                  => {},
                               'type'                         => {},
                               'xml:base'                     => {},
                               'xml:lang'                     => {},
                               'xml:space'                    => {}},
     'feFuncG'             => {'amplitude'                    => {},
                               'exponent'                     => {},
                               'id'                           => {},
                               'intercept'                    => {},
                               'offset'                       => {},
                               'slope'                        => {},
                               'tableValues'                  => {},
                               'type'                         => {},
                               'xml:base'                     => {},
                               'xml:lang'                     => {},
                               'xml:space'                    => {}},
     'feFuncR'             => {'amplitude'                    => {},
                               'exponent'                     => {},
                               'id'                           => {},
                               'intercept'                    => {},
                               'offset'                       => {},
                               'slope'                        => {},
                               'tableValues'                  => {},
                               'type'                         => {},
                               'xml:base'                     => {},
                               'xml:lang'                     => {},
                               'xml:space'                    => {}},
     'feGaussianBlur'      => {'color-interpolation-filters'  => {},
                               'height'                       => {length => 1},
                               'id'                           => {},
                               'in'                           => {},
                               'result'                       => {},
                               'stdDeviation'                 => {},
                               'width'                        => {length => 1},
                               'x'                            => {length => 1},
                               'xml:base'                     => {},
                               'xml:lang'                     => {},
                               'xml:space'                    => {},
                               'y'                            => {length => 1}},
     'feImage'             => {'alignment-baseline'           => {},
                               'baseline-shift'               => {},
                               'class'                        => {},
                               'clip'                         => {},
                               'clip-path'                    => {},
                               'clip-rule'                    => {},
                               'color'                        => {color  => 1},
                               'color-interpolation'          => {},
                               'color-interpolation-filters'  => {},
                               'color-profile'                => {},
                               'color-rendering'              => {},
                               'cursor'                       => {},
                               'direction'                    => {},
                               'display'                      => {},
                               'dominant-baseline'            => {},
                               'enable-background'            => {},
                               'externalResourcesRequired'    => {},
                               'fill'                         => {color  => 1},
                               'fill-opacity'                 => {},
                               'fill-rule'                    => {},
                               'filter'                       => {},
                               'flood-color'                  => {},
                               'flood-opacity'                => {},
                               'font-family'                  => {},
                               'font-size'                    => {},
                               'font-size-adjust'             => {},
                               'font-stretch'                 => {},
                               'font-style'                   => {},
                               'font-variant'                 => {},
                               'font-weight'                  => {},
                               'glyph-orientation-horizontal' => {},
                               'glyph-orientation-vertical'   => {},
                               'height'                       => {length => 1},
                               'id'                           => {},
                               'image-rendering'              => {},
                               'kerning'                      => {},
                               'letter-spacing'               => {},
                               'lighting-color'               => {},
                               'marker-end'                   => {},
                               'marker-mid'                   => {},
                               'marker-start'                 => {},
                               'mask'                         => {},
                               'opacity'                      => {},
                               'overflow'                     => {},
                               'pointer-events'               => {},
                               'preserveAspectRatio'          => {},
                               'result'                       => {},
                               'shape-rendering'              => {},
                               'stop-color'                   => {},
                               'stop-opacity'                 => {},
                               'stroke'                       => {color  => 1},
                               'stroke-dasharray'             => {},
                               'stroke-dashoffset'            => {},
                               'stroke-linecap'               => {},
                               'stroke-linejoin'              => {},
                               'stroke-miterlimit'            => {},
                               'stroke-opacity'               => {},
                               'stroke-width'                 => {length => 1},
                               'style'                        => {},
                               'text-anchor'                  => {},
                               'text-decoration'              => {},
                               'text-rendering'               => {},
                               'unicode-bidi'                 => {},
                               'visibility'                   => {},
                               'width'                        => {length => 1},
                               'word-spacing'                 => {},
                               'writing-mode'                 => {},
                               'x'                            => {length => 1},
                               'xlink:actuate'                => {},
                               'xlink:arcrole'                => {},
                               'xlink:href'                   => {},
                               'xlink:role'                   => {},
                               'xlink:show'                   => {},
                               'xlink:title'                  => {},
                               'xlink:type'                   => {},
                               'xml:base'                     => {},
                               'xml:lang'                     => {},
                               'xml:space'                    => {},
                               'xmlns:xlink'                  => {},
                               'y'                            => {length => 1}},
     'feMerge'             => {'color-interpolation-filters'  => {},
                               'height'                       => {length => 1},
                               'id'                           => {},
                               'result'                       => {},
                               'width'                        => {length => 1},
                               'x'                            => {length => 1},
                               'xml:base'                     => {},
                               'xml:lang'                     => {},
                               'xml:space'                    => {},
                               'y'                            => {length => 1}},
     'feMergeNode'         => {'id'                           => {},
                               'in'                           => {},
                               'xml:base'                     => {},
                               'xml:lang'                     => {},
                               'xml:space'                    => {}},
     'feMorphology'        => {'color-interpolation-filters'  => {},
                               'height'                       => {length => 1},
                               'id'                           => {},
                               'in'                           => {},
                               'operator'                     => {},
                               'radius'                       => {},
                               'result'                       => {},
                               'width'                        => {length => 1},
                               'x'                            => {length => 1},
                               'xml:base'                     => {},
                               'xml:lang'                     => {},
                               'xml:space'                    => {},
                               'y'                            => {length => 1}},
     'feOffset'            => {'color-interpolation-filters'  => {},
                               'dx'                           => {},
                               'dy'                           => {},
                               'height'                       => {length => 1},
                               'id'                           => {},
                               'in'                           => {},
                               'result'                       => {},
                               'width'                        => {length => 1},
                               'x'                            => {length => 1},
                               'xml:base'                     => {},
                               'xml:lang'                     => {},
                               'xml:space'                    => {},
                               'y'                            => {length => 1}},
     'fePointLight'        => {'id'                           => {},
                               'x'                            => {},
                               'xml:base'                     => {},
                               'xml:lang'                     => {},
                               'xml:space'                    => {},
                               'y'                            => {},
                               'z'                            => {}},
     'feSpecularLighting'  => {'class'                        => {},
                               'color'                        => {color  => 1},
                               'color-interpolation'          => {},
                               'color-interpolation-filters'  => {},
                               'color-rendering'              => {},
                               'height'                       => {length => 1},
                               'id'                           => {},
                               'in'                           => {},
                               'kernelUnitLength'             => {},
                               'lighting-color'               => {},
                               'result'                       => {},
                               'specularConstant'             => {},
                               'specularExponent'             => {},
                               'style'                        => {},
                               'surfaceScale'                 => {},
                               'width'                        => {length => 1},
                               'x'                            => {length => 1},
                               'xml:base'                     => {},
                               'xml:lang'                     => {},
                               'xml:space'                    => {},
                               'y'                            => {length => 1}},
     'feSpotLight'         => {'id'                           => {},
                               'limitingConeAngle'            => {},
                               'pointsAtX'                    => {},
                               'pointsAtY'                    => {},
                               'pointsAtZ'                    => {},
                               'specularExponent'             => {},
                               'x'                            => {},
                               'xml:base'                     => {},
                               'xml:lang'                     => {},
                               'xml:space'                    => {},
                               'y'                            => {},
                               'z'                            => {}},
     'feTile'              => {'color-interpolation-filters'  => {},
                               'height'                       => {length => 1},
                               'id'                           => {},
                               'in'                           => {},
                               'result'                       => {},
                               'width'                        => {length => 1},
                               'x'                            => {length => 1},
                               'xml:base'                     => {},
                               'xml:lang'                     => {},
                               'xml:space'                    => {},
                               'y'                            => {length => 1}},
     'feTurbulence'        => {'baseFrequency'                => {},
                               'color-interpolation-filters'  => {},
                               'height'                       => {length => 1},
                               'id'                           => {},
                               'numOctaves'                   => {},
                               'result'                       => {},
                               'seed'                         => {},
                               'stitchTiles'                  => {},
                               'type'                         => {},
                               'width'                        => {length => 1},
                               'x'                            => {length => 1},
                               'xml:base'                     => {},
                               'xml:lang'                     => {},
                               'xml:space'                    => {},
                               'y'                            => {length => 1}},
     'filter'              => {'alignment-baseline'           => {},
                               'baseline-shift'               => {},
                               'class'                        => {},
                               'clip'                         => {},
                               'clip-path'                    => {},
                               'clip-rule'                    => {},
                               'color'                        => {color  => 1},
                               'color-interpolation'          => {},
                               'color-interpolation-filters'  => {},
                               'color-profile'                => {},
                               'color-rendering'              => {},
                               'cursor'                       => {},
                               'direction'                    => {},
                               'display'                      => {},
                               'dominant-baseline'            => {},
                               'enable-background'            => {},
                               'externalResourcesRequired'    => {},
                               'fill'                         => {color  => 1},
                               'fill-opacity'                 => {},
                               'fill-rule'                    => {},
                               'filter'                       => {},
                               'filterRes'                    => {},
                               'filterUnits'                  => {},
                               'flood-color'                  => {},
                               'flood-opacity'                => {},
                               'font-family'                  => {},
                               'font-size'                    => {},
                               'font-size-adjust'             => {},
                               'font-stretch'                 => {},
                               'font-style'                   => {},
                               'font-variant'                 => {},
                               'font-weight'                  => {},
                               'glyph-orientation-horizontal' => {},
                               'glyph-orientation-vertical'   => {},
                               'height'                       => {length => 1},
                               'id'                           => {},
                               'image-rendering'              => {},
                               'kerning'                      => {},
                               'letter-spacing'               => {},
                               'lighting-color'               => {},
                               'marker-end'                   => {},
                               'marker-mid'                   => {},
                               'marker-start'                 => {},
                               'mask'                         => {},
                               'opacity'                      => {},
                               'overflow'                     => {},
                               'pointer-events'               => {},
                               'primitiveUnits'               => {},
                               'shape-rendering'              => {},
                               'stop-color'                   => {},
                               'stop-opacity'                 => {},
                               'stroke'                       => {color  => 1},
                               'stroke-dasharray'             => {},
                               'stroke-dashoffset'            => {},
                               'stroke-linecap'               => {},
                               'stroke-linejoin'              => {},
                               'stroke-miterlimit'            => {},
                               'stroke-opacity'               => {},
                               'stroke-width'                 => {length => 1},
                               'style'                        => {},
                               'text-anchor'                  => {},
                               'text-decoration'              => {},
                               'text-rendering'               => {},
                               'unicode-bidi'                 => {},
                               'visibility'                   => {},
                               'width'                        => {length => 1},
                               'word-spacing'                 => {},
                               'writing-mode'                 => {},
                               'x'                            => {length => 1},
                               'xlink:actuate'                => {},
                               'xlink:arcrole'                => {},
                               'xlink:href'                   => {},
                               'xlink:role'                   => {},
                               'xlink:show'                   => {},
                               'xlink:title'                  => {},
                               'xlink:type'                   => {},
                               'xml:base'                     => {},
                               'xml:lang'                     => {},
                               'xml:space'                    => {},
                               'xmlns:xlink'                  => {},
                               'y'                            => {length => 1}},
     'font'                => {'alignment-baseline'           => {},
                               'baseline-shift'               => {},
                               'class'                        => {},
                               'clip'                         => {},
                               'clip-path'                    => {},
                               'clip-rule'                    => {},
                               'color'                        => {color  => 1},
                               'color-interpolation'          => {},
                               'color-interpolation-filters'  => {},
                               'color-profile'                => {},
                               'color-rendering'              => {},
                               'cursor'                       => {},
                               'direction'                    => {},
                               'display'                      => {},
                               'dominant-baseline'            => {},
                               'enable-background'            => {},
                               'externalResourcesRequired'    => {},
                               'fill'                         => {color  => 1},
                               'fill-opacity'                 => {},
                               'fill-rule'                    => {},
                               'filter'                       => {},
                               'flood-color'                  => {},
                               'flood-opacity'                => {},
                               'font-family'                  => {},
                               'font-size'                    => {},
                               'font-size-adjust'             => {},
                               'font-stretch'                 => {},
                               'font-style'                   => {},
                               'font-variant'                 => {},
                               'font-weight'                  => {},
                               'glyph-orientation-horizontal' => {},
                               'glyph-orientation-vertical'   => {},
                               'horiz-adv-x'                  => {},
                               'horiz-origin-x'               => {},
                               'horiz-origin-y'               => {},
                               'id'                           => {},
                               'image-rendering'              => {},
                               'kerning'                      => {},
                               'letter-spacing'               => {},
                               'lighting-color'               => {},
                               'marker-end'                   => {},
                               'marker-mid'                   => {},
                               'marker-start'                 => {},
                               'mask'                         => {},
                               'opacity'                      => {},
                               'overflow'                     => {},
                               'pointer-events'               => {},
                               'shape-rendering'              => {},
                               'stop-color'                   => {},
                               'stop-opacity'                 => {},
                               'stroke'                       => {color  => 1},
                               'stroke-dasharray'             => {},
                               'stroke-dashoffset'            => {},
                               'stroke-linecap'               => {},
                               'stroke-linejoin'              => {},
                               'stroke-miterlimit'            => {},
                               'stroke-opacity'               => {},
                               'stroke-width'                 => {length => 1},
                               'style'                        => {},
                               'text-anchor'                  => {},
                               'text-decoration'              => {},
                               'text-rendering'               => {},
                               'unicode-bidi'                 => {},
                               'vert-adv-y'                   => {},
                               'vert-origin-x'                => {},
                               'vert-origin-y'                => {},
                               'visibility'                   => {},
                               'word-spacing'                 => {},
                               'writing-mode'                 => {},
                               'xml:base'                     => {},
                               'xml:lang'                     => {},
                               'xml:space'                    => {}},
     'font-face'           => {'accent-height'                => {},
                               'alphabetic'                   => {},
                               'ascent'                       => {},
                               'bbox'                         => {},
                               'cap-height'                   => {},
                               'descent'                      => {},
                               'font-family'                  => {},
                               'font-size'                    => {},
                               'font-stretch'                 => {},
                               'font-style'                   => {},
                               'font-variant'                 => {},
                               'font-weight'                  => {},
                               'hanging'                      => {},
                               'id'                           => {},
                               'ideographic'                  => {},
                               'mathematical'                 => {},
                               'overline-position'            => {},
                               'overline-thickness'           => {},
                               'panose-1'                     => {},
                               'slope'                        => {},
                               'stemh'                        => {},
                               'stemv'                        => {},
                               'strikethrough-position'       => {},
                               'strikethrough-thickness'      => {},
                               'underline-position'           => {},
                               'underline-thickness'          => {},
                               'unicode-range'                => {},
                               'units-per-em'                 => {},
                               'v-alphabetic'                 => {},
                               'v-hanging'                    => {},
                               'v-ideographic'                => {},
                               'v-mathematical'               => {},
                               'widths'                       => {},
                               'x-height'                     => {},
                               'xml:base'                     => {},
                               'xml:lang'                     => {},
                               'xml:space'                    => {}},
     'font-face-format'    => {'id'                           => {},
                               'string'                       => {},
                               'xml:base'                     => {},
                               'xml:lang'                     => {},
                               'xml:space'                    => {}},
     'font-face-name'      => {'id'                           => {},
                               'name'                         => {},
                               'xml:base'                     => {},
                               'xml:lang'                     => {},
                               'xml:space'                    => {}},
     'font-face-src'       => {'id'                           => {},
                               'xml:base'                     => {},
                               'xml:lang'                     => {},
                               'xml:space'                    => {}},
     'font-face-uri'       => {'id'                           => {},
                               'xlink:actuate'                => {},
                               'xlink:arcrole'                => {},
                               'xlink:href'                   => {},
                               'xlink:role'                   => {},
                               'xlink:show'                   => {},
                               'xlink:title'                  => {},
                               'xlink:type'                   => {},
                               'xml:base'                     => {},
                               'xml:lang'                     => {},
                               'xml:space'                    => {},
                               'xmlns:xlink'                  => {}},
     'foreignObject'       => {'alignment-baseline'           => {},
                               'baseline-shift'               => {},
                               'class'                        => {},
                               'clip'                         => {},
                               'clip-path'                    => {},
                               'clip-rule'                    => {},
                               'color'                        => {color  => 1},
                               'color-interpolation'          => {},
                               'color-interpolation-filters'  => {},
                               'color-profile'                => {},
                               'color-rendering'              => {},
                               'cursor'                       => {},
                               'direction'                    => {},
                               'display'                      => {},
                               'dominant-baseline'            => {},
                               'enable-background'            => {},
                               'externalResourcesRequired'    => {},
                               'fill'                         => {color  => 1},
                               'fill-opacity'                 => {},
                               'fill-rule'                    => {},
                               'filter'                       => {},
                               'flood-color'                  => {},
                               'flood-opacity'                => {},
                               'font-family'                  => {},
                               'font-size'                    => {},
                               'font-size-adjust'             => {},
                               'font-stretch'                 => {},
                               'font-style'                   => {},
                               'font-variant'                 => {},
                               'font-weight'                  => {},
                               'glyph-orientation-horizontal' => {},
                               'glyph-orientation-vertical'   => {},
                               'height'                       => {length => 1},
                               'id'                           => {},
                               'image-rendering'              => {},
                               'kerning'                      => {},
                               'letter-spacing'               => {},
                               'lighting-color'               => {},
                               'marker-end'                   => {},
                               'marker-mid'                   => {},
                               'marker-start'                 => {},
                               'mask'                         => {},
                               'onactivate'                   => {},
                               'onclick'                      => {},
                               'onfocusin'                    => {},
                               'onfocusout'                   => {},
                               'onload'                       => {},
                               'onmousedown'                  => {},
                               'onmousemove'                  => {},
                               'onmouseout'                   => {},
                               'onmouseover'                  => {},
                               'onmouseup'                    => {},
                               'opacity'                      => {},
                               'overflow'                     => {},
                               'pointer-events'               => {},
                               'requiredExtensions'           => {},
                               'requiredFeatures'             => {},
                               'shape-rendering'              => {},
                               'stop-color'                   => {},
                               'stop-opacity'                 => {},
                               'stroke'                       => {color  => 1},
                               'stroke-dasharray'             => {},
                               'stroke-dashoffset'            => {},
                               'stroke-linecap'               => {},
                               'stroke-linejoin'              => {},
                               'stroke-miterlimit'            => {},
                               'stroke-opacity'               => {},
                               'stroke-width'                 => {length => 1},
                               'style'                        => {},
                               'systemLanguage'               => {},
                               'text-anchor'                  => {},
                               'text-decoration'              => {},
                               'text-rendering'               => {},
                               'transform'                    => {},
                               'unicode-bidi'                 => {},
                               'visibility'                   => {},
                               'width'                        => {length => 1},
                               'word-spacing'                 => {},
                               'writing-mode'                 => {},
                               'x'                            => {length => 1},
                               'xml:base'                     => {},
                               'xml:lang'                     => {},
                               'xml:space'                    => {},
                               'y'                            => {length => 1}},
     'g'                   => {'alignment-baseline'           => {},
                               'baseline-shift'               => {},
                               'class'                        => {},
                               'clip'                         => {},
                               'clip-path'                    => {},
                               'clip-rule'                    => {},
                               'color'                        => {color  => 1},
                               'color-interpolation'          => {},
                               'color-interpolation-filters'  => {},
                               'color-profile'                => {},
                               'color-rendering'              => {},
                               'cursor'                       => {},
                               'direction'                    => {},
                               'display'                      => {},
                               'dominant-baseline'            => {},
                               'enable-background'            => {},
                               'externalResourcesRequired'    => {},
                               'fill'                         => {color  => 1},
                               'fill-opacity'                 => {},
                               'fill-rule'                    => {},
                               'filter'                       => {},
                               'flood-color'                  => {},
                               'flood-opacity'                => {},
                               'font-family'                  => {},
                               'font-size'                    => {},
                               'font-size-adjust'             => {},
                               'font-stretch'                 => {},
                               'font-style'                   => {},
                               'font-variant'                 => {},
                               'font-weight'                  => {},
                               'glyph-orientation-horizontal' => {},
                               'glyph-orientation-vertical'   => {},
                               'id'                           => {},
                               'image-rendering'              => {},
                               'kerning'                      => {},
                               'letter-spacing'               => {},
                               'lighting-color'               => {},
                               'marker-end'                   => {},
                               'marker-mid'                   => {},
                               'marker-start'                 => {},
                               'mask'                         => {},
                               'onactivate'                   => {},
                               'onclick'                      => {},
                               'onfocusin'                    => {},
                               'onfocusout'                   => {},
                               'onload'                       => {},
                               'onmousedown'                  => {},
                               'onmousemove'                  => {},
                               'onmouseout'                   => {},
                               'onmouseover'                  => {},
                               'onmouseup'                    => {},
                               'opacity'                      => {},
                               'overflow'                     => {},
                               'pointer-events'               => {},
                               'requiredExtensions'           => {},
                               'requiredFeatures'             => {},
                               'shape-rendering'              => {},
                               'stop-color'                   => {},
                               'stop-opacity'                 => {},
                               'stroke'                       => {color  => 1},
                               'stroke-dasharray'             => {},
                               'stroke-dashoffset'            => {},
                               'stroke-linecap'               => {},
                               'stroke-linejoin'              => {},
                               'stroke-miterlimit'            => {},
                               'stroke-opacity'               => {},
                               'stroke-width'                 => {length => 1},
                               'style'                        => {},
                               'systemLanguage'               => {},
                               'text-anchor'                  => {},
                               'text-decoration'              => {},
                               'text-rendering'               => {},
                               'transform'                    => {},
                               'unicode-bidi'                 => {},
                               'visibility'                   => {},
                               'word-spacing'                 => {},
                               'writing-mode'                 => {},
                               'xml:base'                     => {},
                               'xml:lang'                     => {},
                               'xml:space'                    => {}},
     'glyph'               => {'alignment-baseline'           => {},
                               'arabic-form'                  => {},
                               'baseline-shift'               => {},
                               'class'                        => {},
                               'clip'                         => {},
                               'clip-path'                    => {},
                               'clip-rule'                    => {},
                               'color'                        => {color  => 1},
                               'color-interpolation'          => {},
                               'color-interpolation-filters'  => {},
                               'color-profile'                => {},
                               'color-rendering'              => {},
                               'cursor'                       => {},
                               'd'                            => {},
                               'direction'                    => {},
                               'display'                      => {},
                               'dominant-baseline'            => {},
                               'enable-background'            => {},
                               'fill'                         => {color  => 1},
                               'fill-opacity'                 => {},
                               'fill-rule'                    => {},
                               'filter'                       => {},
                               'flood-color'                  => {},
                               'flood-opacity'                => {},
                               'font-family'                  => {},
                               'font-size'                    => {},
                               'font-size-adjust'             => {},
                               'font-stretch'                 => {},
                               'font-style'                   => {},
                               'font-variant'                 => {},
                               'font-weight'                  => {},
                               'glyph-name'                   => {},
                               'glyph-orientation-horizontal' => {},
                               'glyph-orientation-vertical'   => {},
                               'horiz-adv-x'                  => {},
                               'id'                           => {},
                               'image-rendering'              => {},
                               'kerning'                      => {},
                               'lang'                         => {},
                               'letter-spacing'               => {},
                               'lighting-color'               => {},
                               'marker-end'                   => {},
                               'marker-mid'                   => {},
                               'marker-start'                 => {},
                               'mask'                         => {},
                               'opacity'                      => {},
                               'orientation'                  => {},
                               'overflow'                     => {},
                               'pointer-events'               => {},
                               'shape-rendering'              => {},
                               'stop-color'                   => {},
                               'stop-opacity'                 => {},
                               'stroke'                       => {color  => 1},
                               'stroke-dasharray'             => {},
                               'stroke-dashoffset'            => {},
                               'stroke-linecap'               => {},
                               'stroke-linejoin'              => {},
                               'stroke-miterlimit'            => {},
                               'stroke-opacity'               => {},
                               'stroke-width'                 => {length => 1},
                               'style'                        => {},
                               'text-anchor'                  => {},
                               'text-decoration'              => {},
                               'text-rendering'               => {},
                               'unicode'                      => {},
                               'unicode-bidi'                 => {},
                               'vert-adv-y'                   => {},
                               'vert-origin-x'                => {},
                               'vert-origin-y'                => {},
                               'visibility'                   => {},
                               'word-spacing'                 => {},
                               'writing-mode'                 => {},
                               'xml:base'                     => {},
                               'xml:lang'                     => {},
                               'xml:space'                    => {}},
     'glyphRef'            => {'class'                        => {},
                               'dx'                           => {},
                               'dy'                           => {},
                               'font-family'                  => {},
                               'font-size'                    => {},
                               'font-size-adjust'             => {},
                               'font-stretch'                 => {},
                               'font-style'                   => {},
                               'font-variant'                 => {},
                               'font-weight'                  => {},
                               'format'                       => {},
                               'glyphRef'                     => {},
                               'id'                           => {},
                               'style'                        => {},
                               'x'                            => {},
                               'xlink:actuate'                => {},
                               'xlink:arcrole'                => {},
                               'xlink:href'                   => {},
                               'xlink:role'                   => {},
                               'xlink:show'                   => {},
                               'xlink:title'                  => {},
                               'xlink:type'                   => {},
                               'xml:base'                     => {},
                               'xml:lang'                     => {},
                               'xml:space'                    => {},
                               'xmlns:xlink'                  => {},
                               'y'                            => {}},
     'hkern'               => {'g1'                           => {},
                               'g2'                           => {},
                               'id'                           => {},
                               'k'                            => {},
                               'u1'                           => {},
                               'u2'                           => {},
                               'xml:base'                     => {},
                               'xml:lang'                     => {},
                               'xml:space'                    => {}},
     'image'               => {'class'                        => {},
                               'clip'                         => {},
                               'clip-path'                    => {},
                               'clip-rule'                    => {},
                               'color'                        => {color  => 1},
                               'color-interpolation'          => {},
                               'color-profile'                => {},
                               'color-rendering'              => {},
                               'cursor'                       => {},
                               'display'                      => {},
                               'externalResourcesRequired'    => {},
                               'fill-opacity'                 => {},
                               'filter'                       => {},
                               'height'                       => {length => 1},
                               'id'                           => {},
                               'image-rendering'              => {},
                               'mask'                         => {},
                               'onactivate'                   => {},
                               'onclick'                      => {},
                               'onfocusin'                    => {},
                               'onfocusout'                   => {},
                               'onload'                       => {},
                               'onmousedown'                  => {},
                               'onmousemove'                  => {},
                               'onmouseout'                   => {},
                               'onmouseover'                  => {},
                               'onmouseup'                    => {},
                               'opacity'                      => {},
                               'overflow'                     => {},
                               'pointer-events'               => {},
                               'preserveAspectRatio'          => {},
                               'requiredExtensions'           => {},
                               'requiredFeatures'             => {},
                               'shape-rendering'              => {},
                               'stroke-opacity'               => {},
                               'style'                        => {},
                               'systemLanguage'               => {},
                               'text-rendering'               => {},
                               'transform'                    => {},
                               'visibility'                   => {},
                               'width'                        => {length => 1},
                               'x'                            => {length => 1},
                               'xlink:actuate'                => {},
                               'xlink:arcrole'                => {},
                               'xlink:href'                   => {},
                               'xlink:role'                   => {},
                               'xlink:show'                   => {},
                               'xlink:title'                  => {},
                               'xlink:type'                   => {},
                               'xml:base'                     => {},
                               'xml:lang'                     => {},
                               'xml:space'                    => {},
                               'xmlns:xlink'                  => {},
                               'y'                            => {length => 1}},
     'line'                => {'class'                        => {},
                               'clip-path'                    => {},
                               'clip-rule'                    => {},
                               'color'                        => {color  => 1},
                               'color-interpolation'          => {},
                               'color-rendering'              => {},
                               'cursor'                       => {},
                               'display'                      => {},
                               'externalResourcesRequired'    => {},
                               'fill'                         => {color  => 1},
                               'fill-opacity'                 => {},
                               'fill-rule'                    => {},
                               'filter'                       => {},
                               'id'                           => {},
                               'image-rendering'              => {},
                               'marker-end'                   => {},
                               'marker-mid'                   => {},
                               'marker-start'                 => {},
                               'mask'                         => {},
                               'onactivate'                   => {},
                               'onclick'                      => {},
                               'onfocusin'                    => {},
                               'onfocusout'                   => {},
                               'onload'                       => {},
                               'onmousedown'                  => {},
                               'onmousemove'                  => {},
                               'onmouseout'                   => {},
                               'onmouseover'                  => {},
                               'onmouseup'                    => {},
                               'opacity'                      => {},
                               'pointer-events'               => {},
                               'requiredExtensions'           => {},
                               'requiredFeatures'             => {},
                               'shape-rendering'              => {},
                               'stroke'                       => {color  => 1},
                               'stroke-dasharray'             => {},
                               'stroke-dashoffset'            => {},
                               'stroke-linecap'               => {},
                               'stroke-linejoin'              => {},
                               'stroke-miterlimit'            => {},
                               'stroke-opacity'               => {},
                               'stroke-width'                 => {length => 1},
                               'style'                        => {},
                               'systemLanguage'               => {},
                               'text-rendering'               => {},
                               'transform'                    => {},
                               'visibility'                   => {},
                               'x1'                           => {length => 1},
                               'x2'                           => {length => 1},
                               'xml:base'                     => {},
                               'xml:lang'                     => {},
                               'xml:space'                    => {},
                               'y1'                           => {length => 1},
                               'y2'                           => {length => 1}},
     'linearGradient'      => {'class'                        => {},
                               'color'                        => {color  => 1},
                               'color-interpolation'          => {},
                               'color-rendering'              => {},
                               'externalResourcesRequired'    => {},
                               'gradientTransform'            => {},
                               'gradientUnits'                => {},
                               'id'                           => {},
                               'spreadMethod'                 => {},
                               'stop-color'                   => {},
                               'stop-opacity'                 => {},
                               'style'                        => {},
                               'x1'                           => {length => 1},
                               'x2'                           => {length => 1},
                               'xlink:actuate'                => {},
                               'xlink:arcrole'                => {},
                               'xlink:href'                   => {},
                               'xlink:role'                   => {},
                               'xlink:show'                   => {},
                               'xlink:title'                  => {},
                               'xlink:type'                   => {},
                               'xml:base'                     => {},
                               'xml:lang'                     => {},
                               'xml:space'                    => {},
                               'xmlns:xlink'                  => {},
                               'y1'                           => {length => 1},
                               'y2'                           => {length => 1}},
     'marker'              => {'alignment-baseline'           => {},
                               'baseline-shift'               => {},
                               'class'                        => {},
                               'clip'                         => {},
                               'clip-path'                    => {},
                               'clip-rule'                    => {},
                               'color'                        => {color  => 1},
                               'color-interpolation'          => {},
                               'color-interpolation-filters'  => {},
                               'color-profile'                => {},
                               'color-rendering'              => {},
                               'cursor'                       => {},
                               'direction'                    => {},
                               'display'                      => {},
                               'dominant-baseline'            => {},
                               'enable-background'            => {},
                               'externalResourcesRequired'    => {},
                               'fill'                         => {color  => 1},
                               'fill-opacity'                 => {},
                               'fill-rule'                    => {},
                               'filter'                       => {},
                               'flood-color'                  => {},
                               'flood-opacity'                => {},
                               'font-family'                  => {},
                               'font-size'                    => {},
                               'font-size-adjust'             => {},
                               'font-stretch'                 => {},
                               'font-style'                   => {},
                               'font-variant'                 => {},
                               'font-weight'                  => {},
                               'glyph-orientation-horizontal' => {},
                               'glyph-orientation-vertical'   => {},
                               'id'                           => {},
                               'image-rendering'              => {},
                               'kerning'                      => {},
                               'letter-spacing'               => {},
                               'lighting-color'               => {},
                               'marker-end'                   => {},
                               'marker-mid'                   => {},
                               'marker-start'                 => {},
                               'markerHeight'                 => {length => 1},
                               'markerUnits'                  => {},
                               'markerWidth'                  => {length => 1},
                               'mask'                         => {},
                               'opacity'                      => {},
                               'orient'                       => {},
                               'overflow'                     => {},
                               'pointer-events'               => {},
                               'preserveAspectRatio'          => {},
                               'refX'                         => {length => 1},
                               'refY'                         => {length => 1},
                               'shape-rendering'              => {},
                               'stop-color'                   => {},
                               'stop-opacity'                 => {},
                               'stroke'                       => {color  => 1},
                               'stroke-dasharray'             => {},
                               'stroke-dashoffset'            => {},
                               'stroke-linecap'               => {},
                               'stroke-linejoin'              => {},
                               'stroke-miterlimit'            => {},
                               'stroke-opacity'               => {},
                               'stroke-width'                 => {length => 1},
                               'style'                        => {},
                               'text-anchor'                  => {},
                               'text-decoration'              => {},
                               'text-rendering'               => {},
                               'unicode-bidi'                 => {},
                               'viewBox'                      => {},
                               'visibility'                   => {},
                               'word-spacing'                 => {},
                               'writing-mode'                 => {},
                               'xml:base'                     => {},
                               'xml:lang'                     => {},
                               'xml:space'                    => {}},
     'mask'                => {'alignment-baseline'           => {},
                               'baseline-shift'               => {},
                               'class'                        => {},
                               'clip'                         => {},
                               'clip-path'                    => {},
                               'clip-rule'                    => {},
                               'color'                        => {color  => 1},
                               'color-interpolation'          => {},
                               'color-interpolation-filters'  => {},
                               'color-profile'                => {},
                               'color-rendering'              => {},
                               'cursor'                       => {},
                               'direction'                    => {},
                               'display'                      => {},
                               'dominant-baseline'            => {},
                               'enable-background'            => {},
                               'externalResourcesRequired'    => {},
                               'fill'                         => {color  => 1},
                               'fill-opacity'                 => {},
                               'fill-rule'                    => {},
                               'filter'                       => {},
                               'flood-color'                  => {},
                               'flood-opacity'                => {},
                               'font-family'                  => {},
                               'font-size'                    => {},
                               'font-size-adjust'             => {},
                               'font-stretch'                 => {},
                               'font-style'                   => {},
                               'font-variant'                 => {},
                               'font-weight'                  => {},
                               'glyph-orientation-horizontal' => {},
                               'glyph-orientation-vertical'   => {},
                               'height'                       => {length => 1},
                               'id'                           => {},
                               'image-rendering'              => {},
                               'kerning'                      => {},
                               'letter-spacing'               => {},
                               'lighting-color'               => {},
                               'marker-end'                   => {},
                               'marker-mid'                   => {},
                               'marker-start'                 => {},
                               'mask'                         => {},
                               'maskContentUnits'             => {},
                               'maskUnits'                    => {},
                               'opacity'                      => {},
                               'overflow'                     => {},
                               'pointer-events'               => {},
                               'requiredExtensions'           => {},
                               'requiredFeatures'             => {},
                               'shape-rendering'              => {},
                               'stop-color'                   => {},
                               'stop-opacity'                 => {},
                               'stroke'                       => {color  => 1},
                               'stroke-dasharray'             => {},
                               'stroke-dashoffset'            => {},
                               'stroke-linecap'               => {},
                               'stroke-linejoin'              => {},
                               'stroke-miterlimit'            => {},
                               'stroke-opacity'               => {},
                               'stroke-width'                 => {length => 1},
                               'style'                        => {},
                               'systemLanguage'               => {},
                               'text-anchor'                  => {},
                               'text-decoration'              => {},
                               'text-rendering'               => {},
                               'unicode-bidi'                 => {},
                               'visibility'                   => {},
                               'width'                        => {length => 1},
                               'word-spacing'                 => {},
                               'writing-mode'                 => {},
                               'x'                            => {length => 1},
                               'xml:base'                     => {},
                               'xml:lang'                     => {},
                               'xml:space'                    => {},
                               'y'                            => {length => 1}},
     'metadata'            => {'id'                           => {},
                               'xml:base'                     => {},
                               'xml:lang'                     => {},
                               'xml:space'                    => {}},
     'missing-glyph'       => {'alignment-baseline'           => {},
                               'baseline-shift'               => {},
                               'class'                        => {},
                               'clip'                         => {},
                               'clip-path'                    => {},
                               'clip-rule'                    => {},
                               'color'                        => {color  => 1},
                               'color-interpolation'          => {},
                               'color-interpolation-filters'  => {},
                               'color-profile'                => {},
                               'color-rendering'              => {},
                               'cursor'                       => {},
                               'd'                            => {},
                               'direction'                    => {},
                               'display'                      => {},
                               'dominant-baseline'            => {},
                               'enable-background'            => {},
                               'fill'                         => {color  => 1},
                               'fill-opacity'                 => {},
                               'fill-rule'                    => {},
                               'filter'                       => {},
                               'flood-color'                  => {},
                               'flood-opacity'                => {},
                               'font-family'                  => {},
                               'font-size'                    => {},
                               'font-size-adjust'             => {},
                               'font-stretch'                 => {},
                               'font-style'                   => {},
                               'font-variant'                 => {},
                               'font-weight'                  => {},
                               'glyph-orientation-horizontal' => {},
                               'glyph-orientation-vertical'   => {},
                               'horiz-adv-x'                  => {},
                               'id'                           => {},
                               'image-rendering'              => {},
                               'kerning'                      => {},
                               'letter-spacing'               => {},
                               'lighting-color'               => {},
                               'marker-end'                   => {},
                               'marker-mid'                   => {},
                               'marker-start'                 => {},
                               'mask'                         => {},
                               'opacity'                      => {},
                               'overflow'                     => {},
                               'pointer-events'               => {},
                               'shape-rendering'              => {},
                               'stop-color'                   => {},
                               'stop-opacity'                 => {},
                               'stroke'                       => {color  => 1},
                               'stroke-dasharray'             => {},
                               'stroke-dashoffset'            => {},
                               'stroke-linecap'               => {},
                               'stroke-linejoin'              => {},
                               'stroke-miterlimit'            => {},
                               'stroke-opacity'               => {},
                               'stroke-width'                 => {length => 1},
                               'style'                        => {},
                               'text-anchor'                  => {},
                               'text-decoration'              => {},
                               'text-rendering'               => {},
                               'unicode-bidi'                 => {},
                               'vert-adv-y'                   => {},
                               'vert-origin-x'                => {},
                               'vert-origin-y'                => {},
                               'visibility'                   => {},
                               'word-spacing'                 => {},
                               'writing-mode'                 => {},
                               'xml:base'                     => {},
                               'xml:lang'                     => {},
                               'xml:space'                    => {}},
     'mpath'               => {'externalResourcesRequired'    => {},
                               'id'                           => {},
                               'xlink:actuate'                => {},
                               'xlink:arcrole'                => {},
                               'xlink:href'                   => {},
                               'xlink:role'                   => {},
                               'xlink:show'                   => {},
                               'xlink:title'                  => {},
                               'xlink:type'                   => {},
                               'xml:base'                     => {},
                               'xml:lang'                     => {},
                               'xml:space'                    => {},
                               'xmlns:xlink'                  => {}},
     'path'                => {'class'                        => {},
                               'clip-path'                    => {},
                               'clip-rule'                    => {},
                               'color'                        => {color  => 1},
                               'color-interpolation'          => {},
                               'color-rendering'              => {},
                               'cursor'                       => {},
                               'd'                            => {},
                               'display'                      => {},
                               'externalResourcesRequired'    => {},
                               'fill'                         => {color  => 1},
                               'fill-opacity'                 => {},
                               'fill-rule'                    => {},
                               'filter'                       => {},
                               'id'                           => {},
                               'image-rendering'              => {},
                               'marker-end'                   => {},
                               'marker-mid'                   => {},
                               'marker-start'                 => {},
                               'mask'                         => {},
                               'onactivate'                   => {},
                               'onclick'                      => {},
                               'onfocusin'                    => {},
                               'onfocusout'                   => {},
                               'onload'                       => {},
                               'onmousedown'                  => {},
                               'onmousemove'                  => {},
                               'onmouseout'                   => {},
                               'onmouseover'                  => {},
                               'onmouseup'                    => {},
                               'opacity'                      => {},
                               'pathLength'                   => {},
                               'pointer-events'               => {},
                               'requiredExtensions'           => {},
                               'requiredFeatures'             => {},
                               'shape-rendering'              => {},
                               'stroke'                       => {color  => 1},
                               'stroke-dasharray'             => {},
                               'stroke-dashoffset'            => {},
                               'stroke-linecap'               => {},
                               'stroke-linejoin'              => {},
                               'stroke-miterlimit'            => {},
                               'stroke-opacity'               => {},
                               'stroke-width'                 => {length => 1},
                               'style'                        => {},
                               'systemLanguage'               => {},
                               'text-rendering'               => {},
                               'transform'                    => {},
                               'visibility'                   => {},
                               'xml:base'                     => {},
                               'xml:lang'                     => {},
                               'xml:space'                    => {}},
     'pattern'             => {'alignment-baseline'           => {},
                               'baseline-shift'               => {},
                               'class'                        => {},
                               'clip'                         => {},
                               'clip-path'                    => {},
                               'clip-rule'                    => {},
                               'color'                        => {color  => 1},
                               'color-interpolation'          => {},
                               'color-interpolation-filters'  => {},
                               'color-profile'                => {},
                               'color-rendering'              => {},
                               'cursor'                       => {},
                               'direction'                    => {},
                               'display'                      => {},
                               'dominant-baseline'            => {},
                               'enable-background'            => {},
                               'externalResourcesRequired'    => {},
                               'fill'                         => {color  => 1},
                               'fill-opacity'                 => {},
                               'fill-rule'                    => {},
                               'filter'                       => {},
                               'flood-color'                  => {},
                               'flood-opacity'                => {},
                               'font-family'                  => {},
                               'font-size'                    => {},
                               'font-size-adjust'             => {},
                               'font-stretch'                 => {},
                               'font-style'                   => {},
                               'font-variant'                 => {},
                               'font-weight'                  => {},
                               'glyph-orientation-horizontal' => {},
                               'glyph-orientation-vertical'   => {},
                               'height'                       => {length => 1},
                               'id'                           => {},
                               'image-rendering'              => {},
                               'kerning'                      => {},
                               'letter-spacing'               => {},
                               'lighting-color'               => {},
                               'marker-end'                   => {},
                               'marker-mid'                   => {},
                               'marker-start'                 => {},
                               'mask'                         => {},
                               'opacity'                      => {},
                               'overflow'                     => {},
                               'patternContentUnits'          => {},
                               'patternTransform'             => {},
                               'patternUnits'                 => {},
                               'pointer-events'               => {},
                               'preserveAspectRatio'          => {},
                               'requiredExtensions'           => {},
                               'requiredFeatures'             => {},
                               'shape-rendering'              => {},
                               'stop-color'                   => {},
                               'stop-opacity'                 => {},
                               'stroke'                       => {color  => 1},
                               'stroke-dasharray'             => {},
                               'stroke-dashoffset'            => {},
                               'stroke-linecap'               => {},
                               'stroke-linejoin'              => {},
                               'stroke-miterlimit'            => {},
                               'stroke-opacity'               => {},
                               'stroke-width'                 => {length => 1},
                               'style'                        => {},
                               'systemLanguage'               => {},
                               'text-anchor'                  => {},
                               'text-decoration'              => {},
                               'text-rendering'               => {},
                               'unicode-bidi'                 => {},
                               'viewBox'                      => {},
                               'visibility'                   => {},
                               'width'                        => {length => 1},
                               'word-spacing'                 => {},
                               'writing-mode'                 => {},
                               'x'                            => {length => 1},
                               'xlink:actuate'                => {},
                               'xlink:arcrole'                => {},
                               'xlink:href'                   => {},
                               'xlink:role'                   => {},
                               'xlink:show'                   => {},
                               'xlink:title'                  => {},
                               'xlink:type'                   => {},
                               'xml:base'                     => {},
                               'xml:lang'                     => {},
                               'xml:space'                    => {},
                               'xmlns:xlink'                  => {},
                               'y'                            => {length => 1}},
     'polygon'             => {'class'                        => {},
                               'clip-path'                    => {},
                               'clip-rule'                    => {},
                               'color'                        => {color  => 1},
                               'color-interpolation'          => {},
                               'color-rendering'              => {},
                               'cursor'                       => {},
                               'display'                      => {},
                               'externalResourcesRequired'    => {},
                               'fill'                         => {color  => 1},
                               'fill-opacity'                 => {},
                               'fill-rule'                    => {},
                               'filter'                       => {},
                               'id'                           => {},
                               'image-rendering'              => {},
                               'marker-end'                   => {},
                               'marker-mid'                   => {},
                               'marker-start'                 => {},
                               'mask'                         => {},
                               'onactivate'                   => {},
                               'onclick'                      => {},
                               'onfocusin'                    => {},
                               'onfocusout'                   => {},
                               'onload'                       => {},
                               'onmousedown'                  => {},
                               'onmousemove'                  => {},
                               'onmouseout'                   => {},
                               'onmouseover'                  => {},
                               'onmouseup'                    => {},
                               'opacity'                      => {},
                               'pointer-events'               => {},
                               'points'                       => {},
                               'requiredExtensions'           => {},
                               'requiredFeatures'             => {},
                               'shape-rendering'              => {},
                               'stroke'                       => {color  => 1},
                               'stroke-dasharray'             => {},
                               'stroke-dashoffset'            => {},
                               'stroke-linecap'               => {},
                               'stroke-linejoin'              => {},
                               'stroke-miterlimit'            => {},
                               'stroke-opacity'               => {},
                               'stroke-width'                 => {length => 1},
                               'style'                        => {},
                               'systemLanguage'               => {},
                               'text-rendering'               => {},
                               'transform'                    => {},
                               'visibility'                   => {},
                               'xml:base'                     => {},
                               'xml:lang'                     => {},
                               'xml:space'                    => {}},
     'polyline'            => {'class'                        => {},
                               'clip-path'                    => {},
                               'clip-rule'                    => {},
                               'color'                        => {color  => 1},
                               'color-interpolation'          => {},
                               'color-rendering'              => {},
                               'cursor'                       => {},
                               'display'                      => {},
                               'externalResourcesRequired'    => {},
                               'fill'                         => {color  => 1},
                               'fill-opacity'                 => {},
                               'fill-rule'                    => {},
                               'filter'                       => {},
                               'id'                           => {},
                               'image-rendering'              => {},
                               'marker-end'                   => {},
                               'marker-mid'                   => {},
                               'marker-start'                 => {},
                               'mask'                         => {},
                               'onactivate'                   => {},
                               'onclick'                      => {},
                               'onfocusin'                    => {},
                               'onfocusout'                   => {},
                               'onload'                       => {},
                               'onmousedown'                  => {},
                               'onmousemove'                  => {},
                               'onmouseout'                   => {},
                               'onmouseover'                  => {},
                               'onmouseup'                    => {},
                               'opacity'                      => {},
                               'pointer-events'               => {},
                               'points'                       => {},
                               'requiredExtensions'           => {},
                               'requiredFeatures'             => {},
                               'shape-rendering'              => {},
                               'stroke'                       => {color  => 1},
                               'stroke-dasharray'             => {},
                               'stroke-dashoffset'            => {},
                               'stroke-linecap'               => {},
                               'stroke-linejoin'              => {},
                               'stroke-miterlimit'            => {},
                               'stroke-opacity'               => {},
                               'stroke-width'                 => {length => 1},
                               'style'                        => {},
                               'systemLanguage'               => {},
                               'text-rendering'               => {},
                               'transform'                    => {},
                               'visibility'                   => {},
                               'xml:base'                     => {},
                               'xml:lang'                     => {},
                               'xml:space'                    => {}},
     'radialGradient'      => {'class'                        => {},
                               'color'                        => {color  => 1},
                               'color-interpolation'          => {},
                               'color-rendering'              => {},
                               'cx'                           => {length => 1},
                               'cy'                           => {length => 1},
                               'externalResourcesRequired'    => {},
                               'fx'                           => {length => 1},
                               'fy'                           => {length => 1},
                               'gradientTransform'            => {},
                               'gradientUnits'                => {},
                               'id'                           => {},
                               'r'                            => {length => 1},
                               'spreadMethod'                 => {},
                               'stop-color'                   => {},
                               'stop-opacity'                 => {},
                               'style'                        => {},
                               'xlink:actuate'                => {},
                               'xlink:arcrole'                => {},
                               'xlink:href'                   => {},
                               'xlink:role'                   => {},
                               'xlink:show'                   => {},
                               'xlink:title'                  => {},
                               'xlink:type'                   => {},
                               'xml:base'                     => {},
                               'xml:lang'                     => {},
                               'xml:space'                    => {},
                               'xmlns:xlink'                  => {}},
     'rect'                => {'class'                        => {},
                               'clip-path'                    => {},
                               'clip-rule'                    => {},
                               'color'                        => {color  => 1},
                               'color-interpolation'          => {},
                               'color-rendering'              => {},
                               'cursor'                       => {},
                               'display'                      => {},
                               'externalResourcesRequired'    => {},
                               'fill'                         => {color  => 1},
                               'fill-opacity'                 => {},
                               'fill-rule'                    => {},
                               'filter'                       => {},
                               'height'                       => {length => 1},
                               'id'                           => {},
                               'image-rendering'              => {},
                               'mask'                         => {},
                               'onactivate'                   => {},
                               'onclick'                      => {},
                               'onfocusin'                    => {},
                               'onfocusout'                   => {},
                               'onload'                       => {},
                               'onmousedown'                  => {},
                               'onmousemove'                  => {},
                               'onmouseout'                   => {},
                               'onmouseover'                  => {},
                               'onmouseup'                    => {},
                               'opacity'                      => {},
                               'pointer-events'               => {},
                               'requiredExtensions'           => {},
                               'requiredFeatures'             => {},
                               'rx'                           => {length => 1},
                               'ry'                           => {length => 1},
                               'shape-rendering'              => {},
                               'stroke'                       => {color  => 1},
                               'stroke-dasharray'             => {},
                               'stroke-dashoffset'            => {},
                               'stroke-linecap'               => {},
                               'stroke-linejoin'              => {},
                               'stroke-miterlimit'            => {},
                               'stroke-opacity'               => {},
                               'stroke-width'                 => {length => 1},
                               'style'                        => {},
                               'systemLanguage'               => {},
                               'text-rendering'               => {},
                               'transform'                    => {},
                               'visibility'                   => {},
                               'width'                        => {length => 1},
                               'x'                            => {length => 1},
                               'xml:base'                     => {},
                               'xml:lang'                     => {},
                               'xml:space'                    => {},
                               'y'                            => {length => 1}},
     'script'              => {'externalResourcesRequired'    => {},
                               'id'                           => {},
                               'type'                         => {},
                               'xlink:actuate'                => {},
                               'xlink:arcrole'                => {},
                               'xlink:href'                   => {},
                               'xlink:role'                   => {},
                               'xlink:show'                   => {},
                               'xlink:title'                  => {},
                               'xlink:type'                   => {},
                               'xml:base'                     => {},
                               'xml:lang'                     => {},
                               'xml:space'                    => {},
                               'xmlns:xlink'                  => {}},
     'set'                 => {'attributeName'                => {},
                               'attributeType'                => {},
                               'begin'                        => {},
                               'dur'                          => {},
                               'end'                          => {},
                               'externalResourcesRequired'    => {},
                               'fill'                         => {},
                               'id'                           => {},
                               'max'                          => {},
                               'min'                          => {},
                               'onbegin'                      => {},
                               'onend'                        => {},
                               'onload'                       => {},
                               'onrepeat'                     => {},
                               'repeatCount'                  => {},
                               'repeatDur'                    => {},
                               'requiredExtensions'           => {},
                               'requiredFeatures'             => {},
                               'restart'                      => {},
                               'systemLanguage'               => {},
                               'to'                           => {},
                               'xlink:actuate'                => {},
                               'xlink:arcrole'                => {},
                               'xlink:href'                   => {},
                               'xlink:role'                   => {},
                               'xlink:show'                   => {},
                               'xlink:title'                  => {},
                               'xlink:type'                   => {},
                               'xml:base'                     => {},
                               'xml:lang'                     => {},
                               'xml:space'                    => {},
                               'xmlns:xlink'                  => {}},
     'stop'                => {'class'                        => {},
                               'color'                        => {color  => 1},
                               'color-interpolation'          => {},
                               'color-rendering'              => {},
                               'id'                           => {},
                               'offset'                       => {},
                               'stop-color'                   => {},
                               'stop-opacity'                 => {},
                               'style'                        => {},
                               'xml:base'                     => {},
                               'xml:lang'                     => {},
                               'xml:space'                    => {}},
     'style'               => {'id'                           => {},
                               'media'                        => {},
                               'title'                        => {},
                               'type'                         => {},
                               'xml:base'                     => {},
                               'xml:lang'                     => {},
                               'xml:space'                    => {}},
     'svg'                 => {'alignment-baseline'           => {},
                               'baseProfile'                  => {},
                               'baseline-shift'               => {},
                               'class'                        => {},
                               'clip'                         => {},
                               'clip-path'                    => {},
                               'clip-rule'                    => {},
                               'color'                        => {color  => 1},
                               'color-interpolation'          => {},
                               'color-interpolation-filters'  => {},
                               'color-profile'                => {},
                               'color-rendering'              => {},
                               'contentScriptType'            => {},
                               'contentStyleType'             => {},
                               'cursor'                       => {},
                               'direction'                    => {},
                               'display'                      => {},
                               'dominant-baseline'            => {},
                               'enable-background'            => {},
                               'externalResourcesRequired'    => {},
                               'fill'                         => {color  => 1},
                               'fill-opacity'                 => {},
                               'fill-rule'                    => {},
                               'filter'                       => {},
                               'flood-color'                  => {},
                               'flood-opacity'                => {},
                               'font-family'                  => {},
                               'font-size'                    => {},
                               'font-size-adjust'             => {},
                               'font-stretch'                 => {},
                               'font-style'                   => {},
                               'font-variant'                 => {},
                               'font-weight'                  => {},
                               'glyph-orientation-horizontal' => {},
                               'glyph-orientation-vertical'   => {},
                               'height'                       => {length => 1},
                               'id'                           => {},
                               'image-rendering'              => {},
                               'kerning'                      => {},
                               'letter-spacing'               => {},
                               'lighting-color'               => {},
                               'marker-end'                   => {},
                               'marker-mid'                   => {},
                               'marker-start'                 => {},
                               'mask'                         => {},
                               'onabort'                      => {},
                               'onactivate'                   => {},
                               'onclick'                      => {},
                               'onerror'                      => {},
                               'onfocusin'                    => {},
                               'onfocusout'                   => {},
                               'onload'                       => {},
                               'onmousedown'                  => {},
                               'onmousemove'                  => {},
                               'onmouseout'                   => {},
                               'onmouseover'                  => {},
                               'onmouseup'                    => {},
                               'onresize'                     => {},
                               'onscroll'                     => {},
                               'onunload'                     => {},
                               'onzoom'                       => {},
                               'opacity'                      => {},
                               'overflow'                     => {},
                               'pointer-events'               => {},
                               'preserveAspectRatio'          => {},
                               'requiredExtensions'           => {},
                               'requiredFeatures'             => {},
                               'shape-rendering'              => {},
                               'stop-color'                   => {},
                               'stop-opacity'                 => {},
                               'stroke'                       => {color  => 1},
                               'stroke-dasharray'             => {},
                               'stroke-dashoffset'            => {},
                               'stroke-linecap'               => {},
                               'stroke-linejoin'              => {},
                               'stroke-miterlimit'            => {},
                               'stroke-opacity'               => {},
                               'stroke-width'                 => {length => 1},
                               'style'                        => {},
                               'systemLanguage'               => {},
                               'text-anchor'                  => {},
                               'text-decoration'              => {},
                               'text-rendering'               => {},
                               'unicode-bidi'                 => {},
                               'version'                      => {},
                               'viewBox'                      => {},
                               'visibility'                   => {},
                               'width'                        => {length => 1},
                               'word-spacing'                 => {},
                               'writing-mode'                 => {},
                               'x'                            => {length => 1},
                               'xml:base'                     => {},
                               'xml:lang'                     => {},
                               'xml:space'                    => {},
                               'xmlns'                        => {},
                               'xmlns:xlink'                  => {},
                               'y'                            => {length => 1},
                               'zoomAndPan'                   => {}},
     'switch'              => {'alignment-baseline'           => {},
                               'baseline-shift'               => {},
                               'class'                        => {},
                               'clip'                         => {},
                               'clip-path'                    => {},
                               'clip-rule'                    => {},
                               'color'                        => {color  => 1},
                               'color-interpolation'          => {},
                               'color-interpolation-filters'  => {},
                               'color-profile'                => {},
                               'color-rendering'              => {},
                               'cursor'                       => {},
                               'direction'                    => {},
                               'display'                      => {},
                               'dominant-baseline'            => {},
                               'enable-background'            => {},
                               'externalResourcesRequired'    => {},
                               'fill'                         => {color  => 1},
                               'fill-opacity'                 => {},
                               'fill-rule'                    => {},
                               'filter'                       => {},
                               'flood-color'                  => {},
                               'flood-opacity'                => {},
                               'font-family'                  => {},
                               'font-size'                    => {},
                               'font-size-adjust'             => {},
                               'font-stretch'                 => {},
                               'font-style'                   => {},
                               'font-variant'                 => {},
                               'font-weight'                  => {},
                               'glyph-orientation-horizontal' => {},
                               'glyph-orientation-vertical'   => {},
                               'id'                           => {},
                               'image-rendering'              => {},
                               'kerning'                      => {},
                               'letter-spacing'               => {},
                               'lighting-color'               => {},
                               'marker-end'                   => {},
                               'marker-mid'                   => {},
                               'marker-start'                 => {},
                               'mask'                         => {},
                               'onactivate'                   => {},
                               'onclick'                      => {},
                               'onfocusin'                    => {},
                               'onfocusout'                   => {},
                               'onload'                       => {},
                               'onmousedown'                  => {},
                               'onmousemove'                  => {},
                               'onmouseout'                   => {},
                               'onmouseover'                  => {},
                               'onmouseup'                    => {},
                               'opacity'                      => {},
                               'overflow'                     => {},
                               'pointer-events'               => {},
                               'requiredExtensions'           => {},
                               'requiredFeatures'             => {},
                               'shape-rendering'              => {},
                               'stop-color'                   => {},
                               'stop-opacity'                 => {},
                               'stroke'                       => {color  => 1},
                               'stroke-dasharray'             => {},
                               'stroke-dashoffset'            => {},
                               'stroke-linecap'               => {},
                               'stroke-linejoin'              => {},
                               'stroke-miterlimit'            => {},
                               'stroke-opacity'               => {},
                               'stroke-width'                 => {length => 1},
                               'style'                        => {},
                               'systemLanguage'               => {},
                               'text-anchor'                  => {},
                               'text-decoration'              => {},
                               'text-rendering'               => {},
                               'transform'                    => {},
                               'unicode-bidi'                 => {},
                               'visibility'                   => {},
                               'word-spacing'                 => {},
                               'writing-mode'                 => {},
                               'xml:base'                     => {},
                               'xml:lang'                     => {},
                               'xml:space'                    => {}},
     'symbol'              => {'alignment-baseline'           => {},
                               'baseline-shift'               => {},
                               'class'                        => {},
                               'clip'                         => {},
                               'clip-path'                    => {},
                               'clip-rule'                    => {},
                               'color'                        => {color  => 1},
                               'color-interpolation'          => {},
                               'color-interpolation-filters'  => {},
                               'color-profile'                => {},
                               'color-rendering'              => {},
                               'cursor'                       => {},
                               'direction'                    => {},
                               'display'                      => {},
                               'dominant-baseline'            => {},
                               'enable-background'            => {},
                               'externalResourcesRequired'    => {},
                               'fill'                         => {color  => 1},
                               'fill-opacity'                 => {},
                               'fill-rule'                    => {},
                               'filter'                       => {},
                               'flood-color'                  => {},
                               'flood-opacity'                => {},
                               'font-family'                  => {},
                               'font-size'                    => {},
                               'font-size-adjust'             => {},
                               'font-stretch'                 => {},
                               'font-style'                   => {},
                               'font-variant'                 => {},
                               'font-weight'                  => {},
                               'glyph-orientation-horizontal' => {},
                               'glyph-orientation-vertical'   => {},
                               'id'                           => {},
                               'image-rendering'              => {},
                               'kerning'                      => {},
                               'letter-spacing'               => {},
                               'lighting-color'               => {},
                               'marker-end'                   => {},
                               'marker-mid'                   => {},
                               'marker-start'                 => {},
                               'mask'                         => {},
                               'onactivate'                   => {},
                               'onclick'                      => {},
                               'onfocusin'                    => {},
                               'onfocusout'                   => {},
                               'onload'                       => {},
                               'onmousedown'                  => {},
                               'onmousemove'                  => {},
                               'onmouseout'                   => {},
                               'onmouseover'                  => {},
                               'onmouseup'                    => {},
                               'opacity'                      => {},
                               'overflow'                     => {},
                               'pointer-events'               => {},
                               'preserveAspectRatio'          => {},
                               'shape-rendering'              => {},
                               'stop-color'                   => {},
                               'stop-opacity'                 => {},
                               'stroke'                       => {color  => 1},
                               'stroke-dasharray'             => {},
                               'stroke-dashoffset'            => {},
                               'stroke-linecap'               => {},
                               'stroke-linejoin'              => {},
                               'stroke-miterlimit'            => {},
                               'stroke-opacity'               => {},
                               'stroke-width'                 => {length => 1},
                               'style'                        => {},
                               'text-anchor'                  => {},
                               'text-decoration'              => {},
                               'text-rendering'               => {},
                               'unicode-bidi'                 => {},
                               'viewBox'                      => {},
                               'visibility'                   => {},
                               'word-spacing'                 => {},
                               'writing-mode'                 => {},
                               'xml:base'                     => {},
                               'xml:lang'                     => {},
                               'xml:space'                    => {}},
     'text'                => {'alignment-baseline'           => {},
                               'baseline-shift'               => {},
                               'class'                        => {},
                               'clip-path'                    => {},
                               'clip-rule'                    => {},
                               'color'                        => {color  => 1},
                               'color-interpolation'          => {},
                               'color-rendering'              => {},
                               'cursor'                       => {},
                               'direction'                    => {},
                               'display'                      => {},
                               'dominant-baseline'            => {},
                               'dx'                           => {},
                               'dy'                           => {},
                               'externalResourcesRequired'    => {},
                               'fill'                         => {color  => 1},
                               'fill-opacity'                 => {},
                               'fill-rule'                    => {},
                               'filter'                       => {},
                               'font-family'                  => {},
                               'font-size'                    => {},
                               'font-size-adjust'             => {},
                               'font-stretch'                 => {},
                               'font-style'                   => {},
                               'font-variant'                 => {},
                               'font-weight'                  => {},
                               'glyph-orientation-horizontal' => {},
                               'glyph-orientation-vertical'   => {},
                               'id'                           => {},
                               'image-rendering'              => {},
                               'kerning'                      => {},
                               'lengthAdjust'                 => {},
                               'letter-spacing'               => {},
                               'mask'                         => {},
                               'onactivate'                   => {},
                               'onclick'                      => {},
                               'onfocusin'                    => {},
                               'onfocusout'                   => {},
                               'onload'                       => {},
                               'onmousedown'                  => {},
                               'onmousemove'                  => {},
                               'onmouseout'                   => {},
                               'onmouseover'                  => {},
                               'onmouseup'                    => {},
                               'opacity'                      => {},
                               'pointer-events'               => {},
                               'requiredExtensions'           => {},
                               'requiredFeatures'             => {},
                               'rotate'                       => {},
                               'shape-rendering'              => {},
                               'stroke'                       => {color  => 1},
                               'stroke-dasharray'             => {},
                               'stroke-dashoffset'            => {},
                               'stroke-linecap'               => {},
                               'stroke-linejoin'              => {},
                               'stroke-miterlimit'            => {},
                               'stroke-opacity'               => {},
                               'stroke-width'                 => {length => 1},
                               'style'                        => {},
                               'systemLanguage'               => {},
                               'text-anchor'                  => {},
                               'text-decoration'              => {},
                               'text-rendering'               => {},
                               'textLength'                   => {length => 1},
                               'transform'                    => {},
                               'unicode-bidi'                 => {},
                               'visibility'                   => {},
                               'word-spacing'                 => {},
                               'writing-mode'                 => {},
                               'x'                            => {},
                               'xml:base'                     => {},
                               'xml:lang'                     => {},
                               'xml:space'                    => {},
                               'y'                            => {}},
     'textPath'            => {'alignment-baseline'           => {},
                               'baseline-shift'               => {},
                               'class'                        => {},
                               'clip-path'                    => {},
                               'clip-rule'                    => {},
                               'color'                        => {color  => 1},
                               'color-interpolation'          => {},
                               'color-rendering'              => {},
                               'cursor'                       => {},
                               'direction'                    => {},
                               'display'                      => {},
                               'dominant-baseline'            => {},
                               'externalResourcesRequired'    => {},
                               'fill'                         => {color  => 1},
                               'fill-opacity'                 => {},
                               'fill-rule'                    => {},
                               'filter'                       => {},
                               'font-family'                  => {},
                               'font-size'                    => {},
                               'font-size-adjust'             => {},
                               'font-stretch'                 => {},
                               'font-style'                   => {},
                               'font-variant'                 => {},
                               'font-weight'                  => {},
                               'glyph-orientation-horizontal' => {},
                               'glyph-orientation-vertical'   => {},
                               'id'                           => {},
                               'image-rendering'              => {},
                               'kerning'                      => {},
                               'lengthAdjust'                 => {},
                               'letter-spacing'               => {},
                               'mask'                         => {},
                               'method'                       => {},
                               'onactivate'                   => {},
                               'onclick'                      => {},
                               'onfocusin'                    => {},
                               'onfocusout'                   => {},
                               'onload'                       => {},
                               'onmousedown'                  => {},
                               'onmousemove'                  => {},
                               'onmouseout'                   => {},
                               'onmouseover'                  => {},
                               'onmouseup'                    => {},
                               'opacity'                      => {},
                               'pointer-events'               => {},
                               'requiredExtensions'           => {},
                               'requiredFeatures'             => {},
                               'shape-rendering'              => {},
                               'spacing'                      => {},
                               'startOffset'                  => {length => 1},
                               'stroke'                       => {color  => 1},
                               'stroke-dasharray'             => {},
                               'stroke-dashoffset'            => {},
                               'stroke-linecap'               => {},
                               'stroke-linejoin'              => {},
                               'stroke-miterlimit'            => {},
                               'stroke-opacity'               => {},
                               'stroke-width'                 => {length => 1},
                               'style'                        => {},
                               'systemLanguage'               => {},
                               'text-anchor'                  => {},
                               'text-decoration'              => {},
                               'text-rendering'               => {},
                               'textLength'                   => {length => 1},
                               'unicode-bidi'                 => {},
                               'visibility'                   => {},
                               'word-spacing'                 => {},
                               'xlink:actuate'                => {},
                               'xlink:arcrole'                => {},
                               'xlink:href'                   => {},
                               'xlink:role'                   => {},
                               'xlink:show'                   => {},
                               'xlink:title'                  => {},
                               'xlink:type'                   => {},
                               'xml:base'                     => {},
                               'xml:lang'                     => {},
                               'xml:space'                    => {},
                               'xmlns:xlink'                  => {}},
     'title'               => {'class'                        => {},
                               'id'                           => {},
                               'style'                        => {},
                               'xml:base'                     => {},
                               'xml:lang'                     => {},
                               'xml:space'                    => {}},
     'tref'                => {'alignment-baseline'           => {},
                               'baseline-shift'               => {},
                               'class'                        => {},
                               'clip-path'                    => {},
                               'clip-rule'                    => {},
                               'color'                        => {color  => 1},
                               'color-interpolation'          => {},
                               'color-rendering'              => {},
                               'cursor'                       => {},
                               'direction'                    => {},
                               'display'                      => {},
                               'dominant-baseline'            => {},
                               'dx'                           => {},
                               'dy'                           => {},
                               'externalResourcesRequired'    => {},
                               'fill'                         => {color  => 1},
                               'fill-opacity'                 => {},
                               'fill-rule'                    => {},
                               'filter'                       => {},
                               'font-family'                  => {},
                               'font-size'                    => {},
                               'font-size-adjust'             => {},
                               'font-stretch'                 => {},
                               'font-style'                   => {},
                               'font-variant'                 => {},
                               'font-weight'                  => {},
                               'glyph-orientation-horizontal' => {},
                               'glyph-orientation-vertical'   => {},
                               'id'                           => {},
                               'image-rendering'              => {},
                               'kerning'                      => {},
                               'lengthAdjust'                 => {},
                               'letter-spacing'               => {},
                               'mask'                         => {},
                               'onactivate'                   => {},
                               'onclick'                      => {},
                               'onfocusin'                    => {},
                               'onfocusout'                   => {},
                               'onload'                       => {},
                               'onmousedown'                  => {},
                               'onmousemove'                  => {},
                               'onmouseout'                   => {},
                               'onmouseover'                  => {},
                               'onmouseup'                    => {},
                               'opacity'                      => {},
                               'pointer-events'               => {},
                               'requiredExtensions'           => {},
                               'requiredFeatures'             => {},
                               'rotate'                       => {},
                               'shape-rendering'              => {},
                               'stroke'                       => {color  => 1},
                               'stroke-dasharray'             => {},
                               'stroke-dashoffset'            => {},
                               'stroke-linecap'               => {},
                               'stroke-linejoin'              => {},
                               'stroke-miterlimit'            => {},
                               'stroke-opacity'               => {},
                               'stroke-width'                 => {length => 1},
                               'style'                        => {},
                               'systemLanguage'               => {},
                               'text-anchor'                  => {},
                               'text-decoration'              => {},
                               'text-rendering'               => {},
                               'textLength'                   => {length => 1},
                               'unicode-bidi'                 => {},
                               'visibility'                   => {},
                               'word-spacing'                 => {},
                               'x'                            => {},
                               'xlink:actuate'                => {},
                               'xlink:arcrole'                => {},
                               'xlink:href'                   => {},
                               'xlink:role'                   => {},
                               'xlink:show'                   => {},
                               'xlink:title'                  => {},
                               'xlink:type'                   => {},
                               'xml:base'                     => {},
                               'xml:lang'                     => {},
                               'xml:space'                    => {},
                               'xmlns:xlink'                  => {},
                               'y'                            => {}},
     'tspan'               => {'alignment-baseline'           => {},
                               'baseline-shift'               => {},
                               'class'                        => {},
                               'clip-path'                    => {},
                               'clip-rule'                    => {},
                               'color'                        => {color  => 1},
                               'color-interpolation'          => {},
                               'color-rendering'              => {},
                               'cursor'                       => {},
                               'direction'                    => {},
                               'display'                      => {},
                               'dominant-baseline'            => {},
                               'dx'                           => {},
                               'dy'                           => {},
                               'externalResourcesRequired'    => {},
                               'fill'                         => {color  => 1},
                               'fill-opacity'                 => {},
                               'fill-rule'                    => {},
                               'filter'                       => {},
                               'font-family'                  => {},
                               'font-size'                    => {},
                               'font-size-adjust'             => {},
                               'font-stretch'                 => {},
                               'font-style'                   => {},
                               'font-variant'                 => {},
                               'font-weight'                  => {},
                               'glyph-orientation-horizontal' => {},
                               'glyph-orientation-vertical'   => {},
                               'id'                           => {},
                               'image-rendering'              => {},
                               'kerning'                      => {},
                               'lengthAdjust'                 => {},
                               'letter-spacing'               => {},
                               'mask'                         => {},
                               'onactivate'                   => {},
                               'onclick'                      => {},
                               'onfocusin'                    => {},
                               'onfocusout'                   => {},
                               'onload'                       => {},
                               'onmousedown'                  => {},
                               'onmousemove'                  => {},
                               'onmouseout'                   => {},
                               'onmouseover'                  => {},
                               'onmouseup'                    => {},
                               'opacity'                      => {},
                               'pointer-events'               => {},
                               'requiredExtensions'           => {},
                               'requiredFeatures'             => {},
                               'rotate'                       => {},
                               'shape-rendering'              => {},
                               'stroke'                       => {color  => 1},
                               'stroke-dasharray'             => {},
                               'stroke-dashoffset'            => {},
                               'stroke-linecap'               => {},
                               'stroke-linejoin'              => {},
                               'stroke-miterlimit'            => {},
                               'stroke-opacity'               => {},
                               'stroke-width'                 => {length => 1},
                               'style'                        => {},
                               'systemLanguage'               => {},
                               'text-anchor'                  => {},
                               'text-decoration'              => {},
                               'text-rendering'               => {},
                               'textLength'                   => {length => 1},
                               'unicode-bidi'                 => {},
                               'visibility'                   => {},
                               'word-spacing'                 => {},
                               'x'                            => {},
                               'xml:base'                     => {},
                               'xml:lang'                     => {},
                               'xml:space'                    => {},
                               'y'                            => {}},
     'use'                 => {'alignment-baseline'           => {},
                               'baseline-shift'               => {},
                               'class'                        => {},
                               'clip'                         => {},
                               'clip-path'                    => {},
                               'clip-rule'                    => {},
                               'color'                        => {color  => 1},
                               'color-interpolation'          => {},
                               'color-interpolation-filters'  => {},
                               'color-profile'                => {},
                               'color-rendering'              => {},
                               'cursor'                       => {},
                               'direction'                    => {},
                               'display'                      => {},
                               'dominant-baseline'            => {},
                               'enable-background'            => {},
                               'externalResourcesRequired'    => {},
                               'fill'                         => {color  => 1},
                               'fill-opacity'                 => {},
                               'fill-rule'                    => {},
                               'filter'                       => {},
                               'flood-color'                  => {},
                               'flood-opacity'                => {},
                               'font-family'                  => {},
                               'font-size'                    => {},
                               'font-size-adjust'             => {},
                               'font-stretch'                 => {},
                               'font-style'                   => {},
                               'font-variant'                 => {},
                               'font-weight'                  => {},
                               'glyph-orientation-horizontal' => {},
                               'glyph-orientation-vertical'   => {},
                               'height'                       => {length => 1},
                               'id'                           => {},
                               'image-rendering'              => {},
                               'kerning'                      => {},
                               'letter-spacing'               => {},
                               'lighting-color'               => {},
                               'marker-end'                   => {},
                               'marker-mid'                   => {},
                               'marker-start'                 => {},
                               'mask'                         => {},
                               'onactivate'                   => {},
                               'onclick'                      => {},
                               'onfocusin'                    => {},
                               'onfocusout'                   => {},
                               'onload'                       => {},
                               'onmousedown'                  => {},
                               'onmousemove'                  => {},
                               'onmouseout'                   => {},
                               'onmouseover'                  => {},
                               'onmouseup'                    => {},
                               'opacity'                      => {},
                               'overflow'                     => {},
                               'pointer-events'               => {},
                               'requiredExtensions'           => {},
                               'requiredFeatures'             => {},
                               'shape-rendering'              => {},
                               'stop-color'                   => {},
                               'stop-opacity'                 => {},
                               'stroke'                       => {color  => 1},
                               'stroke-dasharray'             => {},
                               'stroke-dashoffset'            => {},
                               'stroke-linecap'               => {},
                               'stroke-linejoin'              => {},
                               'stroke-miterlimit'            => {},
                               'stroke-opacity'               => {},
                               'stroke-width'                 => {length => 1},
                               'style'                        => {},
                               'systemLanguage'               => {},
                               'text-anchor'                  => {},
                               'text-decoration'              => {},
                               'text-rendering'               => {},
                               'transform'                    => {},
                               'unicode-bidi'                 => {},
                               'visibility'                   => {},
                               'width'                        => {length => 1},
                               'word-spacing'                 => {},
                               'writing-mode'                 => {},
                               'x'                            => {length => 1},
                               'xlink:actuate'                => {},
                               'xlink:arcrole'                => {},
                               'xlink:href'                   => {},
                               'xlink:role'                   => {},
                               'xlink:show'                   => {},
                               'xlink:title'                  => {},
                               'xlink:type'                   => {},
                               'xml:base'                     => {},
                               'xml:lang'                     => {},
                               'xml:space'                    => {},
                               'xmlns:xlink'                  => {},
                               'y'                            => {length => 1}},
     'view'                => {'externalResourcesRequired'    => {},
                               'id'                           => {},
                               'preserveAspectRatio'          => {},
                               'viewBox'                      => {},
                               'viewTarget'                   => {},
                               'xml:base'                     => {},
                               'xml:lang'                     => {},
                               'xml:space'                    => {},
                               'zoomAndPan'                   => {}},
     'vkern'               => {'g1'                           => {},
                               'g2'                           => {},
                               'id'                           => {},
                               'k'                            => {},
                               'u1'                           => {},
                               'u2'                           => {},
                               'xml:base'                     => {},
                               'xml:lang'                     => {},
                               'xml:space'                    => {}});

# corrections
$ATTR_VAL{'svg'}->{'xmlns:svg'} = {optional => 1};

1;


__END__

=pod

=head1 DESCRIPTION

This file is automatically generated using the SVG DTD available
under
L<http://www.w3.org/Graphics/SVG/1.1/DTD/svg11-flat-20030114.dtd>.

The data structures are used mainly by
L<SVG::Rasterize::State|SVG::Rasterize::State> for validation and
processing of the SVG input tree.

=head1 ADDITIONS

=head2 Datatypes

The C<DATATYPE_REGEX> hash is not derived from the DTD. The
datatypes are defined by entities in the DTD, but they all expand to
'CDATA'. C<SVG::Rasterize> makes use of this finer granularity of
the DTD by overriding this entity expansion.

=head2 Additions

The additions at the very end of the module are corrections to the
automatically generated data structures that I consider
necessary. The C<xmlns:svg> attribute is set by default by the
C<SVG> class. I am not sure if this is against the SVG
specification. The DTD allows to enable prefixes which then might
allow to set this attribute. Therefore, I decided to allow it as
well. This and future additions will be well separated from the
automatically generated data structures.

=head1 ACKNOWLEDGEMENTS

The parsing of the SVG DTD in order to generate the data structures
in this module was done with L<XML::DTD|XML::DTD> by Brendt
Wohlberg. Brendt was very responsive and helpful with all issues
that arose during the process of solving this task.


=head1 SEE ALSO

=over 4

=item * L<SVG::Rasterize|SVG::Rasterize>

=item * L<XML::DTD|XML::DTD>

=back


=head1 AUTHOR

Lutz Gehlen, C<< <perl at lutzgehlen.de> >>


=head1 LICENSE AND COPYRIGHT

Copyright 2010 Lutz Gehlen.

This program is free software; you can redistribute it and/or modify
it under the terms of either: the GNU General Public License as
published by the Free Software Foundation; or the Artistic License.

See http://dev.perl.org/licenses/ for more information.

=cut
