#!/usr/bin/env perl
use strict;
use warnings;

use Test::More;
use Math::Prime::Util::GMP qw/partitions/;
my $extra = defined $ENV{EXTENDED_TESTING} && $ENV{EXTENDED_TESTING};

my @parts = qw/
1
1
2
3
5
7
11
15
22
30
42
56
77
101
135
176
231
297
385
490
627
792
1002
1255
1575
1958
2436
3010
3718
4565
5604
6842
8349
10143
12310
14883
17977
21637
26015
31185
37338
44583
53174
63261
75175
89134
105558
124754
147273
173525
204226
/;

my %bparts = (
    100 => "190569292",
    500 => "2300165032574323995027",
   1000 => "24061467864032622473692149727991",
   4497 => "16167346574157197963880873560628771195478696427127534310826790306449755",
   9988 => "31043825285346179203111322344702502691204288916782299617140664920755263693739998376431336412511604846065386",
  13337 => "4841449229081281114351180373774137636239639013054790559544724995314398354517477085116206336008004971541987422037760634642695",
  37373 => "885240148270777711759915557428752066370785294706979437063536090533501018735098279767013023483349639513395622225840616033227700794918506274833787569446519667398089943122156454986205555766363295867812094833219935",
);
if (!$extra) {
  my @ns = grep { $_ > 5000 } keys %bparts;
  foreach my $n (@ns) { delete $bparts{$n} }
}

plan tests => scalar(@parts) + scalar(keys(%bparts));


foreach my $n (0..$#parts) {
  is( partitions($n), $parts[$n], "partitions($n)" );
}

while (my($n, $epart) = each (%bparts)) {
  is( partitions($n), $epart, "partitions($n)" );
}
