/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.util;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.Serializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Pair<T1, T2>
implements Comparable<Pair<T1, T2>>,
Serializable {
    public T1 first;
    public T2 second;
    private int hashCode = 0;
    private static final long serialVersionUID = 1360822168806852921L;

    public Pair() {
    }

    public Pair(T1 first, T2 second) {
        this.first = first;
        this.second = second;
    }

    public T1 first() {
        return this.first;
    }

    public T2 second() {
        return this.second;
    }

    public void setFirst(T1 o) {
        this.first = o;
    }

    public void setSecond(T2 o) {
        this.second = o;
    }

    public String toString() {
        return "(" + this.first + "," + this.second + ")";
    }

    public boolean equals(Object o) {
        if (o instanceof Pair) {
            Pair p = (Pair)o;
            return (this.first == null ? p.first == null : this.first.equals(p.first)) && (this.second == null ? p.second == null : this.second.equals(p.second));
        }
        return false;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            int firstHash = this.first == null ? 0 : this.first.hashCode();
            int secondHash = this.second == null ? 0 : this.second.hashCode();
            this.hashCode = firstHash * 31 + secondHash;
        }
        return this.hashCode;
    }

    public static Pair<String, String> readStringPair(DataInputStream in) {
        Pair<String, String> p = new Pair<String, String>();
        try {
            p.first = in.readUTF();
            p.second = in.readUTF();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return p;
    }

    public void save(DataOutputStream out2) {
        try {
            out2.writeUTF(this.first.toString());
            out2.writeUTF(this.second.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public int compareTo(Pair<T1, T2> another) {
        int comp = ((Comparable)this.first()).compareTo(another.first());
        if (comp != 0) {
            return comp;
        }
        return ((Comparable)this.second()).compareTo(another.second());
    }

    public static Pair<String, String> stringIntern(Pair<String, String> p) {
        return new InternedPair(p);
    }

    public static Pair<String, String> internedStringPair(String first, String second) {
        return new InternedPair(first, second);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class InternedPair
    extends Pair<String, String> {
        private static final long serialVersionUID = 1360822168806852922L;

        private InternedPair(Pair<String, String> p) {
            super(p.first, p.second);
            this.internStrings();
        }

        private InternedPair(String first, String second) {
            super(first, second);
            this.internStrings();
        }

        private Object readResolve() {
            this.internStrings();
            return this;
        }

        private void internStrings() {
            if (this.first != null) {
                this.first = ((String)this.first).intern();
            }
            if (this.second != null) {
                this.second = ((String)this.second).intern();
            }
        }
    }
}

