# Generated by default/object.tt
package Paws::Proton::ServiceInstance;
  use Moose;
  has Arn => (is => 'ro', isa => 'Str', request_name => 'arn', traits => ['NameInRequest'], required => 1);
  has CreatedAt => (is => 'ro', isa => 'Str', request_name => 'createdAt', traits => ['NameInRequest'], required => 1);
  has DeploymentStatus => (is => 'ro', isa => 'Str', request_name => 'deploymentStatus', traits => ['NameInRequest'], required => 1);
  has DeploymentStatusMessage => (is => 'ro', isa => 'Str', request_name => 'deploymentStatusMessage', traits => ['NameInRequest']);
  has EnvironmentName => (is => 'ro', isa => 'Str', request_name => 'environmentName', traits => ['NameInRequest'], required => 1);
  has LastDeploymentAttemptedAt => (is => 'ro', isa => 'Str', request_name => 'lastDeploymentAttemptedAt', traits => ['NameInRequest'], required => 1);
  has LastDeploymentSucceededAt => (is => 'ro', isa => 'Str', request_name => 'lastDeploymentSucceededAt', traits => ['NameInRequest'], required => 1);
  has Name => (is => 'ro', isa => 'Str', request_name => 'name', traits => ['NameInRequest'], required => 1);
  has ServiceName => (is => 'ro', isa => 'Str', request_name => 'serviceName', traits => ['NameInRequest'], required => 1);
  has Spec => (is => 'ro', isa => 'Str', request_name => 'spec', traits => ['NameInRequest']);
  has TemplateMajorVersion => (is => 'ro', isa => 'Str', request_name => 'templateMajorVersion', traits => ['NameInRequest'], required => 1);
  has TemplateMinorVersion => (is => 'ro', isa => 'Str', request_name => 'templateMinorVersion', traits => ['NameInRequest'], required => 1);
  has TemplateName => (is => 'ro', isa => 'Str', request_name => 'templateName', traits => ['NameInRequest'], required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::Proton::ServiceInstance

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Proton::ServiceInstance object:

  $service_obj->Method(Att1 => { Arn => $value, ..., TemplateName => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Proton::ServiceInstance object:

  $result = $service_obj->Method(...);
  $result->Att1->Arn

=head1 DESCRIPTION

The service instance detail data.

=head1 ATTRIBUTES


=head2 B<REQUIRED> Arn => Str

The Amazon Resource Name (ARN) of the service instance.


=head2 B<REQUIRED> CreatedAt => Str

The time when the service instance was created.


=head2 B<REQUIRED> DeploymentStatus => Str

The service instance deployment status.


=head2 DeploymentStatusMessage => Str

A service instance deployment status message.


=head2 B<REQUIRED> EnvironmentName => Str

The name of the environment that the service instance was deployed
into.


=head2 B<REQUIRED> LastDeploymentAttemptedAt => Str

The time when a deployment of the service instance was last attempted.


=head2 B<REQUIRED> LastDeploymentSucceededAt => Str

The time when the service instance was last deployed successfully.


=head2 B<REQUIRED> Name => Str

The name of the service instance.


=head2 B<REQUIRED> ServiceName => Str

The name of the service that the service instance belongs to.


=head2 Spec => Str

The service spec that was used to create the service instance.


=head2 B<REQUIRED> TemplateMajorVersion => Str

The ID of the major version of the service template that was used to
create the service instance.


=head2 B<REQUIRED> TemplateMinorVersion => Str

The ID of the minor version of the service template that was used to
create the service instance.


=head2 B<REQUIRED> TemplateName => Str

The name of the service template that was used to create the service
instance.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Proton>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

