package Archive::Any::Zip;
use strict;
use vars qw($VERSION @ISA);
$VERSION = 0.03;

use Archive::Zip qw(:ERROR_CODES);
use Cwd;


=head1 NAME

Archive::Any::Zip - Archive::Any wrapper around Archive::Zip

=head1 SYNOPSIS

B<DO NOT USE THIS MODULE DIRECTLY>

Use Archive::Any instead.

=head1 DESCRIPTION

Wrapper around Archive::Zip for Archive::Any.

=cut

sub can_handle {
	return( 'application/zip' );
}

sub files {
    my( $self, $file ) = shift;

	my $z = Archive::Zip->new( $file );
	$z->memberNames;
}


sub extract {
    my($self, $dir) = @_;

	my $z = Archive::Zip->new( $file );

    my $orig_dir;
    if( $dir ) {
        $orig_dir = getcwd;
        chdir $dir;
    }

    $z->extractTree;

    if( $dir) {
        chdir $orig_dir;
    }

    return 1;
}

sub type {
    return 'zip';
}


=head1 AUTHOR

Michael G Schwern E<lt>schwern@pobox.comE<gt>

=head1 SEE ALSO

Archive::Any, Archive::Zip

=cut

1;
