# Generated by default/object.tt
package Paws::MediaConvert::ChannelMapping;
  use Moose;
  has OutputChannels => (is => 'ro', isa => 'ArrayRef[Paws::MediaConvert::OutputChannelMapping]', request_name => 'outputChannels', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::MediaConvert::ChannelMapping

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::MediaConvert::ChannelMapping object:

  $service_obj->Method(Att1 => { OutputChannels => $value, ..., OutputChannels => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::MediaConvert::ChannelMapping object:

  $result = $service_obj->Method(...);
  $result->Att1->OutputChannels

=head1 DESCRIPTION

Channel mapping (ChannelMapping) contains the group of fields that hold
the remixing value for each channel, in dB. Specify remix values to
indicate how much of the content from your input audio channel you want
in your output audio channels. Each instance of the InputChannels or
InputChannelsFineTune array specifies these values for one output
channel. Use one instance of this array for each output channel. In the
console, each array corresponds to a column in the graphical depiction
of the mapping matrix. The rows of the graphical matrix correspond to
input channels. Valid values are within the range from -60 (mute)
through 6. A setting of 0 passes the input channel unchanged to the
output channel (no attenuation or amplification). Use InputChannels or
InputChannelsFineTune to specify your remix values. Don't use both.

=head1 ATTRIBUTES


=head2 OutputChannels => ArrayRef[L<Paws::MediaConvert::OutputChannelMapping>]

In your JSON job specification, include one child of OutputChannels for
each audio channel that you want in your output. Each child should
contain one instance of InputChannels or InputChannelsFineTune.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::MediaConvert>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

