### Compute a point on power basis curve

### The NURBS book p. 7

use parent 'algorithm';

sub new {
	my $class = shift;

	$self = SUPER::new->(@_);
}

### general algorithm (Horner based)

sub calculatePointRec {
	 my ($self, @a, $n, $u0, $C) = @_;

	$C = @a[$n];
	
	for (my $i = $n - 1; $i >= 0; $i--) {
		$C = $C * $u0 + @a[$i];
	}

	return $C;
}

### examples p. 7 of the NURBS book
### n = 1: [0 <= u <= 1] and C'(u) == a1, where a1 is the direction
### of the line, a constant

sub calculateStraightLineSegment {
  my ($self, $a0, $a1, $u) = @_;

  my $C = $a0 + $a1*$u;
  
  return $C;
}

### examples p. 7 of the NURBS book
### n = 2: [0 <= u <= 1] a parabolic arc between the points $a0 and $a0+$a1+$a2
### lies in the xy plane

sub calculateParabolicArc {
  my ($self, $a0, $a1, $a2, $u) = @_;

  my $C = $a0 + $a1*$u + $a2*pow($u,2);
  
  return $C;
}

### examples p. 7 of the NURBS book
### n = 2: x and y on the curve (unreduced?) :
sub calculateParabolicArcX {
  my ($self, $x1, $x2, $x3, $u) = @_;

  my $x = $x1 + $x2*$u + $x3*pow($u,2);
  
  return $x;
}
sub calculateParabolicArcY {
  my ($self, $y1, $y2, $y3, $u) = @_;

  my $y = $y1 + $y2*$u + $y3*pow($u,2);
  
  return $y;
}

1;
