/* A recursive-descent parser generated by greg 0.4.4 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
struct _GREG;
#define YYRULECOUNT 343

/*

	parser.leg -> parser.c -- Parse (Multi)Markdown plain text for
		conversion into other formats
	
	(c) 2013 Fletcher T. Penney (http://fletcherpenney.net/).

	Derived from peg-multimarkdown, which was forked from peg-markdown,
	which is (c) 2008 John MacFarlane (jgm at berkeley dot edu), and 
	licensed under GNU GPL or MIT.

	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License or the MIT
	license.  See LICENSE for details.
	
	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.
*/

#include "parser.h"
#include "writer.h"


/* Define shortcuts to adding nodes, etc. */
#define node(x)       mk_pos_node(x, NULL, thunk->begin, thunk->end)
#define str(x)        mk_pos_str(x, thunk->begin, thunk->end)
#define list(x,y)     mk_pos_list(x, y, thunk->begin, thunk->end)

#define ext(x)        extension(x,((parser_data *)G->data)->extensions)

#define YY_INPUT(buf, result, max_size, D) yy_input_func(buf, &result, max_size, (parser_data *)G->data)

/* redefine input buffer so that we draw from the specified source string 
	to make it thread/reentrant safe */
void yy_input_func(char *buf, int *result, int max_size, parser_data *data)
{                                                      \
	int yyc;                                           \
	if (data->charbuf && (*(data->charbuf) != '\0')) { \
		yyc = *(data->charbuf)++;                      \
	} else {                                           \
		yyc= EOF;                                      \
	}                                                  \
	(*result) = (EOF == yyc) ? 0 : (*(buf)= yyc, 1);   \
}


#ifndef YY_ALLOC
#define YY_ALLOC(N, D) malloc(N)
#endif
#ifndef YY_CALLOC
#define YY_CALLOC(N, S, D) calloc(N, S)
#endif
#ifndef YY_REALLOC
#define YY_REALLOC(B, N, D) realloc(B, N)
#endif
#ifndef YY_FREE
#define YY_FREE free
#endif
#ifndef YY_LOCAL
#define YY_LOCAL(T)     static T
#endif
#ifndef YY_ACTION
#define YY_ACTION(T)    static T
#endif
#ifndef YY_RULE
#define YY_RULE(T)      static T
#endif
#ifndef YY_PARSE
#define YY_PARSE(T)     T
#endif
#ifndef YY_NAME
#define YY_NAME(N) yy##N
#endif
#ifndef YY_INPUT
#define YY_INPUT(buf, result, max_size, D)		\
  {							\
    int yyc= getchar();					\
    result= (EOF == yyc) ? 0 : (*(buf)= yyc, 1);	\
    yyprintf((stderr, "<%c>", yyc));			\
  }
#endif
#ifndef YY_BEGIN
#define YY_BEGIN        ( G->begin= G->pos, 1)
#endif
#ifndef YY_END
#define YY_END          ( G->end= G->pos, 1)
#endif
#ifdef YY_DEBUG
# ifndef DEBUG_PARSE
#  define DEBUG_PARSE   1
# endif
# ifndef DEBUG_VERBOSE
#  define DEBUG_VERBOSE 2
# endif
# define yyprintf(args)	         if (G->debug & DEBUG_PARSE)         fprintf args
# define yyprintfv(args)         if (G->debug == (DEBUG_PARSE|DEBUG_VERBOSE)) fprintf args
# define yyprintfGcontext        if (G->debug & DEBUG_PARSE)         yyprintcontext(stderr,G->buf+G->pos)
# define yyprintfvGcontext       if (G->debug == (DEBUG_PARSE|DEBUG_VERBOSE)) yyprintcontext(stderr,G->buf+G->pos)
# define yyprintfvTcontext(text) if (G->debug == (DEBUG_PARSE|DEBUG_VERBOSE)) yyprintcontext(stderr,text)
#else
# define yyprintf(args)
# define yyprintfv(args)
# define yyprintfGcontext
# define yyprintfvGcontext
# define yyprintfvTcontext(text)
#endif
#ifndef YYSTYPE
#define YYSTYPE int
#endif
#ifndef YY_XTYPE
#define YY_XTYPE void *
#endif
#ifndef YY_XVAR
#define YY_XVAR yyxvar
#endif

#ifndef YY_STACK_SIZE
#define YY_STACK_SIZE 128
#endif

#ifndef YY_BUFFER_START_SIZE
#define YY_BUFFER_START_SIZE 1024
#endif

#ifndef YY_PART
#define yydata G->data
#define yy G->ss

struct _yythunk; // forward declaration
typedef void (*yyaction)(struct _GREG *G, char *yytext, int yyleng, struct _yythunk *thunkpos, YY_XTYPE YY_XVAR);
typedef struct _yythunk { int begin, end;  yyaction  action; const char *name; struct _yythunk *next; } yythunk;

typedef struct _GREG {
  char *buf;
  int buflen;
  int   offset;
  int   pos;
  int   limit;
  char *text;
  int   textlen;
  int   begin;
  int   end;
  yythunk *thunks;
  int   thunkslen;
  int thunkpos;
  YYSTYPE ss;
  YYSTYPE *val;
  YYSTYPE *vals;
  int valslen;
  YY_XTYPE data;
#ifdef YY_DEBUG
  int debug;
#endif
} GREG;

YY_LOCAL(int) yyrefill(GREG *G)
{
  int yyn;
  while (G->buflen - G->pos < 512)
    {
      G->buflen *= 2;
      G->buf= (char*)YY_REALLOC(G->buf, G->buflen, G->data);
    }
  YY_INPUT((G->buf + G->pos), yyn, (G->buflen - G->pos), G->data);
  if (!yyn) return 0;
  G->limit += yyn;
  return 1;
}

YY_LOCAL(int) yymatchDot(GREG *G)
{
  if (G->pos >= G->limit && !yyrefill(G)) return 0;
  ++G->pos;
  return 1;
}

#ifdef YY_DEBUG
YY_LOCAL(void) yyprintcontext(FILE *stream, char *s)
{
  char *context = s;
  char *nl = strchr(context, 10);
  if (nl) {
    context = (char*)malloc(nl-s+1);
    strncpy(context, s, nl-s);
    context[nl-s] = '\0'; /* replace nl by 0 */
  }
  fprintf(stream, " @ \"%s\"", context);
  if (nl) free(context);
}
#endif

YY_LOCAL(int) yymatchChar(GREG *G, int c)
{
  if (G->pos >= G->limit && !yyrefill(G)) return 0;
  if ((unsigned char)G->buf[G->pos] == c)
    {
      ++G->pos;
      if (c<32) { yyprintf((stderr, "  ok   yymatchChar '0x%x'", c));}
      else      { yyprintf((stderr, "  ok   yymatchChar '%c'", c));}
      yyprintfGcontext;
      yyprintf((stderr, "\n"));
      return 1;
    }
  if (c<32) { yyprintfv((stderr, "  fail yymatchChar '0x%x'", c));}
  else      { yyprintfv((stderr, "  fail yymatchChar '%c'", c));}
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));
  return 0;
}

YY_LOCAL(int) yymatchString(GREG *G, const char *s)
{
  int yysav= G->pos;
  while (*s)
    {
      if (G->pos >= G->limit && !yyrefill(G)) return 0;
      if (G->buf[G->pos] != *s)
        {
          G->pos= yysav;
          return 0;
        }
      ++s;
      ++G->pos;
    }
  return 1;
}

YY_LOCAL(int) yymatchClass(GREG *G, unsigned char *bits, char *cclass)
{
  int c;
  if (G->pos >= G->limit && !yyrefill(G)) return 0;
  c= (unsigned char)G->buf[G->pos];
  if (bits[c >> 3] & (1 << (c & 7)))
    {
      ++G->pos;
      yyprintf((stderr, "  ok   yymatchClass [%s]", cclass));
      yyprintfGcontext;
      yyprintf((stderr, "\n"));
      return 1;
    }
  yyprintfv((stderr, "  fail yymatchClass [%s]", cclass));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));
  return 0;
}

YY_LOCAL(void) yyDo(GREG *G, yyaction action, int begin, int end, const char *name)
{
  while (G->thunkpos >= G->thunkslen)
    {
      G->thunkslen *= 2;
      G->thunks= (yythunk*)YY_REALLOC(G->thunks, sizeof(yythunk) * G->thunkslen, G->data);
    }
  G->thunks[G->thunkpos].begin=  begin;
  G->thunks[G->thunkpos].end=    end;
  G->thunks[G->thunkpos].action= action;
  G->thunks[G->thunkpos].name= name;
  ++G->thunkpos;
}

YY_LOCAL(int) yyText(GREG *G, int begin, int end)
{
  int yyleng= end - begin;
  if (yyleng <= 0)
    yyleng= 0;
  else
    {
      while (G->textlen < (yyleng + 1))
        {
          G->textlen *= 2;
          G->text= (char*)YY_REALLOC(G->text, G->textlen, G->data);
        }
      memcpy(G->text, G->buf + begin, yyleng);
    }
  G->text[yyleng]= '\0';
  return yyleng;
}

YY_LOCAL(void) yyDone(GREG *G)
{
  int pos;
  for (pos= 0; pos < G->thunkpos; ++pos)
    {
      yythunk *thunk= &G->thunks[pos];
      int yyleng= thunk->end ? yyText(G, thunk->begin, thunk->end) : thunk->begin;
      yyprintf((stderr, "DO [%d] %s", pos, thunk->name));
      yyprintfvTcontext(G->text);
      yyprintf((stderr, "\n"));
      thunk->action(G, G->text, yyleng, thunk, G->data);
    }
  G->thunkpos= 0;
}

YY_LOCAL(void) yyCommit(GREG *G)
{
  if ((G->limit -= G->pos))
    {
      memmove(G->buf, G->buf + G->pos, G->limit);
    }
  G->offset += G->pos;
  G->begin -= G->pos;
  G->end -= G->pos;
  G->pos= G->thunkpos= 0;
}

YY_LOCAL(int) yyAccept(GREG *G, int tp0)
{
  if (tp0)
    {
      fprintf(stderr, "accept denied at %d\n", tp0);
      return 0;
    }
  else
    {
      yyDone(G);
      yyCommit(G);
    }
  return 1;
}

YY_LOCAL(void) yyPush(GREG *G, char *text, int count, yythunk *thunk, YY_XTYPE YY_XVAR)	{
  size_t off = (G->val - G->vals) + count;
  if (off > G->valslen) {
    while (G->valslen < off + 1)
      G->valslen *= 2;
    G->vals= (YYSTYPE*)YY_REALLOC((void *)G->vals, sizeof(YYSTYPE) * G->valslen, G->data);
    G->val= G->vals + off;
  } else {
    G->val += count;
  }
}
YY_LOCAL(void) yyPop(GREG *G, char *text, int count, yythunk *thunk, YY_XTYPE YY_XVAR)	{ G->val -= count; }
YY_LOCAL(void) yySet(GREG *G, char *text, int count, yythunk *thunk, YY_XTYPE YY_XVAR)	{ G->val[count]= G->ss; }

#endif /* YY_PART */

#define YYACCEPT        yyAccept(G, yythunkpos0)

YY_RULE(int) yy_RawString(GREG *G); /* 343 */
YY_RULE(int) yy_CriticString(GREG *G); /* 342 */
YY_RULE(int) yy_DocForCritic(GREG *G); /* 341 */
YY_RULE(int) yy_CriticSubstAdd(GREG *G); /* 340 */
YY_RULE(int) yy_CriticSubstDel(GREG *G); /* 339 */
YY_RULE(int) yy_CriticComment(GREG *G); /* 338 */
YY_RULE(int) yy_CriticHighlight(GREG *G); /* 337 */
YY_RULE(int) yy_CriticSubstitution(GREG *G); /* 336 */
YY_RULE(int) yy_CriticDeletion(GREG *G); /* 335 */
YY_RULE(int) yy_CriticAddition(GREG *G); /* 334 */
YY_RULE(int) yy_OPMLSetextHeading2(GREG *G); /* 333 */
YY_RULE(int) yy_OPMLSetextHeading1(GREG *G); /* 332 */
YY_RULE(int) yy_OPMLSetextHeading(GREG *G); /* 331 */
YY_RULE(int) yy_OPMLAtxHeading(GREG *G); /* 330 */
YY_RULE(int) yy_OPMLSectionBlock(GREG *G); /* 329 */
YY_RULE(int) yy_OPMLHeading(GREG *G); /* 328 */
YY_RULE(int) yy_OPMLPlain(GREG *G); /* 327 */
YY_RULE(int) yy_OPMLHeadingSection(GREG *G); /* 326 */
YY_RULE(int) yy_OPMLBlock(GREG *G); /* 325 */
YY_RULE(int) yy_DocForOPML(GREG *G); /* 324 */
YY_RULE(int) yy_RightAlign(GREG *G); /* 323 */
YY_RULE(int) yy_CenterAlign(GREG *G); /* 322 */
YY_RULE(int) yy_LeftAlign(GREG *G); /* 321 */
YY_RULE(int) yy_RightAlignWrap(GREG *G); /* 320 */
YY_RULE(int) yy_CenterAlignWrap(GREG *G); /* 319 */
YY_RULE(int) yy_LeftAlignWrap(GREG *G); /* 318 */
YY_RULE(int) yy_AlignmentCell(GREG *G); /* 317 */
YY_RULE(int) yy_CellStr(GREG *G); /* 316 */
YY_RULE(int) yy_FullCell(GREG *G); /* 315 */
YY_RULE(int) yy_EmptyCell(GREG *G); /* 314 */
YY_RULE(int) yy_ExtendedCell(GREG *G); /* 313 */
YY_RULE(int) yy_TableCell(GREG *G); /* 312 */
YY_RULE(int) yy_CellDivider(GREG *G); /* 311 */
YY_RULE(int) yy_TableLine(GREG *G); /* 310 */
YY_RULE(int) yy_TableRow(GREG *G); /* 309 */
YY_RULE(int) yy_SeparatorLine(GREG *G); /* 308 */
YY_RULE(int) yy_TableBody(GREG *G); /* 307 */
YY_RULE(int) yy_TableCaption(GREG *G); /* 306 */
YY_RULE(int) yy_InStyleTags(GREG *G); /* 305 */
YY_RULE(int) yy_StyleClose(GREG *G); /* 304 */
YY_RULE(int) yy_StyleOpen(GREG *G); /* 303 */
YY_RULE(int) yy_HtmlBlockType(GREG *G); /* 302 */
YY_RULE(int) yy_MarkdownHtmlAttribute(GREG *G); /* 301 */
YY_RULE(int) yy_HtmlBlockSelfClosing(GREG *G); /* 300 */
YY_RULE(int) yy_HtmlBlockCloseScript(GREG *G); /* 299 */
YY_RULE(int) yy_HtmlBlockOpenScript(GREG *G); /* 298 */
YY_RULE(int) yy_HtmlBlockTr(GREG *G); /* 297 */
YY_RULE(int) yy_HtmlBlockCloseTr(GREG *G); /* 296 */
YY_RULE(int) yy_HtmlBlockOpenTr(GREG *G); /* 295 */
YY_RULE(int) yy_HtmlBlockThead(GREG *G); /* 294 */
YY_RULE(int) yy_HtmlBlockCloseThead(GREG *G); /* 293 */
YY_RULE(int) yy_HtmlBlockOpenThead(GREG *G); /* 292 */
YY_RULE(int) yy_HtmlBlockTh(GREG *G); /* 291 */
YY_RULE(int) yy_HtmlBlockCloseTh(GREG *G); /* 290 */
YY_RULE(int) yy_HtmlBlockOpenTh(GREG *G); /* 289 */
YY_RULE(int) yy_HtmlBlockTfoot(GREG *G); /* 288 */
YY_RULE(int) yy_HtmlBlockCloseTfoot(GREG *G); /* 287 */
YY_RULE(int) yy_HtmlBlockOpenTfoot(GREG *G); /* 286 */
YY_RULE(int) yy_HtmlBlockTd(GREG *G); /* 285 */
YY_RULE(int) yy_HtmlBlockCloseTd(GREG *G); /* 284 */
YY_RULE(int) yy_HtmlBlockOpenTd(GREG *G); /* 283 */
YY_RULE(int) yy_HtmlBlockTbody(GREG *G); /* 282 */
YY_RULE(int) yy_HtmlBlockCloseTbody(GREG *G); /* 281 */
YY_RULE(int) yy_HtmlBlockOpenTbody(GREG *G); /* 280 */
YY_RULE(int) yy_HtmlBlockLi(GREG *G); /* 279 */
YY_RULE(int) yy_HtmlBlockCloseLi(GREG *G); /* 278 */
YY_RULE(int) yy_HtmlBlockOpenLi(GREG *G); /* 277 */
YY_RULE(int) yy_HtmlBlockFrameset(GREG *G); /* 276 */
YY_RULE(int) yy_HtmlBlockCloseFrameset(GREG *G); /* 275 */
YY_RULE(int) yy_HtmlBlockOpenFrameset(GREG *G); /* 274 */
YY_RULE(int) yy_HtmlBlockDt(GREG *G); /* 273 */
YY_RULE(int) yy_HtmlBlockCloseDt(GREG *G); /* 272 */
YY_RULE(int) yy_HtmlBlockOpenDt(GREG *G); /* 271 */
YY_RULE(int) yy_HtmlBlockDd(GREG *G); /* 270 */
YY_RULE(int) yy_HtmlBlockCloseDd(GREG *G); /* 269 */
YY_RULE(int) yy_HtmlBlockOpenDd(GREG *G); /* 268 */
YY_RULE(int) yy_HtmlBlockVideo(GREG *G); /* 267 */
YY_RULE(int) yy_HtmlBlockCloseVideo(GREG *G); /* 266 */
YY_RULE(int) yy_HtmlBlockOpenVideo(GREG *G); /* 265 */
YY_RULE(int) yy_HtmlBlockUl(GREG *G); /* 264 */
YY_RULE(int) yy_HtmlBlockCloseUl(GREG *G); /* 263 */
YY_RULE(int) yy_HtmlBlockOpenUl(GREG *G); /* 262 */
YY_RULE(int) yy_HtmlBlockTable(GREG *G); /* 261 */
YY_RULE(int) yy_HtmlBlockCloseTable(GREG *G); /* 260 */
YY_RULE(int) yy_HtmlBlockOpenTable(GREG *G); /* 259 */
YY_RULE(int) yy_HtmlBlockSection(GREG *G); /* 258 */
YY_RULE(int) yy_HtmlBlockCloseSection(GREG *G); /* 257 */
YY_RULE(int) yy_HtmlBlockOpenSection(GREG *G); /* 256 */
YY_RULE(int) yy_HtmlBlockProgress(GREG *G); /* 255 */
YY_RULE(int) yy_HtmlBlockCloseProgress(GREG *G); /* 254 */
YY_RULE(int) yy_HtmlBlockOpenProgress(GREG *G); /* 253 */
YY_RULE(int) yy_HtmlBlockPre(GREG *G); /* 252 */
YY_RULE(int) yy_HtmlBlockClosePre(GREG *G); /* 251 */
YY_RULE(int) yy_HtmlBlockOpenPre(GREG *G); /* 250 */
YY_RULE(int) yy_HtmlBlockP(GREG *G); /* 249 */
YY_RULE(int) yy_HtmlBlockCloseP(GREG *G); /* 248 */
YY_RULE(int) yy_HtmlBlockOpenP(GREG *G); /* 247 */
YY_RULE(int) yy_HtmlBlockOl(GREG *G); /* 246 */
YY_RULE(int) yy_HtmlBlockCloseOl(GREG *G); /* 245 */
YY_RULE(int) yy_HtmlBlockOpenOl(GREG *G); /* 244 */
YY_RULE(int) yy_HtmlBlockNoscript(GREG *G); /* 243 */
YY_RULE(int) yy_HtmlBlockCloseNoscript(GREG *G); /* 242 */
YY_RULE(int) yy_HtmlBlockOpenNoscript(GREG *G); /* 241 */
YY_RULE(int) yy_HtmlBlockNoframes(GREG *G); /* 240 */
YY_RULE(int) yy_HtmlBlockCloseNoframes(GREG *G); /* 239 */
YY_RULE(int) yy_HtmlBlockOpenNoframes(GREG *G); /* 238 */
YY_RULE(int) yy_HtmlBlockMenu(GREG *G); /* 237 */
YY_RULE(int) yy_HtmlBlockCloseMenu(GREG *G); /* 236 */
YY_RULE(int) yy_HtmlBlockOpenMenu(GREG *G); /* 235 */
YY_RULE(int) yy_HtmlBlockH6(GREG *G); /* 234 */
YY_RULE(int) yy_HtmlBlockCloseH6(GREG *G); /* 233 */
YY_RULE(int) yy_HtmlBlockOpenH6(GREG *G); /* 232 */
YY_RULE(int) yy_HtmlBlockH5(GREG *G); /* 231 */
YY_RULE(int) yy_HtmlBlockCloseH5(GREG *G); /* 230 */
YY_RULE(int) yy_HtmlBlockOpenH5(GREG *G); /* 229 */
YY_RULE(int) yy_HtmlBlockH4(GREG *G); /* 228 */
YY_RULE(int) yy_HtmlBlockCloseH4(GREG *G); /* 227 */
YY_RULE(int) yy_HtmlBlockOpenH4(GREG *G); /* 226 */
YY_RULE(int) yy_HtmlBlockH3(GREG *G); /* 225 */
YY_RULE(int) yy_HtmlBlockCloseH3(GREG *G); /* 224 */
YY_RULE(int) yy_HtmlBlockOpenH3(GREG *G); /* 223 */
YY_RULE(int) yy_HtmlBlockH2(GREG *G); /* 222 */
YY_RULE(int) yy_HtmlBlockCloseH2(GREG *G); /* 221 */
YY_RULE(int) yy_HtmlBlockOpenH2(GREG *G); /* 220 */
YY_RULE(int) yy_HtmlBlockH1(GREG *G); /* 219 */
YY_RULE(int) yy_HtmlBlockCloseH1(GREG *G); /* 218 */
YY_RULE(int) yy_HtmlBlockOpenH1(GREG *G); /* 217 */
YY_RULE(int) yy_HtmlBlockHgroup(GREG *G); /* 216 */
YY_RULE(int) yy_HtmlBlockCloseHgroup(GREG *G); /* 215 */
YY_RULE(int) yy_HtmlBlockOpenHgroup(GREG *G); /* 214 */
YY_RULE(int) yy_HtmlBlockHeader(GREG *G); /* 213 */
YY_RULE(int) yy_HtmlBlockCloseHeader(GREG *G); /* 212 */
YY_RULE(int) yy_HtmlBlockOpenHeader(GREG *G); /* 211 */
YY_RULE(int) yy_HtmlBlockForm(GREG *G); /* 210 */
YY_RULE(int) yy_HtmlBlockCloseForm(GREG *G); /* 209 */
YY_RULE(int) yy_HtmlBlockOpenForm(GREG *G); /* 208 */
YY_RULE(int) yy_HtmlBlockFooter(GREG *G); /* 207 */
YY_RULE(int) yy_HtmlBlockCloseFooter(GREG *G); /* 206 */
YY_RULE(int) yy_HtmlBlockOpenFooter(GREG *G); /* 205 */
YY_RULE(int) yy_HtmlBlockFigure(GREG *G); /* 204 */
YY_RULE(int) yy_HtmlBlockCloseFigure(GREG *G); /* 203 */
YY_RULE(int) yy_HtmlBlockOpenFigure(GREG *G); /* 202 */
YY_RULE(int) yy_HtmlBlockFieldset(GREG *G); /* 201 */
YY_RULE(int) yy_HtmlBlockCloseFieldset(GREG *G); /* 200 */
YY_RULE(int) yy_HtmlBlockOpenFieldset(GREG *G); /* 199 */
YY_RULE(int) yy_HtmlBlockDl(GREG *G); /* 198 */
YY_RULE(int) yy_HtmlBlockCloseDl(GREG *G); /* 197 */
YY_RULE(int) yy_HtmlBlockOpenDl(GREG *G); /* 196 */
YY_RULE(int) yy_HtmlBlockDiv(GREG *G); /* 195 */
YY_RULE(int) yy_HtmlBlockCloseDiv(GREG *G); /* 194 */
YY_RULE(int) yy_HtmlBlockOpenDiv(GREG *G); /* 193 */
YY_RULE(int) yy_HtmlBlockDir(GREG *G); /* 192 */
YY_RULE(int) yy_HtmlBlockCloseDir(GREG *G); /* 191 */
YY_RULE(int) yy_HtmlBlockOpenDir(GREG *G); /* 190 */
YY_RULE(int) yy_HtmlBlockCenter(GREG *G); /* 189 */
YY_RULE(int) yy_HtmlBlockCloseCenter(GREG *G); /* 188 */
YY_RULE(int) yy_HtmlBlockOpenCenter(GREG *G); /* 187 */
YY_RULE(int) yy_HtmlBlockCanvas(GREG *G); /* 186 */
YY_RULE(int) yy_HtmlBlockCloseCanvas(GREG *G); /* 185 */
YY_RULE(int) yy_HtmlBlockOpenCanvas(GREG *G); /* 184 */
YY_RULE(int) yy_HtmlBlockBlockquote(GREG *G); /* 183 */
YY_RULE(int) yy_HtmlBlockCloseBlockquote(GREG *G); /* 182 */
YY_RULE(int) yy_HtmlBlockOpenBlockquote(GREG *G); /* 181 */
YY_RULE(int) yy_HtmlBlockAside(GREG *G); /* 180 */
YY_RULE(int) yy_HtmlBlockCloseAside(GREG *G); /* 179 */
YY_RULE(int) yy_HtmlBlockOpenAside(GREG *G); /* 178 */
YY_RULE(int) yy_HtmlBlockArticle(GREG *G); /* 177 */
YY_RULE(int) yy_HtmlBlockCloseArticle(GREG *G); /* 176 */
YY_RULE(int) yy_HtmlBlockOpenArticle(GREG *G); /* 175 */
YY_RULE(int) yy_HtmlBlockAddress(GREG *G); /* 174 */
YY_RULE(int) yy_HtmlBlockCloseAddress(GREG *G); /* 173 */
YY_RULE(int) yy_HtmlBlockOpenAddress(GREG *G); /* 172 */
YY_RULE(int) yy_ListBlockLine(GREG *G); /* 171 */
YY_RULE(int) yy_ListContinuationBlock(GREG *G); /* 170 */
YY_RULE(int) yy_ListBlock(GREG *G); /* 169 */
YY_RULE(int) yy_ListItem(GREG *G); /* 168 */
YY_RULE(int) yy_Enumerator(GREG *G); /* 167 */
YY_RULE(int) yy_ListItemTight(GREG *G); /* 166 */
YY_RULE(int) yy_ListLoose(GREG *G); /* 165 */
YY_RULE(int) yy_ListTight(GREG *G); /* 164 */
YY_RULE(int) yy_Bullet(GREG *G); /* 163 */
YY_RULE(int) yy_Definition(GREG *G); /* 162 */
YY_RULE(int) yy_Term(GREG *G); /* 161 */
YY_RULE(int) yy_TermLine(GREG *G); /* 160 */
YY_RULE(int) yy_VerbatimChunk(GREG *G); /* 159 */
YY_RULE(int) yy_NonblankIndentedLine(GREG *G); /* 158 */
YY_RULE(int) yy_DoubleQuoteEnd(GREG *G); /* 157 */
YY_RULE(int) yy_DoubleQuoteStart(GREG *G); /* 156 */
YY_RULE(int) yy_SingleQuoteEnd(GREG *G); /* 155 */
YY_RULE(int) yy_SingleQuoteStart(GREG *G); /* 154 */
YY_RULE(int) yy_EnDash(GREG *G); /* 153 */
YY_RULE(int) yy_EmDash(GREG *G); /* 152 */
YY_RULE(int) yy_Apostrophe(GREG *G); /* 151 */
YY_RULE(int) yy_DoubleQuoted(GREG *G); /* 150 */
YY_RULE(int) yy_SingleQuoted(GREG *G); /* 149 */
YY_RULE(int) yy_Dash(GREG *G); /* 148 */
YY_RULE(int) yy_Ellipsis(GREG *G); /* 147 */
YY_RULE(int) yy_Ticks5(GREG *G); /* 146 */
YY_RULE(int) yy_Ticks4(GREG *G); /* 145 */
YY_RULE(int) yy_Ticks3(GREG *G); /* 144 */
YY_RULE(int) yy_Ticks2(GREG *G); /* 143 */
YY_RULE(int) yy_Ticks1(GREG *G); /* 142 */
YY_RULE(int) yy_RawNoteBlock(GREG *G); /* 141 */
YY_RULE(int) yy_GlossarySortKey(GREG *G); /* 140 */
YY_RULE(int) yy_GlossaryTerm(GREG *G); /* 139 */
YY_RULE(int) yy_RawNoteReference(GREG *G); /* 138 */
YY_RULE(int) yy_EmptyTitle(GREG *G); /* 137 */
YY_RULE(int) yy_RefTitleParens(GREG *G); /* 136 */
YY_RULE(int) yy_RefTitleDouble(GREG *G); /* 135 */
YY_RULE(int) yy_RefTitleSingle(GREG *G); /* 134 */
YY_RULE(int) yy_UnQuotedValue(GREG *G); /* 133 */
YY_RULE(int) yy_QuotedValue(GREG *G); /* 132 */
YY_RULE(int) yy_AttrValue(GREG *G); /* 131 */
YY_RULE(int) yy_AttrKey(GREG *G); /* 130 */
YY_RULE(int) yy_Attribute(GREG *G); /* 129 */
YY_RULE(int) yy_Attributes(GREG *G); /* 128 */
YY_RULE(int) yy_RefTitle(GREG *G); /* 127 */
YY_RULE(int) yy_RefSrc(GREG *G); /* 126 */
YY_RULE(int) yy_AutoLinkEmail(GREG *G); /* 125 */
YY_RULE(int) yy_AutoLinkUrl(GREG *G); /* 124 */
YY_RULE(int) yy_TitleDouble(GREG *G); /* 123 */
YY_RULE(int) yy_TitleSingle(GREG *G); /* 122 */
YY_RULE(int) yy_SourceContents(GREG *G); /* 121 */
YY_RULE(int) yy_Title(GREG *G); /* 120 */
YY_RULE(int) yy_Source(GREG *G); /* 119 */
YY_RULE(int) yy_RawCitationReference(GREG *G); /* 118 */
YY_RULE(int) yy_CitationReferenceSingle(GREG *G); /* 117 */
YY_RULE(int) yy_CitationReferenceDouble(GREG *G); /* 116 */
YY_RULE(int) yy_Label(GREG *G); /* 115 */
YY_RULE(int) yy_ReferenceLinkSingle(GREG *G); /* 114 */
YY_RULE(int) yy_ReferenceLinkDouble(GREG *G); /* 113 */
YY_RULE(int) yy_AutoLink(GREG *G); /* 112 */
YY_RULE(int) yy_ReferenceLink(GREG *G); /* 111 */
YY_RULE(int) yy_ExplicitLink(GREG *G); /* 110 */
YY_RULE(int) yy_StrongUl(GREG *G); /* 109 */
YY_RULE(int) yy_StrongStar(GREG *G); /* 108 */
YY_RULE(int) yy_Whitespace(GREG *G); /* 107 */
YY_RULE(int) yy_EmphUl(GREG *G); /* 106 */
YY_RULE(int) yy_EmphStar(GREG *G); /* 105 */
YY_RULE(int) yy_StarLine(GREG *G); /* 104 */
YY_RULE(int) yy_UlLine(GREG *G); /* 103 */
YY_RULE(int) yy_DoubleDollarMath(GREG *G); /* 102 */
YY_RULE(int) yy_DoubleDollarMathEnd(GREG *G); /* 101 */
YY_RULE(int) yy_DoubleDollarMathStart(GREG *G); /* 100 */
YY_RULE(int) yy_SingleDollarMath(GREG *G); /* 99 */
YY_RULE(int) yy_SingleDollarMathEnd(GREG *G); /* 98 */
YY_RULE(int) yy_SingleDollarMathStart(GREG *G); /* 97 */
YY_RULE(int) yy_AposChunk(GREG *G); /* 96 */
YY_RULE(int) yy_StrChunk(GREG *G); /* 95 */
YY_RULE(int) yy_voidNormalEndline(GREG *G); /* 94 */
YY_RULE(int) yy_NormalEndline(GREG *G); /* 93 */
YY_RULE(int) yy_TerminalEndline(GREG *G); /* 92 */
YY_RULE(int) yy_LineBreak(GREG *G); /* 91 */
YY_RULE(int) yy_Smart(GREG *G); /* 90 */
YY_RULE(int) yy_MarkdownHtmlTagOpen(GREG *G); /* 89 */
YY_RULE(int) yy_Code(GREG *G); /* 88 */
YY_RULE(int) yy_NoteReference(GREG *G); /* 87 */
YY_RULE(int) yy_Link(GREG *G); /* 86 */
YY_RULE(int) yy_Image(GREG *G); /* 85 */
YY_RULE(int) yy_CitationReference(GREG *G); /* 84 */
YY_RULE(int) yy_Emph(GREG *G); /* 83 */
YY_RULE(int) yy_Strong(GREG *G); /* 82 */
YY_RULE(int) yy_Space(GREG *G); /* 81 */
YY_RULE(int) yy_UlOrStarLine(GREG *G); /* 80 */
YY_RULE(int) yy_MathSpan(GREG *G); /* 79 */
YY_RULE(int) yy_Str(GREG *G); /* 78 */
YY_RULE(int) yy_DollarMath(GREG *G); /* 77 */
YY_RULE(int) yy_CriticMarkup(GREG *G); /* 76 */
YY_RULE(int) yy_voidEndline(GREG *G); /* 75 */
YY_RULE(int) yy_Inlines(GREG *G); /* 74 */
YY_RULE(int) yy_Entity(GREG *G); /* 73 */
YY_RULE(int) yy_EscapedChar(GREG *G); /* 72 */
YY_RULE(int) yy_Symbol(GREG *G); /* 71 */
YY_RULE(int) yy_OptionallyIndentedLine(GREG *G); /* 70 */
YY_RULE(int) yy_IndentedLine(GREG *G); /* 69 */
YY_RULE(int) yy_Indent(GREG *G); /* 68 */
YY_RULE(int) yy_NonindentSpace(GREG *G); /* 67 */
YY_RULE(int) yy_CharEntity(GREG *G); /* 66 */
YY_RULE(int) yy_DecEntity(GREG *G); /* 65 */
YY_RULE(int) yy_HexEntity(GREG *G); /* 64 */
YY_RULE(int) yy_Digit(GREG *G); /* 63 */
YY_RULE(int) yy_Alphanumeric(GREG *G); /* 62 */
YY_RULE(int) yy_HtmlBlockScript(GREG *G); /* 61 */
YY_RULE(int) yy_RawHtml(GREG *G); /* 60 */
YY_RULE(int) yy_HtmlTag(GREG *G); /* 59 */
YY_RULE(int) yy_HtmlComment(GREG *G); /* 58 */
YY_RULE(int) yy_HtmlAttribute(GREG *G); /* 57 */
YY_RULE(int) yy_Quoted(GREG *G); /* 56 */
YY_RULE(int) yy_ExtendedSpecialChar(GREG *G); /* 55 */
YY_RULE(int) yy_SpecialChar(GREG *G); /* 54 */
YY_RULE(int) yy_NormalChar(GREG *G); /* 53 */
YY_RULE(int) yy_Nonspacechar(GREG *G); /* 52 */
YY_RULE(int) yy_Spnl(GREG *G); /* 51 */
YY_RULE(int) yy_Spacechar(GREG *G); /* 50 */
YY_RULE(int) yy_Eof(GREG *G); /* 49 */
YY_RULE(int) yy_Line(GREG *G); /* 48 */
YY_RULE(int) yy_BlockQuoteMarker(GREG *G); /* 47 */
YY_RULE(int) yy_BlockQuoteRaw(GREG *G); /* 46 */
YY_RULE(int) yy_Endline(GREG *G); /* 45 */
YY_RULE(int) yy_SetextBottom2(GREG *G); /* 44 */
YY_RULE(int) yy_SetextBottom1(GREG *G); /* 43 */
YY_RULE(int) yy_SetextHeading2(GREG *G); /* 42 */
YY_RULE(int) yy_SetextHeading1(GREG *G); /* 41 */
YY_RULE(int) yy_AtxStart(GREG *G); /* 40 */
YY_RULE(int) yy_Inline(GREG *G); /* 39 */
YY_RULE(int) yy_AutoLabel(GREG *G); /* 38 */
YY_RULE(int) yy_AtxInline(GREG *G); /* 37 */
YY_RULE(int) yy_AtxHeading(GREG *G); /* 36 */
YY_RULE(int) yy_Heading(GREG *G); /* 35 */
YY_RULE(int) yy_HeadingSectionBlock(GREG *G); /* 34 */
YY_RULE(int) yy_Plain(GREG *G); /* 33 */
YY_RULE(int) yy_Para(GREG *G); /* 32 */
YY_RULE(int) yy_HtmlBlockInTags(GREG *G); /* 31 */
YY_RULE(int) yy_ImageBlock(GREG *G); /* 30 */
YY_RULE(int) yy_Table(GREG *G); /* 29 */
YY_RULE(int) yy_StyleBlock(GREG *G); /* 28 */
YY_RULE(int) yy_MarkdownHtmlBlock(GREG *G); /* 27 */
YY_RULE(int) yy_HtmlBlock(GREG *G); /* 26 */
YY_RULE(int) yy_BulletList(GREG *G); /* 25 */
YY_RULE(int) yy_OrderedList(GREG *G); /* 24 */
YY_RULE(int) yy_HeadingSection(GREG *G); /* 23 */
YY_RULE(int) yy_HorizontalRule(GREG *G); /* 22 */
YY_RULE(int) yy_LinkReference(GREG *G); /* 21 */
YY_RULE(int) yy_Note(GREG *G); /* 20 */
YY_RULE(int) yy_Glossary(GREG *G); /* 19 */
YY_RULE(int) yy_DefinitionList(GREG *G); /* 18 */
YY_RULE(int) yy_Verbatim(GREG *G); /* 17 */
YY_RULE(int) yy_BlockQuote(GREG *G); /* 16 */
YY_RULE(int) yy_RawLine(GREG *G); /* 15 */
YY_RULE(int) yy_SingleLineMetaKeyValue(GREG *G); /* 14 */
YY_RULE(int) yy_AlphanumericAscii(GREG *G); /* 13 */
YY_RULE(int) yy_MetaDataValue(GREG *G); /* 12 */
YY_RULE(int) yy_MetaDataKeyValue(GREG *G); /* 11 */
YY_RULE(int) yy_SetextHeading(GREG *G); /* 10 */
YY_RULE(int) yy_BlankLine(GREG *G); /* 9 */
YY_RULE(int) yy_Block(GREG *G); /* 8 */
YY_RULE(int) yy_MetaData(GREG *G); /* 7 */
YY_RULE(int) yy_Newline(GREG *G); /* 6 */
YY_RULE(int) yy_Sp(GREG *G); /* 5 */
YY_RULE(int) yy_MetaDataKey(GREG *G); /* 4 */
YY_RULE(int) yy_StartList(GREG *G); /* 3 */
YY_RULE(int) yy_BOM(GREG *G); /* 2 */
YY_RULE(int) yy_Doc(GREG *G); /* 1 */

YY_ACTION(void) yy_1_RawString(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
  yyprintf((stderr, "do yy_1_RawString"));
  yyprintfvTcontext(yytext);
  yyprintf((stderr, "\n  {yy = str(yytext); }\n"));
  yy = str(yytext); ;
}
YY_ACTION(void) yy_4_DocForCritic(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
#define a G->val[-1]
  yyprintf((stderr, "do yy_4_DocForCritic"));
  yyprintfvTcontext(yytext);
  yyprintf((stderr, "\n  {((parser_data *)G->data)->result = reverse_list(a); }\n"));
  ((parser_data *)G->data)->result = reverse_list(a); ;
#undef a
}
YY_ACTION(void) yy_3_DocForCritic(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
#define a G->val[-1]
  yyprintf((stderr, "do yy_3_DocForCritic"));
  yyprintfvTcontext(yytext);
  yyprintf((stderr, "\n  {a = cons(yy, a); }\n"));
  a = cons(yy, a); ;
#undef a
}
YY_ACTION(void) yy_2_DocForCritic(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
#define a G->val[-1]
  yyprintf((stderr, "do yy_2_DocForCritic"));
  yyprintfvTcontext(yytext);
  yyprintf((stderr, "\n  {a = cons(yy, a); }\n"));
  a = cons(yy, a); ;
#undef a
}
YY_ACTION(void) yy_1_DocForCritic(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
#define a G->val[-1]
  yyprintf((stderr, "do yy_1_DocForCritic"));
  yyprintfvTcontext(yytext);
  yyprintf((stderr, "\n  {a = cons(yy, a); }\n"));
  a = cons(yy, a); ;
#undef a
}
YY_ACTION(void) yy_1_CriticComment(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
  yyprintf((stderr, "do yy_1_CriticComment"));
  yyprintfvTcontext(yytext);
  yyprintf((stderr, "\n  {yy = str(yytext); yy->key = CRITICCOMMENT; }\n"));
  yy = str(yytext); yy->key = CRITICCOMMENT; ;
}
YY_ACTION(void) yy_1_CriticHighlight(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
  yyprintf((stderr, "do yy_1_CriticHighlight"));
  yyprintfvTcontext(yytext);
  yyprintf((stderr, "\n  {yy = str(yytext); yy->key = CRITICHIGHLIGHT; }\n"));
  yy = str(yytext); yy->key = CRITICHIGHLIGHT; ;
}
YY_ACTION(void) yy_1_CriticSubstAdd(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
  yyprintf((stderr, "do yy_1_CriticSubstAdd"));
  yyprintfvTcontext(yytext);
  yyprintf((stderr, "\n  {yy = str(yytext); yy->key = CRITICADDITION; }\n"));
  yy = str(yytext); yy->key = CRITICADDITION; ;
}
YY_ACTION(void) yy_1_CriticSubstDel(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
  yyprintf((stderr, "do yy_1_CriticSubstDel"));
  yyprintfvTcontext(yytext);
  yyprintf((stderr, "\n  {yy = str(yytext); yy->key = CRITICDELETION; }\n"));
  yy = str(yytext); yy->key = CRITICDELETION; ;
}
YY_ACTION(void) yy_3_CriticSubstitution(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
#define a G->val[-1]
  yyprintf((stderr, "do yy_3_CriticSubstitution"));
  yyprintfvTcontext(yytext);
  yyprintf((stderr, "\n  {yy = list(CRITICSUBSTITUTION, a); }\n"));
  yy = list(CRITICSUBSTITUTION, a); ;
#undef a
}
YY_ACTION(void) yy_2_CriticSubstitution(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
#define a G->val[-1]
  yyprintf((stderr, "do yy_2_CriticSubstitution"));
  yyprintfvTcontext(yytext);
  yyprintf((stderr, "\n  {a = cons(yy,a); }\n"));
  a = cons(yy,a); ;
#undef a
}
YY_ACTION(void) yy_1_CriticSubstitution(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
#define a G->val[-1]
  yyprintf((stderr, "do yy_1_CriticSubstitution"));
  yyprintfvTcontext(yytext);
  yyprintf((stderr, "\n  {a = cons(yy,a); }\n"));
  a = cons(yy,a); ;
#undef a
}
YY_ACTION(void) yy_1_CriticDeletion(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
  yyprintf((stderr, "do yy_1_CriticDeletion"));
  yyprintfvTcontext(yytext);
  yyprintf((stderr, "\n  {yy = str(yytext); yy->key = CRITICDELETION; }\n"));
  yy = str(yytext); yy->key = CRITICDELETION; ;
}
YY_ACTION(void) yy_1_CriticAddition(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
  yyprintf((stderr, "do yy_1_CriticAddition"));
  yyprintfvTcontext(yytext);
  yyprintf((stderr, "\n  {yy = str(yytext); yy->key = CRITICADDITION; }\n"));
  yy = str(yytext); yy->key = CRITICADDITION; ;
}
YY_ACTION(void) yy_2_OPMLPlain(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
#define a G->val[-1]
  yyprintf((stderr, "do yy_2_OPMLPlain"));
  yyprintfvTcontext(yytext);
  yyprintf((stderr, "\n  {yy = mk_list(PLAIN, a); }\n"));
  yy = mk_list(PLAIN, a); ;
#undef a
}
YY_ACTION(void) yy_1_OPMLPlain(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
#define a G->val[-1]
  yyprintf((stderr, "do yy_1_OPMLPlain"));
  yyprintfvTcontext(yytext);
  yyprintf((stderr, "\n  {a = cons(yy,a); }\n"));
  a = cons(yy,a); ;
#undef a
}
YY_ACTION(void) yy_1_OPMLSetextHeading2(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
  yyprintf((stderr, "do yy_1_OPMLSetextHeading2"));
  yyprintfvTcontext(yytext);
  yyprintf((stderr, "\n  {yy = str(yytext); yy->key = H2; }\n"));
  yy = str(yytext); yy->key = H2; ;
}
YY_ACTION(void) yy_1_OPMLSetextHeading1(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
  yyprintf((stderr, "do yy_1_OPMLSetextHeading1"));
  yyprintfvTcontext(yytext);
  yyprintf((stderr, "\n  {yy = str(yytext); yy->key = H1; }\n"));
  yy = str(yytext); yy->key = H1; ;
}
YY_ACTION(void) yy_1_OPMLAtxHeading(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
#define s G->val[-1]
  yyprintf((stderr, "do yy_1_OPMLAtxHeading"));
  yyprintfvTcontext(yytext);
  yyprintf((stderr, "\n  {\n\
\t\t\tyy = str(yytext);\n\
\t\t\tyy->key = s->key;\n\
\t\t\tfree_node(s);\n\
\t\t}\n"));
  
			yy = str(yytext);
			yy->key = s->key;
			free_node(s);
		;
#undef s
}
YY_ACTION(void) yy_3_OPMLHeadingSection(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
#define a G->val[-1]
  yyprintf((stderr, "do yy_3_OPMLHeadingSection"));
  yyprintfvTcontext(yytext);
  yyprintf((stderr, "\n  {yy = mk_list(HEADINGSECTION, a);}\n"));
  yy = mk_list(HEADINGSECTION, a);;
#undef a
}
YY_ACTION(void) yy_2_OPMLHeadingSection(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
#define a G->val[-1]
  yyprintf((stderr, "do yy_2_OPMLHeadingSection"));
  yyprintfvTcontext(yytext);
  yyprintf((stderr, "\n  {a = cons(yy, a); }\n"));
  a = cons(yy, a); ;
#undef a
}
YY_ACTION(void) yy_1_OPMLHeadingSection(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
#define a G->val[-1]
  yyprintf((stderr, "do yy_1_OPMLHeadingSection"));
  yyprintfvTcontext(yytext);
  yyprintf((stderr, "\n  {a = cons(yy, a); }\n"));
  a = cons(yy, a); ;
#undef a
}
YY_ACTION(void) yy_3_DocForOPML(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
#define a G->val[-1]
  yyprintf((stderr, "do yy_3_DocForOPML"));
  yyprintfvTcontext(yytext);
  yyprintf((stderr, "\n  {((parser_data *)G->data)->result = reverse_list(a); }\n"));
  ((parser_data *)G->data)->result = reverse_list(a); ;
#undef a
}
YY_ACTION(void) yy_2_DocForOPML(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
#define a G->val[-1]
  yyprintf((stderr, "do yy_2_DocForOPML"));
  yyprintfvTcontext(yytext);
  yyprintf((stderr, "\n  {a = cons(yy, a); }\n"));
  a = cons(yy, a); ;
#undef a
}
YY_ACTION(void) yy_1_DocForOPML(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
#define a G->val[-1]
  yyprintf((stderr, "do yy_1_DocForOPML"));
  yyprintfvTcontext(yytext);
  yyprintf((stderr, "\n  {a = cons(yy, a); }\n"));
  a = cons(yy, a); ;
#undef a
}
YY_ACTION(void) yy_3_RawNoteBlock(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
#define a G->val[-1]
  yyprintf((stderr, "do yy_3_RawNoteBlock"));
  yyprintfvTcontext(yytext);
  yyprintf((stderr, "\n  {yy = mk_str_from_list(a, true); yy->key = RAW; }\n"));
  yy = mk_str_from_list(a, true); yy->key = RAW; ;
#undef a
}
YY_ACTION(void) yy_2_RawNoteBlock(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
#define a G->val[-1]
  yyprintf((stderr, "do yy_2_RawNoteBlock"));
  yyprintfvTcontext(yytext);
  yyprintf((stderr, "\n  {a = cons(str(yytext), a); }\n"));
  a = cons(str(yytext), a); ;
#undef a
}
YY_ACTION(void) yy_1_RawNoteBlock(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
#define a G->val[-1]
  yyprintf((stderr, "do yy_1_RawNoteBlock"));
  yyprintfvTcontext(yytext);
  yyprintf((stderr, "\n  {a = cons(yy, a); }\n"));
  a = cons(yy, a); ;
#undef a
}
YY_ACTION(void) yy_3_Note(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
#define a G->val[-1]
#define ref G->val[-2]
  yyprintf((stderr, "do yy_3_Note"));
  yyprintfvTcontext(yytext);
  yyprintf((stderr, "\n  {\n\
\t\t\tnode *label;\n\
\t\t\tlabel = str(ref->str);\n\
\t\t\tlabel->key = NOTELABEL;\n\
\t\t\ta = cons(label,a);\n\
\t\t\tyy = list(NOTESOURCE, a);\n\
\t\t\tyy->str = strdup(ref->str);\n\
\t\t\t\n\
\t\t\tfree_node(ref);\n\
\t\t}\n"));
  
			node *label;
			label = str(ref->str);
			label->key = NOTELABEL;
			a = cons(label,a);
			yy = list(NOTESOURCE, a);
			yy->str = strdup(ref->str);
			
			free_node(ref);
		;
#undef a
#undef ref
}
YY_ACTION(void) yy_2_Note(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
#define a G->val[-1]
#define ref G->val[-2]
  yyprintf((stderr, "do yy_2_Note"));
  yyprintfvTcontext(yytext);
  yyprintf((stderr, "\n  {a = cons(yy, a); }\n"));
  a = cons(yy, a); ;
#undef a
#undef ref
}
YY_ACTION(void) yy_1_Note(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
#define a G->val[-1]
#define ref G->val[-2]
  yyprintf((stderr, "do yy_1_Note"));
  yyprintfvTcontext(yytext);
  yyprintf((stderr, "\n  {a = cons(yy, a); }\n"));
  a = cons(yy, a); ;
#undef a
#undef ref
}
YY_ACTION(void) yy_1_RawNoteReference(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
  yyprintf((stderr, "do yy_1_RawNoteReference"));
  yyprintfvTcontext(yytext);
  yyprintf((stderr, "\n  {yy = str(yytext); }\n"));
  yy = str(yytext); ;
}
YY_ACTION(void) yy_2_TableCaption(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
#define c G->val[-1]
#define a G->val[-2]
#define b G->val[-3]
  yyprintf((stderr, "do yy_2_TableCaption"));
  yyprintfvTcontext(yytext);
  yyprintf((stderr, "\n  {\n\
\t\t\tyy = a;\n\
\t\t\tyy->key = TABLECAPTION;\n\
\t\t\tif ( (b != NULL) && (b->key == TABLELABEL) ) {\n\
\t\t\t\tb->next = yy->children;\n\
\t\t\t\tyy->children = b;\n\
\t\t\t}\n\
\t\t}\n"));
  
			yy = a;
			yy->key = TABLECAPTION;
			if ( (b != NULL) && (b->key == TABLELABEL) ) {
				b->next = yy->children;
				yy->children = b;
			}
		;
#undef c
#undef a
#undef b
}
YY_ACTION(void) yy_1_TableCaption(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
#define c G->val[-1]
#define a G->val[-2]
#define b G->val[-3]
  yyprintf((stderr, "do yy_1_TableCaption"));
  yyprintfvTcontext(yytext);
  yyprintf((stderr, "\n  {b = c; b->key = TABLELABEL;}\n"));
  b = c; b->key = TABLELABEL;;
#undef c
#undef a
#undef b
}
YY_ACTION(void) yy_1_RightAlign(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
  yyprintf((stderr, "do yy_1_RightAlign"));
  yyprintfvTcontext(yytext);
  yyprintf((stderr, "\n  {yy = mk_str(\"r\");}\n"));
  yy = mk_str("r");;
}
YY_ACTION(void) yy_1_RightAlignWrap(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
  yyprintf((stderr, "do yy_1_RightAlignWrap"));
  yyprintfvTcontext(yytext);
  yyprintf((stderr, "\n  {yy = mk_str(\"R\");}\n"));
  yy = mk_str("R");;
}
YY_ACTION(void) yy_1_CenterAlign(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
  yyprintf((stderr, "do yy_1_CenterAlign"));
  yyprintfvTcontext(yytext);
  yyprintf((stderr, "\n  {yy = mk_str(\"c\");}\n"));
  yy = mk_str("c");;
}
YY_ACTION(void) yy_1_CenterAlignWrap(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
  yyprintf((stderr, "do yy_1_CenterAlignWrap"));
  yyprintfvTcontext(yytext);
  yyprintf((stderr, "\n  {yy = mk_str(\"C\");}\n"));
  yy = mk_str("C");;
}
YY_ACTION(void) yy_1_LeftAlign(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
  yyprintf((stderr, "do yy_1_LeftAlign"));
  yyprintfvTcontext(yytext);
  yyprintf((stderr, "\n  {yy = mk_str(\"l\");}\n"));
  yy = mk_str("l");;
}
YY_ACTION(void) yy_1_LeftAlignWrap(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
  yyprintf((stderr, "do yy_1_LeftAlignWrap"));
  yyprintfvTcontext(yytext);
  yyprintf((stderr, "\n  {yy = mk_str(\"L\");}\n"));
  yy = mk_str("L");;
}
YY_ACTION(void) yy_2_SeparatorLine(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
#define a G->val[-1]
  yyprintf((stderr, "do yy_2_SeparatorLine"));
  yyprintfvTcontext(yytext);
  yyprintf((stderr, "\n  {\n\
\t\t\tyy = mk_str_from_list(a,false);\n\
\t\t\tyy->key = TABLESEPARATOR;\n\
\t\t}\n"));
  
			yy = mk_str_from_list(a,false);
			yy->key = TABLESEPARATOR;
		;
#undef a
}
YY_ACTION(void) yy_1_SeparatorLine(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
#define a G->val[-1]
  yyprintf((stderr, "do yy_1_SeparatorLine"));
  yyprintfvTcontext(yytext);
  yyprintf((stderr, "\n  {a = cons(yy, a);}\n"));
  a = cons(yy, a);;
#undef a
}
YY_ACTION(void) yy_1_EmptyCell(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
  yyprintf((stderr, "do yy_1_EmptyCell"));
  yyprintfvTcontext(yytext);
  yyprintf((stderr, "\n  {yy = node(TABLECELL); }\n"));
  yy = node(TABLECELL); ;
}
YY_ACTION(void) yy_2_FullCell(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
#define a G->val[-1]
  yyprintf((stderr, "do yy_2_FullCell"));
  yyprintfvTcontext(yytext);
  yyprintf((stderr, "\n  {yy = list(TABLECELL,a); }\n"));
  yy = list(TABLECELL,a); ;
#undef a
}
YY_ACTION(void) yy_1_FullCell(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
#define a G->val[-1]
  yyprintf((stderr, "do yy_1_FullCell"));
  yyprintfvTcontext(yytext);
  yyprintf((stderr, "\n  {a = cons(yy,a)}\n"));
  a = cons(yy,a);
#undef a
}
YY_ACTION(void) yy_1_CellStr(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
  yyprintf((stderr, "do yy_1_CellStr"));
  yyprintfvTcontext(yytext);
  yyprintf((stderr, "\n  {yy = str(yytext); }\n"));
  yy = str(yytext); ;
}
YY_ACTION(void) yy_1_ExtendedCell(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
  yyprintf((stderr, "do yy_1_ExtendedCell"));
  yyprintfvTcontext(yytext);
  yyprintf((stderr, "\n  {\n\
\t\tnode *span;\n\
\t\tspan = str(yytext);\n\
\t\tspan->key = CELLSPAN;\n\
\t\tspan->next = yy->children;\n\
\t\tyy->children = span;\n\
    }\n"));
  
		node *span;
		span = str(yytext);
		span->key = CELLSPAN;
		span->next = yy->children;
		yy->children = span;
    ;
}
YY_ACTION(void) yy_2_TableRow(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
#define a G->val[-1]
  yyprintf((stderr, "do yy_2_TableRow"));
  yyprintfvTcontext(yytext);
  yyprintf((stderr, "\n  {yy = list(TABLEROW, a); }\n"));
  yy = list(TABLEROW, a); ;
#undef a
}
YY_ACTION(void) yy_1_TableRow(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
#define a G->val[-1]
  yyprintf((stderr, "do yy_1_TableRow"));
  yyprintfvTcontext(yytext);
  yyprintf((stderr, "\n  {a = cons(yy, a); }\n"));
  a = cons(yy, a); ;
#undef a
}
YY_ACTION(void) yy_2_TableBody(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
#define a G->val[-1]
  yyprintf((stderr, "do yy_2_TableBody"));
  yyprintfvTcontext(yytext);
  yyprintf((stderr, "\n  {yy = list(TABLEBODY, a);}\n"));
  yy = list(TABLEBODY, a);;
#undef a
}
YY_ACTION(void) yy_1_TableBody(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
#define a G->val[-1]
  yyprintf((stderr, "do yy_1_TableBody"));
  yyprintfvTcontext(yytext);
  yyprintf((stderr, "\n  {a = cons(yy, a);}\n"));
  a = cons(yy, a);;
#undef a
}
YY_ACTION(void) yy_7_Table(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
#define b G->val[-1]
#define a G->val[-2]
  yyprintf((stderr, "do yy_7_Table"));
  yyprintfvTcontext(yytext);
  yyprintf((stderr, "\n  {\n\
\t\t\tif (b != NULL) { append_list(b,a); };\n\
\t\t\tyy = list(TABLE, a);\n\
\t\t}\n"));
  
			if (b != NULL) { append_list(b,a); };
			yy = list(TABLE, a);
		;
#undef b
#undef a
}
YY_ACTION(void) yy_6_Table(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
#define b G->val[-1]
#define a G->val[-2]
  yyprintf((stderr, "do yy_6_Table"));
  yyprintfvTcontext(yytext);
  yyprintf((stderr, "\n  {b = cons(yy, b);}\n"));
  b = cons(yy, b);;
#undef b
#undef a
}
YY_ACTION(void) yy_5_Table(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
#define b G->val[-1]
#define a G->val[-2]
  yyprintf((stderr, "do yy_5_Table"));
  yyprintfvTcontext(yytext);
  yyprintf((stderr, "\n  {a = cons(yy, a); }\n"));
  a = cons(yy, a); ;
#undef b
#undef a
}
YY_ACTION(void) yy_4_Table(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
#define b G->val[-1]
#define a G->val[-2]
  yyprintf((stderr, "do yy_4_Table"));
  yyprintfvTcontext(yytext);
  yyprintf((stderr, "\n  {a = cons(yy, a);}\n"));
  a = cons(yy, a);;
#undef b
#undef a
}
YY_ACTION(void) yy_3_Table(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
#define b G->val[-1]
#define a G->val[-2]
  yyprintf((stderr, "do yy_3_Table"));
  yyprintfvTcontext(yytext);
  yyprintf((stderr, "\n  {append_list(yy,a); }\n"));
  append_list(yy,a); ;
#undef b
#undef a
}
YY_ACTION(void) yy_2_Table(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
#define b G->val[-1]
#define a G->val[-2]
  yyprintf((stderr, "do yy_2_Table"));
  yyprintfvTcontext(yytext);
  yyprintf((stderr, "\n  {yy->key = TABLEHEAD; a = cons(yy, a); }\n"));
  yy->key = TABLEHEAD; a = cons(yy, a); ;
#undef b
#undef a
}
YY_ACTION(void) yy_1_Table(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
#define b G->val[-1]
#define a G->val[-2]
  yyprintf((stderr, "do yy_1_Table"));
  yyprintfvTcontext(yytext);
  yyprintf((stderr, "\n  {b = cons(yy, b);}\n"));
  b = cons(yy, b);;
#undef b
#undef a
}
YY_ACTION(void) yy_1_StyleBlock(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
  yyprintf((stderr, "do yy_1_StyleBlock"));
  yyprintfvTcontext(yytext);
  yyprintf((stderr, "\n  {\n\
\t\t\tif (ext(EXT_FILTER_STYLES)) {\n\
\t\t\t\tyy = mk_list(LIST, NULL);\n\
\t\t\t} else {\n\
\t\t\t\tyy = mk_str(yytext);\n\
\t\t\t\tyy->key = HTMLBLOCK;\n\
\t\t\t}\n\
\t\t}\n"));
  
			if (ext(EXT_FILTER_STYLES)) {
				yy = mk_list(LIST, NULL);
			} else {
				yy = mk_str(yytext);
				yy->key = HTMLBLOCK;
			}
		;
}
YY_ACTION(void) yy_6_MarkdownHtmlTagOpen(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
#define a G->val[-1]
  yyprintf((stderr, "do yy_6_MarkdownHtmlTagOpen"));
  yyprintfvTcontext(yytext);
  yyprintf((stderr, "\n  {yy = mk_str_from_list(a,false); yy->key = HTML; }\n"));
  yy = mk_str_from_list(a,false); yy->key = HTML; ;
#undef a
}
YY_ACTION(void) yy_5_MarkdownHtmlTagOpen(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
#define a G->val[-1]
  yyprintf((stderr, "do yy_5_MarkdownHtmlTagOpen"));
  yyprintfvTcontext(yytext);
  yyprintf((stderr, "\n  {a = cons(mk_str(\">\"),a);}\n"));
  a = cons(mk_str(">"),a);;
#undef a
}
YY_ACTION(void) yy_4_MarkdownHtmlTagOpen(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
#define a G->val[-1]
  yyprintf((stderr, "do yy_4_MarkdownHtmlTagOpen"));
  yyprintfvTcontext(yytext);
  yyprintf((stderr, "\n  {a = cons(mk_str(\" \"),a);\n\
\t\t\t\ta = cons(mk_str(yytext),a);}\n"));
  a = cons(mk_str(" "),a);
				a = cons(mk_str(yytext),a);;
#undef a
}
YY_ACTION(void) yy_3_MarkdownHtmlTagOpen(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
#define a G->val[-1]
  yyprintf((stderr, "do yy_3_MarkdownHtmlTagOpen"));
  yyprintfvTcontext(yytext);
  yyprintf((stderr, "\n  {a = cons(mk_str(\" \"),a);\n\
\t\t\t\ta = cons(mk_str(yytext),a);}\n"));
  a = cons(mk_str(" "),a);
				a = cons(mk_str(yytext),a);;
#undef a
}
YY_ACTION(void) yy_2_MarkdownHtmlTagOpen(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
#define a G->val[-1]
  yyprintf((stderr, "do yy_2_MarkdownHtmlTagOpen"));
  yyprintfvTcontext(yytext);
  yyprintf((stderr, "\n  {a = cons(mk_str(yytext),a);}\n"));
  a = cons(mk_str(yytext),a);;
#undef a
}
YY_ACTION(void) yy_1_MarkdownHtmlTagOpen(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
#define a G->val[-1]
  yyprintf((stderr, "do yy_1_MarkdownHtmlTagOpen"));
  yyprintfvTcontext(yytext);
  yyprintf((stderr, "\n  {a = cons(mk_str(\"<\"),a);}\n"));
  a = cons(mk_str("<"),a);;
#undef a
}
YY_ACTION(void) yy_1_MarkdownHtmlBlock(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
  yyprintf((stderr, "do yy_1_MarkdownHtmlBlock"));
  yyprintfvTcontext(yytext);
  yyprintf((stderr, "\n  {yy = str(yytext); yy->key = RAW; }\n"));
  yy = str(yytext); yy->key = RAW; ;
}
YY_ACTION(void) yy_1_HtmlBlock(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
  yyprintf((stderr, "do yy_1_HtmlBlock"));
  yyprintfvTcontext(yytext);
  yyprintf((stderr, "\n  {\n\
\t\t\tif (ext(EXT_FILTER_HTML)) {\n\
\t\t\t\tyy = mk_list(LIST, NULL);\n\
\t\t\t} else {\n\
\t\t\t\tyy = str(yytext);\n\
\t\t\t\tif ( ext(EXT_PROCESS_HTML)) yy->key = RAW;\n\
\t\t\t\telse yy->key = HTMLBLOCK;\n\
\t\t\t}\n\
\t\t}\n"));
  
			if (ext(EXT_FILTER_HTML)) {
				yy = mk_list(LIST, NULL);
			} else {
				yy = str(yytext);
				if ( ext(EXT_PROCESS_HTML)) yy->key = RAW;
				else yy->key = HTMLBLOCK;
			}
		;
}
YY_ACTION(void) yy_1_OrderedList(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
  yyprintf((stderr, "do yy_1_OrderedList"));
  yyprintfvTcontext(yytext);
  yyprintf((stderr, "\n  {yy->key = ORDEREDLIST; }\n"));
  yy->key = ORDEREDLIST; ;
}
YY_ACTION(void) yy_3_ListContinuationBlock(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
#define a G->val[-1]
  yyprintf((stderr, "do yy_3_ListContinuationBlock"));
  yyprintfvTcontext(yytext);
  yyprintf((stderr, "\n  {yy = mk_str_from_list(a, false); }\n"));
  yy = mk_str_from_list(a, false); ;
#undef a
}
YY_ACTION(void) yy_2_ListContinuationBlock(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
#define a G->val[-1]
  yyprintf((stderr, "do yy_2_ListContinuationBlock"));
  yyprintfvTcontext(yytext);
  yyprintf((stderr, "\n  {a = cons(yy, a); }\n"));
  a = cons(yy, a); ;
#undef a
}
YY_ACTION(void) yy_1_ListContinuationBlock(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
#define a G->val[-1]
  yyprintf((stderr, "do yy_1_ListContinuationBlock"));
  yyprintfvTcontext(yytext);
  yyprintf((stderr, "\n  {\n\
\t\t\tif (strlen(yytext) == 0)\n\
\t\t\t\ta = cons(str(\"\\001\"), a); /* block separator */\n\
\t\t\telse\n\
\t\t\t\ta = cons(str(yytext), a);\n\
\t\t}\n"));
  
			if (strlen(yytext) == 0)
				a = cons(str("\001"), a); /* block separator */
			else
				a = cons(str(yytext), a);
		;
#undef a
}
YY_ACTION(void) yy_3_ListBlock(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
#define a G->val[-1]
  yyprintf((stderr, "do yy_3_ListBlock"));
  yyprintfvTcontext(yytext);
  yyprintf((stderr, "\n  {yy = mk_str_from_list(a, false); }\n"));
  yy = mk_str_from_list(a, false); ;
#undef a
}
YY_ACTION(void) yy_2_ListBlock(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
#define a G->val[-1]
  yyprintf((stderr, "do yy_2_ListBlock"));
  yyprintfvTcontext(yytext);
  yyprintf((stderr, "\n  {a = cons(yy, a); }\n"));
  a = cons(yy, a); ;
#undef a
}
YY_ACTION(void) yy_1_ListBlock(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
#define a G->val[-1]
  yyprintf((stderr, "do yy_1_ListBlock"));
  yyprintfvTcontext(yytext);
  yyprintf((stderr, "\n  {a = cons(yy, a); }\n"));
  a = cons(yy, a); ;
#undef a
}
YY_ACTION(void) yy_3_ListItemTight(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
#define a G->val[-1]
  yyprintf((stderr, "do yy_3_ListItemTight"));
  yyprintfvTcontext(yytext);
  yyprintf((stderr, "\n  {\n\
\t\t\tnode *raw;\n\
\t\t\traw = mk_str_from_list(a, false);\n\
\t\t\traw->key = RAW;\n\
\t\t\tyy = node(LISTITEM);\n\
\t\t\tyy->children = raw;\n\
\t\t}\n"));
  
			node *raw;
			raw = mk_str_from_list(a, false);
			raw->key = RAW;
			yy = node(LISTITEM);
			yy->children = raw;
		;
#undef a
}
YY_ACTION(void) yy_2_ListItemTight(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
#define a G->val[-1]
  yyprintf((stderr, "do yy_2_ListItemTight"));
  yyprintfvTcontext(yytext);
  yyprintf((stderr, "\n  {a = cons(yy, a); }\n"));
  a = cons(yy, a); ;
#undef a
}
YY_ACTION(void) yy_1_ListItemTight(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
#define a G->val[-1]
  yyprintf((stderr, "do yy_1_ListItemTight"));
  yyprintfvTcontext(yytext);
  yyprintf((stderr, "\n  {a = cons(yy, a); }\n"));
  a = cons(yy, a); ;
#undef a
}
YY_ACTION(void) yy_3_ListItem(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
#define a G->val[-1]
  yyprintf((stderr, "do yy_3_ListItem"));
  yyprintfvTcontext(yytext);
  yyprintf((stderr, "\n  {\n\
\t\t\tnode *raw;\n\
\t\t\traw = mk_str_from_list(a, false);\n\
\t\t\traw->key = RAW;\n\
\t\t\tyy = node(LISTITEM);\n\
\t\t\tyy->children = raw;\n\
\t\t}\n"));
  
			node *raw;
			raw = mk_str_from_list(a, false);
			raw->key = RAW;
			yy = node(LISTITEM);
			yy->children = raw;
		;
#undef a
}
YY_ACTION(void) yy_2_ListItem(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
#define a G->val[-1]
  yyprintf((stderr, "do yy_2_ListItem"));
  yyprintfvTcontext(yytext);
  yyprintf((stderr, "\n  {a = cons(yy, a); }\n"));
  a = cons(yy, a); ;
#undef a
}
YY_ACTION(void) yy_1_ListItem(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
#define a G->val[-1]
  yyprintf((stderr, "do yy_1_ListItem"));
  yyprintfvTcontext(yytext);
  yyprintf((stderr, "\n  {a = cons(yy, a); }\n"));
  a = cons(yy, a); ;
#undef a
}
YY_ACTION(void) yy_2_ListLoose(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
#define b G->val[-1]
#define a G->val[-2]
  yyprintf((stderr, "do yy_2_ListLoose"));
  yyprintfvTcontext(yytext);
  yyprintf((stderr, "\n  {yy = list(LIST, a); }\n"));
  yy = list(LIST, a); ;
#undef b
#undef a
}
YY_ACTION(void) yy_1_ListLoose(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
#define b G->val[-1]
#define a G->val[-2]
  yyprintf((stderr, "do yy_1_ListLoose"));
  yyprintfvTcontext(yytext);
  yyprintf((stderr, "\n  {\n\
\t\t\tnode *li;\n\
\t\t\tli = b->children;\n\
\t\t\tli->str = realloc(li->str, strlen(li->str) + 3);\n\
\t\t\tstrcat(li->str, \"\\n\\n\");  /* In loose list, \\n\\n added to end of each element */\n\
\t\t\ta = cons(b, a);\n\
\t\t}\n"));
  
			node *li;
			li = b->children;
			li->str = realloc(li->str, strlen(li->str) + 3);
			strcat(li->str, "\n\n");  /* In loose list, \n\n added to end of each element */
			a = cons(b, a);
		;
#undef b
#undef a
}
YY_ACTION(void) yy_2_ListTight(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
#define a G->val[-1]
  yyprintf((stderr, "do yy_2_ListTight"));
  yyprintfvTcontext(yytext);
  yyprintf((stderr, "\n  {yy = list(LIST, a); }\n"));
  yy = list(LIST, a); ;
#undef a
}
YY_ACTION(void) yy_1_ListTight(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
#define a G->val[-1]
  yyprintf((stderr, "do yy_1_ListTight"));
  yyprintfvTcontext(yytext);
  yyprintf((stderr, "\n  {a = cons(yy, a); }\n"));
  a = cons(yy, a); ;
#undef a
}
YY_ACTION(void) yy_1_BulletList(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
  yyprintf((stderr, "do yy_1_BulletList"));
  yyprintfvTcontext(yytext);
  yyprintf((stderr, "\n  {yy->key = BULLETLIST; }\n"));
  yy->key = BULLETLIST; ;
}
YY_ACTION(void) yy_7_Definition(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
#define b G->val[-1]
#define a G->val[-2]
  yyprintf((stderr, "do yy_7_Definition"));
  yyprintfvTcontext(yytext);
  yyprintf((stderr, "\n  {\n\
\t\t\tif (b != NULL) { a = cons(b,a);}\n\
\t\t\tnode *raw = mk_str_from_list(a, false);\n\
\t\t\traw->key = RAW;\n\
\t\t\tyy = list(DEFINITION,raw);\n\
\t\t}\n"));
  
			if (b != NULL) { a = cons(b,a);}
			node *raw = mk_str_from_list(a, false);
			raw->key = RAW;
			yy = list(DEFINITION,raw);
		;
#undef b
#undef a
}
YY_ACTION(void) yy_6_Definition(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
#define b G->val[-1]
#define a G->val[-2]
  yyprintf((stderr, "do yy_6_Definition"));
  yyprintfvTcontext(yytext);
  yyprintf((stderr, "\n  {a = cons(mk_str(\"\\n\"),a);}\n"));
  a = cons(mk_str("\n"),a);;
#undef b
#undef a
}
YY_ACTION(void) yy_5_Definition(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
#define b G->val[-1]
#define a G->val[-2]
  yyprintf((stderr, "do yy_5_Definition"));
  yyprintfvTcontext(yytext);
  yyprintf((stderr, "\n  {a = cons(mk_str(yytext),a);}\n"));
  a = cons(mk_str(yytext),a);;
#undef b
#undef a
}
YY_ACTION(void) yy_4_Definition(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
#define b G->val[-1]
#define a G->val[-2]
  yyprintf((stderr, "do yy_4_Definition"));
  yyprintfvTcontext(yytext);
  yyprintf((stderr, "\n  {a = cons(mk_str(\"\\n\"),a);}\n"));
  a = cons(mk_str("\n"),a);;
#undef b
#undef a
}
YY_ACTION(void) yy_3_Definition(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
#define b G->val[-1]
#define a G->val[-2]
  yyprintf((stderr, "do yy_3_Definition"));
  yyprintfvTcontext(yytext);
  yyprintf((stderr, "\n  {a = cons(mk_str(yytext), a);}\n"));
  a = cons(mk_str(yytext), a);;
#undef b
#undef a
}
YY_ACTION(void) yy_2_Definition(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
#define b G->val[-1]
#define a G->val[-2]
  yyprintf((stderr, "do yy_2_Definition"));
  yyprintfvTcontext(yytext);
  yyprintf((stderr, "\n  {a = cons(mk_str(yytext), a);}\n"));
  a = cons(mk_str(yytext), a);;
#undef b
#undef a
}
YY_ACTION(void) yy_1_Definition(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
#define b G->val[-1]
#define a G->val[-2]
  yyprintf((stderr, "do yy_1_Definition"));
  yyprintfvTcontext(yytext);
  yyprintf((stderr, "\n  {b = cons(mk_str(\"\\n\"),b); }\n"));
  b = cons(mk_str("\n"),b); ;
#undef b
#undef a
}
YY_ACTION(void) yy_2_Term(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
#define a G->val[-1]
  yyprintf((stderr, "do yy_2_Term"));
  yyprintfvTcontext(yytext);
  yyprintf((stderr, "\n  {yy = mk_list(TERM,a); }\n"));
  yy = mk_list(TERM,a); ;
#undef a
}
YY_ACTION(void) yy_1_Term(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
#define a G->val[-1]
  yyprintf((stderr, "do yy_1_Term"));
  yyprintfvTcontext(yytext);
  yyprintf((stderr, "\n  {a = cons(yy, a);}\n"));
  a = cons(yy, a);;
#undef a
}
YY_ACTION(void) yy_3_DefinitionList(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
#define a G->val[-1]
  yyprintf((stderr, "do yy_3_DefinitionList"));
  yyprintfvTcontext(yytext);
  yyprintf((stderr, "\n  {yy = mk_list(LIST, a); yy->key = DEFLIST; }\n"));
  yy = mk_list(LIST, a); yy->key = DEFLIST; ;
#undef a
}
YY_ACTION(void) yy_2_DefinitionList(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
#define a G->val[-1]
  yyprintf((stderr, "do yy_2_DefinitionList"));
  yyprintfvTcontext(yytext);
  yyprintf((stderr, "\n  {a = cons(yy, a);}\n"));
  a = cons(yy, a);;
#undef a
}
YY_ACTION(void) yy_1_DefinitionList(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
#define a G->val[-1]
  yyprintf((stderr, "do yy_1_DefinitionList"));
  yyprintfvTcontext(yytext);
  yyprintf((stderr, "\n  {a = cons(yy, a); }\n"));
  a = cons(yy, a); ;
#undef a
}
YY_ACTION(void) yy_1_HorizontalRule(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
  yyprintf((stderr, "do yy_1_HorizontalRule"));
  yyprintfvTcontext(yytext);
  yyprintf((stderr, "\n  {yy = mk_node(HRULE); }\n"));
  yy = mk_node(HRULE); ;
}
YY_ACTION(void) yy_2_Verbatim(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
#define a G->val[-1]
  yyprintf((stderr, "do yy_2_Verbatim"));
  yyprintfvTcontext(yytext);
  yyprintf((stderr, "\n  {yy = mk_str_from_list(a, false); yy->key = VERBATIM; }\n"));
  yy = mk_str_from_list(a, false); yy->key = VERBATIM; ;
#undef a
}
YY_ACTION(void) yy_1_Verbatim(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
#define a G->val[-1]
  yyprintf((stderr, "do yy_1_Verbatim"));
  yyprintfvTcontext(yytext);
  yyprintf((stderr, "\n  {a = cons(yy, a); }\n"));
  a = cons(yy, a); ;
#undef a
}
YY_ACTION(void) yy_3_VerbatimChunk(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
#define a G->val[-1]
  yyprintf((stderr, "do yy_3_VerbatimChunk"));
  yyprintfvTcontext(yytext);
  yyprintf((stderr, "\n  {yy = mk_str_from_list(a, false); }\n"));
  yy = mk_str_from_list(a, false); ;
#undef a
}
YY_ACTION(void) yy_2_VerbatimChunk(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
#define a G->val[-1]
  yyprintf((stderr, "do yy_2_VerbatimChunk"));
  yyprintfvTcontext(yytext);
  yyprintf((stderr, "\n  {a = cons(yy, a); }\n"));
  a = cons(yy, a); ;
#undef a
}
YY_ACTION(void) yy_1_VerbatimChunk(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
#define a G->val[-1]
  yyprintf((stderr, "do yy_1_VerbatimChunk"));
  yyprintfvTcontext(yytext);
  yyprintf((stderr, "\n  {a = cons(mk_str(\"\\n\"), a); }\n"));
  a = cons(mk_str("\n"), a); ;
#undef a
}
YY_ACTION(void) yy_2_DoubleQuoted(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
#define b G->val[-1]
#define a G->val[-2]
  yyprintf((stderr, "do yy_2_DoubleQuoted"));
  yyprintfvTcontext(yytext);
  yyprintf((stderr, "\n  {yy = mk_list(DOUBLEQUOTED, a); }\n"));
  yy = mk_list(DOUBLEQUOTED, a); ;
#undef b
#undef a
}
YY_ACTION(void) yy_1_DoubleQuoted(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
#define b G->val[-1]
#define a G->val[-2]
  yyprintf((stderr, "do yy_1_DoubleQuoted"));
  yyprintfvTcontext(yytext);
  yyprintf((stderr, "\n  {a = cons(b, a); }\n"));
  a = cons(b, a); ;
#undef b
#undef a
}
YY_ACTION(void) yy_2_SingleQuoted(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
#define b G->val[-1]
#define a G->val[-2]
  yyprintf((stderr, "do yy_2_SingleQuoted"));
  yyprintfvTcontext(yytext);
  yyprintf((stderr, "\n  {yy = mk_list(SINGLEQUOTED, a); }\n"));
  yy = mk_list(SINGLEQUOTED, a); ;
#undef b
#undef a
}
YY_ACTION(void) yy_1_SingleQuoted(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
#define b G->val[-1]
#define a G->val[-2]
  yyprintf((stderr, "do yy_1_SingleQuoted"));
  yyprintfvTcontext(yytext);
  yyprintf((stderr, "\n  {a = cons(b, a); }\n"));
  a = cons(b, a); ;
#undef b
#undef a
}
YY_ACTION(void) yy_1_EmDash(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
  yyprintf((stderr, "do yy_1_EmDash"));
  yyprintfvTcontext(yytext);
  yyprintf((stderr, "\n  {yy = str(yytext); yy->key = EMDASH; }\n"));
  yy = str(yytext); yy->key = EMDASH; ;
}
YY_ACTION(void) yy_1_EnDash(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
  yyprintf((stderr, "do yy_1_EnDash"));
  yyprintfvTcontext(yytext);
  yyprintf((stderr, "\n  {yy = str(yytext); yy->key = ENDASH; }\n"));
  yy = str(yytext); yy->key = ENDASH; ;
}
YY_ACTION(void) yy_1_Ellipsis(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
  yyprintf((stderr, "do yy_1_Ellipsis"));
  yyprintfvTcontext(yytext);
  yyprintf((stderr, "\n  {yy = node(ELLIPSIS); }\n"));
  yy = node(ELLIPSIS); ;
}
YY_ACTION(void) yy_1_Apostrophe(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
  yyprintf((stderr, "do yy_1_Apostrophe"));
  yyprintfvTcontext(yytext);
  yyprintf((stderr, "\n  {yy = node(APOSTROPHE); }\n"));
  yy = node(APOSTROPHE); ;
}
YY_ACTION(void) yy_1_Code(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
  yyprintf((stderr, "do yy_1_Code"));
  yyprintfvTcontext(yytext);
  yyprintf((stderr, "\n  {yy = str(yytext); yy->key = CODE; }\n"));
  yy = str(yytext); yy->key = CODE; ;
}
YY_ACTION(void) yy_1_GlossarySortKey(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
  yyprintf((stderr, "do yy_1_GlossarySortKey"));
  yyprintfvTcontext(yytext);
  yyprintf((stderr, "\n  {yy = mk_str(yytext); yy->key = GLOSSARYSORTKEY; }\n"));
  yy = mk_str(yytext); yy->key = GLOSSARYSORTKEY; ;
}
YY_ACTION(void) yy_1_GlossaryTerm(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
  yyprintf((stderr, "do yy_1_GlossaryTerm"));
  yyprintfvTcontext(yytext);
  yyprintf((stderr, "\n  {\n\
\t\tyy = mk_list(LIST, NULL);\n\
\t\tyy->str = 0;\n\
\t\tyy->children = mk_str(yytext);\n\
\t\tyy->key = GLOSSARYTERM;\n\
\t}\n"));
  
		yy = mk_list(LIST, NULL);
		yy->str = 0;
		yy->children = mk_str(yytext);
		yy->key = GLOSSARYTERM;
	;
}
YY_ACTION(void) yy_5_Glossary(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
#define ref G->val[-1]
#define a G->val[-2]
  yyprintf((stderr, "do yy_5_Glossary"));
  yyprintfvTcontext(yytext);
  yyprintf((stderr, "\n  {\n\
\t\t\tnode *label;\n\
\t\t\tlabel = str(ref->str);\n\
\t\t\tlabel->key = NOTELABEL;\n\
\t\t\ta = cons(label,a);\n\
\t\t\tyy = list(GLOSSARYSOURCE, a);\n\
\t\t\tyy->str = strdup(ref->str);\n\
\t\t\tfree_node(ref);\n\
\t\t}\n"));
  
			node *label;
			label = str(ref->str);
			label->key = NOTELABEL;
			a = cons(label,a);
			yy = list(GLOSSARYSOURCE, a);
			yy->str = strdup(ref->str);
			free_node(ref);
		;
#undef ref
#undef a
}
YY_ACTION(void) yy_4_Glossary(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
#define ref G->val[-1]
#define a G->val[-2]
  yyprintf((stderr, "do yy_4_Glossary"));
  yyprintfvTcontext(yytext);
  yyprintf((stderr, "\n  {a = cons(yy, a); }\n"));
  a = cons(yy, a); ;
#undef ref
#undef a
}
YY_ACTION(void) yy_3_Glossary(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
#define ref G->val[-1]
#define a G->val[-2]
  yyprintf((stderr, "do yy_3_Glossary"));
  yyprintfvTcontext(yytext);
  yyprintf((stderr, "\n  {a = cons(yy, a); }\n"));
  a = cons(yy, a); ;
#undef ref
#undef a
}
YY_ACTION(void) yy_2_Glossary(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
#define ref G->val[-1]
#define a G->val[-2]
  yyprintf((stderr, "do yy_2_Glossary"));
  yyprintfvTcontext(yytext);
  yyprintf((stderr, "\n  {a = cons(yy, a); }\n"));
  a = cons(yy, a); ;
#undef ref
#undef a
}
YY_ACTION(void) yy_1_Glossary(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
#define ref G->val[-1]
#define a G->val[-2]
  yyprintf((stderr, "do yy_1_Glossary"));
  yyprintfvTcontext(yytext);
  yyprintf((stderr, "\n  {a = cons(yy, a); }\n"));
  a = cons(yy, a); ;
#undef ref
#undef a
}
YY_ACTION(void) yy_1_NoteReference(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
  yyprintf((stderr, "do yy_1_NoteReference"));
  yyprintfvTcontext(yytext);
  yyprintf((stderr, "\n  {yy = str(yytext); yy->key = NOTEREFERENCE; }\n"));
  yy = str(yytext); yy->key = NOTEREFERENCE; ;
}
YY_ACTION(void) yy_1_AutoLabel(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
  yyprintf((stderr, "do yy_1_AutoLabel"));
  yyprintfvTcontext(yytext);
  yyprintf((stderr, "\n  {\n\
\tnode *ref;\n\
\tyy = str(yytext);\n\
\tyy->key = AUTOLABEL;\n\
\t\n\
\t/* And create a LINKREFERENCE so we can use it */\n\
\tchar *label = label_from_string(yytext);\n\
\tGString *anchor = g_string_new(label);\n\
\tg_string_prepend(anchor, \"#\");\n\
\tref = mk_link(NULL, label, anchor->str, NULL, NULL);\n\
\n\
\tg_string_free(anchor, true);\n\
\tfree(label);\n\
\t((parser_data *)G->data)->autolabels = cons(ref,((parser_data *)G->data)->autolabels);\n\
\tref->key = LINKREFERENCE;\n\
}\n"));
  
	node *ref;
	yy = str(yytext);
	yy->key = AUTOLABEL;
	
	/* And create a LINKREFERENCE so we can use it */
	char *label = label_from_string(yytext);
	GString *anchor = g_string_new(label);
	g_string_prepend(anchor, "#");
	ref = mk_link(NULL, label, anchor->str, NULL, NULL);

	g_string_free(anchor, true);
	free(label);
	((parser_data *)G->data)->autolabels = cons(ref,((parser_data *)G->data)->autolabels);
	ref->key = LINKREFERENCE;
;
}
YY_ACTION(void) yy_2_Label(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
#define a G->val[-1]
  yyprintf((stderr, "do yy_2_Label"));
  yyprintfvTcontext(yytext);
  yyprintf((stderr, "\n  {yy = list(LIST, a); }\n"));
  yy = list(LIST, a); ;
#undef a
}
YY_ACTION(void) yy_1_Label(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
#define a G->val[-1]
  yyprintf((stderr, "do yy_1_Label"));
  yyprintfvTcontext(yytext);
  yyprintf((stderr, "\n  {a = cons(yy, a); }\n"));
  a = cons(yy, a); ;
#undef a
}
YY_ACTION(void) yy_1_Image(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
  yyprintf((stderr, "do yy_1_Image"));
  yyprintfvTcontext(yytext);
  yyprintf((stderr, "\n  {yy->key = IMAGE; }\n"));
  yy->key = IMAGE; ;
}
YY_ACTION(void) yy_1_ImageBlock(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
  yyprintf((stderr, "do yy_1_ImageBlock"));
  yyprintfvTcontext(yytext);
  yyprintf((stderr, "\n  {if (yy->key == IMAGE) yy->key = IMAGEBLOCK; }\n"));
  if (yy->key == IMAGE) yy->key = IMAGEBLOCK; ;
}
YY_ACTION(void) yy_1_RefTitle(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
  yyprintf((stderr, "do yy_1_RefTitle"));
  yyprintfvTcontext(yytext);
  yyprintf((stderr, "\n  {yy = str(yytext); yy->key = RAW; }\n"));
  yy = str(yytext); yy->key = RAW; ;
}
YY_ACTION(void) yy_1_RefSrc(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
  yyprintf((stderr, "do yy_1_RefSrc"));
  yyprintfvTcontext(yytext);
  yyprintf((stderr, "\n  {yy = str(yytext); yy->key = HTML; }\n"));
  yy = str(yytext); yy->key = HTML; ;
}
YY_ACTION(void) yy_1_AttrValue(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
  yyprintf((stderr, "do yy_1_AttrValue"));
  yyprintfvTcontext(yytext);
  yyprintf((stderr, "\n  {yy = str(yytext); yy->key = ATTRVALUE; }\n"));
  yy = str(yytext); yy->key = ATTRVALUE; ;
}
YY_ACTION(void) yy_1_AttrKey(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
  yyprintf((stderr, "do yy_1_AttrKey"));
  yyprintfvTcontext(yytext);
  yyprintf((stderr, "\n  {\n\
\t\tchar *lab;\n\
\t\tlab = label_from_string(yytext);\n\
\t\tyy = mk_str(lab);\n\
\t\tyy->key = ATTRKEY;\n\
\t\tfree(lab);\n\
\t}\n"));
  
		char *lab;
		lab = label_from_string(yytext);
		yy = mk_str(lab);
		yy->key = ATTRKEY;
		free(lab);
	;
}
YY_ACTION(void) yy_1_Attribute(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
#define b G->val[-1]
#define a G->val[-2]
  yyprintf((stderr, "do yy_1_Attribute"));
  yyprintfvTcontext(yytext);
  yyprintf((stderr, "\n  {\n\
\t\tyy = a;\n\
\t\tyy->children = b;\n\
\t}\n"));
  
		yy = a;
		yy->children = b;
	;
#undef b
#undef a
}
YY_ACTION(void) yy_2_Attributes(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
#define a G->val[-1]
  yyprintf((stderr, "do yy_2_Attributes"));
  yyprintfvTcontext(yytext);
  yyprintf((stderr, "\n  {yy = a; }\n"));
  yy = a; ;
#undef a
}
YY_ACTION(void) yy_1_Attributes(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
#define a G->val[-1]
  yyprintf((stderr, "do yy_1_Attributes"));
  yyprintfvTcontext(yytext);
  yyprintf((stderr, "\n  {a = cons(yy,a); }\n"));
  a = cons(yy,a); ;
#undef a
}
YY_ACTION(void) yy_2_LinkReference(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
#define t G->val[-1]
#define s G->val[-2]
#define l G->val[-3]
#define a G->val[-4]
  yyprintf((stderr, "do yy_2_LinkReference"));
  yyprintfvTcontext(yytext);
  yyprintf((stderr, "\n  {\n\
\t\t\t/* Get label for referencing */\n\
\t\t\tGString *text = g_string_new(\"\");\n\
\t\t\tchar *clean;\n\
\t\t\tprint_raw_node_tree(text, l->children);\n\
\t\t\tclean = clean_string(text->str);\n\
\t\t\t\n\
\t\t\tif (a == NULL) {\n\
\t\t\t\t/* no attributes */\n\
\t\t\t\tyy = mk_link(NULL, clean, s->str, t->str, NULL);\n\
\t\t\t} else {\n\
\t\t\t\tyy = mk_link(NULL, clean, s->str, t->str, a);\n\
\t\t\t}\n\
\t\t\tg_string_free(text, TRUE);\n\
\t\t\tfree_node(s);\n\
\t\t\tfree_node(t);\n\
\t\t\tfree_node_tree(l);\n\
\t\t\tfree(clean);\n\
\t\t\tyy->key = LINKREFERENCE;\n\
\t\t}\n"));
  
			/* Get label for referencing */
			GString *text = g_string_new("");
			char *clean;
			print_raw_node_tree(text, l->children);
			clean = clean_string(text->str);
			
			if (a == NULL) {
				/* no attributes */
				yy = mk_link(NULL, clean, s->str, t->str, NULL);
			} else {
				yy = mk_link(NULL, clean, s->str, t->str, a);
			}
			g_string_free(text, TRUE);
			free_node(s);
			free_node(t);
			free_node_tree(l);
			free(clean);
			yy->key = LINKREFERENCE;
		;
#undef t
#undef s
#undef l
#undef a
}
YY_ACTION(void) yy_1_LinkReference(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
#define t G->val[-1]
#define s G->val[-2]
#define l G->val[-3]
#define a G->val[-4]
  yyprintf((stderr, "do yy_1_LinkReference"));
  yyprintfvTcontext(yytext);
  yyprintf((stderr, "\n  {a = reverse_list(yy); }\n"));
  a = reverse_list(yy); ;
#undef t
#undef s
#undef l
#undef a
}
YY_ACTION(void) yy_1_AutoLinkEmail(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
  yyprintf((stderr, "do yy_1_AutoLinkEmail"));
  yyprintfvTcontext(yytext);
  yyprintf((stderr, "\n  {\n\
\t\tchar *mailto = malloc(strlen(yytext) + 8);\n\
\t\tsprintf(mailto, \"mailto:%%s\", yytext);\n\
\t\tyy = mk_link(str(yytext), NULL, mailto, NULL, NULL);\n\
\t\tfree(mailto);\n\
\t}\n"));
  
		char *mailto = malloc(strlen(yytext) + 8);
		sprintf(mailto, "mailto:%s", yytext);
		yy = mk_link(str(yytext), NULL, mailto, NULL, NULL);
		free(mailto);
	;
}
YY_ACTION(void) yy_1_AutoLinkUrl(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
  yyprintf((stderr, "do yy_1_AutoLinkUrl"));
  yyprintfvTcontext(yytext);
  yyprintf((stderr, "\n  {\n\
\t\tyy = mk_link(str(yytext), NULL, yytext, NULL, NULL);\n\
\t}\n"));
  
		yy = mk_link(str(yytext), NULL, yytext, NULL, NULL);
	;
}
YY_ACTION(void) yy_1_Title(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
  yyprintf((stderr, "do yy_1_Title"));
  yyprintfvTcontext(yytext);
  yyprintf((stderr, "\n  {yy = str(yytext); yy->key = TITLE; }\n"));
  yy = str(yytext); yy->key = TITLE; ;
}
YY_ACTION(void) yy_1_Source(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
  yyprintf((stderr, "do yy_1_Source"));
  yyprintfvTcontext(yytext);
  yyprintf((stderr, "\n  {yy = str(yytext); yy->key = SOURCE; }\n"));
  yy = str(yytext); yy->key = SOURCE; ;
}
YY_ACTION(void) yy_1_ExplicitLink(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
#define t G->val[-1]
#define s G->val[-2]
#define l G->val[-3]
  yyprintf((stderr, "do yy_1_ExplicitLink"));
  yyprintfvTcontext(yytext);
  yyprintf((stderr, "\n  {\n\
\t\tyy = mk_link(l, NULL, s->str, t->str, NULL);\n\
\t\tfree_node_tree(s);\n\
\t\tfree_node_tree(t);\n\
\t}\n"));
  
		yy = mk_link(l, NULL, s->str, t->str, NULL);
		free_node_tree(s);
		free_node_tree(t);
	;
#undef t
#undef s
#undef l
}
YY_ACTION(void) yy_1_RawCitationReference(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
  yyprintf((stderr, "do yy_1_RawCitationReference"));
  yyprintfvTcontext(yytext);
  yyprintf((stderr, "\n  {yy = str(yytext); }\n"));
  yy = str(yytext); ;
}
YY_ACTION(void) yy_1_CitationReferenceSingle(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
#define b G->val[-1]
  yyprintf((stderr, "do yy_1_CitationReferenceSingle"));
  yyprintfvTcontext(yytext);
  yyprintf((stderr, "\n  {\n\
\t\tyy = mk_link(NULL, b->str, NULL, NULL, NULL);\n\
\t\tyy->key = CITATION;\n\
\t\tfree_node_tree(b);\n\
\t}\n"));
  
		yy = mk_link(NULL, b->str, NULL, NULL, NULL);
		yy->key = CITATION;
		free_node_tree(b);
	;
#undef b
}
YY_ACTION(void) yy_1_CitationReferenceDouble(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
#define b G->val[-1]
#define a G->val[-2]
  yyprintf((stderr, "do yy_1_CitationReferenceDouble"));
  yyprintfvTcontext(yytext);
  yyprintf((stderr, "\n  {\n\
\t\tchar *label;\n\
\t\tlabel = label_from_node_tree(a);\n\
\t\tyy = mk_link(a, b->str, NULL, NULL, NULL);\n\
\t\tyy->key = CITATION;\n\
\t\t\n\
\t\tif (strcmp(label,\"notcited\") == 0)\n\
\t\t\tyy->key = NOCITATION;\n\
\t\tfree(label);\n\
\t\tfree_node_tree(b);\n\
\t}\n"));
  
		char *label;
		label = label_from_node_tree(a);
		yy = mk_link(a, b->str, NULL, NULL, NULL);
		yy->key = CITATION;
		
		if (strcmp(label,"notcited") == 0)
			yy->key = NOCITATION;
		free(label);
		free_node_tree(b);
	;
#undef b
#undef a
}
YY_ACTION(void) yy_1_ReferenceLinkSingle(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
#define a G->val[-1]
  yyprintf((stderr, "do yy_1_ReferenceLinkSingle"));
  yyprintfvTcontext(yytext);
  yyprintf((stderr, "\n  {\n\
\t\tyy = mk_link(a, NULL, NULL, NULL, NULL);\n\
\t\t/* stash copy of raw source in case we need if */\n\
\t\tyy->str = strdup(yytext);\n\
\t}\n"));
  
		yy = mk_link(a, NULL, NULL, NULL, NULL);
		/* stash copy of raw source in case we need if */
		yy->str = strdup(yytext);
	;
#undef a
}
YY_ACTION(void) yy_1_ReferenceLinkDouble(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
#define b G->val[-1]
#define a G->val[-2]
  yyprintf((stderr, "do yy_1_ReferenceLinkDouble"));
  yyprintfvTcontext(yytext);
  yyprintf((stderr, "\n  {\n\
\t\tGString *text = g_string_new(\"\");\n\
\t\tprint_raw_node_tree(text, b->children);\n\
\t\tyy = mk_link(a, text->str, NULL, NULL, NULL);\n\
\t\tg_string_free(text, TRUE);\n\
\t\tfree_node_tree(b);\n\
\t}\n"));
  
		GString *text = g_string_new("");
		print_raw_node_tree(text, b->children);
		yy = mk_link(a, text->str, NULL, NULL, NULL);
		g_string_free(text, TRUE);
		free_node_tree(b);
	;
#undef b
#undef a
}
YY_ACTION(void) yy_2_StrongUl(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
#define b G->val[-1]
#define a G->val[-2]
  yyprintf((stderr, "do yy_2_StrongUl"));
  yyprintfvTcontext(yytext);
  yyprintf((stderr, "\n  {yy = list(STRONG, a); }\n"));
  yy = list(STRONG, a); ;
#undef b
#undef a
}
YY_ACTION(void) yy_1_StrongUl(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
#define b G->val[-1]
#define a G->val[-2]
  yyprintf((stderr, "do yy_1_StrongUl"));
  yyprintfvTcontext(yytext);
  yyprintf((stderr, "\n  {a = cons(b, a); }\n"));
  a = cons(b, a); ;
#undef b
#undef a
}
YY_ACTION(void) yy_2_StrongStar(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
#define b G->val[-1]
#define a G->val[-2]
  yyprintf((stderr, "do yy_2_StrongStar"));
  yyprintfvTcontext(yytext);
  yyprintf((stderr, "\n  {yy = list(STRONG, a); }\n"));
  yy = list(STRONG, a); ;
#undef b
#undef a
}
YY_ACTION(void) yy_1_StrongStar(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
#define b G->val[-1]
#define a G->val[-2]
  yyprintf((stderr, "do yy_1_StrongStar"));
  yyprintfvTcontext(yytext);
  yyprintf((stderr, "\n  {a = cons(b, a); }\n"));
  a = cons(b, a); ;
#undef b
#undef a
}
YY_ACTION(void) yy_3_EmphUl(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
#define b G->val[-1]
#define a G->val[-2]
  yyprintf((stderr, "do yy_3_EmphUl"));
  yyprintfvTcontext(yytext);
  yyprintf((stderr, "\n  {yy = list(EMPH, a); }\n"));
  yy = list(EMPH, a); ;
#undef b
#undef a
}
YY_ACTION(void) yy_2_EmphUl(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
#define b G->val[-1]
#define a G->val[-2]
  yyprintf((stderr, "do yy_2_EmphUl"));
  yyprintfvTcontext(yytext);
  yyprintf((stderr, "\n  {a = cons(b, a); }\n"));
  a = cons(b, a); ;
#undef b
#undef a
}
YY_ACTION(void) yy_1_EmphUl(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
#define b G->val[-1]
#define a G->val[-2]
  yyprintf((stderr, "do yy_1_EmphUl"));
  yyprintfvTcontext(yytext);
  yyprintf((stderr, "\n  {a = cons(b, a); }\n"));
  a = cons(b, a); ;
#undef b
#undef a
}
YY_ACTION(void) yy_3_EmphStar(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
#define b G->val[-1]
#define a G->val[-2]
  yyprintf((stderr, "do yy_3_EmphStar"));
  yyprintfvTcontext(yytext);
  yyprintf((stderr, "\n  {yy = list(EMPH, a); }\n"));
  yy = list(EMPH, a); ;
#undef b
#undef a
}
YY_ACTION(void) yy_2_EmphStar(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
#define b G->val[-1]
#define a G->val[-2]
  yyprintf((stderr, "do yy_2_EmphStar"));
  yyprintfvTcontext(yytext);
  yyprintf((stderr, "\n  {a = cons(b, a); }\n"));
  a = cons(b, a); ;
#undef b
#undef a
}
YY_ACTION(void) yy_1_EmphStar(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
#define b G->val[-1]
#define a G->val[-2]
  yyprintf((stderr, "do yy_1_EmphStar"));
  yyprintfvTcontext(yytext);
  yyprintf((stderr, "\n  {a = cons(b, a); }\n"));
  a = cons(b, a); ;
#undef b
#undef a
}
YY_ACTION(void) yy_1_UlOrStarLine(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
  yyprintf((stderr, "do yy_1_UlOrStarLine"));
  yyprintfvTcontext(yytext);
  yyprintf((stderr, "\n  {yy = str(yytext); }\n"));
  yy = str(yytext); ;
}
YY_ACTION(void) yy_1_DoubleDollarMath(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
  yyprintf((stderr, "do yy_1_DoubleDollarMath"));
  yyprintfvTcontext(yytext);
  yyprintf((stderr, "\n  {yy = str(yytext); yy->key = MATHSPAN; }\n"));
  yy = str(yytext); yy->key = MATHSPAN; ;
}
YY_ACTION(void) yy_1_SingleDollarMath(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
  yyprintf((stderr, "do yy_1_SingleDollarMath"));
  yyprintfvTcontext(yytext);
  yyprintf((stderr, "\n  {yy = str(yytext); yy->key = MATHSPAN; }\n"));
  yy = str(yytext); yy->key = MATHSPAN; ;
}
YY_ACTION(void) yy_1_MathSpan(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
  yyprintf((stderr, "do yy_1_MathSpan"));
  yyprintfvTcontext(yytext);
  yyprintf((stderr, "\n  {\n\
\t/* Basically, these delimiters indicate math in LaTeX syntax, and the\n\
\t   delimiters are compatible with MathJax and LaTeX\n\
\t   ASCIIMathML is *not* supported */\n\
\tyy = str(yytext);\n\
\tyy->key = MATHSPAN;\n\
}\n"));
  
	/* Basically, these delimiters indicate math in LaTeX syntax, and the
	   delimiters are compatible with MathJax and LaTeX
	   ASCIIMathML is *not* supported */
	yy = str(yytext);
	yy->key = MATHSPAN;
;
}
YY_ACTION(void) yy_1_StartList(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
  yyprintf((stderr, "do yy_1_StartList"));
  yyprintfvTcontext(yytext);
  yyprintf((stderr, "\n  {yy = NULL; }\n"));
  yy = NULL; ;
}
YY_ACTION(void) yy_1_AposChunk(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
  yyprintf((stderr, "do yy_1_AposChunk"));
  yyprintfvTcontext(yytext);
  yyprintf((stderr, "\n  {yy = node(APOSTROPHE); }\n"));
  yy = node(APOSTROPHE); ;
}
YY_ACTION(void) yy_1_StrChunk(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
  yyprintf((stderr, "do yy_1_StrChunk"));
  yyprintfvTcontext(yytext);
  yyprintf((stderr, "\n  {yy = str(yytext); }\n"));
  yy = str(yytext); ;
}
YY_ACTION(void) yy_3_Str(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
#define a G->val[-1]
  yyprintf((stderr, "do yy_3_Str"));
  yyprintfvTcontext(yytext);
  yyprintf((stderr, "\n  {if (a->next == NULL) { yy = a; } else { yy = list(LIST, a); } }\n"));
  if (a->next == NULL) { yy = a; } else { yy = list(LIST, a); } ;
#undef a
}
YY_ACTION(void) yy_2_Str(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
#define a G->val[-1]
  yyprintf((stderr, "do yy_2_Str"));
  yyprintfvTcontext(yytext);
  yyprintf((stderr, "\n  {a = cons(yy, a); }\n"));
  a = cons(yy, a); ;
#undef a
}
YY_ACTION(void) yy_1_Str(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
#define a G->val[-1]
  yyprintf((stderr, "do yy_1_Str"));
  yyprintfvTcontext(yytext);
  yyprintf((stderr, "\n  {a = cons(str(yytext), a); }\n"));
  a = cons(str(yytext), a); ;
#undef a
}
YY_ACTION(void) yy_1_LineBreak(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
#define a G->val[-1]
  yyprintf((stderr, "do yy_1_LineBreak"));
  yyprintfvTcontext(yytext);
  yyprintf((stderr, "\n  {yy = a; yy->key = LINEBREAK; }\n"));
  yy = a; yy->key = LINEBREAK; ;
#undef a
}
YY_ACTION(void) yy_1_TerminalEndline(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
  yyprintf((stderr, "do yy_1_TerminalEndline"));
  yyprintfvTcontext(yytext);
  yyprintf((stderr, "\n  {yy = NULL; }\n"));
  yy = NULL; ;
}
YY_ACTION(void) yy_1_NormalEndline(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
  yyprintf((stderr, "do yy_1_NormalEndline"));
  yyprintfvTcontext(yytext);
  yyprintf((stderr, "\n  {\n\
\t\t\tyy = str(\"\\n\");\n\
\t\t\tyy->key = SPACE; \n\
\t\t}\n"));
  
			yy = str("\n");
			yy->key = SPACE; 
		;
}
YY_ACTION(void) yy_1_Space(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
  yyprintf((stderr, "do yy_1_Space"));
  yyprintfvTcontext(yytext);
  yyprintf((stderr, "\n  {yy = str(\" \"); yy->key = SPACE; }\n"));
  yy = str(" "); yy->key = SPACE; ;
}
YY_ACTION(void) yy_3_Inlines(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
#define c G->val[-1]
#define a G->val[-2]
  yyprintf((stderr, "do yy_3_Inlines"));
  yyprintfvTcontext(yytext);
  yyprintf((stderr, "\n  {yy = list(LIST, a); }\n"));
  yy = list(LIST, a); ;
#undef c
#undef a
}
YY_ACTION(void) yy_2_Inlines(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
#define c G->val[-1]
#define a G->val[-2]
  yyprintf((stderr, "do yy_2_Inlines"));
  yyprintfvTcontext(yytext);
  yyprintf((stderr, "\n  {a = cons(c, a); }\n"));
  a = cons(c, a); ;
#undef c
#undef a
}
YY_ACTION(void) yy_1_Inlines(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
#define c G->val[-1]
#define a G->val[-2]
  yyprintf((stderr, "do yy_1_Inlines"));
  yyprintfvTcontext(yytext);
  yyprintf((stderr, "\n  {a = cons(yy, a); }\n"));
  a = cons(yy, a); ;
#undef c
#undef a
}
YY_ACTION(void) yy_1_Plain(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
#define a G->val[-1]
  yyprintf((stderr, "do yy_1_Plain"));
  yyprintfvTcontext(yytext);
  yyprintf((stderr, "\n  {yy = a; yy->key = PLAIN; }\n"));
  yy = a; yy->key = PLAIN; ;
#undef a
}
YY_ACTION(void) yy_1_Para(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
#define a G->val[-1]
  yyprintf((stderr, "do yy_1_Para"));
  yyprintfvTcontext(yytext);
  yyprintf((stderr, "\n  {yy = a; yy->key = PARA; }\n"));
  yy = a; yy->key = PARA; ;
#undef a
}
YY_ACTION(void) yy_1_Entity(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
  yyprintf((stderr, "do yy_1_Entity"));
  yyprintfvTcontext(yytext);
  yyprintf((stderr, "\n  {yy = str(yytext); yy->key = HTML; }\n"));
  yy = str(yytext); yy->key = HTML; ;
}
YY_ACTION(void) yy_1_EscapedChar(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
  yyprintf((stderr, "do yy_1_EscapedChar"));
  yyprintfvTcontext(yytext);
  yyprintf((stderr, "\n  {yy = str(yytext); }\n"));
  yy = str(yytext); ;
}
YY_ACTION(void) yy_1_Symbol(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
  yyprintf((stderr, "do yy_1_Symbol"));
  yyprintfvTcontext(yytext);
  yyprintf((stderr, "\n  {yy = str(yytext); }\n"));
  yy = str(yytext); ;
}
YY_ACTION(void) yy_1_RawHtml(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
  yyprintf((stderr, "do yy_1_RawHtml"));
  yyprintfvTcontext(yytext);
  yyprintf((stderr, "\n  {\n\
\t\tif (ext(EXT_FILTER_HTML)) {\n\
\t\t\tyy = list(LIST, NULL);\n\
\t\t} else {\n\
\t\t\tyy = str(yytext);\n\
\t\t\tyy->key = HTML;\n\
\t\t}\n\
\t}\n"));
  
		if (ext(EXT_FILTER_HTML)) {
			yy = list(LIST, NULL);
		} else {
			yy = str(yytext);
			yy->key = HTML;
		}
	;
}
YY_ACTION(void) yy_1_Line(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
  yyprintf((stderr, "do yy_1_Line"));
  yyprintfvTcontext(yytext);
  yyprintf((stderr, "\n  {yy = str(yytext); }\n"));
  yy = str(yytext); ;
}
YY_ACTION(void) yy_1_BlockQuoteMarker(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
  yyprintf((stderr, "do yy_1_BlockQuoteMarker"));
  yyprintfvTcontext(yytext);
  yyprintf((stderr, "\n  {yy = str(yytext); yy->key = BLOCKQUOTEMARKER; }\n"));
  yy = str(yytext); yy->key = BLOCKQUOTEMARKER; ;
}
YY_ACTION(void) yy_4_BlockQuoteRaw(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
#define b G->val[-1]
#define a G->val[-2]
  yyprintf((stderr, "do yy_4_BlockQuoteRaw"));
  yyprintfvTcontext(yytext);
  yyprintf((stderr, "\n  {\n\
\t\t\tyy = b;\n\
\t\t\tnode *raw;\n\
\t\t\traw = mk_str_from_list(a, true);\n\
\t\t\traw->key = RAW;\n\
\t\t\tyy->children = raw;\n\
\t\t}\n"));
  
			yy = b;
			node *raw;
			raw = mk_str_from_list(a, true);
			raw->key = RAW;
			yy->children = raw;
		;
#undef b
#undef a
}
YY_ACTION(void) yy_3_BlockQuoteRaw(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
#define b G->val[-1]
#define a G->val[-2]
  yyprintf((stderr, "do yy_3_BlockQuoteRaw"));
  yyprintfvTcontext(yytext);
  yyprintf((stderr, "\n  {a = cons(mk_str(\"\\n\"), a); }\n"));
  a = cons(mk_str("\n"), a); ;
#undef b
#undef a
}
YY_ACTION(void) yy_2_BlockQuoteRaw(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
#define b G->val[-1]
#define a G->val[-2]
  yyprintf((stderr, "do yy_2_BlockQuoteRaw"));
  yyprintfvTcontext(yytext);
  yyprintf((stderr, "\n  {a = cons(yy, a); }\n"));
  a = cons(yy, a); ;
#undef b
#undef a
}
YY_ACTION(void) yy_1_BlockQuoteRaw(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
#define b G->val[-1]
#define a G->val[-2]
  yyprintf((stderr, "do yy_1_BlockQuoteRaw"));
  yyprintfvTcontext(yytext);
  yyprintf((stderr, "\n  {a = cons(yy, a); }\n"));
  a = cons(yy, a); ;
#undef b
#undef a
}
YY_ACTION(void) yy_1_BlockQuote(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
#define a G->val[-1]
  yyprintf((stderr, "do yy_1_BlockQuote"));
  yyprintfvTcontext(yytext);
  yyprintf((stderr, "\n  {yy = list(BLOCKQUOTE,a); }\n"));
  yy = list(BLOCKQUOTE,a); ;
#undef a
}
YY_ACTION(void) yy_3_SetextHeading2(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
#define b G->val[-1]
#define a G->val[-2]
  yyprintf((stderr, "do yy_3_SetextHeading2"));
  yyprintfvTcontext(yytext);
  yyprintf((stderr, "\n  {yy = list(H2, a); }\n"));
  yy = list(H2, a); ;
#undef b
#undef a
}
YY_ACTION(void) yy_2_SetextHeading2(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
#define b G->val[-1]
#define a G->val[-2]
  yyprintf((stderr, "do yy_2_SetextHeading2"));
  yyprintfvTcontext(yytext);
  yyprintf((stderr, "\n  {append_list(b,a)}\n"));
  append_list(b,a);
#undef b
#undef a
}
YY_ACTION(void) yy_1_SetextHeading2(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
#define b G->val[-1]
#define a G->val[-2]
  yyprintf((stderr, "do yy_1_SetextHeading2"));
  yyprintfvTcontext(yytext);
  yyprintf((stderr, "\n  {a = cons(yy, a); }\n"));
  a = cons(yy, a); ;
#undef b
#undef a
}
YY_ACTION(void) yy_3_SetextHeading1(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
#define b G->val[-1]
#define a G->val[-2]
  yyprintf((stderr, "do yy_3_SetextHeading1"));
  yyprintfvTcontext(yytext);
  yyprintf((stderr, "\n  {yy = list(H1, a); }\n"));
  yy = list(H1, a); ;
#undef b
#undef a
}
YY_ACTION(void) yy_2_SetextHeading1(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
#define b G->val[-1]
#define a G->val[-2]
  yyprintf((stderr, "do yy_2_SetextHeading1"));
  yyprintfvTcontext(yytext);
  yyprintf((stderr, "\n  {append_list(b,a);}\n"));
  append_list(b,a);;
#undef b
#undef a
}
YY_ACTION(void) yy_1_SetextHeading1(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
#define b G->val[-1]
#define a G->val[-2]
  yyprintf((stderr, "do yy_1_SetextHeading1"));
  yyprintfvTcontext(yytext);
  yyprintf((stderr, "\n  {a = cons(yy, a); }\n"));
  a = cons(yy, a); ;
#undef b
#undef a
}
YY_ACTION(void) yy_3_AtxHeading(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
#define b G->val[-1]
#define a G->val[-2]
#define s G->val[-3]
  yyprintf((stderr, "do yy_3_AtxHeading"));
  yyprintfvTcontext(yytext);
  yyprintf((stderr, "\n  {yy = list(s->key,a); free(s); }\n"));
  yy = list(s->key,a); free(s); ;
#undef b
#undef a
#undef s
}
YY_ACTION(void) yy_2_AtxHeading(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
#define b G->val[-1]
#define a G->val[-2]
#define s G->val[-3]
  yyprintf((stderr, "do yy_2_AtxHeading"));
  yyprintfvTcontext(yytext);
  yyprintf((stderr, "\n  {append_list(b,a);}\n"));
  append_list(b,a);;
#undef b
#undef a
#undef s
}
YY_ACTION(void) yy_1_AtxHeading(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
#define b G->val[-1]
#define a G->val[-2]
#define s G->val[-3]
  yyprintf((stderr, "do yy_1_AtxHeading"));
  yyprintfvTcontext(yytext);
  yyprintf((stderr, "\n  {a = cons(yy, a); }\n"));
  a = cons(yy, a); ;
#undef b
#undef a
#undef s
}
YY_ACTION(void) yy_1_AtxStart(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
  yyprintf((stderr, "do yy_1_AtxStart"));
  yyprintfvTcontext(yytext);
  yyprintf((stderr, "\n  {yy = node(H1 + ((int)strlen(yytext) - 1)); }\n"));
  yy = node(H1 + ((int)strlen(yytext) - 1)); ;
}
YY_ACTION(void) yy_3_HeadingSection(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
#define a G->val[-1]
  yyprintf((stderr, "do yy_3_HeadingSection"));
  yyprintfvTcontext(yytext);
  yyprintf((stderr, "\n  {yy = list(HEADINGSECTION, a); }\n"));
  yy = list(HEADINGSECTION, a); ;
#undef a
}
YY_ACTION(void) yy_2_HeadingSection(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
#define a G->val[-1]
  yyprintf((stderr, "do yy_2_HeadingSection"));
  yyprintfvTcontext(yytext);
  yyprintf((stderr, "\n  {a = cons(yy, a); }\n"));
  a = cons(yy, a); ;
#undef a
}
YY_ACTION(void) yy_1_HeadingSection(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
#define a G->val[-1]
  yyprintf((stderr, "do yy_1_HeadingSection"));
  yyprintfvTcontext(yytext);
  yyprintf((stderr, "\n  {a = cons(yy, a); }\n"));
  a = cons(yy, a); ;
#undef a
}
YY_ACTION(void) yy_4_MetaDataValue(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
#define a G->val[-1]
  yyprintf((stderr, "do yy_4_MetaDataValue"));
  yyprintfvTcontext(yytext);
  yyprintf((stderr, "\n  {\n\
\t\t/* TODO: Need to grab start/stop range from the list */\n\
\t\tyy = mk_str_from_list(a, false);\n\
\t\tyy->key = METAVALUE;\n\
\t}\n"));
  
		/* TODO: Need to grab start/stop range from the list */
		yy = mk_str_from_list(a, false);
		yy->key = METAVALUE;
	;
#undef a
}
YY_ACTION(void) yy_3_MetaDataValue(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
#define a G->val[-1]
  yyprintf((stderr, "do yy_3_MetaDataValue"));
  yyprintfvTcontext(yytext);
  yyprintf((stderr, "\n  {a = cons(str(yytext), a); }\n"));
  a = cons(str(yytext), a); ;
#undef a
}
YY_ACTION(void) yy_2_MetaDataValue(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
#define a G->val[-1]
  yyprintf((stderr, "do yy_2_MetaDataValue"));
  yyprintfvTcontext(yytext);
  yyprintf((stderr, "\n  {a = cons(str(\"\\n\"), a); }\n"));
  a = cons(str("\n"), a); ;
#undef a
}
YY_ACTION(void) yy_1_MetaDataValue(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
#define a G->val[-1]
  yyprintf((stderr, "do yy_1_MetaDataValue"));
  yyprintfvTcontext(yytext);
  yyprintf((stderr, "\n  {a = cons(str(yytext), a); }\n"));
  a = cons(str(yytext), a); ;
#undef a
}
YY_ACTION(void) yy_1_MetaDataKey(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
  yyprintf((stderr, "do yy_1_MetaDataKey"));
  yyprintfvTcontext(yytext);
  yyprintf((stderr, "\n  {\n\
\t\tyy = str(yytext);\n\
\t\tyy->key = METAKEY;\n\
\t}\n"));
  
		yy = str(yytext);
		yy->key = METAKEY;
	;
}
YY_ACTION(void) yy_1_MetaDataKeyValue(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
#define b G->val[-1]
#define a G->val[-2]
  yyprintf((stderr, "do yy_1_MetaDataKeyValue"));
  yyprintfvTcontext(yytext);
  yyprintf((stderr, "\n  {\n\
\t\tyy = a;\n\
\t\tyy->children = b;\n\
\t}\n"));
  
		yy = a;
		yy->children = b;
	;
#undef b
#undef a
}
YY_ACTION(void) yy_2_MetaData(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
#define a G->val[-1]
  yyprintf((stderr, "do yy_2_MetaData"));
  yyprintfvTcontext(yytext);
  yyprintf((stderr, "\n  {yy = list(METADATA, a); }\n"));
  yy = list(METADATA, a); ;
#undef a
}
YY_ACTION(void) yy_1_MetaData(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
#define a G->val[-1]
  yyprintf((stderr, "do yy_1_MetaData"));
  yyprintfvTcontext(yytext);
  yyprintf((stderr, "\n  {a = cons(yy, a); }\n"));
  a = cons(yy, a); ;
#undef a
}
YY_ACTION(void) yy_3_Doc(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
#define b G->val[-1]
#define a G->val[-2]
  yyprintf((stderr, "do yy_3_Doc"));
  yyprintfvTcontext(yytext);
  yyprintf((stderr, "\n  {\n\
\t\tif (b!= NULL) a = cons(b,a);\n\
\t\t((parser_data *)G->data)->result = reverse_list(a);\n\
\t}\n"));
  
		if (b!= NULL) a = cons(b,a);
		((parser_data *)G->data)->result = reverse_list(a);
	;
#undef b
#undef a
}
YY_ACTION(void) yy_2_Doc(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
#define b G->val[-1]
#define a G->val[-2]
  yyprintf((stderr, "do yy_2_Doc"));
  yyprintfvTcontext(yytext);
  yyprintf((stderr, "\n  {a = cons(yy, a); }\n"));
  a = cons(yy, a); ;
#undef b
#undef a
}
YY_ACTION(void) yy_1_Doc(GREG *G, char *yytext, int yyleng, yythunk *thunk, YY_XTYPE YY_XVAR)
{
#define b G->val[-1]
#define a G->val[-2]
  yyprintf((stderr, "do yy_1_Doc"));
  yyprintfvTcontext(yytext);
  yyprintf((stderr, "\n  {a = cons(yy, a); b = node(FOOTER); }\n"));
  a = cons(yy, a); b = node(FOOTER); ;
#undef b
#undef a
}

YY_RULE(int) yy_RawString(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "RawString"));
  yyText(G, G->begin, G->end);  if (!(YY_BEGIN)) goto l1;
  {  int yypos4= G->pos, yythunkpos4= G->thunkpos;
  {  int yypos5= G->pos, yythunkpos5= G->thunkpos;  if (!yymatchString(G, "{++")) goto l6;
  goto l5;
  l6:;	  G->pos= yypos5; G->thunkpos= yythunkpos5;  if (!yymatchString(G, "{--")) goto l7;
  goto l5;
  l7:;	  G->pos= yypos5; G->thunkpos= yythunkpos5;  if (!yymatchString(G, "{~~")) goto l8;
  goto l5;
  l8:;	  G->pos= yypos5; G->thunkpos= yythunkpos5;  if (!yymatchString(G, "{==")) goto l9;
  goto l5;
  l9:;	  G->pos= yypos5; G->thunkpos= yythunkpos5;  if (!yymatchString(G, "{>>")) goto l4;

  }
  l5:;	  goto l1;
  l4:;	  G->pos= yypos4; G->thunkpos= yythunkpos4;
  }  if (!yymatchDot(G)) goto l1;
  l2:;	
  {  int yypos3= G->pos, yythunkpos3= G->thunkpos;
  {  int yypos10= G->pos, yythunkpos10= G->thunkpos;
  {  int yypos11= G->pos, yythunkpos11= G->thunkpos;  if (!yymatchString(G, "{++")) goto l12;
  goto l11;
  l12:;	  G->pos= yypos11; G->thunkpos= yythunkpos11;  if (!yymatchString(G, "{--")) goto l13;
  goto l11;
  l13:;	  G->pos= yypos11; G->thunkpos= yythunkpos11;  if (!yymatchString(G, "{~~")) goto l14;
  goto l11;
  l14:;	  G->pos= yypos11; G->thunkpos= yythunkpos11;  if (!yymatchString(G, "{==")) goto l15;
  goto l11;
  l15:;	  G->pos= yypos11; G->thunkpos= yythunkpos11;  if (!yymatchString(G, "{>>")) goto l10;

  }
  l11:;	  goto l3;
  l10:;	  G->pos= yypos10; G->thunkpos= yythunkpos10;
  }  if (!yymatchDot(G)) goto l3;  goto l2;
  l3:;	  G->pos= yypos3; G->thunkpos= yythunkpos3;
  }  yyText(G, G->begin, G->end);  if (!(YY_END)) goto l1;  yyDo(G, yy_1_RawString, G->begin, G->end, "yy_1_RawString");
  yyprintf((stderr, "  ok   RawString"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l1:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "RawString"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_CriticString(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "CriticString"));
  if (!yy_CriticMarkup(G))  goto l16;
  yyprintf((stderr, "  ok   CriticString"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l16:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "CriticString"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_DocForCritic(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyDo(G, yyPush, 1, 0, "yyPush");
  yyprintfv((stderr, "%s\n", "DocForCritic"));

  {  int yypos18= G->pos, yythunkpos18= G->thunkpos;  if (!yy_BOM(G))  goto l18;
  goto l19;
  l18:;	  G->pos= yypos18; G->thunkpos= yythunkpos18;
  }
  l19:;	  if (!yy_StartList(G))  goto l17;
  yyDo(G, yySet, -1, 0, "yySet");

  l20:;	
  {  int yypos21= G->pos, yythunkpos21= G->thunkpos;
  {  int yypos22= G->pos, yythunkpos22= G->thunkpos;  if (!yy_CriticString(G))  goto l23;
  yyDo(G, yy_1_DocForCritic, G->begin, G->end, "yy_1_DocForCritic");
  goto l22;
  l23:;	  G->pos= yypos22; G->thunkpos= yythunkpos22;  if (!yy_RawString(G))  goto l21;
  yyDo(G, yy_2_DocForCritic, G->begin, G->end, "yy_2_DocForCritic");

  }
  l22:;	  goto l20;
  l21:;	  G->pos= yypos21; G->thunkpos= yythunkpos21;
  }
  l24:;	
  {  int yypos25= G->pos, yythunkpos25= G->thunkpos;  if (!yy_RawString(G))  goto l25;
  yyDo(G, yy_3_DocForCritic, G->begin, G->end, "yy_3_DocForCritic");
  goto l24;
  l25:;	  G->pos= yypos25; G->thunkpos= yythunkpos25;
  }  if (!yy_Eof(G))  goto l17;
  yyDo(G, yy_4_DocForCritic, G->begin, G->end, "yy_4_DocForCritic");
  yyprintf((stderr, "  ok   DocForCritic"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));
  yyDo(G, yyPop, 1, 0, "yyPop");
  return 1;
  l17:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "DocForCritic"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_CriticSubstAdd(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "CriticSubstAdd"));
  yyText(G, G->begin, G->end);  if (!(YY_BEGIN)) goto l26;
  l27:;	
  {  int yypos28= G->pos, yythunkpos28= G->thunkpos;
  {  int yypos29= G->pos, yythunkpos29= G->thunkpos;  if (!yymatchString(G, "~~}")) goto l29;
  goto l28;
  l29:;	  G->pos= yypos29; G->thunkpos= yythunkpos29;
  }  if (!yymatchDot(G)) goto l28;  goto l27;
  l28:;	  G->pos= yypos28; G->thunkpos= yythunkpos28;
  }  yyText(G, G->begin, G->end);  if (!(YY_END)) goto l26;  yyDo(G, yy_1_CriticSubstAdd, G->begin, G->end, "yy_1_CriticSubstAdd");
  yyprintf((stderr, "  ok   CriticSubstAdd"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l26:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "CriticSubstAdd"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_CriticSubstDel(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "CriticSubstDel"));
  yyText(G, G->begin, G->end);  if (!(YY_BEGIN)) goto l30;
  l31:;	
  {  int yypos32= G->pos, yythunkpos32= G->thunkpos;
  {  int yypos33= G->pos, yythunkpos33= G->thunkpos;  if (!yymatchString(G, "~>")) goto l33;
  goto l32;
  l33:;	  G->pos= yypos33; G->thunkpos= yythunkpos33;
  }  if (!yymatchDot(G)) goto l32;  goto l31;
  l32:;	  G->pos= yypos32; G->thunkpos= yythunkpos32;
  }  yyText(G, G->begin, G->end);  if (!(YY_END)) goto l30;  yyDo(G, yy_1_CriticSubstDel, G->begin, G->end, "yy_1_CriticSubstDel");
  yyprintf((stderr, "  ok   CriticSubstDel"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l30:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "CriticSubstDel"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_CriticComment(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "CriticComment"));
  if (!yymatchString(G, "{>>")) goto l34;
  yyText(G, G->begin, G->end);  if (!(YY_BEGIN)) goto l34;
  l35:;	
  {  int yypos36= G->pos, yythunkpos36= G->thunkpos;
  {  int yypos37= G->pos, yythunkpos37= G->thunkpos;  if (!yymatchString(G, "<<}")) goto l37;
  goto l36;
  l37:;	  G->pos= yypos37; G->thunkpos= yythunkpos37;
  }  if (!yymatchDot(G)) goto l36;  goto l35;
  l36:;	  G->pos= yypos36; G->thunkpos= yythunkpos36;
  }  yyText(G, G->begin, G->end);  if (!(YY_END)) goto l34;  if (!yymatchString(G, "<<}")) goto l34;
  yyDo(G, yy_1_CriticComment, G->begin, G->end, "yy_1_CriticComment");
  yyprintf((stderr, "  ok   CriticComment"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l34:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "CriticComment"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_CriticHighlight(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "CriticHighlight"));
  if (!yymatchString(G, "{==")) goto l38;
  yyText(G, G->begin, G->end);  if (!(YY_BEGIN)) goto l38;
  l39:;	
  {  int yypos40= G->pos, yythunkpos40= G->thunkpos;
  {  int yypos41= G->pos, yythunkpos41= G->thunkpos;  if (!yymatchString(G, "==}")) goto l41;
  goto l40;
  l41:;	  G->pos= yypos41; G->thunkpos= yythunkpos41;
  }  if (!yymatchDot(G)) goto l40;  goto l39;
  l40:;	  G->pos= yypos40; G->thunkpos= yythunkpos40;
  }  yyText(G, G->begin, G->end);  if (!(YY_END)) goto l38;  if (!yymatchString(G, "==}")) goto l38;
  yyDo(G, yy_1_CriticHighlight, G->begin, G->end, "yy_1_CriticHighlight");
  yyprintf((stderr, "  ok   CriticHighlight"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l38:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "CriticHighlight"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_CriticSubstitution(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyDo(G, yyPush, 1, 0, "yyPush");
  yyprintfv((stderr, "%s\n", "CriticSubstitution"));
  if (!yy_StartList(G))  goto l42;
  yyDo(G, yySet, -1, 0, "yySet");
  if (!yymatchString(G, "{~~")) goto l42;
  if (!yy_CriticSubstDel(G))  goto l42;
  yyDo(G, yy_1_CriticSubstitution, G->begin, G->end, "yy_1_CriticSubstitution");
  if (!yymatchString(G, "~>")) goto l42;
  if (!yy_CriticSubstAdd(G))  goto l42;
  yyDo(G, yy_2_CriticSubstitution, G->begin, G->end, "yy_2_CriticSubstitution");
  if (!yymatchString(G, "~~}")) goto l42;
  yyDo(G, yy_3_CriticSubstitution, G->begin, G->end, "yy_3_CriticSubstitution");
  yyprintf((stderr, "  ok   CriticSubstitution"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));
  yyDo(G, yyPop, 1, 0, "yyPop");
  return 1;
  l42:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "CriticSubstitution"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_CriticDeletion(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "CriticDeletion"));
  if (!yymatchString(G, "{--")) goto l43;
  yyText(G, G->begin, G->end);  if (!(YY_BEGIN)) goto l43;
  l44:;	
  {  int yypos45= G->pos, yythunkpos45= G->thunkpos;
  {  int yypos46= G->pos, yythunkpos46= G->thunkpos;  if (!yymatchString(G, "--}")) goto l46;
  goto l45;
  l46:;	  G->pos= yypos46; G->thunkpos= yythunkpos46;
  }  if (!yymatchDot(G)) goto l45;  goto l44;
  l45:;	  G->pos= yypos45; G->thunkpos= yythunkpos45;
  }  yyText(G, G->begin, G->end);  if (!(YY_END)) goto l43;  if (!yymatchString(G, "--}")) goto l43;
  yyDo(G, yy_1_CriticDeletion, G->begin, G->end, "yy_1_CriticDeletion");
  yyprintf((stderr, "  ok   CriticDeletion"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l43:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "CriticDeletion"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_CriticAddition(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "CriticAddition"));
  if (!yymatchString(G, "{++")) goto l47;
  yyText(G, G->begin, G->end);  if (!(YY_BEGIN)) goto l47;
  l48:;	
  {  int yypos49= G->pos, yythunkpos49= G->thunkpos;
  {  int yypos50= G->pos, yythunkpos50= G->thunkpos;  if (!yymatchString(G, "++}")) goto l50;
  goto l49;
  l50:;	  G->pos= yypos50; G->thunkpos= yythunkpos50;
  }  if (!yymatchDot(G)) goto l49;  goto l48;
  l49:;	  G->pos= yypos49; G->thunkpos= yythunkpos49;
  }  yyText(G, G->begin, G->end);  if (!(YY_END)) goto l47;  if (!yymatchString(G, "++}")) goto l47;
  yyDo(G, yy_1_CriticAddition, G->begin, G->end, "yy_1_CriticAddition");
  yyprintf((stderr, "  ok   CriticAddition"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l47:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "CriticAddition"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_OPMLSetextHeading2(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "OPMLSetextHeading2"));
  yyText(G, G->begin, G->end);  if (!(YY_BEGIN)) goto l51;
  l52:;	
  {  int yypos53= G->pos, yythunkpos53= G->thunkpos;
  {  int yypos54= G->pos, yythunkpos54= G->thunkpos;  if (!yymatchChar(G, '\r')) goto l54;
  goto l53;
  l54:;	  G->pos= yypos54; G->thunkpos= yythunkpos54;
  }
  {  int yypos55= G->pos, yythunkpos55= G->thunkpos;  if (!yymatchChar(G, '\n')) goto l55;
  goto l53;
  l55:;	  G->pos= yypos55; G->thunkpos= yythunkpos55;
  }  if (!yymatchDot(G)) goto l53;  goto l52;
  l53:;	  G->pos= yypos53; G->thunkpos= yythunkpos53;
  }  yyText(G, G->begin, G->end);  if (!(YY_END)) goto l51;  if (!yy_Newline(G))  goto l51;
  if (!yy_SetextBottom2(G))  goto l51;
  yyDo(G, yy_1_OPMLSetextHeading2, G->begin, G->end, "yy_1_OPMLSetextHeading2");
  yyprintf((stderr, "  ok   OPMLSetextHeading2"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l51:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "OPMLSetextHeading2"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_OPMLSetextHeading1(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "OPMLSetextHeading1"));
  yyText(G, G->begin, G->end);  if (!(YY_BEGIN)) goto l56;
  l57:;	
  {  int yypos58= G->pos, yythunkpos58= G->thunkpos;
  {  int yypos59= G->pos, yythunkpos59= G->thunkpos;  if (!yymatchChar(G, '\r')) goto l59;
  goto l58;
  l59:;	  G->pos= yypos59; G->thunkpos= yythunkpos59;
  }
  {  int yypos60= G->pos, yythunkpos60= G->thunkpos;  if (!yymatchChar(G, '\n')) goto l60;
  goto l58;
  l60:;	  G->pos= yypos60; G->thunkpos= yythunkpos60;
  }  if (!yymatchDot(G)) goto l58;  goto l57;
  l58:;	  G->pos= yypos58; G->thunkpos= yythunkpos58;
  }  yyText(G, G->begin, G->end);  if (!(YY_END)) goto l56;  if (!yy_Newline(G))  goto l56;
  if (!yy_SetextBottom1(G))  goto l56;
  yyDo(G, yy_1_OPMLSetextHeading1, G->begin, G->end, "yy_1_OPMLSetextHeading1");
  yyprintf((stderr, "  ok   OPMLSetextHeading1"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l56:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "OPMLSetextHeading1"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_OPMLSetextHeading(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "OPMLSetextHeading"));

  {  int yypos62= G->pos, yythunkpos62= G->thunkpos;  if (!yy_OPMLSetextHeading1(G))  goto l63;
  goto l62;
  l63:;	  G->pos= yypos62; G->thunkpos= yythunkpos62;  if (!yy_OPMLSetextHeading2(G))  goto l61;

  }
  l62:;	  yyprintf((stderr, "  ok   OPMLSetextHeading"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l61:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "OPMLSetextHeading"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_OPMLAtxHeading(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyDo(G, yyPush, 1, 0, "yyPush");
  yyprintfv((stderr, "%s\n", "OPMLAtxHeading"));

  {  int yypos65= G->pos, yythunkpos65= G->thunkpos;  if (!yy_Heading(G))  goto l64;
  G->pos= yypos65; G->thunkpos= yythunkpos65;
  }  if (!yy_AtxStart(G))  goto l64;
  yyDo(G, yySet, -1, 0, "yySet");

  {  int yypos66= G->pos, yythunkpos66= G->thunkpos;  if (!yy_Sp(G))  goto l66;
  goto l67;
  l66:;	  G->pos= yypos66; G->thunkpos= yythunkpos66;
  }
  l67:;	  yyText(G, G->begin, G->end);  if (!(YY_BEGIN)) goto l64;
  l68:;	
  {  int yypos69= G->pos, yythunkpos69= G->thunkpos;
  {  int yypos70= G->pos, yythunkpos70= G->thunkpos;  if (!yy_Newline(G))  goto l70;
  goto l69;
  l70:;	  G->pos= yypos70; G->thunkpos= yythunkpos70;
  }
  {  int yypos71= G->pos, yythunkpos71= G->thunkpos;
  {  int yypos72= G->pos, yythunkpos72= G->thunkpos;  if (!yy_Sp(G))  goto l72;
  goto l73;
  l72:;	  G->pos= yypos72; G->thunkpos= yythunkpos72;
  }
  l73:;	
  l74:;	
  {  int yypos75= G->pos, yythunkpos75= G->thunkpos;  if (!yymatchChar(G, '#')) goto l75;
  goto l74;
  l75:;	  G->pos= yypos75; G->thunkpos= yythunkpos75;
  }  if (!yy_Sp(G))  goto l71;
  if (!yy_Newline(G))  goto l71;
  goto l69;
  l71:;	  G->pos= yypos71; G->thunkpos= yythunkpos71;
  }  if (!yymatchDot(G)) goto l69;  goto l68;
  l69:;	  G->pos= yypos69; G->thunkpos= yythunkpos69;
  }  yyText(G, G->begin, G->end);  if (!(YY_END)) goto l64;
  {  int yypos76= G->pos, yythunkpos76= G->thunkpos;
  {  int yypos78= G->pos, yythunkpos78= G->thunkpos;  if (!yy_Sp(G))  goto l78;
  goto l79;
  l78:;	  G->pos= yypos78; G->thunkpos= yythunkpos78;
  }
  l79:;	  if (!yymatchChar(G, '#')) goto l76;

  l80:;	
  {  int yypos81= G->pos, yythunkpos81= G->thunkpos;  if (!yymatchChar(G, '#')) goto l81;
  goto l80;
  l81:;	  G->pos= yypos81; G->thunkpos= yythunkpos81;
  }  goto l77;
  l76:;	  G->pos= yypos76; G->thunkpos= yythunkpos76;
  }
  l77:;	
  {  int yypos82= G->pos, yythunkpos82= G->thunkpos;  if (!yy_Sp(G))  goto l82;
  goto l83;
  l82:;	  G->pos= yypos82; G->thunkpos= yythunkpos82;
  }
  l83:;	  if (!yy_Newline(G))  goto l64;
  yyDo(G, yy_1_OPMLAtxHeading, G->begin, G->end, "yy_1_OPMLAtxHeading");
  yyprintf((stderr, "  ok   OPMLAtxHeading"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));
  yyDo(G, yyPop, 1, 0, "yyPop");
  return 1;
  l64:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "OPMLAtxHeading"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_OPMLSectionBlock(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "OPMLSectionBlock"));

  l85:;	
  {  int yypos86= G->pos, yythunkpos86= G->thunkpos;  if (!yy_BlankLine(G))  goto l86;
  goto l85;
  l86:;	  G->pos= yypos86; G->thunkpos= yythunkpos86;
  }
  {  int yypos87= G->pos, yythunkpos87= G->thunkpos;  if (!yy_OPMLHeading(G))  goto l87;
  goto l84;
  l87:;	  G->pos= yypos87; G->thunkpos= yythunkpos87;
  }  if (!yy_OPMLPlain(G))  goto l84;
  yyprintf((stderr, "  ok   OPMLSectionBlock"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l84:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "OPMLSectionBlock"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_OPMLHeading(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "OPMLHeading"));

  {  int yypos89= G->pos, yythunkpos89= G->thunkpos;  if (!yy_OPMLAtxHeading(G))  goto l90;
  goto l89;
  l90:;	  G->pos= yypos89; G->thunkpos= yythunkpos89;  if (!yy_OPMLSetextHeading(G))  goto l88;

  }
  l89:;	  yyprintf((stderr, "  ok   OPMLHeading"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l88:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "OPMLHeading"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_OPMLPlain(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyDo(G, yyPush, 1, 0, "yyPush");
  yyprintfv((stderr, "%s\n", "OPMLPlain"));
  if (!yy_StartList(G))  goto l91;
  yyDo(G, yySet, -1, 0, "yySet");

  {  int yypos94= G->pos, yythunkpos94= G->thunkpos;  if (!yy_BlankLine(G))  goto l94;
  goto l91;
  l94:;	  G->pos= yypos94; G->thunkpos= yythunkpos94;
  }
  {  int yypos95= G->pos, yythunkpos95= G->thunkpos;  if (!yy_Heading(G))  goto l95;
  goto l91;
  l95:;	  G->pos= yypos95; G->thunkpos= yythunkpos95;
  }  if (!yy_Line(G))  goto l91;
  yyDo(G, yy_1_OPMLPlain, G->begin, G->end, "yy_1_OPMLPlain");

  l92:;	
  {  int yypos93= G->pos, yythunkpos93= G->thunkpos;
  {  int yypos96= G->pos, yythunkpos96= G->thunkpos;  if (!yy_BlankLine(G))  goto l96;
  goto l93;
  l96:;	  G->pos= yypos96; G->thunkpos= yythunkpos96;
  }
  {  int yypos97= G->pos, yythunkpos97= G->thunkpos;  if (!yy_Heading(G))  goto l97;
  goto l93;
  l97:;	  G->pos= yypos97; G->thunkpos= yythunkpos97;
  }  if (!yy_Line(G))  goto l93;
  yyDo(G, yy_1_OPMLPlain, G->begin, G->end, "yy_1_OPMLPlain");
  goto l92;
  l93:;	  G->pos= yypos93; G->thunkpos= yythunkpos93;
  }  yyDo(G, yy_2_OPMLPlain, G->begin, G->end, "yy_2_OPMLPlain");
  yyprintf((stderr, "  ok   OPMLPlain"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));
  yyDo(G, yyPop, 1, 0, "yyPop");
  return 1;
  l91:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "OPMLPlain"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_OPMLHeadingSection(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyDo(G, yyPush, 1, 0, "yyPush");
  yyprintfv((stderr, "%s\n", "OPMLHeadingSection"));
  if (!yy_StartList(G))  goto l98;
  yyDo(G, yySet, -1, 0, "yySet");
  if (!yy_OPMLHeading(G))  goto l98;
  yyDo(G, yy_1_OPMLHeadingSection, G->begin, G->end, "yy_1_OPMLHeadingSection");

  l99:;	
  {  int yypos100= G->pos, yythunkpos100= G->thunkpos;  if (!yy_OPMLSectionBlock(G))  goto l100;
  yyDo(G, yy_2_OPMLHeadingSection, G->begin, G->end, "yy_2_OPMLHeadingSection");
  goto l99;
  l100:;	  G->pos= yypos100; G->thunkpos= yythunkpos100;
  }  yyDo(G, yy_3_OPMLHeadingSection, G->begin, G->end, "yy_3_OPMLHeadingSection");
  yyprintf((stderr, "  ok   OPMLHeadingSection"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));
  yyDo(G, yyPop, 1, 0, "yyPop");
  return 1;
  l98:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "OPMLHeadingSection"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_OPMLBlock(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "OPMLBlock"));

  l102:;	
  {  int yypos103= G->pos, yythunkpos103= G->thunkpos;  if (!yy_BlankLine(G))  goto l103;
  goto l102;
  l103:;	  G->pos= yypos103; G->thunkpos= yythunkpos103;
  }
  {  int yypos104= G->pos, yythunkpos104= G->thunkpos;  if (!yy_OPMLHeadingSection(G))  goto l105;
  goto l104;
  l105:;	  G->pos= yypos104; G->thunkpos= yythunkpos104;  if (!yy_OPMLPlain(G))  goto l101;

  }
  l104:;	  yyprintf((stderr, "  ok   OPMLBlock"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l101:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "OPMLBlock"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_DocForOPML(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyDo(G, yyPush, 1, 0, "yyPush");
  yyprintfv((stderr, "%s\n", "DocForOPML"));

  {  int yypos107= G->pos, yythunkpos107= G->thunkpos;  if (!yy_BOM(G))  goto l107;
  goto l108;
  l107:;	  G->pos= yypos107; G->thunkpos= yythunkpos107;
  }
  l108:;	  if (!yy_StartList(G))  goto l106;
  yyDo(G, yySet, -1, 0, "yySet");

  {  int yypos109= G->pos, yythunkpos109= G->thunkpos;  yyText(G, G->begin, G->end);  if (!( !ext(EXT_COMPATIBILITY) )) goto l109;
  {  int yypos111= G->pos, yythunkpos111= G->thunkpos;  if (!yy_MetaDataKey(G))  goto l109;
  if (!yy_Sp(G))  goto l109;
  if (!yymatchChar(G, ':')) goto l109;
  if (!yy_Sp(G))  goto l109;

  {  int yypos112= G->pos, yythunkpos112= G->thunkpos;  if (!yy_Newline(G))  goto l112;
  goto l109;
  l112:;	  G->pos= yypos112; G->thunkpos= yythunkpos112;
  }  G->pos= yypos111; G->thunkpos= yythunkpos111;
  }  if (!yy_MetaData(G))  goto l109;
  yyDo(G, yy_1_DocForOPML, G->begin, G->end, "yy_1_DocForOPML");
  goto l110;
  l109:;	  G->pos= yypos109; G->thunkpos= yythunkpos109;
  }
  l110:;	
  l113:;	
  {  int yypos114= G->pos, yythunkpos114= G->thunkpos;  if (!yy_OPMLBlock(G))  goto l114;
  yyDo(G, yy_2_DocForOPML, G->begin, G->end, "yy_2_DocForOPML");
  goto l113;
  l114:;	  G->pos= yypos114; G->thunkpos= yythunkpos114;
  }
  l115:;	
  {  int yypos116= G->pos, yythunkpos116= G->thunkpos;  if (!yy_BlankLine(G))  goto l116;
  goto l115;
  l116:;	  G->pos= yypos116; G->thunkpos= yythunkpos116;
  }  yyDo(G, yy_3_DocForOPML, G->begin, G->end, "yy_3_DocForOPML");
  yyprintf((stderr, "  ok   DocForOPML"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));
  yyDo(G, yyPop, 1, 0, "yyPop");
  return 1;
  l106:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "DocForOPML"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_RightAlign(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "RightAlign"));
  if (!yymatchChar(G, '-')) goto l117;

  l118:;	
  {  int yypos119= G->pos, yythunkpos119= G->thunkpos;  if (!yymatchChar(G, '-')) goto l119;
  goto l118;
  l119:;	  G->pos= yypos119; G->thunkpos= yythunkpos119;
  }  if (!yymatchChar(G, ':')) goto l117;

  {  int yypos120= G->pos, yythunkpos120= G->thunkpos;
  {  int yypos121= G->pos, yythunkpos121= G->thunkpos;  if (!yymatchChar(G, '-')) goto l121;
  goto l117;
  l121:;	  G->pos= yypos121; G->thunkpos= yythunkpos121;
  }
  {  int yypos122= G->pos, yythunkpos122= G->thunkpos;  if (!yymatchChar(G, ':')) goto l122;
  goto l117;
  l122:;	  G->pos= yypos122; G->thunkpos= yythunkpos122;
  }  G->pos= yypos120; G->thunkpos= yythunkpos120;
  }  yyDo(G, yy_1_RightAlign, G->begin, G->end, "yy_1_RightAlign");
  yyprintf((stderr, "  ok   RightAlign"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l117:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "RightAlign"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_CenterAlign(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "CenterAlign"));
  if (!yymatchChar(G, ':')) goto l123;

  l124:;	
  {  int yypos125= G->pos, yythunkpos125= G->thunkpos;  if (!yymatchChar(G, '-')) goto l125;
  goto l124;
  l125:;	  G->pos= yypos125; G->thunkpos= yythunkpos125;
  }  if (!yymatchChar(G, ':')) goto l123;

  {  int yypos126= G->pos, yythunkpos126= G->thunkpos;
  {  int yypos127= G->pos, yythunkpos127= G->thunkpos;  if (!yymatchChar(G, '-')) goto l127;
  goto l123;
  l127:;	  G->pos= yypos127; G->thunkpos= yythunkpos127;
  }
  {  int yypos128= G->pos, yythunkpos128= G->thunkpos;  if (!yymatchChar(G, ':')) goto l128;
  goto l123;
  l128:;	  G->pos= yypos128; G->thunkpos= yythunkpos128;
  }  G->pos= yypos126; G->thunkpos= yythunkpos126;
  }  yyDo(G, yy_1_CenterAlign, G->begin, G->end, "yy_1_CenterAlign");
  yyprintf((stderr, "  ok   CenterAlign"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l123:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "CenterAlign"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_LeftAlign(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "LeftAlign"));

  {  int yypos130= G->pos, yythunkpos130= G->thunkpos;  if (!yymatchChar(G, ':')) goto l130;
  goto l131;
  l130:;	  G->pos= yypos130; G->thunkpos= yythunkpos130;
  }
  l131:;	  if (!yymatchChar(G, '-')) goto l129;

  l132:;	
  {  int yypos133= G->pos, yythunkpos133= G->thunkpos;  if (!yymatchChar(G, '-')) goto l133;
  goto l132;
  l133:;	  G->pos= yypos133; G->thunkpos= yythunkpos133;
  }
  {  int yypos134= G->pos, yythunkpos134= G->thunkpos;
  {  int yypos135= G->pos, yythunkpos135= G->thunkpos;  if (!yymatchChar(G, '-')) goto l135;
  goto l129;
  l135:;	  G->pos= yypos135; G->thunkpos= yythunkpos135;
  }
  {  int yypos136= G->pos, yythunkpos136= G->thunkpos;  if (!yymatchChar(G, ':')) goto l136;
  goto l129;
  l136:;	  G->pos= yypos136; G->thunkpos= yythunkpos136;
  }  G->pos= yypos134; G->thunkpos= yythunkpos134;
  }  yyDo(G, yy_1_LeftAlign, G->begin, G->end, "yy_1_LeftAlign");
  yyprintf((stderr, "  ok   LeftAlign"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l129:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "LeftAlign"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_RightAlignWrap(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "RightAlignWrap"));
  if (!yymatchChar(G, '-')) goto l137;

  l138:;	
  {  int yypos139= G->pos, yythunkpos139= G->thunkpos;  if (!yymatchChar(G, '-')) goto l139;
  goto l138;
  l139:;	  G->pos= yypos139; G->thunkpos= yythunkpos139;
  }  if (!yymatchChar(G, ':')) goto l137;
  if (!yymatchChar(G, '+')) goto l137;

  {  int yypos140= G->pos, yythunkpos140= G->thunkpos;
  {  int yypos141= G->pos, yythunkpos141= G->thunkpos;  if (!yymatchChar(G, '-')) goto l141;
  goto l137;
  l141:;	  G->pos= yypos141; G->thunkpos= yythunkpos141;
  }
  {  int yypos142= G->pos, yythunkpos142= G->thunkpos;  if (!yymatchChar(G, ':')) goto l142;
  goto l137;
  l142:;	  G->pos= yypos142; G->thunkpos= yythunkpos142;
  }  G->pos= yypos140; G->thunkpos= yythunkpos140;
  }  yyDo(G, yy_1_RightAlignWrap, G->begin, G->end, "yy_1_RightAlignWrap");
  yyprintf((stderr, "  ok   RightAlignWrap"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l137:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "RightAlignWrap"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_CenterAlignWrap(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "CenterAlignWrap"));
  if (!yymatchChar(G, ':')) goto l143;

  l144:;	
  {  int yypos145= G->pos, yythunkpos145= G->thunkpos;  if (!yymatchChar(G, '-')) goto l145;
  goto l144;
  l145:;	  G->pos= yypos145; G->thunkpos= yythunkpos145;
  }  if (!yymatchChar(G, '+')) goto l143;
  if (!yymatchChar(G, ':')) goto l143;

  {  int yypos146= G->pos, yythunkpos146= G->thunkpos;
  {  int yypos147= G->pos, yythunkpos147= G->thunkpos;  if (!yymatchChar(G, '-')) goto l147;
  goto l143;
  l147:;	  G->pos= yypos147; G->thunkpos= yythunkpos147;
  }
  {  int yypos148= G->pos, yythunkpos148= G->thunkpos;  if (!yymatchChar(G, ':')) goto l148;
  goto l143;
  l148:;	  G->pos= yypos148; G->thunkpos= yythunkpos148;
  }  G->pos= yypos146; G->thunkpos= yythunkpos146;
  }  yyDo(G, yy_1_CenterAlignWrap, G->begin, G->end, "yy_1_CenterAlignWrap");
  yyprintf((stderr, "  ok   CenterAlignWrap"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l143:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "CenterAlignWrap"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_LeftAlignWrap(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "LeftAlignWrap"));

  {  int yypos150= G->pos, yythunkpos150= G->thunkpos;  if (!yymatchChar(G, ':')) goto l150;
  goto l151;
  l150:;	  G->pos= yypos150; G->thunkpos= yythunkpos150;
  }
  l151:;	  if (!yymatchChar(G, '-')) goto l149;

  l152:;	
  {  int yypos153= G->pos, yythunkpos153= G->thunkpos;  if (!yymatchChar(G, '-')) goto l153;
  goto l152;
  l153:;	  G->pos= yypos153; G->thunkpos= yythunkpos153;
  }  if (!yymatchChar(G, '+')) goto l149;

  {  int yypos154= G->pos, yythunkpos154= G->thunkpos;
  {  int yypos155= G->pos, yythunkpos155= G->thunkpos;  if (!yymatchChar(G, '-')) goto l155;
  goto l149;
  l155:;	  G->pos= yypos155; G->thunkpos= yythunkpos155;
  }
  {  int yypos156= G->pos, yythunkpos156= G->thunkpos;  if (!yymatchChar(G, ':')) goto l156;
  goto l149;
  l156:;	  G->pos= yypos156; G->thunkpos= yythunkpos156;
  }  G->pos= yypos154; G->thunkpos= yythunkpos154;
  }  yyDo(G, yy_1_LeftAlignWrap, G->begin, G->end, "yy_1_LeftAlignWrap");
  yyprintf((stderr, "  ok   LeftAlignWrap"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l149:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "LeftAlignWrap"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_AlignmentCell(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "AlignmentCell"));
  if (!yy_Sp(G))  goto l157;

  {  int yypos158= G->pos, yythunkpos158= G->thunkpos;  if (!yy_CellDivider(G))  goto l158;
  goto l157;
  l158:;	  G->pos= yypos158; G->thunkpos= yythunkpos158;
  }
  {  int yypos159= G->pos, yythunkpos159= G->thunkpos;  if (!yy_LeftAlignWrap(G))  goto l160;
  goto l159;
  l160:;	  G->pos= yypos159; G->thunkpos= yythunkpos159;  if (!yy_CenterAlignWrap(G))  goto l161;
  goto l159;
  l161:;	  G->pos= yypos159; G->thunkpos= yythunkpos159;  if (!yy_RightAlignWrap(G))  goto l162;
  goto l159;
  l162:;	  G->pos= yypos159; G->thunkpos= yythunkpos159;  if (!yy_LeftAlign(G))  goto l163;
  goto l159;
  l163:;	  G->pos= yypos159; G->thunkpos= yythunkpos159;  if (!yy_CenterAlign(G))  goto l164;
  goto l159;
  l164:;	  G->pos= yypos159; G->thunkpos= yythunkpos159;  if (!yy_RightAlign(G))  goto l157;

  }
  l159:;	  if (!yy_Sp(G))  goto l157;

  {  int yypos165= G->pos, yythunkpos165= G->thunkpos;  if (!yy_CellDivider(G))  goto l165;
  goto l166;
  l165:;	  G->pos= yypos165; G->thunkpos= yythunkpos165;
  }
  l166:;	  yyprintf((stderr, "  ok   AlignmentCell"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l157:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "AlignmentCell"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_CellStr(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "CellStr"));
  yyText(G, G->begin, G->end);  if (!(YY_BEGIN)) goto l167;
  {  int yypos168= G->pos, yythunkpos168= G->thunkpos;  if (!yy_CellDivider(G))  goto l168;
  goto l167;
  l168:;	  G->pos= yypos168; G->thunkpos= yythunkpos168;
  }  if (!yy_NormalChar(G))  goto l167;

  l169:;	
  {  int yypos170= G->pos, yythunkpos170= G->thunkpos;
  {  int yypos171= G->pos, yythunkpos171= G->thunkpos;
  {  int yypos173= G->pos, yythunkpos173= G->thunkpos;  if (!yy_CellDivider(G))  goto l173;
  goto l172;
  l173:;	  G->pos= yypos173; G->thunkpos= yythunkpos173;
  }  if (!yy_NormalChar(G))  goto l172;
  goto l171;
  l172:;	  G->pos= yypos171; G->thunkpos= yythunkpos171;  if (!yymatchChar(G, '_')) goto l170;

  l174:;	
  {  int yypos175= G->pos, yythunkpos175= G->thunkpos;  if (!yymatchChar(G, '_')) goto l175;
  goto l174;
  l175:;	  G->pos= yypos175; G->thunkpos= yythunkpos175;
  }
  {  int yypos176= G->pos, yythunkpos176= G->thunkpos;  if (!yy_Alphanumeric(G))  goto l170;
  G->pos= yypos176; G->thunkpos= yythunkpos176;
  }
  }
  l171:;	  goto l169;
  l170:;	  G->pos= yypos170; G->thunkpos= yythunkpos170;
  }  yyText(G, G->begin, G->end);  if (!(YY_END)) goto l167;  yyDo(G, yy_1_CellStr, G->begin, G->end, "yy_1_CellStr");
  yyprintf((stderr, "  ok   CellStr"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l167:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "CellStr"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_FullCell(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyDo(G, yyPush, 1, 0, "yyPush");
  yyprintfv((stderr, "%s\n", "FullCell"));
  if (!yy_Sp(G))  goto l177;
  if (!yy_StartList(G))  goto l177;
  yyDo(G, yySet, -1, 0, "yySet");

  {  int yypos180= G->pos, yythunkpos180= G->thunkpos;
  {  int yypos182= G->pos, yythunkpos182= G->thunkpos;  if (!yy_CellDivider(G))  goto l182;
  goto l181;
  l182:;	  G->pos= yypos182; G->thunkpos= yythunkpos182;
  }  if (!yy_CellStr(G))  goto l181;
  goto l180;
  l181:;	  G->pos= yypos180; G->thunkpos= yythunkpos180;
  {  int yypos183= G->pos, yythunkpos183= G->thunkpos;  if (!yy_Newline(G))  goto l183;
  goto l177;
  l183:;	  G->pos= yypos183; G->thunkpos= yythunkpos183;
  }
  {  int yypos184= G->pos, yythunkpos184= G->thunkpos;  if (!yy_Endline(G))  goto l184;
  goto l177;
  l184:;	  G->pos= yypos184; G->thunkpos= yythunkpos184;
  }
  {  int yypos185= G->pos, yythunkpos185= G->thunkpos;  if (!yy_CellDivider(G))  goto l185;
  goto l177;
  l185:;	  G->pos= yypos185; G->thunkpos= yythunkpos185;
  }
  {  int yypos186= G->pos, yythunkpos186= G->thunkpos;  if (!yy_Str(G))  goto l186;
  goto l177;
  l186:;	  G->pos= yypos186; G->thunkpos= yythunkpos186;
  }
  {  int yypos187= G->pos, yythunkpos187= G->thunkpos;  if (!yy_Sp(G))  goto l187;

  {  int yypos188= G->pos, yythunkpos188= G->thunkpos;  if (!yy_CellDivider(G))  goto l187;
  G->pos= yypos188; G->thunkpos= yythunkpos188;
  }  goto l177;
  l187:;	  G->pos= yypos187; G->thunkpos= yythunkpos187;
  }  if (!yy_Inline(G))  goto l177;

  }
  l180:;	  yyDo(G, yy_1_FullCell, G->begin, G->end, "yy_1_FullCell");

  l178:;	
  {  int yypos179= G->pos, yythunkpos179= G->thunkpos;
  {  int yypos189= G->pos, yythunkpos189= G->thunkpos;
  {  int yypos191= G->pos, yythunkpos191= G->thunkpos;  if (!yy_CellDivider(G))  goto l191;
  goto l190;
  l191:;	  G->pos= yypos191; G->thunkpos= yythunkpos191;
  }  if (!yy_CellStr(G))  goto l190;
  goto l189;
  l190:;	  G->pos= yypos189; G->thunkpos= yythunkpos189;
  {  int yypos192= G->pos, yythunkpos192= G->thunkpos;  if (!yy_Newline(G))  goto l192;
  goto l179;
  l192:;	  G->pos= yypos192; G->thunkpos= yythunkpos192;
  }
  {  int yypos193= G->pos, yythunkpos193= G->thunkpos;  if (!yy_Endline(G))  goto l193;
  goto l179;
  l193:;	  G->pos= yypos193; G->thunkpos= yythunkpos193;
  }
  {  int yypos194= G->pos, yythunkpos194= G->thunkpos;  if (!yy_CellDivider(G))  goto l194;
  goto l179;
  l194:;	  G->pos= yypos194; G->thunkpos= yythunkpos194;
  }
  {  int yypos195= G->pos, yythunkpos195= G->thunkpos;  if (!yy_Str(G))  goto l195;
  goto l179;
  l195:;	  G->pos= yypos195; G->thunkpos= yythunkpos195;
  }
  {  int yypos196= G->pos, yythunkpos196= G->thunkpos;  if (!yy_Sp(G))  goto l196;

  {  int yypos197= G->pos, yythunkpos197= G->thunkpos;  if (!yy_CellDivider(G))  goto l196;
  G->pos= yypos197; G->thunkpos= yythunkpos197;
  }  goto l179;
  l196:;	  G->pos= yypos196; G->thunkpos= yythunkpos196;
  }  if (!yy_Inline(G))  goto l179;

  }
  l189:;	  yyDo(G, yy_1_FullCell, G->begin, G->end, "yy_1_FullCell");
  goto l178;
  l179:;	  G->pos= yypos179; G->thunkpos= yythunkpos179;
  }  yyText(G, G->begin, G->end);  if (!(YY_BEGIN)) goto l177;  if (!yy_Sp(G))  goto l177;
  yyText(G, G->begin, G->end);  if (!(YY_END)) goto l177;
  {  int yypos198= G->pos, yythunkpos198= G->thunkpos;  if (!yy_CellDivider(G))  goto l198;
  goto l199;
  l198:;	  G->pos= yypos198; G->thunkpos= yythunkpos198;
  }
  l199:;	  yyDo(G, yy_2_FullCell, G->begin, G->end, "yy_2_FullCell");
  yyprintf((stderr, "  ok   FullCell"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));
  yyDo(G, yyPop, 1, 0, "yyPop");
  return 1;
  l177:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "FullCell"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_EmptyCell(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "EmptyCell"));
  yyText(G, G->begin, G->end);  if (!(YY_BEGIN)) goto l200;  if (!yy_Sp(G))  goto l200;
  yyText(G, G->begin, G->end);  if (!(YY_END)) goto l200;  if (!yy_CellDivider(G))  goto l200;
  yyDo(G, yy_1_EmptyCell, G->begin, G->end, "yy_1_EmptyCell");
  yyprintf((stderr, "  ok   EmptyCell"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l200:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "EmptyCell"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_ExtendedCell(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "ExtendedCell"));

  {  int yypos202= G->pos, yythunkpos202= G->thunkpos;  if (!yy_EmptyCell(G))  goto l203;
  goto l202;
  l203:;	  G->pos= yypos202; G->thunkpos= yythunkpos202;  if (!yy_FullCell(G))  goto l201;

  }
  l202:;	  yyText(G, G->begin, G->end);  if (!(YY_BEGIN)) goto l201;  if (!yy_CellDivider(G))  goto l201;

  l204:;	
  {  int yypos205= G->pos, yythunkpos205= G->thunkpos;  if (!yy_CellDivider(G))  goto l205;
  goto l204;
  l205:;	  G->pos= yypos205; G->thunkpos= yythunkpos205;
  }  yyText(G, G->begin, G->end);  if (!(YY_END)) goto l201;  yyDo(G, yy_1_ExtendedCell, G->begin, G->end, "yy_1_ExtendedCell");
  yyprintf((stderr, "  ok   ExtendedCell"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l201:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "ExtendedCell"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_TableCell(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "TableCell"));

  {  int yypos207= G->pos, yythunkpos207= G->thunkpos;  if (!yy_ExtendedCell(G))  goto l208;
  goto l207;
  l208:;	  G->pos= yypos207; G->thunkpos= yythunkpos207;  if (!yy_EmptyCell(G))  goto l209;
  goto l207;
  l209:;	  G->pos= yypos207; G->thunkpos= yythunkpos207;  if (!yy_FullCell(G))  goto l206;

  }
  l207:;	  yyprintf((stderr, "  ok   TableCell"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l206:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "TableCell"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_CellDivider(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "CellDivider"));
  if (!yymatchChar(G, '|')) goto l210;
  yyprintf((stderr, "  ok   CellDivider"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l210:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "CellDivider"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_TableLine(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "TableLine"));

  l212:;	
  {  int yypos213= G->pos, yythunkpos213= G->thunkpos;
  {  int yypos214= G->pos, yythunkpos214= G->thunkpos;  if (!yy_Newline(G))  goto l214;
  goto l213;
  l214:;	  G->pos= yypos214; G->thunkpos= yythunkpos214;
  }
  {  int yypos215= G->pos, yythunkpos215= G->thunkpos;  if (!yy_CellDivider(G))  goto l215;
  goto l213;
  l215:;	  G->pos= yypos215; G->thunkpos= yythunkpos215;
  }  if (!yymatchDot(G)) goto l213;  goto l212;
  l213:;	  G->pos= yypos213; G->thunkpos= yythunkpos213;
  }  if (!yy_CellDivider(G))  goto l211;
  yyprintf((stderr, "  ok   TableLine"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l211:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "TableLine"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_TableRow(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyDo(G, yyPush, 1, 0, "yyPush");
  yyprintfv((stderr, "%s\n", "TableRow"));
  if (!yy_StartList(G))  goto l216;
  yyDo(G, yySet, -1, 0, "yySet");

  {  int yypos217= G->pos, yythunkpos217= G->thunkpos;  if (!yy_SeparatorLine(G))  goto l217;
  goto l216;
  l217:;	  G->pos= yypos217; G->thunkpos= yythunkpos217;
  }
  {  int yypos218= G->pos, yythunkpos218= G->thunkpos;  if (!yy_TableLine(G))  goto l216;
  G->pos= yypos218; G->thunkpos= yythunkpos218;
  }
  {  int yypos219= G->pos, yythunkpos219= G->thunkpos;  if (!yy_CellDivider(G))  goto l219;
  goto l220;
  l219:;	  G->pos= yypos219; G->thunkpos= yythunkpos219;
  }
  l220:;	  if (!yy_TableCell(G))  goto l216;
  yyDo(G, yy_1_TableRow, G->begin, G->end, "yy_1_TableRow");

  l221:;	
  {  int yypos222= G->pos, yythunkpos222= G->thunkpos;  if (!yy_TableCell(G))  goto l222;
  yyDo(G, yy_1_TableRow, G->begin, G->end, "yy_1_TableRow");
  goto l221;
  l222:;	  G->pos= yypos222; G->thunkpos= yythunkpos222;
  }  if (!yy_Sp(G))  goto l216;
  yyText(G, G->begin, G->end);  if (!(YY_BEGIN)) goto l216;  if (!yy_Newline(G))  goto l216;
  yyText(G, G->begin, G->end);  if (!(YY_END)) goto l216;  yyDo(G, yy_2_TableRow, G->begin, G->end, "yy_2_TableRow");
  yyprintf((stderr, "  ok   TableRow"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));
  yyDo(G, yyPop, 1, 0, "yyPop");
  return 1;
  l216:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "TableRow"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_SeparatorLine(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyDo(G, yyPush, 1, 0, "yyPush");
  yyprintfv((stderr, "%s\n", "SeparatorLine"));
  if (!yy_StartList(G))  goto l223;
  yyDo(G, yySet, -1, 0, "yySet");

  {  int yypos224= G->pos, yythunkpos224= G->thunkpos;  if (!yy_TableLine(G))  goto l223;
  G->pos= yypos224; G->thunkpos= yythunkpos224;
  }
  {  int yypos225= G->pos, yythunkpos225= G->thunkpos;  if (!yy_CellDivider(G))  goto l225;
  goto l226;
  l225:;	  G->pos= yypos225; G->thunkpos= yythunkpos225;
  }
  l226:;	  if (!yy_AlignmentCell(G))  goto l223;
  yyDo(G, yy_1_SeparatorLine, G->begin, G->end, "yy_1_SeparatorLine");

  l227:;	
  {  int yypos228= G->pos, yythunkpos228= G->thunkpos;  if (!yy_AlignmentCell(G))  goto l228;
  yyDo(G, yy_1_SeparatorLine, G->begin, G->end, "yy_1_SeparatorLine");
  goto l227;
  l228:;	  G->pos= yypos228; G->thunkpos= yythunkpos228;
  }  if (!yy_Sp(G))  goto l223;
  if (!yy_Newline(G))  goto l223;
  yyDo(G, yy_2_SeparatorLine, G->begin, G->end, "yy_2_SeparatorLine");
  yyprintf((stderr, "  ok   SeparatorLine"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));
  yyDo(G, yyPop, 1, 0, "yyPop");
  return 1;
  l223:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "SeparatorLine"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_TableBody(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyDo(G, yyPush, 1, 0, "yyPush");
  yyprintfv((stderr, "%s\n", "TableBody"));
  if (!yy_StartList(G))  goto l229;
  yyDo(G, yySet, -1, 0, "yySet");
  if (!yy_TableRow(G))  goto l229;
  yyDo(G, yy_1_TableBody, G->begin, G->end, "yy_1_TableBody");

  l230:;	
  {  int yypos231= G->pos, yythunkpos231= G->thunkpos;  if (!yy_TableRow(G))  goto l231;
  yyDo(G, yy_1_TableBody, G->begin, G->end, "yy_1_TableBody");
  goto l230;
  l231:;	  G->pos= yypos231; G->thunkpos= yythunkpos231;
  }  yyDo(G, yy_2_TableBody, G->begin, G->end, "yy_2_TableBody");
  yyprintf((stderr, "  ok   TableBody"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));
  yyDo(G, yyPop, 1, 0, "yyPop");
  return 1;
  l229:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "TableBody"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_TableCaption(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyDo(G, yyPush, 3, 0, "yyPush");
  yyprintfv((stderr, "%s\n", "TableCaption"));
  if (!yy_StartList(G))  goto l232;
  yyDo(G, yySet, -3, 0, "yySet");
  if (!yy_Label(G))  goto l232;
  yyDo(G, yySet, -2, 0, "yySet");

  {  int yypos233= G->pos, yythunkpos233= G->thunkpos;  if (!yy_AutoLabel(G))  goto l233;
  yyDo(G, yySet, -1, 0, "yySet");
  yyDo(G, yy_1_TableCaption, G->begin, G->end, "yy_1_TableCaption");
  goto l234;
  l233:;	  G->pos= yypos233; G->thunkpos= yythunkpos233;
  }
  l234:;	  if (!yy_Sp(G))  goto l232;
  if (!yy_Newline(G))  goto l232;
  yyDo(G, yy_2_TableCaption, G->begin, G->end, "yy_2_TableCaption");
  yyprintf((stderr, "  ok   TableCaption"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));
  yyDo(G, yyPop, 3, 0, "yyPop");
  return 1;
  l232:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "TableCaption"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_InStyleTags(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "InStyleTags"));
  if (!yy_StyleOpen(G))  goto l235;

  l236:;	
  {  int yypos237= G->pos, yythunkpos237= G->thunkpos;
  {  int yypos238= G->pos, yythunkpos238= G->thunkpos;  if (!yy_StyleClose(G))  goto l238;
  goto l237;
  l238:;	  G->pos= yypos238; G->thunkpos= yythunkpos238;
  }  if (!yymatchDot(G)) goto l237;  goto l236;
  l237:;	  G->pos= yypos237; G->thunkpos= yythunkpos237;
  }  if (!yy_StyleClose(G))  goto l235;
  yyprintf((stderr, "  ok   InStyleTags"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l235:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "InStyleTags"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_StyleClose(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "StyleClose"));
  if (!yymatchChar(G, '<')) goto l239;
  if (!yy_Spnl(G))  goto l239;
  if (!yymatchChar(G, '/')) goto l239;

  {  int yypos240= G->pos, yythunkpos240= G->thunkpos;  if (!yymatchString(G, "style")) goto l241;
  goto l240;
  l241:;	  G->pos= yypos240; G->thunkpos= yythunkpos240;  if (!yymatchString(G, "STYLE")) goto l239;

  }
  l240:;	  if (!yy_Spnl(G))  goto l239;
  if (!yymatchChar(G, '>')) goto l239;
  yyprintf((stderr, "  ok   StyleClose"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l239:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "StyleClose"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_StyleOpen(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "StyleOpen"));
  if (!yymatchChar(G, '<')) goto l242;
  if (!yy_Spnl(G))  goto l242;

  {  int yypos243= G->pos, yythunkpos243= G->thunkpos;  if (!yymatchString(G, "style")) goto l244;
  goto l243;
  l244:;	  G->pos= yypos243; G->thunkpos= yythunkpos243;  if (!yymatchString(G, "STYLE")) goto l242;

  }
  l243:;	  if (!yy_Spnl(G))  goto l242;

  l245:;	
  {  int yypos246= G->pos, yythunkpos246= G->thunkpos;  if (!yy_HtmlAttribute(G))  goto l246;
  goto l245;
  l246:;	  G->pos= yypos246; G->thunkpos= yythunkpos246;
  }  if (!yymatchChar(G, '>')) goto l242;
  yyprintf((stderr, "  ok   StyleOpen"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l242:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "StyleOpen"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_HtmlBlockType(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "HtmlBlockType"));

  {  int yypos248= G->pos, yythunkpos248= G->thunkpos;  if (!yymatchString(G, "address")) goto l249;
  goto l248;
  l249:;	  G->pos= yypos248; G->thunkpos= yythunkpos248;  if (!yymatchString(G, "blockquote")) goto l250;
  goto l248;
  l250:;	  G->pos= yypos248; G->thunkpos= yythunkpos248;  if (!yymatchString(G, "center")) goto l251;
  goto l248;
  l251:;	  G->pos= yypos248; G->thunkpos= yythunkpos248;  if (!yymatchString(G, "dir")) goto l252;
  goto l248;
  l252:;	  G->pos= yypos248; G->thunkpos= yythunkpos248;  if (!yymatchString(G, "div")) goto l253;
  goto l248;
  l253:;	  G->pos= yypos248; G->thunkpos= yythunkpos248;  if (!yymatchString(G, "dl")) goto l254;
  goto l248;
  l254:;	  G->pos= yypos248; G->thunkpos= yythunkpos248;  if (!yymatchString(G, "fieldset")) goto l255;
  goto l248;
  l255:;	  G->pos= yypos248; G->thunkpos= yythunkpos248;  if (!yymatchString(G, "form")) goto l256;
  goto l248;
  l256:;	  G->pos= yypos248; G->thunkpos= yythunkpos248;  if (!yymatchString(G, "h1")) goto l257;
  goto l248;
  l257:;	  G->pos= yypos248; G->thunkpos= yythunkpos248;  if (!yymatchString(G, "h2")) goto l258;
  goto l248;
  l258:;	  G->pos= yypos248; G->thunkpos= yythunkpos248;  if (!yymatchString(G, "h3")) goto l259;
  goto l248;
  l259:;	  G->pos= yypos248; G->thunkpos= yythunkpos248;  if (!yymatchString(G, "h4")) goto l260;
  goto l248;
  l260:;	  G->pos= yypos248; G->thunkpos= yythunkpos248;  if (!yymatchString(G, "h5")) goto l261;
  goto l248;
  l261:;	  G->pos= yypos248; G->thunkpos= yythunkpos248;  if (!yymatchString(G, "h6")) goto l262;
  goto l248;
  l262:;	  G->pos= yypos248; G->thunkpos= yythunkpos248;  if (!yymatchString(G, "hr")) goto l263;
  goto l248;
  l263:;	  G->pos= yypos248; G->thunkpos= yythunkpos248;  if (!yymatchString(G, "isindex")) goto l264;
  goto l248;
  l264:;	  G->pos= yypos248; G->thunkpos= yythunkpos248;  if (!yymatchString(G, "menu")) goto l265;
  goto l248;
  l265:;	  G->pos= yypos248; G->thunkpos= yythunkpos248;  if (!yymatchString(G, "noframes")) goto l266;
  goto l248;
  l266:;	  G->pos= yypos248; G->thunkpos= yythunkpos248;  if (!yymatchString(G, "noscript")) goto l267;
  goto l248;
  l267:;	  G->pos= yypos248; G->thunkpos= yythunkpos248;  if (!yymatchString(G, "ol")) goto l268;
  goto l248;
  l268:;	  G->pos= yypos248; G->thunkpos= yythunkpos248;  if (!yymatchChar(G, 'p')) goto l269;
  goto l248;
  l269:;	  G->pos= yypos248; G->thunkpos= yythunkpos248;  if (!yymatchString(G, "pre")) goto l270;
  goto l248;
  l270:;	  G->pos= yypos248; G->thunkpos= yythunkpos248;  if (!yymatchString(G, "table")) goto l271;
  goto l248;
  l271:;	  G->pos= yypos248; G->thunkpos= yythunkpos248;  if (!yymatchString(G, "ul")) goto l272;
  goto l248;
  l272:;	  G->pos= yypos248; G->thunkpos= yythunkpos248;  if (!yymatchString(G, "dd")) goto l273;
  goto l248;
  l273:;	  G->pos= yypos248; G->thunkpos= yythunkpos248;  if (!yymatchString(G, "dt")) goto l274;
  goto l248;
  l274:;	  G->pos= yypos248; G->thunkpos= yythunkpos248;  if (!yymatchString(G, "frameset")) goto l275;
  goto l248;
  l275:;	  G->pos= yypos248; G->thunkpos= yythunkpos248;  if (!yymatchString(G, "li")) goto l276;
  goto l248;
  l276:;	  G->pos= yypos248; G->thunkpos= yythunkpos248;  if (!yymatchString(G, "tbody")) goto l277;
  goto l248;
  l277:;	  G->pos= yypos248; G->thunkpos= yythunkpos248;  if (!yymatchString(G, "td")) goto l278;
  goto l248;
  l278:;	  G->pos= yypos248; G->thunkpos= yythunkpos248;  if (!yymatchString(G, "tfoot")) goto l279;
  goto l248;
  l279:;	  G->pos= yypos248; G->thunkpos= yythunkpos248;  if (!yymatchString(G, "th")) goto l280;
  goto l248;
  l280:;	  G->pos= yypos248; G->thunkpos= yythunkpos248;  if (!yymatchString(G, "thead")) goto l281;
  goto l248;
  l281:;	  G->pos= yypos248; G->thunkpos= yythunkpos248;  if (!yymatchString(G, "tr")) goto l282;
  goto l248;
  l282:;	  G->pos= yypos248; G->thunkpos= yythunkpos248;  if (!yymatchString(G, "script")) goto l283;
  goto l248;
  l283:;	  G->pos= yypos248; G->thunkpos= yythunkpos248;  if (!yymatchString(G, "ADDRESS")) goto l284;
  goto l248;
  l284:;	  G->pos= yypos248; G->thunkpos= yythunkpos248;  if (!yymatchString(G, "BLOCKQUOTE")) goto l285;
  goto l248;
  l285:;	  G->pos= yypos248; G->thunkpos= yythunkpos248;  if (!yymatchString(G, "CENTER")) goto l286;
  goto l248;
  l286:;	  G->pos= yypos248; G->thunkpos= yythunkpos248;  if (!yymatchString(G, "DIR")) goto l287;
  goto l248;
  l287:;	  G->pos= yypos248; G->thunkpos= yythunkpos248;  if (!yymatchString(G, "DIV")) goto l288;
  goto l248;
  l288:;	  G->pos= yypos248; G->thunkpos= yythunkpos248;  if (!yymatchString(G, "DL")) goto l289;
  goto l248;
  l289:;	  G->pos= yypos248; G->thunkpos= yythunkpos248;  if (!yymatchString(G, "FIELDSET")) goto l290;
  goto l248;
  l290:;	  G->pos= yypos248; G->thunkpos= yythunkpos248;  if (!yymatchString(G, "FORM")) goto l291;
  goto l248;
  l291:;	  G->pos= yypos248; G->thunkpos= yythunkpos248;  if (!yymatchString(G, "H1")) goto l292;
  goto l248;
  l292:;	  G->pos= yypos248; G->thunkpos= yythunkpos248;  if (!yymatchString(G, "H2")) goto l293;
  goto l248;
  l293:;	  G->pos= yypos248; G->thunkpos= yythunkpos248;  if (!yymatchString(G, "H3")) goto l294;
  goto l248;
  l294:;	  G->pos= yypos248; G->thunkpos= yythunkpos248;  if (!yymatchString(G, "H4")) goto l295;
  goto l248;
  l295:;	  G->pos= yypos248; G->thunkpos= yythunkpos248;  if (!yymatchString(G, "H5")) goto l296;
  goto l248;
  l296:;	  G->pos= yypos248; G->thunkpos= yythunkpos248;  if (!yymatchString(G, "H6")) goto l297;
  goto l248;
  l297:;	  G->pos= yypos248; G->thunkpos= yythunkpos248;  if (!yymatchString(G, "HR")) goto l298;
  goto l248;
  l298:;	  G->pos= yypos248; G->thunkpos= yythunkpos248;  if (!yymatchString(G, "ISINDEX")) goto l299;
  goto l248;
  l299:;	  G->pos= yypos248; G->thunkpos= yythunkpos248;  if (!yymatchString(G, "MENU")) goto l300;
  goto l248;
  l300:;	  G->pos= yypos248; G->thunkpos= yythunkpos248;  if (!yymatchString(G, "NOFRAMES")) goto l301;
  goto l248;
  l301:;	  G->pos= yypos248; G->thunkpos= yythunkpos248;  if (!yymatchString(G, "NOSCRIPT")) goto l302;
  goto l248;
  l302:;	  G->pos= yypos248; G->thunkpos= yythunkpos248;  if (!yymatchString(G, "OL")) goto l303;
  goto l248;
  l303:;	  G->pos= yypos248; G->thunkpos= yythunkpos248;  if (!yymatchChar(G, 'P')) goto l304;
  goto l248;
  l304:;	  G->pos= yypos248; G->thunkpos= yythunkpos248;  if (!yymatchString(G, "PRE")) goto l305;
  goto l248;
  l305:;	  G->pos= yypos248; G->thunkpos= yythunkpos248;  if (!yymatchString(G, "TABLE")) goto l306;
  goto l248;
  l306:;	  G->pos= yypos248; G->thunkpos= yythunkpos248;  if (!yymatchString(G, "UL")) goto l307;
  goto l248;
  l307:;	  G->pos= yypos248; G->thunkpos= yythunkpos248;  if (!yymatchString(G, "DD")) goto l308;
  goto l248;
  l308:;	  G->pos= yypos248; G->thunkpos= yythunkpos248;  if (!yymatchString(G, "DT")) goto l309;
  goto l248;
  l309:;	  G->pos= yypos248; G->thunkpos= yythunkpos248;  if (!yymatchString(G, "FRAMESET")) goto l310;
  goto l248;
  l310:;	  G->pos= yypos248; G->thunkpos= yythunkpos248;  if (!yymatchString(G, "LI")) goto l311;
  goto l248;
  l311:;	  G->pos= yypos248; G->thunkpos= yythunkpos248;  if (!yymatchString(G, "TBODY")) goto l312;
  goto l248;
  l312:;	  G->pos= yypos248; G->thunkpos= yythunkpos248;  if (!yymatchString(G, "TD")) goto l313;
  goto l248;
  l313:;	  G->pos= yypos248; G->thunkpos= yythunkpos248;  if (!yymatchString(G, "TFOOT")) goto l314;
  goto l248;
  l314:;	  G->pos= yypos248; G->thunkpos= yythunkpos248;  if (!yymatchString(G, "TH")) goto l315;
  goto l248;
  l315:;	  G->pos= yypos248; G->thunkpos= yythunkpos248;  if (!yymatchString(G, "THEAD")) goto l316;
  goto l248;
  l316:;	  G->pos= yypos248; G->thunkpos= yythunkpos248;  if (!yymatchString(G, "TR")) goto l317;
  goto l248;
  l317:;	  G->pos= yypos248; G->thunkpos= yythunkpos248;  if (!yymatchString(G, "SCRIPT")) goto l247;

  }
  l248:;	  yyprintf((stderr, "  ok   HtmlBlockType"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l247:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "HtmlBlockType"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_MarkdownHtmlAttribute(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "MarkdownHtmlAttribute"));

  {  int yypos319= G->pos, yythunkpos319= G->thunkpos;  if (!yymatchString(G, "markdown")) goto l320;
  goto l319;
  l320:;	  G->pos= yypos319; G->thunkpos= yythunkpos319;  if (!yymatchString(G, "MARKDOWN")) goto l318;

  }
  l319:;	  if (!yy_Spnl(G))  goto l318;
  if (!yymatchChar(G, '=')) goto l318;
  if (!yy_Spnl(G))  goto l318;

  {  int yypos321= G->pos, yythunkpos321= G->thunkpos;  if (!yymatchChar(G, '"')) goto l321;
  if (!yy_Spnl(G))  goto l321;
  goto l322;
  l321:;	  G->pos= yypos321; G->thunkpos= yythunkpos321;
  }
  l322:;	  if (!yymatchChar(G, '1')) goto l318;

  {  int yypos323= G->pos, yythunkpos323= G->thunkpos;  if (!yy_Spnl(G))  goto l323;
  if (!yymatchChar(G, '"')) goto l323;
  goto l324;
  l323:;	  G->pos= yypos323; G->thunkpos= yythunkpos323;
  }
  l324:;	  if (!yy_Spnl(G))  goto l318;
  yyprintf((stderr, "  ok   MarkdownHtmlAttribute"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l318:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "MarkdownHtmlAttribute"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_HtmlBlockSelfClosing(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "HtmlBlockSelfClosing"));
  if (!yymatchChar(G, '<')) goto l325;
  if (!yy_Spnl(G))  goto l325;
  if (!yy_HtmlBlockType(G))  goto l325;
  if (!yy_Spnl(G))  goto l325;

  l326:;	
  {  int yypos327= G->pos, yythunkpos327= G->thunkpos;  if (!yy_HtmlAttribute(G))  goto l327;
  goto l326;
  l327:;	  G->pos= yypos327; G->thunkpos= yythunkpos327;
  }  if (!yymatchChar(G, '/')) goto l325;
  if (!yy_Spnl(G))  goto l325;
  if (!yymatchChar(G, '>')) goto l325;
  yyprintf((stderr, "  ok   HtmlBlockSelfClosing"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l325:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "HtmlBlockSelfClosing"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_HtmlBlockCloseScript(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "HtmlBlockCloseScript"));
  if (!yymatchChar(G, '<')) goto l328;
  if (!yy_Spnl(G))  goto l328;
  if (!yymatchChar(G, '/')) goto l328;

  {  int yypos329= G->pos, yythunkpos329= G->thunkpos;  if (!yymatchString(G, "script")) goto l330;
  goto l329;
  l330:;	  G->pos= yypos329; G->thunkpos= yythunkpos329;  if (!yymatchString(G, "SCRIPT")) goto l328;

  }
  l329:;	  if (!yy_Spnl(G))  goto l328;
  if (!yymatchChar(G, '>')) goto l328;
  yyprintf((stderr, "  ok   HtmlBlockCloseScript"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l328:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "HtmlBlockCloseScript"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_HtmlBlockOpenScript(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "HtmlBlockOpenScript"));
  if (!yymatchChar(G, '<')) goto l331;
  if (!yy_Spnl(G))  goto l331;

  {  int yypos332= G->pos, yythunkpos332= G->thunkpos;  if (!yymatchString(G, "script")) goto l333;
  goto l332;
  l333:;	  G->pos= yypos332; G->thunkpos= yythunkpos332;  if (!yymatchString(G, "SCRIPT")) goto l331;

  }
  l332:;	  if (!yy_Spnl(G))  goto l331;

  l334:;	
  {  int yypos335= G->pos, yythunkpos335= G->thunkpos;  if (!yy_HtmlAttribute(G))  goto l335;
  goto l334;
  l335:;	  G->pos= yypos335; G->thunkpos= yythunkpos335;
  }  if (!yymatchChar(G, '>')) goto l331;
  yyprintf((stderr, "  ok   HtmlBlockOpenScript"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l331:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "HtmlBlockOpenScript"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_HtmlBlockTr(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "HtmlBlockTr"));
  if (!yy_HtmlBlockOpenTr(G))  goto l336;

  l337:;	
  {  int yypos338= G->pos, yythunkpos338= G->thunkpos;
  {  int yypos339= G->pos, yythunkpos339= G->thunkpos;  if (!yy_HtmlBlockTr(G))  goto l340;
  goto l339;
  l340:;	  G->pos= yypos339; G->thunkpos= yythunkpos339;
  {  int yypos341= G->pos, yythunkpos341= G->thunkpos;  if (!yy_HtmlBlockCloseTr(G))  goto l341;
  goto l338;
  l341:;	  G->pos= yypos341; G->thunkpos= yythunkpos341;
  }  if (!yymatchDot(G)) goto l338;
  }
  l339:;	  goto l337;
  l338:;	  G->pos= yypos338; G->thunkpos= yythunkpos338;
  }  if (!yy_HtmlBlockCloseTr(G))  goto l336;
  yyprintf((stderr, "  ok   HtmlBlockTr"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l336:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "HtmlBlockTr"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_HtmlBlockCloseTr(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "HtmlBlockCloseTr"));
  if (!yymatchChar(G, '<')) goto l342;
  if (!yy_Spnl(G))  goto l342;
  if (!yymatchChar(G, '/')) goto l342;

  {  int yypos343= G->pos, yythunkpos343= G->thunkpos;  if (!yymatchString(G, "tr")) goto l344;
  goto l343;
  l344:;	  G->pos= yypos343; G->thunkpos= yythunkpos343;  if (!yymatchString(G, "TR")) goto l342;

  }
  l343:;	  if (!yy_Spnl(G))  goto l342;
  if (!yymatchChar(G, '>')) goto l342;
  yyprintf((stderr, "  ok   HtmlBlockCloseTr"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l342:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "HtmlBlockCloseTr"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_HtmlBlockOpenTr(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "HtmlBlockOpenTr"));
  if (!yymatchChar(G, '<')) goto l345;
  if (!yy_Spnl(G))  goto l345;

  {  int yypos346= G->pos, yythunkpos346= G->thunkpos;  if (!yymatchString(G, "tr")) goto l347;
  goto l346;
  l347:;	  G->pos= yypos346; G->thunkpos= yythunkpos346;  if (!yymatchString(G, "TR")) goto l345;

  }
  l346:;	  if (!yy_Spnl(G))  goto l345;

  l348:;	
  {  int yypos349= G->pos, yythunkpos349= G->thunkpos;  if (!yy_HtmlAttribute(G))  goto l349;
  goto l348;
  l349:;	  G->pos= yypos349; G->thunkpos= yythunkpos349;
  }  if (!yymatchChar(G, '>')) goto l345;
  yyprintf((stderr, "  ok   HtmlBlockOpenTr"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l345:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "HtmlBlockOpenTr"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_HtmlBlockThead(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "HtmlBlockThead"));
  if (!yy_HtmlBlockOpenThead(G))  goto l350;

  l351:;	
  {  int yypos352= G->pos, yythunkpos352= G->thunkpos;
  {  int yypos353= G->pos, yythunkpos353= G->thunkpos;  if (!yy_HtmlBlockThead(G))  goto l354;
  goto l353;
  l354:;	  G->pos= yypos353; G->thunkpos= yythunkpos353;
  {  int yypos355= G->pos, yythunkpos355= G->thunkpos;  if (!yy_HtmlBlockCloseThead(G))  goto l355;
  goto l352;
  l355:;	  G->pos= yypos355; G->thunkpos= yythunkpos355;
  }  if (!yymatchDot(G)) goto l352;
  }
  l353:;	  goto l351;
  l352:;	  G->pos= yypos352; G->thunkpos= yythunkpos352;
  }  if (!yy_HtmlBlockCloseThead(G))  goto l350;
  yyprintf((stderr, "  ok   HtmlBlockThead"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l350:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "HtmlBlockThead"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_HtmlBlockCloseThead(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "HtmlBlockCloseThead"));
  if (!yymatchChar(G, '<')) goto l356;
  if (!yy_Spnl(G))  goto l356;
  if (!yymatchChar(G, '/')) goto l356;

  {  int yypos357= G->pos, yythunkpos357= G->thunkpos;  if (!yymatchString(G, "thead")) goto l358;
  goto l357;
  l358:;	  G->pos= yypos357; G->thunkpos= yythunkpos357;  if (!yymatchString(G, "THEAD")) goto l356;

  }
  l357:;	  if (!yy_Spnl(G))  goto l356;
  if (!yymatchChar(G, '>')) goto l356;
  yyprintf((stderr, "  ok   HtmlBlockCloseThead"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l356:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "HtmlBlockCloseThead"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_HtmlBlockOpenThead(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "HtmlBlockOpenThead"));
  if (!yymatchChar(G, '<')) goto l359;
  if (!yy_Spnl(G))  goto l359;

  {  int yypos360= G->pos, yythunkpos360= G->thunkpos;  if (!yymatchString(G, "thead")) goto l361;
  goto l360;
  l361:;	  G->pos= yypos360; G->thunkpos= yythunkpos360;  if (!yymatchString(G, "THEAD")) goto l359;

  }
  l360:;	  if (!yy_Spnl(G))  goto l359;

  l362:;	
  {  int yypos363= G->pos, yythunkpos363= G->thunkpos;  if (!yy_HtmlAttribute(G))  goto l363;
  goto l362;
  l363:;	  G->pos= yypos363; G->thunkpos= yythunkpos363;
  }  if (!yymatchChar(G, '>')) goto l359;
  yyprintf((stderr, "  ok   HtmlBlockOpenThead"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l359:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "HtmlBlockOpenThead"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_HtmlBlockTh(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "HtmlBlockTh"));
  if (!yy_HtmlBlockOpenTh(G))  goto l364;

  l365:;	
  {  int yypos366= G->pos, yythunkpos366= G->thunkpos;
  {  int yypos367= G->pos, yythunkpos367= G->thunkpos;  if (!yy_HtmlBlockTh(G))  goto l368;
  goto l367;
  l368:;	  G->pos= yypos367; G->thunkpos= yythunkpos367;
  {  int yypos369= G->pos, yythunkpos369= G->thunkpos;  if (!yy_HtmlBlockCloseTh(G))  goto l369;
  goto l366;
  l369:;	  G->pos= yypos369; G->thunkpos= yythunkpos369;
  }  if (!yymatchDot(G)) goto l366;
  }
  l367:;	  goto l365;
  l366:;	  G->pos= yypos366; G->thunkpos= yythunkpos366;
  }  if (!yy_HtmlBlockCloseTh(G))  goto l364;
  yyprintf((stderr, "  ok   HtmlBlockTh"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l364:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "HtmlBlockTh"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_HtmlBlockCloseTh(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "HtmlBlockCloseTh"));
  if (!yymatchChar(G, '<')) goto l370;
  if (!yy_Spnl(G))  goto l370;
  if (!yymatchChar(G, '/')) goto l370;

  {  int yypos371= G->pos, yythunkpos371= G->thunkpos;  if (!yymatchString(G, "th")) goto l372;
  goto l371;
  l372:;	  G->pos= yypos371; G->thunkpos= yythunkpos371;  if (!yymatchString(G, "TH")) goto l370;

  }
  l371:;	  if (!yy_Spnl(G))  goto l370;
  if (!yymatchChar(G, '>')) goto l370;
  yyprintf((stderr, "  ok   HtmlBlockCloseTh"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l370:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "HtmlBlockCloseTh"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_HtmlBlockOpenTh(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "HtmlBlockOpenTh"));
  if (!yymatchChar(G, '<')) goto l373;
  if (!yy_Spnl(G))  goto l373;

  {  int yypos374= G->pos, yythunkpos374= G->thunkpos;  if (!yymatchString(G, "th")) goto l375;
  goto l374;
  l375:;	  G->pos= yypos374; G->thunkpos= yythunkpos374;  if (!yymatchString(G, "TH")) goto l373;

  }
  l374:;	  if (!yy_Spnl(G))  goto l373;

  l376:;	
  {  int yypos377= G->pos, yythunkpos377= G->thunkpos;  if (!yy_HtmlAttribute(G))  goto l377;
  goto l376;
  l377:;	  G->pos= yypos377; G->thunkpos= yythunkpos377;
  }  if (!yymatchChar(G, '>')) goto l373;
  yyprintf((stderr, "  ok   HtmlBlockOpenTh"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l373:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "HtmlBlockOpenTh"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_HtmlBlockTfoot(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "HtmlBlockTfoot"));
  if (!yy_HtmlBlockOpenTfoot(G))  goto l378;

  l379:;	
  {  int yypos380= G->pos, yythunkpos380= G->thunkpos;
  {  int yypos381= G->pos, yythunkpos381= G->thunkpos;  if (!yy_HtmlBlockTfoot(G))  goto l382;
  goto l381;
  l382:;	  G->pos= yypos381; G->thunkpos= yythunkpos381;
  {  int yypos383= G->pos, yythunkpos383= G->thunkpos;  if (!yy_HtmlBlockCloseTfoot(G))  goto l383;
  goto l380;
  l383:;	  G->pos= yypos383; G->thunkpos= yythunkpos383;
  }  if (!yymatchDot(G)) goto l380;
  }
  l381:;	  goto l379;
  l380:;	  G->pos= yypos380; G->thunkpos= yythunkpos380;
  }  if (!yy_HtmlBlockCloseTfoot(G))  goto l378;
  yyprintf((stderr, "  ok   HtmlBlockTfoot"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l378:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "HtmlBlockTfoot"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_HtmlBlockCloseTfoot(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "HtmlBlockCloseTfoot"));
  if (!yymatchChar(G, '<')) goto l384;
  if (!yy_Spnl(G))  goto l384;
  if (!yymatchChar(G, '/')) goto l384;

  {  int yypos385= G->pos, yythunkpos385= G->thunkpos;  if (!yymatchString(G, "tfoot")) goto l386;
  goto l385;
  l386:;	  G->pos= yypos385; G->thunkpos= yythunkpos385;  if (!yymatchString(G, "TFOOT")) goto l384;

  }
  l385:;	  if (!yy_Spnl(G))  goto l384;
  if (!yymatchChar(G, '>')) goto l384;
  yyprintf((stderr, "  ok   HtmlBlockCloseTfoot"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l384:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "HtmlBlockCloseTfoot"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_HtmlBlockOpenTfoot(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "HtmlBlockOpenTfoot"));
  if (!yymatchChar(G, '<')) goto l387;
  if (!yy_Spnl(G))  goto l387;

  {  int yypos388= G->pos, yythunkpos388= G->thunkpos;  if (!yymatchString(G, "tfoot")) goto l389;
  goto l388;
  l389:;	  G->pos= yypos388; G->thunkpos= yythunkpos388;  if (!yymatchString(G, "TFOOT")) goto l387;

  }
  l388:;	  if (!yy_Spnl(G))  goto l387;

  l390:;	
  {  int yypos391= G->pos, yythunkpos391= G->thunkpos;  if (!yy_HtmlAttribute(G))  goto l391;
  goto l390;
  l391:;	  G->pos= yypos391; G->thunkpos= yythunkpos391;
  }  if (!yymatchChar(G, '>')) goto l387;
  yyprintf((stderr, "  ok   HtmlBlockOpenTfoot"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l387:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "HtmlBlockOpenTfoot"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_HtmlBlockTd(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "HtmlBlockTd"));
  if (!yy_HtmlBlockOpenTd(G))  goto l392;

  l393:;	
  {  int yypos394= G->pos, yythunkpos394= G->thunkpos;
  {  int yypos395= G->pos, yythunkpos395= G->thunkpos;  if (!yy_HtmlBlockTd(G))  goto l396;
  goto l395;
  l396:;	  G->pos= yypos395; G->thunkpos= yythunkpos395;
  {  int yypos397= G->pos, yythunkpos397= G->thunkpos;  if (!yy_HtmlBlockCloseTd(G))  goto l397;
  goto l394;
  l397:;	  G->pos= yypos397; G->thunkpos= yythunkpos397;
  }  if (!yymatchDot(G)) goto l394;
  }
  l395:;	  goto l393;
  l394:;	  G->pos= yypos394; G->thunkpos= yythunkpos394;
  }  if (!yy_HtmlBlockCloseTd(G))  goto l392;
  yyprintf((stderr, "  ok   HtmlBlockTd"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l392:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "HtmlBlockTd"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_HtmlBlockCloseTd(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "HtmlBlockCloseTd"));
  if (!yymatchChar(G, '<')) goto l398;
  if (!yy_Spnl(G))  goto l398;
  if (!yymatchChar(G, '/')) goto l398;

  {  int yypos399= G->pos, yythunkpos399= G->thunkpos;  if (!yymatchString(G, "td")) goto l400;
  goto l399;
  l400:;	  G->pos= yypos399; G->thunkpos= yythunkpos399;  if (!yymatchString(G, "TD")) goto l398;

  }
  l399:;	  if (!yy_Spnl(G))  goto l398;
  if (!yymatchChar(G, '>')) goto l398;
  yyprintf((stderr, "  ok   HtmlBlockCloseTd"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l398:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "HtmlBlockCloseTd"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_HtmlBlockOpenTd(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "HtmlBlockOpenTd"));
  if (!yymatchChar(G, '<')) goto l401;
  if (!yy_Spnl(G))  goto l401;

  {  int yypos402= G->pos, yythunkpos402= G->thunkpos;  if (!yymatchString(G, "td")) goto l403;
  goto l402;
  l403:;	  G->pos= yypos402; G->thunkpos= yythunkpos402;  if (!yymatchString(G, "TD")) goto l401;

  }
  l402:;	  if (!yy_Spnl(G))  goto l401;

  l404:;	
  {  int yypos405= G->pos, yythunkpos405= G->thunkpos;  if (!yy_HtmlAttribute(G))  goto l405;
  goto l404;
  l405:;	  G->pos= yypos405; G->thunkpos= yythunkpos405;
  }  if (!yymatchChar(G, '>')) goto l401;
  yyprintf((stderr, "  ok   HtmlBlockOpenTd"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l401:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "HtmlBlockOpenTd"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_HtmlBlockTbody(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "HtmlBlockTbody"));
  if (!yy_HtmlBlockOpenTbody(G))  goto l406;

  l407:;	
  {  int yypos408= G->pos, yythunkpos408= G->thunkpos;
  {  int yypos409= G->pos, yythunkpos409= G->thunkpos;  if (!yy_HtmlBlockTbody(G))  goto l410;
  goto l409;
  l410:;	  G->pos= yypos409; G->thunkpos= yythunkpos409;
  {  int yypos411= G->pos, yythunkpos411= G->thunkpos;  if (!yy_HtmlBlockCloseTbody(G))  goto l411;
  goto l408;
  l411:;	  G->pos= yypos411; G->thunkpos= yythunkpos411;
  }  if (!yymatchDot(G)) goto l408;
  }
  l409:;	  goto l407;
  l408:;	  G->pos= yypos408; G->thunkpos= yythunkpos408;
  }  if (!yy_HtmlBlockCloseTbody(G))  goto l406;
  yyprintf((stderr, "  ok   HtmlBlockTbody"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l406:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "HtmlBlockTbody"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_HtmlBlockCloseTbody(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "HtmlBlockCloseTbody"));
  if (!yymatchChar(G, '<')) goto l412;
  if (!yy_Spnl(G))  goto l412;
  if (!yymatchChar(G, '/')) goto l412;

  {  int yypos413= G->pos, yythunkpos413= G->thunkpos;  if (!yymatchString(G, "tbody")) goto l414;
  goto l413;
  l414:;	  G->pos= yypos413; G->thunkpos= yythunkpos413;  if (!yymatchString(G, "TBODY")) goto l412;

  }
  l413:;	  if (!yy_Spnl(G))  goto l412;
  if (!yymatchChar(G, '>')) goto l412;
  yyprintf((stderr, "  ok   HtmlBlockCloseTbody"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l412:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "HtmlBlockCloseTbody"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_HtmlBlockOpenTbody(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "HtmlBlockOpenTbody"));
  if (!yymatchChar(G, '<')) goto l415;
  if (!yy_Spnl(G))  goto l415;

  {  int yypos416= G->pos, yythunkpos416= G->thunkpos;  if (!yymatchString(G, "tbody")) goto l417;
  goto l416;
  l417:;	  G->pos= yypos416; G->thunkpos= yythunkpos416;  if (!yymatchString(G, "TBODY")) goto l415;

  }
  l416:;	  if (!yy_Spnl(G))  goto l415;

  l418:;	
  {  int yypos419= G->pos, yythunkpos419= G->thunkpos;  if (!yy_HtmlAttribute(G))  goto l419;
  goto l418;
  l419:;	  G->pos= yypos419; G->thunkpos= yythunkpos419;
  }  if (!yymatchChar(G, '>')) goto l415;
  yyprintf((stderr, "  ok   HtmlBlockOpenTbody"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l415:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "HtmlBlockOpenTbody"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_HtmlBlockLi(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "HtmlBlockLi"));
  if (!yy_HtmlBlockOpenLi(G))  goto l420;

  l421:;	
  {  int yypos422= G->pos, yythunkpos422= G->thunkpos;
  {  int yypos423= G->pos, yythunkpos423= G->thunkpos;  if (!yy_HtmlBlockLi(G))  goto l424;
  goto l423;
  l424:;	  G->pos= yypos423; G->thunkpos= yythunkpos423;
  {  int yypos425= G->pos, yythunkpos425= G->thunkpos;  if (!yy_HtmlBlockCloseLi(G))  goto l425;
  goto l422;
  l425:;	  G->pos= yypos425; G->thunkpos= yythunkpos425;
  }  if (!yymatchDot(G)) goto l422;
  }
  l423:;	  goto l421;
  l422:;	  G->pos= yypos422; G->thunkpos= yythunkpos422;
  }  if (!yy_HtmlBlockCloseLi(G))  goto l420;
  yyprintf((stderr, "  ok   HtmlBlockLi"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l420:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "HtmlBlockLi"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_HtmlBlockCloseLi(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "HtmlBlockCloseLi"));
  if (!yymatchChar(G, '<')) goto l426;
  if (!yy_Spnl(G))  goto l426;
  if (!yymatchChar(G, '/')) goto l426;

  {  int yypos427= G->pos, yythunkpos427= G->thunkpos;  if (!yymatchString(G, "li")) goto l428;
  goto l427;
  l428:;	  G->pos= yypos427; G->thunkpos= yythunkpos427;  if (!yymatchString(G, "LI")) goto l426;

  }
  l427:;	  if (!yy_Spnl(G))  goto l426;
  if (!yymatchChar(G, '>')) goto l426;
  yyprintf((stderr, "  ok   HtmlBlockCloseLi"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l426:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "HtmlBlockCloseLi"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_HtmlBlockOpenLi(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "HtmlBlockOpenLi"));
  if (!yymatchChar(G, '<')) goto l429;
  if (!yy_Spnl(G))  goto l429;

  {  int yypos430= G->pos, yythunkpos430= G->thunkpos;  if (!yymatchString(G, "li")) goto l431;
  goto l430;
  l431:;	  G->pos= yypos430; G->thunkpos= yythunkpos430;  if (!yymatchString(G, "LI")) goto l429;

  }
  l430:;	  if (!yy_Spnl(G))  goto l429;

  l432:;	
  {  int yypos433= G->pos, yythunkpos433= G->thunkpos;  if (!yy_HtmlAttribute(G))  goto l433;
  goto l432;
  l433:;	  G->pos= yypos433; G->thunkpos= yythunkpos433;
  }  if (!yymatchChar(G, '>')) goto l429;
  yyprintf((stderr, "  ok   HtmlBlockOpenLi"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l429:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "HtmlBlockOpenLi"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_HtmlBlockFrameset(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "HtmlBlockFrameset"));
  if (!yy_HtmlBlockOpenFrameset(G))  goto l434;

  l435:;	
  {  int yypos436= G->pos, yythunkpos436= G->thunkpos;
  {  int yypos437= G->pos, yythunkpos437= G->thunkpos;  if (!yy_HtmlBlockFrameset(G))  goto l438;
  goto l437;
  l438:;	  G->pos= yypos437; G->thunkpos= yythunkpos437;
  {  int yypos439= G->pos, yythunkpos439= G->thunkpos;  if (!yy_HtmlBlockCloseFrameset(G))  goto l439;
  goto l436;
  l439:;	  G->pos= yypos439; G->thunkpos= yythunkpos439;
  }  if (!yymatchDot(G)) goto l436;
  }
  l437:;	  goto l435;
  l436:;	  G->pos= yypos436; G->thunkpos= yythunkpos436;
  }  if (!yy_HtmlBlockCloseFrameset(G))  goto l434;
  yyprintf((stderr, "  ok   HtmlBlockFrameset"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l434:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "HtmlBlockFrameset"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_HtmlBlockCloseFrameset(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "HtmlBlockCloseFrameset"));
  if (!yymatchChar(G, '<')) goto l440;
  if (!yy_Spnl(G))  goto l440;
  if (!yymatchChar(G, '/')) goto l440;

  {  int yypos441= G->pos, yythunkpos441= G->thunkpos;  if (!yymatchString(G, "frameset")) goto l442;
  goto l441;
  l442:;	  G->pos= yypos441; G->thunkpos= yythunkpos441;  if (!yymatchString(G, "FRAMESET")) goto l440;

  }
  l441:;	  if (!yy_Spnl(G))  goto l440;
  if (!yymatchChar(G, '>')) goto l440;
  yyprintf((stderr, "  ok   HtmlBlockCloseFrameset"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l440:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "HtmlBlockCloseFrameset"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_HtmlBlockOpenFrameset(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "HtmlBlockOpenFrameset"));
  if (!yymatchChar(G, '<')) goto l443;
  if (!yy_Spnl(G))  goto l443;

  {  int yypos444= G->pos, yythunkpos444= G->thunkpos;  if (!yymatchString(G, "frameset")) goto l445;
  goto l444;
  l445:;	  G->pos= yypos444; G->thunkpos= yythunkpos444;  if (!yymatchString(G, "FRAMESET")) goto l443;

  }
  l444:;	  if (!yy_Spnl(G))  goto l443;

  l446:;	
  {  int yypos447= G->pos, yythunkpos447= G->thunkpos;  if (!yy_HtmlAttribute(G))  goto l447;
  goto l446;
  l447:;	  G->pos= yypos447; G->thunkpos= yythunkpos447;
  }  if (!yymatchChar(G, '>')) goto l443;
  yyprintf((stderr, "  ok   HtmlBlockOpenFrameset"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l443:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "HtmlBlockOpenFrameset"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_HtmlBlockDt(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "HtmlBlockDt"));
  if (!yy_HtmlBlockOpenDt(G))  goto l448;

  l449:;	
  {  int yypos450= G->pos, yythunkpos450= G->thunkpos;
  {  int yypos451= G->pos, yythunkpos451= G->thunkpos;  if (!yy_HtmlBlockDt(G))  goto l452;
  goto l451;
  l452:;	  G->pos= yypos451; G->thunkpos= yythunkpos451;
  {  int yypos453= G->pos, yythunkpos453= G->thunkpos;  if (!yy_HtmlBlockCloseDt(G))  goto l453;
  goto l450;
  l453:;	  G->pos= yypos453; G->thunkpos= yythunkpos453;
  }  if (!yymatchDot(G)) goto l450;
  }
  l451:;	  goto l449;
  l450:;	  G->pos= yypos450; G->thunkpos= yythunkpos450;
  }  if (!yy_HtmlBlockCloseDt(G))  goto l448;
  yyprintf((stderr, "  ok   HtmlBlockDt"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l448:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "HtmlBlockDt"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_HtmlBlockCloseDt(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "HtmlBlockCloseDt"));
  if (!yymatchChar(G, '<')) goto l454;
  if (!yy_Spnl(G))  goto l454;
  if (!yymatchChar(G, '/')) goto l454;

  {  int yypos455= G->pos, yythunkpos455= G->thunkpos;  if (!yymatchString(G, "dt")) goto l456;
  goto l455;
  l456:;	  G->pos= yypos455; G->thunkpos= yythunkpos455;  if (!yymatchString(G, "DT")) goto l454;

  }
  l455:;	  if (!yy_Spnl(G))  goto l454;
  if (!yymatchChar(G, '>')) goto l454;
  yyprintf((stderr, "  ok   HtmlBlockCloseDt"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l454:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "HtmlBlockCloseDt"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_HtmlBlockOpenDt(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "HtmlBlockOpenDt"));
  if (!yymatchChar(G, '<')) goto l457;
  if (!yy_Spnl(G))  goto l457;

  {  int yypos458= G->pos, yythunkpos458= G->thunkpos;  if (!yymatchString(G, "dt")) goto l459;
  goto l458;
  l459:;	  G->pos= yypos458; G->thunkpos= yythunkpos458;  if (!yymatchString(G, "DT")) goto l457;

  }
  l458:;	  if (!yy_Spnl(G))  goto l457;

  l460:;	
  {  int yypos461= G->pos, yythunkpos461= G->thunkpos;  if (!yy_HtmlAttribute(G))  goto l461;
  goto l460;
  l461:;	  G->pos= yypos461; G->thunkpos= yythunkpos461;
  }  if (!yymatchChar(G, '>')) goto l457;
  yyprintf((stderr, "  ok   HtmlBlockOpenDt"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l457:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "HtmlBlockOpenDt"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_HtmlBlockDd(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "HtmlBlockDd"));
  if (!yy_HtmlBlockOpenDd(G))  goto l462;

  l463:;	
  {  int yypos464= G->pos, yythunkpos464= G->thunkpos;
  {  int yypos465= G->pos, yythunkpos465= G->thunkpos;  if (!yy_HtmlBlockDd(G))  goto l466;
  goto l465;
  l466:;	  G->pos= yypos465; G->thunkpos= yythunkpos465;
  {  int yypos467= G->pos, yythunkpos467= G->thunkpos;  if (!yy_HtmlBlockCloseDd(G))  goto l467;
  goto l464;
  l467:;	  G->pos= yypos467; G->thunkpos= yythunkpos467;
  }  if (!yymatchDot(G)) goto l464;
  }
  l465:;	  goto l463;
  l464:;	  G->pos= yypos464; G->thunkpos= yythunkpos464;
  }  if (!yy_HtmlBlockCloseDd(G))  goto l462;
  yyprintf((stderr, "  ok   HtmlBlockDd"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l462:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "HtmlBlockDd"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_HtmlBlockCloseDd(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "HtmlBlockCloseDd"));
  if (!yymatchChar(G, '<')) goto l468;
  if (!yy_Spnl(G))  goto l468;
  if (!yymatchChar(G, '/')) goto l468;

  {  int yypos469= G->pos, yythunkpos469= G->thunkpos;  if (!yymatchString(G, "dd")) goto l470;
  goto l469;
  l470:;	  G->pos= yypos469; G->thunkpos= yythunkpos469;  if (!yymatchString(G, "DD")) goto l468;

  }
  l469:;	  if (!yy_Spnl(G))  goto l468;
  if (!yymatchChar(G, '>')) goto l468;
  yyprintf((stderr, "  ok   HtmlBlockCloseDd"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l468:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "HtmlBlockCloseDd"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_HtmlBlockOpenDd(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "HtmlBlockOpenDd"));
  if (!yymatchChar(G, '<')) goto l471;
  if (!yy_Spnl(G))  goto l471;

  {  int yypos472= G->pos, yythunkpos472= G->thunkpos;  if (!yymatchString(G, "dd")) goto l473;
  goto l472;
  l473:;	  G->pos= yypos472; G->thunkpos= yythunkpos472;  if (!yymatchString(G, "DD")) goto l471;

  }
  l472:;	  if (!yy_Spnl(G))  goto l471;

  l474:;	
  {  int yypos475= G->pos, yythunkpos475= G->thunkpos;  if (!yy_HtmlAttribute(G))  goto l475;
  goto l474;
  l475:;	  G->pos= yypos475; G->thunkpos= yythunkpos475;
  }  if (!yymatchChar(G, '>')) goto l471;
  yyprintf((stderr, "  ok   HtmlBlockOpenDd"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l471:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "HtmlBlockOpenDd"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_HtmlBlockVideo(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "HtmlBlockVideo"));
  if (!yy_HtmlBlockOpenVideo(G))  goto l476;

  l477:;	
  {  int yypos478= G->pos, yythunkpos478= G->thunkpos;
  {  int yypos479= G->pos, yythunkpos479= G->thunkpos;  if (!yy_HtmlBlockVideo(G))  goto l480;
  goto l479;
  l480:;	  G->pos= yypos479; G->thunkpos= yythunkpos479;
  {  int yypos481= G->pos, yythunkpos481= G->thunkpos;  if (!yy_HtmlBlockCloseVideo(G))  goto l481;
  goto l478;
  l481:;	  G->pos= yypos481; G->thunkpos= yythunkpos481;
  }  if (!yymatchDot(G)) goto l478;
  }
  l479:;	  goto l477;
  l478:;	  G->pos= yypos478; G->thunkpos= yythunkpos478;
  }  if (!yy_HtmlBlockCloseVideo(G))  goto l476;
  yyprintf((stderr, "  ok   HtmlBlockVideo"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l476:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "HtmlBlockVideo"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_HtmlBlockCloseVideo(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "HtmlBlockCloseVideo"));
  if (!yymatchChar(G, '<')) goto l482;
  if (!yy_Spnl(G))  goto l482;
  if (!yymatchChar(G, '/')) goto l482;

  {  int yypos483= G->pos, yythunkpos483= G->thunkpos;  if (!yymatchString(G, "video")) goto l484;
  goto l483;
  l484:;	  G->pos= yypos483; G->thunkpos= yythunkpos483;  if (!yymatchString(G, "VIDEO")) goto l482;

  }
  l483:;	  if (!yy_Spnl(G))  goto l482;
  if (!yymatchChar(G, '>')) goto l482;
  yyprintf((stderr, "  ok   HtmlBlockCloseVideo"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l482:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "HtmlBlockCloseVideo"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_HtmlBlockOpenVideo(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "HtmlBlockOpenVideo"));
  if (!yymatchChar(G, '<')) goto l485;
  if (!yy_Spnl(G))  goto l485;

  {  int yypos486= G->pos, yythunkpos486= G->thunkpos;  if (!yymatchString(G, "video")) goto l487;
  goto l486;
  l487:;	  G->pos= yypos486; G->thunkpos= yythunkpos486;  if (!yymatchString(G, "VIDEO")) goto l485;

  }
  l486:;	  if (!yy_Spnl(G))  goto l485;

  l488:;	
  {  int yypos489= G->pos, yythunkpos489= G->thunkpos;  if (!yy_HtmlAttribute(G))  goto l489;
  goto l488;
  l489:;	  G->pos= yypos489; G->thunkpos= yythunkpos489;
  }  if (!yymatchChar(G, '>')) goto l485;
  yyprintf((stderr, "  ok   HtmlBlockOpenVideo"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l485:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "HtmlBlockOpenVideo"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_HtmlBlockUl(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "HtmlBlockUl"));
  if (!yy_HtmlBlockOpenUl(G))  goto l490;

  l491:;	
  {  int yypos492= G->pos, yythunkpos492= G->thunkpos;
  {  int yypos493= G->pos, yythunkpos493= G->thunkpos;  if (!yy_HtmlBlockUl(G))  goto l494;
  goto l493;
  l494:;	  G->pos= yypos493; G->thunkpos= yythunkpos493;
  {  int yypos495= G->pos, yythunkpos495= G->thunkpos;  if (!yy_HtmlBlockCloseUl(G))  goto l495;
  goto l492;
  l495:;	  G->pos= yypos495; G->thunkpos= yythunkpos495;
  }  if (!yymatchDot(G)) goto l492;
  }
  l493:;	  goto l491;
  l492:;	  G->pos= yypos492; G->thunkpos= yythunkpos492;
  }  if (!yy_HtmlBlockCloseUl(G))  goto l490;
  yyprintf((stderr, "  ok   HtmlBlockUl"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l490:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "HtmlBlockUl"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_HtmlBlockCloseUl(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "HtmlBlockCloseUl"));
  if (!yymatchChar(G, '<')) goto l496;
  if (!yy_Spnl(G))  goto l496;
  if (!yymatchChar(G, '/')) goto l496;

  {  int yypos497= G->pos, yythunkpos497= G->thunkpos;  if (!yymatchString(G, "ul")) goto l498;
  goto l497;
  l498:;	  G->pos= yypos497; G->thunkpos= yythunkpos497;  if (!yymatchString(G, "UL")) goto l496;

  }
  l497:;	  if (!yy_Spnl(G))  goto l496;
  if (!yymatchChar(G, '>')) goto l496;
  yyprintf((stderr, "  ok   HtmlBlockCloseUl"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l496:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "HtmlBlockCloseUl"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_HtmlBlockOpenUl(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "HtmlBlockOpenUl"));
  if (!yymatchChar(G, '<')) goto l499;
  if (!yy_Spnl(G))  goto l499;

  {  int yypos500= G->pos, yythunkpos500= G->thunkpos;  if (!yymatchString(G, "ul")) goto l501;
  goto l500;
  l501:;	  G->pos= yypos500; G->thunkpos= yythunkpos500;  if (!yymatchString(G, "UL")) goto l499;

  }
  l500:;	  if (!yy_Spnl(G))  goto l499;

  l502:;	
  {  int yypos503= G->pos, yythunkpos503= G->thunkpos;  if (!yy_HtmlAttribute(G))  goto l503;
  goto l502;
  l503:;	  G->pos= yypos503; G->thunkpos= yythunkpos503;
  }  if (!yymatchChar(G, '>')) goto l499;
  yyprintf((stderr, "  ok   HtmlBlockOpenUl"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l499:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "HtmlBlockOpenUl"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_HtmlBlockTable(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "HtmlBlockTable"));
  if (!yy_HtmlBlockOpenTable(G))  goto l504;

  l505:;	
  {  int yypos506= G->pos, yythunkpos506= G->thunkpos;
  {  int yypos507= G->pos, yythunkpos507= G->thunkpos;  if (!yy_HtmlBlockTable(G))  goto l508;
  goto l507;
  l508:;	  G->pos= yypos507; G->thunkpos= yythunkpos507;
  {  int yypos509= G->pos, yythunkpos509= G->thunkpos;  if (!yy_HtmlBlockCloseTable(G))  goto l509;
  goto l506;
  l509:;	  G->pos= yypos509; G->thunkpos= yythunkpos509;
  }  if (!yymatchDot(G)) goto l506;
  }
  l507:;	  goto l505;
  l506:;	  G->pos= yypos506; G->thunkpos= yythunkpos506;
  }  if (!yy_HtmlBlockCloseTable(G))  goto l504;
  yyprintf((stderr, "  ok   HtmlBlockTable"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l504:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "HtmlBlockTable"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_HtmlBlockCloseTable(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "HtmlBlockCloseTable"));
  if (!yymatchChar(G, '<')) goto l510;
  if (!yy_Spnl(G))  goto l510;
  if (!yymatchChar(G, '/')) goto l510;

  {  int yypos511= G->pos, yythunkpos511= G->thunkpos;  if (!yymatchString(G, "table")) goto l512;
  goto l511;
  l512:;	  G->pos= yypos511; G->thunkpos= yythunkpos511;  if (!yymatchString(G, "TABLE")) goto l510;

  }
  l511:;	  if (!yy_Spnl(G))  goto l510;
  if (!yymatchChar(G, '>')) goto l510;
  yyprintf((stderr, "  ok   HtmlBlockCloseTable"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l510:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "HtmlBlockCloseTable"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_HtmlBlockOpenTable(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "HtmlBlockOpenTable"));
  if (!yymatchChar(G, '<')) goto l513;
  if (!yy_Spnl(G))  goto l513;

  {  int yypos514= G->pos, yythunkpos514= G->thunkpos;  if (!yymatchString(G, "table")) goto l515;
  goto l514;
  l515:;	  G->pos= yypos514; G->thunkpos= yythunkpos514;  if (!yymatchString(G, "TABLE")) goto l513;

  }
  l514:;	  if (!yy_Spnl(G))  goto l513;

  l516:;	
  {  int yypos517= G->pos, yythunkpos517= G->thunkpos;  if (!yy_HtmlAttribute(G))  goto l517;
  goto l516;
  l517:;	  G->pos= yypos517; G->thunkpos= yythunkpos517;
  }  if (!yymatchChar(G, '>')) goto l513;
  yyprintf((stderr, "  ok   HtmlBlockOpenTable"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l513:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "HtmlBlockOpenTable"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_HtmlBlockSection(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "HtmlBlockSection"));
  if (!yy_HtmlBlockOpenSection(G))  goto l518;

  l519:;	
  {  int yypos520= G->pos, yythunkpos520= G->thunkpos;
  {  int yypos521= G->pos, yythunkpos521= G->thunkpos;  if (!yy_HtmlBlockSection(G))  goto l522;
  goto l521;
  l522:;	  G->pos= yypos521; G->thunkpos= yythunkpos521;
  {  int yypos523= G->pos, yythunkpos523= G->thunkpos;  if (!yy_HtmlBlockCloseSection(G))  goto l523;
  goto l520;
  l523:;	  G->pos= yypos523; G->thunkpos= yythunkpos523;
  }  if (!yymatchDot(G)) goto l520;
  }
  l521:;	  goto l519;
  l520:;	  G->pos= yypos520; G->thunkpos= yythunkpos520;
  }  if (!yy_HtmlBlockCloseSection(G))  goto l518;
  yyprintf((stderr, "  ok   HtmlBlockSection"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l518:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "HtmlBlockSection"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_HtmlBlockCloseSection(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "HtmlBlockCloseSection"));
  if (!yymatchChar(G, '<')) goto l524;
  if (!yy_Spnl(G))  goto l524;
  if (!yymatchChar(G, '/')) goto l524;

  {  int yypos525= G->pos, yythunkpos525= G->thunkpos;  if (!yymatchString(G, "section")) goto l526;
  goto l525;
  l526:;	  G->pos= yypos525; G->thunkpos= yythunkpos525;  if (!yymatchString(G, "SECTION")) goto l524;

  }
  l525:;	  if (!yy_Spnl(G))  goto l524;
  if (!yymatchChar(G, '>')) goto l524;
  yyprintf((stderr, "  ok   HtmlBlockCloseSection"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l524:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "HtmlBlockCloseSection"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_HtmlBlockOpenSection(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "HtmlBlockOpenSection"));
  if (!yymatchChar(G, '<')) goto l527;
  if (!yy_Spnl(G))  goto l527;

  {  int yypos528= G->pos, yythunkpos528= G->thunkpos;  if (!yymatchString(G, "section")) goto l529;
  goto l528;
  l529:;	  G->pos= yypos528; G->thunkpos= yythunkpos528;  if (!yymatchString(G, "SECTION")) goto l527;

  }
  l528:;	  if (!yy_Spnl(G))  goto l527;

  l530:;	
  {  int yypos531= G->pos, yythunkpos531= G->thunkpos;  if (!yy_HtmlAttribute(G))  goto l531;
  goto l530;
  l531:;	  G->pos= yypos531; G->thunkpos= yythunkpos531;
  }  if (!yymatchChar(G, '>')) goto l527;
  yyprintf((stderr, "  ok   HtmlBlockOpenSection"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l527:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "HtmlBlockOpenSection"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_HtmlBlockProgress(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "HtmlBlockProgress"));
  if (!yy_HtmlBlockOpenProgress(G))  goto l532;

  l533:;	
  {  int yypos534= G->pos, yythunkpos534= G->thunkpos;
  {  int yypos535= G->pos, yythunkpos535= G->thunkpos;  if (!yy_HtmlBlockProgress(G))  goto l536;
  goto l535;
  l536:;	  G->pos= yypos535; G->thunkpos= yythunkpos535;
  {  int yypos537= G->pos, yythunkpos537= G->thunkpos;  if (!yy_HtmlBlockCloseProgress(G))  goto l537;
  goto l534;
  l537:;	  G->pos= yypos537; G->thunkpos= yythunkpos537;
  }  if (!yymatchDot(G)) goto l534;
  }
  l535:;	  goto l533;
  l534:;	  G->pos= yypos534; G->thunkpos= yythunkpos534;
  }  if (!yy_HtmlBlockCloseProgress(G))  goto l532;
  yyprintf((stderr, "  ok   HtmlBlockProgress"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l532:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "HtmlBlockProgress"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_HtmlBlockCloseProgress(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "HtmlBlockCloseProgress"));
  if (!yymatchChar(G, '<')) goto l538;
  if (!yy_Spnl(G))  goto l538;
  if (!yymatchChar(G, '/')) goto l538;

  {  int yypos539= G->pos, yythunkpos539= G->thunkpos;  if (!yymatchString(G, "progress")) goto l540;
  goto l539;
  l540:;	  G->pos= yypos539; G->thunkpos= yythunkpos539;  if (!yymatchString(G, "PROGRESS")) goto l538;

  }
  l539:;	  if (!yy_Spnl(G))  goto l538;
  if (!yymatchChar(G, '>')) goto l538;
  yyprintf((stderr, "  ok   HtmlBlockCloseProgress"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l538:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "HtmlBlockCloseProgress"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_HtmlBlockOpenProgress(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "HtmlBlockOpenProgress"));
  if (!yymatchChar(G, '<')) goto l541;
  if (!yy_Spnl(G))  goto l541;

  {  int yypos542= G->pos, yythunkpos542= G->thunkpos;  if (!yymatchString(G, "progress")) goto l543;
  goto l542;
  l543:;	  G->pos= yypos542; G->thunkpos= yythunkpos542;  if (!yymatchString(G, "PROGRESS")) goto l541;

  }
  l542:;	  if (!yy_Spnl(G))  goto l541;

  l544:;	
  {  int yypos545= G->pos, yythunkpos545= G->thunkpos;  if (!yy_HtmlAttribute(G))  goto l545;
  goto l544;
  l545:;	  G->pos= yypos545; G->thunkpos= yythunkpos545;
  }  if (!yymatchChar(G, '>')) goto l541;
  yyprintf((stderr, "  ok   HtmlBlockOpenProgress"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l541:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "HtmlBlockOpenProgress"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_HtmlBlockPre(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "HtmlBlockPre"));
  if (!yy_HtmlBlockOpenPre(G))  goto l546;

  l547:;	
  {  int yypos548= G->pos, yythunkpos548= G->thunkpos;
  {  int yypos549= G->pos, yythunkpos549= G->thunkpos;  if (!yy_HtmlBlockPre(G))  goto l550;
  goto l549;
  l550:;	  G->pos= yypos549; G->thunkpos= yythunkpos549;
  {  int yypos551= G->pos, yythunkpos551= G->thunkpos;  if (!yy_HtmlBlockClosePre(G))  goto l551;
  goto l548;
  l551:;	  G->pos= yypos551; G->thunkpos= yythunkpos551;
  }  if (!yymatchDot(G)) goto l548;
  }
  l549:;	  goto l547;
  l548:;	  G->pos= yypos548; G->thunkpos= yythunkpos548;
  }  if (!yy_HtmlBlockClosePre(G))  goto l546;
  yyprintf((stderr, "  ok   HtmlBlockPre"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l546:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "HtmlBlockPre"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_HtmlBlockClosePre(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "HtmlBlockClosePre"));
  if (!yymatchChar(G, '<')) goto l552;
  if (!yy_Spnl(G))  goto l552;
  if (!yymatchChar(G, '/')) goto l552;

  {  int yypos553= G->pos, yythunkpos553= G->thunkpos;  if (!yymatchString(G, "pre")) goto l554;
  goto l553;
  l554:;	  G->pos= yypos553; G->thunkpos= yythunkpos553;  if (!yymatchString(G, "PRE")) goto l552;

  }
  l553:;	  if (!yy_Spnl(G))  goto l552;
  if (!yymatchChar(G, '>')) goto l552;
  yyprintf((stderr, "  ok   HtmlBlockClosePre"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l552:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "HtmlBlockClosePre"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_HtmlBlockOpenPre(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "HtmlBlockOpenPre"));
  if (!yymatchChar(G, '<')) goto l555;
  if (!yy_Spnl(G))  goto l555;

  {  int yypos556= G->pos, yythunkpos556= G->thunkpos;  if (!yymatchString(G, "pre")) goto l557;
  goto l556;
  l557:;	  G->pos= yypos556; G->thunkpos= yythunkpos556;  if (!yymatchString(G, "PRE")) goto l555;

  }
  l556:;	  if (!yy_Spnl(G))  goto l555;

  l558:;	
  {  int yypos559= G->pos, yythunkpos559= G->thunkpos;  if (!yy_HtmlAttribute(G))  goto l559;
  goto l558;
  l559:;	  G->pos= yypos559; G->thunkpos= yythunkpos559;
  }  if (!yymatchChar(G, '>')) goto l555;
  yyprintf((stderr, "  ok   HtmlBlockOpenPre"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l555:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "HtmlBlockOpenPre"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_HtmlBlockP(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "HtmlBlockP"));
  if (!yy_HtmlBlockOpenP(G))  goto l560;

  l561:;	
  {  int yypos562= G->pos, yythunkpos562= G->thunkpos;
  {  int yypos563= G->pos, yythunkpos563= G->thunkpos;  if (!yy_HtmlBlockP(G))  goto l564;
  goto l563;
  l564:;	  G->pos= yypos563; G->thunkpos= yythunkpos563;
  {  int yypos565= G->pos, yythunkpos565= G->thunkpos;  if (!yy_HtmlBlockCloseP(G))  goto l565;
  goto l562;
  l565:;	  G->pos= yypos565; G->thunkpos= yythunkpos565;
  }  if (!yymatchDot(G)) goto l562;
  }
  l563:;	  goto l561;
  l562:;	  G->pos= yypos562; G->thunkpos= yythunkpos562;
  }  if (!yy_HtmlBlockCloseP(G))  goto l560;
  yyprintf((stderr, "  ok   HtmlBlockP"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l560:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "HtmlBlockP"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_HtmlBlockCloseP(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "HtmlBlockCloseP"));
  if (!yymatchChar(G, '<')) goto l566;
  if (!yy_Spnl(G))  goto l566;
  if (!yymatchChar(G, '/')) goto l566;

  {  int yypos567= G->pos, yythunkpos567= G->thunkpos;  if (!yymatchChar(G, 'p')) goto l568;
  goto l567;
  l568:;	  G->pos= yypos567; G->thunkpos= yythunkpos567;  if (!yymatchChar(G, 'P')) goto l566;

  }
  l567:;	  if (!yy_Spnl(G))  goto l566;
  if (!yymatchChar(G, '>')) goto l566;
  yyprintf((stderr, "  ok   HtmlBlockCloseP"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l566:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "HtmlBlockCloseP"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_HtmlBlockOpenP(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "HtmlBlockOpenP"));
  if (!yymatchChar(G, '<')) goto l569;
  if (!yy_Spnl(G))  goto l569;

  {  int yypos570= G->pos, yythunkpos570= G->thunkpos;  if (!yymatchChar(G, 'p')) goto l571;
  goto l570;
  l571:;	  G->pos= yypos570; G->thunkpos= yythunkpos570;  if (!yymatchChar(G, 'P')) goto l569;

  }
  l570:;	  if (!yy_Spnl(G))  goto l569;

  l572:;	
  {  int yypos573= G->pos, yythunkpos573= G->thunkpos;  if (!yy_HtmlAttribute(G))  goto l573;
  goto l572;
  l573:;	  G->pos= yypos573; G->thunkpos= yythunkpos573;
  }  if (!yymatchChar(G, '>')) goto l569;
  yyprintf((stderr, "  ok   HtmlBlockOpenP"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l569:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "HtmlBlockOpenP"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_HtmlBlockOl(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "HtmlBlockOl"));
  if (!yy_HtmlBlockOpenOl(G))  goto l574;

  l575:;	
  {  int yypos576= G->pos, yythunkpos576= G->thunkpos;
  {  int yypos577= G->pos, yythunkpos577= G->thunkpos;  if (!yy_HtmlBlockOl(G))  goto l578;
  goto l577;
  l578:;	  G->pos= yypos577; G->thunkpos= yythunkpos577;
  {  int yypos579= G->pos, yythunkpos579= G->thunkpos;  if (!yy_HtmlBlockCloseOl(G))  goto l579;
  goto l576;
  l579:;	  G->pos= yypos579; G->thunkpos= yythunkpos579;
  }  if (!yymatchDot(G)) goto l576;
  }
  l577:;	  goto l575;
  l576:;	  G->pos= yypos576; G->thunkpos= yythunkpos576;
  }  if (!yy_HtmlBlockCloseOl(G))  goto l574;
  yyprintf((stderr, "  ok   HtmlBlockOl"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l574:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "HtmlBlockOl"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_HtmlBlockCloseOl(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "HtmlBlockCloseOl"));
  if (!yymatchChar(G, '<')) goto l580;
  if (!yy_Spnl(G))  goto l580;
  if (!yymatchChar(G, '/')) goto l580;

  {  int yypos581= G->pos, yythunkpos581= G->thunkpos;  if (!yymatchString(G, "ol")) goto l582;
  goto l581;
  l582:;	  G->pos= yypos581; G->thunkpos= yythunkpos581;  if (!yymatchString(G, "OL")) goto l580;

  }
  l581:;	  if (!yy_Spnl(G))  goto l580;
  if (!yymatchChar(G, '>')) goto l580;
  yyprintf((stderr, "  ok   HtmlBlockCloseOl"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l580:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "HtmlBlockCloseOl"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_HtmlBlockOpenOl(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "HtmlBlockOpenOl"));
  if (!yymatchChar(G, '<')) goto l583;
  if (!yy_Spnl(G))  goto l583;

  {  int yypos584= G->pos, yythunkpos584= G->thunkpos;  if (!yymatchString(G, "ol")) goto l585;
  goto l584;
  l585:;	  G->pos= yypos584; G->thunkpos= yythunkpos584;  if (!yymatchString(G, "OL")) goto l583;

  }
  l584:;	  if (!yy_Spnl(G))  goto l583;

  l586:;	
  {  int yypos587= G->pos, yythunkpos587= G->thunkpos;  if (!yy_HtmlAttribute(G))  goto l587;
  goto l586;
  l587:;	  G->pos= yypos587; G->thunkpos= yythunkpos587;
  }  if (!yymatchChar(G, '>')) goto l583;
  yyprintf((stderr, "  ok   HtmlBlockOpenOl"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l583:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "HtmlBlockOpenOl"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_HtmlBlockNoscript(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "HtmlBlockNoscript"));
  if (!yy_HtmlBlockOpenNoscript(G))  goto l588;

  l589:;	
  {  int yypos590= G->pos, yythunkpos590= G->thunkpos;
  {  int yypos591= G->pos, yythunkpos591= G->thunkpos;  if (!yy_HtmlBlockNoscript(G))  goto l592;
  goto l591;
  l592:;	  G->pos= yypos591; G->thunkpos= yythunkpos591;
  {  int yypos593= G->pos, yythunkpos593= G->thunkpos;  if (!yy_HtmlBlockCloseNoscript(G))  goto l593;
  goto l590;
  l593:;	  G->pos= yypos593; G->thunkpos= yythunkpos593;
  }  if (!yymatchDot(G)) goto l590;
  }
  l591:;	  goto l589;
  l590:;	  G->pos= yypos590; G->thunkpos= yythunkpos590;
  }  if (!yy_HtmlBlockCloseNoscript(G))  goto l588;
  yyprintf((stderr, "  ok   HtmlBlockNoscript"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l588:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "HtmlBlockNoscript"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_HtmlBlockCloseNoscript(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "HtmlBlockCloseNoscript"));
  if (!yymatchChar(G, '<')) goto l594;
  if (!yy_Spnl(G))  goto l594;
  if (!yymatchChar(G, '/')) goto l594;

  {  int yypos595= G->pos, yythunkpos595= G->thunkpos;  if (!yymatchString(G, "noscript")) goto l596;
  goto l595;
  l596:;	  G->pos= yypos595; G->thunkpos= yythunkpos595;  if (!yymatchString(G, "NOSCRIPT")) goto l594;

  }
  l595:;	  if (!yy_Spnl(G))  goto l594;
  if (!yymatchChar(G, '>')) goto l594;
  yyprintf((stderr, "  ok   HtmlBlockCloseNoscript"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l594:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "HtmlBlockCloseNoscript"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_HtmlBlockOpenNoscript(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "HtmlBlockOpenNoscript"));
  if (!yymatchChar(G, '<')) goto l597;
  if (!yy_Spnl(G))  goto l597;

  {  int yypos598= G->pos, yythunkpos598= G->thunkpos;  if (!yymatchString(G, "noscript")) goto l599;
  goto l598;
  l599:;	  G->pos= yypos598; G->thunkpos= yythunkpos598;  if (!yymatchString(G, "NOSCRIPT")) goto l597;

  }
  l598:;	  if (!yy_Spnl(G))  goto l597;

  l600:;	
  {  int yypos601= G->pos, yythunkpos601= G->thunkpos;  if (!yy_HtmlAttribute(G))  goto l601;
  goto l600;
  l601:;	  G->pos= yypos601; G->thunkpos= yythunkpos601;
  }  if (!yymatchChar(G, '>')) goto l597;
  yyprintf((stderr, "  ok   HtmlBlockOpenNoscript"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l597:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "HtmlBlockOpenNoscript"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_HtmlBlockNoframes(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "HtmlBlockNoframes"));
  if (!yy_HtmlBlockOpenNoframes(G))  goto l602;

  l603:;	
  {  int yypos604= G->pos, yythunkpos604= G->thunkpos;
  {  int yypos605= G->pos, yythunkpos605= G->thunkpos;  if (!yy_HtmlBlockNoframes(G))  goto l606;
  goto l605;
  l606:;	  G->pos= yypos605; G->thunkpos= yythunkpos605;
  {  int yypos607= G->pos, yythunkpos607= G->thunkpos;  if (!yy_HtmlBlockCloseNoframes(G))  goto l607;
  goto l604;
  l607:;	  G->pos= yypos607; G->thunkpos= yythunkpos607;
  }  if (!yymatchDot(G)) goto l604;
  }
  l605:;	  goto l603;
  l604:;	  G->pos= yypos604; G->thunkpos= yythunkpos604;
  }  if (!yy_HtmlBlockCloseNoframes(G))  goto l602;
  yyprintf((stderr, "  ok   HtmlBlockNoframes"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l602:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "HtmlBlockNoframes"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_HtmlBlockCloseNoframes(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "HtmlBlockCloseNoframes"));
  if (!yymatchChar(G, '<')) goto l608;
  if (!yy_Spnl(G))  goto l608;
  if (!yymatchChar(G, '/')) goto l608;

  {  int yypos609= G->pos, yythunkpos609= G->thunkpos;  if (!yymatchString(G, "noframes")) goto l610;
  goto l609;
  l610:;	  G->pos= yypos609; G->thunkpos= yythunkpos609;  if (!yymatchString(G, "NOFRAMES")) goto l608;

  }
  l609:;	  if (!yy_Spnl(G))  goto l608;
  if (!yymatchChar(G, '>')) goto l608;
  yyprintf((stderr, "  ok   HtmlBlockCloseNoframes"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l608:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "HtmlBlockCloseNoframes"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_HtmlBlockOpenNoframes(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "HtmlBlockOpenNoframes"));
  if (!yymatchChar(G, '<')) goto l611;
  if (!yy_Spnl(G))  goto l611;

  {  int yypos612= G->pos, yythunkpos612= G->thunkpos;  if (!yymatchString(G, "noframes")) goto l613;
  goto l612;
  l613:;	  G->pos= yypos612; G->thunkpos= yythunkpos612;  if (!yymatchString(G, "NOFRAMES")) goto l611;

  }
  l612:;	  if (!yy_Spnl(G))  goto l611;

  l614:;	
  {  int yypos615= G->pos, yythunkpos615= G->thunkpos;  if (!yy_HtmlAttribute(G))  goto l615;
  goto l614;
  l615:;	  G->pos= yypos615; G->thunkpos= yythunkpos615;
  }  if (!yymatchChar(G, '>')) goto l611;
  yyprintf((stderr, "  ok   HtmlBlockOpenNoframes"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l611:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "HtmlBlockOpenNoframes"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_HtmlBlockMenu(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "HtmlBlockMenu"));
  if (!yy_HtmlBlockOpenMenu(G))  goto l616;

  l617:;	
  {  int yypos618= G->pos, yythunkpos618= G->thunkpos;
  {  int yypos619= G->pos, yythunkpos619= G->thunkpos;  if (!yy_HtmlBlockMenu(G))  goto l620;
  goto l619;
  l620:;	  G->pos= yypos619; G->thunkpos= yythunkpos619;
  {  int yypos621= G->pos, yythunkpos621= G->thunkpos;  if (!yy_HtmlBlockCloseMenu(G))  goto l621;
  goto l618;
  l621:;	  G->pos= yypos621; G->thunkpos= yythunkpos621;
  }  if (!yymatchDot(G)) goto l618;
  }
  l619:;	  goto l617;
  l618:;	  G->pos= yypos618; G->thunkpos= yythunkpos618;
  }  if (!yy_HtmlBlockCloseMenu(G))  goto l616;
  yyprintf((stderr, "  ok   HtmlBlockMenu"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l616:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "HtmlBlockMenu"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_HtmlBlockCloseMenu(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "HtmlBlockCloseMenu"));
  if (!yymatchChar(G, '<')) goto l622;
  if (!yy_Spnl(G))  goto l622;
  if (!yymatchChar(G, '/')) goto l622;

  {  int yypos623= G->pos, yythunkpos623= G->thunkpos;  if (!yymatchString(G, "menu")) goto l624;
  goto l623;
  l624:;	  G->pos= yypos623; G->thunkpos= yythunkpos623;  if (!yymatchString(G, "MENU")) goto l622;

  }
  l623:;	  if (!yy_Spnl(G))  goto l622;
  if (!yymatchChar(G, '>')) goto l622;
  yyprintf((stderr, "  ok   HtmlBlockCloseMenu"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l622:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "HtmlBlockCloseMenu"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_HtmlBlockOpenMenu(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "HtmlBlockOpenMenu"));
  if (!yymatchChar(G, '<')) goto l625;
  if (!yy_Spnl(G))  goto l625;

  {  int yypos626= G->pos, yythunkpos626= G->thunkpos;  if (!yymatchString(G, "menu")) goto l627;
  goto l626;
  l627:;	  G->pos= yypos626; G->thunkpos= yythunkpos626;  if (!yymatchString(G, "MENU")) goto l625;

  }
  l626:;	  if (!yy_Spnl(G))  goto l625;

  l628:;	
  {  int yypos629= G->pos, yythunkpos629= G->thunkpos;  if (!yy_HtmlAttribute(G))  goto l629;
  goto l628;
  l629:;	  G->pos= yypos629; G->thunkpos= yythunkpos629;
  }  if (!yymatchChar(G, '>')) goto l625;
  yyprintf((stderr, "  ok   HtmlBlockOpenMenu"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l625:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "HtmlBlockOpenMenu"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_HtmlBlockH6(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "HtmlBlockH6"));
  if (!yy_HtmlBlockOpenH6(G))  goto l630;

  l631:;	
  {  int yypos632= G->pos, yythunkpos632= G->thunkpos;
  {  int yypos633= G->pos, yythunkpos633= G->thunkpos;  if (!yy_HtmlBlockH6(G))  goto l634;
  goto l633;
  l634:;	  G->pos= yypos633; G->thunkpos= yythunkpos633;
  {  int yypos635= G->pos, yythunkpos635= G->thunkpos;  if (!yy_HtmlBlockCloseH6(G))  goto l635;
  goto l632;
  l635:;	  G->pos= yypos635; G->thunkpos= yythunkpos635;
  }  if (!yymatchDot(G)) goto l632;
  }
  l633:;	  goto l631;
  l632:;	  G->pos= yypos632; G->thunkpos= yythunkpos632;
  }  if (!yy_HtmlBlockCloseH6(G))  goto l630;
  yyprintf((stderr, "  ok   HtmlBlockH6"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l630:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "HtmlBlockH6"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_HtmlBlockCloseH6(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "HtmlBlockCloseH6"));
  if (!yymatchChar(G, '<')) goto l636;
  if (!yy_Spnl(G))  goto l636;
  if (!yymatchChar(G, '/')) goto l636;

  {  int yypos637= G->pos, yythunkpos637= G->thunkpos;  if (!yymatchString(G, "h6")) goto l638;
  goto l637;
  l638:;	  G->pos= yypos637; G->thunkpos= yythunkpos637;  if (!yymatchString(G, "H6")) goto l636;

  }
  l637:;	  if (!yy_Spnl(G))  goto l636;
  if (!yymatchChar(G, '>')) goto l636;
  yyprintf((stderr, "  ok   HtmlBlockCloseH6"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l636:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "HtmlBlockCloseH6"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_HtmlBlockOpenH6(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "HtmlBlockOpenH6"));
  if (!yymatchChar(G, '<')) goto l639;
  if (!yy_Spnl(G))  goto l639;

  {  int yypos640= G->pos, yythunkpos640= G->thunkpos;  if (!yymatchString(G, "h6")) goto l641;
  goto l640;
  l641:;	  G->pos= yypos640; G->thunkpos= yythunkpos640;  if (!yymatchString(G, "H6")) goto l639;

  }
  l640:;	  if (!yy_Spnl(G))  goto l639;

  l642:;	
  {  int yypos643= G->pos, yythunkpos643= G->thunkpos;  if (!yy_HtmlAttribute(G))  goto l643;
  goto l642;
  l643:;	  G->pos= yypos643; G->thunkpos= yythunkpos643;
  }  if (!yymatchChar(G, '>')) goto l639;
  yyprintf((stderr, "  ok   HtmlBlockOpenH6"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l639:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "HtmlBlockOpenH6"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_HtmlBlockH5(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "HtmlBlockH5"));
  if (!yy_HtmlBlockOpenH5(G))  goto l644;

  l645:;	
  {  int yypos646= G->pos, yythunkpos646= G->thunkpos;
  {  int yypos647= G->pos, yythunkpos647= G->thunkpos;  if (!yy_HtmlBlockH5(G))  goto l648;
  goto l647;
  l648:;	  G->pos= yypos647; G->thunkpos= yythunkpos647;
  {  int yypos649= G->pos, yythunkpos649= G->thunkpos;  if (!yy_HtmlBlockCloseH5(G))  goto l649;
  goto l646;
  l649:;	  G->pos= yypos649; G->thunkpos= yythunkpos649;
  }  if (!yymatchDot(G)) goto l646;
  }
  l647:;	  goto l645;
  l646:;	  G->pos= yypos646; G->thunkpos= yythunkpos646;
  }  if (!yy_HtmlBlockCloseH5(G))  goto l644;
  yyprintf((stderr, "  ok   HtmlBlockH5"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l644:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "HtmlBlockH5"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_HtmlBlockCloseH5(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "HtmlBlockCloseH5"));
  if (!yymatchChar(G, '<')) goto l650;
  if (!yy_Spnl(G))  goto l650;
  if (!yymatchChar(G, '/')) goto l650;

  {  int yypos651= G->pos, yythunkpos651= G->thunkpos;  if (!yymatchString(G, "h5")) goto l652;
  goto l651;
  l652:;	  G->pos= yypos651; G->thunkpos= yythunkpos651;  if (!yymatchString(G, "H5")) goto l650;

  }
  l651:;	  if (!yy_Spnl(G))  goto l650;
  if (!yymatchChar(G, '>')) goto l650;
  yyprintf((stderr, "  ok   HtmlBlockCloseH5"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l650:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "HtmlBlockCloseH5"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_HtmlBlockOpenH5(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "HtmlBlockOpenH5"));
  if (!yymatchChar(G, '<')) goto l653;
  if (!yy_Spnl(G))  goto l653;

  {  int yypos654= G->pos, yythunkpos654= G->thunkpos;  if (!yymatchString(G, "h5")) goto l655;
  goto l654;
  l655:;	  G->pos= yypos654; G->thunkpos= yythunkpos654;  if (!yymatchString(G, "H5")) goto l653;

  }
  l654:;	  if (!yy_Spnl(G))  goto l653;

  l656:;	
  {  int yypos657= G->pos, yythunkpos657= G->thunkpos;  if (!yy_HtmlAttribute(G))  goto l657;
  goto l656;
  l657:;	  G->pos= yypos657; G->thunkpos= yythunkpos657;
  }  if (!yymatchChar(G, '>')) goto l653;
  yyprintf((stderr, "  ok   HtmlBlockOpenH5"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l653:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "HtmlBlockOpenH5"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_HtmlBlockH4(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "HtmlBlockH4"));
  if (!yy_HtmlBlockOpenH4(G))  goto l658;

  l659:;	
  {  int yypos660= G->pos, yythunkpos660= G->thunkpos;
  {  int yypos661= G->pos, yythunkpos661= G->thunkpos;  if (!yy_HtmlBlockH4(G))  goto l662;
  goto l661;
  l662:;	  G->pos= yypos661; G->thunkpos= yythunkpos661;
  {  int yypos663= G->pos, yythunkpos663= G->thunkpos;  if (!yy_HtmlBlockCloseH4(G))  goto l663;
  goto l660;
  l663:;	  G->pos= yypos663; G->thunkpos= yythunkpos663;
  }  if (!yymatchDot(G)) goto l660;
  }
  l661:;	  goto l659;
  l660:;	  G->pos= yypos660; G->thunkpos= yythunkpos660;
  }  if (!yy_HtmlBlockCloseH4(G))  goto l658;
  yyprintf((stderr, "  ok   HtmlBlockH4"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l658:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "HtmlBlockH4"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_HtmlBlockCloseH4(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "HtmlBlockCloseH4"));
  if (!yymatchChar(G, '<')) goto l664;
  if (!yy_Spnl(G))  goto l664;
  if (!yymatchChar(G, '/')) goto l664;

  {  int yypos665= G->pos, yythunkpos665= G->thunkpos;  if (!yymatchString(G, "h4")) goto l666;
  goto l665;
  l666:;	  G->pos= yypos665; G->thunkpos= yythunkpos665;  if (!yymatchString(G, "H4")) goto l664;

  }
  l665:;	  if (!yy_Spnl(G))  goto l664;
  if (!yymatchChar(G, '>')) goto l664;
  yyprintf((stderr, "  ok   HtmlBlockCloseH4"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l664:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "HtmlBlockCloseH4"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_HtmlBlockOpenH4(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "HtmlBlockOpenH4"));
  if (!yymatchChar(G, '<')) goto l667;
  if (!yy_Spnl(G))  goto l667;

  {  int yypos668= G->pos, yythunkpos668= G->thunkpos;  if (!yymatchString(G, "h4")) goto l669;
  goto l668;
  l669:;	  G->pos= yypos668; G->thunkpos= yythunkpos668;  if (!yymatchString(G, "H4")) goto l667;

  }
  l668:;	  if (!yy_Spnl(G))  goto l667;

  l670:;	
  {  int yypos671= G->pos, yythunkpos671= G->thunkpos;  if (!yy_HtmlAttribute(G))  goto l671;
  goto l670;
  l671:;	  G->pos= yypos671; G->thunkpos= yythunkpos671;
  }  if (!yymatchChar(G, '>')) goto l667;
  yyprintf((stderr, "  ok   HtmlBlockOpenH4"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l667:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "HtmlBlockOpenH4"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_HtmlBlockH3(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "HtmlBlockH3"));
  if (!yy_HtmlBlockOpenH3(G))  goto l672;

  l673:;	
  {  int yypos674= G->pos, yythunkpos674= G->thunkpos;
  {  int yypos675= G->pos, yythunkpos675= G->thunkpos;  if (!yy_HtmlBlockH3(G))  goto l676;
  goto l675;
  l676:;	  G->pos= yypos675; G->thunkpos= yythunkpos675;
  {  int yypos677= G->pos, yythunkpos677= G->thunkpos;  if (!yy_HtmlBlockCloseH3(G))  goto l677;
  goto l674;
  l677:;	  G->pos= yypos677; G->thunkpos= yythunkpos677;
  }  if (!yymatchDot(G)) goto l674;
  }
  l675:;	  goto l673;
  l674:;	  G->pos= yypos674; G->thunkpos= yythunkpos674;
  }  if (!yy_HtmlBlockCloseH3(G))  goto l672;
  yyprintf((stderr, "  ok   HtmlBlockH3"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l672:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "HtmlBlockH3"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_HtmlBlockCloseH3(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "HtmlBlockCloseH3"));
  if (!yymatchChar(G, '<')) goto l678;
  if (!yy_Spnl(G))  goto l678;
  if (!yymatchChar(G, '/')) goto l678;

  {  int yypos679= G->pos, yythunkpos679= G->thunkpos;  if (!yymatchString(G, "h3")) goto l680;
  goto l679;
  l680:;	  G->pos= yypos679; G->thunkpos= yythunkpos679;  if (!yymatchString(G, "H3")) goto l678;

  }
  l679:;	  if (!yy_Spnl(G))  goto l678;
  if (!yymatchChar(G, '>')) goto l678;
  yyprintf((stderr, "  ok   HtmlBlockCloseH3"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l678:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "HtmlBlockCloseH3"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_HtmlBlockOpenH3(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "HtmlBlockOpenH3"));
  if (!yymatchChar(G, '<')) goto l681;
  if (!yy_Spnl(G))  goto l681;

  {  int yypos682= G->pos, yythunkpos682= G->thunkpos;  if (!yymatchString(G, "h3")) goto l683;
  goto l682;
  l683:;	  G->pos= yypos682; G->thunkpos= yythunkpos682;  if (!yymatchString(G, "H3")) goto l681;

  }
  l682:;	  if (!yy_Spnl(G))  goto l681;

  l684:;	
  {  int yypos685= G->pos, yythunkpos685= G->thunkpos;  if (!yy_HtmlAttribute(G))  goto l685;
  goto l684;
  l685:;	  G->pos= yypos685; G->thunkpos= yythunkpos685;
  }  if (!yymatchChar(G, '>')) goto l681;
  yyprintf((stderr, "  ok   HtmlBlockOpenH3"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l681:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "HtmlBlockOpenH3"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_HtmlBlockH2(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "HtmlBlockH2"));
  if (!yy_HtmlBlockOpenH2(G))  goto l686;

  l687:;	
  {  int yypos688= G->pos, yythunkpos688= G->thunkpos;
  {  int yypos689= G->pos, yythunkpos689= G->thunkpos;  if (!yy_HtmlBlockH2(G))  goto l690;
  goto l689;
  l690:;	  G->pos= yypos689; G->thunkpos= yythunkpos689;
  {  int yypos691= G->pos, yythunkpos691= G->thunkpos;  if (!yy_HtmlBlockCloseH2(G))  goto l691;
  goto l688;
  l691:;	  G->pos= yypos691; G->thunkpos= yythunkpos691;
  }  if (!yymatchDot(G)) goto l688;
  }
  l689:;	  goto l687;
  l688:;	  G->pos= yypos688; G->thunkpos= yythunkpos688;
  }  if (!yy_HtmlBlockCloseH2(G))  goto l686;
  yyprintf((stderr, "  ok   HtmlBlockH2"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l686:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "HtmlBlockH2"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_HtmlBlockCloseH2(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "HtmlBlockCloseH2"));
  if (!yymatchChar(G, '<')) goto l692;
  if (!yy_Spnl(G))  goto l692;
  if (!yymatchChar(G, '/')) goto l692;

  {  int yypos693= G->pos, yythunkpos693= G->thunkpos;  if (!yymatchString(G, "h2")) goto l694;
  goto l693;
  l694:;	  G->pos= yypos693; G->thunkpos= yythunkpos693;  if (!yymatchString(G, "H2")) goto l692;

  }
  l693:;	  if (!yy_Spnl(G))  goto l692;
  if (!yymatchChar(G, '>')) goto l692;
  yyprintf((stderr, "  ok   HtmlBlockCloseH2"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l692:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "HtmlBlockCloseH2"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_HtmlBlockOpenH2(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "HtmlBlockOpenH2"));
  if (!yymatchChar(G, '<')) goto l695;
  if (!yy_Spnl(G))  goto l695;

  {  int yypos696= G->pos, yythunkpos696= G->thunkpos;  if (!yymatchString(G, "h2")) goto l697;
  goto l696;
  l697:;	  G->pos= yypos696; G->thunkpos= yythunkpos696;  if (!yymatchString(G, "H2")) goto l695;

  }
  l696:;	  if (!yy_Spnl(G))  goto l695;

  l698:;	
  {  int yypos699= G->pos, yythunkpos699= G->thunkpos;  if (!yy_HtmlAttribute(G))  goto l699;
  goto l698;
  l699:;	  G->pos= yypos699; G->thunkpos= yythunkpos699;
  }  if (!yymatchChar(G, '>')) goto l695;
  yyprintf((stderr, "  ok   HtmlBlockOpenH2"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l695:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "HtmlBlockOpenH2"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_HtmlBlockH1(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "HtmlBlockH1"));
  if (!yy_HtmlBlockOpenH1(G))  goto l700;

  l701:;	
  {  int yypos702= G->pos, yythunkpos702= G->thunkpos;
  {  int yypos703= G->pos, yythunkpos703= G->thunkpos;  if (!yy_HtmlBlockH1(G))  goto l704;
  goto l703;
  l704:;	  G->pos= yypos703; G->thunkpos= yythunkpos703;
  {  int yypos705= G->pos, yythunkpos705= G->thunkpos;  if (!yy_HtmlBlockCloseH1(G))  goto l705;
  goto l702;
  l705:;	  G->pos= yypos705; G->thunkpos= yythunkpos705;
  }  if (!yymatchDot(G)) goto l702;
  }
  l703:;	  goto l701;
  l702:;	  G->pos= yypos702; G->thunkpos= yythunkpos702;
  }  if (!yy_HtmlBlockCloseH1(G))  goto l700;
  yyprintf((stderr, "  ok   HtmlBlockH1"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l700:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "HtmlBlockH1"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_HtmlBlockCloseH1(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "HtmlBlockCloseH1"));
  if (!yymatchChar(G, '<')) goto l706;
  if (!yy_Spnl(G))  goto l706;
  if (!yymatchChar(G, '/')) goto l706;

  {  int yypos707= G->pos, yythunkpos707= G->thunkpos;  if (!yymatchString(G, "h1")) goto l708;
  goto l707;
  l708:;	  G->pos= yypos707; G->thunkpos= yythunkpos707;  if (!yymatchString(G, "H1")) goto l706;

  }
  l707:;	  if (!yy_Spnl(G))  goto l706;
  if (!yymatchChar(G, '>')) goto l706;
  yyprintf((stderr, "  ok   HtmlBlockCloseH1"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l706:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "HtmlBlockCloseH1"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_HtmlBlockOpenH1(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "HtmlBlockOpenH1"));
  if (!yymatchChar(G, '<')) goto l709;
  if (!yy_Spnl(G))  goto l709;

  {  int yypos710= G->pos, yythunkpos710= G->thunkpos;  if (!yymatchString(G, "h1")) goto l711;
  goto l710;
  l711:;	  G->pos= yypos710; G->thunkpos= yythunkpos710;  if (!yymatchString(G, "H1")) goto l709;

  }
  l710:;	  if (!yy_Spnl(G))  goto l709;

  l712:;	
  {  int yypos713= G->pos, yythunkpos713= G->thunkpos;  if (!yy_HtmlAttribute(G))  goto l713;
  goto l712;
  l713:;	  G->pos= yypos713; G->thunkpos= yythunkpos713;
  }  if (!yymatchChar(G, '>')) goto l709;
  yyprintf((stderr, "  ok   HtmlBlockOpenH1"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l709:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "HtmlBlockOpenH1"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_HtmlBlockHgroup(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "HtmlBlockHgroup"));
  if (!yy_HtmlBlockOpenHgroup(G))  goto l714;

  l715:;	
  {  int yypos716= G->pos, yythunkpos716= G->thunkpos;
  {  int yypos717= G->pos, yythunkpos717= G->thunkpos;  if (!yy_HtmlBlockHgroup(G))  goto l718;
  goto l717;
  l718:;	  G->pos= yypos717; G->thunkpos= yythunkpos717;
  {  int yypos719= G->pos, yythunkpos719= G->thunkpos;  if (!yy_HtmlBlockCloseHgroup(G))  goto l719;
  goto l716;
  l719:;	  G->pos= yypos719; G->thunkpos= yythunkpos719;
  }  if (!yymatchDot(G)) goto l716;
  }
  l717:;	  goto l715;
  l716:;	  G->pos= yypos716; G->thunkpos= yythunkpos716;
  }  if (!yy_HtmlBlockCloseHgroup(G))  goto l714;
  yyprintf((stderr, "  ok   HtmlBlockHgroup"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l714:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "HtmlBlockHgroup"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_HtmlBlockCloseHgroup(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "HtmlBlockCloseHgroup"));
  if (!yymatchChar(G, '<')) goto l720;
  if (!yy_Spnl(G))  goto l720;
  if (!yymatchChar(G, '/')) goto l720;

  {  int yypos721= G->pos, yythunkpos721= G->thunkpos;  if (!yymatchString(G, "hgroup")) goto l722;
  goto l721;
  l722:;	  G->pos= yypos721; G->thunkpos= yythunkpos721;  if (!yymatchString(G, "HGROUP")) goto l720;

  }
  l721:;	  if (!yy_Spnl(G))  goto l720;
  if (!yymatchChar(G, '>')) goto l720;
  yyprintf((stderr, "  ok   HtmlBlockCloseHgroup"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l720:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "HtmlBlockCloseHgroup"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_HtmlBlockOpenHgroup(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "HtmlBlockOpenHgroup"));
  if (!yymatchChar(G, '<')) goto l723;
  if (!yy_Spnl(G))  goto l723;

  {  int yypos724= G->pos, yythunkpos724= G->thunkpos;  if (!yymatchString(G, "hgroup")) goto l725;
  goto l724;
  l725:;	  G->pos= yypos724; G->thunkpos= yythunkpos724;  if (!yymatchString(G, "HGROUP")) goto l723;

  }
  l724:;	  if (!yy_Spnl(G))  goto l723;

  l726:;	
  {  int yypos727= G->pos, yythunkpos727= G->thunkpos;  if (!yy_HtmlAttribute(G))  goto l727;
  goto l726;
  l727:;	  G->pos= yypos727; G->thunkpos= yythunkpos727;
  }  if (!yymatchChar(G, '>')) goto l723;
  yyprintf((stderr, "  ok   HtmlBlockOpenHgroup"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l723:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "HtmlBlockOpenHgroup"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_HtmlBlockHeader(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "HtmlBlockHeader"));
  if (!yy_HtmlBlockOpenHeader(G))  goto l728;

  l729:;	
  {  int yypos730= G->pos, yythunkpos730= G->thunkpos;
  {  int yypos731= G->pos, yythunkpos731= G->thunkpos;  if (!yy_HtmlBlockHeader(G))  goto l732;
  goto l731;
  l732:;	  G->pos= yypos731; G->thunkpos= yythunkpos731;
  {  int yypos733= G->pos, yythunkpos733= G->thunkpos;  if (!yy_HtmlBlockCloseHeader(G))  goto l733;
  goto l730;
  l733:;	  G->pos= yypos733; G->thunkpos= yythunkpos733;
  }  if (!yymatchDot(G)) goto l730;
  }
  l731:;	  goto l729;
  l730:;	  G->pos= yypos730; G->thunkpos= yythunkpos730;
  }  if (!yy_HtmlBlockCloseHeader(G))  goto l728;
  yyprintf((stderr, "  ok   HtmlBlockHeader"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l728:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "HtmlBlockHeader"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_HtmlBlockCloseHeader(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "HtmlBlockCloseHeader"));
  if (!yymatchChar(G, '<')) goto l734;
  if (!yy_Spnl(G))  goto l734;
  if (!yymatchChar(G, '/')) goto l734;

  {  int yypos735= G->pos, yythunkpos735= G->thunkpos;  if (!yymatchString(G, "header")) goto l736;
  goto l735;
  l736:;	  G->pos= yypos735; G->thunkpos= yythunkpos735;  if (!yymatchString(G, "HEADER")) goto l734;

  }
  l735:;	  if (!yy_Spnl(G))  goto l734;
  if (!yymatchChar(G, '>')) goto l734;
  yyprintf((stderr, "  ok   HtmlBlockCloseHeader"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l734:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "HtmlBlockCloseHeader"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_HtmlBlockOpenHeader(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "HtmlBlockOpenHeader"));
  if (!yymatchChar(G, '<')) goto l737;
  if (!yy_Spnl(G))  goto l737;

  {  int yypos738= G->pos, yythunkpos738= G->thunkpos;  if (!yymatchString(G, "header")) goto l739;
  goto l738;
  l739:;	  G->pos= yypos738; G->thunkpos= yythunkpos738;  if (!yymatchString(G, "HEADER")) goto l737;

  }
  l738:;	  if (!yy_Spnl(G))  goto l737;

  l740:;	
  {  int yypos741= G->pos, yythunkpos741= G->thunkpos;  if (!yy_HtmlAttribute(G))  goto l741;
  goto l740;
  l741:;	  G->pos= yypos741; G->thunkpos= yythunkpos741;
  }  if (!yymatchChar(G, '>')) goto l737;
  yyprintf((stderr, "  ok   HtmlBlockOpenHeader"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l737:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "HtmlBlockOpenHeader"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_HtmlBlockForm(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "HtmlBlockForm"));
  if (!yy_HtmlBlockOpenForm(G))  goto l742;

  l743:;	
  {  int yypos744= G->pos, yythunkpos744= G->thunkpos;
  {  int yypos745= G->pos, yythunkpos745= G->thunkpos;  if (!yy_HtmlBlockForm(G))  goto l746;
  goto l745;
  l746:;	  G->pos= yypos745; G->thunkpos= yythunkpos745;
  {  int yypos747= G->pos, yythunkpos747= G->thunkpos;  if (!yy_HtmlBlockCloseForm(G))  goto l747;
  goto l744;
  l747:;	  G->pos= yypos747; G->thunkpos= yythunkpos747;
  }  if (!yymatchDot(G)) goto l744;
  }
  l745:;	  goto l743;
  l744:;	  G->pos= yypos744; G->thunkpos= yythunkpos744;
  }  if (!yy_HtmlBlockCloseForm(G))  goto l742;
  yyprintf((stderr, "  ok   HtmlBlockForm"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l742:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "HtmlBlockForm"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_HtmlBlockCloseForm(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "HtmlBlockCloseForm"));
  if (!yymatchChar(G, '<')) goto l748;
  if (!yy_Spnl(G))  goto l748;
  if (!yymatchChar(G, '/')) goto l748;

  {  int yypos749= G->pos, yythunkpos749= G->thunkpos;  if (!yymatchString(G, "form")) goto l750;
  goto l749;
  l750:;	  G->pos= yypos749; G->thunkpos= yythunkpos749;  if (!yymatchString(G, "FORM")) goto l748;

  }
  l749:;	  if (!yy_Spnl(G))  goto l748;
  if (!yymatchChar(G, '>')) goto l748;
  yyprintf((stderr, "  ok   HtmlBlockCloseForm"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l748:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "HtmlBlockCloseForm"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_HtmlBlockOpenForm(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "HtmlBlockOpenForm"));
  if (!yymatchChar(G, '<')) goto l751;
  if (!yy_Spnl(G))  goto l751;

  {  int yypos752= G->pos, yythunkpos752= G->thunkpos;  if (!yymatchString(G, "form")) goto l753;
  goto l752;
  l753:;	  G->pos= yypos752; G->thunkpos= yythunkpos752;  if (!yymatchString(G, "FORM")) goto l751;

  }
  l752:;	  if (!yy_Spnl(G))  goto l751;

  l754:;	
  {  int yypos755= G->pos, yythunkpos755= G->thunkpos;  if (!yy_HtmlAttribute(G))  goto l755;
  goto l754;
  l755:;	  G->pos= yypos755; G->thunkpos= yythunkpos755;
  }  if (!yymatchChar(G, '>')) goto l751;
  yyprintf((stderr, "  ok   HtmlBlockOpenForm"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l751:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "HtmlBlockOpenForm"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_HtmlBlockFooter(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "HtmlBlockFooter"));
  if (!yy_HtmlBlockOpenFooter(G))  goto l756;

  l757:;	
  {  int yypos758= G->pos, yythunkpos758= G->thunkpos;
  {  int yypos759= G->pos, yythunkpos759= G->thunkpos;  if (!yy_HtmlBlockFooter(G))  goto l760;
  goto l759;
  l760:;	  G->pos= yypos759; G->thunkpos= yythunkpos759;
  {  int yypos761= G->pos, yythunkpos761= G->thunkpos;  if (!yy_HtmlBlockCloseFooter(G))  goto l761;
  goto l758;
  l761:;	  G->pos= yypos761; G->thunkpos= yythunkpos761;
  }  if (!yymatchDot(G)) goto l758;
  }
  l759:;	  goto l757;
  l758:;	  G->pos= yypos758; G->thunkpos= yythunkpos758;
  }  if (!yy_HtmlBlockCloseFooter(G))  goto l756;
  yyprintf((stderr, "  ok   HtmlBlockFooter"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l756:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "HtmlBlockFooter"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_HtmlBlockCloseFooter(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "HtmlBlockCloseFooter"));
  if (!yymatchChar(G, '<')) goto l762;
  if (!yy_Spnl(G))  goto l762;
  if (!yymatchChar(G, '/')) goto l762;

  {  int yypos763= G->pos, yythunkpos763= G->thunkpos;  if (!yymatchString(G, "footer")) goto l764;
  goto l763;
  l764:;	  G->pos= yypos763; G->thunkpos= yythunkpos763;  if (!yymatchString(G, "FOOTER")) goto l762;

  }
  l763:;	  if (!yy_Spnl(G))  goto l762;
  if (!yymatchChar(G, '>')) goto l762;
  yyprintf((stderr, "  ok   HtmlBlockCloseFooter"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l762:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "HtmlBlockCloseFooter"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_HtmlBlockOpenFooter(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "HtmlBlockOpenFooter"));
  if (!yymatchChar(G, '<')) goto l765;
  if (!yy_Spnl(G))  goto l765;

  {  int yypos766= G->pos, yythunkpos766= G->thunkpos;  if (!yymatchString(G, "footer")) goto l767;
  goto l766;
  l767:;	  G->pos= yypos766; G->thunkpos= yythunkpos766;  if (!yymatchString(G, "FOOTER")) goto l765;

  }
  l766:;	  if (!yy_Spnl(G))  goto l765;

  l768:;	
  {  int yypos769= G->pos, yythunkpos769= G->thunkpos;  if (!yy_HtmlAttribute(G))  goto l769;
  goto l768;
  l769:;	  G->pos= yypos769; G->thunkpos= yythunkpos769;
  }  if (!yymatchChar(G, '>')) goto l765;
  yyprintf((stderr, "  ok   HtmlBlockOpenFooter"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l765:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "HtmlBlockOpenFooter"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_HtmlBlockFigure(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "HtmlBlockFigure"));
  if (!yy_HtmlBlockOpenFigure(G))  goto l770;

  l771:;	
  {  int yypos772= G->pos, yythunkpos772= G->thunkpos;
  {  int yypos773= G->pos, yythunkpos773= G->thunkpos;  if (!yy_HtmlBlockFigure(G))  goto l774;
  goto l773;
  l774:;	  G->pos= yypos773; G->thunkpos= yythunkpos773;
  {  int yypos775= G->pos, yythunkpos775= G->thunkpos;  if (!yy_HtmlBlockCloseFigure(G))  goto l775;
  goto l772;
  l775:;	  G->pos= yypos775; G->thunkpos= yythunkpos775;
  }  if (!yymatchDot(G)) goto l772;
  }
  l773:;	  goto l771;
  l772:;	  G->pos= yypos772; G->thunkpos= yythunkpos772;
  }  if (!yy_HtmlBlockCloseFigure(G))  goto l770;
  yyprintf((stderr, "  ok   HtmlBlockFigure"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l770:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "HtmlBlockFigure"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_HtmlBlockCloseFigure(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "HtmlBlockCloseFigure"));
  if (!yymatchChar(G, '<')) goto l776;
  if (!yy_Spnl(G))  goto l776;
  if (!yymatchChar(G, '/')) goto l776;

  {  int yypos777= G->pos, yythunkpos777= G->thunkpos;  if (!yymatchString(G, "figure")) goto l778;
  goto l777;
  l778:;	  G->pos= yypos777; G->thunkpos= yythunkpos777;  if (!yymatchString(G, "FIGURE")) goto l776;

  }
  l777:;	  if (!yy_Spnl(G))  goto l776;
  if (!yymatchChar(G, '>')) goto l776;
  yyprintf((stderr, "  ok   HtmlBlockCloseFigure"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l776:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "HtmlBlockCloseFigure"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_HtmlBlockOpenFigure(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "HtmlBlockOpenFigure"));
  if (!yymatchChar(G, '<')) goto l779;
  if (!yy_Spnl(G))  goto l779;

  {  int yypos780= G->pos, yythunkpos780= G->thunkpos;  if (!yymatchString(G, "figure")) goto l781;
  goto l780;
  l781:;	  G->pos= yypos780; G->thunkpos= yythunkpos780;  if (!yymatchString(G, "FIGURE")) goto l779;

  }
  l780:;	  if (!yy_Spnl(G))  goto l779;

  l782:;	
  {  int yypos783= G->pos, yythunkpos783= G->thunkpos;  if (!yy_HtmlAttribute(G))  goto l783;
  goto l782;
  l783:;	  G->pos= yypos783; G->thunkpos= yythunkpos783;
  }  if (!yymatchChar(G, '>')) goto l779;
  yyprintf((stderr, "  ok   HtmlBlockOpenFigure"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l779:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "HtmlBlockOpenFigure"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_HtmlBlockFieldset(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "HtmlBlockFieldset"));
  if (!yy_HtmlBlockOpenFieldset(G))  goto l784;

  l785:;	
  {  int yypos786= G->pos, yythunkpos786= G->thunkpos;
  {  int yypos787= G->pos, yythunkpos787= G->thunkpos;  if (!yy_HtmlBlockFieldset(G))  goto l788;
  goto l787;
  l788:;	  G->pos= yypos787; G->thunkpos= yythunkpos787;
  {  int yypos789= G->pos, yythunkpos789= G->thunkpos;  if (!yy_HtmlBlockCloseFieldset(G))  goto l789;
  goto l786;
  l789:;	  G->pos= yypos789; G->thunkpos= yythunkpos789;
  }  if (!yymatchDot(G)) goto l786;
  }
  l787:;	  goto l785;
  l786:;	  G->pos= yypos786; G->thunkpos= yythunkpos786;
  }  if (!yy_HtmlBlockCloseFieldset(G))  goto l784;
  yyprintf((stderr, "  ok   HtmlBlockFieldset"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l784:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "HtmlBlockFieldset"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_HtmlBlockCloseFieldset(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "HtmlBlockCloseFieldset"));
  if (!yymatchChar(G, '<')) goto l790;
  if (!yy_Spnl(G))  goto l790;
  if (!yymatchChar(G, '/')) goto l790;

  {  int yypos791= G->pos, yythunkpos791= G->thunkpos;  if (!yymatchString(G, "fieldset")) goto l792;
  goto l791;
  l792:;	  G->pos= yypos791; G->thunkpos= yythunkpos791;  if (!yymatchString(G, "FIELDSET")) goto l790;

  }
  l791:;	  if (!yy_Spnl(G))  goto l790;
  if (!yymatchChar(G, '>')) goto l790;
  yyprintf((stderr, "  ok   HtmlBlockCloseFieldset"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l790:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "HtmlBlockCloseFieldset"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_HtmlBlockOpenFieldset(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "HtmlBlockOpenFieldset"));
  if (!yymatchChar(G, '<')) goto l793;
  if (!yy_Spnl(G))  goto l793;

  {  int yypos794= G->pos, yythunkpos794= G->thunkpos;  if (!yymatchString(G, "fieldset")) goto l795;
  goto l794;
  l795:;	  G->pos= yypos794; G->thunkpos= yythunkpos794;  if (!yymatchString(G, "FIELDSET")) goto l793;

  }
  l794:;	  if (!yy_Spnl(G))  goto l793;

  l796:;	
  {  int yypos797= G->pos, yythunkpos797= G->thunkpos;  if (!yy_HtmlAttribute(G))  goto l797;
  goto l796;
  l797:;	  G->pos= yypos797; G->thunkpos= yythunkpos797;
  }  if (!yymatchChar(G, '>')) goto l793;
  yyprintf((stderr, "  ok   HtmlBlockOpenFieldset"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l793:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "HtmlBlockOpenFieldset"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_HtmlBlockDl(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "HtmlBlockDl"));
  if (!yy_HtmlBlockOpenDl(G))  goto l798;

  l799:;	
  {  int yypos800= G->pos, yythunkpos800= G->thunkpos;
  {  int yypos801= G->pos, yythunkpos801= G->thunkpos;  if (!yy_HtmlBlockDl(G))  goto l802;
  goto l801;
  l802:;	  G->pos= yypos801; G->thunkpos= yythunkpos801;
  {  int yypos803= G->pos, yythunkpos803= G->thunkpos;  if (!yy_HtmlBlockCloseDl(G))  goto l803;
  goto l800;
  l803:;	  G->pos= yypos803; G->thunkpos= yythunkpos803;
  }  if (!yymatchDot(G)) goto l800;
  }
  l801:;	  goto l799;
  l800:;	  G->pos= yypos800; G->thunkpos= yythunkpos800;
  }  if (!yy_HtmlBlockCloseDl(G))  goto l798;
  yyprintf((stderr, "  ok   HtmlBlockDl"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l798:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "HtmlBlockDl"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_HtmlBlockCloseDl(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "HtmlBlockCloseDl"));
  if (!yymatchChar(G, '<')) goto l804;
  if (!yy_Spnl(G))  goto l804;
  if (!yymatchChar(G, '/')) goto l804;

  {  int yypos805= G->pos, yythunkpos805= G->thunkpos;  if (!yymatchString(G, "dl")) goto l806;
  goto l805;
  l806:;	  G->pos= yypos805; G->thunkpos= yythunkpos805;  if (!yymatchString(G, "DL")) goto l804;

  }
  l805:;	  if (!yy_Spnl(G))  goto l804;
  if (!yymatchChar(G, '>')) goto l804;
  yyprintf((stderr, "  ok   HtmlBlockCloseDl"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l804:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "HtmlBlockCloseDl"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_HtmlBlockOpenDl(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "HtmlBlockOpenDl"));
  if (!yymatchChar(G, '<')) goto l807;
  if (!yy_Spnl(G))  goto l807;

  {  int yypos808= G->pos, yythunkpos808= G->thunkpos;  if (!yymatchString(G, "dl")) goto l809;
  goto l808;
  l809:;	  G->pos= yypos808; G->thunkpos= yythunkpos808;  if (!yymatchString(G, "DL")) goto l807;

  }
  l808:;	  if (!yy_Spnl(G))  goto l807;

  l810:;	
  {  int yypos811= G->pos, yythunkpos811= G->thunkpos;  if (!yy_HtmlAttribute(G))  goto l811;
  goto l810;
  l811:;	  G->pos= yypos811; G->thunkpos= yythunkpos811;
  }  if (!yymatchChar(G, '>')) goto l807;
  yyprintf((stderr, "  ok   HtmlBlockOpenDl"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l807:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "HtmlBlockOpenDl"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_HtmlBlockDiv(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "HtmlBlockDiv"));
  if (!yy_HtmlBlockOpenDiv(G))  goto l812;

  l813:;	
  {  int yypos814= G->pos, yythunkpos814= G->thunkpos;
  {  int yypos815= G->pos, yythunkpos815= G->thunkpos;  if (!yy_HtmlBlockDiv(G))  goto l816;
  goto l815;
  l816:;	  G->pos= yypos815; G->thunkpos= yythunkpos815;
  {  int yypos817= G->pos, yythunkpos817= G->thunkpos;  if (!yy_HtmlBlockCloseDiv(G))  goto l817;
  goto l814;
  l817:;	  G->pos= yypos817; G->thunkpos= yythunkpos817;
  }  if (!yymatchDot(G)) goto l814;
  }
  l815:;	  goto l813;
  l814:;	  G->pos= yypos814; G->thunkpos= yythunkpos814;
  }  if (!yy_HtmlBlockCloseDiv(G))  goto l812;
  yyprintf((stderr, "  ok   HtmlBlockDiv"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l812:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "HtmlBlockDiv"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_HtmlBlockCloseDiv(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "HtmlBlockCloseDiv"));
  if (!yymatchChar(G, '<')) goto l818;
  if (!yy_Spnl(G))  goto l818;
  if (!yymatchChar(G, '/')) goto l818;

  {  int yypos819= G->pos, yythunkpos819= G->thunkpos;  if (!yymatchString(G, "div")) goto l820;
  goto l819;
  l820:;	  G->pos= yypos819; G->thunkpos= yythunkpos819;  if (!yymatchString(G, "DIV")) goto l818;

  }
  l819:;	  if (!yy_Spnl(G))  goto l818;
  if (!yymatchChar(G, '>')) goto l818;
  yyprintf((stderr, "  ok   HtmlBlockCloseDiv"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l818:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "HtmlBlockCloseDiv"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_HtmlBlockOpenDiv(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "HtmlBlockOpenDiv"));
  if (!yymatchChar(G, '<')) goto l821;
  if (!yy_Spnl(G))  goto l821;

  {  int yypos822= G->pos, yythunkpos822= G->thunkpos;  if (!yymatchString(G, "div")) goto l823;
  goto l822;
  l823:;	  G->pos= yypos822; G->thunkpos= yythunkpos822;  if (!yymatchString(G, "DIV")) goto l821;

  }
  l822:;	  if (!yy_Spnl(G))  goto l821;

  l824:;	
  {  int yypos825= G->pos, yythunkpos825= G->thunkpos;  if (!yy_HtmlAttribute(G))  goto l825;
  goto l824;
  l825:;	  G->pos= yypos825; G->thunkpos= yythunkpos825;
  }  if (!yymatchChar(G, '>')) goto l821;
  yyprintf((stderr, "  ok   HtmlBlockOpenDiv"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l821:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "HtmlBlockOpenDiv"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_HtmlBlockDir(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "HtmlBlockDir"));
  if (!yy_HtmlBlockOpenDir(G))  goto l826;

  l827:;	
  {  int yypos828= G->pos, yythunkpos828= G->thunkpos;
  {  int yypos829= G->pos, yythunkpos829= G->thunkpos;  if (!yy_HtmlBlockDir(G))  goto l830;
  goto l829;
  l830:;	  G->pos= yypos829; G->thunkpos= yythunkpos829;
  {  int yypos831= G->pos, yythunkpos831= G->thunkpos;  if (!yy_HtmlBlockCloseDir(G))  goto l831;
  goto l828;
  l831:;	  G->pos= yypos831; G->thunkpos= yythunkpos831;
  }  if (!yymatchDot(G)) goto l828;
  }
  l829:;	  goto l827;
  l828:;	  G->pos= yypos828; G->thunkpos= yythunkpos828;
  }  if (!yy_HtmlBlockCloseDir(G))  goto l826;
  yyprintf((stderr, "  ok   HtmlBlockDir"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l826:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "HtmlBlockDir"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_HtmlBlockCloseDir(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "HtmlBlockCloseDir"));
  if (!yymatchChar(G, '<')) goto l832;
  if (!yy_Spnl(G))  goto l832;
  if (!yymatchChar(G, '/')) goto l832;

  {  int yypos833= G->pos, yythunkpos833= G->thunkpos;  if (!yymatchString(G, "dir")) goto l834;
  goto l833;
  l834:;	  G->pos= yypos833; G->thunkpos= yythunkpos833;  if (!yymatchString(G, "DIR")) goto l832;

  }
  l833:;	  if (!yy_Spnl(G))  goto l832;
  if (!yymatchChar(G, '>')) goto l832;
  yyprintf((stderr, "  ok   HtmlBlockCloseDir"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l832:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "HtmlBlockCloseDir"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_HtmlBlockOpenDir(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "HtmlBlockOpenDir"));
  if (!yymatchChar(G, '<')) goto l835;
  if (!yy_Spnl(G))  goto l835;

  {  int yypos836= G->pos, yythunkpos836= G->thunkpos;  if (!yymatchString(G, "dir")) goto l837;
  goto l836;
  l837:;	  G->pos= yypos836; G->thunkpos= yythunkpos836;  if (!yymatchString(G, "DIR")) goto l835;

  }
  l836:;	  if (!yy_Spnl(G))  goto l835;

  l838:;	
  {  int yypos839= G->pos, yythunkpos839= G->thunkpos;  if (!yy_HtmlAttribute(G))  goto l839;
  goto l838;
  l839:;	  G->pos= yypos839; G->thunkpos= yythunkpos839;
  }  if (!yymatchChar(G, '>')) goto l835;
  yyprintf((stderr, "  ok   HtmlBlockOpenDir"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l835:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "HtmlBlockOpenDir"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_HtmlBlockCenter(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "HtmlBlockCenter"));
  if (!yy_HtmlBlockOpenCenter(G))  goto l840;

  l841:;	
  {  int yypos842= G->pos, yythunkpos842= G->thunkpos;
  {  int yypos843= G->pos, yythunkpos843= G->thunkpos;  if (!yy_HtmlBlockCenter(G))  goto l844;
  goto l843;
  l844:;	  G->pos= yypos843; G->thunkpos= yythunkpos843;
  {  int yypos845= G->pos, yythunkpos845= G->thunkpos;  if (!yy_HtmlBlockCloseCenter(G))  goto l845;
  goto l842;
  l845:;	  G->pos= yypos845; G->thunkpos= yythunkpos845;
  }  if (!yymatchDot(G)) goto l842;
  }
  l843:;	  goto l841;
  l842:;	  G->pos= yypos842; G->thunkpos= yythunkpos842;
  }  if (!yy_HtmlBlockCloseCenter(G))  goto l840;
  yyprintf((stderr, "  ok   HtmlBlockCenter"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l840:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "HtmlBlockCenter"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_HtmlBlockCloseCenter(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "HtmlBlockCloseCenter"));
  if (!yymatchChar(G, '<')) goto l846;
  if (!yy_Spnl(G))  goto l846;
  if (!yymatchChar(G, '/')) goto l846;

  {  int yypos847= G->pos, yythunkpos847= G->thunkpos;  if (!yymatchString(G, "center")) goto l848;
  goto l847;
  l848:;	  G->pos= yypos847; G->thunkpos= yythunkpos847;  if (!yymatchString(G, "CENTER")) goto l846;

  }
  l847:;	  if (!yy_Spnl(G))  goto l846;
  if (!yymatchChar(G, '>')) goto l846;
  yyprintf((stderr, "  ok   HtmlBlockCloseCenter"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l846:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "HtmlBlockCloseCenter"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_HtmlBlockOpenCenter(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "HtmlBlockOpenCenter"));
  if (!yymatchChar(G, '<')) goto l849;
  if (!yy_Spnl(G))  goto l849;

  {  int yypos850= G->pos, yythunkpos850= G->thunkpos;  if (!yymatchString(G, "center")) goto l851;
  goto l850;
  l851:;	  G->pos= yypos850; G->thunkpos= yythunkpos850;  if (!yymatchString(G, "CENTER")) goto l849;

  }
  l850:;	  if (!yy_Spnl(G))  goto l849;

  l852:;	
  {  int yypos853= G->pos, yythunkpos853= G->thunkpos;  if (!yy_HtmlAttribute(G))  goto l853;
  goto l852;
  l853:;	  G->pos= yypos853; G->thunkpos= yythunkpos853;
  }  if (!yymatchChar(G, '>')) goto l849;
  yyprintf((stderr, "  ok   HtmlBlockOpenCenter"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l849:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "HtmlBlockOpenCenter"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_HtmlBlockCanvas(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "HtmlBlockCanvas"));
  if (!yy_HtmlBlockOpenCanvas(G))  goto l854;

  l855:;	
  {  int yypos856= G->pos, yythunkpos856= G->thunkpos;
  {  int yypos857= G->pos, yythunkpos857= G->thunkpos;  if (!yy_HtmlBlockCanvas(G))  goto l858;
  goto l857;
  l858:;	  G->pos= yypos857; G->thunkpos= yythunkpos857;
  {  int yypos859= G->pos, yythunkpos859= G->thunkpos;  if (!yy_HtmlBlockCloseCanvas(G))  goto l859;
  goto l856;
  l859:;	  G->pos= yypos859; G->thunkpos= yythunkpos859;
  }  if (!yymatchDot(G)) goto l856;
  }
  l857:;	  goto l855;
  l856:;	  G->pos= yypos856; G->thunkpos= yythunkpos856;
  }  if (!yy_HtmlBlockCloseCanvas(G))  goto l854;
  yyprintf((stderr, "  ok   HtmlBlockCanvas"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l854:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "HtmlBlockCanvas"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_HtmlBlockCloseCanvas(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "HtmlBlockCloseCanvas"));
  if (!yymatchChar(G, '<')) goto l860;
  if (!yy_Spnl(G))  goto l860;
  if (!yymatchChar(G, '/')) goto l860;

  {  int yypos861= G->pos, yythunkpos861= G->thunkpos;  if (!yymatchString(G, "canvas")) goto l862;
  goto l861;
  l862:;	  G->pos= yypos861; G->thunkpos= yythunkpos861;  if (!yymatchString(G, "CANVAS")) goto l860;

  }
  l861:;	  if (!yy_Spnl(G))  goto l860;
  if (!yymatchChar(G, '>')) goto l860;
  yyprintf((stderr, "  ok   HtmlBlockCloseCanvas"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l860:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "HtmlBlockCloseCanvas"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_HtmlBlockOpenCanvas(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "HtmlBlockOpenCanvas"));
  if (!yymatchChar(G, '<')) goto l863;
  if (!yy_Spnl(G))  goto l863;

  {  int yypos864= G->pos, yythunkpos864= G->thunkpos;  if (!yymatchString(G, "canvas")) goto l865;
  goto l864;
  l865:;	  G->pos= yypos864; G->thunkpos= yythunkpos864;  if (!yymatchString(G, "CANVAS")) goto l863;

  }
  l864:;	  if (!yy_Spnl(G))  goto l863;

  l866:;	
  {  int yypos867= G->pos, yythunkpos867= G->thunkpos;  if (!yy_HtmlAttribute(G))  goto l867;
  goto l866;
  l867:;	  G->pos= yypos867; G->thunkpos= yythunkpos867;
  }  if (!yymatchChar(G, '>')) goto l863;
  yyprintf((stderr, "  ok   HtmlBlockOpenCanvas"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l863:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "HtmlBlockOpenCanvas"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_HtmlBlockBlockquote(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "HtmlBlockBlockquote"));
  if (!yy_HtmlBlockOpenBlockquote(G))  goto l868;

  l869:;	
  {  int yypos870= G->pos, yythunkpos870= G->thunkpos;
  {  int yypos871= G->pos, yythunkpos871= G->thunkpos;  if (!yy_HtmlBlockBlockquote(G))  goto l872;
  goto l871;
  l872:;	  G->pos= yypos871; G->thunkpos= yythunkpos871;
  {  int yypos873= G->pos, yythunkpos873= G->thunkpos;  if (!yy_HtmlBlockCloseBlockquote(G))  goto l873;
  goto l870;
  l873:;	  G->pos= yypos873; G->thunkpos= yythunkpos873;
  }  if (!yymatchDot(G)) goto l870;
  }
  l871:;	  goto l869;
  l870:;	  G->pos= yypos870; G->thunkpos= yythunkpos870;
  }  if (!yy_HtmlBlockCloseBlockquote(G))  goto l868;
  yyprintf((stderr, "  ok   HtmlBlockBlockquote"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l868:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "HtmlBlockBlockquote"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_HtmlBlockCloseBlockquote(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "HtmlBlockCloseBlockquote"));
  if (!yymatchChar(G, '<')) goto l874;
  if (!yy_Spnl(G))  goto l874;
  if (!yymatchChar(G, '/')) goto l874;

  {  int yypos875= G->pos, yythunkpos875= G->thunkpos;  if (!yymatchString(G, "blockquote")) goto l876;
  goto l875;
  l876:;	  G->pos= yypos875; G->thunkpos= yythunkpos875;  if (!yymatchString(G, "BLOCKQUOTE")) goto l874;

  }
  l875:;	  if (!yy_Spnl(G))  goto l874;
  if (!yymatchChar(G, '>')) goto l874;
  yyprintf((stderr, "  ok   HtmlBlockCloseBlockquote"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l874:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "HtmlBlockCloseBlockquote"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_HtmlBlockOpenBlockquote(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "HtmlBlockOpenBlockquote"));
  if (!yymatchChar(G, '<')) goto l877;
  if (!yy_Spnl(G))  goto l877;

  {  int yypos878= G->pos, yythunkpos878= G->thunkpos;  if (!yymatchString(G, "blockquote")) goto l879;
  goto l878;
  l879:;	  G->pos= yypos878; G->thunkpos= yythunkpos878;  if (!yymatchString(G, "BLOCKQUOTE")) goto l877;

  }
  l878:;	  if (!yy_Spnl(G))  goto l877;

  l880:;	
  {  int yypos881= G->pos, yythunkpos881= G->thunkpos;  if (!yy_HtmlAttribute(G))  goto l881;
  goto l880;
  l881:;	  G->pos= yypos881; G->thunkpos= yythunkpos881;
  }  if (!yymatchChar(G, '>')) goto l877;
  yyprintf((stderr, "  ok   HtmlBlockOpenBlockquote"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l877:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "HtmlBlockOpenBlockquote"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_HtmlBlockAside(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "HtmlBlockAside"));
  if (!yy_HtmlBlockOpenAside(G))  goto l882;

  l883:;	
  {  int yypos884= G->pos, yythunkpos884= G->thunkpos;
  {  int yypos885= G->pos, yythunkpos885= G->thunkpos;  if (!yy_HtmlBlockAside(G))  goto l886;
  goto l885;
  l886:;	  G->pos= yypos885; G->thunkpos= yythunkpos885;
  {  int yypos887= G->pos, yythunkpos887= G->thunkpos;  if (!yy_HtmlBlockCloseAside(G))  goto l887;
  goto l884;
  l887:;	  G->pos= yypos887; G->thunkpos= yythunkpos887;
  }  if (!yymatchDot(G)) goto l884;
  }
  l885:;	  goto l883;
  l884:;	  G->pos= yypos884; G->thunkpos= yythunkpos884;
  }  if (!yy_HtmlBlockCloseAside(G))  goto l882;
  yyprintf((stderr, "  ok   HtmlBlockAside"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l882:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "HtmlBlockAside"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_HtmlBlockCloseAside(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "HtmlBlockCloseAside"));
  if (!yymatchChar(G, '<')) goto l888;
  if (!yy_Spnl(G))  goto l888;
  if (!yymatchChar(G, '/')) goto l888;

  {  int yypos889= G->pos, yythunkpos889= G->thunkpos;  if (!yymatchString(G, "aside")) goto l890;
  goto l889;
  l890:;	  G->pos= yypos889; G->thunkpos= yythunkpos889;  if (!yymatchString(G, "ASIDE")) goto l888;

  }
  l889:;	  if (!yy_Spnl(G))  goto l888;
  if (!yymatchChar(G, '>')) goto l888;
  yyprintf((stderr, "  ok   HtmlBlockCloseAside"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l888:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "HtmlBlockCloseAside"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_HtmlBlockOpenAside(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "HtmlBlockOpenAside"));
  if (!yymatchChar(G, '<')) goto l891;
  if (!yy_Spnl(G))  goto l891;

  {  int yypos892= G->pos, yythunkpos892= G->thunkpos;  if (!yymatchString(G, "aside")) goto l893;
  goto l892;
  l893:;	  G->pos= yypos892; G->thunkpos= yythunkpos892;  if (!yymatchString(G, "ASIDE")) goto l891;

  }
  l892:;	  if (!yy_Spnl(G))  goto l891;

  l894:;	
  {  int yypos895= G->pos, yythunkpos895= G->thunkpos;  if (!yy_HtmlAttribute(G))  goto l895;
  goto l894;
  l895:;	  G->pos= yypos895; G->thunkpos= yythunkpos895;
  }  if (!yymatchChar(G, '>')) goto l891;
  yyprintf((stderr, "  ok   HtmlBlockOpenAside"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l891:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "HtmlBlockOpenAside"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_HtmlBlockArticle(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "HtmlBlockArticle"));
  if (!yy_HtmlBlockOpenArticle(G))  goto l896;

  l897:;	
  {  int yypos898= G->pos, yythunkpos898= G->thunkpos;
  {  int yypos899= G->pos, yythunkpos899= G->thunkpos;  if (!yy_HtmlBlockArticle(G))  goto l900;
  goto l899;
  l900:;	  G->pos= yypos899; G->thunkpos= yythunkpos899;
  {  int yypos901= G->pos, yythunkpos901= G->thunkpos;  if (!yy_HtmlBlockCloseArticle(G))  goto l901;
  goto l898;
  l901:;	  G->pos= yypos901; G->thunkpos= yythunkpos901;
  }  if (!yymatchDot(G)) goto l898;
  }
  l899:;	  goto l897;
  l898:;	  G->pos= yypos898; G->thunkpos= yythunkpos898;
  }  if (!yy_HtmlBlockCloseArticle(G))  goto l896;
  yyprintf((stderr, "  ok   HtmlBlockArticle"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l896:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "HtmlBlockArticle"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_HtmlBlockCloseArticle(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "HtmlBlockCloseArticle"));
  if (!yymatchChar(G, '<')) goto l902;
  if (!yy_Spnl(G))  goto l902;
  if (!yymatchChar(G, '/')) goto l902;

  {  int yypos903= G->pos, yythunkpos903= G->thunkpos;  if (!yymatchString(G, "article")) goto l904;
  goto l903;
  l904:;	  G->pos= yypos903; G->thunkpos= yythunkpos903;  if (!yymatchString(G, "ARTICLE")) goto l902;

  }
  l903:;	  if (!yy_Spnl(G))  goto l902;
  if (!yymatchChar(G, '>')) goto l902;
  yyprintf((stderr, "  ok   HtmlBlockCloseArticle"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l902:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "HtmlBlockCloseArticle"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_HtmlBlockOpenArticle(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "HtmlBlockOpenArticle"));
  if (!yymatchChar(G, '<')) goto l905;
  if (!yy_Spnl(G))  goto l905;

  {  int yypos906= G->pos, yythunkpos906= G->thunkpos;  if (!yymatchString(G, "article")) goto l907;
  goto l906;
  l907:;	  G->pos= yypos906; G->thunkpos= yythunkpos906;  if (!yymatchString(G, "ARTICLE")) goto l905;

  }
  l906:;	  if (!yy_Spnl(G))  goto l905;

  l908:;	
  {  int yypos909= G->pos, yythunkpos909= G->thunkpos;  if (!yy_HtmlAttribute(G))  goto l909;
  goto l908;
  l909:;	  G->pos= yypos909; G->thunkpos= yythunkpos909;
  }  if (!yymatchChar(G, '>')) goto l905;
  yyprintf((stderr, "  ok   HtmlBlockOpenArticle"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l905:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "HtmlBlockOpenArticle"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_HtmlBlockAddress(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "HtmlBlockAddress"));
  if (!yy_HtmlBlockOpenAddress(G))  goto l910;

  l911:;	
  {  int yypos912= G->pos, yythunkpos912= G->thunkpos;
  {  int yypos913= G->pos, yythunkpos913= G->thunkpos;  if (!yy_HtmlBlockAddress(G))  goto l914;
  goto l913;
  l914:;	  G->pos= yypos913; G->thunkpos= yythunkpos913;
  {  int yypos915= G->pos, yythunkpos915= G->thunkpos;  if (!yy_HtmlBlockCloseAddress(G))  goto l915;
  goto l912;
  l915:;	  G->pos= yypos915; G->thunkpos= yythunkpos915;
  }  if (!yymatchDot(G)) goto l912;
  }
  l913:;	  goto l911;
  l912:;	  G->pos= yypos912; G->thunkpos= yythunkpos912;
  }  if (!yy_HtmlBlockCloseAddress(G))  goto l910;
  yyprintf((stderr, "  ok   HtmlBlockAddress"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l910:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "HtmlBlockAddress"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_HtmlBlockCloseAddress(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "HtmlBlockCloseAddress"));
  if (!yymatchChar(G, '<')) goto l916;
  if (!yy_Spnl(G))  goto l916;
  if (!yymatchChar(G, '/')) goto l916;

  {  int yypos917= G->pos, yythunkpos917= G->thunkpos;  if (!yymatchString(G, "address")) goto l918;
  goto l917;
  l918:;	  G->pos= yypos917; G->thunkpos= yythunkpos917;  if (!yymatchString(G, "ADDRESS")) goto l916;

  }
  l917:;	  if (!yy_Spnl(G))  goto l916;
  if (!yymatchChar(G, '>')) goto l916;
  yyprintf((stderr, "  ok   HtmlBlockCloseAddress"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l916:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "HtmlBlockCloseAddress"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_HtmlBlockOpenAddress(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "HtmlBlockOpenAddress"));
  if (!yymatchChar(G, '<')) goto l919;
  if (!yy_Spnl(G))  goto l919;

  {  int yypos920= G->pos, yythunkpos920= G->thunkpos;  if (!yymatchString(G, "address")) goto l921;
  goto l920;
  l921:;	  G->pos= yypos920; G->thunkpos= yythunkpos920;  if (!yymatchString(G, "ADDRESS")) goto l919;

  }
  l920:;	  if (!yy_Spnl(G))  goto l919;

  l922:;	
  {  int yypos923= G->pos, yythunkpos923= G->thunkpos;  if (!yy_HtmlAttribute(G))  goto l923;
  goto l922;
  l923:;	  G->pos= yypos923; G->thunkpos= yythunkpos923;
  }  if (!yymatchChar(G, '>')) goto l919;
  yyprintf((stderr, "  ok   HtmlBlockOpenAddress"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l919:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "HtmlBlockOpenAddress"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_ListBlockLine(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "ListBlockLine"));

  {  int yypos925= G->pos, yythunkpos925= G->thunkpos;  if (!yy_BlankLine(G))  goto l925;
  goto l924;
  l925:;	  G->pos= yypos925; G->thunkpos= yythunkpos925;
  }
  {  int yypos926= G->pos, yythunkpos926= G->thunkpos;
  {  int yypos927= G->pos, yythunkpos927= G->thunkpos;  if (!yy_Indent(G))  goto l927;
  goto l928;
  l927:;	  G->pos= yypos927; G->thunkpos= yythunkpos927;
  }
  l928:;	
  {  int yypos929= G->pos, yythunkpos929= G->thunkpos;  if (!yy_Bullet(G))  goto l930;
  goto l929;
  l930:;	  G->pos= yypos929; G->thunkpos= yythunkpos929;  if (!yy_Enumerator(G))  goto l926;

  }
  l929:;	  goto l924;
  l926:;	  G->pos= yypos926; G->thunkpos= yythunkpos926;
  }
  {  int yypos931= G->pos, yythunkpos931= G->thunkpos;  if (!yy_HorizontalRule(G))  goto l931;
  goto l924;
  l931:;	  G->pos= yypos931; G->thunkpos= yythunkpos931;
  }  if (!yy_OptionallyIndentedLine(G))  goto l924;
  yyprintf((stderr, "  ok   ListBlockLine"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l924:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "ListBlockLine"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_ListContinuationBlock(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyDo(G, yyPush, 1, 0, "yyPush");
  yyprintfv((stderr, "%s\n", "ListContinuationBlock"));
  if (!yy_StartList(G))  goto l932;
  yyDo(G, yySet, -1, 0, "yySet");
  yyText(G, G->begin, G->end);  if (!(YY_BEGIN)) goto l932;
  l933:;	
  {  int yypos934= G->pos, yythunkpos934= G->thunkpos;  if (!yy_BlankLine(G))  goto l934;
  goto l933;
  l934:;	  G->pos= yypos934; G->thunkpos= yythunkpos934;
  }  yyText(G, G->begin, G->end);  if (!(YY_END)) goto l932;  yyDo(G, yy_1_ListContinuationBlock, G->begin, G->end, "yy_1_ListContinuationBlock");
  if (!yy_Indent(G))  goto l932;
  if (!yy_ListBlock(G))  goto l932;
  yyDo(G, yy_2_ListContinuationBlock, G->begin, G->end, "yy_2_ListContinuationBlock");

  l935:;	
  {  int yypos936= G->pos, yythunkpos936= G->thunkpos;  if (!yy_Indent(G))  goto l936;
  if (!yy_ListBlock(G))  goto l936;
  yyDo(G, yy_2_ListContinuationBlock, G->begin, G->end, "yy_2_ListContinuationBlock");
  goto l935;
  l936:;	  G->pos= yypos936; G->thunkpos= yythunkpos936;
  }  yyDo(G, yy_3_ListContinuationBlock, G->begin, G->end, "yy_3_ListContinuationBlock");
  yyprintf((stderr, "  ok   ListContinuationBlock"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));
  yyDo(G, yyPop, 1, 0, "yyPop");
  return 1;
  l932:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "ListContinuationBlock"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_ListBlock(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyDo(G, yyPush, 1, 0, "yyPush");
  yyprintfv((stderr, "%s\n", "ListBlock"));
  if (!yy_StartList(G))  goto l937;
  yyDo(G, yySet, -1, 0, "yySet");

  {  int yypos938= G->pos, yythunkpos938= G->thunkpos;  if (!yy_BlankLine(G))  goto l938;
  goto l937;
  l938:;	  G->pos= yypos938; G->thunkpos= yythunkpos938;
  }  if (!yy_Line(G))  goto l937;
  yyDo(G, yy_1_ListBlock, G->begin, G->end, "yy_1_ListBlock");

  l939:;	
  {  int yypos940= G->pos, yythunkpos940= G->thunkpos;  if (!yy_ListBlockLine(G))  goto l940;
  yyDo(G, yy_2_ListBlock, G->begin, G->end, "yy_2_ListBlock");
  goto l939;
  l940:;	  G->pos= yypos940; G->thunkpos= yythunkpos940;
  }  yyDo(G, yy_3_ListBlock, G->begin, G->end, "yy_3_ListBlock");
  yyprintf((stderr, "  ok   ListBlock"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));
  yyDo(G, yyPop, 1, 0, "yyPop");
  return 1;
  l937:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "ListBlock"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_ListItem(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyDo(G, yyPush, 1, 0, "yyPush");
  yyprintfv((stderr, "%s\n", "ListItem"));
  yyText(G, G->begin, G->end);  if (!(YY_BEGIN)) goto l941;
  {  int yypos942= G->pos, yythunkpos942= G->thunkpos;  if (!yy_Bullet(G))  goto l943;
  goto l942;
  l943:;	  G->pos= yypos942; G->thunkpos= yythunkpos942;  if (!yy_Enumerator(G))  goto l941;

  }
  l942:;	  yyText(G, G->begin, G->end);  if (!(YY_END)) goto l941;  if (!yy_StartList(G))  goto l941;
  yyDo(G, yySet, -1, 0, "yySet");
  if (!yy_ListBlock(G))  goto l941;
  yyDo(G, yy_1_ListItem, G->begin, G->end, "yy_1_ListItem");

  l944:;	
  {  int yypos945= G->pos, yythunkpos945= G->thunkpos;  if (!yy_ListContinuationBlock(G))  goto l945;
  yyDo(G, yy_2_ListItem, G->begin, G->end, "yy_2_ListItem");
  goto l944;
  l945:;	  G->pos= yypos945; G->thunkpos= yythunkpos945;
  }  yyDo(G, yy_3_ListItem, G->begin, G->end, "yy_3_ListItem");
  yyprintf((stderr, "  ok   ListItem"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));
  yyDo(G, yyPop, 1, 0, "yyPop");
  return 1;
  l941:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "ListItem"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_Enumerator(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "Enumerator"));
  if (!yy_NonindentSpace(G))  goto l946;
  if (!yymatchClass(G, (unsigned char *)"\000\000\000\000\000\000\377\003\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000", "0-9")) goto l946;

  l947:;	
  {  int yypos948= G->pos, yythunkpos948= G->thunkpos;  if (!yymatchClass(G, (unsigned char *)"\000\000\000\000\000\000\377\003\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000", "0-9")) goto l948;
  goto l947;
  l948:;	  G->pos= yypos948; G->thunkpos= yythunkpos948;
  }  if (!yymatchChar(G, '.')) goto l946;
  if (!yy_Spacechar(G))  goto l946;

  l949:;	
  {  int yypos950= G->pos, yythunkpos950= G->thunkpos;  if (!yy_Spacechar(G))  goto l950;
  goto l949;
  l950:;	  G->pos= yypos950; G->thunkpos= yythunkpos950;
  }  yyprintf((stderr, "  ok   Enumerator"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l946:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "Enumerator"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_ListItemTight(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyDo(G, yyPush, 1, 0, "yyPush");
  yyprintfv((stderr, "%s\n", "ListItemTight"));

  {  int yypos952= G->pos, yythunkpos952= G->thunkpos;  if (!yy_Bullet(G))  goto l953;
  goto l952;
  l953:;	  G->pos= yypos952; G->thunkpos= yythunkpos952;  if (!yy_Enumerator(G))  goto l951;

  }
  l952:;	  if (!yy_StartList(G))  goto l951;
  yyDo(G, yySet, -1, 0, "yySet");
  if (!yy_ListBlock(G))  goto l951;
  yyDo(G, yy_1_ListItemTight, G->begin, G->end, "yy_1_ListItemTight");

  l954:;	
  {  int yypos955= G->pos, yythunkpos955= G->thunkpos;
  {  int yypos956= G->pos, yythunkpos956= G->thunkpos;  if (!yy_BlankLine(G))  goto l956;
  goto l955;
  l956:;	  G->pos= yypos956; G->thunkpos= yythunkpos956;
  }  if (!yy_ListContinuationBlock(G))  goto l955;
  yyDo(G, yy_2_ListItemTight, G->begin, G->end, "yy_2_ListItemTight");
  goto l954;
  l955:;	  G->pos= yypos955; G->thunkpos= yythunkpos955;
  }
  {  int yypos957= G->pos, yythunkpos957= G->thunkpos;  if (!yy_ListContinuationBlock(G))  goto l957;
  goto l951;
  l957:;	  G->pos= yypos957; G->thunkpos= yythunkpos957;
  }  yyDo(G, yy_3_ListItemTight, G->begin, G->end, "yy_3_ListItemTight");
  yyprintf((stderr, "  ok   ListItemTight"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));
  yyDo(G, yyPop, 1, 0, "yyPop");
  return 1;
  l951:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "ListItemTight"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_ListLoose(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyDo(G, yyPush, 2, 0, "yyPush");
  yyprintfv((stderr, "%s\n", "ListLoose"));
  if (!yy_StartList(G))  goto l958;
  yyDo(G, yySet, -2, 0, "yySet");
  if (!yy_ListItem(G))  goto l958;
  yyDo(G, yySet, -1, 0, "yySet");

  l961:;	
  {  int yypos962= G->pos, yythunkpos962= G->thunkpos;  if (!yy_BlankLine(G))  goto l962;
  goto l961;
  l962:;	  G->pos= yypos962; G->thunkpos= yythunkpos962;
  }  yyDo(G, yy_1_ListLoose, G->begin, G->end, "yy_1_ListLoose");

  l959:;	
  {  int yypos960= G->pos, yythunkpos960= G->thunkpos;  if (!yy_ListItem(G))  goto l960;
  yyDo(G, yySet, -1, 0, "yySet");

  l963:;	
  {  int yypos964= G->pos, yythunkpos964= G->thunkpos;  if (!yy_BlankLine(G))  goto l964;
  goto l963;
  l964:;	  G->pos= yypos964; G->thunkpos= yythunkpos964;
  }  yyDo(G, yy_1_ListLoose, G->begin, G->end, "yy_1_ListLoose");
  goto l959;
  l960:;	  G->pos= yypos960; G->thunkpos= yythunkpos960;
  }  yyDo(G, yy_2_ListLoose, G->begin, G->end, "yy_2_ListLoose");
  yyprintf((stderr, "  ok   ListLoose"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));
  yyDo(G, yyPop, 2, 0, "yyPop");
  return 1;
  l958:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "ListLoose"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_ListTight(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyDo(G, yyPush, 1, 0, "yyPush");
  yyprintfv((stderr, "%s\n", "ListTight"));
  if (!yy_StartList(G))  goto l965;
  yyDo(G, yySet, -1, 0, "yySet");
  if (!yy_ListItemTight(G))  goto l965;
  yyDo(G, yy_1_ListTight, G->begin, G->end, "yy_1_ListTight");

  l966:;	
  {  int yypos967= G->pos, yythunkpos967= G->thunkpos;  if (!yy_ListItemTight(G))  goto l967;
  yyDo(G, yy_1_ListTight, G->begin, G->end, "yy_1_ListTight");
  goto l966;
  l967:;	  G->pos= yypos967; G->thunkpos= yythunkpos967;
  }
  l968:;	
  {  int yypos969= G->pos, yythunkpos969= G->thunkpos;  if (!yy_BlankLine(G))  goto l969;
  goto l968;
  l969:;	  G->pos= yypos969; G->thunkpos= yythunkpos969;
  }
  {  int yypos970= G->pos, yythunkpos970= G->thunkpos;
  {  int yypos971= G->pos, yythunkpos971= G->thunkpos;  if (!yy_Bullet(G))  goto l972;
  goto l971;
  l972:;	  G->pos= yypos971; G->thunkpos= yythunkpos971;  if (!yy_Enumerator(G))  goto l970;

  }
  l971:;	  goto l965;
  l970:;	  G->pos= yypos970; G->thunkpos= yythunkpos970;
  }  yyDo(G, yy_2_ListTight, G->begin, G->end, "yy_2_ListTight");
  yyprintf((stderr, "  ok   ListTight"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));
  yyDo(G, yyPop, 1, 0, "yyPop");
  return 1;
  l965:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "ListTight"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_Bullet(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "Bullet"));

  {  int yypos974= G->pos, yythunkpos974= G->thunkpos;  if (!yy_HorizontalRule(G))  goto l974;
  goto l973;
  l974:;	  G->pos= yypos974; G->thunkpos= yythunkpos974;
  }  if (!yy_NonindentSpace(G))  goto l973;

  {  int yypos975= G->pos, yythunkpos975= G->thunkpos;  if (!yymatchChar(G, '+')) goto l976;
  goto l975;
  l976:;	  G->pos= yypos975; G->thunkpos= yythunkpos975;  if (!yymatchChar(G, '*')) goto l977;
  goto l975;
  l977:;	  G->pos= yypos975; G->thunkpos= yythunkpos975;  if (!yymatchChar(G, '-')) goto l973;

  }
  l975:;	  if (!yy_Spacechar(G))  goto l973;

  l978:;	
  {  int yypos979= G->pos, yythunkpos979= G->thunkpos;  if (!yy_Spacechar(G))  goto l979;
  goto l978;
  l979:;	  G->pos= yypos979; G->thunkpos= yythunkpos979;
  }  yyprintf((stderr, "  ok   Bullet"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l973:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "Bullet"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_Definition(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyDo(G, yyPush, 2, 0, "yyPush");
  yyprintfv((stderr, "%s\n", "Definition"));
  if (!yy_StartList(G))  goto l980;
  yyDo(G, yySet, -2, 0, "yySet");
  if (!yy_StartList(G))  goto l980;
  yyDo(G, yySet, -1, 0, "yySet");

  {  int yypos981= G->pos, yythunkpos981= G->thunkpos;  if (!yy_BlankLine(G))  goto l981;
  yyDo(G, yy_1_Definition, G->begin, G->end, "yy_1_Definition");
  goto l982;
  l981:;	  G->pos= yypos981; G->thunkpos= yythunkpos981;
  }
  l982:;	  if (!yy_NonindentSpace(G))  goto l980;
  if (!yymatchChar(G, ':')) goto l980;
  if (!yy_Sp(G))  goto l980;
  if (!yy_RawLine(G))  goto l980;
  yyDo(G, yy_2_Definition, G->begin, G->end, "yy_2_Definition");

  l983:;	
  {  int yypos984= G->pos, yythunkpos984= G->thunkpos;
  {  int yypos985= G->pos, yythunkpos985= G->thunkpos;  if (!yymatchChar(G, ':')) goto l985;
  goto l984;
  l985:;	  G->pos= yypos985; G->thunkpos= yythunkpos985;
  }
  {  int yypos986= G->pos, yythunkpos986= G->thunkpos;  if (!yy_BlankLine(G))  goto l986;
  goto l984;
  l986:;	  G->pos= yypos986; G->thunkpos= yythunkpos986;
  }  if (!yy_RawLine(G))  goto l984;
  yyDo(G, yy_3_Definition, G->begin, G->end, "yy_3_Definition");
  goto l983;
  l984:;	  G->pos= yypos984; G->thunkpos= yythunkpos984;
  }
  l987:;	
  {  int yypos988= G->pos, yythunkpos988= G->thunkpos;  if (!yy_BlankLine(G))  goto l988;
  yyDo(G, yy_4_Definition, G->begin, G->end, "yy_4_Definition");
  if (!yy_IndentedLine(G))  goto l988;
  yyDo(G, yy_5_Definition, G->begin, G->end, "yy_5_Definition");

  l989:;	
  {  int yypos990= G->pos, yythunkpos990= G->thunkpos;  if (!yy_IndentedLine(G))  goto l990;
  yyDo(G, yy_5_Definition, G->begin, G->end, "yy_5_Definition");
  goto l989;
  l990:;	  G->pos= yypos990; G->thunkpos= yythunkpos990;
  }  yyDo(G, yy_6_Definition, G->begin, G->end, "yy_6_Definition");
  goto l987;
  l988:;	  G->pos= yypos988; G->thunkpos= yythunkpos988;
  }  yyDo(G, yy_7_Definition, G->begin, G->end, "yy_7_Definition");
  yyprintf((stderr, "  ok   Definition"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));
  yyDo(G, yyPop, 2, 0, "yyPop");
  return 1;
  l980:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "Definition"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_Term(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyDo(G, yyPush, 1, 0, "yyPush");
  yyprintfv((stderr, "%s\n", "Term"));
  if (!yy_StartList(G))  goto l991;
  yyDo(G, yySet, -1, 0, "yySet");

  {  int yypos992= G->pos, yythunkpos992= G->thunkpos;  if (!yy_BlankLine(G))  goto l992;
  goto l991;
  l992:;	  G->pos= yypos992; G->thunkpos= yythunkpos992;
  }
  {  int yypos993= G->pos, yythunkpos993= G->thunkpos;  if (!yymatchChar(G, ':')) goto l993;
  goto l991;
  l993:;	  G->pos= yypos993; G->thunkpos= yythunkpos993;
  }
  {  int yypos996= G->pos, yythunkpos996= G->thunkpos;  if (!yy_Newline(G))  goto l996;
  goto l991;
  l996:;	  G->pos= yypos996; G->thunkpos= yythunkpos996;
  }
  {  int yypos997= G->pos, yythunkpos997= G->thunkpos;  if (!yy_Endline(G))  goto l997;
  goto l991;
  l997:;	  G->pos= yypos997; G->thunkpos= yythunkpos997;
  }  if (!yy_Inline(G))  goto l991;
  yyDo(G, yy_1_Term, G->begin, G->end, "yy_1_Term");

  l994:;	
  {  int yypos995= G->pos, yythunkpos995= G->thunkpos;
  {  int yypos998= G->pos, yythunkpos998= G->thunkpos;  if (!yy_Newline(G))  goto l998;
  goto l995;
  l998:;	  G->pos= yypos998; G->thunkpos= yythunkpos998;
  }
  {  int yypos999= G->pos, yythunkpos999= G->thunkpos;  if (!yy_Endline(G))  goto l999;
  goto l995;
  l999:;	  G->pos= yypos999; G->thunkpos= yythunkpos999;
  }  if (!yy_Inline(G))  goto l995;
  yyDo(G, yy_1_Term, G->begin, G->end, "yy_1_Term");
  goto l994;
  l995:;	  G->pos= yypos995; G->thunkpos= yythunkpos995;
  }  if (!yy_Newline(G))  goto l991;
  yyDo(G, yy_2_Term, G->begin, G->end, "yy_2_Term");
  yyprintf((stderr, "  ok   Term"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));
  yyDo(G, yyPop, 1, 0, "yyPop");
  return 1;
  l991:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "Term"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_TermLine(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "TermLine"));

  {  int yypos1001= G->pos, yythunkpos1001= G->thunkpos;  if (!yymatchChar(G, ':')) goto l1001;
  goto l1000;
  l1001:;	  G->pos= yypos1001; G->thunkpos= yythunkpos1001;
  }
  {  int yypos1002= G->pos, yythunkpos1002= G->thunkpos;  if (!yy_BlankLine(G))  goto l1002;
  goto l1000;
  l1002:;	  G->pos= yypos1002; G->thunkpos= yythunkpos1002;
  }
  l1003:;	
  {  int yypos1004= G->pos, yythunkpos1004= G->thunkpos;
  {  int yypos1005= G->pos, yythunkpos1005= G->thunkpos;  if (!yy_Newline(G))  goto l1005;
  goto l1004;
  l1005:;	  G->pos= yypos1005; G->thunkpos= yythunkpos1005;
  }  if (!yymatchDot(G)) goto l1004;  goto l1003;
  l1004:;	  G->pos= yypos1004; G->thunkpos= yythunkpos1004;
  }  if (!yy_Newline(G))  goto l1000;
  yyprintf((stderr, "  ok   TermLine"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l1000:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "TermLine"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_VerbatimChunk(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyDo(G, yyPush, 1, 0, "yyPush");
  yyprintfv((stderr, "%s\n", "VerbatimChunk"));
  if (!yy_StartList(G))  goto l1006;
  yyDo(G, yySet, -1, 0, "yySet");

  l1007:;	
  {  int yypos1008= G->pos, yythunkpos1008= G->thunkpos;  if (!yy_BlankLine(G))  goto l1008;
  yyDo(G, yy_1_VerbatimChunk, G->begin, G->end, "yy_1_VerbatimChunk");
  goto l1007;
  l1008:;	  G->pos= yypos1008; G->thunkpos= yythunkpos1008;
  }  if (!yy_NonblankIndentedLine(G))  goto l1006;
  yyDo(G, yy_2_VerbatimChunk, G->begin, G->end, "yy_2_VerbatimChunk");

  l1009:;	
  {  int yypos1010= G->pos, yythunkpos1010= G->thunkpos;  if (!yy_NonblankIndentedLine(G))  goto l1010;
  yyDo(G, yy_2_VerbatimChunk, G->begin, G->end, "yy_2_VerbatimChunk");
  goto l1009;
  l1010:;	  G->pos= yypos1010; G->thunkpos= yythunkpos1010;
  }  yyDo(G, yy_3_VerbatimChunk, G->begin, G->end, "yy_3_VerbatimChunk");
  yyprintf((stderr, "  ok   VerbatimChunk"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));
  yyDo(G, yyPop, 1, 0, "yyPop");
  return 1;
  l1006:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "VerbatimChunk"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_NonblankIndentedLine(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "NonblankIndentedLine"));

  {  int yypos1012= G->pos, yythunkpos1012= G->thunkpos;  if (!yy_BlankLine(G))  goto l1012;
  goto l1011;
  l1012:;	  G->pos= yypos1012; G->thunkpos= yythunkpos1012;
  }  if (!yy_IndentedLine(G))  goto l1011;
  yyprintf((stderr, "  ok   NonblankIndentedLine"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l1011:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "NonblankIndentedLine"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_DoubleQuoteEnd(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "DoubleQuoteEnd"));
  if (!yymatchChar(G, '"')) goto l1013;
  yyprintf((stderr, "  ok   DoubleQuoteEnd"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l1013:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "DoubleQuoteEnd"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_DoubleQuoteStart(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "DoubleQuoteStart"));
  if (!yymatchChar(G, '"')) goto l1014;
  yyprintf((stderr, "  ok   DoubleQuoteStart"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l1014:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "DoubleQuoteStart"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_SingleQuoteEnd(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "SingleQuoteEnd"));
  if (!yymatchChar(G, '\'')) goto l1015;

  {  int yypos1016= G->pos, yythunkpos1016= G->thunkpos;  if (!yy_Alphanumeric(G))  goto l1016;
  goto l1015;
  l1016:;	  G->pos= yypos1016; G->thunkpos= yythunkpos1016;
  }  yyprintf((stderr, "  ok   SingleQuoteEnd"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l1015:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "SingleQuoteEnd"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_SingleQuoteStart(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "SingleQuoteStart"));
  if (!yymatchChar(G, '\'')) goto l1017;

  {  int yypos1018= G->pos, yythunkpos1018= G->thunkpos;
  {  int yypos1019= G->pos, yythunkpos1019= G->thunkpos;  if (!yy_Spacechar(G))  goto l1020;
  goto l1019;
  l1020:;	  G->pos= yypos1019; G->thunkpos= yythunkpos1019;  if (!yy_Newline(G))  goto l1018;

  }
  l1019:;	  goto l1017;
  l1018:;	  G->pos= yypos1018; G->thunkpos= yythunkpos1018;
  }  yyprintf((stderr, "  ok   SingleQuoteStart"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l1017:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "SingleQuoteStart"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_EnDash(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "EnDash"));
  yyText(G, G->begin, G->end);  if (!(YY_BEGIN)) goto l1021;
  {  int yypos1022= G->pos, yythunkpos1022= G->thunkpos;  if (!yymatchString(G, "--")) goto l1023;
  goto l1022;
  l1023:;	  G->pos= yypos1022; G->thunkpos= yythunkpos1022;  if (!yymatchChar(G, '-')) goto l1021;

  {  int yypos1024= G->pos, yythunkpos1024= G->thunkpos;  if (!yy_Digit(G))  goto l1021;
  G->pos= yypos1024; G->thunkpos= yythunkpos1024;
  }
  }
  l1022:;	  yyText(G, G->begin, G->end);  if (!(YY_END)) goto l1021;  yyDo(G, yy_1_EnDash, G->begin, G->end, "yy_1_EnDash");
  yyprintf((stderr, "  ok   EnDash"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l1021:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "EnDash"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_EmDash(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "EmDash"));
  yyText(G, G->begin, G->end);  if (!(YY_BEGIN)) goto l1025;  if (!yymatchString(G, "---")) goto l1025;
  yyText(G, G->begin, G->end);  if (!(YY_END)) goto l1025;  yyDo(G, yy_1_EmDash, G->begin, G->end, "yy_1_EmDash");
  yyprintf((stderr, "  ok   EmDash"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l1025:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "EmDash"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_Apostrophe(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "Apostrophe"));
  if (!yymatchChar(G, '\'')) goto l1026;
  yyDo(G, yy_1_Apostrophe, G->begin, G->end, "yy_1_Apostrophe");
  yyprintf((stderr, "  ok   Apostrophe"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l1026:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "Apostrophe"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_DoubleQuoted(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyDo(G, yyPush, 2, 0, "yyPush");
  yyprintfv((stderr, "%s\n", "DoubleQuoted"));
  if (!yy_DoubleQuoteStart(G))  goto l1027;
  if (!yy_StartList(G))  goto l1027;
  yyDo(G, yySet, -2, 0, "yySet");

  {  int yypos1030= G->pos, yythunkpos1030= G->thunkpos;  if (!yy_DoubleQuoteEnd(G))  goto l1030;
  goto l1027;
  l1030:;	  G->pos= yypos1030; G->thunkpos= yythunkpos1030;
  }  if (!yy_Inline(G))  goto l1027;
  yyDo(G, yySet, -1, 0, "yySet");
  yyDo(G, yy_1_DoubleQuoted, G->begin, G->end, "yy_1_DoubleQuoted");

  l1028:;	
  {  int yypos1029= G->pos, yythunkpos1029= G->thunkpos;
  {  int yypos1031= G->pos, yythunkpos1031= G->thunkpos;  if (!yy_DoubleQuoteEnd(G))  goto l1031;
  goto l1029;
  l1031:;	  G->pos= yypos1031; G->thunkpos= yythunkpos1031;
  }  if (!yy_Inline(G))  goto l1029;
  yyDo(G, yySet, -1, 0, "yySet");
  yyDo(G, yy_1_DoubleQuoted, G->begin, G->end, "yy_1_DoubleQuoted");
  goto l1028;
  l1029:;	  G->pos= yypos1029; G->thunkpos= yythunkpos1029;
  }  if (!yy_DoubleQuoteEnd(G))  goto l1027;
  yyDo(G, yy_2_DoubleQuoted, G->begin, G->end, "yy_2_DoubleQuoted");
  yyprintf((stderr, "  ok   DoubleQuoted"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));
  yyDo(G, yyPop, 2, 0, "yyPop");
  return 1;
  l1027:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "DoubleQuoted"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_SingleQuoted(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyDo(G, yyPush, 2, 0, "yyPush");
  yyprintfv((stderr, "%s\n", "SingleQuoted"));
  if (!yy_SingleQuoteStart(G))  goto l1032;
  if (!yy_StartList(G))  goto l1032;
  yyDo(G, yySet, -2, 0, "yySet");

  {  int yypos1035= G->pos, yythunkpos1035= G->thunkpos;  if (!yy_SingleQuoteEnd(G))  goto l1035;
  goto l1032;
  l1035:;	  G->pos= yypos1035; G->thunkpos= yythunkpos1035;
  }  if (!yy_Inline(G))  goto l1032;
  yyDo(G, yySet, -1, 0, "yySet");
  yyDo(G, yy_1_SingleQuoted, G->begin, G->end, "yy_1_SingleQuoted");

  l1033:;	
  {  int yypos1034= G->pos, yythunkpos1034= G->thunkpos;
  {  int yypos1036= G->pos, yythunkpos1036= G->thunkpos;  if (!yy_SingleQuoteEnd(G))  goto l1036;
  goto l1034;
  l1036:;	  G->pos= yypos1036; G->thunkpos= yythunkpos1036;
  }  if (!yy_Inline(G))  goto l1034;
  yyDo(G, yySet, -1, 0, "yySet");
  yyDo(G, yy_1_SingleQuoted, G->begin, G->end, "yy_1_SingleQuoted");
  goto l1033;
  l1034:;	  G->pos= yypos1034; G->thunkpos= yythunkpos1034;
  }  if (!yy_SingleQuoteEnd(G))  goto l1032;
  yyDo(G, yy_2_SingleQuoted, G->begin, G->end, "yy_2_SingleQuoted");
  yyprintf((stderr, "  ok   SingleQuoted"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));
  yyDo(G, yyPop, 2, 0, "yyPop");
  return 1;
  l1032:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "SingleQuoted"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_Dash(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "Dash"));

  {  int yypos1038= G->pos, yythunkpos1038= G->thunkpos;  if (!yy_EmDash(G))  goto l1039;
  goto l1038;
  l1039:;	  G->pos= yypos1038; G->thunkpos= yythunkpos1038;  if (!yy_EnDash(G))  goto l1037;

  }
  l1038:;	  yyprintf((stderr, "  ok   Dash"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l1037:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "Dash"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_Ellipsis(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "Ellipsis"));

  {  int yypos1041= G->pos, yythunkpos1041= G->thunkpos;  if (!yymatchString(G, "...")) goto l1042;
  goto l1041;
  l1042:;	  G->pos= yypos1041; G->thunkpos= yythunkpos1041;  if (!yymatchString(G, ". . .")) goto l1040;

  }
  l1041:;	  yyDo(G, yy_1_Ellipsis, G->begin, G->end, "yy_1_Ellipsis");
  yyprintf((stderr, "  ok   Ellipsis"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l1040:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "Ellipsis"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_Ticks5(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "Ticks5"));
  if (!yymatchString(G, "`````")) goto l1043;

  {  int yypos1044= G->pos, yythunkpos1044= G->thunkpos;  if (!yymatchChar(G, '`')) goto l1044;
  goto l1043;
  l1044:;	  G->pos= yypos1044; G->thunkpos= yythunkpos1044;
  }  yyprintf((stderr, "  ok   Ticks5"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l1043:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "Ticks5"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_Ticks4(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "Ticks4"));
  if (!yymatchString(G, "````")) goto l1045;

  {  int yypos1046= G->pos, yythunkpos1046= G->thunkpos;  if (!yymatchChar(G, '`')) goto l1046;
  goto l1045;
  l1046:;	  G->pos= yypos1046; G->thunkpos= yythunkpos1046;
  }  yyprintf((stderr, "  ok   Ticks4"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l1045:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "Ticks4"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_Ticks3(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "Ticks3"));
  if (!yymatchString(G, "```")) goto l1047;

  {  int yypos1048= G->pos, yythunkpos1048= G->thunkpos;  if (!yymatchChar(G, '`')) goto l1048;
  goto l1047;
  l1048:;	  G->pos= yypos1048; G->thunkpos= yythunkpos1048;
  }  yyprintf((stderr, "  ok   Ticks3"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l1047:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "Ticks3"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_Ticks2(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "Ticks2"));
  if (!yymatchString(G, "``")) goto l1049;

  {  int yypos1050= G->pos, yythunkpos1050= G->thunkpos;  if (!yymatchChar(G, '`')) goto l1050;
  goto l1049;
  l1050:;	  G->pos= yypos1050; G->thunkpos= yythunkpos1050;
  }  yyprintf((stderr, "  ok   Ticks2"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l1049:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "Ticks2"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_Ticks1(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "Ticks1"));
  if (!yymatchChar(G, '`')) goto l1051;

  {  int yypos1052= G->pos, yythunkpos1052= G->thunkpos;  if (!yymatchChar(G, '`')) goto l1052;
  goto l1051;
  l1052:;	  G->pos= yypos1052; G->thunkpos= yythunkpos1052;
  }  yyprintf((stderr, "  ok   Ticks1"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l1051:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "Ticks1"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_RawNoteBlock(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyDo(G, yyPush, 1, 0, "yyPush");
  yyprintfv((stderr, "%s\n", "RawNoteBlock"));
  if (!yy_StartList(G))  goto l1053;
  yyDo(G, yySet, -1, 0, "yySet");

  {  int yypos1056= G->pos, yythunkpos1056= G->thunkpos;  if (!yy_BlankLine(G))  goto l1056;
  goto l1053;
  l1056:;	  G->pos= yypos1056; G->thunkpos= yythunkpos1056;
  }
  {  int yypos1057= G->pos, yythunkpos1057= G->thunkpos;  if (!yy_NonindentSpace(G))  goto l1057;
  if (!yy_RawNoteReference(G))  goto l1057;
  goto l1053;
  l1057:;	  G->pos= yypos1057; G->thunkpos= yythunkpos1057;
  }  if (!yy_OptionallyIndentedLine(G))  goto l1053;
  yyDo(G, yy_1_RawNoteBlock, G->begin, G->end, "yy_1_RawNoteBlock");

  l1054:;	
  {  int yypos1055= G->pos, yythunkpos1055= G->thunkpos;
  {  int yypos1058= G->pos, yythunkpos1058= G->thunkpos;  if (!yy_BlankLine(G))  goto l1058;
  goto l1055;
  l1058:;	  G->pos= yypos1058; G->thunkpos= yythunkpos1058;
  }
  {  int yypos1059= G->pos, yythunkpos1059= G->thunkpos;  if (!yy_NonindentSpace(G))  goto l1059;
  if (!yy_RawNoteReference(G))  goto l1059;
  goto l1055;
  l1059:;	  G->pos= yypos1059; G->thunkpos= yythunkpos1059;
  }  if (!yy_OptionallyIndentedLine(G))  goto l1055;
  yyDo(G, yy_1_RawNoteBlock, G->begin, G->end, "yy_1_RawNoteBlock");
  goto l1054;
  l1055:;	  G->pos= yypos1055; G->thunkpos= yythunkpos1055;
  }  yyText(G, G->begin, G->end);  if (!(YY_BEGIN)) goto l1053;
  l1060:;	
  {  int yypos1061= G->pos, yythunkpos1061= G->thunkpos;  if (!yy_BlankLine(G))  goto l1061;
  goto l1060;
  l1061:;	  G->pos= yypos1061; G->thunkpos= yythunkpos1061;
  }  yyText(G, G->begin, G->end);  if (!(YY_END)) goto l1053;  yyDo(G, yy_2_RawNoteBlock, G->begin, G->end, "yy_2_RawNoteBlock");
  yyDo(G, yy_3_RawNoteBlock, G->begin, G->end, "yy_3_RawNoteBlock");
  yyprintf((stderr, "  ok   RawNoteBlock"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));
  yyDo(G, yyPop, 1, 0, "yyPop");
  return 1;
  l1053:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "RawNoteBlock"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_GlossarySortKey(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "GlossarySortKey"));
  if (!yymatchChar(G, '(')) goto l1062;
  yyText(G, G->begin, G->end);  if (!(YY_BEGIN)) goto l1062;
  l1063:;	
  {  int yypos1064= G->pos, yythunkpos1064= G->thunkpos;
  {  int yypos1065= G->pos, yythunkpos1065= G->thunkpos;  if (!yymatchChar(G, ')')) goto l1065;
  goto l1064;
  l1065:;	  G->pos= yypos1065; G->thunkpos= yythunkpos1065;
  }
  {  int yypos1066= G->pos, yythunkpos1066= G->thunkpos;  if (!yy_Newline(G))  goto l1066;
  goto l1064;
  l1066:;	  G->pos= yypos1066; G->thunkpos= yythunkpos1066;
  }  if (!yymatchDot(G)) goto l1064;  goto l1063;
  l1064:;	  G->pos= yypos1064; G->thunkpos= yythunkpos1064;
  }  yyText(G, G->begin, G->end);  if (!(YY_END)) goto l1062;  if (!yymatchChar(G, ')')) goto l1062;
  yyDo(G, yy_1_GlossarySortKey, G->begin, G->end, "yy_1_GlossarySortKey");
  yyprintf((stderr, "  ok   GlossarySortKey"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l1062:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "GlossarySortKey"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_GlossaryTerm(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "GlossaryTerm"));
  yyText(G, G->begin, G->end);  if (!(YY_BEGIN)) goto l1067;
  {  int yypos1070= G->pos, yythunkpos1070= G->thunkpos;  if (!yy_Newline(G))  goto l1070;
  goto l1067;
  l1070:;	  G->pos= yypos1070; G->thunkpos= yythunkpos1070;
  }
  {  int yypos1071= G->pos, yythunkpos1071= G->thunkpos;  if (!yymatchChar(G, '(')) goto l1071;
  goto l1067;
  l1071:;	  G->pos= yypos1071; G->thunkpos= yythunkpos1071;
  }  if (!yymatchDot(G)) goto l1067;
  l1068:;	
  {  int yypos1069= G->pos, yythunkpos1069= G->thunkpos;
  {  int yypos1072= G->pos, yythunkpos1072= G->thunkpos;  if (!yy_Newline(G))  goto l1072;
  goto l1069;
  l1072:;	  G->pos= yypos1072; G->thunkpos= yythunkpos1072;
  }
  {  int yypos1073= G->pos, yythunkpos1073= G->thunkpos;  if (!yymatchChar(G, '(')) goto l1073;
  goto l1069;
  l1073:;	  G->pos= yypos1073; G->thunkpos= yythunkpos1073;
  }  if (!yymatchDot(G)) goto l1069;  goto l1068;
  l1069:;	  G->pos= yypos1069; G->thunkpos= yythunkpos1069;
  }  yyText(G, G->begin, G->end);  if (!(YY_END)) goto l1067;  yyDo(G, yy_1_GlossaryTerm, G->begin, G->end, "yy_1_GlossaryTerm");
  yyprintf((stderr, "  ok   GlossaryTerm"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l1067:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "GlossaryTerm"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_RawNoteReference(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "RawNoteReference"));

  {  int yypos1075= G->pos, yythunkpos1075= G->thunkpos;  if (!yymatchString(G, "[^")) goto l1076;
  goto l1075;
  l1076:;	  G->pos= yypos1075; G->thunkpos= yythunkpos1075;  if (!yymatchString(G, "[#")) goto l1074;

  }
  l1075:;	  yyText(G, G->begin, G->end);  if (!(YY_BEGIN)) goto l1074;
  {  int yypos1079= G->pos, yythunkpos1079= G->thunkpos;  if (!yy_Newline(G))  goto l1079;
  goto l1074;
  l1079:;	  G->pos= yypos1079; G->thunkpos= yythunkpos1079;
  }
  {  int yypos1080= G->pos, yythunkpos1080= G->thunkpos;  if (!yymatchChar(G, ']')) goto l1080;
  goto l1074;
  l1080:;	  G->pos= yypos1080; G->thunkpos= yythunkpos1080;
  }  if (!yymatchDot(G)) goto l1074;
  l1077:;	
  {  int yypos1078= G->pos, yythunkpos1078= G->thunkpos;
  {  int yypos1081= G->pos, yythunkpos1081= G->thunkpos;  if (!yy_Newline(G))  goto l1081;
  goto l1078;
  l1081:;	  G->pos= yypos1081; G->thunkpos= yythunkpos1081;
  }
  {  int yypos1082= G->pos, yythunkpos1082= G->thunkpos;  if (!yymatchChar(G, ']')) goto l1082;
  goto l1078;
  l1082:;	  G->pos= yypos1082; G->thunkpos= yythunkpos1082;
  }  if (!yymatchDot(G)) goto l1078;  goto l1077;
  l1078:;	  G->pos= yypos1078; G->thunkpos= yythunkpos1078;
  }  yyText(G, G->begin, G->end);  if (!(YY_END)) goto l1074;  if (!yymatchChar(G, ']')) goto l1074;
  yyDo(G, yy_1_RawNoteReference, G->begin, G->end, "yy_1_RawNoteReference");
  yyprintf((stderr, "  ok   RawNoteReference"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l1074:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "RawNoteReference"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_EmptyTitle(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "EmptyTitle"));
  yyText(G, G->begin, G->end);  if (!(YY_BEGIN)) goto l1083;  if (!yymatchString(G, "")) goto l1083;
  yyText(G, G->begin, G->end);  if (!(YY_END)) goto l1083;  yyprintf((stderr, "  ok   EmptyTitle"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l1083:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "EmptyTitle"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_RefTitleParens(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "RefTitleParens"));
  if (!yy_Spnl(G))  goto l1084;
  if (!yymatchChar(G, '(')) goto l1084;
  yyText(G, G->begin, G->end);  if (!(YY_BEGIN)) goto l1084;
  l1085:;	
  {  int yypos1086= G->pos, yythunkpos1086= G->thunkpos;
  {  int yypos1087= G->pos, yythunkpos1087= G->thunkpos;
  {  int yypos1088= G->pos, yythunkpos1088= G->thunkpos;  if (!yymatchChar(G, ')')) goto l1089;
  if (!yy_Sp(G))  goto l1089;
  if (!yy_Newline(G))  goto l1089;
  goto l1088;
  l1089:;	  G->pos= yypos1088; G->thunkpos= yythunkpos1088;  if (!yy_Newline(G))  goto l1090;
  goto l1088;
  l1090:;	  G->pos= yypos1088; G->thunkpos= yythunkpos1088;  yyText(G, G->begin, G->end);  if (!( !ext(EXT_COMPATIBILITY) )) goto l1087;  if (!yymatchChar(G, ')')) goto l1087;
  if (!yy_Sp(G))  goto l1087;
  if (!yy_AlphanumericAscii(G))  goto l1087;

  l1091:;	
  {  int yypos1092= G->pos, yythunkpos1092= G->thunkpos;  if (!yy_AlphanumericAscii(G))  goto l1092;
  goto l1091;
  l1092:;	  G->pos= yypos1092; G->thunkpos= yythunkpos1092;
  }  if (!yymatchChar(G, '=')) goto l1087;

  }
  l1088:;	  goto l1086;
  l1087:;	  G->pos= yypos1087; G->thunkpos= yythunkpos1087;
  }  if (!yymatchDot(G)) goto l1086;  goto l1085;
  l1086:;	  G->pos= yypos1086; G->thunkpos= yythunkpos1086;
  }  yyText(G, G->begin, G->end);  if (!(YY_END)) goto l1084;  if (!yymatchChar(G, ')')) goto l1084;
  yyprintf((stderr, "  ok   RefTitleParens"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l1084:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "RefTitleParens"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_RefTitleDouble(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "RefTitleDouble"));
  if (!yy_Spnl(G))  goto l1093;
  if (!yymatchChar(G, '"')) goto l1093;
  yyText(G, G->begin, G->end);  if (!(YY_BEGIN)) goto l1093;
  l1094:;	
  {  int yypos1095= G->pos, yythunkpos1095= G->thunkpos;
  {  int yypos1096= G->pos, yythunkpos1096= G->thunkpos;
  {  int yypos1097= G->pos, yythunkpos1097= G->thunkpos;  if (!yymatchChar(G, '"')) goto l1098;
  if (!yy_Sp(G))  goto l1098;
  if (!yy_Newline(G))  goto l1098;
  goto l1097;
  l1098:;	  G->pos= yypos1097; G->thunkpos= yythunkpos1097;  if (!yy_Newline(G))  goto l1099;
  goto l1097;
  l1099:;	  G->pos= yypos1097; G->thunkpos= yythunkpos1097;  yyText(G, G->begin, G->end);  if (!( !ext(EXT_COMPATIBILITY) )) goto l1096;  if (!yymatchChar(G, '"')) goto l1096;
  if (!yy_Sp(G))  goto l1096;
  if (!yy_AlphanumericAscii(G))  goto l1096;

  l1100:;	
  {  int yypos1101= G->pos, yythunkpos1101= G->thunkpos;  if (!yy_AlphanumericAscii(G))  goto l1101;
  goto l1100;
  l1101:;	  G->pos= yypos1101; G->thunkpos= yythunkpos1101;
  }  if (!yymatchChar(G, '=')) goto l1096;

  }
  l1097:;	  goto l1095;
  l1096:;	  G->pos= yypos1096; G->thunkpos= yythunkpos1096;
  }  if (!yymatchDot(G)) goto l1095;  goto l1094;
  l1095:;	  G->pos= yypos1095; G->thunkpos= yythunkpos1095;
  }  yyText(G, G->begin, G->end);  if (!(YY_END)) goto l1093;  if (!yymatchChar(G, '"')) goto l1093;
  yyprintf((stderr, "  ok   RefTitleDouble"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l1093:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "RefTitleDouble"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_RefTitleSingle(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "RefTitleSingle"));
  if (!yy_Spnl(G))  goto l1102;
  if (!yymatchChar(G, '\'')) goto l1102;
  yyText(G, G->begin, G->end);  if (!(YY_BEGIN)) goto l1102;
  l1103:;	
  {  int yypos1104= G->pos, yythunkpos1104= G->thunkpos;
  {  int yypos1105= G->pos, yythunkpos1105= G->thunkpos;
  {  int yypos1106= G->pos, yythunkpos1106= G->thunkpos;  if (!yymatchChar(G, '\'')) goto l1107;
  if (!yy_Sp(G))  goto l1107;
  if (!yy_Newline(G))  goto l1107;
  goto l1106;
  l1107:;	  G->pos= yypos1106; G->thunkpos= yythunkpos1106;  if (!yy_Newline(G))  goto l1108;
  goto l1106;
  l1108:;	  G->pos= yypos1106; G->thunkpos= yythunkpos1106;  yyText(G, G->begin, G->end);  if (!( !ext(EXT_COMPATIBILITY) )) goto l1105;  if (!yymatchChar(G, '\'')) goto l1105;
  if (!yy_Sp(G))  goto l1105;
  if (!yy_AlphanumericAscii(G))  goto l1105;

  l1109:;	
  {  int yypos1110= G->pos, yythunkpos1110= G->thunkpos;  if (!yy_AlphanumericAscii(G))  goto l1110;
  goto l1109;
  l1110:;	  G->pos= yypos1110; G->thunkpos= yythunkpos1110;
  }  if (!yymatchChar(G, '=')) goto l1105;

  }
  l1106:;	  goto l1104;
  l1105:;	  G->pos= yypos1105; G->thunkpos= yythunkpos1105;
  }  if (!yymatchDot(G)) goto l1104;  goto l1103;
  l1104:;	  G->pos= yypos1104; G->thunkpos= yythunkpos1104;
  }  yyText(G, G->begin, G->end);  if (!(YY_END)) goto l1102;  if (!yymatchChar(G, '\'')) goto l1102;
  yyprintf((stderr, "  ok   RefTitleSingle"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l1102:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "RefTitleSingle"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_UnQuotedValue(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "UnQuotedValue"));
  yyText(G, G->begin, G->end);  if (!(YY_BEGIN)) goto l1111;
  {  int yypos1114= G->pos, yythunkpos1114= G->thunkpos;  if (!yy_AlphanumericAscii(G))  goto l1115;
  goto l1114;
  l1115:;	  G->pos= yypos1114; G->thunkpos= yythunkpos1114;  if (!yymatchChar(G, '.')) goto l1111;

  }
  l1114:;	
  l1112:;	
  {  int yypos1113= G->pos, yythunkpos1113= G->thunkpos;
  {  int yypos1116= G->pos, yythunkpos1116= G->thunkpos;  if (!yy_AlphanumericAscii(G))  goto l1117;
  goto l1116;
  l1117:;	  G->pos= yypos1116; G->thunkpos= yythunkpos1116;  if (!yymatchChar(G, '.')) goto l1113;

  }
  l1116:;	  goto l1112;
  l1113:;	  G->pos= yypos1113; G->thunkpos= yythunkpos1113;
  }  yyText(G, G->begin, G->end);  if (!(YY_END)) goto l1111;  yyprintf((stderr, "  ok   UnQuotedValue"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l1111:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "UnQuotedValue"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_QuotedValue(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "QuotedValue"));
  if (!yymatchChar(G, '"')) goto l1118;
  yyText(G, G->begin, G->end);  if (!(YY_BEGIN)) goto l1118;
  l1119:;	
  {  int yypos1120= G->pos, yythunkpos1120= G->thunkpos;
  {  int yypos1121= G->pos, yythunkpos1121= G->thunkpos;  if (!yymatchChar(G, '"')) goto l1121;
  goto l1120;
  l1121:;	  G->pos= yypos1121; G->thunkpos= yythunkpos1121;
  }  if (!yymatchDot(G)) goto l1120;  goto l1119;
  l1120:;	  G->pos= yypos1120; G->thunkpos= yythunkpos1120;
  }  yyText(G, G->begin, G->end);  if (!(YY_END)) goto l1118;  if (!yymatchChar(G, '"')) goto l1118;
  yyprintf((stderr, "  ok   QuotedValue"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l1118:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "QuotedValue"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_AttrValue(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "AttrValue"));

  {  int yypos1123= G->pos, yythunkpos1123= G->thunkpos;  if (!yy_QuotedValue(G))  goto l1124;
  goto l1123;
  l1124:;	  G->pos= yypos1123; G->thunkpos= yythunkpos1123;  if (!yy_UnQuotedValue(G))  goto l1122;

  }
  l1123:;	  yyDo(G, yy_1_AttrValue, G->begin, G->end, "yy_1_AttrValue");
  yyprintf((stderr, "  ok   AttrValue"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l1122:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "AttrValue"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_AttrKey(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "AttrKey"));
  yyText(G, G->begin, G->end);  if (!(YY_BEGIN)) goto l1125;  if (!yy_AlphanumericAscii(G))  goto l1125;

  l1126:;	
  {  int yypos1127= G->pos, yythunkpos1127= G->thunkpos;  if (!yy_AlphanumericAscii(G))  goto l1127;
  goto l1126;
  l1127:;	  G->pos= yypos1127; G->thunkpos= yythunkpos1127;
  }  yyText(G, G->begin, G->end);  if (!(YY_END)) goto l1125;  yyDo(G, yy_1_AttrKey, G->begin, G->end, "yy_1_AttrKey");
  yyprintf((stderr, "  ok   AttrKey"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l1125:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "AttrKey"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_Attribute(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyDo(G, yyPush, 2, 0, "yyPush");
  yyprintfv((stderr, "%s\n", "Attribute"));
  if (!yy_Spnl(G))  goto l1128;
  if (!yy_AttrKey(G))  goto l1128;
  yyDo(G, yySet, -2, 0, "yySet");
  if (!yymatchChar(G, '=')) goto l1128;
  if (!yy_AttrValue(G))  goto l1128;
  yyDo(G, yySet, -1, 0, "yySet");
  yyDo(G, yy_1_Attribute, G->begin, G->end, "yy_1_Attribute");
  yyprintf((stderr, "  ok   Attribute"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));
  yyDo(G, yyPop, 2, 0, "yyPop");
  return 1;
  l1128:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "Attribute"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_Attributes(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyDo(G, yyPush, 1, 0, "yyPush");
  yyprintfv((stderr, "%s\n", "Attributes"));
  if (!yy_StartList(G))  goto l1129;
  yyDo(G, yySet, -1, 0, "yySet");
  if (!yy_Attribute(G))  goto l1129;
  yyDo(G, yy_1_Attributes, G->begin, G->end, "yy_1_Attributes");

  l1130:;	
  {  int yypos1131= G->pos, yythunkpos1131= G->thunkpos;  if (!yy_Attribute(G))  goto l1131;
  yyDo(G, yy_1_Attributes, G->begin, G->end, "yy_1_Attributes");
  goto l1130;
  l1131:;	  G->pos= yypos1131; G->thunkpos= yythunkpos1131;
  }  yyDo(G, yy_2_Attributes, G->begin, G->end, "yy_2_Attributes");
  yyprintf((stderr, "  ok   Attributes"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));
  yyDo(G, yyPop, 1, 0, "yyPop");
  return 1;
  l1129:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "Attributes"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_RefTitle(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "RefTitle"));

  {  int yypos1133= G->pos, yythunkpos1133= G->thunkpos;  if (!yy_RefTitleSingle(G))  goto l1134;
  goto l1133;
  l1134:;	  G->pos= yypos1133; G->thunkpos= yythunkpos1133;  if (!yy_RefTitleDouble(G))  goto l1135;
  goto l1133;
  l1135:;	  G->pos= yypos1133; G->thunkpos= yythunkpos1133;  if (!yy_RefTitleParens(G))  goto l1136;
  goto l1133;
  l1136:;	  G->pos= yypos1133; G->thunkpos= yythunkpos1133;  if (!yy_EmptyTitle(G))  goto l1132;

  }
  l1133:;	  yyDo(G, yy_1_RefTitle, G->begin, G->end, "yy_1_RefTitle");
  yyprintf((stderr, "  ok   RefTitle"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l1132:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "RefTitle"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_RefSrc(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "RefSrc"));
  yyText(G, G->begin, G->end);  if (!(YY_BEGIN)) goto l1137;  if (!yy_Nonspacechar(G))  goto l1137;

  l1138:;	
  {  int yypos1139= G->pos, yythunkpos1139= G->thunkpos;  if (!yy_Nonspacechar(G))  goto l1139;
  goto l1138;
  l1139:;	  G->pos= yypos1139; G->thunkpos= yythunkpos1139;
  }  yyText(G, G->begin, G->end);  if (!(YY_END)) goto l1137;  yyDo(G, yy_1_RefSrc, G->begin, G->end, "yy_1_RefSrc");
  yyprintf((stderr, "  ok   RefSrc"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l1137:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "RefSrc"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_AutoLinkEmail(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "AutoLinkEmail"));
  if (!yymatchChar(G, '<')) goto l1140;

  {  int yypos1141= G->pos, yythunkpos1141= G->thunkpos;  if (!yymatchString(G, "mailto:")) goto l1141;
  goto l1142;
  l1141:;	  G->pos= yypos1141; G->thunkpos= yythunkpos1141;
  }
  l1142:;	  yyText(G, G->begin, G->end);  if (!(YY_BEGIN)) goto l1140;  if (!yymatchClass(G, (unsigned char *)"\000\000\000\000\062\350\377\003\376\377\377\207\376\377\377\107\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000", "-A-Za-z0-9+_./!%%~$")) goto l1140;

  l1143:;	
  {  int yypos1144= G->pos, yythunkpos1144= G->thunkpos;  if (!yymatchClass(G, (unsigned char *)"\000\000\000\000\062\350\377\003\376\377\377\207\376\377\377\107\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000", "-A-Za-z0-9+_./!%%~$")) goto l1144;
  goto l1143;
  l1144:;	  G->pos= yypos1144; G->thunkpos= yythunkpos1144;
  }  if (!yymatchChar(G, '@')) goto l1140;

  {  int yypos1147= G->pos, yythunkpos1147= G->thunkpos;  if (!yy_Newline(G))  goto l1147;
  goto l1140;
  l1147:;	  G->pos= yypos1147; G->thunkpos= yythunkpos1147;
  }
  {  int yypos1148= G->pos, yythunkpos1148= G->thunkpos;  if (!yymatchChar(G, '>')) goto l1148;
  goto l1140;
  l1148:;	  G->pos= yypos1148; G->thunkpos= yythunkpos1148;
  }  if (!yymatchDot(G)) goto l1140;
  l1145:;	
  {  int yypos1146= G->pos, yythunkpos1146= G->thunkpos;
  {  int yypos1149= G->pos, yythunkpos1149= G->thunkpos;  if (!yy_Newline(G))  goto l1149;
  goto l1146;
  l1149:;	  G->pos= yypos1149; G->thunkpos= yythunkpos1149;
  }
  {  int yypos1150= G->pos, yythunkpos1150= G->thunkpos;  if (!yymatchChar(G, '>')) goto l1150;
  goto l1146;
  l1150:;	  G->pos= yypos1150; G->thunkpos= yythunkpos1150;
  }  if (!yymatchDot(G)) goto l1146;  goto l1145;
  l1146:;	  G->pos= yypos1146; G->thunkpos= yythunkpos1146;
  }  yyText(G, G->begin, G->end);  if (!(YY_END)) goto l1140;  if (!yymatchChar(G, '>')) goto l1140;
  yyDo(G, yy_1_AutoLinkEmail, G->begin, G->end, "yy_1_AutoLinkEmail");
  yyprintf((stderr, "  ok   AutoLinkEmail"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l1140:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "AutoLinkEmail"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_AutoLinkUrl(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "AutoLinkUrl"));
  if (!yymatchChar(G, '<')) goto l1151;
  yyText(G, G->begin, G->end);  if (!(YY_BEGIN)) goto l1151;  if (!yymatchClass(G, (unsigned char *)"\000\000\000\000\000\000\000\000\376\377\377\007\376\377\377\007\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000", "A-Za-z")) goto l1151;

  l1152:;	
  {  int yypos1153= G->pos, yythunkpos1153= G->thunkpos;  if (!yymatchClass(G, (unsigned char *)"\000\000\000\000\000\000\000\000\376\377\377\007\376\377\377\007\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000", "A-Za-z")) goto l1153;
  goto l1152;
  l1153:;	  G->pos= yypos1153; G->thunkpos= yythunkpos1153;
  }  if (!yymatchString(G, "://")) goto l1151;

  {  int yypos1156= G->pos, yythunkpos1156= G->thunkpos;  if (!yy_Newline(G))  goto l1156;
  goto l1151;
  l1156:;	  G->pos= yypos1156; G->thunkpos= yythunkpos1156;
  }
  {  int yypos1157= G->pos, yythunkpos1157= G->thunkpos;  if (!yymatchChar(G, '>')) goto l1157;
  goto l1151;
  l1157:;	  G->pos= yypos1157; G->thunkpos= yythunkpos1157;
  }  if (!yymatchDot(G)) goto l1151;
  l1154:;	
  {  int yypos1155= G->pos, yythunkpos1155= G->thunkpos;
  {  int yypos1158= G->pos, yythunkpos1158= G->thunkpos;  if (!yy_Newline(G))  goto l1158;
  goto l1155;
  l1158:;	  G->pos= yypos1158; G->thunkpos= yythunkpos1158;
  }
  {  int yypos1159= G->pos, yythunkpos1159= G->thunkpos;  if (!yymatchChar(G, '>')) goto l1159;
  goto l1155;
  l1159:;	  G->pos= yypos1159; G->thunkpos= yythunkpos1159;
  }  if (!yymatchDot(G)) goto l1155;  goto l1154;
  l1155:;	  G->pos= yypos1155; G->thunkpos= yythunkpos1155;
  }  yyText(G, G->begin, G->end);  if (!(YY_END)) goto l1151;  if (!yymatchChar(G, '>')) goto l1151;
  yyDo(G, yy_1_AutoLinkUrl, G->begin, G->end, "yy_1_AutoLinkUrl");
  yyprintf((stderr, "  ok   AutoLinkUrl"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l1151:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "AutoLinkUrl"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_TitleDouble(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "TitleDouble"));
  if (!yymatchChar(G, '"')) goto l1160;
  yyText(G, G->begin, G->end);  if (!(YY_BEGIN)) goto l1160;
  l1161:;	
  {  int yypos1162= G->pos, yythunkpos1162= G->thunkpos;
  {  int yypos1163= G->pos, yythunkpos1163= G->thunkpos;  if (!yymatchChar(G, '"')) goto l1163;
  if (!yy_Sp(G))  goto l1163;

  {  int yypos1164= G->pos, yythunkpos1164= G->thunkpos;  if (!yymatchChar(G, ')')) goto l1165;
  goto l1164;
  l1165:;	  G->pos= yypos1164; G->thunkpos= yythunkpos1164;  if (!yy_Newline(G))  goto l1163;

  }
  l1164:;	  goto l1162;
  l1163:;	  G->pos= yypos1163; G->thunkpos= yythunkpos1163;
  }  if (!yymatchDot(G)) goto l1162;  goto l1161;
  l1162:;	  G->pos= yypos1162; G->thunkpos= yythunkpos1162;
  }  yyText(G, G->begin, G->end);  if (!(YY_END)) goto l1160;  if (!yymatchChar(G, '"')) goto l1160;
  yyprintf((stderr, "  ok   TitleDouble"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l1160:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "TitleDouble"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_TitleSingle(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "TitleSingle"));
  if (!yymatchChar(G, '\'')) goto l1166;
  yyText(G, G->begin, G->end);  if (!(YY_BEGIN)) goto l1166;
  l1167:;	
  {  int yypos1168= G->pos, yythunkpos1168= G->thunkpos;
  {  int yypos1169= G->pos, yythunkpos1169= G->thunkpos;  if (!yymatchChar(G, '\'')) goto l1169;
  if (!yy_Sp(G))  goto l1169;

  {  int yypos1170= G->pos, yythunkpos1170= G->thunkpos;  if (!yymatchChar(G, ')')) goto l1171;
  goto l1170;
  l1171:;	  G->pos= yypos1170; G->thunkpos= yythunkpos1170;  if (!yy_Newline(G))  goto l1169;

  }
  l1170:;	  goto l1168;
  l1169:;	  G->pos= yypos1169; G->thunkpos= yythunkpos1169;
  }  if (!yymatchDot(G)) goto l1168;  goto l1167;
  l1168:;	  G->pos= yypos1168; G->thunkpos= yythunkpos1168;
  }  yyText(G, G->begin, G->end);  if (!(YY_END)) goto l1166;  if (!yymatchChar(G, '\'')) goto l1166;
  yyprintf((stderr, "  ok   TitleSingle"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l1166:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "TitleSingle"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_SourceContents(GREG *G)
{  yyprintfv((stderr, "%s\n", "SourceContents"));

  l1173:;	
  {  int yypos1174= G->pos, yythunkpos1174= G->thunkpos;
  {  int yypos1175= G->pos, yythunkpos1175= G->thunkpos;
  {  int yypos1179= G->pos, yythunkpos1179= G->thunkpos;  if (!yymatchChar(G, '(')) goto l1179;
  goto l1176;
  l1179:;	  G->pos= yypos1179; G->thunkpos= yythunkpos1179;
  }
  {  int yypos1180= G->pos, yythunkpos1180= G->thunkpos;  if (!yymatchChar(G, ')')) goto l1180;
  goto l1176;
  l1180:;	  G->pos= yypos1180; G->thunkpos= yythunkpos1180;
  }
  {  int yypos1181= G->pos, yythunkpos1181= G->thunkpos;  if (!yymatchChar(G, '>')) goto l1181;
  goto l1176;
  l1181:;	  G->pos= yypos1181; G->thunkpos= yythunkpos1181;
  }  if (!yy_Nonspacechar(G))  goto l1176;

  l1177:;	
  {  int yypos1178= G->pos, yythunkpos1178= G->thunkpos;
  {  int yypos1182= G->pos, yythunkpos1182= G->thunkpos;  if (!yymatchChar(G, '(')) goto l1182;
  goto l1178;
  l1182:;	  G->pos= yypos1182; G->thunkpos= yythunkpos1182;
  }
  {  int yypos1183= G->pos, yythunkpos1183= G->thunkpos;  if (!yymatchChar(G, ')')) goto l1183;
  goto l1178;
  l1183:;	  G->pos= yypos1183; G->thunkpos= yythunkpos1183;
  }
  {  int yypos1184= G->pos, yythunkpos1184= G->thunkpos;  if (!yymatchChar(G, '>')) goto l1184;
  goto l1178;
  l1184:;	  G->pos= yypos1184; G->thunkpos= yythunkpos1184;
  }  if (!yy_Nonspacechar(G))  goto l1178;
  goto l1177;
  l1178:;	  G->pos= yypos1178; G->thunkpos= yythunkpos1178;
  }  goto l1175;
  l1176:;	  G->pos= yypos1175; G->thunkpos= yythunkpos1175;  if (!yymatchChar(G, '(')) goto l1174;
  if (!yy_SourceContents(G))  goto l1174;
  if (!yymatchChar(G, ')')) goto l1174;

  }
  l1175:;	  goto l1173;
  l1174:;	  G->pos= yypos1174; G->thunkpos= yythunkpos1174;
  }  yyprintf((stderr, "  ok   SourceContents"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
}
YY_RULE(int) yy_Title(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "Title"));

  {  int yypos1186= G->pos, yythunkpos1186= G->thunkpos;  if (!yy_TitleSingle(G))  goto l1187;
  goto l1186;
  l1187:;	  G->pos= yypos1186; G->thunkpos= yythunkpos1186;  if (!yy_TitleDouble(G))  goto l1188;
  goto l1186;
  l1188:;	  G->pos= yypos1186; G->thunkpos= yythunkpos1186;  yyText(G, G->begin, G->end);  if (!(YY_BEGIN)) goto l1185;  if (!yymatchString(G, "")) goto l1185;
  yyText(G, G->begin, G->end);  if (!(YY_END)) goto l1185;
  }
  l1186:;	  yyDo(G, yy_1_Title, G->begin, G->end, "yy_1_Title");
  yyprintf((stderr, "  ok   Title"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l1185:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "Title"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_Source(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "Source"));

  {  int yypos1190= G->pos, yythunkpos1190= G->thunkpos;  if (!yymatchChar(G, '<')) goto l1191;
  yyText(G, G->begin, G->end);  if (!(YY_BEGIN)) goto l1191;  if (!yy_SourceContents(G))  goto l1191;
  yyText(G, G->begin, G->end);  if (!(YY_END)) goto l1191;  if (!yymatchChar(G, '>')) goto l1191;
  goto l1190;
  l1191:;	  G->pos= yypos1190; G->thunkpos= yythunkpos1190;  yyText(G, G->begin, G->end);  if (!(YY_BEGIN)) goto l1189;  if (!yy_SourceContents(G))  goto l1189;
  yyText(G, G->begin, G->end);  if (!(YY_END)) goto l1189;
  }
  l1190:;	  yyDo(G, yy_1_Source, G->begin, G->end, "yy_1_Source");
  yyprintf((stderr, "  ok   Source"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l1189:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "Source"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_RawCitationReference(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "RawCitationReference"));
  if (!yymatchString(G, "[#")) goto l1192;
  yyText(G, G->begin, G->end);  if (!(YY_BEGIN)) goto l1192;
  {  int yypos1195= G->pos, yythunkpos1195= G->thunkpos;  if (!yy_Newline(G))  goto l1195;
  goto l1192;
  l1195:;	  G->pos= yypos1195; G->thunkpos= yythunkpos1195;
  }
  {  int yypos1196= G->pos, yythunkpos1196= G->thunkpos;  if (!yymatchChar(G, ']')) goto l1196;
  goto l1192;
  l1196:;	  G->pos= yypos1196; G->thunkpos= yythunkpos1196;
  }  if (!yymatchDot(G)) goto l1192;
  l1193:;	
  {  int yypos1194= G->pos, yythunkpos1194= G->thunkpos;
  {  int yypos1197= G->pos, yythunkpos1197= G->thunkpos;  if (!yy_Newline(G))  goto l1197;
  goto l1194;
  l1197:;	  G->pos= yypos1197; G->thunkpos= yythunkpos1197;
  }
  {  int yypos1198= G->pos, yythunkpos1198= G->thunkpos;  if (!yymatchChar(G, ']')) goto l1198;
  goto l1194;
  l1198:;	  G->pos= yypos1198; G->thunkpos= yythunkpos1198;
  }  if (!yymatchDot(G)) goto l1194;  goto l1193;
  l1194:;	  G->pos= yypos1194; G->thunkpos= yythunkpos1194;
  }  yyText(G, G->begin, G->end);  if (!(YY_END)) goto l1192;  if (!yymatchChar(G, ']')) goto l1192;
  yyDo(G, yy_1_RawCitationReference, G->begin, G->end, "yy_1_RawCitationReference");
  yyprintf((stderr, "  ok   RawCitationReference"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l1192:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "RawCitationReference"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_CitationReferenceSingle(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyDo(G, yyPush, 1, 0, "yyPush");
  yyprintfv((stderr, "%s\n", "CitationReferenceSingle"));
  yyText(G, G->begin, G->end);  if (!(YY_BEGIN)) goto l1199;
  {  int yypos1200= G->pos, yythunkpos1200= G->thunkpos;  if (!yymatchString(G, "[]")) goto l1201;
  if (!yy_Spnl(G))  goto l1201;
  if (!yy_RawCitationReference(G))  goto l1201;
  yyDo(G, yySet, -1, 0, "yySet");
  goto l1200;
  l1201:;	  G->pos= yypos1200; G->thunkpos= yythunkpos1200;  if (!yy_RawCitationReference(G))  goto l1199;
  yyDo(G, yySet, -1, 0, "yySet");

  {  int yypos1202= G->pos, yythunkpos1202= G->thunkpos;  if (!yy_Spnl(G))  goto l1202;
  if (!yymatchString(G, "[]")) goto l1202;
  goto l1203;
  l1202:;	  G->pos= yypos1202; G->thunkpos= yythunkpos1202;
  }
  l1203:;	
  }
  l1200:;	  yyText(G, G->begin, G->end);  if (!(YY_END)) goto l1199;  yyDo(G, yy_1_CitationReferenceSingle, G->begin, G->end, "yy_1_CitationReferenceSingle");
  yyprintf((stderr, "  ok   CitationReferenceSingle"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));
  yyDo(G, yyPop, 1, 0, "yyPop");
  return 1;
  l1199:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "CitationReferenceSingle"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_CitationReferenceDouble(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyDo(G, yyPush, 2, 0, "yyPush");
  yyprintfv((stderr, "%s\n", "CitationReferenceDouble"));

  {  int yypos1205= G->pos, yythunkpos1205= G->thunkpos;  if (!yymatchString(G, "[]")) goto l1205;
  goto l1204;
  l1205:;	  G->pos= yypos1205; G->thunkpos= yythunkpos1205;
  }  if (!yy_Label(G))  goto l1204;
  yyDo(G, yySet, -2, 0, "yySet");
  yyText(G, G->begin, G->end);  if (!(YY_BEGIN)) goto l1204;  if (!yy_Spnl(G))  goto l1204;
  yyText(G, G->begin, G->end);  if (!(YY_END)) goto l1204;
  {  int yypos1206= G->pos, yythunkpos1206= G->thunkpos;  if (!yymatchString(G, "[]")) goto l1206;
  goto l1204;
  l1206:;	  G->pos= yypos1206; G->thunkpos= yythunkpos1206;
  }  if (!yy_RawCitationReference(G))  goto l1204;
  yyDo(G, yySet, -1, 0, "yySet");
  yyDo(G, yy_1_CitationReferenceDouble, G->begin, G->end, "yy_1_CitationReferenceDouble");
  yyprintf((stderr, "  ok   CitationReferenceDouble"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));
  yyDo(G, yyPop, 2, 0, "yyPop");
  return 1;
  l1204:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "CitationReferenceDouble"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_Label(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyDo(G, yyPush, 1, 0, "yyPush");
  yyprintfv((stderr, "%s\n", "Label"));
  yyText(G, G->begin, G->end);  if (!(YY_BEGIN)) goto l1207;  if (!yymatchChar(G, '[')) goto l1207;

  {  int yypos1208= G->pos, yythunkpos1208= G->thunkpos;  if (!yymatchChar(G, '[')) goto l1208;
  goto l1207;
  l1208:;	  G->pos= yypos1208; G->thunkpos= yythunkpos1208;
  }
  {  int yypos1209= G->pos, yythunkpos1209= G->thunkpos;
  {  int yypos1211= G->pos, yythunkpos1211= G->thunkpos;  if (!yymatchChar(G, '^')) goto l1211;
  goto l1210;
  l1211:;	  G->pos= yypos1211; G->thunkpos= yythunkpos1211;
  }
  {  int yypos1212= G->pos, yythunkpos1212= G->thunkpos;  if (!yymatchChar(G, '#')) goto l1212;
  goto l1210;
  l1212:;	  G->pos= yypos1212; G->thunkpos= yythunkpos1212;
  }  yyText(G, G->begin, G->end);  if (!( ext(EXT_NOTES) )) goto l1210;  goto l1209;
  l1210:;	  G->pos= yypos1209; G->thunkpos= yythunkpos1209;
  {  int yypos1213= G->pos, yythunkpos1213= G->thunkpos;  if (!yymatchDot(G)) goto l1207;  G->pos= yypos1213; G->thunkpos= yythunkpos1213;
  }  yyText(G, G->begin, G->end);  if (!( !ext(EXT_NOTES) )) goto l1207;
  }
  l1209:;	  if (!yy_StartList(G))  goto l1207;
  yyDo(G, yySet, -1, 0, "yySet");

  l1214:;	
  {  int yypos1215= G->pos, yythunkpos1215= G->thunkpos;
  {  int yypos1216= G->pos, yythunkpos1216= G->thunkpos;  if (!yymatchChar(G, ']')) goto l1216;
  goto l1215;
  l1216:;	  G->pos= yypos1216; G->thunkpos= yythunkpos1216;
  }  if (!yy_Inline(G))  goto l1215;
  yyDo(G, yy_1_Label, G->begin, G->end, "yy_1_Label");
  goto l1214;
  l1215:;	  G->pos= yypos1215; G->thunkpos= yythunkpos1215;
  }  if (!yymatchChar(G, ']')) goto l1207;
  yyText(G, G->begin, G->end);  if (!(YY_END)) goto l1207;  yyDo(G, yy_2_Label, G->begin, G->end, "yy_2_Label");
  yyprintf((stderr, "  ok   Label"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));
  yyDo(G, yyPop, 1, 0, "yyPop");
  return 1;
  l1207:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "Label"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_ReferenceLinkSingle(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyDo(G, yyPush, 1, 0, "yyPush");
  yyprintfv((stderr, "%s\n", "ReferenceLinkSingle"));
  if (!yy_Label(G))  goto l1217;
  yyDo(G, yySet, -1, 0, "yySet");
  yyText(G, G->begin, G->end);  if (!(YY_BEGIN)) goto l1217;
  {  int yypos1218= G->pos, yythunkpos1218= G->thunkpos;  if (!yy_Spnl(G))  goto l1218;
  if (!yymatchString(G, "[]")) goto l1218;
  goto l1219;
  l1218:;	  G->pos= yypos1218; G->thunkpos= yythunkpos1218;
  }
  l1219:;	  yyText(G, G->begin, G->end);  if (!(YY_END)) goto l1217;  yyDo(G, yy_1_ReferenceLinkSingle, G->begin, G->end, "yy_1_ReferenceLinkSingle");
  yyprintf((stderr, "  ok   ReferenceLinkSingle"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));
  yyDo(G, yyPop, 1, 0, "yyPop");
  return 1;
  l1217:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "ReferenceLinkSingle"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_ReferenceLinkDouble(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyDo(G, yyPush, 2, 0, "yyPush");
  yyprintfv((stderr, "%s\n", "ReferenceLinkDouble"));
  if (!yy_Label(G))  goto l1220;
  yyDo(G, yySet, -2, 0, "yySet");
  yyText(G, G->begin, G->end);  if (!(YY_BEGIN)) goto l1220;  if (!yy_Spnl(G))  goto l1220;
  yyText(G, G->begin, G->end);  if (!(YY_END)) goto l1220;
  {  int yypos1221= G->pos, yythunkpos1221= G->thunkpos;  if (!yymatchString(G, "[]")) goto l1221;
  goto l1220;
  l1221:;	  G->pos= yypos1221; G->thunkpos= yythunkpos1221;
  }  if (!yy_Label(G))  goto l1220;
  yyDo(G, yySet, -1, 0, "yySet");
  yyDo(G, yy_1_ReferenceLinkDouble, G->begin, G->end, "yy_1_ReferenceLinkDouble");
  yyprintf((stderr, "  ok   ReferenceLinkDouble"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));
  yyDo(G, yyPop, 2, 0, "yyPop");
  return 1;
  l1220:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "ReferenceLinkDouble"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_AutoLink(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "AutoLink"));

  {  int yypos1223= G->pos, yythunkpos1223= G->thunkpos;  if (!yy_AutoLinkUrl(G))  goto l1224;
  goto l1223;
  l1224:;	  G->pos= yypos1223; G->thunkpos= yythunkpos1223;  if (!yy_AutoLinkEmail(G))  goto l1222;

  }
  l1223:;	  yyprintf((stderr, "  ok   AutoLink"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l1222:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "AutoLink"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_ReferenceLink(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "ReferenceLink"));

  {  int yypos1226= G->pos, yythunkpos1226= G->thunkpos;  if (!yy_ReferenceLinkDouble(G))  goto l1227;
  goto l1226;
  l1227:;	  G->pos= yypos1226; G->thunkpos= yythunkpos1226;  if (!yy_ReferenceLinkSingle(G))  goto l1225;

  }
  l1226:;	  yyprintf((stderr, "  ok   ReferenceLink"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l1225:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "ReferenceLink"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_ExplicitLink(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyDo(G, yyPush, 3, 0, "yyPush");
  yyprintfv((stderr, "%s\n", "ExplicitLink"));
  if (!yy_Label(G))  goto l1228;
  yyDo(G, yySet, -3, 0, "yySet");
  if (!yymatchChar(G, '(')) goto l1228;
  if (!yy_Sp(G))  goto l1228;
  if (!yy_Source(G))  goto l1228;
  yyDo(G, yySet, -2, 0, "yySet");
  if (!yy_Spnl(G))  goto l1228;
  if (!yy_Title(G))  goto l1228;
  yyDo(G, yySet, -1, 0, "yySet");
  if (!yy_Sp(G))  goto l1228;
  yyText(G, G->begin, G->end);  if (!(YY_BEGIN)) goto l1228;  if (!yymatchChar(G, ')')) goto l1228;
  yyText(G, G->begin, G->end);  if (!(YY_END)) goto l1228;  yyDo(G, yy_1_ExplicitLink, G->begin, G->end, "yy_1_ExplicitLink");
  yyprintf((stderr, "  ok   ExplicitLink"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));
  yyDo(G, yyPop, 3, 0, "yyPop");
  return 1;
  l1228:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "ExplicitLink"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_StrongUl(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyDo(G, yyPush, 2, 0, "yyPush");
  yyprintfv((stderr, "%s\n", "StrongUl"));
  if (!yymatchString(G, "__")) goto l1229;

  {  int yypos1230= G->pos, yythunkpos1230= G->thunkpos;  if (!yy_Whitespace(G))  goto l1230;
  goto l1229;
  l1230:;	  G->pos= yypos1230; G->thunkpos= yythunkpos1230;
  }  if (!yy_StartList(G))  goto l1229;
  yyDo(G, yySet, -2, 0, "yySet");

  {  int yypos1233= G->pos, yythunkpos1233= G->thunkpos;  if (!yymatchString(G, "__")) goto l1233;
  goto l1229;
  l1233:;	  G->pos= yypos1233; G->thunkpos= yythunkpos1233;
  }  if (!yy_Inline(G))  goto l1229;
  yyDo(G, yySet, -1, 0, "yySet");
  yyDo(G, yy_1_StrongUl, G->begin, G->end, "yy_1_StrongUl");

  l1231:;	
  {  int yypos1232= G->pos, yythunkpos1232= G->thunkpos;
  {  int yypos1234= G->pos, yythunkpos1234= G->thunkpos;  if (!yymatchString(G, "__")) goto l1234;
  goto l1232;
  l1234:;	  G->pos= yypos1234; G->thunkpos= yythunkpos1234;
  }  if (!yy_Inline(G))  goto l1232;
  yyDo(G, yySet, -1, 0, "yySet");
  yyDo(G, yy_1_StrongUl, G->begin, G->end, "yy_1_StrongUl");
  goto l1231;
  l1232:;	  G->pos= yypos1232; G->thunkpos= yythunkpos1232;
  }  yyText(G, G->begin, G->end);  if (!(YY_BEGIN)) goto l1229;  if (!yymatchString(G, "__")) goto l1229;
  yyText(G, G->begin, G->end);  if (!(YY_END)) goto l1229;  yyDo(G, yy_2_StrongUl, G->begin, G->end, "yy_2_StrongUl");
  yyprintf((stderr, "  ok   StrongUl"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));
  yyDo(G, yyPop, 2, 0, "yyPop");
  return 1;
  l1229:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "StrongUl"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_StrongStar(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyDo(G, yyPush, 2, 0, "yyPush");
  yyprintfv((stderr, "%s\n", "StrongStar"));
  if (!yymatchString(G, "**")) goto l1235;

  {  int yypos1236= G->pos, yythunkpos1236= G->thunkpos;  if (!yy_Whitespace(G))  goto l1236;
  goto l1235;
  l1236:;	  G->pos= yypos1236; G->thunkpos= yythunkpos1236;
  }  if (!yy_StartList(G))  goto l1235;
  yyDo(G, yySet, -2, 0, "yySet");

  {  int yypos1239= G->pos, yythunkpos1239= G->thunkpos;  if (!yymatchString(G, "**")) goto l1239;
  goto l1235;
  l1239:;	  G->pos= yypos1239; G->thunkpos= yythunkpos1239;
  }  if (!yy_Inline(G))  goto l1235;
  yyDo(G, yySet, -1, 0, "yySet");
  yyDo(G, yy_1_StrongStar, G->begin, G->end, "yy_1_StrongStar");

  l1237:;	
  {  int yypos1238= G->pos, yythunkpos1238= G->thunkpos;
  {  int yypos1240= G->pos, yythunkpos1240= G->thunkpos;  if (!yymatchString(G, "**")) goto l1240;
  goto l1238;
  l1240:;	  G->pos= yypos1240; G->thunkpos= yythunkpos1240;
  }  if (!yy_Inline(G))  goto l1238;
  yyDo(G, yySet, -1, 0, "yySet");
  yyDo(G, yy_1_StrongStar, G->begin, G->end, "yy_1_StrongStar");
  goto l1237;
  l1238:;	  G->pos= yypos1238; G->thunkpos= yythunkpos1238;
  }  yyText(G, G->begin, G->end);  if (!(YY_BEGIN)) goto l1235;  if (!yymatchString(G, "**")) goto l1235;
  yyText(G, G->begin, G->end);  if (!(YY_END)) goto l1235;  yyDo(G, yy_2_StrongStar, G->begin, G->end, "yy_2_StrongStar");
  yyprintf((stderr, "  ok   StrongStar"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));
  yyDo(G, yyPop, 2, 0, "yyPop");
  return 1;
  l1235:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "StrongStar"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_Whitespace(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "Whitespace"));

  {  int yypos1242= G->pos, yythunkpos1242= G->thunkpos;  if (!yy_Spacechar(G))  goto l1243;
  goto l1242;
  l1243:;	  G->pos= yypos1242; G->thunkpos= yythunkpos1242;  if (!yy_Newline(G))  goto l1241;

  }
  l1242:;	  yyprintf((stderr, "  ok   Whitespace"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l1241:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "Whitespace"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_EmphUl(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyDo(G, yyPush, 2, 0, "yyPush");
  yyprintfv((stderr, "%s\n", "EmphUl"));
  if (!yymatchChar(G, '_')) goto l1244;

  {  int yypos1245= G->pos, yythunkpos1245= G->thunkpos;  if (!yy_Whitespace(G))  goto l1245;
  goto l1244;
  l1245:;	  G->pos= yypos1245; G->thunkpos= yythunkpos1245;
  }  if (!yy_StartList(G))  goto l1244;
  yyDo(G, yySet, -2, 0, "yySet");

  {  int yypos1248= G->pos, yythunkpos1248= G->thunkpos;
  {  int yypos1250= G->pos, yythunkpos1250= G->thunkpos;  if (!yymatchChar(G, '_')) goto l1250;
  goto l1249;
  l1250:;	  G->pos= yypos1250; G->thunkpos= yythunkpos1250;
  }  if (!yy_Inline(G))  goto l1249;
  yyDo(G, yySet, -1, 0, "yySet");
  yyDo(G, yy_1_EmphUl, G->begin, G->end, "yy_1_EmphUl");
  goto l1248;
  l1249:;	  G->pos= yypos1248; G->thunkpos= yythunkpos1248;  if (!yy_StrongUl(G))  goto l1244;
  yyDo(G, yySet, -1, 0, "yySet");
  yyDo(G, yy_2_EmphUl, G->begin, G->end, "yy_2_EmphUl");

  }
  l1248:;	
  l1246:;	
  {  int yypos1247= G->pos, yythunkpos1247= G->thunkpos;
  {  int yypos1251= G->pos, yythunkpos1251= G->thunkpos;
  {  int yypos1253= G->pos, yythunkpos1253= G->thunkpos;  if (!yymatchChar(G, '_')) goto l1253;
  goto l1252;
  l1253:;	  G->pos= yypos1253; G->thunkpos= yythunkpos1253;
  }  if (!yy_Inline(G))  goto l1252;
  yyDo(G, yySet, -1, 0, "yySet");
  yyDo(G, yy_1_EmphUl, G->begin, G->end, "yy_1_EmphUl");
  goto l1251;
  l1252:;	  G->pos= yypos1251; G->thunkpos= yythunkpos1251;  if (!yy_StrongUl(G))  goto l1247;
  yyDo(G, yySet, -1, 0, "yySet");
  yyDo(G, yy_2_EmphUl, G->begin, G->end, "yy_2_EmphUl");

  }
  l1251:;	  goto l1246;
  l1247:;	  G->pos= yypos1247; G->thunkpos= yythunkpos1247;
  }  yyText(G, G->begin, G->end);  if (!(YY_BEGIN)) goto l1244;  if (!yymatchChar(G, '_')) goto l1244;
  yyText(G, G->begin, G->end);  if (!(YY_END)) goto l1244;  yyDo(G, yy_3_EmphUl, G->begin, G->end, "yy_3_EmphUl");
  yyprintf((stderr, "  ok   EmphUl"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));
  yyDo(G, yyPop, 2, 0, "yyPop");
  return 1;
  l1244:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "EmphUl"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_EmphStar(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyDo(G, yyPush, 2, 0, "yyPush");
  yyprintfv((stderr, "%s\n", "EmphStar"));
  if (!yymatchChar(G, '*')) goto l1254;

  {  int yypos1255= G->pos, yythunkpos1255= G->thunkpos;  if (!yy_Whitespace(G))  goto l1255;
  goto l1254;
  l1255:;	  G->pos= yypos1255; G->thunkpos= yythunkpos1255;
  }  if (!yy_StartList(G))  goto l1254;
  yyDo(G, yySet, -2, 0, "yySet");

  {  int yypos1258= G->pos, yythunkpos1258= G->thunkpos;
  {  int yypos1260= G->pos, yythunkpos1260= G->thunkpos;  if (!yymatchChar(G, '*')) goto l1260;
  goto l1259;
  l1260:;	  G->pos= yypos1260; G->thunkpos= yythunkpos1260;
  }  if (!yy_Inline(G))  goto l1259;
  yyDo(G, yySet, -1, 0, "yySet");
  yyDo(G, yy_1_EmphStar, G->begin, G->end, "yy_1_EmphStar");
  goto l1258;
  l1259:;	  G->pos= yypos1258; G->thunkpos= yythunkpos1258;  if (!yy_StrongStar(G))  goto l1254;
  yyDo(G, yySet, -1, 0, "yySet");
  yyDo(G, yy_2_EmphStar, G->begin, G->end, "yy_2_EmphStar");

  }
  l1258:;	
  l1256:;	
  {  int yypos1257= G->pos, yythunkpos1257= G->thunkpos;
  {  int yypos1261= G->pos, yythunkpos1261= G->thunkpos;
  {  int yypos1263= G->pos, yythunkpos1263= G->thunkpos;  if (!yymatchChar(G, '*')) goto l1263;
  goto l1262;
  l1263:;	  G->pos= yypos1263; G->thunkpos= yythunkpos1263;
  }  if (!yy_Inline(G))  goto l1262;
  yyDo(G, yySet, -1, 0, "yySet");
  yyDo(G, yy_1_EmphStar, G->begin, G->end, "yy_1_EmphStar");
  goto l1261;
  l1262:;	  G->pos= yypos1261; G->thunkpos= yythunkpos1261;  if (!yy_StrongStar(G))  goto l1257;
  yyDo(G, yySet, -1, 0, "yySet");
  yyDo(G, yy_2_EmphStar, G->begin, G->end, "yy_2_EmphStar");

  }
  l1261:;	  goto l1256;
  l1257:;	  G->pos= yypos1257; G->thunkpos= yythunkpos1257;
  }  yyText(G, G->begin, G->end);  if (!(YY_BEGIN)) goto l1254;  if (!yymatchChar(G, '*')) goto l1254;
  yyText(G, G->begin, G->end);  if (!(YY_END)) goto l1254;  yyDo(G, yy_3_EmphStar, G->begin, G->end, "yy_3_EmphStar");
  yyprintf((stderr, "  ok   EmphStar"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));
  yyDo(G, yyPop, 2, 0, "yyPop");
  return 1;
  l1254:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "EmphStar"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_StarLine(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "StarLine"));

  {  int yypos1265= G->pos, yythunkpos1265= G->thunkpos;  yyText(G, G->begin, G->end);  if (!(YY_BEGIN)) goto l1266;  if (!yymatchString(G, "****")) goto l1266;

  l1267:;	
  {  int yypos1268= G->pos, yythunkpos1268= G->thunkpos;  if (!yymatchChar(G, '*')) goto l1268;
  goto l1267;
  l1268:;	  G->pos= yypos1268; G->thunkpos= yythunkpos1268;
  }  yyText(G, G->begin, G->end);  if (!(YY_END)) goto l1266;  goto l1265;
  l1266:;	  G->pos= yypos1265; G->thunkpos= yythunkpos1265;  yyText(G, G->begin, G->end);  if (!(YY_BEGIN)) goto l1264;  if (!yy_Spacechar(G))  goto l1264;
  if (!yymatchChar(G, '*')) goto l1264;

  l1269:;	
  {  int yypos1270= G->pos, yythunkpos1270= G->thunkpos;  if (!yymatchChar(G, '*')) goto l1270;
  goto l1269;
  l1270:;	  G->pos= yypos1270; G->thunkpos= yythunkpos1270;
  }
  {  int yypos1271= G->pos, yythunkpos1271= G->thunkpos;  if (!yy_Spacechar(G))  goto l1264;
  G->pos= yypos1271; G->thunkpos= yythunkpos1271;
  }  yyText(G, G->begin, G->end);  if (!(YY_END)) goto l1264;
  }
  l1265:;	  yyprintf((stderr, "  ok   StarLine"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l1264:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "StarLine"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_UlLine(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "UlLine"));

  {  int yypos1273= G->pos, yythunkpos1273= G->thunkpos;  yyText(G, G->begin, G->end);  if (!(YY_BEGIN)) goto l1274;  if (!yymatchString(G, "____")) goto l1274;

  l1275:;	
  {  int yypos1276= G->pos, yythunkpos1276= G->thunkpos;  if (!yymatchChar(G, '_')) goto l1276;
  goto l1275;
  l1276:;	  G->pos= yypos1276; G->thunkpos= yythunkpos1276;
  }  yyText(G, G->begin, G->end);  if (!(YY_END)) goto l1274;  goto l1273;
  l1274:;	  G->pos= yypos1273; G->thunkpos= yythunkpos1273;  yyText(G, G->begin, G->end);  if (!(YY_BEGIN)) goto l1272;  if (!yy_Spacechar(G))  goto l1272;
  if (!yymatchChar(G, '_')) goto l1272;

  l1277:;	
  {  int yypos1278= G->pos, yythunkpos1278= G->thunkpos;  if (!yymatchChar(G, '_')) goto l1278;
  goto l1277;
  l1278:;	  G->pos= yypos1278; G->thunkpos= yythunkpos1278;
  }
  {  int yypos1279= G->pos, yythunkpos1279= G->thunkpos;  if (!yy_Spacechar(G))  goto l1272;
  G->pos= yypos1279; G->thunkpos= yythunkpos1279;
  }  yyText(G, G->begin, G->end);  if (!(YY_END)) goto l1272;
  }
  l1273:;	  yyprintf((stderr, "  ok   UlLine"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l1272:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "UlLine"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_DoubleDollarMath(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "DoubleDollarMath"));
  yyText(G, G->begin, G->end);  if (!(YY_BEGIN)) goto l1280;  if (!yy_DoubleDollarMathStart(G))  goto l1280;

  l1281:;	
  {  int yypos1282= G->pos, yythunkpos1282= G->thunkpos;
  {  int yypos1283= G->pos, yythunkpos1283= G->thunkpos;  if (!yy_DoubleDollarMathEnd(G))  goto l1283;
  goto l1282;
  l1283:;	  G->pos= yypos1283; G->thunkpos= yythunkpos1283;
  }
  {  int yypos1284= G->pos, yythunkpos1284= G->thunkpos;  if (!yy_BlankLine(G))  goto l1284;
  if (!yy_BlankLine(G))  goto l1284;
  goto l1282;
  l1284:;	  G->pos= yypos1284; G->thunkpos= yythunkpos1284;
  }  if (!yymatchDot(G)) goto l1282;  goto l1281;
  l1282:;	  G->pos= yypos1282; G->thunkpos= yythunkpos1282;
  }  if (!yy_DoubleDollarMathEnd(G))  goto l1280;
  yyText(G, G->begin, G->end);  if (!(YY_END)) goto l1280;  yyDo(G, yy_1_DoubleDollarMath, G->begin, G->end, "yy_1_DoubleDollarMath");
  yyprintf((stderr, "  ok   DoubleDollarMath"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l1280:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "DoubleDollarMath"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_DoubleDollarMathEnd(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "DoubleDollarMathEnd"));

  {  int yypos1286= G->pos, yythunkpos1286= G->thunkpos;  if (!yymatchChar(G, '\\')) goto l1286;
  goto l1285;
  l1286:;	  G->pos= yypos1286; G->thunkpos= yythunkpos1286;
  }  if (!yy_Nonspacechar(G))  goto l1285;
  if (!yymatchChar(G, '$')) goto l1285;
  if (!yymatchChar(G, '$')) goto l1285;

  {  int yypos1287= G->pos, yythunkpos1287= G->thunkpos;  if (!yy_Nonspacechar(G))  goto l1287;
  goto l1285;
  l1287:;	  G->pos= yypos1287; G->thunkpos= yythunkpos1287;
  }  yyprintf((stderr, "  ok   DoubleDollarMathEnd"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l1285:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "DoubleDollarMathEnd"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_DoubleDollarMathStart(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "DoubleDollarMathStart"));
  if (!yymatchChar(G, '$')) goto l1288;
  if (!yymatchChar(G, '$')) goto l1288;

  {  int yypos1289= G->pos, yythunkpos1289= G->thunkpos;
  {  int yypos1290= G->pos, yythunkpos1290= G->thunkpos;  if (!yy_Spacechar(G))  goto l1291;
  goto l1290;
  l1291:;	  G->pos= yypos1290; G->thunkpos= yythunkpos1290;  if (!yy_Newline(G))  goto l1289;

  }
  l1290:;	  goto l1288;
  l1289:;	  G->pos= yypos1289; G->thunkpos= yythunkpos1289;
  }  yyprintf((stderr, "  ok   DoubleDollarMathStart"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l1288:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "DoubleDollarMathStart"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_SingleDollarMath(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "SingleDollarMath"));
  yyText(G, G->begin, G->end);  if (!(YY_BEGIN)) goto l1292;  if (!yy_SingleDollarMathStart(G))  goto l1292;

  l1293:;	
  {  int yypos1294= G->pos, yythunkpos1294= G->thunkpos;
  {  int yypos1295= G->pos, yythunkpos1295= G->thunkpos;  if (!yy_SingleDollarMathEnd(G))  goto l1295;
  goto l1294;
  l1295:;	  G->pos= yypos1295; G->thunkpos= yythunkpos1295;
  }
  {  int yypos1296= G->pos, yythunkpos1296= G->thunkpos;  if (!yy_BlankLine(G))  goto l1296;
  if (!yy_BlankLine(G))  goto l1296;
  goto l1294;
  l1296:;	  G->pos= yypos1296; G->thunkpos= yythunkpos1296;
  }  if (!yymatchDot(G)) goto l1294;  goto l1293;
  l1294:;	  G->pos= yypos1294; G->thunkpos= yythunkpos1294;
  }  if (!yy_SingleDollarMathEnd(G))  goto l1292;
  yyText(G, G->begin, G->end);  if (!(YY_END)) goto l1292;  yyDo(G, yy_1_SingleDollarMath, G->begin, G->end, "yy_1_SingleDollarMath");
  yyprintf((stderr, "  ok   SingleDollarMath"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l1292:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "SingleDollarMath"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_SingleDollarMathEnd(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "SingleDollarMathEnd"));

  {  int yypos1298= G->pos, yythunkpos1298= G->thunkpos;  if (!yymatchChar(G, '\\')) goto l1298;
  goto l1297;
  l1298:;	  G->pos= yypos1298; G->thunkpos= yythunkpos1298;
  }
  {  int yypos1299= G->pos, yythunkpos1299= G->thunkpos;  if (!yymatchChar(G, '$')) goto l1299;
  goto l1297;
  l1299:;	  G->pos= yypos1299; G->thunkpos= yythunkpos1299;
  }  if (!yy_Nonspacechar(G))  goto l1297;
  if (!yymatchChar(G, '$')) goto l1297;

  {  int yypos1300= G->pos, yythunkpos1300= G->thunkpos;  if (!yy_Nonspacechar(G))  goto l1300;
  goto l1297;
  l1300:;	  G->pos= yypos1300; G->thunkpos= yythunkpos1300;
  }  yyprintf((stderr, "  ok   SingleDollarMathEnd"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l1297:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "SingleDollarMathEnd"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_SingleDollarMathStart(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "SingleDollarMathStart"));
  if (!yymatchChar(G, '$')) goto l1301;

  {  int yypos1302= G->pos, yythunkpos1302= G->thunkpos;
  {  int yypos1303= G->pos, yythunkpos1303= G->thunkpos;  if (!yy_Spacechar(G))  goto l1304;
  goto l1303;
  l1304:;	  G->pos= yypos1303; G->thunkpos= yythunkpos1303;  if (!yy_Newline(G))  goto l1305;
  goto l1303;
  l1305:;	  G->pos= yypos1303; G->thunkpos= yythunkpos1303;  if (!yymatchChar(G, '$')) goto l1302;

  }
  l1303:;	  goto l1301;
  l1302:;	  G->pos= yypos1302; G->thunkpos= yythunkpos1302;
  }  yyprintf((stderr, "  ok   SingleDollarMathStart"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l1301:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "SingleDollarMathStart"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_AposChunk(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "AposChunk"));
  yyText(G, G->begin, G->end);  if (!( ext(EXT_SMART) )) goto l1306;  if (!yymatchChar(G, '\'')) goto l1306;

  {  int yypos1307= G->pos, yythunkpos1307= G->thunkpos;  if (!yy_Alphanumeric(G))  goto l1306;
  G->pos= yypos1307; G->thunkpos= yythunkpos1307;
  }  yyDo(G, yy_1_AposChunk, G->begin, G->end, "yy_1_AposChunk");
  yyprintf((stderr, "  ok   AposChunk"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l1306:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "AposChunk"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_StrChunk(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "StrChunk"));

  {  int yypos1309= G->pos, yythunkpos1309= G->thunkpos;  yyText(G, G->begin, G->end);  if (!(YY_BEGIN)) goto l1310;
  {  int yypos1313= G->pos, yythunkpos1313= G->thunkpos;  if (!yy_NormalChar(G))  goto l1314;
  goto l1313;
  l1314:;	  G->pos= yypos1313; G->thunkpos= yythunkpos1313;  if (!yymatchChar(G, '_')) goto l1310;

  l1315:;	
  {  int yypos1316= G->pos, yythunkpos1316= G->thunkpos;  if (!yymatchChar(G, '_')) goto l1316;
  goto l1315;
  l1316:;	  G->pos= yypos1316; G->thunkpos= yythunkpos1316;
  }
  {  int yypos1317= G->pos, yythunkpos1317= G->thunkpos;  if (!yy_Alphanumeric(G))  goto l1310;
  G->pos= yypos1317; G->thunkpos= yythunkpos1317;
  }
  }
  l1313:;	
  l1311:;	
  {  int yypos1312= G->pos, yythunkpos1312= G->thunkpos;
  {  int yypos1318= G->pos, yythunkpos1318= G->thunkpos;  if (!yy_NormalChar(G))  goto l1319;
  goto l1318;
  l1319:;	  G->pos= yypos1318; G->thunkpos= yythunkpos1318;  if (!yymatchChar(G, '_')) goto l1312;

  l1320:;	
  {  int yypos1321= G->pos, yythunkpos1321= G->thunkpos;  if (!yymatchChar(G, '_')) goto l1321;
  goto l1320;
  l1321:;	  G->pos= yypos1321; G->thunkpos= yythunkpos1321;
  }
  {  int yypos1322= G->pos, yythunkpos1322= G->thunkpos;  if (!yy_Alphanumeric(G))  goto l1312;
  G->pos= yypos1322; G->thunkpos= yythunkpos1322;
  }
  }
  l1318:;	  goto l1311;
  l1312:;	  G->pos= yypos1312; G->thunkpos= yythunkpos1312;
  }  yyText(G, G->begin, G->end);  if (!(YY_END)) goto l1310;  yyDo(G, yy_1_StrChunk, G->begin, G->end, "yy_1_StrChunk");
  goto l1309;
  l1310:;	  G->pos= yypos1309; G->thunkpos= yythunkpos1309;  if (!yy_AposChunk(G))  goto l1308;

  }
  l1309:;	  yyprintf((stderr, "  ok   StrChunk"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l1308:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "StrChunk"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_voidNormalEndline(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "voidNormalEndline"));
  if (!yy_Sp(G))  goto l1323;
  if (!yy_Newline(G))  goto l1323;

  {  int yypos1324= G->pos, yythunkpos1324= G->thunkpos;  if (!yy_BlankLine(G))  goto l1324;
  goto l1323;
  l1324:;	  G->pos= yypos1324; G->thunkpos= yythunkpos1324;
  }
  {  int yypos1325= G->pos, yythunkpos1325= G->thunkpos;  if (!yymatchChar(G, '>')) goto l1325;
  goto l1323;
  l1325:;	  G->pos= yypos1325; G->thunkpos= yythunkpos1325;
  }
  {  int yypos1326= G->pos, yythunkpos1326= G->thunkpos;  if (!yy_AtxStart(G))  goto l1326;
  goto l1323;
  l1326:;	  G->pos= yypos1326; G->thunkpos= yythunkpos1326;
  }
  {  int yypos1327= G->pos, yythunkpos1327= G->thunkpos;  if (!yy_Line(G))  goto l1327;

  {  int yypos1328= G->pos, yythunkpos1328= G->thunkpos;  if (!yymatchChar(G, '=')) goto l1329;

  l1330:;	
  {  int yypos1331= G->pos, yythunkpos1331= G->thunkpos;  if (!yymatchChar(G, '=')) goto l1331;
  goto l1330;
  l1331:;	  G->pos= yypos1331; G->thunkpos= yythunkpos1331;
  }  goto l1328;
  l1329:;	  G->pos= yypos1328; G->thunkpos= yythunkpos1328;  if (!yymatchChar(G, '-')) goto l1327;

  l1332:;	
  {  int yypos1333= G->pos, yythunkpos1333= G->thunkpos;  if (!yymatchChar(G, '-')) goto l1333;
  goto l1332;
  l1333:;	  G->pos= yypos1333; G->thunkpos= yythunkpos1333;
  }
  }
  l1328:;	  if (!yy_Newline(G))  goto l1327;
  goto l1323;
  l1327:;	  G->pos= yypos1327; G->thunkpos= yythunkpos1327;
  }  yyprintf((stderr, "  ok   voidNormalEndline"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l1323:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "voidNormalEndline"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_NormalEndline(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "NormalEndline"));
  if (!yy_Sp(G))  goto l1334;
  if (!yy_Newline(G))  goto l1334;

  {  int yypos1335= G->pos, yythunkpos1335= G->thunkpos;  if (!yy_BlankLine(G))  goto l1335;
  goto l1334;
  l1335:;	  G->pos= yypos1335; G->thunkpos= yythunkpos1335;
  }
  {  int yypos1336= G->pos, yythunkpos1336= G->thunkpos;  if (!yymatchChar(G, '>')) goto l1336;
  goto l1334;
  l1336:;	  G->pos= yypos1336; G->thunkpos= yythunkpos1336;
  }
  {  int yypos1337= G->pos, yythunkpos1337= G->thunkpos;  if (!yy_AtxStart(G))  goto l1337;
  goto l1334;
  l1337:;	  G->pos= yypos1337; G->thunkpos= yythunkpos1337;
  }
  {  int yypos1338= G->pos, yythunkpos1338= G->thunkpos;  if (!yy_Line(G))  goto l1338;

  {  int yypos1339= G->pos, yythunkpos1339= G->thunkpos;  if (!yymatchChar(G, '=')) goto l1340;

  l1341:;	
  {  int yypos1342= G->pos, yythunkpos1342= G->thunkpos;  if (!yymatchChar(G, '=')) goto l1342;
  goto l1341;
  l1342:;	  G->pos= yypos1342; G->thunkpos= yythunkpos1342;
  }  goto l1339;
  l1340:;	  G->pos= yypos1339; G->thunkpos= yythunkpos1339;  if (!yymatchChar(G, '-')) goto l1338;

  l1343:;	
  {  int yypos1344= G->pos, yythunkpos1344= G->thunkpos;  if (!yymatchChar(G, '-')) goto l1344;
  goto l1343;
  l1344:;	  G->pos= yypos1344; G->thunkpos= yythunkpos1344;
  }
  }
  l1339:;	  if (!yy_Newline(G))  goto l1338;
  goto l1334;
  l1338:;	  G->pos= yypos1338; G->thunkpos= yythunkpos1338;
  }  yyDo(G, yy_1_NormalEndline, G->begin, G->end, "yy_1_NormalEndline");
  yyprintf((stderr, "  ok   NormalEndline"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l1334:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "NormalEndline"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_TerminalEndline(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "TerminalEndline"));
  if (!yy_Sp(G))  goto l1345;
  if (!yy_Newline(G))  goto l1345;
  if (!yy_Eof(G))  goto l1345;
  yyDo(G, yy_1_TerminalEndline, G->begin, G->end, "yy_1_TerminalEndline");
  yyprintf((stderr, "  ok   TerminalEndline"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l1345:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "TerminalEndline"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_LineBreak(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyDo(G, yyPush, 1, 0, "yyPush");
  yyprintfv((stderr, "%s\n", "LineBreak"));
  if (!yymatchString(G, "  ")) goto l1346;
  if (!yy_NormalEndline(G))  goto l1346;
  yyDo(G, yySet, -1, 0, "yySet");
  yyDo(G, yy_1_LineBreak, G->begin, G->end, "yy_1_LineBreak");
  yyprintf((stderr, "  ok   LineBreak"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));
  yyDo(G, yyPop, 1, 0, "yyPop");
  return 1;
  l1346:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "LineBreak"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_Smart(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "Smart"));
  yyText(G, G->begin, G->end);  if (!( ext(EXT_SMART) )) goto l1347;
  {  int yypos1348= G->pos, yythunkpos1348= G->thunkpos;  if (!yy_Ellipsis(G))  goto l1349;
  goto l1348;
  l1349:;	  G->pos= yypos1348; G->thunkpos= yythunkpos1348;  if (!yy_Dash(G))  goto l1350;
  goto l1348;
  l1350:;	  G->pos= yypos1348; G->thunkpos= yythunkpos1348;  if (!yy_SingleQuoted(G))  goto l1351;
  goto l1348;
  l1351:;	  G->pos= yypos1348; G->thunkpos= yythunkpos1348;  if (!yy_DoubleQuoted(G))  goto l1352;
  goto l1348;
  l1352:;	  G->pos= yypos1348; G->thunkpos= yythunkpos1348;  if (!yy_Apostrophe(G))  goto l1347;

  }
  l1348:;	  yyprintf((stderr, "  ok   Smart"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l1347:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "Smart"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_MarkdownHtmlTagOpen(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyDo(G, yyPush, 1, 0, "yyPush");
  yyprintfv((stderr, "%s\n", "MarkdownHtmlTagOpen"));
  if (!yy_StartList(G))  goto l1353;
  yyDo(G, yySet, -1, 0, "yySet");
  if (!yymatchChar(G, '<')) goto l1353;
  yyDo(G, yy_1_MarkdownHtmlTagOpen, G->begin, G->end, "yy_1_MarkdownHtmlTagOpen");
  if (!yy_Spnl(G))  goto l1353;
  yyText(G, G->begin, G->end);  if (!(YY_BEGIN)) goto l1353;  if (!yy_HtmlBlockType(G))  goto l1353;
  yyText(G, G->begin, G->end);  if (!(YY_END)) goto l1353;  yyDo(G, yy_2_MarkdownHtmlTagOpen, G->begin, G->end, "yy_2_MarkdownHtmlTagOpen");
  if (!yy_Spnl(G))  goto l1353;

  l1354:;	
  {  int yypos1355= G->pos, yythunkpos1355= G->thunkpos;
  {  int yypos1356= G->pos, yythunkpos1356= G->thunkpos;  if (!yy_MarkdownHtmlAttribute(G))  goto l1356;
  goto l1355;
  l1356:;	  G->pos= yypos1356; G->thunkpos= yythunkpos1356;
  }  yyText(G, G->begin, G->end);  if (!(YY_BEGIN)) goto l1355;  if (!yy_HtmlAttribute(G))  goto l1355;
  yyText(G, G->begin, G->end);  if (!(YY_END)) goto l1355;  yyDo(G, yy_3_MarkdownHtmlTagOpen, G->begin, G->end, "yy_3_MarkdownHtmlTagOpen");
  goto l1354;
  l1355:;	  G->pos= yypos1355; G->thunkpos= yythunkpos1355;
  }  if (!yy_MarkdownHtmlAttribute(G))  goto l1353;

  l1357:;	
  {  int yypos1358= G->pos, yythunkpos1358= G->thunkpos;  yyText(G, G->begin, G->end);  if (!(YY_BEGIN)) goto l1358;  if (!yy_HtmlAttribute(G))  goto l1358;
  yyText(G, G->begin, G->end);  if (!(YY_END)) goto l1358;  yyDo(G, yy_4_MarkdownHtmlTagOpen, G->begin, G->end, "yy_4_MarkdownHtmlTagOpen");
  goto l1357;
  l1358:;	  G->pos= yypos1358; G->thunkpos= yythunkpos1358;
  }  if (!yymatchChar(G, '>')) goto l1353;
  yyDo(G, yy_5_MarkdownHtmlTagOpen, G->begin, G->end, "yy_5_MarkdownHtmlTagOpen");
  yyDo(G, yy_6_MarkdownHtmlTagOpen, G->begin, G->end, "yy_6_MarkdownHtmlTagOpen");
  yyprintf((stderr, "  ok   MarkdownHtmlTagOpen"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));
  yyDo(G, yyPop, 1, 0, "yyPop");
  return 1;
  l1353:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "MarkdownHtmlTagOpen"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_Code(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "Code"));

  {  int yypos1360= G->pos, yythunkpos1360= G->thunkpos;  if (!yy_Ticks1(G))  goto l1361;
  if (!yy_Sp(G))  goto l1361;
  yyText(G, G->begin, G->end);  if (!(YY_BEGIN)) goto l1361;
  {  int yypos1364= G->pos, yythunkpos1364= G->thunkpos;
  {  int yypos1368= G->pos, yythunkpos1368= G->thunkpos;  if (!yymatchChar(G, '`')) goto l1368;
  goto l1365;
  l1368:;	  G->pos= yypos1368; G->thunkpos= yythunkpos1368;
  }  if (!yy_Nonspacechar(G))  goto l1365;

  l1366:;	
  {  int yypos1367= G->pos, yythunkpos1367= G->thunkpos;
  {  int yypos1369= G->pos, yythunkpos1369= G->thunkpos;  if (!yymatchChar(G, '`')) goto l1369;
  goto l1367;
  l1369:;	  G->pos= yypos1369; G->thunkpos= yythunkpos1369;
  }  if (!yy_Nonspacechar(G))  goto l1367;
  goto l1366;
  l1367:;	  G->pos= yypos1367; G->thunkpos= yythunkpos1367;
  }  goto l1364;
  l1365:;	  G->pos= yypos1364; G->thunkpos= yythunkpos1364;
  {  int yypos1371= G->pos, yythunkpos1371= G->thunkpos;  if (!yy_Ticks1(G))  goto l1371;
  goto l1370;
  l1371:;	  G->pos= yypos1371; G->thunkpos= yythunkpos1371;
  }  if (!yymatchChar(G, '`')) goto l1370;

  l1372:;	
  {  int yypos1373= G->pos, yythunkpos1373= G->thunkpos;  if (!yymatchChar(G, '`')) goto l1373;
  goto l1372;
  l1373:;	  G->pos= yypos1373; G->thunkpos= yythunkpos1373;
  }  goto l1364;
  l1370:;	  G->pos= yypos1364; G->thunkpos= yythunkpos1364;
  {  int yypos1374= G->pos, yythunkpos1374= G->thunkpos;  if (!yy_Sp(G))  goto l1374;
  if (!yy_Ticks1(G))  goto l1374;
  goto l1361;
  l1374:;	  G->pos= yypos1374; G->thunkpos= yythunkpos1374;
  }
  {  int yypos1375= G->pos, yythunkpos1375= G->thunkpos;  if (!yy_Spacechar(G))  goto l1376;
  goto l1375;
  l1376:;	  G->pos= yypos1375; G->thunkpos= yythunkpos1375;  if (!yy_Newline(G))  goto l1361;

  {  int yypos1377= G->pos, yythunkpos1377= G->thunkpos;  if (!yy_BlankLine(G))  goto l1377;
  goto l1361;
  l1377:;	  G->pos= yypos1377; G->thunkpos= yythunkpos1377;
  }
  }
  l1375:;	
  }
  l1364:;	
  l1362:;	
  {  int yypos1363= G->pos, yythunkpos1363= G->thunkpos;
  {  int yypos1378= G->pos, yythunkpos1378= G->thunkpos;
  {  int yypos1382= G->pos, yythunkpos1382= G->thunkpos;  if (!yymatchChar(G, '`')) goto l1382;
  goto l1379;
  l1382:;	  G->pos= yypos1382; G->thunkpos= yythunkpos1382;
  }  if (!yy_Nonspacechar(G))  goto l1379;

  l1380:;	
  {  int yypos1381= G->pos, yythunkpos1381= G->thunkpos;
  {  int yypos1383= G->pos, yythunkpos1383= G->thunkpos;  if (!yymatchChar(G, '`')) goto l1383;
  goto l1381;
  l1383:;	  G->pos= yypos1383; G->thunkpos= yythunkpos1383;
  }  if (!yy_Nonspacechar(G))  goto l1381;
  goto l1380;
  l1381:;	  G->pos= yypos1381; G->thunkpos= yythunkpos1381;
  }  goto l1378;
  l1379:;	  G->pos= yypos1378; G->thunkpos= yythunkpos1378;
  {  int yypos1385= G->pos, yythunkpos1385= G->thunkpos;  if (!yy_Ticks1(G))  goto l1385;
  goto l1384;
  l1385:;	  G->pos= yypos1385; G->thunkpos= yythunkpos1385;
  }  if (!yymatchChar(G, '`')) goto l1384;

  l1386:;	
  {  int yypos1387= G->pos, yythunkpos1387= G->thunkpos;  if (!yymatchChar(G, '`')) goto l1387;
  goto l1386;
  l1387:;	  G->pos= yypos1387; G->thunkpos= yythunkpos1387;
  }  goto l1378;
  l1384:;	  G->pos= yypos1378; G->thunkpos= yythunkpos1378;
  {  int yypos1388= G->pos, yythunkpos1388= G->thunkpos;  if (!yy_Sp(G))  goto l1388;
  if (!yy_Ticks1(G))  goto l1388;
  goto l1363;
  l1388:;	  G->pos= yypos1388; G->thunkpos= yythunkpos1388;
  }
  {  int yypos1389= G->pos, yythunkpos1389= G->thunkpos;  if (!yy_Spacechar(G))  goto l1390;
  goto l1389;
  l1390:;	  G->pos= yypos1389; G->thunkpos= yythunkpos1389;  if (!yy_Newline(G))  goto l1363;

  {  int yypos1391= G->pos, yythunkpos1391= G->thunkpos;  if (!yy_BlankLine(G))  goto l1391;
  goto l1363;
  l1391:;	  G->pos= yypos1391; G->thunkpos= yythunkpos1391;
  }
  }
  l1389:;	
  }
  l1378:;	  goto l1362;
  l1363:;	  G->pos= yypos1363; G->thunkpos= yythunkpos1363;
  }  yyText(G, G->begin, G->end);  if (!(YY_END)) goto l1361;  if (!yy_Sp(G))  goto l1361;
  if (!yy_Ticks1(G))  goto l1361;
  goto l1360;
  l1361:;	  G->pos= yypos1360; G->thunkpos= yythunkpos1360;  if (!yy_Ticks2(G))  goto l1392;
  if (!yy_Sp(G))  goto l1392;
  yyText(G, G->begin, G->end);  if (!(YY_BEGIN)) goto l1392;
  {  int yypos1395= G->pos, yythunkpos1395= G->thunkpos;
  {  int yypos1399= G->pos, yythunkpos1399= G->thunkpos;  if (!yymatchChar(G, '`')) goto l1399;
  goto l1396;
  l1399:;	  G->pos= yypos1399; G->thunkpos= yythunkpos1399;
  }  if (!yy_Nonspacechar(G))  goto l1396;

  l1397:;	
  {  int yypos1398= G->pos, yythunkpos1398= G->thunkpos;
  {  int yypos1400= G->pos, yythunkpos1400= G->thunkpos;  if (!yymatchChar(G, '`')) goto l1400;
  goto l1398;
  l1400:;	  G->pos= yypos1400; G->thunkpos= yythunkpos1400;
  }  if (!yy_Nonspacechar(G))  goto l1398;
  goto l1397;
  l1398:;	  G->pos= yypos1398; G->thunkpos= yythunkpos1398;
  }  goto l1395;
  l1396:;	  G->pos= yypos1395; G->thunkpos= yythunkpos1395;
  {  int yypos1402= G->pos, yythunkpos1402= G->thunkpos;  if (!yy_Ticks2(G))  goto l1402;
  goto l1401;
  l1402:;	  G->pos= yypos1402; G->thunkpos= yythunkpos1402;
  }  if (!yymatchChar(G, '`')) goto l1401;

  l1403:;	
  {  int yypos1404= G->pos, yythunkpos1404= G->thunkpos;  if (!yymatchChar(G, '`')) goto l1404;
  goto l1403;
  l1404:;	  G->pos= yypos1404; G->thunkpos= yythunkpos1404;
  }  goto l1395;
  l1401:;	  G->pos= yypos1395; G->thunkpos= yythunkpos1395;
  {  int yypos1405= G->pos, yythunkpos1405= G->thunkpos;  if (!yy_Sp(G))  goto l1405;
  if (!yy_Ticks2(G))  goto l1405;
  goto l1392;
  l1405:;	  G->pos= yypos1405; G->thunkpos= yythunkpos1405;
  }
  {  int yypos1406= G->pos, yythunkpos1406= G->thunkpos;  if (!yy_Spacechar(G))  goto l1407;
  goto l1406;
  l1407:;	  G->pos= yypos1406; G->thunkpos= yythunkpos1406;  if (!yy_Newline(G))  goto l1392;

  {  int yypos1408= G->pos, yythunkpos1408= G->thunkpos;  if (!yy_BlankLine(G))  goto l1408;
  goto l1392;
  l1408:;	  G->pos= yypos1408; G->thunkpos= yythunkpos1408;
  }
  }
  l1406:;	
  }
  l1395:;	
  l1393:;	
  {  int yypos1394= G->pos, yythunkpos1394= G->thunkpos;
  {  int yypos1409= G->pos, yythunkpos1409= G->thunkpos;
  {  int yypos1413= G->pos, yythunkpos1413= G->thunkpos;  if (!yymatchChar(G, '`')) goto l1413;
  goto l1410;
  l1413:;	  G->pos= yypos1413; G->thunkpos= yythunkpos1413;
  }  if (!yy_Nonspacechar(G))  goto l1410;

  l1411:;	
  {  int yypos1412= G->pos, yythunkpos1412= G->thunkpos;
  {  int yypos1414= G->pos, yythunkpos1414= G->thunkpos;  if (!yymatchChar(G, '`')) goto l1414;
  goto l1412;
  l1414:;	  G->pos= yypos1414; G->thunkpos= yythunkpos1414;
  }  if (!yy_Nonspacechar(G))  goto l1412;
  goto l1411;
  l1412:;	  G->pos= yypos1412; G->thunkpos= yythunkpos1412;
  }  goto l1409;
  l1410:;	  G->pos= yypos1409; G->thunkpos= yythunkpos1409;
  {  int yypos1416= G->pos, yythunkpos1416= G->thunkpos;  if (!yy_Ticks2(G))  goto l1416;
  goto l1415;
  l1416:;	  G->pos= yypos1416; G->thunkpos= yythunkpos1416;
  }  if (!yymatchChar(G, '`')) goto l1415;

  l1417:;	
  {  int yypos1418= G->pos, yythunkpos1418= G->thunkpos;  if (!yymatchChar(G, '`')) goto l1418;
  goto l1417;
  l1418:;	  G->pos= yypos1418; G->thunkpos= yythunkpos1418;
  }  goto l1409;
  l1415:;	  G->pos= yypos1409; G->thunkpos= yythunkpos1409;
  {  int yypos1419= G->pos, yythunkpos1419= G->thunkpos;  if (!yy_Sp(G))  goto l1419;
  if (!yy_Ticks2(G))  goto l1419;
  goto l1394;
  l1419:;	  G->pos= yypos1419; G->thunkpos= yythunkpos1419;
  }
  {  int yypos1420= G->pos, yythunkpos1420= G->thunkpos;  if (!yy_Spacechar(G))  goto l1421;
  goto l1420;
  l1421:;	  G->pos= yypos1420; G->thunkpos= yythunkpos1420;  if (!yy_Newline(G))  goto l1394;

  {  int yypos1422= G->pos, yythunkpos1422= G->thunkpos;  if (!yy_BlankLine(G))  goto l1422;
  goto l1394;
  l1422:;	  G->pos= yypos1422; G->thunkpos= yythunkpos1422;
  }
  }
  l1420:;	
  }
  l1409:;	  goto l1393;
  l1394:;	  G->pos= yypos1394; G->thunkpos= yythunkpos1394;
  }  yyText(G, G->begin, G->end);  if (!(YY_END)) goto l1392;  if (!yy_Sp(G))  goto l1392;
  if (!yy_Ticks2(G))  goto l1392;
  goto l1360;
  l1392:;	  G->pos= yypos1360; G->thunkpos= yythunkpos1360;  if (!yy_Ticks3(G))  goto l1423;
  if (!yy_Sp(G))  goto l1423;
  yyText(G, G->begin, G->end);  if (!(YY_BEGIN)) goto l1423;
  {  int yypos1426= G->pos, yythunkpos1426= G->thunkpos;
  {  int yypos1430= G->pos, yythunkpos1430= G->thunkpos;  if (!yymatchChar(G, '`')) goto l1430;
  goto l1427;
  l1430:;	  G->pos= yypos1430; G->thunkpos= yythunkpos1430;
  }  if (!yy_Nonspacechar(G))  goto l1427;

  l1428:;	
  {  int yypos1429= G->pos, yythunkpos1429= G->thunkpos;
  {  int yypos1431= G->pos, yythunkpos1431= G->thunkpos;  if (!yymatchChar(G, '`')) goto l1431;
  goto l1429;
  l1431:;	  G->pos= yypos1431; G->thunkpos= yythunkpos1431;
  }  if (!yy_Nonspacechar(G))  goto l1429;
  goto l1428;
  l1429:;	  G->pos= yypos1429; G->thunkpos= yythunkpos1429;
  }  goto l1426;
  l1427:;	  G->pos= yypos1426; G->thunkpos= yythunkpos1426;
  {  int yypos1433= G->pos, yythunkpos1433= G->thunkpos;  if (!yy_Ticks3(G))  goto l1433;
  goto l1432;
  l1433:;	  G->pos= yypos1433; G->thunkpos= yythunkpos1433;
  }  if (!yymatchChar(G, '`')) goto l1432;

  l1434:;	
  {  int yypos1435= G->pos, yythunkpos1435= G->thunkpos;  if (!yymatchChar(G, '`')) goto l1435;
  goto l1434;
  l1435:;	  G->pos= yypos1435; G->thunkpos= yythunkpos1435;
  }  goto l1426;
  l1432:;	  G->pos= yypos1426; G->thunkpos= yythunkpos1426;
  {  int yypos1436= G->pos, yythunkpos1436= G->thunkpos;  if (!yy_Sp(G))  goto l1436;
  if (!yy_Ticks3(G))  goto l1436;
  goto l1423;
  l1436:;	  G->pos= yypos1436; G->thunkpos= yythunkpos1436;
  }
  {  int yypos1437= G->pos, yythunkpos1437= G->thunkpos;  if (!yy_Spacechar(G))  goto l1438;
  goto l1437;
  l1438:;	  G->pos= yypos1437; G->thunkpos= yythunkpos1437;  if (!yy_Newline(G))  goto l1423;

  {  int yypos1439= G->pos, yythunkpos1439= G->thunkpos;  if (!yy_BlankLine(G))  goto l1439;
  goto l1423;
  l1439:;	  G->pos= yypos1439; G->thunkpos= yythunkpos1439;
  }
  }
  l1437:;	
  }
  l1426:;	
  l1424:;	
  {  int yypos1425= G->pos, yythunkpos1425= G->thunkpos;
  {  int yypos1440= G->pos, yythunkpos1440= G->thunkpos;
  {  int yypos1444= G->pos, yythunkpos1444= G->thunkpos;  if (!yymatchChar(G, '`')) goto l1444;
  goto l1441;
  l1444:;	  G->pos= yypos1444; G->thunkpos= yythunkpos1444;
  }  if (!yy_Nonspacechar(G))  goto l1441;

  l1442:;	
  {  int yypos1443= G->pos, yythunkpos1443= G->thunkpos;
  {  int yypos1445= G->pos, yythunkpos1445= G->thunkpos;  if (!yymatchChar(G, '`')) goto l1445;
  goto l1443;
  l1445:;	  G->pos= yypos1445; G->thunkpos= yythunkpos1445;
  }  if (!yy_Nonspacechar(G))  goto l1443;
  goto l1442;
  l1443:;	  G->pos= yypos1443; G->thunkpos= yythunkpos1443;
  }  goto l1440;
  l1441:;	  G->pos= yypos1440; G->thunkpos= yythunkpos1440;
  {  int yypos1447= G->pos, yythunkpos1447= G->thunkpos;  if (!yy_Ticks3(G))  goto l1447;
  goto l1446;
  l1447:;	  G->pos= yypos1447; G->thunkpos= yythunkpos1447;
  }  if (!yymatchChar(G, '`')) goto l1446;

  l1448:;	
  {  int yypos1449= G->pos, yythunkpos1449= G->thunkpos;  if (!yymatchChar(G, '`')) goto l1449;
  goto l1448;
  l1449:;	  G->pos= yypos1449; G->thunkpos= yythunkpos1449;
  }  goto l1440;
  l1446:;	  G->pos= yypos1440; G->thunkpos= yythunkpos1440;
  {  int yypos1450= G->pos, yythunkpos1450= G->thunkpos;  if (!yy_Sp(G))  goto l1450;
  if (!yy_Ticks3(G))  goto l1450;
  goto l1425;
  l1450:;	  G->pos= yypos1450; G->thunkpos= yythunkpos1450;
  }
  {  int yypos1451= G->pos, yythunkpos1451= G->thunkpos;  if (!yy_Spacechar(G))  goto l1452;
  goto l1451;
  l1452:;	  G->pos= yypos1451; G->thunkpos= yythunkpos1451;  if (!yy_Newline(G))  goto l1425;

  {  int yypos1453= G->pos, yythunkpos1453= G->thunkpos;  if (!yy_BlankLine(G))  goto l1453;
  goto l1425;
  l1453:;	  G->pos= yypos1453; G->thunkpos= yythunkpos1453;
  }
  }
  l1451:;	
  }
  l1440:;	  goto l1424;
  l1425:;	  G->pos= yypos1425; G->thunkpos= yythunkpos1425;
  }  yyText(G, G->begin, G->end);  if (!(YY_END)) goto l1423;  if (!yy_Sp(G))  goto l1423;
  if (!yy_Ticks3(G))  goto l1423;
  goto l1360;
  l1423:;	  G->pos= yypos1360; G->thunkpos= yythunkpos1360;  if (!yy_Ticks4(G))  goto l1454;
  if (!yy_Sp(G))  goto l1454;
  yyText(G, G->begin, G->end);  if (!(YY_BEGIN)) goto l1454;
  {  int yypos1457= G->pos, yythunkpos1457= G->thunkpos;
  {  int yypos1461= G->pos, yythunkpos1461= G->thunkpos;  if (!yymatchChar(G, '`')) goto l1461;
  goto l1458;
  l1461:;	  G->pos= yypos1461; G->thunkpos= yythunkpos1461;
  }  if (!yy_Nonspacechar(G))  goto l1458;

  l1459:;	
  {  int yypos1460= G->pos, yythunkpos1460= G->thunkpos;
  {  int yypos1462= G->pos, yythunkpos1462= G->thunkpos;  if (!yymatchChar(G, '`')) goto l1462;
  goto l1460;
  l1462:;	  G->pos= yypos1462; G->thunkpos= yythunkpos1462;
  }  if (!yy_Nonspacechar(G))  goto l1460;
  goto l1459;
  l1460:;	  G->pos= yypos1460; G->thunkpos= yythunkpos1460;
  }  goto l1457;
  l1458:;	  G->pos= yypos1457; G->thunkpos= yythunkpos1457;
  {  int yypos1464= G->pos, yythunkpos1464= G->thunkpos;  if (!yy_Ticks4(G))  goto l1464;
  goto l1463;
  l1464:;	  G->pos= yypos1464; G->thunkpos= yythunkpos1464;
  }  if (!yymatchChar(G, '`')) goto l1463;

  l1465:;	
  {  int yypos1466= G->pos, yythunkpos1466= G->thunkpos;  if (!yymatchChar(G, '`')) goto l1466;
  goto l1465;
  l1466:;	  G->pos= yypos1466; G->thunkpos= yythunkpos1466;
  }  goto l1457;
  l1463:;	  G->pos= yypos1457; G->thunkpos= yythunkpos1457;
  {  int yypos1467= G->pos, yythunkpos1467= G->thunkpos;  if (!yy_Sp(G))  goto l1467;
  if (!yy_Ticks4(G))  goto l1467;
  goto l1454;
  l1467:;	  G->pos= yypos1467; G->thunkpos= yythunkpos1467;
  }
  {  int yypos1468= G->pos, yythunkpos1468= G->thunkpos;  if (!yy_Spacechar(G))  goto l1469;
  goto l1468;
  l1469:;	  G->pos= yypos1468; G->thunkpos= yythunkpos1468;  if (!yy_Newline(G))  goto l1454;

  {  int yypos1470= G->pos, yythunkpos1470= G->thunkpos;  if (!yy_BlankLine(G))  goto l1470;
  goto l1454;
  l1470:;	  G->pos= yypos1470; G->thunkpos= yythunkpos1470;
  }
  }
  l1468:;	
  }
  l1457:;	
  l1455:;	
  {  int yypos1456= G->pos, yythunkpos1456= G->thunkpos;
  {  int yypos1471= G->pos, yythunkpos1471= G->thunkpos;
  {  int yypos1475= G->pos, yythunkpos1475= G->thunkpos;  if (!yymatchChar(G, '`')) goto l1475;
  goto l1472;
  l1475:;	  G->pos= yypos1475; G->thunkpos= yythunkpos1475;
  }  if (!yy_Nonspacechar(G))  goto l1472;

  l1473:;	
  {  int yypos1474= G->pos, yythunkpos1474= G->thunkpos;
  {  int yypos1476= G->pos, yythunkpos1476= G->thunkpos;  if (!yymatchChar(G, '`')) goto l1476;
  goto l1474;
  l1476:;	  G->pos= yypos1476; G->thunkpos= yythunkpos1476;
  }  if (!yy_Nonspacechar(G))  goto l1474;
  goto l1473;
  l1474:;	  G->pos= yypos1474; G->thunkpos= yythunkpos1474;
  }  goto l1471;
  l1472:;	  G->pos= yypos1471; G->thunkpos= yythunkpos1471;
  {  int yypos1478= G->pos, yythunkpos1478= G->thunkpos;  if (!yy_Ticks4(G))  goto l1478;
  goto l1477;
  l1478:;	  G->pos= yypos1478; G->thunkpos= yythunkpos1478;
  }  if (!yymatchChar(G, '`')) goto l1477;

  l1479:;	
  {  int yypos1480= G->pos, yythunkpos1480= G->thunkpos;  if (!yymatchChar(G, '`')) goto l1480;
  goto l1479;
  l1480:;	  G->pos= yypos1480; G->thunkpos= yythunkpos1480;
  }  goto l1471;
  l1477:;	  G->pos= yypos1471; G->thunkpos= yythunkpos1471;
  {  int yypos1481= G->pos, yythunkpos1481= G->thunkpos;  if (!yy_Sp(G))  goto l1481;
  if (!yy_Ticks4(G))  goto l1481;
  goto l1456;
  l1481:;	  G->pos= yypos1481; G->thunkpos= yythunkpos1481;
  }
  {  int yypos1482= G->pos, yythunkpos1482= G->thunkpos;  if (!yy_Spacechar(G))  goto l1483;
  goto l1482;
  l1483:;	  G->pos= yypos1482; G->thunkpos= yythunkpos1482;  if (!yy_Newline(G))  goto l1456;

  {  int yypos1484= G->pos, yythunkpos1484= G->thunkpos;  if (!yy_BlankLine(G))  goto l1484;
  goto l1456;
  l1484:;	  G->pos= yypos1484; G->thunkpos= yythunkpos1484;
  }
  }
  l1482:;	
  }
  l1471:;	  goto l1455;
  l1456:;	  G->pos= yypos1456; G->thunkpos= yythunkpos1456;
  }  yyText(G, G->begin, G->end);  if (!(YY_END)) goto l1454;  if (!yy_Sp(G))  goto l1454;
  if (!yy_Ticks4(G))  goto l1454;
  goto l1360;
  l1454:;	  G->pos= yypos1360; G->thunkpos= yythunkpos1360;  if (!yy_Ticks5(G))  goto l1359;
  if (!yy_Sp(G))  goto l1359;
  yyText(G, G->begin, G->end);  if (!(YY_BEGIN)) goto l1359;
  {  int yypos1487= G->pos, yythunkpos1487= G->thunkpos;
  {  int yypos1491= G->pos, yythunkpos1491= G->thunkpos;  if (!yymatchChar(G, '`')) goto l1491;
  goto l1488;
  l1491:;	  G->pos= yypos1491; G->thunkpos= yythunkpos1491;
  }  if (!yy_Nonspacechar(G))  goto l1488;

  l1489:;	
  {  int yypos1490= G->pos, yythunkpos1490= G->thunkpos;
  {  int yypos1492= G->pos, yythunkpos1492= G->thunkpos;  if (!yymatchChar(G, '`')) goto l1492;
  goto l1490;
  l1492:;	  G->pos= yypos1492; G->thunkpos= yythunkpos1492;
  }  if (!yy_Nonspacechar(G))  goto l1490;
  goto l1489;
  l1490:;	  G->pos= yypos1490; G->thunkpos= yythunkpos1490;
  }  goto l1487;
  l1488:;	  G->pos= yypos1487; G->thunkpos= yythunkpos1487;
  {  int yypos1494= G->pos, yythunkpos1494= G->thunkpos;  if (!yy_Ticks5(G))  goto l1494;
  goto l1493;
  l1494:;	  G->pos= yypos1494; G->thunkpos= yythunkpos1494;
  }  if (!yymatchChar(G, '`')) goto l1493;

  l1495:;	
  {  int yypos1496= G->pos, yythunkpos1496= G->thunkpos;  if (!yymatchChar(G, '`')) goto l1496;
  goto l1495;
  l1496:;	  G->pos= yypos1496; G->thunkpos= yythunkpos1496;
  }  goto l1487;
  l1493:;	  G->pos= yypos1487; G->thunkpos= yythunkpos1487;
  {  int yypos1497= G->pos, yythunkpos1497= G->thunkpos;  if (!yy_Sp(G))  goto l1497;
  if (!yy_Ticks5(G))  goto l1497;
  goto l1359;
  l1497:;	  G->pos= yypos1497; G->thunkpos= yythunkpos1497;
  }
  {  int yypos1498= G->pos, yythunkpos1498= G->thunkpos;  if (!yy_Spacechar(G))  goto l1499;
  goto l1498;
  l1499:;	  G->pos= yypos1498; G->thunkpos= yythunkpos1498;  if (!yy_Newline(G))  goto l1359;

  {  int yypos1500= G->pos, yythunkpos1500= G->thunkpos;  if (!yy_BlankLine(G))  goto l1500;
  goto l1359;
  l1500:;	  G->pos= yypos1500; G->thunkpos= yythunkpos1500;
  }
  }
  l1498:;	
  }
  l1487:;	
  l1485:;	
  {  int yypos1486= G->pos, yythunkpos1486= G->thunkpos;
  {  int yypos1501= G->pos, yythunkpos1501= G->thunkpos;
  {  int yypos1505= G->pos, yythunkpos1505= G->thunkpos;  if (!yymatchChar(G, '`')) goto l1505;
  goto l1502;
  l1505:;	  G->pos= yypos1505; G->thunkpos= yythunkpos1505;
  }  if (!yy_Nonspacechar(G))  goto l1502;

  l1503:;	
  {  int yypos1504= G->pos, yythunkpos1504= G->thunkpos;
  {  int yypos1506= G->pos, yythunkpos1506= G->thunkpos;  if (!yymatchChar(G, '`')) goto l1506;
  goto l1504;
  l1506:;	  G->pos= yypos1506; G->thunkpos= yythunkpos1506;
  }  if (!yy_Nonspacechar(G))  goto l1504;
  goto l1503;
  l1504:;	  G->pos= yypos1504; G->thunkpos= yythunkpos1504;
  }  goto l1501;
  l1502:;	  G->pos= yypos1501; G->thunkpos= yythunkpos1501;
  {  int yypos1508= G->pos, yythunkpos1508= G->thunkpos;  if (!yy_Ticks5(G))  goto l1508;
  goto l1507;
  l1508:;	  G->pos= yypos1508; G->thunkpos= yythunkpos1508;
  }  if (!yymatchChar(G, '`')) goto l1507;

  l1509:;	
  {  int yypos1510= G->pos, yythunkpos1510= G->thunkpos;  if (!yymatchChar(G, '`')) goto l1510;
  goto l1509;
  l1510:;	  G->pos= yypos1510; G->thunkpos= yythunkpos1510;
  }  goto l1501;
  l1507:;	  G->pos= yypos1501; G->thunkpos= yythunkpos1501;
  {  int yypos1511= G->pos, yythunkpos1511= G->thunkpos;  if (!yy_Sp(G))  goto l1511;
  if (!yy_Ticks5(G))  goto l1511;
  goto l1486;
  l1511:;	  G->pos= yypos1511; G->thunkpos= yythunkpos1511;
  }
  {  int yypos1512= G->pos, yythunkpos1512= G->thunkpos;  if (!yy_Spacechar(G))  goto l1513;
  goto l1512;
  l1513:;	  G->pos= yypos1512; G->thunkpos= yythunkpos1512;  if (!yy_Newline(G))  goto l1486;

  {  int yypos1514= G->pos, yythunkpos1514= G->thunkpos;  if (!yy_BlankLine(G))  goto l1514;
  goto l1486;
  l1514:;	  G->pos= yypos1514; G->thunkpos= yythunkpos1514;
  }
  }
  l1512:;	
  }
  l1501:;	  goto l1485;
  l1486:;	  G->pos= yypos1486; G->thunkpos= yythunkpos1486;
  }  yyText(G, G->begin, G->end);  if (!(YY_END)) goto l1359;  if (!yy_Sp(G))  goto l1359;
  if (!yy_Ticks5(G))  goto l1359;

  }
  l1360:;	  yyDo(G, yy_1_Code, G->begin, G->end, "yy_1_Code");
  yyprintf((stderr, "  ok   Code"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l1359:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "Code"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_NoteReference(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "NoteReference"));
  yyText(G, G->begin, G->end);  if (!( ext(EXT_NOTES) )) goto l1515;  if (!yymatchString(G, "[^")) goto l1515;
  yyText(G, G->begin, G->end);  if (!(YY_BEGIN)) goto l1515;
  {  int yypos1518= G->pos, yythunkpos1518= G->thunkpos;  if (!yy_Newline(G))  goto l1518;
  goto l1515;
  l1518:;	  G->pos= yypos1518; G->thunkpos= yythunkpos1518;
  }
  {  int yypos1519= G->pos, yythunkpos1519= G->thunkpos;  if (!yymatchChar(G, ']')) goto l1519;
  goto l1515;
  l1519:;	  G->pos= yypos1519; G->thunkpos= yythunkpos1519;
  }  if (!yymatchDot(G)) goto l1515;
  l1516:;	
  {  int yypos1517= G->pos, yythunkpos1517= G->thunkpos;
  {  int yypos1520= G->pos, yythunkpos1520= G->thunkpos;  if (!yy_Newline(G))  goto l1520;
  goto l1517;
  l1520:;	  G->pos= yypos1520; G->thunkpos= yythunkpos1520;
  }
  {  int yypos1521= G->pos, yythunkpos1521= G->thunkpos;  if (!yymatchChar(G, ']')) goto l1521;
  goto l1517;
  l1521:;	  G->pos= yypos1521; G->thunkpos= yythunkpos1521;
  }  if (!yymatchDot(G)) goto l1517;  goto l1516;
  l1517:;	  G->pos= yypos1517; G->thunkpos= yythunkpos1517;
  }  yyText(G, G->begin, G->end);  if (!(YY_END)) goto l1515;  if (!yymatchChar(G, ']')) goto l1515;
  yyDo(G, yy_1_NoteReference, G->begin, G->end, "yy_1_NoteReference");
  yyprintf((stderr, "  ok   NoteReference"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l1515:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "NoteReference"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_Link(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "Link"));

  {  int yypos1523= G->pos, yythunkpos1523= G->thunkpos;  if (!yy_ExplicitLink(G))  goto l1524;
  goto l1523;
  l1524:;	  G->pos= yypos1523; G->thunkpos= yythunkpos1523;  if (!yy_ReferenceLink(G))  goto l1525;
  goto l1523;
  l1525:;	  G->pos= yypos1523; G->thunkpos= yythunkpos1523;  if (!yy_AutoLink(G))  goto l1522;

  }
  l1523:;	  yyprintf((stderr, "  ok   Link"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l1522:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "Link"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_Image(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "Image"));
  if (!yymatchChar(G, '!')) goto l1526;

  {  int yypos1527= G->pos, yythunkpos1527= G->thunkpos;  if (!yy_AutoLink(G))  goto l1527;
  goto l1526;
  l1527:;	  G->pos= yypos1527; G->thunkpos= yythunkpos1527;
  }  if (!yy_Link(G))  goto l1526;
  yyDo(G, yy_1_Image, G->begin, G->end, "yy_1_Image");
  yyprintf((stderr, "  ok   Image"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l1526:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "Image"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_CitationReference(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "CitationReference"));

  {  int yypos1529= G->pos, yythunkpos1529= G->thunkpos;  if (!yy_CitationReferenceDouble(G))  goto l1530;
  goto l1529;
  l1530:;	  G->pos= yypos1529; G->thunkpos= yythunkpos1529;  if (!yy_CitationReferenceSingle(G))  goto l1528;

  }
  l1529:;	  yyprintf((stderr, "  ok   CitationReference"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l1528:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "CitationReference"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_Emph(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "Emph"));

  {  int yypos1532= G->pos, yythunkpos1532= G->thunkpos;  if (!yy_EmphStar(G))  goto l1533;
  goto l1532;
  l1533:;	  G->pos= yypos1532; G->thunkpos= yythunkpos1532;  if (!yy_EmphUl(G))  goto l1531;

  }
  l1532:;	  yyprintf((stderr, "  ok   Emph"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l1531:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "Emph"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_Strong(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "Strong"));

  {  int yypos1535= G->pos, yythunkpos1535= G->thunkpos;  if (!yy_StrongStar(G))  goto l1536;
  goto l1535;
  l1536:;	  G->pos= yypos1535; G->thunkpos= yythunkpos1535;  if (!yy_StrongUl(G))  goto l1534;

  }
  l1535:;	  yyprintf((stderr, "  ok   Strong"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l1534:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "Strong"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_Space(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "Space"));
  if (!yy_Spacechar(G))  goto l1537;

  l1538:;	
  {  int yypos1539= G->pos, yythunkpos1539= G->thunkpos;  if (!yy_Spacechar(G))  goto l1539;
  goto l1538;
  l1539:;	  G->pos= yypos1539; G->thunkpos= yythunkpos1539;
  }  yyDo(G, yy_1_Space, G->begin, G->end, "yy_1_Space");
  yyprintf((stderr, "  ok   Space"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l1537:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "Space"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_UlOrStarLine(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "UlOrStarLine"));

  {  int yypos1541= G->pos, yythunkpos1541= G->thunkpos;  if (!yy_UlLine(G))  goto l1542;
  goto l1541;
  l1542:;	  G->pos= yypos1541; G->thunkpos= yythunkpos1541;  if (!yy_StarLine(G))  goto l1540;

  }
  l1541:;	  yyDo(G, yy_1_UlOrStarLine, G->begin, G->end, "yy_1_UlOrStarLine");
  yyprintf((stderr, "  ok   UlOrStarLine"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l1540:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "UlOrStarLine"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_MathSpan(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "MathSpan"));
  if (!yymatchChar(G, '\\')) goto l1543;
  yyText(G, G->begin, G->end);  if (!(YY_BEGIN)) goto l1543;
  {  int yypos1544= G->pos, yythunkpos1544= G->thunkpos;  if (!yymatchString(G, "\\[")) goto l1545;

  l1546:;	
  {  int yypos1547= G->pos, yythunkpos1547= G->thunkpos;
  {  int yypos1548= G->pos, yythunkpos1548= G->thunkpos;  if (!yymatchString(G, "\\\\]")) goto l1548;
  goto l1547;
  l1548:;	  G->pos= yypos1548; G->thunkpos= yythunkpos1548;
  }  if (!yymatchDot(G)) goto l1547;  goto l1546;
  l1547:;	  G->pos= yypos1547; G->thunkpos= yythunkpos1547;
  }  if (!yymatchString(G, "\\\\]")) goto l1545;
  goto l1544;
  l1545:;	  G->pos= yypos1544; G->thunkpos= yythunkpos1544;  if (!yymatchString(G, "\\(")) goto l1543;

  l1549:;	
  {  int yypos1550= G->pos, yythunkpos1550= G->thunkpos;
  {  int yypos1551= G->pos, yythunkpos1551= G->thunkpos;  if (!yymatchString(G, "\\\\)")) goto l1551;
  goto l1550;
  l1551:;	  G->pos= yypos1551; G->thunkpos= yythunkpos1551;
  }  if (!yymatchDot(G)) goto l1550;  goto l1549;
  l1550:;	  G->pos= yypos1550; G->thunkpos= yythunkpos1550;
  }  if (!yymatchString(G, "\\\\)")) goto l1543;

  }
  l1544:;	  yyText(G, G->begin, G->end);  if (!(YY_END)) goto l1543;  yyDo(G, yy_1_MathSpan, G->begin, G->end, "yy_1_MathSpan");
  yyprintf((stderr, "  ok   MathSpan"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l1543:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "MathSpan"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_Str(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyDo(G, yyPush, 1, 0, "yyPush");
  yyprintfv((stderr, "%s\n", "Str"));
  if (!yy_StartList(G))  goto l1552;
  yyDo(G, yySet, -1, 0, "yySet");
  yyText(G, G->begin, G->end);  if (!(YY_BEGIN)) goto l1552;  if (!yy_NormalChar(G))  goto l1552;

  l1553:;	
  {  int yypos1554= G->pos, yythunkpos1554= G->thunkpos;  if (!yy_NormalChar(G))  goto l1554;
  goto l1553;
  l1554:;	  G->pos= yypos1554; G->thunkpos= yythunkpos1554;
  }  yyText(G, G->begin, G->end);  if (!(YY_END)) goto l1552;  yyDo(G, yy_1_Str, G->begin, G->end, "yy_1_Str");

  l1555:;	
  {  int yypos1556= G->pos, yythunkpos1556= G->thunkpos;  if (!yy_StrChunk(G))  goto l1556;
  yyDo(G, yy_2_Str, G->begin, G->end, "yy_2_Str");
  goto l1555;
  l1556:;	  G->pos= yypos1556; G->thunkpos= yythunkpos1556;
  }  yyDo(G, yy_3_Str, G->begin, G->end, "yy_3_Str");
  yyprintf((stderr, "  ok   Str"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));
  yyDo(G, yyPop, 1, 0, "yyPop");
  return 1;
  l1552:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "Str"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_DollarMath(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "DollarMath"));

  {  int yypos1558= G->pos, yythunkpos1558= G->thunkpos;  if (!yy_SingleDollarMath(G))  goto l1559;
  goto l1558;
  l1559:;	  G->pos= yypos1558; G->thunkpos= yythunkpos1558;  if (!yy_DoubleDollarMath(G))  goto l1557;

  }
  l1558:;	  yyprintf((stderr, "  ok   DollarMath"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l1557:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "DollarMath"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_CriticMarkup(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "CriticMarkup"));

  {  int yypos1561= G->pos, yythunkpos1561= G->thunkpos;  if (!yy_CriticAddition(G))  goto l1562;
  goto l1561;
  l1562:;	  G->pos= yypos1561; G->thunkpos= yythunkpos1561;  if (!yy_CriticDeletion(G))  goto l1563;
  goto l1561;
  l1563:;	  G->pos= yypos1561; G->thunkpos= yythunkpos1561;  if (!yy_CriticSubstitution(G))  goto l1564;
  goto l1561;
  l1564:;	  G->pos= yypos1561; G->thunkpos= yythunkpos1561;  if (!yy_CriticHighlight(G))  goto l1565;
  goto l1561;
  l1565:;	  G->pos= yypos1561; G->thunkpos= yythunkpos1561;  if (!yy_CriticComment(G))  goto l1560;

  }
  l1561:;	  yyprintf((stderr, "  ok   CriticMarkup"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l1560:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "CriticMarkup"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_voidEndline(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "voidEndline"));

  {  int yypos1567= G->pos, yythunkpos1567= G->thunkpos;  if (!yymatchString(G, "  ")) goto l1568;
  if (!yy_voidNormalEndline(G))  goto l1568;
  goto l1567;
  l1568:;	  G->pos= yypos1567; G->thunkpos= yythunkpos1567;  if (!yy_Sp(G))  goto l1569;
  if (!yy_Newline(G))  goto l1569;
  if (!yy_Eof(G))  goto l1569;
  goto l1567;
  l1569:;	  G->pos= yypos1567; G->thunkpos= yythunkpos1567;  if (!yy_voidNormalEndline(G))  goto l1566;

  }
  l1567:;	  yyprintf((stderr, "  ok   voidEndline"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l1566:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "voidEndline"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_Inlines(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyDo(G, yyPush, 2, 0, "yyPush");
  yyprintfv((stderr, "%s\n", "Inlines"));
  if (!yy_StartList(G))  goto l1570;
  yyDo(G, yySet, -2, 0, "yySet");

  {  int yypos1573= G->pos, yythunkpos1573= G->thunkpos;
  {  int yypos1575= G->pos, yythunkpos1575= G->thunkpos;  if (!yy_Endline(G))  goto l1575;
  goto l1574;
  l1575:;	  G->pos= yypos1575; G->thunkpos= yythunkpos1575;
  }  if (!yy_Inline(G))  goto l1574;
  yyDo(G, yy_1_Inlines, G->begin, G->end, "yy_1_Inlines");
  goto l1573;
  l1574:;	  G->pos= yypos1573; G->thunkpos= yythunkpos1573;  if (!yy_Endline(G))  goto l1570;
  yyDo(G, yySet, -1, 0, "yySet");

  {  int yypos1576= G->pos, yythunkpos1576= G->thunkpos;  if (!yy_Inline(G))  goto l1570;
  G->pos= yypos1576; G->thunkpos= yythunkpos1576;
  }  yyDo(G, yy_2_Inlines, G->begin, G->end, "yy_2_Inlines");

  }
  l1573:;	
  l1571:;	
  {  int yypos1572= G->pos, yythunkpos1572= G->thunkpos;
  {  int yypos1577= G->pos, yythunkpos1577= G->thunkpos;
  {  int yypos1579= G->pos, yythunkpos1579= G->thunkpos;  if (!yy_Endline(G))  goto l1579;
  goto l1578;
  l1579:;	  G->pos= yypos1579; G->thunkpos= yythunkpos1579;
  }  if (!yy_Inline(G))  goto l1578;
  yyDo(G, yy_1_Inlines, G->begin, G->end, "yy_1_Inlines");
  goto l1577;
  l1578:;	  G->pos= yypos1577; G->thunkpos= yythunkpos1577;  if (!yy_Endline(G))  goto l1572;
  yyDo(G, yySet, -1, 0, "yySet");

  {  int yypos1580= G->pos, yythunkpos1580= G->thunkpos;  if (!yy_Inline(G))  goto l1572;
  G->pos= yypos1580; G->thunkpos= yythunkpos1580;
  }  yyDo(G, yy_2_Inlines, G->begin, G->end, "yy_2_Inlines");

  }
  l1577:;	  goto l1571;
  l1572:;	  G->pos= yypos1572; G->thunkpos= yythunkpos1572;
  }
  {  int yypos1581= G->pos, yythunkpos1581= G->thunkpos;  if (!yy_voidEndline(G))  goto l1581;
  goto l1582;
  l1581:;	  G->pos= yypos1581; G->thunkpos= yythunkpos1581;
  }
  l1582:;	  yyDo(G, yy_3_Inlines, G->begin, G->end, "yy_3_Inlines");
  yyprintf((stderr, "  ok   Inlines"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));
  yyDo(G, yyPop, 2, 0, "yyPop");
  return 1;
  l1570:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "Inlines"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_Entity(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "Entity"));

  {  int yypos1584= G->pos, yythunkpos1584= G->thunkpos;  if (!yy_HexEntity(G))  goto l1585;
  goto l1584;
  l1585:;	  G->pos= yypos1584; G->thunkpos= yythunkpos1584;  if (!yy_DecEntity(G))  goto l1586;
  goto l1584;
  l1586:;	  G->pos= yypos1584; G->thunkpos= yythunkpos1584;  if (!yy_CharEntity(G))  goto l1583;

  }
  l1584:;	  yyDo(G, yy_1_Entity, G->begin, G->end, "yy_1_Entity");
  yyprintf((stderr, "  ok   Entity"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l1583:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "Entity"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_EscapedChar(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "EscapedChar"));
  if (!yymatchChar(G, '\\')) goto l1587;

  {  int yypos1588= G->pos, yythunkpos1588= G->thunkpos;  if (!yy_Newline(G))  goto l1588;
  goto l1587;
  l1588:;	  G->pos= yypos1588; G->thunkpos= yythunkpos1588;
  }  yyText(G, G->begin, G->end);  if (!(YY_BEGIN)) goto l1587;  if (!yymatchClass(G, (unsigned char *)"\000\000\000\000\236\157\000\120\000\000\000\270\001\000\000\070\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000", "-\\\\`|*_{}[\\]()#+.!$><'\"\"")) goto l1587;
  yyText(G, G->begin, G->end);  if (!(YY_END)) goto l1587;  yyDo(G, yy_1_EscapedChar, G->begin, G->end, "yy_1_EscapedChar");
  yyprintf((stderr, "  ok   EscapedChar"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l1587:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "EscapedChar"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_Symbol(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "Symbol"));
  yyText(G, G->begin, G->end);  if (!(YY_BEGIN)) goto l1589;  if (!yy_SpecialChar(G))  goto l1589;
  yyText(G, G->begin, G->end);  if (!(YY_END)) goto l1589;  yyDo(G, yy_1_Symbol, G->begin, G->end, "yy_1_Symbol");
  yyprintf((stderr, "  ok   Symbol"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l1589:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "Symbol"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_OptionallyIndentedLine(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "OptionallyIndentedLine"));

  {  int yypos1591= G->pos, yythunkpos1591= G->thunkpos;  if (!yy_Indent(G))  goto l1591;
  goto l1592;
  l1591:;	  G->pos= yypos1591; G->thunkpos= yythunkpos1591;
  }
  l1592:;	  if (!yy_Line(G))  goto l1590;
  yyprintf((stderr, "  ok   OptionallyIndentedLine"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l1590:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "OptionallyIndentedLine"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_IndentedLine(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "IndentedLine"));
  if (!yy_Indent(G))  goto l1593;
  if (!yy_Line(G))  goto l1593;
  yyprintf((stderr, "  ok   IndentedLine"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l1593:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "IndentedLine"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_Indent(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "Indent"));

  {  int yypos1595= G->pos, yythunkpos1595= G->thunkpos;  if (!yymatchChar(G, '\t')) goto l1596;
  goto l1595;
  l1596:;	  G->pos= yypos1595; G->thunkpos= yythunkpos1595;  if (!yymatchString(G, "    ")) goto l1594;

  }
  l1595:;	  yyprintf((stderr, "  ok   Indent"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l1594:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "Indent"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_NonindentSpace(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "NonindentSpace"));

  {  int yypos1598= G->pos, yythunkpos1598= G->thunkpos;  if (!yymatchString(G, "   ")) goto l1599;
  goto l1598;
  l1599:;	  G->pos= yypos1598; G->thunkpos= yythunkpos1598;  if (!yymatchString(G, "  ")) goto l1600;
  goto l1598;
  l1600:;	  G->pos= yypos1598; G->thunkpos= yythunkpos1598;  if (!yymatchChar(G, ' ')) goto l1601;
  goto l1598;
  l1601:;	  G->pos= yypos1598; G->thunkpos= yythunkpos1598;  if (!yymatchString(G, "")) goto l1597;

  }
  l1598:;	  yyprintf((stderr, "  ok   NonindentSpace"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l1597:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "NonindentSpace"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_CharEntity(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "CharEntity"));
  yyText(G, G->begin, G->end);  if (!(YY_BEGIN)) goto l1602;  if (!yymatchChar(G, '&')) goto l1602;
  if (!yymatchClass(G, (unsigned char *)"\000\000\000\000\000\000\377\003\376\377\377\007\376\377\377\007\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000", "A-Za-z0-9")) goto l1602;

  l1603:;	
  {  int yypos1604= G->pos, yythunkpos1604= G->thunkpos;  if (!yymatchClass(G, (unsigned char *)"\000\000\000\000\000\000\377\003\376\377\377\007\376\377\377\007\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000", "A-Za-z0-9")) goto l1604;
  goto l1603;
  l1604:;	  G->pos= yypos1604; G->thunkpos= yythunkpos1604;
  }  if (!yymatchChar(G, ';')) goto l1602;
  yyText(G, G->begin, G->end);  if (!(YY_END)) goto l1602;  yyprintf((stderr, "  ok   CharEntity"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l1602:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "CharEntity"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_DecEntity(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "DecEntity"));
  yyText(G, G->begin, G->end);  if (!(YY_BEGIN)) goto l1605;  if (!yymatchChar(G, '&')) goto l1605;
  if (!yymatchChar(G, '#')) goto l1605;
  if (!yymatchClass(G, (unsigned char *)"\000\000\000\000\000\000\377\003\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000", "0-9")) goto l1605;

  l1606:;	
  {  int yypos1607= G->pos, yythunkpos1607= G->thunkpos;  if (!yymatchClass(G, (unsigned char *)"\000\000\000\000\000\000\377\003\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000", "0-9")) goto l1607;
  goto l1606;
  l1607:;	  G->pos= yypos1607; G->thunkpos= yythunkpos1607;
  }  yyText(G, G->begin, G->end);  if (!(YY_END)) goto l1605;  if (!yymatchChar(G, ';')) goto l1605;
  yyText(G, G->begin, G->end);  if (!(YY_END)) goto l1605;  yyprintf((stderr, "  ok   DecEntity"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l1605:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "DecEntity"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_HexEntity(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "HexEntity"));
  yyText(G, G->begin, G->end);  if (!(YY_BEGIN)) goto l1608;  if (!yymatchChar(G, '&')) goto l1608;
  if (!yymatchChar(G, '#')) goto l1608;
  if (!yymatchClass(G, (unsigned char *)"\000\000\000\000\000\000\000\000\000\000\000\001\000\000\000\001\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000", "Xx")) goto l1608;
  if (!yymatchClass(G, (unsigned char *)"\000\000\000\000\000\000\377\003\176\000\000\000\176\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000", "0-9a-fA-F")) goto l1608;

  l1609:;	
  {  int yypos1610= G->pos, yythunkpos1610= G->thunkpos;  if (!yymatchClass(G, (unsigned char *)"\000\000\000\000\000\000\377\003\176\000\000\000\176\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000", "0-9a-fA-F")) goto l1610;
  goto l1609;
  l1610:;	  G->pos= yypos1610; G->thunkpos= yythunkpos1610;
  }  if (!yymatchChar(G, ';')) goto l1608;
  yyText(G, G->begin, G->end);  if (!(YY_END)) goto l1608;  yyprintf((stderr, "  ok   HexEntity"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l1608:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "HexEntity"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_Digit(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "Digit"));
  if (!yymatchClass(G, (unsigned char *)"\000\000\000\000\000\000\377\003\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000", "0-9")) goto l1611;
  yyprintf((stderr, "  ok   Digit"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l1611:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "Digit"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_Alphanumeric(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "Alphanumeric"));

  {  int yypos1613= G->pos, yythunkpos1613= G->thunkpos;  if (!yymatchClass(G, (unsigned char *)"\000\000\000\000\000\000\377\003\376\377\377\007\376\377\377\007\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000", "0-9A-Za-z")) goto l1614;
  goto l1613;
  l1614:;	  G->pos= yypos1613; G->thunkpos= yythunkpos1613;  if (!yymatchString(G, "\200")) goto l1615;
  goto l1613;
  l1615:;	  G->pos= yypos1613; G->thunkpos= yythunkpos1613;  if (!yymatchString(G, "\201")) goto l1616;
  goto l1613;
  l1616:;	  G->pos= yypos1613; G->thunkpos= yythunkpos1613;  if (!yymatchString(G, "\202")) goto l1617;
  goto l1613;
  l1617:;	  G->pos= yypos1613; G->thunkpos= yythunkpos1613;  if (!yymatchString(G, "\203")) goto l1618;
  goto l1613;
  l1618:;	  G->pos= yypos1613; G->thunkpos= yythunkpos1613;  if (!yymatchString(G, "\204")) goto l1619;
  goto l1613;
  l1619:;	  G->pos= yypos1613; G->thunkpos= yythunkpos1613;  if (!yymatchString(G, "\205")) goto l1620;
  goto l1613;
  l1620:;	  G->pos= yypos1613; G->thunkpos= yythunkpos1613;  if (!yymatchString(G, "\206")) goto l1621;
  goto l1613;
  l1621:;	  G->pos= yypos1613; G->thunkpos= yythunkpos1613;  if (!yymatchString(G, "\207")) goto l1622;
  goto l1613;
  l1622:;	  G->pos= yypos1613; G->thunkpos= yythunkpos1613;  if (!yymatchString(G, "\210")) goto l1623;
  goto l1613;
  l1623:;	  G->pos= yypos1613; G->thunkpos= yythunkpos1613;  if (!yymatchString(G, "\211")) goto l1624;
  goto l1613;
  l1624:;	  G->pos= yypos1613; G->thunkpos= yythunkpos1613;  if (!yymatchString(G, "\212")) goto l1625;
  goto l1613;
  l1625:;	  G->pos= yypos1613; G->thunkpos= yythunkpos1613;  if (!yymatchString(G, "\213")) goto l1626;
  goto l1613;
  l1626:;	  G->pos= yypos1613; G->thunkpos= yythunkpos1613;  if (!yymatchString(G, "\214")) goto l1627;
  goto l1613;
  l1627:;	  G->pos= yypos1613; G->thunkpos= yythunkpos1613;  if (!yymatchString(G, "\215")) goto l1628;
  goto l1613;
  l1628:;	  G->pos= yypos1613; G->thunkpos= yythunkpos1613;  if (!yymatchString(G, "\216")) goto l1629;
  goto l1613;
  l1629:;	  G->pos= yypos1613; G->thunkpos= yythunkpos1613;  if (!yymatchString(G, "\217")) goto l1630;
  goto l1613;
  l1630:;	  G->pos= yypos1613; G->thunkpos= yythunkpos1613;  if (!yymatchString(G, "\220")) goto l1631;
  goto l1613;
  l1631:;	  G->pos= yypos1613; G->thunkpos= yythunkpos1613;  if (!yymatchString(G, "\221")) goto l1632;
  goto l1613;
  l1632:;	  G->pos= yypos1613; G->thunkpos= yythunkpos1613;  if (!yymatchString(G, "\222")) goto l1633;
  goto l1613;
  l1633:;	  G->pos= yypos1613; G->thunkpos= yythunkpos1613;  if (!yymatchString(G, "\223")) goto l1634;
  goto l1613;
  l1634:;	  G->pos= yypos1613; G->thunkpos= yythunkpos1613;  if (!yymatchString(G, "\224")) goto l1635;
  goto l1613;
  l1635:;	  G->pos= yypos1613; G->thunkpos= yythunkpos1613;  if (!yymatchString(G, "\225")) goto l1636;
  goto l1613;
  l1636:;	  G->pos= yypos1613; G->thunkpos= yythunkpos1613;  if (!yymatchString(G, "\226")) goto l1637;
  goto l1613;
  l1637:;	  G->pos= yypos1613; G->thunkpos= yythunkpos1613;  if (!yymatchString(G, "\227")) goto l1638;
  goto l1613;
  l1638:;	  G->pos= yypos1613; G->thunkpos= yythunkpos1613;  if (!yymatchString(G, "\230")) goto l1639;
  goto l1613;
  l1639:;	  G->pos= yypos1613; G->thunkpos= yythunkpos1613;  if (!yymatchString(G, "\231")) goto l1640;
  goto l1613;
  l1640:;	  G->pos= yypos1613; G->thunkpos= yythunkpos1613;  if (!yymatchString(G, "\232")) goto l1641;
  goto l1613;
  l1641:;	  G->pos= yypos1613; G->thunkpos= yythunkpos1613;  if (!yymatchString(G, "\233")) goto l1642;
  goto l1613;
  l1642:;	  G->pos= yypos1613; G->thunkpos= yythunkpos1613;  if (!yymatchString(G, "\234")) goto l1643;
  goto l1613;
  l1643:;	  G->pos= yypos1613; G->thunkpos= yythunkpos1613;  if (!yymatchString(G, "\235")) goto l1644;
  goto l1613;
  l1644:;	  G->pos= yypos1613; G->thunkpos= yythunkpos1613;  if (!yymatchString(G, "\236")) goto l1645;
  goto l1613;
  l1645:;	  G->pos= yypos1613; G->thunkpos= yythunkpos1613;  if (!yymatchString(G, "\237")) goto l1646;
  goto l1613;
  l1646:;	  G->pos= yypos1613; G->thunkpos= yythunkpos1613;  if (!yymatchString(G, "\240")) goto l1647;
  goto l1613;
  l1647:;	  G->pos= yypos1613; G->thunkpos= yythunkpos1613;  if (!yymatchString(G, "\241")) goto l1648;
  goto l1613;
  l1648:;	  G->pos= yypos1613; G->thunkpos= yythunkpos1613;  if (!yymatchString(G, "\242")) goto l1649;
  goto l1613;
  l1649:;	  G->pos= yypos1613; G->thunkpos= yythunkpos1613;  if (!yymatchString(G, "\243")) goto l1650;
  goto l1613;
  l1650:;	  G->pos= yypos1613; G->thunkpos= yythunkpos1613;  if (!yymatchString(G, "\244")) goto l1651;
  goto l1613;
  l1651:;	  G->pos= yypos1613; G->thunkpos= yythunkpos1613;  if (!yymatchString(G, "\245")) goto l1652;
  goto l1613;
  l1652:;	  G->pos= yypos1613; G->thunkpos= yythunkpos1613;  if (!yymatchString(G, "\246")) goto l1653;
  goto l1613;
  l1653:;	  G->pos= yypos1613; G->thunkpos= yythunkpos1613;  if (!yymatchString(G, "\247")) goto l1654;
  goto l1613;
  l1654:;	  G->pos= yypos1613; G->thunkpos= yythunkpos1613;  if (!yymatchString(G, "\250")) goto l1655;
  goto l1613;
  l1655:;	  G->pos= yypos1613; G->thunkpos= yythunkpos1613;  if (!yymatchString(G, "\251")) goto l1656;
  goto l1613;
  l1656:;	  G->pos= yypos1613; G->thunkpos= yythunkpos1613;  if (!yymatchString(G, "\252")) goto l1657;
  goto l1613;
  l1657:;	  G->pos= yypos1613; G->thunkpos= yythunkpos1613;  if (!yymatchString(G, "\253")) goto l1658;
  goto l1613;
  l1658:;	  G->pos= yypos1613; G->thunkpos= yythunkpos1613;  if (!yymatchString(G, "\254")) goto l1659;
  goto l1613;
  l1659:;	  G->pos= yypos1613; G->thunkpos= yythunkpos1613;  if (!yymatchString(G, "\255")) goto l1660;
  goto l1613;
  l1660:;	  G->pos= yypos1613; G->thunkpos= yythunkpos1613;  if (!yymatchString(G, "\256")) goto l1661;
  goto l1613;
  l1661:;	  G->pos= yypos1613; G->thunkpos= yythunkpos1613;  if (!yymatchString(G, "\257")) goto l1662;
  goto l1613;
  l1662:;	  G->pos= yypos1613; G->thunkpos= yythunkpos1613;  if (!yymatchString(G, "\260")) goto l1663;
  goto l1613;
  l1663:;	  G->pos= yypos1613; G->thunkpos= yythunkpos1613;  if (!yymatchString(G, "\261")) goto l1664;
  goto l1613;
  l1664:;	  G->pos= yypos1613; G->thunkpos= yythunkpos1613;  if (!yymatchString(G, "\262")) goto l1665;
  goto l1613;
  l1665:;	  G->pos= yypos1613; G->thunkpos= yythunkpos1613;  if (!yymatchString(G, "\263")) goto l1666;
  goto l1613;
  l1666:;	  G->pos= yypos1613; G->thunkpos= yythunkpos1613;  if (!yymatchString(G, "\264")) goto l1667;
  goto l1613;
  l1667:;	  G->pos= yypos1613; G->thunkpos= yythunkpos1613;  if (!yymatchString(G, "\265")) goto l1668;
  goto l1613;
  l1668:;	  G->pos= yypos1613; G->thunkpos= yythunkpos1613;  if (!yymatchString(G, "\266")) goto l1669;
  goto l1613;
  l1669:;	  G->pos= yypos1613; G->thunkpos= yythunkpos1613;  if (!yymatchString(G, "\267")) goto l1670;
  goto l1613;
  l1670:;	  G->pos= yypos1613; G->thunkpos= yythunkpos1613;  if (!yymatchString(G, "\270")) goto l1671;
  goto l1613;
  l1671:;	  G->pos= yypos1613; G->thunkpos= yythunkpos1613;  if (!yymatchString(G, "\271")) goto l1672;
  goto l1613;
  l1672:;	  G->pos= yypos1613; G->thunkpos= yythunkpos1613;  if (!yymatchString(G, "\272")) goto l1673;
  goto l1613;
  l1673:;	  G->pos= yypos1613; G->thunkpos= yythunkpos1613;  if (!yymatchString(G, "\273")) goto l1674;
  goto l1613;
  l1674:;	  G->pos= yypos1613; G->thunkpos= yythunkpos1613;  if (!yymatchString(G, "\274")) goto l1675;
  goto l1613;
  l1675:;	  G->pos= yypos1613; G->thunkpos= yythunkpos1613;  if (!yymatchString(G, "\275")) goto l1676;
  goto l1613;
  l1676:;	  G->pos= yypos1613; G->thunkpos= yythunkpos1613;  if (!yymatchString(G, "\276")) goto l1677;
  goto l1613;
  l1677:;	  G->pos= yypos1613; G->thunkpos= yythunkpos1613;  if (!yymatchString(G, "\277")) goto l1678;
  goto l1613;
  l1678:;	  G->pos= yypos1613; G->thunkpos= yythunkpos1613;  if (!yymatchString(G, "\300")) goto l1679;
  goto l1613;
  l1679:;	  G->pos= yypos1613; G->thunkpos= yythunkpos1613;  if (!yymatchString(G, "\301")) goto l1680;
  goto l1613;
  l1680:;	  G->pos= yypos1613; G->thunkpos= yythunkpos1613;  if (!yymatchString(G, "\302")) goto l1681;
  goto l1613;
  l1681:;	  G->pos= yypos1613; G->thunkpos= yythunkpos1613;  if (!yymatchString(G, "\303")) goto l1682;
  goto l1613;
  l1682:;	  G->pos= yypos1613; G->thunkpos= yythunkpos1613;  if (!yymatchString(G, "\304")) goto l1683;
  goto l1613;
  l1683:;	  G->pos= yypos1613; G->thunkpos= yythunkpos1613;  if (!yymatchString(G, "\305")) goto l1684;
  goto l1613;
  l1684:;	  G->pos= yypos1613; G->thunkpos= yythunkpos1613;  if (!yymatchString(G, "\306")) goto l1685;
  goto l1613;
  l1685:;	  G->pos= yypos1613; G->thunkpos= yythunkpos1613;  if (!yymatchString(G, "\307")) goto l1686;
  goto l1613;
  l1686:;	  G->pos= yypos1613; G->thunkpos= yythunkpos1613;  if (!yymatchString(G, "\310")) goto l1687;
  goto l1613;
  l1687:;	  G->pos= yypos1613; G->thunkpos= yythunkpos1613;  if (!yymatchString(G, "\311")) goto l1688;
  goto l1613;
  l1688:;	  G->pos= yypos1613; G->thunkpos= yythunkpos1613;  if (!yymatchString(G, "\312")) goto l1689;
  goto l1613;
  l1689:;	  G->pos= yypos1613; G->thunkpos= yythunkpos1613;  if (!yymatchString(G, "\313")) goto l1690;
  goto l1613;
  l1690:;	  G->pos= yypos1613; G->thunkpos= yythunkpos1613;  if (!yymatchString(G, "\314")) goto l1691;
  goto l1613;
  l1691:;	  G->pos= yypos1613; G->thunkpos= yythunkpos1613;  if (!yymatchString(G, "\315")) goto l1692;
  goto l1613;
  l1692:;	  G->pos= yypos1613; G->thunkpos= yythunkpos1613;  if (!yymatchString(G, "\316")) goto l1693;
  goto l1613;
  l1693:;	  G->pos= yypos1613; G->thunkpos= yythunkpos1613;  if (!yymatchString(G, "\317")) goto l1694;
  goto l1613;
  l1694:;	  G->pos= yypos1613; G->thunkpos= yythunkpos1613;  if (!yymatchString(G, "\320")) goto l1695;
  goto l1613;
  l1695:;	  G->pos= yypos1613; G->thunkpos= yythunkpos1613;  if (!yymatchString(G, "\321")) goto l1696;
  goto l1613;
  l1696:;	  G->pos= yypos1613; G->thunkpos= yythunkpos1613;  if (!yymatchString(G, "\322")) goto l1697;
  goto l1613;
  l1697:;	  G->pos= yypos1613; G->thunkpos= yythunkpos1613;  if (!yymatchString(G, "\323")) goto l1698;
  goto l1613;
  l1698:;	  G->pos= yypos1613; G->thunkpos= yythunkpos1613;  if (!yymatchString(G, "\324")) goto l1699;
  goto l1613;
  l1699:;	  G->pos= yypos1613; G->thunkpos= yythunkpos1613;  if (!yymatchString(G, "\325")) goto l1700;
  goto l1613;
  l1700:;	  G->pos= yypos1613; G->thunkpos= yythunkpos1613;  if (!yymatchString(G, "\326")) goto l1701;
  goto l1613;
  l1701:;	  G->pos= yypos1613; G->thunkpos= yythunkpos1613;  if (!yymatchString(G, "\327")) goto l1702;
  goto l1613;
  l1702:;	  G->pos= yypos1613; G->thunkpos= yythunkpos1613;  if (!yymatchString(G, "\330")) goto l1703;
  goto l1613;
  l1703:;	  G->pos= yypos1613; G->thunkpos= yythunkpos1613;  if (!yymatchString(G, "\331")) goto l1704;
  goto l1613;
  l1704:;	  G->pos= yypos1613; G->thunkpos= yythunkpos1613;  if (!yymatchString(G, "\332")) goto l1705;
  goto l1613;
  l1705:;	  G->pos= yypos1613; G->thunkpos= yythunkpos1613;  if (!yymatchString(G, "\333")) goto l1706;
  goto l1613;
  l1706:;	  G->pos= yypos1613; G->thunkpos= yythunkpos1613;  if (!yymatchString(G, "\334")) goto l1707;
  goto l1613;
  l1707:;	  G->pos= yypos1613; G->thunkpos= yythunkpos1613;  if (!yymatchString(G, "\335")) goto l1708;
  goto l1613;
  l1708:;	  G->pos= yypos1613; G->thunkpos= yythunkpos1613;  if (!yymatchString(G, "\336")) goto l1709;
  goto l1613;
  l1709:;	  G->pos= yypos1613; G->thunkpos= yythunkpos1613;  if (!yymatchString(G, "\337")) goto l1710;
  goto l1613;
  l1710:;	  G->pos= yypos1613; G->thunkpos= yythunkpos1613;  if (!yymatchString(G, "\340")) goto l1711;
  goto l1613;
  l1711:;	  G->pos= yypos1613; G->thunkpos= yythunkpos1613;  if (!yymatchString(G, "\341")) goto l1712;
  goto l1613;
  l1712:;	  G->pos= yypos1613; G->thunkpos= yythunkpos1613;  if (!yymatchString(G, "\342")) goto l1713;
  goto l1613;
  l1713:;	  G->pos= yypos1613; G->thunkpos= yythunkpos1613;  if (!yymatchString(G, "\343")) goto l1714;
  goto l1613;
  l1714:;	  G->pos= yypos1613; G->thunkpos= yythunkpos1613;  if (!yymatchString(G, "\344")) goto l1715;
  goto l1613;
  l1715:;	  G->pos= yypos1613; G->thunkpos= yythunkpos1613;  if (!yymatchString(G, "\345")) goto l1716;
  goto l1613;
  l1716:;	  G->pos= yypos1613; G->thunkpos= yythunkpos1613;  if (!yymatchString(G, "\346")) goto l1717;
  goto l1613;
  l1717:;	  G->pos= yypos1613; G->thunkpos= yythunkpos1613;  if (!yymatchString(G, "\347")) goto l1718;
  goto l1613;
  l1718:;	  G->pos= yypos1613; G->thunkpos= yythunkpos1613;  if (!yymatchString(G, "\350")) goto l1719;
  goto l1613;
  l1719:;	  G->pos= yypos1613; G->thunkpos= yythunkpos1613;  if (!yymatchString(G, "\351")) goto l1720;
  goto l1613;
  l1720:;	  G->pos= yypos1613; G->thunkpos= yythunkpos1613;  if (!yymatchString(G, "\352")) goto l1721;
  goto l1613;
  l1721:;	  G->pos= yypos1613; G->thunkpos= yythunkpos1613;  if (!yymatchString(G, "\353")) goto l1722;
  goto l1613;
  l1722:;	  G->pos= yypos1613; G->thunkpos= yythunkpos1613;  if (!yymatchString(G, "\354")) goto l1723;
  goto l1613;
  l1723:;	  G->pos= yypos1613; G->thunkpos= yythunkpos1613;  if (!yymatchString(G, "\355")) goto l1724;
  goto l1613;
  l1724:;	  G->pos= yypos1613; G->thunkpos= yythunkpos1613;  if (!yymatchString(G, "\356")) goto l1725;
  goto l1613;
  l1725:;	  G->pos= yypos1613; G->thunkpos= yythunkpos1613;  if (!yymatchString(G, "\357")) goto l1726;
  goto l1613;
  l1726:;	  G->pos= yypos1613; G->thunkpos= yythunkpos1613;  if (!yymatchString(G, "\360")) goto l1727;
  goto l1613;
  l1727:;	  G->pos= yypos1613; G->thunkpos= yythunkpos1613;  if (!yymatchString(G, "\361")) goto l1728;
  goto l1613;
  l1728:;	  G->pos= yypos1613; G->thunkpos= yythunkpos1613;  if (!yymatchString(G, "\362")) goto l1729;
  goto l1613;
  l1729:;	  G->pos= yypos1613; G->thunkpos= yythunkpos1613;  if (!yymatchString(G, "\363")) goto l1730;
  goto l1613;
  l1730:;	  G->pos= yypos1613; G->thunkpos= yythunkpos1613;  if (!yymatchString(G, "\364")) goto l1731;
  goto l1613;
  l1731:;	  G->pos= yypos1613; G->thunkpos= yythunkpos1613;  if (!yymatchString(G, "\365")) goto l1732;
  goto l1613;
  l1732:;	  G->pos= yypos1613; G->thunkpos= yythunkpos1613;  if (!yymatchString(G, "\366")) goto l1733;
  goto l1613;
  l1733:;	  G->pos= yypos1613; G->thunkpos= yythunkpos1613;  if (!yymatchString(G, "\367")) goto l1734;
  goto l1613;
  l1734:;	  G->pos= yypos1613; G->thunkpos= yythunkpos1613;  if (!yymatchString(G, "\370")) goto l1735;
  goto l1613;
  l1735:;	  G->pos= yypos1613; G->thunkpos= yythunkpos1613;  if (!yymatchString(G, "\371")) goto l1736;
  goto l1613;
  l1736:;	  G->pos= yypos1613; G->thunkpos= yythunkpos1613;  if (!yymatchString(G, "\372")) goto l1737;
  goto l1613;
  l1737:;	  G->pos= yypos1613; G->thunkpos= yythunkpos1613;  if (!yymatchString(G, "\373")) goto l1738;
  goto l1613;
  l1738:;	  G->pos= yypos1613; G->thunkpos= yythunkpos1613;  if (!yymatchString(G, "\374")) goto l1739;
  goto l1613;
  l1739:;	  G->pos= yypos1613; G->thunkpos= yythunkpos1613;  if (!yymatchString(G, "\375")) goto l1740;
  goto l1613;
  l1740:;	  G->pos= yypos1613; G->thunkpos= yythunkpos1613;  if (!yymatchString(G, "\376")) goto l1741;
  goto l1613;
  l1741:;	  G->pos= yypos1613; G->thunkpos= yythunkpos1613;  if (!yymatchString(G, "\377")) goto l1612;

  }
  l1613:;	  yyprintf((stderr, "  ok   Alphanumeric"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l1612:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "Alphanumeric"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_HtmlBlockScript(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "HtmlBlockScript"));
  if (!yy_HtmlBlockOpenScript(G))  goto l1742;

  l1743:;	
  {  int yypos1744= G->pos, yythunkpos1744= G->thunkpos;
  {  int yypos1745= G->pos, yythunkpos1745= G->thunkpos;  if (!yy_HtmlBlockCloseScript(G))  goto l1745;
  goto l1744;
  l1745:;	  G->pos= yypos1745; G->thunkpos= yythunkpos1745;
  }  if (!yymatchDot(G)) goto l1744;  goto l1743;
  l1744:;	  G->pos= yypos1744; G->thunkpos= yythunkpos1744;
  }  if (!yy_HtmlBlockCloseScript(G))  goto l1742;
  yyprintf((stderr, "  ok   HtmlBlockScript"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l1742:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "HtmlBlockScript"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_RawHtml(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "RawHtml"));
  yyText(G, G->begin, G->end);  if (!(YY_BEGIN)) goto l1746;
  {  int yypos1747= G->pos, yythunkpos1747= G->thunkpos;  if (!yy_HtmlComment(G))  goto l1748;
  goto l1747;
  l1748:;	  G->pos= yypos1747; G->thunkpos= yythunkpos1747;  if (!yy_HtmlBlockScript(G))  goto l1749;
  goto l1747;
  l1749:;	  G->pos= yypos1747; G->thunkpos= yythunkpos1747;  if (!yy_HtmlTag(G))  goto l1746;

  }
  l1747:;	  yyText(G, G->begin, G->end);  if (!(YY_END)) goto l1746;  yyDo(G, yy_1_RawHtml, G->begin, G->end, "yy_1_RawHtml");
  yyprintf((stderr, "  ok   RawHtml"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l1746:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "RawHtml"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_HtmlTag(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "HtmlTag"));
  if (!yymatchChar(G, '<')) goto l1750;
  if (!yy_Spnl(G))  goto l1750;

  {  int yypos1751= G->pos, yythunkpos1751= G->thunkpos;  if (!yymatchChar(G, '/')) goto l1751;
  goto l1752;
  l1751:;	  G->pos= yypos1751; G->thunkpos= yythunkpos1751;
  }
  l1752:;	  if (!yy_AlphanumericAscii(G))  goto l1750;

  l1753:;	
  {  int yypos1754= G->pos, yythunkpos1754= G->thunkpos;  if (!yy_AlphanumericAscii(G))  goto l1754;
  goto l1753;
  l1754:;	  G->pos= yypos1754; G->thunkpos= yythunkpos1754;
  }  if (!yy_Spnl(G))  goto l1750;

  l1755:;	
  {  int yypos1756= G->pos, yythunkpos1756= G->thunkpos;  if (!yy_HtmlAttribute(G))  goto l1756;
  goto l1755;
  l1756:;	  G->pos= yypos1756; G->thunkpos= yythunkpos1756;
  }
  {  int yypos1757= G->pos, yythunkpos1757= G->thunkpos;  if (!yymatchChar(G, '/')) goto l1757;
  goto l1758;
  l1757:;	  G->pos= yypos1757; G->thunkpos= yythunkpos1757;
  }
  l1758:;	  if (!yy_Spnl(G))  goto l1750;
  if (!yymatchChar(G, '>')) goto l1750;
  yyprintf((stderr, "  ok   HtmlTag"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l1750:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "HtmlTag"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_HtmlComment(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "HtmlComment"));
  if (!yymatchString(G, "<!--")) goto l1759;

  l1760:;	
  {  int yypos1761= G->pos, yythunkpos1761= G->thunkpos;
  {  int yypos1762= G->pos, yythunkpos1762= G->thunkpos;  if (!yymatchString(G, "-->")) goto l1762;
  goto l1761;
  l1762:;	  G->pos= yypos1762; G->thunkpos= yythunkpos1762;
  }  if (!yymatchDot(G)) goto l1761;  goto l1760;
  l1761:;	  G->pos= yypos1761; G->thunkpos= yythunkpos1761;
  }  if (!yymatchString(G, "-->")) goto l1759;
  yyprintf((stderr, "  ok   HtmlComment"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l1759:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "HtmlComment"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_HtmlAttribute(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "HtmlAttribute"));

  {  int yypos1766= G->pos, yythunkpos1766= G->thunkpos;  if (!yy_AlphanumericAscii(G))  goto l1767;
  goto l1766;
  l1767:;	  G->pos= yypos1766; G->thunkpos= yythunkpos1766;  if (!yymatchChar(G, '-')) goto l1763;

  }
  l1766:;	
  l1764:;	
  {  int yypos1765= G->pos, yythunkpos1765= G->thunkpos;
  {  int yypos1768= G->pos, yythunkpos1768= G->thunkpos;  if (!yy_AlphanumericAscii(G))  goto l1769;
  goto l1768;
  l1769:;	  G->pos= yypos1768; G->thunkpos= yythunkpos1768;  if (!yymatchChar(G, '-')) goto l1765;

  }
  l1768:;	  goto l1764;
  l1765:;	  G->pos= yypos1765; G->thunkpos= yythunkpos1765;
  }  if (!yy_Spnl(G))  goto l1763;

  {  int yypos1770= G->pos, yythunkpos1770= G->thunkpos;  if (!yymatchChar(G, '=')) goto l1770;
  if (!yy_Spnl(G))  goto l1770;

  {  int yypos1772= G->pos, yythunkpos1772= G->thunkpos;  if (!yy_Quoted(G))  goto l1773;
  goto l1772;
  l1773:;	  G->pos= yypos1772; G->thunkpos= yythunkpos1772;
  {  int yypos1776= G->pos, yythunkpos1776= G->thunkpos;  if (!yymatchChar(G, '>')) goto l1776;
  goto l1770;
  l1776:;	  G->pos= yypos1776; G->thunkpos= yythunkpos1776;
  }  if (!yy_Nonspacechar(G))  goto l1770;

  l1774:;	
  {  int yypos1775= G->pos, yythunkpos1775= G->thunkpos;
  {  int yypos1777= G->pos, yythunkpos1777= G->thunkpos;  if (!yymatchChar(G, '>')) goto l1777;
  goto l1775;
  l1777:;	  G->pos= yypos1777; G->thunkpos= yythunkpos1777;
  }  if (!yy_Nonspacechar(G))  goto l1775;
  goto l1774;
  l1775:;	  G->pos= yypos1775; G->thunkpos= yythunkpos1775;
  }
  }
  l1772:;	  goto l1771;
  l1770:;	  G->pos= yypos1770; G->thunkpos= yythunkpos1770;
  }
  l1771:;	  if (!yy_Spnl(G))  goto l1763;
  yyprintf((stderr, "  ok   HtmlAttribute"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l1763:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "HtmlAttribute"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_Quoted(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "Quoted"));

  {  int yypos1779= G->pos, yythunkpos1779= G->thunkpos;  if (!yymatchChar(G, '"')) goto l1780;

  l1781:;	
  {  int yypos1782= G->pos, yythunkpos1782= G->thunkpos;
  {  int yypos1783= G->pos, yythunkpos1783= G->thunkpos;  if (!yymatchChar(G, '"')) goto l1783;
  goto l1782;
  l1783:;	  G->pos= yypos1783; G->thunkpos= yythunkpos1783;
  }  if (!yymatchDot(G)) goto l1782;  goto l1781;
  l1782:;	  G->pos= yypos1782; G->thunkpos= yythunkpos1782;
  }  if (!yymatchChar(G, '"')) goto l1780;
  goto l1779;
  l1780:;	  G->pos= yypos1779; G->thunkpos= yythunkpos1779;  if (!yymatchChar(G, '\'')) goto l1778;

  l1784:;	
  {  int yypos1785= G->pos, yythunkpos1785= G->thunkpos;
  {  int yypos1786= G->pos, yythunkpos1786= G->thunkpos;  if (!yymatchChar(G, '\'')) goto l1786;
  goto l1785;
  l1786:;	  G->pos= yypos1786; G->thunkpos= yythunkpos1786;
  }  if (!yymatchDot(G)) goto l1785;  goto l1784;
  l1785:;	  G->pos= yypos1785; G->thunkpos= yythunkpos1785;
  }  if (!yymatchChar(G, '\'')) goto l1778;

  }
  l1779:;	  yyprintf((stderr, "  ok   Quoted"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l1778:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "Quoted"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_ExtendedSpecialChar(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "ExtendedSpecialChar"));

  {  int yypos1788= G->pos, yythunkpos1788= G->thunkpos;  yyText(G, G->begin, G->end);  if (!( ext(EXT_SMART) )) goto l1789;
  {  int yypos1790= G->pos, yythunkpos1790= G->thunkpos;  if (!yymatchChar(G, '.')) goto l1791;
  goto l1790;
  l1791:;	  G->pos= yypos1790; G->thunkpos= yythunkpos1790;  if (!yymatchChar(G, '-')) goto l1792;
  goto l1790;
  l1792:;	  G->pos= yypos1790; G->thunkpos= yythunkpos1790;  if (!yymatchChar(G, '\'')) goto l1793;
  goto l1790;
  l1793:;	  G->pos= yypos1790; G->thunkpos= yythunkpos1790;  if (!yymatchChar(G, '"')) goto l1789;

  }
  l1790:;	  goto l1788;
  l1789:;	  G->pos= yypos1788; G->thunkpos= yythunkpos1788;  yyText(G, G->begin, G->end);  if (!( ext(EXT_NOTES) )) goto l1794;  if (!yymatchChar(G, '^')) goto l1794;
  goto l1788;
  l1794:;	  G->pos= yypos1788; G->thunkpos= yythunkpos1788;  yyText(G, G->begin, G->end);  if (!( ext(EXT_CRITIC) )) goto l1787;  if (!yymatchChar(G, '{')) goto l1787;

  }
  l1788:;	  yyprintf((stderr, "  ok   ExtendedSpecialChar"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l1787:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "ExtendedSpecialChar"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_SpecialChar(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "SpecialChar"));

  {  int yypos1796= G->pos, yythunkpos1796= G->thunkpos;  if (!yymatchChar(G, '*')) goto l1797;
  goto l1796;
  l1797:;	  G->pos= yypos1796; G->thunkpos= yythunkpos1796;  if (!yymatchChar(G, '_')) goto l1798;
  goto l1796;
  l1798:;	  G->pos= yypos1796; G->thunkpos= yythunkpos1796;  if (!yymatchChar(G, '`')) goto l1799;
  goto l1796;
  l1799:;	  G->pos= yypos1796; G->thunkpos= yythunkpos1796;  if (!yymatchChar(G, '&')) goto l1800;
  goto l1796;
  l1800:;	  G->pos= yypos1796; G->thunkpos= yythunkpos1796;  if (!yymatchChar(G, '[')) goto l1801;
  goto l1796;
  l1801:;	  G->pos= yypos1796; G->thunkpos= yythunkpos1796;  if (!yymatchChar(G, ']')) goto l1802;
  goto l1796;
  l1802:;	  G->pos= yypos1796; G->thunkpos= yythunkpos1796;  if (!yymatchChar(G, '(')) goto l1803;
  goto l1796;
  l1803:;	  G->pos= yypos1796; G->thunkpos= yythunkpos1796;  if (!yymatchChar(G, ')')) goto l1804;
  goto l1796;
  l1804:;	  G->pos= yypos1796; G->thunkpos= yythunkpos1796;  if (!yymatchChar(G, '<')) goto l1805;
  goto l1796;
  l1805:;	  G->pos= yypos1796; G->thunkpos= yythunkpos1796;  if (!yymatchChar(G, '!')) goto l1806;
  goto l1796;
  l1806:;	  G->pos= yypos1796; G->thunkpos= yythunkpos1796;  if (!yymatchChar(G, '#')) goto l1807;
  goto l1796;
  l1807:;	  G->pos= yypos1796; G->thunkpos= yythunkpos1796;  if (!yymatchChar(G, '\\')) goto l1808;
  goto l1796;
  l1808:;	  G->pos= yypos1796; G->thunkpos= yythunkpos1796;  if (!yymatchChar(G, '\'')) goto l1809;
  goto l1796;
  l1809:;	  G->pos= yypos1796; G->thunkpos= yythunkpos1796;  if (!yymatchChar(G, '"')) goto l1810;
  goto l1796;
  l1810:;	  G->pos= yypos1796; G->thunkpos= yythunkpos1796;  if (!yy_ExtendedSpecialChar(G))  goto l1795;

  }
  l1796:;	  yyprintf((stderr, "  ok   SpecialChar"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l1795:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "SpecialChar"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_NormalChar(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "NormalChar"));

  {  int yypos1812= G->pos, yythunkpos1812= G->thunkpos;
  {  int yypos1813= G->pos, yythunkpos1813= G->thunkpos;  if (!yy_SpecialChar(G))  goto l1814;
  goto l1813;
  l1814:;	  G->pos= yypos1813; G->thunkpos= yythunkpos1813;  if (!yy_Spacechar(G))  goto l1815;
  goto l1813;
  l1815:;	  G->pos= yypos1813; G->thunkpos= yythunkpos1813;  if (!yy_Newline(G))  goto l1812;

  }
  l1813:;	  goto l1811;
  l1812:;	  G->pos= yypos1812; G->thunkpos= yythunkpos1812;
  }  if (!yymatchDot(G)) goto l1811;  yyprintf((stderr, "  ok   NormalChar"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l1811:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "NormalChar"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_Nonspacechar(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "Nonspacechar"));

  {  int yypos1817= G->pos, yythunkpos1817= G->thunkpos;  if (!yy_Spacechar(G))  goto l1817;
  goto l1816;
  l1817:;	  G->pos= yypos1817; G->thunkpos= yythunkpos1817;
  }
  {  int yypos1818= G->pos, yythunkpos1818= G->thunkpos;  if (!yy_Newline(G))  goto l1818;
  goto l1816;
  l1818:;	  G->pos= yypos1818; G->thunkpos= yythunkpos1818;
  }  if (!yymatchDot(G)) goto l1816;  yyprintf((stderr, "  ok   Nonspacechar"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l1816:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "Nonspacechar"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_Spnl(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "Spnl"));
  if (!yy_Sp(G))  goto l1819;

  {  int yypos1820= G->pos, yythunkpos1820= G->thunkpos;  if (!yy_Newline(G))  goto l1820;
  if (!yy_Sp(G))  goto l1820;
  goto l1821;
  l1820:;	  G->pos= yypos1820; G->thunkpos= yythunkpos1820;
  }
  l1821:;	  yyprintf((stderr, "  ok   Spnl"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l1819:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "Spnl"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_Spacechar(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "Spacechar"));

  {  int yypos1823= G->pos, yythunkpos1823= G->thunkpos;  if (!yymatchChar(G, ' ')) goto l1824;
  goto l1823;
  l1824:;	  G->pos= yypos1823; G->thunkpos= yythunkpos1823;  if (!yymatchChar(G, '\t')) goto l1822;

  }
  l1823:;	  yyprintf((stderr, "  ok   Spacechar"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l1822:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "Spacechar"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_Eof(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "Eof"));

  {  int yypos1826= G->pos, yythunkpos1826= G->thunkpos;  if (!yymatchDot(G)) goto l1826;  goto l1825;
  l1826:;	  G->pos= yypos1826; G->thunkpos= yythunkpos1826;
  }  yyprintf((stderr, "  ok   Eof"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l1825:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "Eof"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_Line(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "Line"));
  if (!yy_RawLine(G))  goto l1827;
  yyDo(G, yy_1_Line, G->begin, G->end, "yy_1_Line");
  yyprintf((stderr, "  ok   Line"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l1827:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "Line"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_BlockQuoteMarker(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "BlockQuoteMarker"));
  yyText(G, G->begin, G->end);  if (!(YY_BEGIN)) goto l1828;  if (!yymatchChar(G, '>')) goto l1828;

  {  int yypos1829= G->pos, yythunkpos1829= G->thunkpos;  if (!yymatchChar(G, ' ')) goto l1829;
  goto l1830;
  l1829:;	  G->pos= yypos1829; G->thunkpos= yythunkpos1829;
  }
  l1830:;	  yyText(G, G->begin, G->end);  if (!(YY_END)) goto l1828;  yyDo(G, yy_1_BlockQuoteMarker, G->begin, G->end, "yy_1_BlockQuoteMarker");
  yyprintf((stderr, "  ok   BlockQuoteMarker"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l1828:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "BlockQuoteMarker"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_BlockQuoteRaw(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyDo(G, yyPush, 2, 0, "yyPush");
  yyprintfv((stderr, "%s\n", "BlockQuoteRaw"));
  if (!yy_StartList(G))  goto l1831;
  yyDo(G, yySet, -2, 0, "yySet");
  if (!yy_BlockQuoteMarker(G))  goto l1831;
  yyDo(G, yySet, -1, 0, "yySet");
  if (!yy_Line(G))  goto l1831;
  yyDo(G, yy_1_BlockQuoteRaw, G->begin, G->end, "yy_1_BlockQuoteRaw");

  l1834:;	
  {  int yypos1835= G->pos, yythunkpos1835= G->thunkpos;
  {  int yypos1836= G->pos, yythunkpos1836= G->thunkpos;  if (!yymatchChar(G, '>')) goto l1836;
  goto l1835;
  l1836:;	  G->pos= yypos1836; G->thunkpos= yythunkpos1836;
  }
  {  int yypos1837= G->pos, yythunkpos1837= G->thunkpos;  if (!yy_BlankLine(G))  goto l1837;
  goto l1835;
  l1837:;	  G->pos= yypos1837; G->thunkpos= yythunkpos1837;
  }  if (!yy_Line(G))  goto l1835;
  yyDo(G, yy_2_BlockQuoteRaw, G->begin, G->end, "yy_2_BlockQuoteRaw");
  goto l1834;
  l1835:;	  G->pos= yypos1835; G->thunkpos= yythunkpos1835;
  }
  l1838:;	
  {  int yypos1839= G->pos, yythunkpos1839= G->thunkpos;  if (!yy_BlankLine(G))  goto l1839;
  yyDo(G, yy_3_BlockQuoteRaw, G->begin, G->end, "yy_3_BlockQuoteRaw");
  goto l1838;
  l1839:;	  G->pos= yypos1839; G->thunkpos= yythunkpos1839;
  }
  l1832:;	
  {  int yypos1833= G->pos, yythunkpos1833= G->thunkpos;  if (!yy_BlockQuoteMarker(G))  goto l1833;
  yyDo(G, yySet, -1, 0, "yySet");
  if (!yy_Line(G))  goto l1833;
  yyDo(G, yy_1_BlockQuoteRaw, G->begin, G->end, "yy_1_BlockQuoteRaw");

  l1840:;	
  {  int yypos1841= G->pos, yythunkpos1841= G->thunkpos;
  {  int yypos1842= G->pos, yythunkpos1842= G->thunkpos;  if (!yymatchChar(G, '>')) goto l1842;
  goto l1841;
  l1842:;	  G->pos= yypos1842; G->thunkpos= yythunkpos1842;
  }
  {  int yypos1843= G->pos, yythunkpos1843= G->thunkpos;  if (!yy_BlankLine(G))  goto l1843;
  goto l1841;
  l1843:;	  G->pos= yypos1843; G->thunkpos= yythunkpos1843;
  }  if (!yy_Line(G))  goto l1841;
  yyDo(G, yy_2_BlockQuoteRaw, G->begin, G->end, "yy_2_BlockQuoteRaw");
  goto l1840;
  l1841:;	  G->pos= yypos1841; G->thunkpos= yythunkpos1841;
  }
  l1844:;	
  {  int yypos1845= G->pos, yythunkpos1845= G->thunkpos;  if (!yy_BlankLine(G))  goto l1845;
  yyDo(G, yy_3_BlockQuoteRaw, G->begin, G->end, "yy_3_BlockQuoteRaw");
  goto l1844;
  l1845:;	  G->pos= yypos1845; G->thunkpos= yythunkpos1845;
  }  goto l1832;
  l1833:;	  G->pos= yypos1833; G->thunkpos= yythunkpos1833;
  }  yyDo(G, yy_4_BlockQuoteRaw, G->begin, G->end, "yy_4_BlockQuoteRaw");
  yyprintf((stderr, "  ok   BlockQuoteRaw"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));
  yyDo(G, yyPop, 2, 0, "yyPop");
  return 1;
  l1831:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "BlockQuoteRaw"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_Endline(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "Endline"));

  {  int yypos1847= G->pos, yythunkpos1847= G->thunkpos;  if (!yy_LineBreak(G))  goto l1848;
  goto l1847;
  l1848:;	  G->pos= yypos1847; G->thunkpos= yythunkpos1847;  if (!yy_TerminalEndline(G))  goto l1849;
  goto l1847;
  l1849:;	  G->pos= yypos1847; G->thunkpos= yythunkpos1847;  if (!yy_NormalEndline(G))  goto l1846;

  }
  l1847:;	  yyprintf((stderr, "  ok   Endline"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l1846:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "Endline"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_SetextBottom2(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "SetextBottom2"));
  if (!yymatchChar(G, '-')) goto l1850;

  l1851:;	
  {  int yypos1852= G->pos, yythunkpos1852= G->thunkpos;  if (!yymatchChar(G, '-')) goto l1852;
  goto l1851;
  l1852:;	  G->pos= yypos1852; G->thunkpos= yythunkpos1852;
  }  if (!yy_Newline(G))  goto l1850;
  yyprintf((stderr, "  ok   SetextBottom2"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l1850:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "SetextBottom2"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_SetextBottom1(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "SetextBottom1"));
  if (!yymatchChar(G, '=')) goto l1853;

  l1854:;	
  {  int yypos1855= G->pos, yythunkpos1855= G->thunkpos;  if (!yymatchChar(G, '=')) goto l1855;
  goto l1854;
  l1855:;	  G->pos= yypos1855; G->thunkpos= yythunkpos1855;
  }  if (!yy_Newline(G))  goto l1853;
  yyprintf((stderr, "  ok   SetextBottom1"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l1853:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "SetextBottom1"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_SetextHeading2(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyDo(G, yyPush, 2, 0, "yyPush");
  yyprintfv((stderr, "%s\n", "SetextHeading2"));

  {  int yypos1857= G->pos, yythunkpos1857= G->thunkpos;  if (!yy_RawLine(G))  goto l1856;
  if (!yy_SetextBottom2(G))  goto l1856;
  G->pos= yypos1857; G->thunkpos= yythunkpos1857;
  }  if (!yy_StartList(G))  goto l1856;
  yyDo(G, yySet, -2, 0, "yySet");

  {  int yypos1860= G->pos, yythunkpos1860= G->thunkpos;  if (!yy_Endline(G))  goto l1860;
  goto l1856;
  l1860:;	  G->pos= yypos1860; G->thunkpos= yythunkpos1860;
  }
  {  int yypos1861= G->pos, yythunkpos1861= G->thunkpos;  yyText(G, G->begin, G->end);  if (!( !ext(EXT_COMPATIBILITY) )) goto l1861;  if (!yy_Sp(G))  goto l1861;
  if (!yy_AutoLabel(G))  goto l1861;
  goto l1856;
  l1861:;	  G->pos= yypos1861; G->thunkpos= yythunkpos1861;
  }  if (!yy_Inline(G))  goto l1856;
  yyDo(G, yy_1_SetextHeading2, G->begin, G->end, "yy_1_SetextHeading2");

  l1858:;	
  {  int yypos1859= G->pos, yythunkpos1859= G->thunkpos;
  {  int yypos1862= G->pos, yythunkpos1862= G->thunkpos;  if (!yy_Endline(G))  goto l1862;
  goto l1859;
  l1862:;	  G->pos= yypos1862; G->thunkpos= yythunkpos1862;
  }
  {  int yypos1863= G->pos, yythunkpos1863= G->thunkpos;  yyText(G, G->begin, G->end);  if (!( !ext(EXT_COMPATIBILITY) )) goto l1863;  if (!yy_Sp(G))  goto l1863;
  if (!yy_AutoLabel(G))  goto l1863;
  goto l1859;
  l1863:;	  G->pos= yypos1863; G->thunkpos= yythunkpos1863;
  }  if (!yy_Inline(G))  goto l1859;
  yyDo(G, yy_1_SetextHeading2, G->begin, G->end, "yy_1_SetextHeading2");
  goto l1858;
  l1859:;	  G->pos= yypos1859; G->thunkpos= yythunkpos1859;
  }
  {  int yypos1864= G->pos, yythunkpos1864= G->thunkpos;  if (!yy_Sp(G))  goto l1864;
  if (!yy_AutoLabel(G))  goto l1864;
  yyDo(G, yySet, -1, 0, "yySet");
  yyDo(G, yy_2_SetextHeading2, G->begin, G->end, "yy_2_SetextHeading2");

  {  int yypos1866= G->pos, yythunkpos1866= G->thunkpos;  if (!yy_Sp(G))  goto l1866;
  goto l1867;
  l1866:;	  G->pos= yypos1866; G->thunkpos= yythunkpos1866;
  }
  l1867:;	  goto l1865;
  l1864:;	  G->pos= yypos1864; G->thunkpos= yythunkpos1864;
  }
  l1865:;	
  {  int yypos1868= G->pos, yythunkpos1868= G->thunkpos;  if (!yy_Sp(G))  goto l1868;
  goto l1869;
  l1868:;	  G->pos= yypos1868; G->thunkpos= yythunkpos1868;
  }
  l1869:;	  if (!yy_Newline(G))  goto l1856;
  yyText(G, G->begin, G->end);  if (!(YY_BEGIN)) goto l1856;  if (!yy_SetextBottom2(G))  goto l1856;
  yyText(G, G->begin, G->end);  if (!(YY_END)) goto l1856;  yyDo(G, yy_3_SetextHeading2, G->begin, G->end, "yy_3_SetextHeading2");
  yyprintf((stderr, "  ok   SetextHeading2"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));
  yyDo(G, yyPop, 2, 0, "yyPop");
  return 1;
  l1856:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "SetextHeading2"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_SetextHeading1(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyDo(G, yyPush, 2, 0, "yyPush");
  yyprintfv((stderr, "%s\n", "SetextHeading1"));

  {  int yypos1871= G->pos, yythunkpos1871= G->thunkpos;  if (!yy_RawLine(G))  goto l1870;
  if (!yy_SetextBottom1(G))  goto l1870;
  G->pos= yypos1871; G->thunkpos= yythunkpos1871;
  }  if (!yy_StartList(G))  goto l1870;
  yyDo(G, yySet, -2, 0, "yySet");

  {  int yypos1874= G->pos, yythunkpos1874= G->thunkpos;  if (!yy_Endline(G))  goto l1874;
  goto l1870;
  l1874:;	  G->pos= yypos1874; G->thunkpos= yythunkpos1874;
  }
  {  int yypos1875= G->pos, yythunkpos1875= G->thunkpos;  yyText(G, G->begin, G->end);  if (!( !ext(EXT_COMPATIBILITY) )) goto l1875;  if (!yy_Sp(G))  goto l1875;
  if (!yy_AutoLabel(G))  goto l1875;
  goto l1870;
  l1875:;	  G->pos= yypos1875; G->thunkpos= yythunkpos1875;
  }  if (!yy_Inline(G))  goto l1870;
  yyDo(G, yy_1_SetextHeading1, G->begin, G->end, "yy_1_SetextHeading1");

  l1872:;	
  {  int yypos1873= G->pos, yythunkpos1873= G->thunkpos;
  {  int yypos1876= G->pos, yythunkpos1876= G->thunkpos;  if (!yy_Endline(G))  goto l1876;
  goto l1873;
  l1876:;	  G->pos= yypos1876; G->thunkpos= yythunkpos1876;
  }
  {  int yypos1877= G->pos, yythunkpos1877= G->thunkpos;  yyText(G, G->begin, G->end);  if (!( !ext(EXT_COMPATIBILITY) )) goto l1877;  if (!yy_Sp(G))  goto l1877;
  if (!yy_AutoLabel(G))  goto l1877;
  goto l1873;
  l1877:;	  G->pos= yypos1877; G->thunkpos= yythunkpos1877;
  }  if (!yy_Inline(G))  goto l1873;
  yyDo(G, yy_1_SetextHeading1, G->begin, G->end, "yy_1_SetextHeading1");
  goto l1872;
  l1873:;	  G->pos= yypos1873; G->thunkpos= yythunkpos1873;
  }
  {  int yypos1878= G->pos, yythunkpos1878= G->thunkpos;  if (!yy_Sp(G))  goto l1878;
  if (!yy_AutoLabel(G))  goto l1878;
  yyDo(G, yySet, -1, 0, "yySet");
  yyDo(G, yy_2_SetextHeading1, G->begin, G->end, "yy_2_SetextHeading1");

  {  int yypos1880= G->pos, yythunkpos1880= G->thunkpos;  if (!yy_Sp(G))  goto l1880;
  goto l1881;
  l1880:;	  G->pos= yypos1880; G->thunkpos= yythunkpos1880;
  }
  l1881:;	  goto l1879;
  l1878:;	  G->pos= yypos1878; G->thunkpos= yythunkpos1878;
  }
  l1879:;	
  {  int yypos1882= G->pos, yythunkpos1882= G->thunkpos;  if (!yy_Sp(G))  goto l1882;
  goto l1883;
  l1882:;	  G->pos= yypos1882; G->thunkpos= yythunkpos1882;
  }
  l1883:;	  if (!yy_Newline(G))  goto l1870;
  yyText(G, G->begin, G->end);  if (!(YY_BEGIN)) goto l1870;  if (!yy_SetextBottom1(G))  goto l1870;
  yyText(G, G->begin, G->end);  if (!(YY_END)) goto l1870;  yyDo(G, yy_3_SetextHeading1, G->begin, G->end, "yy_3_SetextHeading1");
  yyprintf((stderr, "  ok   SetextHeading1"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));
  yyDo(G, yyPop, 2, 0, "yyPop");
  return 1;
  l1870:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "SetextHeading1"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_AtxStart(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "AtxStart"));
  yyText(G, G->begin, G->end);  if (!(YY_BEGIN)) goto l1884;
  {  int yypos1885= G->pos, yythunkpos1885= G->thunkpos;  if (!yymatchString(G, "######")) goto l1886;
  goto l1885;
  l1886:;	  G->pos= yypos1885; G->thunkpos= yythunkpos1885;  if (!yymatchString(G, "#####")) goto l1887;
  goto l1885;
  l1887:;	  G->pos= yypos1885; G->thunkpos= yythunkpos1885;  if (!yymatchString(G, "####")) goto l1888;
  goto l1885;
  l1888:;	  G->pos= yypos1885; G->thunkpos= yythunkpos1885;  if (!yymatchString(G, "###")) goto l1889;
  goto l1885;
  l1889:;	  G->pos= yypos1885; G->thunkpos= yythunkpos1885;  if (!yymatchString(G, "##")) goto l1890;
  goto l1885;
  l1890:;	  G->pos= yypos1885; G->thunkpos= yythunkpos1885;  if (!yymatchChar(G, '#')) goto l1884;

  }
  l1885:;	  yyText(G, G->begin, G->end);  if (!(YY_END)) goto l1884;  yyDo(G, yy_1_AtxStart, G->begin, G->end, "yy_1_AtxStart");
  yyprintf((stderr, "  ok   AtxStart"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l1884:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "AtxStart"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_Inline(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "Inline"));

  {  int yypos1892= G->pos, yythunkpos1892= G->thunkpos;  yyText(G, G->begin, G->end);  if (!( ext(EXT_CRITIC) )) goto l1893;  if (!yy_CriticMarkup(G))  goto l1893;
  goto l1892;
  l1893:;	  G->pos= yypos1892; G->thunkpos= yythunkpos1892;  yyText(G, G->begin, G->end);  if (!( !ext(EXT_COMPATIBILITY) )) goto l1894;  if (!yy_DollarMath(G))  goto l1894;
  goto l1892;
  l1894:;	  G->pos= yypos1892; G->thunkpos= yythunkpos1892;  if (!yy_Str(G))  goto l1895;
  goto l1892;
  l1895:;	  G->pos= yypos1892; G->thunkpos= yythunkpos1892;  yyText(G, G->begin, G->end);  if (!( !ext(EXT_COMPATIBILITY) )) goto l1896;  if (!yy_MathSpan(G))  goto l1896;
  goto l1892;
  l1896:;	  G->pos= yypos1892; G->thunkpos= yythunkpos1892;  if (!yy_Endline(G))  goto l1897;
  goto l1892;
  l1897:;	  G->pos= yypos1892; G->thunkpos= yythunkpos1892;  if (!yy_UlOrStarLine(G))  goto l1898;
  goto l1892;
  l1898:;	  G->pos= yypos1892; G->thunkpos= yythunkpos1892;  if (!yy_Space(G))  goto l1899;
  goto l1892;
  l1899:;	  G->pos= yypos1892; G->thunkpos= yythunkpos1892;  if (!yy_Strong(G))  goto l1900;
  goto l1892;
  l1900:;	  G->pos= yypos1892; G->thunkpos= yythunkpos1892;  if (!yy_Emph(G))  goto l1901;
  goto l1892;
  l1901:;	  G->pos= yypos1892; G->thunkpos= yythunkpos1892;  yyText(G, G->begin, G->end);  if (!( !ext(EXT_COMPATIBILITY) )) goto l1902;  if (!yy_CitationReference(G))  goto l1902;
  goto l1892;
  l1902:;	  G->pos= yypos1892; G->thunkpos= yythunkpos1892;  if (!yy_Image(G))  goto l1903;
  goto l1892;
  l1903:;	  G->pos= yypos1892; G->thunkpos= yythunkpos1892;  if (!yy_Link(G))  goto l1904;
  goto l1892;
  l1904:;	  G->pos= yypos1892; G->thunkpos= yythunkpos1892;  if (!yy_NoteReference(G))  goto l1905;
  goto l1892;
  l1905:;	  G->pos= yypos1892; G->thunkpos= yythunkpos1892;  if (!yy_Code(G))  goto l1906;
  goto l1892;
  l1906:;	  G->pos= yypos1892; G->thunkpos= yythunkpos1892;  if (!yy_MarkdownHtmlTagOpen(G))  goto l1907;
  goto l1892;
  l1907:;	  G->pos= yypos1892; G->thunkpos= yythunkpos1892;  if (!yy_RawHtml(G))  goto l1908;
  goto l1892;
  l1908:;	  G->pos= yypos1892; G->thunkpos= yythunkpos1892;  if (!yy_Entity(G))  goto l1909;
  goto l1892;
  l1909:;	  G->pos= yypos1892; G->thunkpos= yythunkpos1892;  if (!yy_EscapedChar(G))  goto l1910;
  goto l1892;
  l1910:;	  G->pos= yypos1892; G->thunkpos= yythunkpos1892;  if (!yy_Smart(G))  goto l1911;
  goto l1892;
  l1911:;	  G->pos= yypos1892; G->thunkpos= yythunkpos1892;  if (!yy_Symbol(G))  goto l1891;

  }
  l1892:;	  yyprintf((stderr, "  ok   Inline"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l1891:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "Inline"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_AutoLabel(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "AutoLabel"));
  if (!yymatchChar(G, '[')) goto l1912;
  yyText(G, G->begin, G->end);  if (!(YY_BEGIN)) goto l1912;
  {  int yypos1913= G->pos, yythunkpos1913= G->thunkpos;  if (!yy_Newline(G))  goto l1913;
  goto l1912;
  l1913:;	  G->pos= yypos1913; G->thunkpos= yythunkpos1913;
  }
  {  int yypos1914= G->pos, yythunkpos1914= G->thunkpos;  if (!yymatchChar(G, '^')) goto l1914;
  goto l1912;
  l1914:;	  G->pos= yypos1914; G->thunkpos= yythunkpos1914;
  }
  {  int yypos1915= G->pos, yythunkpos1915= G->thunkpos;  if (!yymatchChar(G, '#')) goto l1915;
  goto l1912;
  l1915:;	  G->pos= yypos1915; G->thunkpos= yythunkpos1915;
  }  if (!yymatchDot(G)) goto l1912;
  {  int yypos1918= G->pos, yythunkpos1918= G->thunkpos;  if (!yy_Newline(G))  goto l1918;
  goto l1912;
  l1918:;	  G->pos= yypos1918; G->thunkpos= yythunkpos1918;
  }
  {  int yypos1919= G->pos, yythunkpos1919= G->thunkpos;  if (!yymatchChar(G, ']')) goto l1919;
  goto l1912;
  l1919:;	  G->pos= yypos1919; G->thunkpos= yythunkpos1919;
  }  if (!yymatchDot(G)) goto l1912;
  l1916:;	
  {  int yypos1917= G->pos, yythunkpos1917= G->thunkpos;
  {  int yypos1920= G->pos, yythunkpos1920= G->thunkpos;  if (!yy_Newline(G))  goto l1920;
  goto l1917;
  l1920:;	  G->pos= yypos1920; G->thunkpos= yythunkpos1920;
  }
  {  int yypos1921= G->pos, yythunkpos1921= G->thunkpos;  if (!yymatchChar(G, ']')) goto l1921;
  goto l1917;
  l1921:;	  G->pos= yypos1921; G->thunkpos= yythunkpos1921;
  }  if (!yymatchDot(G)) goto l1917;  goto l1916;
  l1917:;	  G->pos= yypos1917; G->thunkpos= yythunkpos1917;
  }  yyText(G, G->begin, G->end);  if (!(YY_END)) goto l1912;  if (!yymatchChar(G, ']')) goto l1912;

  {  int yypos1922= G->pos, yythunkpos1922= G->thunkpos;
  {  int yypos1923= G->pos, yythunkpos1923= G->thunkpos;
  {  int yypos1924= G->pos, yythunkpos1924= G->thunkpos;  if (!yy_Sp(G))  goto l1924;
  goto l1925;
  l1924:;	  G->pos= yypos1924; G->thunkpos= yythunkpos1924;
  }
  l1925:;	
  {  int yypos1926= G->pos, yythunkpos1926= G->thunkpos;  if (!yymatchChar(G, '(')) goto l1927;
  goto l1926;
  l1927:;	  G->pos= yypos1926; G->thunkpos= yythunkpos1926;  if (!yymatchChar(G, '[')) goto l1923;

  }
  l1926:;	  goto l1912;
  l1923:;	  G->pos= yypos1923; G->thunkpos= yythunkpos1923;
  }  G->pos= yypos1922; G->thunkpos= yythunkpos1922;
  }  yyDo(G, yy_1_AutoLabel, G->begin, G->end, "yy_1_AutoLabel");
  yyprintf((stderr, "  ok   AutoLabel"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l1912:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "AutoLabel"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_AtxInline(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "AtxInline"));

  {  int yypos1929= G->pos, yythunkpos1929= G->thunkpos;  if (!yy_Newline(G))  goto l1929;
  goto l1928;
  l1929:;	  G->pos= yypos1929; G->thunkpos= yythunkpos1929;
  }
  {  int yypos1930= G->pos, yythunkpos1930= G->thunkpos;  yyText(G, G->begin, G->end);  if (!( !ext(EXT_COMPATIBILITY) )) goto l1930;  if (!yy_Sp(G))  goto l1930;
  if (!yy_AutoLabel(G))  goto l1930;

  {  int yypos1931= G->pos, yythunkpos1931= G->thunkpos;  if (!yy_Sp(G))  goto l1931;
  goto l1932;
  l1931:;	  G->pos= yypos1931; G->thunkpos= yythunkpos1931;
  }
  l1932:;	
  l1933:;	
  {  int yypos1934= G->pos, yythunkpos1934= G->thunkpos;  if (!yymatchChar(G, '#')) goto l1934;
  goto l1933;
  l1934:;	  G->pos= yypos1934; G->thunkpos= yythunkpos1934;
  }  if (!yy_Sp(G))  goto l1930;
  if (!yy_Newline(G))  goto l1930;
  goto l1928;
  l1930:;	  G->pos= yypos1930; G->thunkpos= yythunkpos1930;
  }
  {  int yypos1935= G->pos, yythunkpos1935= G->thunkpos;
  {  int yypos1936= G->pos, yythunkpos1936= G->thunkpos;  if (!yy_Sp(G))  goto l1936;
  goto l1937;
  l1936:;	  G->pos= yypos1936; G->thunkpos= yythunkpos1936;
  }
  l1937:;	
  l1938:;	
  {  int yypos1939= G->pos, yythunkpos1939= G->thunkpos;  if (!yymatchChar(G, '#')) goto l1939;
  goto l1938;
  l1939:;	  G->pos= yypos1939; G->thunkpos= yythunkpos1939;
  }  if (!yy_Sp(G))  goto l1935;
  if (!yy_Newline(G))  goto l1935;
  goto l1928;
  l1935:;	  G->pos= yypos1935; G->thunkpos= yythunkpos1935;
  }  if (!yy_Inline(G))  goto l1928;
  yyprintf((stderr, "  ok   AtxInline"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l1928:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "AtxInline"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_AtxHeading(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyDo(G, yyPush, 3, 0, "yyPush");
  yyprintfv((stderr, "%s\n", "AtxHeading"));
  if (!yy_AtxStart(G))  goto l1940;
  yyDo(G, yySet, -3, 0, "yySet");

  {  int yypos1941= G->pos, yythunkpos1941= G->thunkpos;  if (!yy_Sp(G))  goto l1941;
  goto l1942;
  l1941:;	  G->pos= yypos1941; G->thunkpos= yythunkpos1941;
  }
  l1942:;	  if (!yy_StartList(G))  goto l1940;
  yyDo(G, yySet, -2, 0, "yySet");
  if (!yy_AtxInline(G))  goto l1940;
  yyDo(G, yy_1_AtxHeading, G->begin, G->end, "yy_1_AtxHeading");

  l1943:;	
  {  int yypos1944= G->pos, yythunkpos1944= G->thunkpos;  if (!yy_AtxInline(G))  goto l1944;
  yyDo(G, yy_1_AtxHeading, G->begin, G->end, "yy_1_AtxHeading");
  goto l1943;
  l1944:;	  G->pos= yypos1944; G->thunkpos= yythunkpos1944;
  }
  {  int yypos1945= G->pos, yythunkpos1945= G->thunkpos;
  {  int yypos1947= G->pos, yythunkpos1947= G->thunkpos;  if (!yy_Sp(G))  goto l1947;
  goto l1948;
  l1947:;	  G->pos= yypos1947; G->thunkpos= yythunkpos1947;
  }
  l1948:;	  if (!yy_AutoLabel(G))  goto l1945;
  yyDo(G, yySet, -1, 0, "yySet");
  yyDo(G, yy_2_AtxHeading, G->begin, G->end, "yy_2_AtxHeading");
  goto l1946;
  l1945:;	  G->pos= yypos1945; G->thunkpos= yythunkpos1945;
  }
  l1946:;	
  {  int yypos1949= G->pos, yythunkpos1949= G->thunkpos;
  {  int yypos1951= G->pos, yythunkpos1951= G->thunkpos;  if (!yy_Sp(G))  goto l1951;
  goto l1952;
  l1951:;	  G->pos= yypos1951; G->thunkpos= yythunkpos1951;
  }
  l1952:;	
  l1953:;	
  {  int yypos1954= G->pos, yythunkpos1954= G->thunkpos;  if (!yymatchChar(G, '#')) goto l1954;
  goto l1953;
  l1954:;	  G->pos= yypos1954; G->thunkpos= yythunkpos1954;
  }  if (!yy_Sp(G))  goto l1949;
  goto l1950;
  l1949:;	  G->pos= yypos1949; G->thunkpos= yythunkpos1949;
  }
  l1950:;	  if (!yy_Sp(G))  goto l1940;
  yyText(G, G->begin, G->end);  if (!(YY_BEGIN)) goto l1940;  if (!yy_Newline(G))  goto l1940;
  yyText(G, G->begin, G->end);  if (!(YY_END)) goto l1940;  yyDo(G, yy_3_AtxHeading, G->begin, G->end, "yy_3_AtxHeading");
  yyprintf((stderr, "  ok   AtxHeading"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));
  yyDo(G, yyPop, 3, 0, "yyPop");
  return 1;
  l1940:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "AtxHeading"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_Heading(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "Heading"));

  {  int yypos1956= G->pos, yythunkpos1956= G->thunkpos;  if (!yy_SetextHeading(G))  goto l1957;
  goto l1956;
  l1957:;	  G->pos= yypos1956; G->thunkpos= yythunkpos1956;  if (!yy_AtxHeading(G))  goto l1955;

  }
  l1956:;	  yyprintf((stderr, "  ok   Heading"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l1955:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "Heading"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_HeadingSectionBlock(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "HeadingSectionBlock"));

  l1959:;	
  {  int yypos1960= G->pos, yythunkpos1960= G->thunkpos;  if (!yy_BlankLine(G))  goto l1960;
  goto l1959;
  l1960:;	  G->pos= yypos1960; G->thunkpos= yythunkpos1960;
  }
  {  int yypos1961= G->pos, yythunkpos1961= G->thunkpos;  if (!yy_Heading(G))  goto l1961;
  goto l1958;
  l1961:;	  G->pos= yypos1961; G->thunkpos= yythunkpos1961;
  }
  {  int yypos1962= G->pos, yythunkpos1962= G->thunkpos;  if (!yy_BlockQuote(G))  goto l1963;
  goto l1962;
  l1963:;	  G->pos= yypos1962; G->thunkpos= yythunkpos1962;  if (!yy_Verbatim(G))  goto l1964;
  goto l1962;
  l1964:;	  G->pos= yypos1962; G->thunkpos= yythunkpos1962;  yyText(G, G->begin, G->end);  if (!( !ext(EXT_COMPATIBILITY) )) goto l1965;  if (!yy_DefinitionList(G))  goto l1965;
  goto l1962;
  l1965:;	  G->pos= yypos1962; G->thunkpos= yythunkpos1962;  yyText(G, G->begin, G->end);  if (!( !ext(EXT_COMPATIBILITY) )) goto l1966;  if (!yy_Glossary(G))  goto l1966;
  goto l1962;
  l1966:;	  G->pos= yypos1962; G->thunkpos= yythunkpos1962;  if (!yy_Note(G))  goto l1967;
  goto l1962;
  l1967:;	  G->pos= yypos1962; G->thunkpos= yythunkpos1962;  if (!yy_LinkReference(G))  goto l1968;
  goto l1962;
  l1968:;	  G->pos= yypos1962; G->thunkpos= yythunkpos1962;  if (!yy_HorizontalRule(G))  goto l1969;
  goto l1962;
  l1969:;	  G->pos= yypos1962; G->thunkpos= yythunkpos1962;  if (!yy_OrderedList(G))  goto l1970;
  goto l1962;
  l1970:;	  G->pos= yypos1962; G->thunkpos= yythunkpos1962;  if (!yy_BulletList(G))  goto l1971;
  goto l1962;
  l1971:;	  G->pos= yypos1962; G->thunkpos= yythunkpos1962;  if (!yy_HtmlBlock(G))  goto l1972;
  goto l1962;
  l1972:;	  G->pos= yypos1962; G->thunkpos= yythunkpos1962;  if (!yy_MarkdownHtmlBlock(G))  goto l1973;
  goto l1962;
  l1973:;	  G->pos= yypos1962; G->thunkpos= yythunkpos1962;  if (!yy_StyleBlock(G))  goto l1974;
  goto l1962;
  l1974:;	  G->pos= yypos1962; G->thunkpos= yythunkpos1962;  yyText(G, G->begin, G->end);  if (!( !ext(EXT_COMPATIBILITY) )) goto l1975;  if (!yy_Table(G))  goto l1975;
  goto l1962;
  l1975:;	  G->pos= yypos1962; G->thunkpos= yythunkpos1962;  yyText(G, G->begin, G->end);  if (!( !ext(EXT_COMPATIBILITY) )) goto l1976;  if (!yy_ImageBlock(G))  goto l1976;
  goto l1962;
  l1976:;	  G->pos= yypos1962; G->thunkpos= yythunkpos1962;
  {  int yypos1978= G->pos, yythunkpos1978= G->thunkpos;
  {  int yypos1979= G->pos, yythunkpos1979= G->thunkpos;  if (!yy_Sp(G))  goto l1979;
  goto l1980;
  l1979:;	  G->pos= yypos1979; G->thunkpos= yythunkpos1979;
  }
  l1980:;	  if (!yy_HtmlBlockInTags(G))  goto l1978;
  goto l1977;
  l1978:;	  G->pos= yypos1978; G->thunkpos= yythunkpos1978;
  }  if (!yy_Para(G))  goto l1977;
  goto l1962;
  l1977:;	  G->pos= yypos1962; G->thunkpos= yythunkpos1962;  if (!yy_Plain(G))  goto l1958;

  }
  l1962:;	  yyprintf((stderr, "  ok   HeadingSectionBlock"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l1958:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "HeadingSectionBlock"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_Plain(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyDo(G, yyPush, 1, 0, "yyPush");
  yyprintfv((stderr, "%s\n", "Plain"));
  if (!yy_Inlines(G))  goto l1981;
  yyDo(G, yySet, -1, 0, "yySet");
  yyDo(G, yy_1_Plain, G->begin, G->end, "yy_1_Plain");
  yyprintf((stderr, "  ok   Plain"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));
  yyDo(G, yyPop, 1, 0, "yyPop");
  return 1;
  l1981:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "Plain"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_Para(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyDo(G, yyPush, 1, 0, "yyPush");
  yyprintfv((stderr, "%s\n", "Para"));
  if (!yy_NonindentSpace(G))  goto l1982;
  if (!yy_Inlines(G))  goto l1982;
  yyDo(G, yySet, -1, 0, "yySet");
  if (!yy_BlankLine(G))  goto l1982;

  l1983:;	
  {  int yypos1984= G->pos, yythunkpos1984= G->thunkpos;  if (!yy_BlankLine(G))  goto l1984;
  goto l1983;
  l1984:;	  G->pos= yypos1984; G->thunkpos= yythunkpos1984;
  }  yyDo(G, yy_1_Para, G->begin, G->end, "yy_1_Para");
  yyprintf((stderr, "  ok   Para"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));
  yyDo(G, yyPop, 1, 0, "yyPop");
  return 1;
  l1982:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "Para"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_HtmlBlockInTags(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "HtmlBlockInTags"));

  {  int yypos1986= G->pos, yythunkpos1986= G->thunkpos;  if (!yy_HtmlBlockAddress(G))  goto l1987;
  goto l1986;
  l1987:;	  G->pos= yypos1986; G->thunkpos= yythunkpos1986;  if (!yy_HtmlBlockArticle(G))  goto l1988;
  goto l1986;
  l1988:;	  G->pos= yypos1986; G->thunkpos= yythunkpos1986;  if (!yy_HtmlBlockAside(G))  goto l1989;
  goto l1986;
  l1989:;	  G->pos= yypos1986; G->thunkpos= yythunkpos1986;  if (!yy_HtmlBlockCanvas(G))  goto l1990;
  goto l1986;
  l1990:;	  G->pos= yypos1986; G->thunkpos= yythunkpos1986;  if (!yy_HtmlBlockBlockquote(G))  goto l1991;
  goto l1986;
  l1991:;	  G->pos= yypos1986; G->thunkpos= yythunkpos1986;  if (!yy_HtmlBlockCenter(G))  goto l1992;
  goto l1986;
  l1992:;	  G->pos= yypos1986; G->thunkpos= yythunkpos1986;  if (!yy_HtmlBlockDir(G))  goto l1993;
  goto l1986;
  l1993:;	  G->pos= yypos1986; G->thunkpos= yythunkpos1986;  if (!yy_HtmlBlockDiv(G))  goto l1994;
  goto l1986;
  l1994:;	  G->pos= yypos1986; G->thunkpos= yythunkpos1986;  if (!yy_HtmlBlockDl(G))  goto l1995;
  goto l1986;
  l1995:;	  G->pos= yypos1986; G->thunkpos= yythunkpos1986;  if (!yy_HtmlBlockFieldset(G))  goto l1996;
  goto l1986;
  l1996:;	  G->pos= yypos1986; G->thunkpos= yythunkpos1986;  if (!yy_HtmlBlockFigure(G))  goto l1997;
  goto l1986;
  l1997:;	  G->pos= yypos1986; G->thunkpos= yythunkpos1986;  if (!yy_HtmlBlockFooter(G))  goto l1998;
  goto l1986;
  l1998:;	  G->pos= yypos1986; G->thunkpos= yythunkpos1986;  if (!yy_HtmlBlockForm(G))  goto l1999;
  goto l1986;
  l1999:;	  G->pos= yypos1986; G->thunkpos= yythunkpos1986;  if (!yy_HtmlBlockHeader(G))  goto l2000;
  goto l1986;
  l2000:;	  G->pos= yypos1986; G->thunkpos= yythunkpos1986;  if (!yy_HtmlBlockHgroup(G))  goto l2001;
  goto l1986;
  l2001:;	  G->pos= yypos1986; G->thunkpos= yythunkpos1986;  if (!yy_HtmlBlockH1(G))  goto l2002;
  goto l1986;
  l2002:;	  G->pos= yypos1986; G->thunkpos= yythunkpos1986;  if (!yy_HtmlBlockH2(G))  goto l2003;
  goto l1986;
  l2003:;	  G->pos= yypos1986; G->thunkpos= yythunkpos1986;  if (!yy_HtmlBlockH3(G))  goto l2004;
  goto l1986;
  l2004:;	  G->pos= yypos1986; G->thunkpos= yythunkpos1986;  if (!yy_HtmlBlockH4(G))  goto l2005;
  goto l1986;
  l2005:;	  G->pos= yypos1986; G->thunkpos= yythunkpos1986;  if (!yy_HtmlBlockH5(G))  goto l2006;
  goto l1986;
  l2006:;	  G->pos= yypos1986; G->thunkpos= yythunkpos1986;  if (!yy_HtmlBlockH6(G))  goto l2007;
  goto l1986;
  l2007:;	  G->pos= yypos1986; G->thunkpos= yythunkpos1986;  if (!yy_HtmlBlockMenu(G))  goto l2008;
  goto l1986;
  l2008:;	  G->pos= yypos1986; G->thunkpos= yythunkpos1986;  if (!yy_HtmlBlockNoframes(G))  goto l2009;
  goto l1986;
  l2009:;	  G->pos= yypos1986; G->thunkpos= yythunkpos1986;  if (!yy_HtmlBlockNoscript(G))  goto l2010;
  goto l1986;
  l2010:;	  G->pos= yypos1986; G->thunkpos= yythunkpos1986;  if (!yy_HtmlBlockOl(G))  goto l2011;
  goto l1986;
  l2011:;	  G->pos= yypos1986; G->thunkpos= yythunkpos1986;  if (!yy_HtmlBlockP(G))  goto l2012;
  goto l1986;
  l2012:;	  G->pos= yypos1986; G->thunkpos= yythunkpos1986;  if (!yy_HtmlBlockPre(G))  goto l2013;
  goto l1986;
  l2013:;	  G->pos= yypos1986; G->thunkpos= yythunkpos1986;  if (!yy_HtmlBlockProgress(G))  goto l2014;
  goto l1986;
  l2014:;	  G->pos= yypos1986; G->thunkpos= yythunkpos1986;  if (!yy_HtmlBlockSection(G))  goto l2015;
  goto l1986;
  l2015:;	  G->pos= yypos1986; G->thunkpos= yythunkpos1986;  if (!yy_HtmlBlockTable(G))  goto l2016;
  goto l1986;
  l2016:;	  G->pos= yypos1986; G->thunkpos= yythunkpos1986;  if (!yy_HtmlBlockUl(G))  goto l2017;
  goto l1986;
  l2017:;	  G->pos= yypos1986; G->thunkpos= yythunkpos1986;  if (!yy_HtmlBlockVideo(G))  goto l2018;
  goto l1986;
  l2018:;	  G->pos= yypos1986; G->thunkpos= yythunkpos1986;  if (!yy_HtmlBlockDd(G))  goto l2019;
  goto l1986;
  l2019:;	  G->pos= yypos1986; G->thunkpos= yythunkpos1986;  if (!yy_HtmlBlockDt(G))  goto l2020;
  goto l1986;
  l2020:;	  G->pos= yypos1986; G->thunkpos= yythunkpos1986;  if (!yy_HtmlBlockFrameset(G))  goto l2021;
  goto l1986;
  l2021:;	  G->pos= yypos1986; G->thunkpos= yythunkpos1986;  if (!yy_HtmlBlockLi(G))  goto l2022;
  goto l1986;
  l2022:;	  G->pos= yypos1986; G->thunkpos= yythunkpos1986;  if (!yy_HtmlBlockTbody(G))  goto l2023;
  goto l1986;
  l2023:;	  G->pos= yypos1986; G->thunkpos= yythunkpos1986;  if (!yy_HtmlBlockTd(G))  goto l2024;
  goto l1986;
  l2024:;	  G->pos= yypos1986; G->thunkpos= yythunkpos1986;  if (!yy_HtmlBlockTfoot(G))  goto l2025;
  goto l1986;
  l2025:;	  G->pos= yypos1986; G->thunkpos= yythunkpos1986;  if (!yy_HtmlBlockTh(G))  goto l2026;
  goto l1986;
  l2026:;	  G->pos= yypos1986; G->thunkpos= yythunkpos1986;  if (!yy_HtmlBlockThead(G))  goto l2027;
  goto l1986;
  l2027:;	  G->pos= yypos1986; G->thunkpos= yythunkpos1986;  if (!yy_HtmlBlockTr(G))  goto l2028;
  goto l1986;
  l2028:;	  G->pos= yypos1986; G->thunkpos= yythunkpos1986;  if (!yy_HtmlBlockScript(G))  goto l1985;

  }
  l1986:;	  yyprintf((stderr, "  ok   HtmlBlockInTags"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l1985:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "HtmlBlockInTags"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_ImageBlock(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "ImageBlock"));
  if (!yy_Image(G))  goto l2029;
  if (!yy_Sp(G))  goto l2029;
  if (!yy_Newline(G))  goto l2029;
  if (!yy_BlankLine(G))  goto l2029;

  l2030:;	
  {  int yypos2031= G->pos, yythunkpos2031= G->thunkpos;  if (!yy_BlankLine(G))  goto l2031;
  goto l2030;
  l2031:;	  G->pos= yypos2031; G->thunkpos= yythunkpos2031;
  }  yyDo(G, yy_1_ImageBlock, G->begin, G->end, "yy_1_ImageBlock");
  yyprintf((stderr, "  ok   ImageBlock"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l2029:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "ImageBlock"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_Table(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyDo(G, yyPush, 2, 0, "yyPush");
  yyprintfv((stderr, "%s\n", "Table"));
  if (!yy_StartList(G))  goto l2032;
  yyDo(G, yySet, -2, 0, "yySet");
  if (!yy_StartList(G))  goto l2032;
  yyDo(G, yySet, -1, 0, "yySet");

  {  int yypos2033= G->pos, yythunkpos2033= G->thunkpos;  if (!yy_TableCaption(G))  goto l2033;
  yyDo(G, yy_1_Table, G->begin, G->end, "yy_1_Table");
  goto l2034;
  l2033:;	  G->pos= yypos2033; G->thunkpos= yythunkpos2033;
  }
  l2034:;	  if (!yy_TableBody(G))  goto l2032;
  yyDo(G, yy_2_Table, G->begin, G->end, "yy_2_Table");
  if (!yy_SeparatorLine(G))  goto l2032;
  yyDo(G, yy_3_Table, G->begin, G->end, "yy_3_Table");
  if (!yy_TableBody(G))  goto l2032;
  yyDo(G, yy_4_Table, G->begin, G->end, "yy_4_Table");

  l2035:;	
  {  int yypos2036= G->pos, yythunkpos2036= G->thunkpos;  if (!yy_BlankLine(G))  goto l2036;

  {  int yypos2037= G->pos, yythunkpos2037= G->thunkpos;  if (!yy_TableCaption(G))  goto l2037;
  goto l2036;
  l2037:;	  G->pos= yypos2037; G->thunkpos= yythunkpos2037;
  }  if (!yy_TableBody(G))  goto l2036;
  yyDo(G, yy_5_Table, G->begin, G->end, "yy_5_Table");

  {  int yypos2038= G->pos, yythunkpos2038= G->thunkpos;
  {  int yypos2039= G->pos, yythunkpos2039= G->thunkpos;  if (!yy_TableCaption(G))  goto l2040;
  goto l2039;
  l2040:;	  G->pos= yypos2039; G->thunkpos= yythunkpos2039;  if (!yy_BlankLine(G))  goto l2036;

  }
  l2039:;	  G->pos= yypos2038; G->thunkpos= yythunkpos2038;
  }  goto l2035;
  l2036:;	  G->pos= yypos2036; G->thunkpos= yythunkpos2036;
  }
  {  int yypos2041= G->pos, yythunkpos2041= G->thunkpos;  if (!yy_TableCaption(G))  goto l2042;
  yyDo(G, yy_6_Table, G->begin, G->end, "yy_6_Table");

  {  int yypos2043= G->pos, yythunkpos2043= G->thunkpos;  if (!yy_BlankLine(G))  goto l2042;
  G->pos= yypos2043; G->thunkpos= yythunkpos2043;
  }  goto l2041;
  l2042:;	  G->pos= yypos2041; G->thunkpos= yythunkpos2041;
  {  int yypos2044= G->pos, yythunkpos2044= G->thunkpos;  if (!yy_BlankLine(G))  goto l2032;
  G->pos= yypos2044; G->thunkpos= yythunkpos2044;
  }
  }
  l2041:;	  yyDo(G, yy_7_Table, G->begin, G->end, "yy_7_Table");
  yyprintf((stderr, "  ok   Table"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));
  yyDo(G, yyPop, 2, 0, "yyPop");
  return 1;
  l2032:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "Table"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_StyleBlock(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "StyleBlock"));
  yyText(G, G->begin, G->end);  if (!(YY_BEGIN)) goto l2045;  if (!yy_InStyleTags(G))  goto l2045;
  yyText(G, G->begin, G->end);  if (!(YY_END)) goto l2045;
  l2046:;	
  {  int yypos2047= G->pos, yythunkpos2047= G->thunkpos;  if (!yy_BlankLine(G))  goto l2047;
  goto l2046;
  l2047:;	  G->pos= yypos2047; G->thunkpos= yythunkpos2047;
  }  yyDo(G, yy_1_StyleBlock, G->begin, G->end, "yy_1_StyleBlock");
  yyprintf((stderr, "  ok   StyleBlock"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l2045:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "StyleBlock"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_MarkdownHtmlBlock(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "MarkdownHtmlBlock"));

  {  int yypos2049= G->pos, yythunkpos2049= G->thunkpos;  if (!yy_MarkdownHtmlTagOpen(G))  goto l2048;
  G->pos= yypos2049; G->thunkpos= yythunkpos2049;
  }  yyText(G, G->begin, G->end);  if (!(YY_BEGIN)) goto l2048;
  {  int yypos2050= G->pos, yythunkpos2050= G->thunkpos;  if (!yy_HtmlBlockInTags(G))  goto l2051;
  goto l2050;
  l2051:;	  G->pos= yypos2050; G->thunkpos= yythunkpos2050;  if (!yy_HtmlComment(G))  goto l2052;
  goto l2050;
  l2052:;	  G->pos= yypos2050; G->thunkpos= yythunkpos2050;  if (!yy_HtmlBlockSelfClosing(G))  goto l2048;

  }
  l2050:;	  yyText(G, G->begin, G->end);  if (!(YY_END)) goto l2048;  if (!yy_BlankLine(G))  goto l2048;

  l2053:;	
  {  int yypos2054= G->pos, yythunkpos2054= G->thunkpos;  if (!yy_BlankLine(G))  goto l2054;
  goto l2053;
  l2054:;	  G->pos= yypos2054; G->thunkpos= yythunkpos2054;
  }  yyDo(G, yy_1_MarkdownHtmlBlock, G->begin, G->end, "yy_1_MarkdownHtmlBlock");
  yyprintf((stderr, "  ok   MarkdownHtmlBlock"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l2048:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "MarkdownHtmlBlock"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_HtmlBlock(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "HtmlBlock"));

  {  int yypos2056= G->pos, yythunkpos2056= G->thunkpos;  if (!yy_MarkdownHtmlTagOpen(G))  goto l2056;
  goto l2055;
  l2056:;	  G->pos= yypos2056; G->thunkpos= yythunkpos2056;
  }  yyText(G, G->begin, G->end);  if (!(YY_BEGIN)) goto l2055;
  {  int yypos2057= G->pos, yythunkpos2057= G->thunkpos;  if (!yy_HtmlBlockInTags(G))  goto l2058;
  goto l2057;
  l2058:;	  G->pos= yypos2057; G->thunkpos= yythunkpos2057;  if (!yy_HtmlComment(G))  goto l2059;
  goto l2057;
  l2059:;	  G->pos= yypos2057; G->thunkpos= yythunkpos2057;  if (!yy_HtmlBlockSelfClosing(G))  goto l2055;

  }
  l2057:;	  yyText(G, G->begin, G->end);  if (!(YY_END)) goto l2055;  if (!yy_BlankLine(G))  goto l2055;

  l2060:;	
  {  int yypos2061= G->pos, yythunkpos2061= G->thunkpos;  if (!yy_BlankLine(G))  goto l2061;
  goto l2060;
  l2061:;	  G->pos= yypos2061; G->thunkpos= yythunkpos2061;
  }  yyDo(G, yy_1_HtmlBlock, G->begin, G->end, "yy_1_HtmlBlock");
  yyprintf((stderr, "  ok   HtmlBlock"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l2055:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "HtmlBlock"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_BulletList(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "BulletList"));

  {  int yypos2063= G->pos, yythunkpos2063= G->thunkpos;  if (!yy_Bullet(G))  goto l2062;
  G->pos= yypos2063; G->thunkpos= yythunkpos2063;
  }
  {  int yypos2064= G->pos, yythunkpos2064= G->thunkpos;  if (!yy_ListTight(G))  goto l2065;
  goto l2064;
  l2065:;	  G->pos= yypos2064; G->thunkpos= yythunkpos2064;  if (!yy_ListLoose(G))  goto l2062;

  }
  l2064:;	  yyDo(G, yy_1_BulletList, G->begin, G->end, "yy_1_BulletList");
  yyprintf((stderr, "  ok   BulletList"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l2062:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "BulletList"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_OrderedList(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "OrderedList"));

  {  int yypos2067= G->pos, yythunkpos2067= G->thunkpos;  if (!yy_Enumerator(G))  goto l2066;
  G->pos= yypos2067; G->thunkpos= yythunkpos2067;
  }
  {  int yypos2068= G->pos, yythunkpos2068= G->thunkpos;  if (!yy_ListTight(G))  goto l2069;
  goto l2068;
  l2069:;	  G->pos= yypos2068; G->thunkpos= yythunkpos2068;  if (!yy_ListLoose(G))  goto l2066;

  }
  l2068:;	  yyDo(G, yy_1_OrderedList, G->begin, G->end, "yy_1_OrderedList");
  yyprintf((stderr, "  ok   OrderedList"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l2066:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "OrderedList"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_HeadingSection(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyDo(G, yyPush, 1, 0, "yyPush");
  yyprintfv((stderr, "%s\n", "HeadingSection"));
  if (!yy_StartList(G))  goto l2070;
  yyDo(G, yySet, -1, 0, "yySet");
  if (!yy_Heading(G))  goto l2070;
  yyDo(G, yy_1_HeadingSection, G->begin, G->end, "yy_1_HeadingSection");

  l2071:;	
  {  int yypos2072= G->pos, yythunkpos2072= G->thunkpos;  if (!yy_HeadingSectionBlock(G))  goto l2072;
  yyDo(G, yy_2_HeadingSection, G->begin, G->end, "yy_2_HeadingSection");
  goto l2071;
  l2072:;	  G->pos= yypos2072; G->thunkpos= yythunkpos2072;
  }  yyDo(G, yy_3_HeadingSection, G->begin, G->end, "yy_3_HeadingSection");
  yyprintf((stderr, "  ok   HeadingSection"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));
  yyDo(G, yyPop, 1, 0, "yyPop");
  return 1;
  l2070:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "HeadingSection"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_HorizontalRule(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "HorizontalRule"));
  if (!yy_NonindentSpace(G))  goto l2073;

  {  int yypos2074= G->pos, yythunkpos2074= G->thunkpos;  if (!yymatchChar(G, '*')) goto l2075;
  if (!yy_Sp(G))  goto l2075;
  if (!yymatchChar(G, '*')) goto l2075;
  if (!yy_Sp(G))  goto l2075;
  if (!yymatchChar(G, '*')) goto l2075;

  l2076:;	
  {  int yypos2077= G->pos, yythunkpos2077= G->thunkpos;  if (!yy_Sp(G))  goto l2077;
  if (!yymatchChar(G, '*')) goto l2077;
  goto l2076;
  l2077:;	  G->pos= yypos2077; G->thunkpos= yythunkpos2077;
  }  goto l2074;
  l2075:;	  G->pos= yypos2074; G->thunkpos= yythunkpos2074;  if (!yymatchChar(G, '-')) goto l2078;
  if (!yy_Sp(G))  goto l2078;
  if (!yymatchChar(G, '-')) goto l2078;
  if (!yy_Sp(G))  goto l2078;
  if (!yymatchChar(G, '-')) goto l2078;

  l2079:;	
  {  int yypos2080= G->pos, yythunkpos2080= G->thunkpos;  if (!yy_Sp(G))  goto l2080;
  if (!yymatchChar(G, '-')) goto l2080;
  goto l2079;
  l2080:;	  G->pos= yypos2080; G->thunkpos= yythunkpos2080;
  }  goto l2074;
  l2078:;	  G->pos= yypos2074; G->thunkpos= yythunkpos2074;  if (!yymatchChar(G, '_')) goto l2073;
  if (!yy_Sp(G))  goto l2073;
  if (!yymatchChar(G, '_')) goto l2073;
  if (!yy_Sp(G))  goto l2073;
  if (!yymatchChar(G, '_')) goto l2073;

  l2081:;	
  {  int yypos2082= G->pos, yythunkpos2082= G->thunkpos;  if (!yy_Sp(G))  goto l2082;
  if (!yymatchChar(G, '_')) goto l2082;
  goto l2081;
  l2082:;	  G->pos= yypos2082; G->thunkpos= yythunkpos2082;
  }
  }
  l2074:;	  if (!yy_Sp(G))  goto l2073;
  if (!yy_Newline(G))  goto l2073;
  if (!yy_BlankLine(G))  goto l2073;

  l2083:;	
  {  int yypos2084= G->pos, yythunkpos2084= G->thunkpos;  if (!yy_BlankLine(G))  goto l2084;
  goto l2083;
  l2084:;	  G->pos= yypos2084; G->thunkpos= yythunkpos2084;
  }  yyDo(G, yy_1_HorizontalRule, G->begin, G->end, "yy_1_HorizontalRule");
  yyprintf((stderr, "  ok   HorizontalRule"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l2073:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "HorizontalRule"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_LinkReference(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyDo(G, yyPush, 4, 0, "yyPush");
  yyprintfv((stderr, "%s\n", "LinkReference"));
  if (!yy_StartList(G))  goto l2085;
  yyDo(G, yySet, -4, 0, "yySet");
  if (!yy_NonindentSpace(G))  goto l2085;

  {  int yypos2086= G->pos, yythunkpos2086= G->thunkpos;  if (!yymatchString(G, "[]")) goto l2086;
  goto l2085;
  l2086:;	  G->pos= yypos2086; G->thunkpos= yythunkpos2086;
  }  if (!yy_Label(G))  goto l2085;
  yyDo(G, yySet, -3, 0, "yySet");
  if (!yymatchChar(G, ':')) goto l2085;
  if (!yy_Spnl(G))  goto l2085;
  if (!yy_RefSrc(G))  goto l2085;
  yyDo(G, yySet, -2, 0, "yySet");
  if (!yy_RefTitle(G))  goto l2085;
  yyDo(G, yySet, -1, 0, "yySet");

  {  int yypos2087= G->pos, yythunkpos2087= G->thunkpos;  yyText(G, G->begin, G->end);  if (!( !ext(EXT_COMPATIBILITY) )) goto l2087;  yyText(G, G->begin, G->end);  if (!(YY_BEGIN)) goto l2087;  if (!yy_Attributes(G))  goto l2087;
  yyDo(G, yy_1_LinkReference, G->begin, G->end, "yy_1_LinkReference");
  goto l2088;
  l2087:;	  G->pos= yypos2087; G->thunkpos= yythunkpos2087;
  }
  l2088:;	  yyText(G, G->begin, G->end);  if (!(YY_END)) goto l2085;  if (!yy_BlankLine(G))  goto l2085;

  l2089:;	
  {  int yypos2090= G->pos, yythunkpos2090= G->thunkpos;  if (!yy_BlankLine(G))  goto l2090;
  goto l2089;
  l2090:;	  G->pos= yypos2090; G->thunkpos= yythunkpos2090;
  }  yyDo(G, yy_2_LinkReference, G->begin, G->end, "yy_2_LinkReference");
  yyprintf((stderr, "  ok   LinkReference"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));
  yyDo(G, yyPop, 4, 0, "yyPop");
  return 1;
  l2085:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "LinkReference"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_Note(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyDo(G, yyPush, 2, 0, "yyPush");
  yyprintfv((stderr, "%s\n", "Note"));
  yyText(G, G->begin, G->end);  if (!( ext(EXT_NOTES) )) goto l2091;  if (!yy_NonindentSpace(G))  goto l2091;
  if (!yy_RawNoteReference(G))  goto l2091;
  yyDo(G, yySet, -2, 0, "yySet");
  if (!yymatchChar(G, ':')) goto l2091;
  if (!yy_Sp(G))  goto l2091;
  if (!yy_StartList(G))  goto l2091;
  yyDo(G, yySet, -1, 0, "yySet");
  if (!yy_RawNoteBlock(G))  goto l2091;
  yyDo(G, yy_1_Note, G->begin, G->end, "yy_1_Note");

  l2092:;	
  {  int yypos2093= G->pos, yythunkpos2093= G->thunkpos;
  {  int yypos2094= G->pos, yythunkpos2094= G->thunkpos;  if (!yy_Indent(G))  goto l2093;
  G->pos= yypos2094; G->thunkpos= yythunkpos2094;
  }  if (!yy_RawNoteBlock(G))  goto l2093;
  yyDo(G, yy_2_Note, G->begin, G->end, "yy_2_Note");
  goto l2092;
  l2093:;	  G->pos= yypos2093; G->thunkpos= yythunkpos2093;
  }  yyDo(G, yy_3_Note, G->begin, G->end, "yy_3_Note");
  yyprintf((stderr, "  ok   Note"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));
  yyDo(G, yyPop, 2, 0, "yyPop");
  return 1;
  l2091:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "Note"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_Glossary(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyDo(G, yyPush, 2, 0, "yyPush");
  yyprintfv((stderr, "%s\n", "Glossary"));
  yyText(G, G->begin, G->end);  if (!( ext(EXT_NOTES) )) goto l2095;  if (!yy_StartList(G))  goto l2095;
  yyDo(G, yySet, -2, 0, "yySet");
  if (!yy_NonindentSpace(G))  goto l2095;
  if (!yy_RawNoteReference(G))  goto l2095;
  yyDo(G, yySet, -1, 0, "yySet");
  if (!yymatchChar(G, ':')) goto l2095;
  if (!yy_Sp(G))  goto l2095;
  if (!yymatchString(G, "glossary:")) goto l2095;
  if (!yy_Sp(G))  goto l2095;
  if (!yy_GlossaryTerm(G))  goto l2095;
  yyDo(G, yy_1_Glossary, G->begin, G->end, "yy_1_Glossary");

  {  int yypos2096= G->pos, yythunkpos2096= G->thunkpos;  if (!yy_GlossarySortKey(G))  goto l2096;
  yyDo(G, yy_2_Glossary, G->begin, G->end, "yy_2_Glossary");
  goto l2097;
  l2096:;	  G->pos= yypos2096; G->thunkpos= yythunkpos2096;
  }
  l2097:;	  if (!yy_Newline(G))  goto l2095;
  if (!yy_RawNoteBlock(G))  goto l2095;
  yyDo(G, yy_3_Glossary, G->begin, G->end, "yy_3_Glossary");

  l2098:;	
  {  int yypos2099= G->pos, yythunkpos2099= G->thunkpos;
  {  int yypos2100= G->pos, yythunkpos2100= G->thunkpos;  if (!yy_Indent(G))  goto l2099;
  G->pos= yypos2100; G->thunkpos= yythunkpos2100;
  }  if (!yy_RawNoteBlock(G))  goto l2099;
  yyDo(G, yy_4_Glossary, G->begin, G->end, "yy_4_Glossary");
  goto l2098;
  l2099:;	  G->pos= yypos2099; G->thunkpos= yythunkpos2099;
  }  yyDo(G, yy_5_Glossary, G->begin, G->end, "yy_5_Glossary");
  yyprintf((stderr, "  ok   Glossary"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));
  yyDo(G, yyPop, 2, 0, "yyPop");
  return 1;
  l2095:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "Glossary"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_DefinitionList(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyDo(G, yyPush, 1, 0, "yyPush");
  yyprintfv((stderr, "%s\n", "DefinitionList"));
  if (!yy_StartList(G))  goto l2101;
  yyDo(G, yySet, -1, 0, "yySet");

  {  int yypos2102= G->pos, yythunkpos2102= G->thunkpos;  if (!yy_TermLine(G))  goto l2101;

  l2103:;	
  {  int yypos2104= G->pos, yythunkpos2104= G->thunkpos;  if (!yy_TermLine(G))  goto l2104;
  goto l2103;
  l2104:;	  G->pos= yypos2104; G->thunkpos= yythunkpos2104;
  }
  {  int yypos2105= G->pos, yythunkpos2105= G->thunkpos;  if (!yy_Newline(G))  goto l2105;
  goto l2106;
  l2105:;	  G->pos= yypos2105; G->thunkpos= yythunkpos2105;
  }
  l2106:;	  if (!yy_NonindentSpace(G))  goto l2101;
  if (!yymatchChar(G, ':')) goto l2101;
  G->pos= yypos2102; G->thunkpos= yythunkpos2102;
  }  if (!yy_Term(G))  goto l2101;
  yyDo(G, yy_1_DefinitionList, G->begin, G->end, "yy_1_DefinitionList");

  l2109:;	
  {  int yypos2110= G->pos, yythunkpos2110= G->thunkpos;  if (!yy_Term(G))  goto l2110;
  yyDo(G, yy_1_DefinitionList, G->begin, G->end, "yy_1_DefinitionList");
  goto l2109;
  l2110:;	  G->pos= yypos2110; G->thunkpos= yythunkpos2110;
  }
  {  int yypos2111= G->pos, yythunkpos2111= G->thunkpos;  if (!yy_BlankLine(G))  goto l2111;
  goto l2112;
  l2111:;	  G->pos= yypos2111; G->thunkpos= yythunkpos2111;
  }
  l2112:;	  if (!yy_Definition(G))  goto l2101;
  yyDo(G, yy_2_DefinitionList, G->begin, G->end, "yy_2_DefinitionList");

  l2113:;	
  {  int yypos2114= G->pos, yythunkpos2114= G->thunkpos;  if (!yy_Definition(G))  goto l2114;
  yyDo(G, yy_2_DefinitionList, G->begin, G->end, "yy_2_DefinitionList");
  goto l2113;
  l2114:;	  G->pos= yypos2114; G->thunkpos= yythunkpos2114;
  }
  l2115:;	
  {  int yypos2116= G->pos, yythunkpos2116= G->thunkpos;  if (!yy_BlankLine(G))  goto l2116;
  goto l2115;
  l2116:;	  G->pos= yypos2116; G->thunkpos= yythunkpos2116;
  }
  l2107:;	
  {  int yypos2108= G->pos, yythunkpos2108= G->thunkpos;  if (!yy_Term(G))  goto l2108;
  yyDo(G, yy_1_DefinitionList, G->begin, G->end, "yy_1_DefinitionList");

  l2117:;	
  {  int yypos2118= G->pos, yythunkpos2118= G->thunkpos;  if (!yy_Term(G))  goto l2118;
  yyDo(G, yy_1_DefinitionList, G->begin, G->end, "yy_1_DefinitionList");
  goto l2117;
  l2118:;	  G->pos= yypos2118; G->thunkpos= yythunkpos2118;
  }
  {  int yypos2119= G->pos, yythunkpos2119= G->thunkpos;  if (!yy_BlankLine(G))  goto l2119;
  goto l2120;
  l2119:;	  G->pos= yypos2119; G->thunkpos= yythunkpos2119;
  }
  l2120:;	  if (!yy_Definition(G))  goto l2108;
  yyDo(G, yy_2_DefinitionList, G->begin, G->end, "yy_2_DefinitionList");

  l2121:;	
  {  int yypos2122= G->pos, yythunkpos2122= G->thunkpos;  if (!yy_Definition(G))  goto l2122;
  yyDo(G, yy_2_DefinitionList, G->begin, G->end, "yy_2_DefinitionList");
  goto l2121;
  l2122:;	  G->pos= yypos2122; G->thunkpos= yythunkpos2122;
  }
  l2123:;	
  {  int yypos2124= G->pos, yythunkpos2124= G->thunkpos;  if (!yy_BlankLine(G))  goto l2124;
  goto l2123;
  l2124:;	  G->pos= yypos2124; G->thunkpos= yythunkpos2124;
  }  goto l2107;
  l2108:;	  G->pos= yypos2108; G->thunkpos= yythunkpos2108;
  }  yyDo(G, yy_3_DefinitionList, G->begin, G->end, "yy_3_DefinitionList");
  yyprintf((stderr, "  ok   DefinitionList"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));
  yyDo(G, yyPop, 1, 0, "yyPop");
  return 1;
  l2101:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "DefinitionList"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_Verbatim(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyDo(G, yyPush, 1, 0, "yyPush");
  yyprintfv((stderr, "%s\n", "Verbatim"));

  l2126:;	
  {  int yypos2127= G->pos, yythunkpos2127= G->thunkpos;  if (!yy_BlankLine(G))  goto l2127;
  goto l2126;
  l2127:;	  G->pos= yypos2127; G->thunkpos= yythunkpos2127;
  }  if (!yy_StartList(G))  goto l2125;
  yyDo(G, yySet, -1, 0, "yySet");
  if (!yy_VerbatimChunk(G))  goto l2125;
  yyDo(G, yy_1_Verbatim, G->begin, G->end, "yy_1_Verbatim");

  l2128:;	
  {  int yypos2129= G->pos, yythunkpos2129= G->thunkpos;  if (!yy_VerbatimChunk(G))  goto l2129;
  yyDo(G, yy_1_Verbatim, G->begin, G->end, "yy_1_Verbatim");
  goto l2128;
  l2129:;	  G->pos= yypos2129; G->thunkpos= yythunkpos2129;
  }
  l2130:;	
  {  int yypos2131= G->pos, yythunkpos2131= G->thunkpos;  if (!yy_BlankLine(G))  goto l2131;
  goto l2130;
  l2131:;	  G->pos= yypos2131; G->thunkpos= yythunkpos2131;
  }  yyDo(G, yy_2_Verbatim, G->begin, G->end, "yy_2_Verbatim");
  yyprintf((stderr, "  ok   Verbatim"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));
  yyDo(G, yyPop, 1, 0, "yyPop");
  return 1;
  l2125:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "Verbatim"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_BlockQuote(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyDo(G, yyPush, 1, 0, "yyPush");
  yyprintfv((stderr, "%s\n", "BlockQuote"));
  if (!yy_BlockQuoteRaw(G))  goto l2132;
  yyDo(G, yySet, -1, 0, "yySet");
  yyDo(G, yy_1_BlockQuote, G->begin, G->end, "yy_1_BlockQuote");
  yyprintf((stderr, "  ok   BlockQuote"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));
  yyDo(G, yyPop, 1, 0, "yyPop");
  return 1;
  l2132:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "BlockQuote"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_RawLine(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "RawLine"));

  {  int yypos2134= G->pos, yythunkpos2134= G->thunkpos;  yyText(G, G->begin, G->end);  if (!(YY_BEGIN)) goto l2135;
  l2136:;	
  {  int yypos2137= G->pos, yythunkpos2137= G->thunkpos;
  {  int yypos2138= G->pos, yythunkpos2138= G->thunkpos;  if (!yymatchChar(G, '\r')) goto l2138;
  goto l2137;
  l2138:;	  G->pos= yypos2138; G->thunkpos= yythunkpos2138;
  }
  {  int yypos2139= G->pos, yythunkpos2139= G->thunkpos;  if (!yymatchChar(G, '\n')) goto l2139;
  goto l2137;
  l2139:;	  G->pos= yypos2139; G->thunkpos= yythunkpos2139;
  }  if (!yymatchDot(G)) goto l2137;  goto l2136;
  l2137:;	  G->pos= yypos2137; G->thunkpos= yythunkpos2137;
  }  if (!yy_Newline(G))  goto l2135;
  yyText(G, G->begin, G->end);  if (!(YY_END)) goto l2135;  goto l2134;
  l2135:;	  G->pos= yypos2134; G->thunkpos= yythunkpos2134;  yyText(G, G->begin, G->end);  if (!(YY_BEGIN)) goto l2133;  if (!yymatchDot(G)) goto l2133;
  l2140:;	
  {  int yypos2141= G->pos, yythunkpos2141= G->thunkpos;  if (!yymatchDot(G)) goto l2141;  goto l2140;
  l2141:;	  G->pos= yypos2141; G->thunkpos= yythunkpos2141;
  }  yyText(G, G->begin, G->end);  if (!(YY_END)) goto l2133;  if (!yy_Eof(G))  goto l2133;

  }
  l2134:;	  yyprintf((stderr, "  ok   RawLine"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l2133:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "RawLine"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_SingleLineMetaKeyValue(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "SingleLineMetaKeyValue"));
  if (!yy_MetaDataKey(G))  goto l2142;
  if (!yy_Sp(G))  goto l2142;
  if (!yymatchChar(G, ':')) goto l2142;
  if (!yy_Sp(G))  goto l2142;

  l2143:;	
  {  int yypos2144= G->pos, yythunkpos2144= G->thunkpos;
  {  int yypos2145= G->pos, yythunkpos2145= G->thunkpos;  if (!yy_Newline(G))  goto l2145;
  goto l2144;
  l2145:;	  G->pos= yypos2145; G->thunkpos= yythunkpos2145;
  }  if (!yymatchDot(G)) goto l2144;  goto l2143;
  l2144:;	  G->pos= yypos2144; G->thunkpos= yythunkpos2144;
  }  yyprintf((stderr, "  ok   SingleLineMetaKeyValue"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l2142:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "SingleLineMetaKeyValue"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_AlphanumericAscii(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "AlphanumericAscii"));
  if (!yymatchClass(G, (unsigned char *)"\000\000\000\000\000\000\377\003\376\377\377\007\376\377\377\007\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000", "A-Za-z0-9")) goto l2146;
  yyprintf((stderr, "  ok   AlphanumericAscii"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l2146:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "AlphanumericAscii"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_MetaDataValue(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyDo(G, yyPush, 1, 0, "yyPush");
  yyprintfv((stderr, "%s\n", "MetaDataValue"));
  if (!yy_StartList(G))  goto l2147;
  yyDo(G, yySet, -1, 0, "yySet");
  yyText(G, G->begin, G->end);  if (!(YY_BEGIN)) goto l2147;
  l2148:;	
  {  int yypos2149= G->pos, yythunkpos2149= G->thunkpos;
  {  int yypos2150= G->pos, yythunkpos2150= G->thunkpos;  if (!yy_Newline(G))  goto l2150;
  goto l2149;
  l2150:;	  G->pos= yypos2150; G->thunkpos= yythunkpos2150;
  }  if (!yymatchDot(G)) goto l2149;  goto l2148;
  l2149:;	  G->pos= yypos2149; G->thunkpos= yythunkpos2149;
  }  yyText(G, G->begin, G->end);  if (!(YY_END)) goto l2147;  yyDo(G, yy_1_MetaDataValue, G->begin, G->end, "yy_1_MetaDataValue");

  {  int yypos2151= G->pos, yythunkpos2151= G->thunkpos;  if (!yy_Newline(G))  goto l2152;

  {  int yypos2153= G->pos, yythunkpos2153= G->thunkpos;
  {  int yypos2154= G->pos, yythunkpos2154= G->thunkpos;  if (!yy_BlankLine(G))  goto l2154;
  goto l2152;
  l2154:;	  G->pos= yypos2154; G->thunkpos= yythunkpos2154;
  }
  {  int yypos2155= G->pos, yythunkpos2155= G->thunkpos;  if (!yy_SingleLineMetaKeyValue(G))  goto l2155;
  goto l2152;
  l2155:;	  G->pos= yypos2155; G->thunkpos= yythunkpos2155;
  }  if (!yy_Sp(G))  goto l2152;
  if (!yy_RawLine(G))  goto l2152;
  G->pos= yypos2153; G->thunkpos= yythunkpos2153;
  }  yyDo(G, yy_2_MetaDataValue, G->begin, G->end, "yy_2_MetaDataValue");
  goto l2151;
  l2152:;	  G->pos= yypos2151; G->thunkpos= yythunkpos2151;  if (!yy_Newline(G))  goto l2147;

  }
  l2151:;	
  l2156:;	
  {  int yypos2157= G->pos, yythunkpos2157= G->thunkpos;
  {  int yypos2158= G->pos, yythunkpos2158= G->thunkpos;  if (!yy_BlankLine(G))  goto l2158;
  goto l2157;
  l2158:;	  G->pos= yypos2158; G->thunkpos= yythunkpos2158;
  }
  {  int yypos2159= G->pos, yythunkpos2159= G->thunkpos;  if (!yy_SingleLineMetaKeyValue(G))  goto l2159;
  goto l2157;
  l2159:;	  G->pos= yypos2159; G->thunkpos= yythunkpos2159;
  }  if (!yy_Sp(G))  goto l2157;
  if (!yy_RawLine(G))  goto l2157;
  yyDo(G, yy_3_MetaDataValue, G->begin, G->end, "yy_3_MetaDataValue");
  goto l2156;
  l2157:;	  G->pos= yypos2157; G->thunkpos= yythunkpos2157;
  }  yyDo(G, yy_4_MetaDataValue, G->begin, G->end, "yy_4_MetaDataValue");
  yyprintf((stderr, "  ok   MetaDataValue"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));
  yyDo(G, yyPop, 1, 0, "yyPop");
  return 1;
  l2147:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "MetaDataValue"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_MetaDataKeyValue(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyDo(G, yyPush, 2, 0, "yyPush");
  yyprintfv((stderr, "%s\n", "MetaDataKeyValue"));
  if (!yy_MetaDataKey(G))  goto l2160;
  yyDo(G, yySet, -2, 0, "yySet");
  if (!yy_Sp(G))  goto l2160;
  if (!yymatchChar(G, ':')) goto l2160;
  if (!yy_Sp(G))  goto l2160;
  if (!yy_MetaDataValue(G))  goto l2160;
  yyDo(G, yySet, -1, 0, "yySet");
  yyDo(G, yy_1_MetaDataKeyValue, G->begin, G->end, "yy_1_MetaDataKeyValue");
  yyprintf((stderr, "  ok   MetaDataKeyValue"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));
  yyDo(G, yyPop, 2, 0, "yyPop");
  return 1;
  l2160:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "MetaDataKeyValue"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_SetextHeading(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "SetextHeading"));

  {  int yypos2162= G->pos, yythunkpos2162= G->thunkpos;  if (!yy_SetextHeading1(G))  goto l2163;
  goto l2162;
  l2163:;	  G->pos= yypos2162; G->thunkpos= yythunkpos2162;  if (!yy_SetextHeading2(G))  goto l2161;

  }
  l2162:;	  yyprintf((stderr, "  ok   SetextHeading"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l2161:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "SetextHeading"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_BlankLine(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "BlankLine"));
  if (!yy_Sp(G))  goto l2164;
  if (!yy_Newline(G))  goto l2164;
  yyprintf((stderr, "  ok   BlankLine"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l2164:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "BlankLine"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_Block(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "Block"));

  l2166:;	
  {  int yypos2167= G->pos, yythunkpos2167= G->thunkpos;  if (!yy_BlankLine(G))  goto l2167;
  goto l2166;
  l2167:;	  G->pos= yypos2167; G->thunkpos= yythunkpos2167;
  }
  {  int yypos2168= G->pos, yythunkpos2168= G->thunkpos;  if (!yy_BlockQuote(G))  goto l2169;
  goto l2168;
  l2169:;	  G->pos= yypos2168; G->thunkpos= yythunkpos2168;  if (!yy_Verbatim(G))  goto l2170;
  goto l2168;
  l2170:;	  G->pos= yypos2168; G->thunkpos= yythunkpos2168;  yyText(G, G->begin, G->end);  if (!( !ext(EXT_COMPATIBILITY) )) goto l2171;  if (!yy_DefinitionList(G))  goto l2171;
  goto l2168;
  l2171:;	  G->pos= yypos2168; G->thunkpos= yythunkpos2168;  yyText(G, G->begin, G->end);  if (!( !ext(EXT_COMPATIBILITY) )) goto l2172;  if (!yy_Glossary(G))  goto l2172;
  goto l2168;
  l2172:;	  G->pos= yypos2168; G->thunkpos= yythunkpos2168;  if (!yy_Note(G))  goto l2173;
  goto l2168;
  l2173:;	  G->pos= yypos2168; G->thunkpos= yythunkpos2168;  if (!yy_LinkReference(G))  goto l2174;
  goto l2168;
  l2174:;	  G->pos= yypos2168; G->thunkpos= yythunkpos2168;  if (!yy_HorizontalRule(G))  goto l2175;
  goto l2168;
  l2175:;	  G->pos= yypos2168; G->thunkpos= yythunkpos2168;  if (!yy_HeadingSection(G))  goto l2176;
  goto l2168;
  l2176:;	  G->pos= yypos2168; G->thunkpos= yythunkpos2168;  if (!yy_OrderedList(G))  goto l2177;
  goto l2168;
  l2177:;	  G->pos= yypos2168; G->thunkpos= yythunkpos2168;  if (!yy_BulletList(G))  goto l2178;
  goto l2168;
  l2178:;	  G->pos= yypos2168; G->thunkpos= yythunkpos2168;  if (!yy_HtmlBlock(G))  goto l2179;
  goto l2168;
  l2179:;	  G->pos= yypos2168; G->thunkpos= yythunkpos2168;  if (!yy_MarkdownHtmlBlock(G))  goto l2180;
  goto l2168;
  l2180:;	  G->pos= yypos2168; G->thunkpos= yythunkpos2168;  if (!yy_StyleBlock(G))  goto l2181;
  goto l2168;
  l2181:;	  G->pos= yypos2168; G->thunkpos= yythunkpos2168;  yyText(G, G->begin, G->end);  if (!( !ext(EXT_COMPATIBILITY) )) goto l2182;  if (!yy_Table(G))  goto l2182;
  goto l2168;
  l2182:;	  G->pos= yypos2168; G->thunkpos= yythunkpos2168;  yyText(G, G->begin, G->end);  if (!( !ext(EXT_COMPATIBILITY) )) goto l2183;  if (!yy_ImageBlock(G))  goto l2183;
  goto l2168;
  l2183:;	  G->pos= yypos2168; G->thunkpos= yythunkpos2168;
  {  int yypos2185= G->pos, yythunkpos2185= G->thunkpos;
  {  int yypos2186= G->pos, yythunkpos2186= G->thunkpos;  if (!yy_Sp(G))  goto l2186;
  goto l2187;
  l2186:;	  G->pos= yypos2186; G->thunkpos= yythunkpos2186;
  }
  l2187:;	  if (!yy_HtmlBlockInTags(G))  goto l2185;
  goto l2184;
  l2185:;	  G->pos= yypos2185; G->thunkpos= yythunkpos2185;
  }  if (!yy_Para(G))  goto l2184;
  goto l2168;
  l2184:;	  G->pos= yypos2168; G->thunkpos= yythunkpos2168;  if (!yy_Plain(G))  goto l2165;

  }
  l2168:;	  yyprintf((stderr, "  ok   Block"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l2165:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "Block"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_MetaData(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyDo(G, yyPush, 1, 0, "yyPush");
  yyprintfv((stderr, "%s\n", "MetaData"));
  if (!yy_StartList(G))  goto l2188;
  yyDo(G, yySet, -1, 0, "yySet");

  {  int yypos2189= G->pos, yythunkpos2189= G->thunkpos;  if (!yymatchClass(G, (unsigned char *)"\000\000\000\000\000\000\000\000\376\377\377\007\376\377\377\007\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000", "A-Za-z")) goto l2189;

  l2190:;	
  {  int yypos2191= G->pos, yythunkpos2191= G->thunkpos;  if (!yymatchClass(G, (unsigned char *)"\000\000\000\000\000\000\000\000\376\377\377\007\376\377\377\007\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000", "A-Za-z")) goto l2191;
  goto l2190;
  l2191:;	  G->pos= yypos2191; G->thunkpos= yythunkpos2191;
  }  if (!yymatchString(G, "://")) goto l2189;
  goto l2188;
  l2189:;	  G->pos= yypos2189; G->thunkpos= yythunkpos2189;
  }
  {  int yypos2192= G->pos, yythunkpos2192= G->thunkpos;  if (!yy_SetextHeading(G))  goto l2192;
  goto l2188;
  l2192:;	  G->pos= yypos2192; G->thunkpos= yythunkpos2192;
  }  if (!yy_MetaDataKeyValue(G))  goto l2188;
  yyDo(G, yy_1_MetaData, G->begin, G->end, "yy_1_MetaData");

  l2193:;	
  {  int yypos2194= G->pos, yythunkpos2194= G->thunkpos;  if (!yy_MetaDataKeyValue(G))  goto l2194;
  yyDo(G, yy_1_MetaData, G->begin, G->end, "yy_1_MetaData");
  goto l2193;
  l2194:;	  G->pos= yypos2194; G->thunkpos= yythunkpos2194;
  }  yyDo(G, yy_2_MetaData, G->begin, G->end, "yy_2_MetaData");
  yyprintf((stderr, "  ok   MetaData"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));
  yyDo(G, yyPop, 1, 0, "yyPop");
  return 1;
  l2188:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "MetaData"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_Newline(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "Newline"));

  {  int yypos2196= G->pos, yythunkpos2196= G->thunkpos;  if (!yymatchChar(G, '\n')) goto l2197;
  goto l2196;
  l2197:;	  G->pos= yypos2196; G->thunkpos= yythunkpos2196;  if (!yymatchChar(G, '\r')) goto l2195;

  {  int yypos2198= G->pos, yythunkpos2198= G->thunkpos;  if (!yymatchChar(G, '\n')) goto l2198;
  goto l2199;
  l2198:;	  G->pos= yypos2198; G->thunkpos= yythunkpos2198;
  }
  l2199:;	
  }
  l2196:;	  yyprintf((stderr, "  ok   Newline"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l2195:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "Newline"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_Sp(GREG *G)
{  yyprintfv((stderr, "%s\n", "Sp"));

  l2201:;	
  {  int yypos2202= G->pos, yythunkpos2202= G->thunkpos;  if (!yy_Spacechar(G))  goto l2202;
  goto l2201;
  l2202:;	  G->pos= yypos2202; G->thunkpos= yythunkpos2202;
  }  yyprintf((stderr, "  ok   Sp"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
}
YY_RULE(int) yy_MetaDataKey(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "MetaDataKey"));
  yyText(G, G->begin, G->end);  if (!(YY_BEGIN)) goto l2203;
  {  int yypos2204= G->pos, yythunkpos2204= G->thunkpos;  if (!yymatchClass(G, (unsigned char *)"\000\000\000\000\000\000\000\000\376\377\377\007\376\377\377\007\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000", "A-Za-z")) goto l2204;

  l2205:;	
  {  int yypos2206= G->pos, yythunkpos2206= G->thunkpos;  if (!yymatchClass(G, (unsigned char *)"\000\000\000\000\000\000\000\000\376\377\377\007\376\377\377\007\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000", "A-Za-z")) goto l2206;
  goto l2205;
  l2206:;	  G->pos= yypos2206; G->thunkpos= yythunkpos2206;
  }  if (!yymatchString(G, "://")) goto l2204;
  goto l2203;
  l2204:;	  G->pos= yypos2204; G->thunkpos= yythunkpos2204;
  }  if (!yy_AlphanumericAscii(G))  goto l2203;

  l2207:;	
  {  int yypos2208= G->pos, yythunkpos2208= G->thunkpos;  if (!yy_Sp(G))  goto l2208;

  {  int yypos2211= G->pos, yythunkpos2211= G->thunkpos;  if (!yy_AlphanumericAscii(G))  goto l2212;
  goto l2211;
  l2212:;	  G->pos= yypos2211; G->thunkpos= yythunkpos2211;  if (!yymatchChar(G, '_')) goto l2213;
  goto l2211;
  l2213:;	  G->pos= yypos2211; G->thunkpos= yythunkpos2211;  if (!yymatchChar(G, ' ')) goto l2214;
  goto l2211;
  l2214:;	  G->pos= yypos2211; G->thunkpos= yythunkpos2211;  if (!yymatchChar(G, '-')) goto l2215;
  goto l2211;
  l2215:;	  G->pos= yypos2211; G->thunkpos= yythunkpos2211;  if (!yymatchChar(G, '.')) goto l2208;

  }
  l2211:;	
  l2209:;	
  {  int yypos2210= G->pos, yythunkpos2210= G->thunkpos;
  {  int yypos2216= G->pos, yythunkpos2216= G->thunkpos;  if (!yy_AlphanumericAscii(G))  goto l2217;
  goto l2216;
  l2217:;	  G->pos= yypos2216; G->thunkpos= yythunkpos2216;  if (!yymatchChar(G, '_')) goto l2218;
  goto l2216;
  l2218:;	  G->pos= yypos2216; G->thunkpos= yythunkpos2216;  if (!yymatchChar(G, ' ')) goto l2219;
  goto l2216;
  l2219:;	  G->pos= yypos2216; G->thunkpos= yythunkpos2216;  if (!yymatchChar(G, '-')) goto l2220;
  goto l2216;
  l2220:;	  G->pos= yypos2216; G->thunkpos= yythunkpos2216;  if (!yymatchChar(G, '.')) goto l2210;

  }
  l2216:;	  goto l2209;
  l2210:;	  G->pos= yypos2210; G->thunkpos= yythunkpos2210;
  }  goto l2207;
  l2208:;	  G->pos= yypos2208; G->thunkpos= yythunkpos2208;
  }  yyText(G, G->begin, G->end);  if (!(YY_END)) goto l2203;  yyDo(G, yy_1_MetaDataKey, G->begin, G->end, "yy_1_MetaDataKey");
  yyprintf((stderr, "  ok   MetaDataKey"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l2203:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "MetaDataKey"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_StartList(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "StartList"));

  {  int yypos2222= G->pos, yythunkpos2222= G->thunkpos;  if (!yymatchDot(G)) goto l2221;  G->pos= yypos2222; G->thunkpos= yythunkpos2222;
  }  yyDo(G, yy_1_StartList, G->begin, G->end, "yy_1_StartList");
  yyprintf((stderr, "  ok   StartList"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l2221:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "StartList"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_BOM(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyprintfv((stderr, "%s\n", "BOM"));
  if (!yymatchString(G, "\357\273\277")) goto l2223;
  yyprintf((stderr, "  ok   BOM"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));

  return 1;
  l2223:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "BOM"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}
YY_RULE(int) yy_Doc(GREG *G)
{  int yypos0= G->pos, yythunkpos0= G->thunkpos;  yyDo(G, yyPush, 2, 0, "yyPush");
  yyprintfv((stderr, "%s\n", "Doc"));

  {  int yypos2225= G->pos, yythunkpos2225= G->thunkpos;  if (!yy_BOM(G))  goto l2225;
  goto l2226;
  l2225:;	  G->pos= yypos2225; G->thunkpos= yythunkpos2225;
  }
  l2226:;	  if (!yy_StartList(G))  goto l2224;
  yyDo(G, yySet, -2, 0, "yySet");
  if (!yy_StartList(G))  goto l2224;
  yyDo(G, yySet, -1, 0, "yySet");

  {  int yypos2227= G->pos, yythunkpos2227= G->thunkpos;  yyText(G, G->begin, G->end);  if (!( !ext(EXT_COMPATIBILITY) && !ext(EXT_NO_METADATA) )) goto l2227;
  {  int yypos2229= G->pos, yythunkpos2229= G->thunkpos;  if (!yy_MetaDataKey(G))  goto l2227;
  if (!yy_Sp(G))  goto l2227;
  if (!yymatchChar(G, ':')) goto l2227;
  if (!yy_Sp(G))  goto l2227;

  {  int yypos2230= G->pos, yythunkpos2230= G->thunkpos;  if (!yy_Newline(G))  goto l2230;
  goto l2227;
  l2230:;	  G->pos= yypos2230; G->thunkpos= yythunkpos2230;
  }  G->pos= yypos2229; G->thunkpos= yythunkpos2229;
  }  if (!yy_MetaData(G))  goto l2227;
  yyDo(G, yy_1_Doc, G->begin, G->end, "yy_1_Doc");
  goto l2228;
  l2227:;	  G->pos= yypos2227; G->thunkpos= yythunkpos2227;
  }
  l2228:;	
  l2231:;	
  {  int yypos2232= G->pos, yythunkpos2232= G->thunkpos;  if (!yy_Block(G))  goto l2232;
  yyDo(G, yy_2_Doc, G->begin, G->end, "yy_2_Doc");
  goto l2231;
  l2232:;	  G->pos= yypos2232; G->thunkpos= yythunkpos2232;
  }
  l2233:;	
  {  int yypos2234= G->pos, yythunkpos2234= G->thunkpos;  if (!yy_BlankLine(G))  goto l2234;
  goto l2233;
  l2234:;	  G->pos= yypos2234; G->thunkpos= yythunkpos2234;
  }  yyDo(G, yy_3_Doc, G->begin, G->end, "yy_3_Doc");
  yyprintf((stderr, "  ok   Doc"));
  yyprintfGcontext;
  yyprintf((stderr, "\n"));
  yyDo(G, yyPop, 2, 0, "yyPop");
  return 1;
  l2224:;	  G->pos= yypos0; G->thunkpos= yythunkpos0;  yyprintfv((stderr, "  fail %s", "Doc"));
  yyprintfvGcontext;
  yyprintfv((stderr, "\n"));

  return 0;
}

#ifndef YY_PART

typedef int (*yyrule)(GREG *G);

YY_PARSE(int) YY_NAME(parse_from)(GREG *G, yyrule yystart)
{
  int yyok;
  if (!G->buflen)
    {
      G->buflen= YY_BUFFER_START_SIZE;
      G->buf= (char*)YY_ALLOC(G->buflen, G->data);
      G->textlen= YY_BUFFER_START_SIZE;
      G->text= (char*)YY_ALLOC(G->textlen, G->data);
      G->thunkslen= YY_STACK_SIZE;
      G->thunks= (yythunk*)YY_ALLOC(sizeof(yythunk) * G->thunkslen, G->data);
      G->valslen= YY_STACK_SIZE;
      G->vals= (YYSTYPE*)YY_ALLOC(sizeof(YYSTYPE) * G->valslen, G->data);
      G->begin= G->end= G->pos= G->limit= G->thunkpos= 0;
    }
  G->pos = 0;
  G->begin= G->end= G->pos;
  G->thunkpos= 0;
  G->val= G->vals;
  yyok= yystart(G);
  if (yyok) yyDone(G);
  yyCommit(G);
  return yyok;
  (void)yyrefill;
  (void)yymatchDot;
  (void)yymatchChar;
  (void)yymatchString;
  (void)yymatchClass;
  (void)yyDo;
  (void)yyText;
  (void)yyDone;
  (void)yyCommit;
  (void)yyAccept;
  (void)yyPush;
  (void)yyPop;
  (void)yySet;
}

YY_PARSE(int) YY_NAME(parse)(GREG *G)
{
  return YY_NAME(parse_from)(G, yy_Doc);
}

YY_PARSE(void) YY_NAME(init)(GREG *G)
{
    memset(G, 0, sizeof(GREG));
}
YY_PARSE(void) YY_NAME(deinit)(GREG *G)
{
    if (G->buf) YY_FREE(G->buf);
    if (G->text) YY_FREE(G->text);
    if (G->thunks) YY_FREE(G->thunks);
    if (G->vals) YY_FREE((void*)G->vals);
}
YY_PARSE(GREG *) YY_NAME(parse_new)(YY_XTYPE data)
{
  GREG *G = (GREG *)YY_CALLOC(1, sizeof(GREG), G->data);
  G->data = data;
  return G;
}

YY_PARSE(void) YY_NAME(parse_free)(GREG *G)
{
  YY_NAME(deinit)(G);
  YY_FREE(G);
}

#endif


/* process_raw_blocks -- follow the tree and process any RAW nodes and insert them
	into the tree */
node * process_raw_blocks(node * n, int extensions) {
	/* from the parser data we get the parent node and pointer to reference list */
	node *current = NULL;
	node *last_child = NULL;
	char *contents;
	GREG g;

	current = n;
	
	while (current != NULL) {
		if (current->key == RAW) {
			/* Process this RAW block */
			
			yyinit(&g);
			contents = strtok(current->str, "\001");
			current->key = LIST;
			g.data = mk_parser_data(contents, (extensions | EXT_NO_METADATA ));
			
			while (yyparse(&g));
			
			current->children = ((parser_data *)g.data)->result;
			
			free((parser_data *)g.data);	/* we're not using free_parser_data to preserve result tree */
			
			yydeinit(&g);
			
			last_child = current->children;
			while ((contents = strtok(NULL, "\001"))) {
				while (last_child->next != NULL) 
					last_child = last_child->next;
					
					yyinit(&g);
					g.data = mk_parser_data(contents, (extensions | EXT_NO_METADATA ));
					while (yyparse(&g));
					last_child->next = ((parser_data *)g.data)->result;
					free((parser_data *)g.data);
					yydeinit(&g);
			}
			free(current->str);
			current->str = NULL;
		}
		if (current->children != NULL) {
			/* Recurse into children */
			current->children = process_raw_blocks(current->children, extensions);
		}
		current = current->next;
	}
	return n;
}

char * markdown_to_string(char * source, int extensions, int format) {
	char *out;
	char *formatted;
	char *critic_resolved;
	node *refined;
	GREG g;               /* create parser context */
	yyinit(&g);

	/* Resolve Critic Markup before parsing */
	if ((extensions & EXT_CRITIC_ACCEPT) || (extensions & EXT_CRITIC_REJECT)) {
		g.data = mk_parser_data(source, extensions);

		while (yyparse_from(&g, yy_DocForCritic));
		
		if (extensions & EXT_CRITIC_REJECT) {
			if ((extensions & EXT_CRITIC_ACCEPT) && (format == HTML_FORMAT))
				critic_resolved = export_node_tree(((parser_data *)g.data)->result, CRITIC_HTML_HIGHLIGHT_FORMAT, extensions);
			else
				critic_resolved = export_node_tree(((parser_data *)g.data)->result, CRITIC_REJECT_FORMAT, extensions);
		} else {
			critic_resolved = export_node_tree(((parser_data *)g.data)->result, CRITIC_ACCEPT_FORMAT , extensions);
		}
		
		free_parser_data((parser_data *)g.data);
		yydeinit(&g);
		yyinit(&g);

		formatted = preformat_text(critic_resolved);
		free(critic_resolved);
	} else {
		formatted = preformat_text(source);
	}
	
	g.data = mk_parser_data(formatted,extensions);
	
	if (format == OPML_FORMAT) {
		while (yyparse_from(&g, yy_DocForOPML));	/* We want simpler version */
	} else {
		while (yyparse(&g));       /* parse */
	}

	if (((parser_data *)g.data)->parse_aborted) {
		/* clean up */
		free_parser_data((parser_data *)g.data);
		yydeinit(&g);
		
		free(formatted);
		
		out = strdup("MultiMarkdown was unable to parse this file.");
		return out;
	}

	refined = process_raw_blocks(((parser_data *)g.data)->result, extensions);    /* iteratively parse RAW bits */

	/* move autolabels to main parse tree */
	if (((parser_data *)g.data)->autolabels != NULL) {
//		fprintf(stderr, "We have autolabels\n");
		append_list(((parser_data *)g.data)->autolabels,refined);
		((parser_data *)g.data)->autolabels = NULL;	
	} else {
//		fprintf(stderr, "No autolabels\n");
	}
	
	/* Show what we got */
	out = export_node_tree(refined, format, extensions);
	
	/* clean up */
	free_parser_data((parser_data *)g.data);
	yydeinit(&g);
	
	free(formatted);
	return out;
}

/* has_metadata -- determine whether metadata exists or not */
bool has_metadata(char *source, int extensions) {
    char *formatted;
    GREG g;
    yyinit(&g);
    node *result;
    bool answer = FALSE;
    
    formatted = preformat_text(source);
    g.data = mk_parser_data(formatted, extensions);
    
    /* TODO: change this to parse only the metadata for speed */
    while (yyparse(&g));

    result = ((parser_data *)g.data)->result;

    if ((result != NULL) && (result->key == METADATA)) {
		answer = TRUE;
    }

	free_parser_data((parser_data *)g.data);
	yydeinit(&g);
	
	free(formatted);
	return answer;
}

/* extract_metadata_value -- find the value and return it */
char * extract_metadata_value(char *source, int extensions, char *key) {
	char *out;
	char *formatted;
	GREG g;
	yyinit(&g);
	
	/* don't preformat if doing syntax highlighting */
	formatted = preformat_text(source);
	g.data = mk_parser_data(formatted,extensions);
	
	while (yyparse(&g));       /* parse */

	if (((parser_data *)g.data)->parse_aborted) {
		out = strdup("MultiMarkdown was unable to parse this file.");
	} else {
		out = metavalue_for_key(key,((parser_data *)g.data)->result);
	}
	
	
	free_parser_data((parser_data *)g.data);
	yydeinit(&g);
	
	free(formatted);
	return out;
}


