# Generated by default/object.tt
package Paws::Honeycode::FailedBatchItem;
  use Moose;
  has ErrorMessage => (is => 'ro', isa => 'Str', request_name => 'errorMessage', traits => ['NameInRequest'], required => 1);
  has Id => (is => 'ro', isa => 'Str', request_name => 'id', traits => ['NameInRequest'], required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::Honeycode::FailedBatchItem

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Honeycode::FailedBatchItem object:

  $service_obj->Method(Att1 => { ErrorMessage => $value, ..., Id => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Honeycode::FailedBatchItem object:

  $result = $service_obj->Method(...);
  $result->Att1->ErrorMessage

=head1 DESCRIPTION

A single item in a batch that failed to perform the intended action
because of an error preventing it from succeeding.

=head1 ATTRIBUTES


=head2 B<REQUIRED> ErrorMessage => Str

The error message that indicates why the batch item failed.


=head2 B<REQUIRED> Id => Str

The id of the batch item that failed. This is the batch item id for the
BatchCreateTableRows and BatchUpsertTableRows operations and the row id
for the BatchUpdateTableRows and BatchDeleteTableRows operations.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Honeycode>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

