# Generated by default/object.tt
package Paws::IoTSiteWise::AssetRelationshipSummary;
  use Moose;
  has HierarchyInfo => (is => 'ro', isa => 'Paws::IoTSiteWise::AssetHierarchyInfo', request_name => 'hierarchyInfo', traits => ['NameInRequest']);
  has RelationshipType => (is => 'ro', isa => 'Str', request_name => 'relationshipType', traits => ['NameInRequest'], required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::IoTSiteWise::AssetRelationshipSummary

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::IoTSiteWise::AssetRelationshipSummary object:

  $service_obj->Method(Att1 => { HierarchyInfo => $value, ..., RelationshipType => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::IoTSiteWise::AssetRelationshipSummary object:

  $result = $service_obj->Method(...);
  $result->Att1->HierarchyInfo

=head1 DESCRIPTION

Contains information about assets that are related to one another.

=head1 ATTRIBUTES


=head2 HierarchyInfo => L<Paws::IoTSiteWise::AssetHierarchyInfo>

The assets that are related through an asset hierarchy.

This object is present if the C<relationshipType> is C<HIERARCHY>.


=head2 B<REQUIRED> RelationshipType => Str

The relationship type of the assets in this relationship. This value is
one of the following:

=over

=item *

C<HIERARCHY> E<ndash> The assets are related through an asset
hierarchy. If you specify this relationship type, this asset
relationship includes the C<hierarchyInfo> object.

=back




=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::IoTSiteWise>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

