# Generated by default/object.tt
package Paws::Macie2::SearchResourcesSimpleCriterion;
  use Moose;
  has Comparator => (is => 'ro', isa => 'Str', request_name => 'comparator', traits => ['NameInRequest']);
  has Key => (is => 'ro', isa => 'Str', request_name => 'key', traits => ['NameInRequest']);
  has Values => (is => 'ro', isa => 'ArrayRef[Str|Undef]', request_name => 'values', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::Macie2::SearchResourcesSimpleCriterion

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Macie2::SearchResourcesSimpleCriterion object:

  $service_obj->Method(Att1 => { Comparator => $value, ..., Values => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Macie2::SearchResourcesSimpleCriterion object:

  $result = $service_obj->Method(...);
  $result->Att1->Comparator

=head1 DESCRIPTION

Specifies a property-based filter condition that determines which
Amazon Web Services resources are included or excluded from the query
results.

=head1 ATTRIBUTES


=head2 Comparator => Str

The operator to use in the condition. Valid values are EQ (equals) and
NE (not equals).


=head2 Key => Str

The property to use in the condition.


=head2 Values => ArrayRef[Str|Undef]

An array that lists one or more values to use in the condition. If you
specify multiple values, Amazon Macie uses OR logic to join the values.
Valid values for each supported property (key) are:

=over

=item *

ACCOUNT_ID - A string that represents the unique identifier for the
Amazon Web Services account that owns the resource.

=item *

S3_BUCKET_EFFECTIVE_PERMISSION - A string that represents an enumerated
value that Macie defines for the BucketPublicAccess.effectivePermission
(https://docs.aws.amazon.com/macie/latest/APIReference/datasources-s3.html#datasources-s3-prop-bucketpublicaccess-effectivepermission)
property of an S3 bucket.

=item *

S3_BUCKET_NAME - A string that represents the name of an S3 bucket.

=item *

S3_BUCKET_SHARED_ACCESS - A string that represents an enumerated value
that Macie defines for the BucketMetadata.sharedAccess
(https://docs.aws.amazon.com/macie/latest/APIReference/datasources-s3.html#datasources-s3-prop-bucketmetadata-sharedaccess)
property of an S3 bucket.

=back

Values are case sensitive. Also, Macie doesn't support use of partial
values or wildcard characters in values.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Macie2>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

