/*
 * Decompiled with CFR 0.152.
 */
package opennlp.grok.lexicon;

import java.net.URL;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import opennlp.common.parse.LexException;
import opennlp.common.synsem.Category;
import opennlp.common.synsem.CategoryFcn;
import opennlp.common.synsem.LF;
import opennlp.common.unify.ModFcn;
import opennlp.common.unify.Mutable;
import opennlp.common.unify.UnifyFailure;
import opennlp.common.util.Pair;
import opennlp.grok.datarep.DataItem;
import opennlp.grok.datarep.DataModel;
import opennlp.grok.datarep.EntriesItem;
import opennlp.grok.datarep.EntriesModel;
import opennlp.grok.datarep.Family;
import opennlp.grok.datarep.LexiconModel;
import opennlp.grok.datarep.MacroItem;
import opennlp.grok.datarep.MacroModel;
import opennlp.grok.datarep.MorphItem;
import opennlp.grok.datarep.MorphModel;
import opennlp.grok.expression.CatReader;
import opennlp.grok.expression.GSign;
import opennlp.grok.expression.SignHash;
import opennlp.grok.io.LexiconReader;
import opennlp.grok.io.MacroReader;
import opennlp.grok.io.MorphReader;
import opennlp.grok.lexicon.LexiconAdapter;
import opennlp.grok.lexicon.MorphData;
import opennlp.grok.lexicon.XtagMorphData;
import opennlp.grok.util.Debug;
import opennlp.grok.util.GroupMap;
import opennlp.hylo.Proposition;

public class LMRLexicon
extends LexiconAdapter {
    private CategoryFcn semanticDefaultReplacer;
    MorphData _morphServer;
    HashMap _closed = new HashMap();
    GroupMap _words;
    GroupMap _stems;
    GroupMap _macros;
    GroupMap _defaultMacros;
    GroupMap _posToEntries;
    private String REPLACEMENT = "";
    private ModFcn defaultReplacer = new ModFcn(){

        public void modify(Mutable m) {
            if (m instanceof Proposition && ((Proposition)m).toString().equals("[*DEFAULT*]")) {
                ((Proposition)m).setAtomName(LMRLexicon.this.REPLACEMENT);
            }
        }
    };
    private static HashMap catIndices;
    private static HashMap featIndices;
    private static boolean indexedFeaturesSuccess;
    private static ModFcn addIndexedFeatures;

    public LMRLexicon(Properties g) {
        super(g);
        LexiconModel lexicon = null;
        MacroModel macroModel = null;
        MorphModel morph = null;
        try {
            lexicon = LexiconReader.getLexicon(new URL(g.getProperty("lexicon")).openStream());
        }
        catch (Exception e) {
            System.out.println("Unable to load lexicon.");
            System.out.println(e);
        }
        try {
            macroModel = MacroReader.getMacro(new URL(g.getProperty("morphology")).openStream());
        }
        catch (Exception e) {
            System.out.println("Unable to load macros.");
            System.out.println(e);
        }
        try {
            morph = MorphReader.getMorph(new URL(g.getProperty("morphology")).openStream());
        }
        catch (Exception e) {
            System.out.println("Unable to load morphology.");
            System.out.println(e);
        }
        this._words = new GroupMap();
        Iterator I = ((AbstractList)morph).iterator();
        while (I.hasNext()) {
            MorphItem mi = (MorphItem)I.next();
            this._words.put(mi.getWord(), mi);
        }
        this._stems = new GroupMap();
        this._posToEntries = new GroupMap();
        HashSet pHeads = new HashSet();
        Iterator L = ((AbstractList)lexicon).iterator();
        while (L.hasNext()) {
            Family family = (Family)L.next();
            EntriesModel entries = family.getEntries();
            DataModel data = family.getData();
            this._posToEntries.put(family.getPOS(), entries);
            Iterator E = ((AbstractList)entries).iterator();
            while (E.hasNext()) {
                EntriesItem eItem = (EntriesItem)E.next();
                this._closed.put(eItem, family.getClosed());
                if (eItem.getStem().equals("")) continue;
                this._stems.put(eItem.getStem() + family.getPOS(), eItem);
            }
            Iterator D = ((AbstractList)data).iterator();
            while (D.hasNext()) {
                DataItem dItem = (DataItem)D.next();
                this._stems.put(dItem.getStem() + family.getPOS(), new Pair((Object)dItem, (Object)entries));
            }
        }
        this._macros = new GroupMap();
        this._defaultMacros = new GroupMap();
        Iterator M = ((AbstractList)macroModel).iterator();
        while (M.hasNext()) {
            MacroItem mi = (MacroItem)M.next();
            ArrayList specs = mi.getSpecs();
            Iterator S = specs.iterator();
            while (S.hasNext()) {
                this.putMacro(mi.getName().startsWith("%") ? this._defaultMacros : this._macros, mi.getName(), (String)S.next());
            }
        }
        this._morphServer = new XtagMorphData(g);
    }

    public MorphData getMorphData() {
        return this._morphServer;
    }

    public Collection getWord(String w) throws LexException {
        Collection morphItems = (Collection)this._words.get(w);
        Collection morphsFromDB = null;
        if (this._morphServer != null) {
            morphsFromDB = this._morphServer.getMorphItems(w);
        }
        if (morphItems == null && morphsFromDB == null) {
            throw new LexException(w + " not in lexicon");
        }
        if (morphItems == null) {
            morphItems = morphsFromDB;
        } else if (morphsFromDB != null) {
            morphItems.addAll(morphsFromDB);
        }
        if (Debug.On("Lexicon")) {
            this.show(morphItems, w);
        }
        SignHash result = new SignHash();
        Iterator MI = morphItems.iterator();
        while (MI.hasNext()) {
            this.getWithMorphItem(w, (MorphItem)MI.next(), result);
        }
        if (Debug.On("Lexicon")) {
            System.out.println(result.values());
        }
        return result.values();
    }

    private void getWithMorphItem(String w, MorphItem mi, SignHash result) {
        HashSet defMacros = new HashSet();
        HashSet macros = new HashSet();
        List newMacros = mi.getMacros();
        if (newMacros != null) {
            macros.addAll(newMacros);
        }
        String stem = mi.getStem();
        String pos = mi.getPOS();
        if (this._stems.containsKey(stem + pos)) {
            Collection stemItems = (Collection)this._stems.get(stem + pos);
            Iterator I = stemItems.iterator();
            while (I.hasNext()) {
                Object item = I.next();
                if (item instanceof EntriesItem) {
                    this.getWithEntriesItem(w, w, (EntriesItem)item, (HashSet)macros.clone(), defMacros, null, result);
                    continue;
                }
                this.getWithDataItem(w, (DataItem)((Pair)item).a, (EntriesModel)((Pair)item).b, (HashSet)macros.clone(), defMacros, result);
            }
        } else {
            Collection entrySets = (Collection)this._posToEntries.get(pos);
            DataItem di = new DataItem();
            di.setStem(stem);
            di.setPred(stem);
            Iterator E = entrySets.iterator();
            while (E.hasNext()) {
                this.getWithDataItem(w, di, (EntriesModel)E.next(), (HashSet)macros.clone(), defMacros, result);
            }
        }
    }

    private void getWithDataItem(String w, DataItem item, EntriesModel entries, HashSet macros, HashSet defaultMacros, SignHash result) {
        macros.addAll(item.getFeat());
        Iterator I = ((AbstractList)entries).iterator();
        while (I.hasNext()) {
            EntriesItem ei = (EntriesItem)I.next();
            if (!ei.getStem().equals("[*DEFAULT*]")) continue;
            this.getWithEntriesItem(w, item.getStem(), ei, macros, defaultMacros, item.getLF(), result);
        }
    }

    private void getWithEntriesItem(String w, String stem, EntriesItem item, HashSet macros, HashSet defaultMacros, LF lf, SignHash result) {
        if (!item.getActive().booleanValue()) {
            return;
        }
        Category cat = item.getCat().copy();
        this.REPLACEMENT = stem;
        cat.deepMap(this.defaultReplacer);
        if (lf != null) {
            CatReader.mergeLF(cat, lf);
        }
        result.insert(new GSign(w, cat));
    }

    private void putMacro(GroupMap map, String name, String val) {
    }

    private Category addIndexedFeatures(HashMap catI, HashMap featI, Category c) throws UnifyFailure {
        catIndices = catI;
        featIndices = featI;
        indexedFeaturesSuccess = true;
        Category ans = c.copy();
        ans.deepMap(addIndexedFeatures);
        catIndices = null;
        featIndices = null;
        if (!indexedFeaturesSuccess) {
            throw new UnifyFailure();
        }
        return ans;
    }

    private Category addMacros(Category cat, HashSet macroSet, HashSet defaultMacros) throws UnifyFailure {
        HashMap catIndices = new HashMap();
        HashMap featIndices = new HashMap();
        return this.addIndexedFeatures(catIndices, featIndices, cat);
    }

    private void show(Collection c, String w) {
        if (c == null) {
            return;
        }
        StringBuffer foo = new StringBuffer(w).append(": ");
        Iterator i = c.iterator();
        while (i.hasNext()) {
            foo.append(i.next().toString()).append(" || ");
        }
        System.out.println(foo.toString());
    }

    static {
        Debug.Register("Lexicon", false);
        indexedFeaturesSuccess = true;
        addIndexedFeatures = new ModFcn(){

            public void modify(Mutable c) {
            }
        };
    }
}

