﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/DateTime.h>
#include <aws/core/utils/memory/stl/AWSMap.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/servicecatalog-appregistry/AppRegistry_EXPORTS.h>
#include <aws/servicecatalog-appregistry/model/Integrations.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace AppRegistry {
namespace Model {
class GetApplicationResult {
 public:
  AWS_APPREGISTRY_API GetApplicationResult() = default;
  AWS_APPREGISTRY_API GetApplicationResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_APPREGISTRY_API GetApplicationResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>The identifier of the application.</p>
   */
  inline const Aws::String& GetId() const { return m_id; }
  template <typename IdT = Aws::String>
  void SetId(IdT&& value) {
    m_idHasBeenSet = true;
    m_id = std::forward<IdT>(value);
  }
  template <typename IdT = Aws::String>
  GetApplicationResult& WithId(IdT&& value) {
    SetId(std::forward<IdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The Amazon resource name (ARN) that specifies the application across
   * services.</p>
   */
  inline const Aws::String& GetArn() const { return m_arn; }
  template <typename ArnT = Aws::String>
  void SetArn(ArnT&& value) {
    m_arnHasBeenSet = true;
    m_arn = std::forward<ArnT>(value);
  }
  template <typename ArnT = Aws::String>
  GetApplicationResult& WithArn(ArnT&& value) {
    SetArn(std::forward<ArnT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The name of the application. The name must be unique in the region in which
   * you are creating the application.</p>
   */
  inline const Aws::String& GetName() const { return m_name; }
  template <typename NameT = Aws::String>
  void SetName(NameT&& value) {
    m_nameHasBeenSet = true;
    m_name = std::forward<NameT>(value);
  }
  template <typename NameT = Aws::String>
  GetApplicationResult& WithName(NameT&& value) {
    SetName(std::forward<NameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The description of the application.</p>
   */
  inline const Aws::String& GetDescription() const { return m_description; }
  template <typename DescriptionT = Aws::String>
  void SetDescription(DescriptionT&& value) {
    m_descriptionHasBeenSet = true;
    m_description = std::forward<DescriptionT>(value);
  }
  template <typename DescriptionT = Aws::String>
  GetApplicationResult& WithDescription(DescriptionT&& value) {
    SetDescription(std::forward<DescriptionT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The ISO-8601 formatted timestamp of the moment when the application was
   * created.</p>
   */
  inline const Aws::Utils::DateTime& GetCreationTime() const { return m_creationTime; }
  template <typename CreationTimeT = Aws::Utils::DateTime>
  void SetCreationTime(CreationTimeT&& value) {
    m_creationTimeHasBeenSet = true;
    m_creationTime = std::forward<CreationTimeT>(value);
  }
  template <typename CreationTimeT = Aws::Utils::DateTime>
  GetApplicationResult& WithCreationTime(CreationTimeT&& value) {
    SetCreationTime(std::forward<CreationTimeT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The ISO-8601 formatted timestamp of the moment when the application was last
   * updated.</p>
   */
  inline const Aws::Utils::DateTime& GetLastUpdateTime() const { return m_lastUpdateTime; }
  template <typename LastUpdateTimeT = Aws::Utils::DateTime>
  void SetLastUpdateTime(LastUpdateTimeT&& value) {
    m_lastUpdateTimeHasBeenSet = true;
    m_lastUpdateTime = std::forward<LastUpdateTimeT>(value);
  }
  template <typename LastUpdateTimeT = Aws::Utils::DateTime>
  GetApplicationResult& WithLastUpdateTime(LastUpdateTimeT&& value) {
    SetLastUpdateTime(std::forward<LastUpdateTimeT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The number of top-level resources that were registered as part of this
   * application.</p>
   */
  inline int GetAssociatedResourceCount() const { return m_associatedResourceCount; }
  inline void SetAssociatedResourceCount(int value) {
    m_associatedResourceCountHasBeenSet = true;
    m_associatedResourceCount = value;
  }
  inline GetApplicationResult& WithAssociatedResourceCount(int value) {
    SetAssociatedResourceCount(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Key-value pairs associated with the application.</p>
   */
  inline const Aws::Map<Aws::String, Aws::String>& GetTags() const { return m_tags; }
  template <typename TagsT = Aws::Map<Aws::String, Aws::String>>
  void SetTags(TagsT&& value) {
    m_tagsHasBeenSet = true;
    m_tags = std::forward<TagsT>(value);
  }
  template <typename TagsT = Aws::Map<Aws::String, Aws::String>>
  GetApplicationResult& WithTags(TagsT&& value) {
    SetTags(std::forward<TagsT>(value));
    return *this;
  }
  template <typename TagsKeyT = Aws::String, typename TagsValueT = Aws::String>
  GetApplicationResult& AddTags(TagsKeyT&& key, TagsValueT&& value) {
    m_tagsHasBeenSet = true;
    m_tags.emplace(std::forward<TagsKeyT>(key), std::forward<TagsValueT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p> The information about the integration of the application with other
   * services, such as Resource Groups. </p>
   */
  inline const Integrations& GetIntegrations() const { return m_integrations; }
  template <typename IntegrationsT = Integrations>
  void SetIntegrations(IntegrationsT&& value) {
    m_integrationsHasBeenSet = true;
    m_integrations = std::forward<IntegrationsT>(value);
  }
  template <typename IntegrationsT = Integrations>
  GetApplicationResult& WithIntegrations(IntegrationsT&& value) {
    SetIntegrations(std::forward<IntegrationsT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p> A key-value pair that identifies an associated resource. </p>
   */
  inline const Aws::Map<Aws::String, Aws::String>& GetApplicationTag() const { return m_applicationTag; }
  template <typename ApplicationTagT = Aws::Map<Aws::String, Aws::String>>
  void SetApplicationTag(ApplicationTagT&& value) {
    m_applicationTagHasBeenSet = true;
    m_applicationTag = std::forward<ApplicationTagT>(value);
  }
  template <typename ApplicationTagT = Aws::Map<Aws::String, Aws::String>>
  GetApplicationResult& WithApplicationTag(ApplicationTagT&& value) {
    SetApplicationTag(std::forward<ApplicationTagT>(value));
    return *this;
  }
  template <typename ApplicationTagKeyT = Aws::String, typename ApplicationTagValueT = Aws::String>
  GetApplicationResult& AddApplicationTag(ApplicationTagKeyT&& key, ApplicationTagValueT&& value) {
    m_applicationTagHasBeenSet = true;
    m_applicationTag.emplace(std::forward<ApplicationTagKeyT>(key), std::forward<ApplicationTagValueT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  GetApplicationResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_id;

  Aws::String m_arn;

  Aws::String m_name;

  Aws::String m_description;

  Aws::Utils::DateTime m_creationTime{};

  Aws::Utils::DateTime m_lastUpdateTime{};

  int m_associatedResourceCount{0};

  Aws::Map<Aws::String, Aws::String> m_tags;

  Integrations m_integrations;

  Aws::Map<Aws::String, Aws::String> m_applicationTag;

  Aws::String m_requestId;
  bool m_idHasBeenSet = false;
  bool m_arnHasBeenSet = false;
  bool m_nameHasBeenSet = false;
  bool m_descriptionHasBeenSet = false;
  bool m_creationTimeHasBeenSet = false;
  bool m_lastUpdateTimeHasBeenSet = false;
  bool m_associatedResourceCountHasBeenSet = false;
  bool m_tagsHasBeenSet = false;
  bool m_integrationsHasBeenSet = false;
  bool m_applicationTagHasBeenSet = false;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace AppRegistry
}  // namespace Aws
