﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/transcribestreaming/TranscribeStreamingService_EXPORTS.h>
#include <aws/transcribestreaming/model/MedicalEntity.h>
#include <aws/transcribestreaming/model/MedicalItem.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace TranscribeStreamingService {
namespace Model {

/**
 * <p>A list of possible alternative transcriptions for the input audio. Each
 * alternative may contain one or more of <code>Items</code>,
 * <code>Entities</code>, or <code>Transcript</code>.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/transcribe-streaming-2017-10-26/MedicalAlternative">AWS
 * API Reference</a></p>
 */
class MedicalAlternative {
 public:
  AWS_TRANSCRIBESTREAMINGSERVICE_API MedicalAlternative() = default;
  AWS_TRANSCRIBESTREAMINGSERVICE_API MedicalAlternative(Aws::Utils::Json::JsonView jsonValue);
  AWS_TRANSCRIBESTREAMINGSERVICE_API MedicalAlternative& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_TRANSCRIBESTREAMINGSERVICE_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>Contains transcribed text.</p>
   */
  inline const Aws::String& GetTranscript() const { return m_transcript; }
  inline bool TranscriptHasBeenSet() const { return m_transcriptHasBeenSet; }
  template <typename TranscriptT = Aws::String>
  void SetTranscript(TranscriptT&& value) {
    m_transcriptHasBeenSet = true;
    m_transcript = std::forward<TranscriptT>(value);
  }
  template <typename TranscriptT = Aws::String>
  MedicalAlternative& WithTranscript(TranscriptT&& value) {
    SetTranscript(std::forward<TranscriptT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Contains words, phrases, or punctuation marks in your transcription
   * output.</p>
   */
  inline const Aws::Vector<MedicalItem>& GetItems() const { return m_items; }
  inline bool ItemsHasBeenSet() const { return m_itemsHasBeenSet; }
  template <typename ItemsT = Aws::Vector<MedicalItem>>
  void SetItems(ItemsT&& value) {
    m_itemsHasBeenSet = true;
    m_items = std::forward<ItemsT>(value);
  }
  template <typename ItemsT = Aws::Vector<MedicalItem>>
  MedicalAlternative& WithItems(ItemsT&& value) {
    SetItems(std::forward<ItemsT>(value));
    return *this;
  }
  template <typename ItemsT = MedicalItem>
  MedicalAlternative& AddItems(ItemsT&& value) {
    m_itemsHasBeenSet = true;
    m_items.emplace_back(std::forward<ItemsT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Contains entities identified as personal health information (PHI) in your
   * transcription output.</p>
   */
  inline const Aws::Vector<MedicalEntity>& GetEntities() const { return m_entities; }
  inline bool EntitiesHasBeenSet() const { return m_entitiesHasBeenSet; }
  template <typename EntitiesT = Aws::Vector<MedicalEntity>>
  void SetEntities(EntitiesT&& value) {
    m_entitiesHasBeenSet = true;
    m_entities = std::forward<EntitiesT>(value);
  }
  template <typename EntitiesT = Aws::Vector<MedicalEntity>>
  MedicalAlternative& WithEntities(EntitiesT&& value) {
    SetEntities(std::forward<EntitiesT>(value));
    return *this;
  }
  template <typename EntitiesT = MedicalEntity>
  MedicalAlternative& AddEntities(EntitiesT&& value) {
    m_entitiesHasBeenSet = true;
    m_entities.emplace_back(std::forward<EntitiesT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_transcript;

  Aws::Vector<MedicalItem> m_items;

  Aws::Vector<MedicalEntity> m_entities;
  bool m_transcriptHasBeenSet = false;
  bool m_itemsHasBeenSet = false;
  bool m_entitiesHasBeenSet = false;
};

}  // namespace Model
}  // namespace TranscribeStreamingService
}  // namespace Aws
