// Copyright (c) Microsoft Corporation.
// Licensed under the MIT License.
import { createPipelineRequest as tspCreatePipelineRequest, } from "@typespec/ts-http-runtime";
/**
 * Creates a new pipeline request with the given options.
 * This method is to allow for the easy setting of default values and not required.
 * @param options - The options to create the request with.
 */
export function createPipelineRequest(options) {
    // Cast required due to difference between ts-http-runtime requiring AbortSignal while core-rest-pipeline allows
    // the more generic AbortSignalLike. The wrapAbortSignalLike pipeline policy will take care of ensuring that any AbortSignalLike in the request
    // is converted into a true AbortSignal.
    return tspCreatePipelineRequest(options);
}//# sourceMappingURL=https://main.vscode-cdn.net/sourcemaps/c3a26841a84f20dfe0850d0a5a9bd01da4f003ea/node_modules/@azure/core-rest-pipeline/dist/react-native/pipelineRequest.js.map