// Copyright (c) Microsoft Corporation.
// Licensed under the MIT License.
/**
 * Helper function to convert OperationOptions to RequestParameters
 * @param options - the options that are used by Modular layer to send the request
 * @returns the result of the conversion in RequestParameters of RLC layer
 */
export function operationOptionsToRequestParameters(options) {
    return {
        allowInsecureConnection: options.requestOptions?.allowInsecureConnection,
        timeout: options.requestOptions?.timeout,
        skipUrlEncoding: options.requestOptions?.skipUrlEncoding,
        abortSignal: options.abortSignal,
        onUploadProgress: options.requestOptions?.onUploadProgress,
        onDownloadProgress: options.requestOptions?.onDownloadProgress,
        headers: { ...options.requestOptions?.headers },
        onResponse: options.onResponse,
    };
}//# sourceMappingURL=https://main.vscode-cdn.net/sourcemaps/c3a26841a84f20dfe0850d0a5a9bd01da4f003ea/node_modules/@typespec/ts-http-runtime/dist/esm/client/operationOptionHelpers.js.map