/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.docker.ui.rename;

import java.awt.Dialog;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.modules.docker.api.DockerAction;
import org.netbeans.modules.docker.api.DockerException;
import org.netbeans.modules.docker.ui.node.StatefulDockerContainer;
import org.netbeans.modules.docker.ui.rename.Bundle;
import org.netbeans.modules.docker.ui.rename.RenamePanel;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.RequestProcessor;
import org.openide.util.actions.NodeAction;

public class RenameContainerAction
extends NodeAction {
    private static final Logger LOGGER = Logger.getLogger(RenameContainerAction.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void performAction(Node[] activatedNodes) {
        StatefulDockerContainer container = (StatefulDockerContainer)activatedNodes[0].getLookup().lookup(StatefulDockerContainer.class);
        if (container != null) {
            JButton renameButton = new JButton();
            Mnemonics.setLocalizedText((AbstractButton)renameButton, (String)Bundle.LBL_Rename());
            RenamePanel panel = new RenamePanel(renameButton);
            DialogDescriptor descriptor = new DialogDescriptor((Object)panel, Bundle.LBL_RenameContainer(container.getDetail().getName()), true, new Object[]{renameButton, DialogDescriptor.CANCEL_OPTION}, (Object)renameButton, 0, null, null);
            descriptor.setClosingOptions(new Object[]{renameButton, DialogDescriptor.CANCEL_OPTION});
            panel.setMessageLine(descriptor.createNotificationLineSupport());
            Dialog dlg = null;
            try {
                dlg = DialogDisplayer.getDefault().createDialog(descriptor);
                dlg.setVisible(true);
                if (descriptor.getValue() == renameButton) {
                    this.perform(container, panel.getContainerName());
                }
            }
            finally {
                if (dlg != null) {
                    dlg.dispose();
                }
            }
        }
    }

    private void perform(final StatefulDockerContainer container, final String name) {
        RequestProcessor.getDefault().post(new Runnable(){
            final /* synthetic */ RenameContainerAction this$0;
            {
                this.this$0 = this$0;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                ProgressHandle handle = ProgressHandle.createHandle((String)Bundle.MSG_Renaming(container.getDetail().getName()));
                handle.start();
                try {
                    DockerAction facade = new DockerAction(container.getContainer().getInstance());
                    facade.rename(container.getContainer(), name);
                }
                catch (DockerException ex) {
                    LOGGER.log(Level.INFO, null, ex);
                    String msg = ex.getLocalizedMessage();
                    NotifyDescriptor.Message desc = new NotifyDescriptor.Message((Object)msg, 0);
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)desc);
                }
                finally {
                    handle.finish();
                }
            }
        });
    }

    protected boolean enable(Node[] activatedNodes) {
        if (activatedNodes.length != 1) {
            return false;
        }
        return activatedNodes[0].getLookup().lookup(StatefulDockerContainer.class) != null;
    }

    public String getName() {
        return Bundle.LBL_RenameContainerAction();
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected boolean asynchronous() {
        return false;
    }
}

