/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.ui.commit;

import java.io.File;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.libs.git.GitException;
import org.netbeans.libs.git.progress.FileListener;
import org.netbeans.libs.git.progress.NotificationListener;
import org.netbeans.modules.git.FileInformation;
import org.netbeans.modules.git.FileStatusCache;
import org.netbeans.modules.git.Git;
import org.netbeans.modules.git.client.GitClient;
import org.netbeans.modules.git.client.GitProgressSupport;
import org.netbeans.modules.git.ui.actions.GitAction;
import org.netbeans.modules.git.utils.GitUtils;
import org.netbeans.modules.versioning.spi.VCSContext;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;

public final class DeleteLocalAction
extends GitAction {
    private static final Logger LOG = Logger.getLogger(DeleteLocalAction.class.getName());

    @Override
    protected boolean enableFull(Node[] nodes) {
        VCSContext context = GitUtils.getCurrentContext(nodes);
        return Git.getInstance().getFileStatusCache().containsFiles(context.getRootFiles(), EnumSet.of(FileInformation.Status.NEW_HEAD_INDEX, FileInformation.Status.NEW_HEAD_WORKING_TREE), true);
    }

    @Override
    protected void performContextAction(Node[] nodes) {
        VCSContext context = GitUtils.getCurrentContext(nodes);
        FileStatusCache cache = Git.getInstance().getFileStatusCache();
        final Set files = context.getRootFiles();
        for (File f : files) {
            FileInformation info = cache.getStatus(f);
            if (info.containsStatus(EnumSet.of(FileInformation.Status.NEW_HEAD_INDEX, FileInformation.Status.NEW_HEAD_WORKING_TREE))) continue;
            return;
        }
        NotifyDescriptor.Confirmation descriptor = new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(DeleteLocalAction.class, (String)"CTL_DeleteLocal_Prompt"));
        descriptor.setTitle(NbBundle.getMessage(DeleteLocalAction.class, (String)"CTL_DeleteLocal_Title"));
        descriptor.setMessageType(2);
        descriptor.setOptionType(0);
        Object res = DialogDisplayer.getDefault().notify((NotifyDescriptor)descriptor);
        if (res != NotifyDescriptor.YES_OPTION) {
            return;
        }
        GitProgressSupport.NoOutputLogging support = new GitProgressSupport.NoOutputLogging(this){
            final /* synthetic */ DeleteLocalAction this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void perform() {
                final Map<File, Set<File>> sortedFiles = GitUtils.sortByRepository(files);
                try {
                    GitUtils.runWithoutIndexing(new Callable<Void>(){
                        final /* synthetic */ 1 this$1;
                        {
                            this.this$1 = this$1;
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public Void call() throws Exception {
                            FileListener list = new FileListener(){

                                public void notifyFile(File file, String relativePathToRoot) {
                                    this$1.setProgress(file.getName());
                                }
                            };
                            for (Map.Entry e : sortedFiles.entrySet()) {
                                if (this.this$1.isCanceled()) {
                                    return null;
                                }
                                File root = (File)e.getKey();
                                GitClient client = null;
                                try {
                                    client = Git.getInstance().getClient(root);
                                    client.addNotificationListener((NotificationListener)list);
                                    File[] roots = ((Set)e.getValue()).toArray(new File[((Set)e.getValue()).size()]);
                                    client.reset(roots, "HEAD", false, this.this$1.getProgressMonitor());
                                    client.clean(roots, this.this$1.getProgressMonitor());
                                }
                                catch (GitException ex) {
                                    LOG.log(Level.INFO, null, ex);
                                }
                                finally {
                                    if (client == null) continue;
                                    client.release();
                                }
                            }
                            return null;
                        }
                    }, files.toArray(new File[0]));
                }
                catch (GitException ex) {
                    LOG.log(Level.INFO, null, ex);
                }
            }
        };
        support.start(Git.getInstance().getRequestProcessor(), null, NbBundle.getMessage(DeleteLocalAction.class, (String)"LBL_DeleteLocalAction.progress"));
    }
}

