/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.graph;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import javax.swing.SwingUtilities;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.project.MavenProject;
import org.netbeans.modules.java.graph.DependencyGraphScene;
import org.netbeans.modules.java.graph.GraphEdge;
import org.netbeans.modules.java.graph.GraphNode;
import org.netbeans.modules.java.graph.GraphNodeImplementation;
import org.netbeans.modules.java.graph.GraphNodeVisitor;
import org.netbeans.modules.maven.graph.MavenDependencyNode;

public class GraphConstructor
implements GraphNodeVisitor<MavenDependencyNode> {
    private final MavenProject proj;
    private MavenDependencyNode root;
    private final Stack<MavenDependencyNode> path;
    final Map<String, GraphNode<MavenDependencyNode>> cache;
    private final List<GraphEdge<MavenDependencyNode>> edges;

    public GraphConstructor(MavenProject proj) {
        this.proj = proj;
        this.path = new Stack();
        this.cache = new HashMap<String, GraphNode<MavenDependencyNode>>();
        this.edges = new ArrayList<GraphEdge<MavenDependencyNode>>();
    }

    public boolean visit(MavenDependencyNode node) {
        if (this.root == null) {
            this.root = node;
        }
        boolean primary = false;
        GraphNode grNode = this.cache.get(node.getDependencyConflictId());
        if (node.getState() == 0) {
            if (grNode == null) {
                grNode = new GraphNode((GraphNodeImplementation)node);
                this.cache.put(node.getDependencyConflictId(), (GraphNode<MavenDependencyNode>)grNode);
            } else {
                grNode.setImpl((GraphNodeImplementation)node);
            }
            grNode.setPrimaryLevel(this.path.size());
            primary = true;
        } else {
            if (grNode == null) {
                grNode = new GraphNode((GraphNodeImplementation)node);
                String conflictId = node.getState() == 2 ? node.getRelatedDependencyConflictId() : node.getDependencyConflictId();
                this.cache.put(conflictId, (GraphNode<MavenDependencyNode>)grNode);
            }
            grNode.addDuplicateOrConflict((GraphNodeImplementation)node);
        }
        if (!this.path.empty()) {
            GraphNodeImplementation parent = this.path.peek();
            GraphEdge ed = new GraphEdge(parent, (GraphNodeImplementation)node);
            ed.setPrimaryPath(primary);
            this.edges.add((GraphEdge<MavenDependencyNode>)ed);
        }
        if (node != this.root && grNode.getImpl() != null) {
            grNode.setManagedState(this.obtainManagedState((MavenDependencyNode)grNode.getImpl()));
        }
        this.path.push(node);
        return true;
    }

    public void updateScene(DependencyGraphScene scene) {
        assert (SwingUtilities.isEventDispatchThread());
        GraphNode<MavenDependencyNode> rootNode = this.cache.get(this.root.getDependencyConflictId());
        scene.addNode(rootNode);
        for (GraphNode<MavenDependencyNode> graphNode : this.cache.values()) {
            if (graphNode == rootNode) continue;
            scene.addNode(graphNode);
        }
        for (GraphEdge graphEdge : this.edges) {
            scene.addEdge((Object)graphEdge);
            GraphNode<MavenDependencyNode> grNode = this.cache.get(((MavenDependencyNode)graphEdge.getTarget()).getDependencyConflictId());
            if (grNode == null) {
                grNode = this.cache.get(((MavenDependencyNode)graphEdge.getTarget()).getRelatedDependencyConflictId());
            }
            scene.setEdgeTarget((Object)graphEdge, grNode);
            GraphNode<MavenDependencyNode> parentGrNode = this.cache.get(((MavenDependencyNode)graphEdge.getSource()).getDependencyConflictId());
            scene.setEdgeSource((Object)graphEdge, parentGrNode);
        }
    }

    public boolean endVisit(MavenDependencyNode node) {
        this.path.pop();
        return true;
    }

    private int obtainManagedState(MavenDependencyNode dependencyNode) {
        if (this.proj == null) {
            return 0;
        }
        DependencyManagement dm = this.proj.getDependencyManagement();
        if (dm == null) {
            return 0;
        }
        List deps = dm.getDependencies();
        if (deps == null) {
            return 0;
        }
        Artifact artifact = dependencyNode.getArtifact();
        String id = artifact.getArtifactId();
        String groupId = artifact.getGroupId();
        String version = artifact.getVersion();
        for (Dependency dep : deps) {
            if (!id.equals(dep.getArtifactId()) || !groupId.equals(dep.getGroupId())) continue;
            if (!version.equals(dep.getVersion())) {
                return 2;
            }
            return 1;
        }
        return 0;
    }
}

