/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javaee.resources.impl.model;

import java.net.URL;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.queries.SourceForBinaryQuery;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.modules.j2ee.metadata.model.api.support.annotation.AnnotationModelHelper;
import org.netbeans.modules.javaee.resources.api.model.Location;
import org.netbeans.modules.javaee.resources.impl.model.LocationImpl;
import org.openide.filesystems.FileObject;

public final class LocationHelper {
    private LocationHelper() {
    }

    public static Location getClassLocation(AnnotationModelHelper helper, String fqn) {
        String cpBase = fqn.replace('.', '/');
        ClassPath sourceCP = helper.getClasspathInfo().getClassPath(ClasspathInfo.PathKind.SOURCE);
        FileObject classFO = sourceCP.findResource(cpBase + ".java");
        if (classFO == null) {
            ClassPath compileCP = helper.getClasspathInfo().getClassPath(ClasspathInfo.PathKind.COMPILE);
            classFO = LocationHelper.searchForFile(compileCP, cpBase);
        }
        if (classFO != null) {
            return new LocationImpl(classFO);
        }
        return null;
    }

    private static FileObject searchForFile(ClassPath cp, String cpBase) {
        FileObject file = LocationHelper.getFileFromClasspath(cp, cpBase + ".java");
        if (file == null) {
            return LocationHelper.getFileFromClasspath(cp, cpBase + ".class");
        }
        return file;
    }

    private static FileObject getFileFromClasspath(ClassPath cp, String classRelativePath) {
        for (ClassPath.Entry entry : cp.entries()) {
            FileObject[] roots;
            if (entry.isValid()) {
                roots = new FileObject[]{entry.getRoot()};
            } else {
                SourceForBinaryQuery.Result res = SourceForBinaryQuery.findSourceRoots((URL)entry.getURL());
                roots = res.getRoots();
            }
            for (FileObject root : roots) {
                FileObject metaInf = root.getFileObject(classRelativePath);
                if (metaInf == null) continue;
                return metaInf;
            }
        }
        return null;
    }
}

