/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.schema2beansdev;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.netbeans.modules.schema2beans.AttrProp;
import org.netbeans.modules.schema2beans.Common;
import org.netbeans.modules.schema2beans.JavaBeansUtil;
import org.netbeans.modules.schema2beans.QName;
import org.netbeans.modules.schema2beans.ValidateException;
import org.netbeans.modules.schema2beansdev.AbstractCodeGeneratorClass;
import org.netbeans.modules.schema2beansdev.BeanBuilder;
import org.netbeans.modules.schema2beansdev.CodeGeneratorClass;
import org.netbeans.modules.schema2beansdev.GenBeans;
import org.netbeans.modules.schema2beansdev.GraphLink;
import org.netbeans.modules.schema2beansdev.GraphNode;
import org.netbeans.modules.schema2beansdev.HasAnnotation;
import org.netbeans.modules.schema2beansdev.SchemaRep;
import org.netbeans.modules.schema2beansdev.gen.JavaUtil;
import org.netbeans.modules.schema2beansdev.gen.JavaWriter;
import org.netbeans.modules.schema2beansdev.metadd.MetaDD;
import org.netbeans.modules.schema2beansdev.metadd.MetaElement;
import org.netbeans.modules.schema2beansdev.metadd.MetaProperty;

public class JavaBeanClass
extends AbstractCodeGeneratorClass
implements CodeGeneratorClass {
    protected final int elementTypeSetnull = -1;
    private Map declaredQNames = new HashMap();
    private boolean loggerDeclared = false;

    JavaBeanClass(BeanBuilder.BeanElement be, GenBeans.Config config) {
        this.init(be, config);
    }

    @Override
    public void generate(OutputStream out, MetaDD mdd) throws IOException {
        this.mdd = mdd;
        this.metaElement = this.getMetaElement(this.beanElement);
        if (this.metaElement != null && this.metaElement.isSkipGeneration()) {
            this.config.messageOut.println(Common.getMessage("MSG_SkippingGeneration"));
            return;
        }
        this.findAttributeOwners();
        this.genAllParts();
        this.select(this.DECL_SECTION);
        this.cr();
        this.printGenBuffers(out);
    }

    protected void genAllParts() throws IOException {
        this.genHeader(this.HEADER_SECTION);
        this.genPackage(this.HEADER_SECTION);
        this.genImports(this.HEADER_SECTION);
        this.genClassName(this.HEADER_SECTION);
        this.genConstructor();
        this.genAccessors();
        if (!this.config.isMinFeatures()) {
            this.genDeepCopy();
        }
        if (this.config.isGenerateXMLIO() || this.config.isDumpToString()) {
            this.genXMLIO();
        }
        if (this.config.isStaxProduceXMLEventReader()) {
            this.genFetchXMLEventReader();
        }
        if (this.config.isGenerateValidate()) {
            this.genValidate();
        }
        if (this.config.isGeneratePropertyEvents()) {
            this.genPropertyEvents();
        }
        if (this.config.isGenerateStoreEvents()) {
            this.genStoreEvents();
        }
        if (this.config.isVetoable()) {
            this.genVetoable();
        }
        if (this.config.isGenerateTransactions()) {
            this.genTransactions();
        }
        if (this.config.isGenerateHasChanged()) {
            this.genHasChanged();
        }
        if (this.config.isGenerateSwitches()) {
            this.generateSwitches();
        }
        if (!this.config.isMinFeatures()) {
            this.genPropertiesByName();
        }
        if (this.config.isKeepElementPositions()) {
            this.genElementPositions();
        }
        if (this.beanElement.isRoot && this.config.isProcessDocType()) {
            this.genProcessDocType(this.config.isJava5());
        }
        if (!this.config.isMinFeatures()) {
            this.genName();
            this.genChildBeans();
        }
        this.genEqualsHashCode();
        if (this.config.isDumpToString()) {
            this.genToString();
        }
        if (this.config.isExtendBaseBean()) {
            this.genExtendBaseBean();
        }
        this.genTrailer(this.TRAILER_SECTION);
        this.genFinishClass(this.TRAILER_SECTION);
        try {
            this.select(this.TRAILER_SECTION);
            this.printSchema();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected void genMadeChange() throws IOException {
        if (this.config.isGenerateHasChanged()) {
            this.jw.writeEol("_setChanged(true)");
        }
    }

    protected void genExtendBaseBeanConstructor() throws IOException {
        if (this.config.isExtendBaseBean()) {
            this.jw.writeEol("super(null, baseBeanRuntimeVersion)");
        }
    }

    public void genHeader(int out) throws IOException {
        this.select(out);
        this.gencr("/**");
        this.gencr(" *\tThis generated bean class " + this.className);
        this.gencr(" *\tmatches the schema element '" + this.beanElement.node.getName() + "'.");
        if (!this.beanElement.isRoot) {
            this.jw.writecr(" *  The root bean class is " + this.rootBeanElement.getClassType());
        }
        this.gencr(" *");
        this.printComment(" *\t");
        if (this.config.isGenerateTimeStamp()) {
            this.gencr(" *\tGenerated on " + new Date());
        }
        if (this.beanElement.isRoot) {
            this.gencr(" *");
            this.gencr(" *\tThis class matches the root element of the " + (this.config.getSchemaTypeNum() == 1 ? "DTD" : "XML Schema") + ",");
            this.gencr(" *\tand is the root of the bean graph.");
            this.gencr(" *");
            this.dumpBeanTree(this.jw, " * " + this.jw.getIndent(), this.jw.getIndent());
            this.gencr(" *");
        }
        this.gencr(" * @Generated");
        this.gencr(" */");
        this.cr();
    }

    public void genPackage(int out) {
        this.select(out);
        if (this.packageName != null) {
            this.gen(5, this.packageName);
            this.eol();
            this.cr();
        }
    }

    public void genImports(int out) {
        this.select(out);
    }

    public void genClassName(int out) throws IOException {
        String name = null;
        String impName = null;
        this.select(out);
        this.jw.write("public ");
        this.jw.write("class ", this.className);
        if (this.mdd != null) {
            if (this.metaElement != null) {
                name = this.metaElement.getExtends();
                impName = this.metaElement.getImplements();
            }
            if (name == null) {
                name = this.mdd.getExtends();
            }
            if (impName == null) {
                impName = this.mdd.getImplements();
            }
        }
        if (name != null) {
            this.gen(" extends ");
            this.gencr(name);
        }
        if (impName != null) {
            this.gen(" implements ", impName);
        }
        this.sp();
        this.begin();
    }

    public void genConstructor() throws IOException {
        String type;
        AbstractCodeGeneratorClass.Property a;
        int i;
        int size = this.attrList.size();
        if (!this.config.isMinFeatures()) {
            this.jw.select(this.DECL_SECTION);
            for (i = 0; i < size; ++i) {
                a = (AbstractCodeGeneratorClass.Property)this.attrList.get(i);
                this.jw.write("public static final String ", a.constName, " = \"", a.name);
                this.jw.writeEolNoI18N("\"");
            }
            this.jw.cr();
        }
        this.jw.select(this.CONSTRUCTOR_SECTION);
        this.jw.bigComment("Normal starting point constructor.");
        this.jw.beginConstructor(this.className);
        if (this.config.isExtendBaseBean()) {
            this.jw.select(this.DECL_SECTION);
            this.jw.write("private static final org.netbeans.modules.schema2beans.Version baseBeanRuntimeVersion = new org.netbeans.modules.schema2beans.Version(5", ", ");
            this.jw.write("0, ");
            this.jw.writeEol("0)");
            this.jw.select(this.CONSTRUCTOR_SECTION);
            this.jw.writeEol("this(null, baseBeanRuntimeVersion)");
            this.jw.end();
            this.jw.cr();
            this.jw.bigComment("This constructor is here for BaseBean compatibility.");
            this.jw.beginConstructor(this.className, "java.util.Vector comps, org.netbeans.modules.schema2beans.Version baseBeanRuntimeVersion");
        }
        this.genExtendBaseBeanConstructor();
        if (this.config.isMakeDefaults() || this.config.isSetDefaults()) {
            for (i = 0; i < size; ++i) {
                a = (AbstractCodeGeneratorClass.Property)this.attrList.get(i);
                boolean indexed = a.isIndexed();
                boolean isScalar = a.isScalar();
                if (indexed || isScalar || a.ored || a.getDefaultValue() != null) continue;
                type = a.getType();
                String attr = "_" + a.name;
                if (a.elementInstance != 32) continue;
                List exceps = JavaUtil.exceptionsFromParsingText(type, false);
                if (!exceps.isEmpty()) {
                    this.jw.beginTry();
                }
                this.gen(attr, " = ");
                this.genNewDefault(a, true);
                this.eol();
                if (a.isBean && this.config.isGenerateParentRefs()) {
                    this.jw.writeEol(attr, "._setParent(this)");
                }
                if (exceps.isEmpty()) continue;
                this.end();
                this.genRethrowExceptions(exceps);
            }
        }
        this.jw.end();
        this.jw.cr();
        LinkedList<AbstractCodeGeneratorClass.Property> requiredParameters = new LinkedList<AbstractCodeGeneratorClass.Property>();
        for (int i2 = 0; i2 < size; ++i2) {
            AbstractCodeGeneratorClass.Property a2 = (AbstractCodeGeneratorClass.Property)this.attrList.get(i2);
            if (a2.ored || a2.elementInstance != 32 && a2.elementInstance != 64) continue;
            requiredParameters.add(a2);
        }
        if (!this.config.isMinFeatures() && requiredParameters.size() > 0) {
            String parameters = null;
            for (AbstractCodeGeneratorClass.Property a3 : requiredParameters) {
                parameters = parameters != null ? parameters + ", " : "";
                String baseType = type = a3.getType();
                if (a3.isIndexed()) {
                    type = baseType + "[]";
                }
                String fullClassType = this.getTypeFullClassName(a3, type);
                parameters = parameters + fullClassType + " " + a3.instanceOf();
            }
            this.jw.bigComment("Required parameters constructor");
            this.jw.beginConstructor(this.className, parameters);
            this.genExtendBaseBeanConstructor();
            for (AbstractCodeGeneratorClass.Property a4 : requiredParameters) {
                String type2;
                boolean indexed = a4.isIndexed();
                String baseType = type2 = a4.getType();
                if (indexed) {
                    type2 = baseType + "[]";
                }
                String attr = "_" + a4.name;
                SchemaRep.WhiteSpace ws = (SchemaRep.WhiteSpace)a4.searchExtraData(SchemaRep.WhiteSpace.class);
                if (!indexed) {
                    if (ws != null) {
                        this.genWhiteSpaceRestriction(ws, a4.instanceOf(), baseType);
                    }
                    this.jw.write(attr, " = ");
                    this.jw.writeEol(a4.instanceOf());
                    if (a4.isBean && this.config.isGenerateParentRefs()) {
                        this.jw.beginIf(attr + " != null");
                        this.jw.writeEol(attr, "._setParent(this)");
                        this.jw.end();
                        continue;
                    }
                    if (!this.config.isOptionalScalars() || !a4.isScalar()) continue;
                    this.jw.writeEol(a4.getScalarIsSet(), " = true");
                    continue;
                }
                this.jw.beginIf(a4.instanceOf() + "!= null");
                if ("java.util.ArrayList".equals(this.config.getIndexedPropertyType())) {
                    this.jw.write("((", this.config.getIndexedPropertyType(), ") ", attr);
                    this.jw.writeEol(").ensureCapacity(", a4.instanceOf(), ".length)");
                }
                this.jw.beginFor("int i = 0", "i < " + a4.instanceOf() + ".length", "++i");
                if (ws != null) {
                    this.genWhiteSpaceRestriction(ws, a4.instanceOf() + "[i]", baseType);
                }
                if (a4.isBean && this.config.isGenerateParentRefs()) {
                    this.jw.beginIf(a4.instanceOf() + "[i] != null");
                    this.jw.writeEol(a4.instanceOf(), "[i]._setParent(this)");
                    this.jw.end();
                }
                this.jw.write(attr, ".add(", JavaUtil.toObject(a4.instanceOf() + "[i]", baseType, this.config.isForME(), this.config.isJava5()));
                this.jw.writeEol(")");
                this.jw.end();
                this.jw.end();
            }
            this.jw.end();
            this.jw.cr();
        }
    }

    public void genAccessors() throws IOException {
        int size = this.attrList.size();
        for (int i = 0; i < size; ++i) {
            SchemaRep.WhiteSpace ws;
            String type;
            AbstractCodeGeneratorClass.Property a = (AbstractCodeGeneratorClass.Property)this.attrList.get(i);
            boolean indexed = a.isIndexed();
            boolean isArrayStyle = this.config.getIndexedPropertyType() == null;
            boolean isWrapper = false;
            boolean isScalar = a.isScalar();
            String scalarType = a.getScalarType();
            String attr = "_" + a.name;
            String propertyName = a.beanIntrospectorName();
            MetaElement me = this.getMetaElement(a);
            String baseType = type = a.getType();
            if (indexed) {
                type = baseType + "[]";
            }
            AbstractCodeGeneratorClass.Signatures sigs = this.getSignatures(a);
            this.select(this.DECL_SECTION);
            if (indexed) {
                if (isArrayStyle) {
                    this.gen(1, baseType + "[]", attr);
                    this.gen(" = new ", baseType, "[0]");
                    this.eol();
                } else {
                    String paramType = this.config.jdkTarget >= 150 ? "<" + JavaUtil.toObjectType(baseType) + ">" : "";
                    this.gen(1, "java.util.List" + paramType, attr);
                    this.gen(" = new " + this.config.getIndexedPropertyType() + paramType + "();");
                    this.tabIn();
                    if (this.config.jdkTarget < 150) {
                        this.comment("List<" + baseType + ">");
                    } else {
                        this.cr();
                    }
                }
            } else {
                this.gen(1, type, attr);
                if (a.getDefaultValue() != null && (a.elementInstance == 32 || a.elementInstance == 64)) {
                    this.gen(" = ");
                    if (!JavaUtil.checkValueToType(type, a.getDefaultValue())) {
                        this.config.messageOut.println(Common.getMessage("MSG_NotAGoodValue", a.getDefaultValue(), type));
                    }
                    this.gen(JavaUtil.instanceFrom(type, a.getDefaultValue()));
                    this.eol();
                    if (this.config.isOptionalScalars() && a.isScalar()) {
                        this.gen(1, "boolean", a.getScalarIsSet());
                        this.gen(" = true");
                        this.eol();
                    }
                } else {
                    this.eol();
                    if (this.config.isOptionalScalars() && a.isScalar()) {
                        this.gen(1, "boolean", a.getScalarIsSet());
                        this.gen(" = false");
                        this.eol();
                    }
                }
            }
            this.select(this.ACCESS_SECTION);
            this.comment("This attribute is ", Common.instanceToString(a.elementInstance));
            if (this.config.jdkTarget >= 150) {
                boolean first = true;
                Iterator extraDataIt = a.extraDataIterator();
                while (extraDataIt.hasNext()) {
                    Object extraData = extraDataIt.next();
                    if (!(extraData instanceof HasAnnotation)) continue;
                    HasAnnotation annotator = (HasAnnotation)extraData;
                    if (first) {
                        first = false;
                    } else {
                        this.jw.write(' ');
                    }
                    this.jw.write('@');
                    this.jw.write(annotator.genAnnotation());
                }
                if (!first) {
                    this.jw.cr();
                }
            }
            this.gen(sigs.findSignature(SETTER));
            this.sp();
            this.begin();
            if (a.getPropertyInterface() != null) {
                this.jw.writeEol(type + " value = (" + type + ") valueInterface");
            }
            if (indexed) {
                this.gen("if (value == null)");
                this.cr();
                this.tabIn();
                if (baseType.equals("byte[]")) {
                    this.jw.writeEol("value = new byte[0][0]");
                } else {
                    this.jw.writeEol("value = new ", baseType, "[0]");
                }
            }
            if (!indexed && (ws = (SchemaRep.WhiteSpace)a.searchExtraData(SchemaRep.WhiteSpace.class)) != null) {
                this.genWhiteSpaceRestriction(ws, "value", baseType);
            }
            if (this.config.isGeneratePropertyEvents() || this.config.isVetoable()) {
                if (indexed) {
                    this.jw.beginIf("value.length == " + a.getSizeMethod() + "()");
                    this.jw.writeEol("boolean same = true");
                    this.jw.beginFor("int i = 0", "i < value.length", "++i");
                    this.jw.beginIf("!(" + JavaUtil.genEquals(type, "value[i]", a.getReadMethod(true) + "(i)") + ")");
                    this.jw.writeEol("same = false");
                    this.jw.writeEol("break");
                    this.jw.end();
                    this.jw.end();
                    this.jw.beginIf("same");
                } else {
                    this.jw.beginIf(JavaUtil.genEquals(type, "value", attr));
                }
                this.jw.comment("No change.");
                this.jw.writeEol("return");
                this.jw.end();
                if (indexed) {
                    this.jw.end();
                }
                if (a.isBean) {
                    if (this.config.isGeneratePropertyEvents()) {
                        this.comment("Make the foreign beans take on our property change event listeners.");
                    }
                    if (this.config.isGenerateParentRefs()) {
                        this.comment("Maintain the parent reference.");
                    }
                    String iterVar = "value";
                    if (indexed) {
                        this.jw.beginFor("int i = 0", "i < value.length", "++i");
                        iterVar = "value[i]";
                    }
                    this.jw.beginIf(iterVar + " != null");
                    if (this.config.isGeneratePropertyEvents()) {
                        this.geneol(iterVar + "._setPropertyChangeSupport(eventListeners)");
                    }
                    if (this.config.isVetoable()) {
                        this.geneol(iterVar + "._setVetoableChangeSupport(vetos)");
                    }
                    if (this.config.isGenerateParentRefs()) {
                        this.jw.writeEol(iterVar + "._setParent(this)");
                    }
                    this.jw.end();
                    if (indexed) {
                        this.jw.end();
                    }
                }
                this.jw.writeEol("java.beans.PropertyChangeEvent event = null");
                this.gen("if (");
                this.jw.setFirst(" || ");
                if (this.config.isGeneratePropertyEvents()) {
                    this.jw.writeNext("eventListeners != null");
                }
                if (this.config.isGenerateStoreEvents()) {
                    this.jw.writeNext("storeEvents");
                }
                if (this.config.isVetoable()) {
                    this.jw.writeNext("vetos != null");
                }
                this.gen(") ");
                this.begin();
                if (indexed) {
                    this.jw.comment("See if only 1 thing changed.");
                    this.jw.writeEol("int addIndex = -1");
                    this.jw.writeEol("int removeIndex = -1");
                    this.jw.writeEol("int oldSize = size", a.name, "()");
                    this.jw.writeEol("int newSize = value.length");
                    this.jw.beginIf("oldSize + 1 == newSize || oldSize == newSize + 1");
                    this.jw.writeEol("boolean checkAddOrRemoveOne = true");
                    this.jw.writeEol("int oldIndex = 0, newIndex = 0");
                    this.jw.beginFor("", "oldIndex < oldSize && newIndex < newSize", "++newIndex, ++oldIndex");
                    this.jw.beginIf(JavaUtil.genEquals(baseType, "value[newIndex]", a.getReadMethod(true) + "(oldIndex)"));
                    this.jw.comment("Same, so just continue.");
                    this.jw.endElseBeginIf("addIndex != -1 || removeIndex != -1");
                    this.jw.comment("More than 1 difference detected.");
                    this.jw.writeEol("addIndex = removeIndex = -1");
                    this.jw.writeEol("checkAddOrRemoveOne = false");
                    this.jw.writeEol("break");
                    this.jw.endElseBeginIf("oldIndex + 1 < oldSize && (" + JavaUtil.genEquals(baseType, "value[newIndex]", a.getReadMethod(true) + "(oldIndex+1)") + ")");
                    this.jw.writeEol("removeIndex = oldIndex");
                    this.jw.writeEol("++oldIndex");
                    this.jw.endElseBeginIf("newIndex + 1 < newSize && (" + JavaUtil.genEquals(baseType, "value[newIndex+1]", a.getReadMethod(true) + "(oldIndex)") + ")");
                    this.jw.writeEol("addIndex = newIndex");
                    this.jw.writeEol("++newIndex");
                    this.jw.endElseBegin();
                    this.jw.comment("More than 1 difference.");
                    this.jw.writeEol("addIndex = removeIndex = -1");
                    this.jw.writeEol("checkAddOrRemoveOne = false");
                    this.jw.writeEol("break");
                    this.jw.end();
                    this.jw.end();
                    this.jw.beginIf("checkAddOrRemoveOne && addIndex == -1 && removeIndex == -1");
                    this.jw.beginIf("oldSize + 1 == newSize");
                    this.jw.comment("Added last one");
                    this.jw.writeEol("addIndex = oldSize");
                    this.jw.endElseBeginIf("oldSize == newSize + 1");
                    this.jw.comment("Removed last one");
                    this.jw.writeEol("removeIndex = newSize");
                    this.jw.end();
                    this.jw.end();
                    this.jw.end();
                    this.jw.beginIf("addIndex >= 0");
                    this.jw.write("event = ");
                    this.genNewEvent(a, "addIndex", "null", "value[addIndex]", baseType);
                    this.jw.eol();
                    if (!(isArrayStyle || this.config.isVetoable() || this.config.isKeepElementPositions() || this.config.isGenerateStoreEvents())) {
                        ws = (SchemaRep.WhiteSpace)a.searchExtraData(SchemaRep.WhiteSpace.class);
                        if (ws != null) {
                            this.genWhiteSpaceRestriction(ws, "value[addIndex]", baseType);
                        }
                        this.jw.writeEol(attr + ".add(addIndex, value[addIndex])");
                        this.genMadeChange();
                        this.jw.writeEol("eventListeners.firePropertyChange(event)");
                        this.jw.writeEol("return");
                    }
                    this.jw.endElseBeginIf("removeIndex >= 0");
                    this.jw.write("event = ");
                    this.genNewEvent(a, "removeIndex", a.getReadMethod(true) + "(removeIndex)", "null", baseType);
                    this.jw.eol();
                    if (!(isArrayStyle || this.config.isVetoable() || this.config.isKeepElementPositions() || this.config.isGenerateStoreEvents())) {
                        this.jw.writeEol(attr + ".remove(removeIndex)");
                        this.genMadeChange();
                        this.jw.writeEol("eventListeners.firePropertyChange(event)");
                        this.jw.writeEol("return");
                    }
                    this.jw.endElseBegin();
                }
                this.jw.write("event = ");
                this.genNewEvent(a, indexed ? "-1" : "", a.getReadMethod(false) + "()", "value", type);
                this.jw.eol();
                this.end();
                if (indexed) {
                    this.jw.end();
                }
            }
            if (this.config.isVetoable()) {
                this.gencr("if (vetos != null)");
                this.tabIn();
                this.geneol("vetos.fireVetoableChange(event)");
            }
            if (indexed) {
                if (this.config.isKeepElementPositions()) {
                    this.jw.comment("Figure out where this type belongs.");
                    this.jw.writeEol("int elementCount = fetchChildCount()");
                    this.jw.writeEol("int destPos = 0");
                    this.jw.writeEol("int srcPos = 0");
                    this.jw.beginFor("", "destPos < elementCount && srcPos < value.length", "++destPos");
                    this.jw.beginIf("elementTypesByPosition[destPos] == " + i);
                    this.jw.comment("replace it");
                    this.jw.writeEol("elementsByPosition[destPos] = value[srcPos++]");
                    this.jw.end();
                    this.jw.end();
                    this.jw.comment("Handle when the replacement array is smaller.");
                    this.jw.beginWhile("destPos < elementCount");
                    this.jw.beginIf("elementTypesByPosition[destPos] == " + i);
                    this.jw.writeEol("deleteElement(destPos)");
                    this.jw.writeEol("--elementCount");
                    this.jw.endElseBegin();
                    this.jw.writeEol("++destPos");
                    this.jw.end();
                    this.jw.end();
                    this.jw.comment("Handle when replacement array is larger.");
                    this.jw.beginFor("", "srcPos < value.length", "++srcPos");
                    this.jw.writeEol("insertElementByPosition(destPos++, ", JavaUtil.toObject("value[srcPos]", baseType, this.config.isForME(), this.config.isJava5()), ", " + i + ")");
                    this.jw.end();
                }
                if (isArrayStyle) {
                    this.jw.writeEol(attr, " = value");
                } else {
                    this.jw.writeEol(attr, ".clear()");
                    if ("java.util.ArrayList".equals(this.config.getIndexedPropertyType())) {
                        this.jw.writeEol("((", this.config.getIndexedPropertyType(), ") " + attr, ").ensureCapacity(value.length)");
                    }
                    this.jw.beginFor("int i = 0", "i < value.length", "++i");
                    ws = (SchemaRep.WhiteSpace)a.searchExtraData(SchemaRep.WhiteSpace.class);
                    if (ws != null) {
                        this.genWhiteSpaceRestriction(ws, "value[i]", baseType);
                    }
                    this.jw.write(attr, ".add(");
                    String objectValue = JavaUtil.toObject("value[i]", baseType, this.config.isForME(), this.config.isJava5());
                    this.jw.writeEol(objectValue, ")");
                    this.jw.end();
                }
            } else {
                this.geneol(attr + " = value");
                if (this.config.isOptionalScalars() && a.isScalar()) {
                    this.jw.writeEol(a.getScalarIsSet(), " = true");
                }
                if (this.config.isKeepElementPositions()) {
                    this.jw.comment("Figure out where this type belongs.");
                    this.jw.writeEol("int elementCount = fetchChildCount()");
                    this.jw.writeEol("int pos = findFirstOfElementType(" + i + ")");
                    if (!isScalar) {
                        this.jw.beginIf("value != null");
                    }
                    this.jw.beginIf("pos >= elementCount");
                    this.jw.comment("It's the last one to be added");
                    this.jw.writeEol("expandElementsByPosition(elementCount+1)");
                    this.jw.writeEol("elementTypesByPosition[pos] = " + i);
                    this.jw.end();
                    this.jw.writeEol("elementsByPosition[pos] = ", JavaUtil.toObject("value", type, this.config.isForME(), this.config.isJava5()));
                    if (!isScalar) {
                        this.jw.endElseBegin();
                        this.jw.beginIf("pos < elementCount");
                        this.jw.writeEol("deleteElement(pos)");
                        this.jw.end();
                        this.jw.end();
                    }
                }
            }
            this.genMadeChange();
            if (this.config.isGeneratePropertyEvents()) {
                if (this.config.isGenerateStoreEvents()) {
                    this.gencr("if (storeEvents)");
                    this.tabIn();
                    this.geneol("storedEvents.add(event)");
                    this.gen("else ");
                }
                this.gencr("if (event != null)");
                this.tabIn();
                this.geneol("eventListeners.firePropertyChange(event)");
            }
            this.genResetMutuallyExclusive(a, true);
            this.end();
            this.cr();
            if (indexed) {
                this.gen(sigs.findSignature(SETTERINDEXED));
                this.sp();
                this.begin();
                if (a.getPropertyInterface() != null) {
                    this.jw.writeEol(baseType + " value = (" + baseType + ") valueInterface");
                }
                if (this.config.isGeneratePropertyEvents()) {
                    this.jw.beginIf(JavaUtil.genEquals(type, "value", a.getReadMethod(true) + "(index)", true));
                    this.jw.comment("No change.");
                    this.jw.writeEol("return");
                    this.jw.end();
                }
                if (a.isBean && this.config.isGenerateParentRefs()) {
                    this.jw.beginIf("value != null");
                    this.jw.writeEol("value._setParent(this)");
                    this.jw.end();
                }
                if (this.config.isGeneratePropertyEvents()) {
                    if (a.isBean) {
                        this.jw.beginIf("value != null");
                        this.comment("Make the foreign beans take on our property change event listeners.");
                        this.geneol("value._setPropertyChangeSupport(eventListeners)");
                        if (this.config.isVetoable()) {
                            this.geneol("value._setVetoableChangeSupport(vetos)");
                        }
                        this.jw.end();
                    }
                    this.gen("if (");
                    if (this.config.isGenerateStoreEvents()) {
                        this.gen("storeEvents || ");
                    }
                    this.gen("eventListeners != null) ");
                    this.begin();
                    this.jw.write("java.beans.PropertyChangeEvent event = ");
                    this.genNewEvent(a, "index", a.getReadMethod(true) + "(index)", "value", baseType);
                    this.jw.eol();
                    if (this.config.isVetoable()) {
                        this.gencr("if (vetos != null)");
                        this.tabIn();
                        this.geneol("vetos.fireVetoableChange(event)");
                    }
                    if (this.config.isGenerateStoreEvents()) {
                        this.gencr("if (storeEvents)");
                        this.tabIn();
                        this.geneol("storedEvents.add(event)");
                        this.gencr("else");
                        this.tabIn();
                    }
                    this.geneol("eventListeners.firePropertyChange(event)");
                    this.end();
                }
                if (isArrayStyle) {
                    this.jw.writeEol(attr, "[index] = value");
                } else {
                    if (!a.isDirectChild()) {
                        this.jw.beginFor("int size = " + attr + ".size()", "index >= size", "++size");
                        this.jw.writeEol(attr, ".add(null)");
                        this.jw.end();
                    }
                    this.jw.write(attr, ".set(index, ");
                    this.jw.write(JavaUtil.toObject("value", baseType, this.config.isForME(), this.config.isJava5()));
                    this.jw.writeEol(")");
                }
                if (this.config.isKeepElementPositions()) {
                    this.jw.writeEol("int pos = findElementType(" + i + ", index)");
                    this.jw.writeEol("elementsByPosition[pos] = ", JavaUtil.toObject("value", baseType, this.config.isForME(), this.config.isJava5()));
                }
                this.genMadeChange();
                this.end();
                this.cr();
            }
            this.gen(sigs.findSignature(GETTER));
            this.sp();
            this.begin();
            if (indexed && !isArrayStyle) {
                if (baseType.equals("byte[]")) {
                    this.jw.writeEol(type, " arr = new byte[", attr, ".size()][]");
                } else {
                    this.jw.writeEol(type, " arr = new ", baseType + "[" + attr, ".size()]");
                }
                if (isScalar) {
                    this.jw.beginFor("int i = 0", "i < arr.length", "++i");
                    this.jw.write("arr[i] = ");
                    this.jw.write(JavaUtil.fromObject(baseType, attr + ".get(i)"));
                    this.jw.eol();
                    this.jw.end();
                    this.jw.write("return arr");
                } else {
                    this.gen("return (" + type + ") " + attr + ".toArray(arr)");
                }
            } else {
                this.gen("return " + attr);
            }
            this.eol();
            this.end();
            this.cr();
            if (indexed) {
                if (!this.config.isMinFeatures() && !isArrayStyle) {
                    this.gen(sigs.findSignature(GETTERLIST));
                    this.sp();
                    this.begin();
                    this.gen("return " + attr);
                    this.eol();
                    this.end();
                    this.cr();
                }
                this.gen(sigs.findSignature(GETTERINDEXED));
                this.sp();
                this.begin();
                this.jw.write("return ");
                if (isArrayStyle) {
                    this.jw.writeEol(attr, "[index]");
                } else {
                    this.jw.writeEol(JavaUtil.fromObject(baseType, attr + ".get(index)"));
                }
                this.end();
                this.cr();
                this.comment("Return the number of " + propertyName);
                this.gen(sigs.findSignature(SIZE));
                this.sp();
                this.begin();
                if (isArrayStyle) {
                    this.jw.writeEol("return ", attr, ".length");
                } else {
                    this.jw.writeEol("return ", attr, ".size()");
                }
                this.end();
                this.cr();
                if (!isArrayStyle) {
                    this.gen(sigs.findSignature(ADD));
                    this.sp();
                    this.begin();
                    if (a.getPropertyInterface() != null) {
                        this.jw.writeEol(baseType + " value = (" + baseType + ") valueInterface");
                    }
                    if (a.isBean && this.config.isGenerateParentRefs()) {
                        this.jw.beginIf("value != null");
                        this.jw.writeEol("value._setParent(this)");
                        this.jw.end();
                    }
                    if (a.isBean && this.config.isGeneratePropertyEvents()) {
                        this.jw.beginIf("value != null");
                        this.comment("Make the foreign beans take on our property change event listeners.");
                        this.geneol("value._setPropertyChangeSupport(eventListeners)");
                        if (this.config.isVetoable()) {
                            this.geneol("value._setVetoableChangeSupport(vetos)");
                        }
                        this.jw.end();
                    }
                    this.jw.writeEol(attr, ".add(", JavaUtil.toObject("value", baseType, this.config.isForME(), this.config.isJava5()), ")");
                    if (this.config.isKeepElementPositions()) {
                        int lastPropNum;
                        GraphLink gl = a.getGraphLink();
                        if (gl == null) {
                            lastPropNum = i;
                        } else {
                            AbstractCodeGeneratorClass.Property lastProp = (AbstractCodeGeneratorClass.Property)gl.getLastSibling().getObject();
                            if (lastProp == a) {
                                lastPropNum = i;
                            } else {
                                for (lastPropNum = 0; lastPropNum < size && this.attrList.get(lastPropNum) != lastProp; ++lastPropNum) {
                                }
                                if (lastPropNum == size) {
                                    this.jw.comment("Did not find lastPropNum");
                                    lastPropNum = i;
                                }
                            }
                        }
                        this.jw.writeEol("int pos = findLastOfElementType(" + lastPropNum + ")+1");
                        this.jw.writeEol("insertElementByPosition(pos, ", JavaUtil.toObject("value", baseType, this.config.isForME(), this.config.isJava5()), ", " + i + ")");
                    }
                    if (this.config.isGeneratePropertyEvents()) {
                        this.gen("if (");
                        if (this.config.isGenerateStoreEvents()) {
                            this.gen("storeEvents || ");
                        }
                        this.gen("eventListeners != null) ");
                        this.begin();
                        this.jw.write("java.beans.PropertyChangeEvent event = ");
                        this.genNewEvent(a, attr + ".size()-1", "null", "value", baseType);
                        this.jw.eol();
                        if (this.config.isVetoable()) {
                            this.gencr("if (vetos != null)");
                            this.tabIn();
                            this.geneol("vetos.fireVetoableChange(event)");
                        }
                        if (this.config.isGenerateStoreEvents()) {
                            this.gencr("if (storeEvents)");
                            this.tabIn();
                            this.geneol("storedEvents.add(event)");
                            this.gencr("else");
                            this.tabIn();
                        }
                        this.geneol("eventListeners.firePropertyChange(event)");
                        this.end();
                    }
                    this.jw.writeEol("int positionOfNewItem = " + attr + ".size()-1");
                    if (this.isMutuallyExclusive(a)) {
                        this.jw.beginIf("positionOfNewItem == 0");
                        this.genResetMutuallyExclusive(a, false);
                        this.jw.end();
                    }
                    this.genMadeChange();
                    this.geneol("return positionOfNewItem");
                    this.end();
                    this.cr();
                    this.jw.bigComment("Search from the end looking for @param value, and then remove it.");
                    this.gen(sigs.findSignature(REMOVE));
                    this.sp();
                    this.begin();
                    if (a.getPropertyInterface() != null) {
                        this.jw.writeEol(baseType + " value = (" + baseType + ") valueInterface");
                    }
                    this.jw.writeEol("int pos = ", attr, ".indexOf(", JavaUtil.toObject("value", baseType, this.config.isForME(), this.config.isJava5()) + ")");
                    this.gen("if (pos >= 0) ");
                    this.begin();
                    this.geneol(attr + ".remove(pos)");
                    if (this.config.isKeepElementPositions()) {
                        this.jw.writeEol("int elementPos = findElementType(" + i + ", pos)");
                        this.jw.writeEol("deleteElement(elementPos)");
                    }
                    if (this.config.isGeneratePropertyEvents()) {
                        this.gen("if (");
                        if (this.config.isGenerateStoreEvents()) {
                            this.gen("storeEvents || ");
                        }
                        this.gen("eventListeners != null) ");
                        this.begin();
                        this.gen("java.beans.PropertyChangeEvent event = ");
                        this.genNewEvent(a, "pos", "value", "null", baseType);
                        this.jw.eol();
                        if (this.config.isVetoable()) {
                            this.gencr("if (vetos != null)");
                            this.tabIn();
                            this.geneol("vetos.fireVetoableChange(event)");
                        }
                        if (this.config.isGenerateStoreEvents()) {
                            this.gencr("if (storeEvents)");
                            this.tabIn();
                            this.geneol("storedEvents.add(event)");
                            this.gencr("else");
                            this.tabIn();
                        }
                        this.geneol("eventListeners.firePropertyChange(event)");
                        this.end();
                    }
                    this.end();
                    this.genMadeChange();
                    this.geneol("return pos");
                    this.end();
                    this.cr();
                }
                MetaProperty mp = this.getMetaProperty(a.name);
                GraphNode graphNode = a.getGraphNode();
                SchemaRep.Key key = null;
                if (graphNode != null) {
                    key = (SchemaRep.Key)graphNode.searchExtraData(SchemaRep.Key.class);
                }
                if (a.isBean && (key != null || mp != null && mp.isKey())) {
                    this.config.messageOut.println("Found key: " + key);
                    SchemaRep.Selector selector = (SchemaRep.Selector)key.findSubElement(SchemaRep.Selector.class);
                    SchemaRep.Field field = (SchemaRep.Field)key.findSubElement(SchemaRep.Field.class);
                    this.genFinder(a, graphNode, attr, key.getElementName(), baseType, a.name, selector.getXPath(), field.getXPath(), false);
                }
            }
            this.genDefaultsAccessable(a);
            if (!a.isBean || a.getBeanElement().isAbstract) continue;
            this.genNewMethod(a.getPropertyInterface(), baseType, this.getTypeFullClassName(a));
        }
        if (this.config.isKeepElementPositions()) {
            this.select(this.DECL_SECTION);
            this.jw.writeEol("private java.lang.Object[] elementsByPosition = new java.lang.Object[0]");
            this.jw.writeEol("private int[] elementTypesByPosition = new int[0]");
        }
        if (this.beanElement.isRoot && !this.config.isMinFeatures()) {
            this.select(this.DECL_SECTION);
            this.jw.write("private java.lang.String schemaLocation");
            if (this.mdd.getSchemaLocation() != null) {
                this.jw.write(" = ");
                this.jw.write(JavaUtil.instanceFrom("java.lang.String", this.mdd.getSchemaLocation()));
            }
            this.jw.eol();
            this.select(this.ACCESS_SECTION);
            this.jw.beginMethod("_setSchemaLocation", "String location", null, "void", 0);
            this.jw.writeEol("schemaLocation = location");
            this.genMadeChange();
            this.jw.end();
            this.jw.cr();
            this.jw.beginMethod("_getSchemaLocation", "", null, "String", 0);
            this.jw.writeEol("return schemaLocation");
            this.jw.endMethod();
        }
        if (this.config.isGenerateParentRefs()) {
            this.select(this.DECL_SECTION);
            String parentType = this.parentBeanType();
            this.jw.writeEol("private ", parentType, " parent");
            this.select(this.BODY_SECTION);
            this.jw.beginMethod("_setParent", parentType + " parent");
            this.jw.writeEol("this.parent = parent");
            this.jw.endMethod();
            this.jw.beginMethod("_getXPathExpr", "", null, "String", 0);
            this.jw.beginIf("parent == null");
            this.jw.writeEol("return \"/", this.beanElement.node.getName(), "\"");
            this.jw.endElseBegin();
            this.jw.writeEol("String parentXPathExpr = parent._getXPathExpr()");
            this.jw.writeEol("String myExpr = parent.nameChild(this, false, false, true)");
            this.jw.writeEol("return parentXPathExpr + \"/\" + myExpr");
            this.jw.end();
            this.jw.endMethod();
            this.jw.beginMethod("_getXPathExpr", "Object childObj", null, "String", 0);
            this.jw.writeEol("String childName = nameChild(childObj, false, false, true)");
            this.jw.beginIf("childName == null");
            this.jw.writeEol("throw new IllegalArgumentException(\"childObj (\"+childObj.toString()+\") is not a child of this bean (" + this.className + ").\")");
            this.jw.end();
            this.jw.writeEol("return _getXPathExpr() + \"/\" + childName");
            this.jw.endMethod();
        }
        Iterator it = this.beanElement.getGraphNode().extraDataIterator();
        while (it.hasNext()) {
            Object data = it.next();
            if (!(data instanceof BeanBuilder.Finder)) continue;
            BeanBuilder.Finder finder = (BeanBuilder.Finder)data;
            this.genFinder(this.beanElement.getGraphNode(), finder);
        }
    }

    protected void genFinder(GraphNode startingGraphNode, BeanBuilder.Finder finder) throws IOException {
        this.genFinder(startingGraphNode, finder.getFindExpr(), finder.getByExpr(), finder.isListFindExpr());
    }

    protected void genFinder(GraphNode startingGraphNode, String selectorXPath, String fieldXPath, boolean isListFindExpr) throws IOException {
        this.genFinder(null, startingGraphNode, null, null, null, null, selectorXPath, fieldXPath, isListFindExpr);
    }

    protected void genFinder(AbstractCodeGeneratorClass.Property a, GraphNode startingGraphNode, String attr, String keyName, String returnType, String nameToFind, String selectorXPath, String fieldXPath, boolean isListFindExpr) throws IOException {
        String topVar;
        String lastVar;
        String dtdName = null;
        String keyVar = null;
        String keyType = null;
        String keyTypeInterface = null;
        LinkedList<GraphLink> xpathChain = null;
        GraphNode graphNode = startingGraphNode;
        AbstractCodeGeneratorClass.Property selectorProp = null;
        if (graphNode != null && graphNode.getGraphLink() != null) {
            xpathChain = new LinkedList<GraphLink>();
            GraphLink gl = null;
            GraphLink.XPathIterator it = graphNode.getGraphLink().xPathIterator(selectorXPath);
            while (it.hasNext() && (gl = (GraphLink)it.next()) != null) {
                if (gl.getObject() == null) continue;
                xpathChain.add(gl);
            }
            if (gl != null) {
                GraphLink nextStartingLink = gl.element != null ? gl.element.getGraphLink() : gl;
                selectorProp = (AbstractCodeGeneratorClass.Property)gl.getObject();
                if (!fieldXPath.equals(".")) {
                    GraphLink.XPathIterator it2 = nextStartingLink.xPathIterator(fieldXPath);
                    while (it2.hasNext() && (gl = (GraphLink)it2.next()) != null) {
                        if (gl.getObject() == null) continue;
                        xpathChain.add(gl);
                    }
                }
                if (gl != null) {
                    AbstractCodeGeneratorClass.Property finalProp = (AbstractCodeGeneratorClass.Property)gl.getObject();
                    if (finalProp != null) {
                        dtdName = finalProp.dtdName;
                        keyVar = finalProp.instanceOf() + "Key";
                        keyType = finalProp.getType();
                        keyTypeInterface = finalProp.getPropertyInterface();
                    } else {
                        this.config.messageOut.println("Warning: finalProp=null while generating finder.");
                    }
                }
            }
            if (gl == null) {
                xpathChain = null;
            }
        }
        if (dtdName == null) {
            dtdName = fieldXPath;
            keyVar = Common.convertNameInstance(dtdName);
            keyType = "String";
            this.jw.comment("Did not figure out proper expression to find the key.  This method may not work.");
            this.jw.comment("selectorXPath=" + selectorXPath);
            if (selectorProp == null) {
                this.jw.comment("  Failed to find selector.");
            } else {
                this.jw.comment("  found selector property name=" + selectorProp.dtdName);
            }
            this.jw.comment("fieldXPath=" + fieldXPath);
            xpathChain = null;
        }
        if (selectorProp != null) {
            if (nameToFind == null) {
                nameToFind = Common.convertName(selectorProp.dtdName);
            }
            if (returnType == null) {
                returnType = selectorProp.getPropertyInterface() == null ? selectorProp.getType() : selectorProp.getPropertyInterface();
            }
        }
        if (keyName == null) {
            keyName = fieldXPath;
        }
        if (returnType == null) {
            returnType = "String";
        }
        if (isListFindExpr) {
            returnType = "java.util.List/*<" + returnType + ">*/";
            this.jw.bigComment("Search for the key.\n@return all elements found that match.");
        } else {
            this.jw.bigComment("Search for the key.\n@return  null if the key is not found.");
        }
        String methodName = isListFindExpr ? "findAll" + nameToFind : "find" + nameToFind;
        if (!keyName.equals(".")) {
            methodName = methodName + "By" + Common.convertName(keyName);
        }
        String arguments = keyTypeInterface == null ? keyType + " " + keyVar : keyTypeInterface + " " + keyVar + "Interface";
        this.jw.beginMethod(methodName, arguments, null, returnType, 0 | 0x100);
        if (keyTypeInterface != null) {
            this.jw.writeEol(keyVar, " = (" + keyType, ") ", keyVar + "Interface");
        }
        if (isListFindExpr) {
            this.jw.writeEol("java.util.List _result = new java.util.ArrayList()");
        }
        if (attr != null) {
            this.beginAttrIterator(attr, a, "_el");
            this.jw.beginIf("_el == null");
            this.jw.writeEol("continue");
            this.jw.end();
            lastVar = "_el";
            topVar = "_el";
        } else {
            lastVar = "this";
            topVar = "null";
        }
        if (xpathChain != null) {
            GraphLink gl = null;
            int foundIndices = 0;
            Iterator it = xpathChain.iterator();
            while (it.hasNext()) {
                gl = (GraphLink)it.next();
                AbstractCodeGeneratorClass.Property prop = (AbstractCodeGeneratorClass.Property)gl.getObject();
                String var = prop.instanceOf() + foundIndices;
                if (attr == null && selectorProp == prop) {
                    topVar = var;
                }
                if (prop.isIndexed()) {
                    ++foundIndices;
                    this.jw.beginFor("int " + var + "Index = 0", var + "Index < " + lastVar + ".size" + prop.name + "()", var + "Index++");
                }
                this.jw.write(prop.getType() + " " + var);
                this.jw.write(" = (", prop.getType(), ") ");
                this.jw.write(lastVar, ".");
                this.jw.write(prop.getReadMethod(prop.isIndexed()));
                if (prop.isIndexed()) {
                    this.jw.write("(" + var + "Index)");
                } else {
                    this.jw.write("()");
                }
                this.jw.eol();
                this.jw.beginIf(var + " == null");
                if (!it.hasNext()) {
                    this.jw.beginIf(keyVar, " == null");
                    if (isListFindExpr) {
                        this.jw.writeEol("_result.add(", topVar, ")");
                    } else {
                        this.jw.writeEol("return ", topVar);
                    }
                    this.jw.end();
                }
                this.jw.writeEol("continue");
                this.jw.end();
                lastVar = var;
            }
            this.jw.beginIf(lastVar + ".equals(" + keyVar + ")");
            if (isListFindExpr) {
                this.jw.writeEol("_result.add(", topVar, ")");
            } else {
                this.jw.writeEol("return ", topVar);
            }
            this.jw.end();
            while (foundIndices > 0) {
                this.jw.end();
                --foundIndices;
            }
        }
        if (attr != null) {
            this.jw.end();
        }
        if (isListFindExpr) {
            this.jw.writeEol("return _result");
        } else {
            this.jw.writeEol("return ", JavaUtil.nullValueForType(returnType));
        }
        this.jw.endMethod();
    }

    public void genXMLIO() throws IOException {
        this.select(this.BODY_SECTION);
        String beanName = this.beanElement.node.getName();
        if (this.beanElement.isRoot) {
            if (!this.config.isStandalone()) {
                this.jw.beginMethod("write", "org.openide.filesystems.FileObject fo", "java.io.IOException", "void", 0 | 0x200);
                this.jw.writeEol("org.openide.filesystems.FileLock lock = fo.lock()");
                this.jw.beginTry();
                this.jw.writeEol("java.io.OutputStream out = fo.getOutputStream(lock)");
                this.jw.writeEol("write(out)");
                this.jw.writeEol("out.close()");
                this.jw.endFinallyBegin();
                this.jw.writeEol("lock.releaseLock()");
                this.jw.end();
                this.jw.endMethod();
                this.jw.beginMethod("write", "final org.openide.filesystems.FileObject dir, final String filename", "java.io.IOException", "void", 0 | 0x200);
                this.jw.writeEol("org.openide.filesystems.FileSystem fs = dir.getFileSystem()");
                this.jw.write("fs.runAtomicAction(new org.openide.filesystems.FileSystem.AtomicAction()\n");
                this.jw.begin();
                this.jw.write("public void run() throws java.io.IOException {\n");
                this.jw.writeEol("org.openide.filesystems.FileObject file = dir.getFileObject(filename)");
                this.jw.beginIf("file == null");
                this.jw.writeEol("file = dir.createData(filename)");
                this.jw.end();
                this.jw.writeEol("write(file)");
                this.jw.end();
                this.jw.end();
                this.jw.writeEol(")");
                this.jw.endMethod();
            }
            this.jw.beginMethod("write", "java.io.File f", "java.io.IOException", "void", 0 | 0x200);
            this.jw.writeEol("java.io.OutputStream out = new java.io.FileOutputStream(f)");
            this.jw.beginTry();
            this.jw.writeEol("write(out)");
            this.jw.endFinallyBegin();
            this.jw.writeEol("out.close()");
            this.jw.end();
            this.jw.endMethod();
            this.jw.beginMethod("write", "java.io.OutputStream out", "java.io.IOException", "void", 0 | 0x200);
            this.geneol("write(out, null)");
            this.jw.endMethod();
            this.jw.beginMethod("write", "java.io.OutputStream out, String encoding", "java.io.IOException", "void", 0 | 0x200);
            this.geneol("java.io.Writer w");
            this.jw.beginIf("encoding == null");
            this.gen("encoding = \"UTF-8\"");
            this.eolNoI18N();
            this.end();
            this.gen("w = new java.io.BufferedWriter(new java.io.OutputStreamWriter(out, encoding))");
            this.eol();
            this.geneol("write(w, encoding)");
            this.geneol("w.flush()");
            this.jw.endMethod();
            this.jw.bigComment("Print this Java Bean to @param out including an XML header.\n@param encoding is the encoding style that @param out was opened with.");
            this.jw.beginMethod("write", "java.io.Writer out, String encoding", "java.io.IOException", "void", 0 | 0x200);
            this.gen("out.write(\"<?xml version='1.0'\")");
            this.eolNoI18N();
            this.gen("if (encoding != null)");
            this.cr();
            this.tabIn();
            this.gen("out.write(\" encoding='\"+encoding+\"'\")");
            this.eolNoI18N();
            this.gen("out.write(\" ?>\\n\")");
            this.eolNoI18N();
            if (this.config.isProcessDocType()) {
                this.jw.beginIf("docType != null");
                this.jw.writeEol("out.write(docType.toString())");
                this.jw.writeEol("out.write(\"\\n\")");
                this.jw.end();
            }
            this.jw.write("writeNode(out, \"", beanName, "\", \"\")");
            this.eolNoI18N();
            this.jw.endMethod();
        }
        this.jw.beginMethod("writeNode", "java.io.Writer out", "java.io.IOException", "void", 0 | 0x200);
        this.jw.writeEol("String myName");
        if (this.config.isGenerateParentRefs()) {
            this.jw.beginIf("parent == null");
        }
        this.jw.writeEol("myName = \"", beanName, "\"");
        if (this.config.isGenerateParentRefs()) {
            this.jw.endElseBegin();
            this.jw.writeEol("myName = parent.nameChild(this, false, true)");
            this.jw.beginIf("myName == null");
            this.jw.writeEol("myName = \"", beanName, "\"");
            this.jw.end();
            this.jw.end();
        }
        this.jw.write("writeNode(out, myName, \"\")");
        this.eolNoI18N();
        this.jw.endMethod();
        this.jw.beginMethod("writeNode", "java.io.Writer out, String nodeName, String indent", "java.io.IOException", "void", 0 | 0x200);
        this.jw.write("writeNode(out, nodeName, null, indent, new java.util.HashMap");
        if (this.config.jdkTarget >= 150) {
            this.jw.write("<String, String>");
        }
        this.jw.writeEol("())");
        this.jw.endMethod();
        this.jw.bigComment("It's not recommended to call this method directly.");
        String writeNodeArgs = "java.io.Writer out, String nodeName, String namespace, String indent, java.util.Map";
        if (this.config.jdkTarget >= 150) {
            writeNodeArgs = writeNodeArgs + "<String, String>";
        }
        writeNodeArgs = writeNodeArgs + " namespaceMap";
        this.jw.beginMethod("writeNode", writeNodeArgs, "java.io.IOException", "void", 0 | 0x200 | 0x400);
        int size = this.attrList.size();
        HashMap<String, String> namespaceToPrefixTable = new HashMap<String, String>();
        this.geneol("out.write(indent)");
        this.outWrite("<");
        this.jw.beginIf("namespace != null");
        this.jw.writeEol("out.write((String)namespaceMap.get(namespace))");
        this.outWrite(":");
        this.jw.end();
        this.geneol("out.write(nodeName)");
        if (this.beanElement.isRoot && this.getDefaultNamespace() != null) {
            this.jw.writeEolNoI18N("out.write(\" xmlns='\")");
            this.jw.writeEolNoI18N("out.write(" + JavaUtil.instanceFrom("java.lang.String", this.getDefaultNamespace()) + ")");
            this.jw.writeEolNoI18N("out.write(\"'\")");
        }
        if (this.beanElement.isRoot) {
            this.jw.beginIf("schemaLocation != null");
            this.jw.writeEol("namespaceMap.put(\"http://www.w3.org/2001/XMLSchema-instance\", \"xsi\")");
            namespaceToPrefixTable.put("http://www.w3.org/2001/XMLSchema-instance", "xsi");
            this.jw.writeEol("out.write(\" xmlns:xsi='http://www.w3.org/2001/XMLSchema-instance' xsi:schemaLocation='\")");
            this.jw.writeEol("out.write(schemaLocation)");
            this.jw.writeEolNoI18N("out.write(\"'\")");
            this.jw.end();
        }
        boolean firstNS = true;
        for (int i = 0; i < size; ++i) {
            String prefix;
            String type;
            AbstractCodeGeneratorClass.Property a = (AbstractCodeGeneratorClass.Property)this.attrList.get(i);
            boolean indexed = a.isIndexed();
            String attr = "_" + a.name;
            String baseType = type = a.getType().intern();
            if (indexed) {
                type = (baseType + "[]").intern();
            }
            if (this.isTypeQName(baseType)) {
                if (firstNS) {
                    firstNS = false;
                    this.jw.comment("Work out any namespaces.");
                    this.jw.writeEol("boolean firstNSAddition = true");
                }
                if (indexed) {
                    this.beginAttrIterator(attr, a, "element");
                    attr = "element";
                }
                this.jw.beginIf(attr + " != null && " + attr + ".getNamespaceURI() != null && !\"\".equals(", attr, ".getNamespaceURI())");
                this.jw.writeEol("String prefix = (String) namespaceMap.get(", attr, ".getNamespaceURI())");
                this.jw.beginIf("prefix == null || \"\".equals(prefix)");
                this.jw.writeEol("prefix = ", attr, ".getPrefix()");
                this.jw.beginIf("prefix == null || \"\".equals(prefix)");
                this.jw.writeEol("prefix = \"", a.dtdName, "_ns__\"");
                this.jw.end();
                this.jw.comment("Need to make sure it's a unique prefix too.");
                this.jw.writeEol("boolean changed");
                this.jw.write("do ");
                this.jw.begin();
                this.jw.writeEol("changed = false");
                this.jw.beginFor("java.util.Iterator valueIt = namespaceMap.values().iterator()", "valueIt.hasNext()", "");
                this.jw.writeEol("String otherPrefix = (String) valueIt.next()");
                this.jw.beginIf("prefix.equals(otherPrefix)");
                this.jw.writeEol("prefix += \"_\"");
                this.jw.writeEol("changed = true");
                this.jw.end();
                this.jw.end();
                this.jw.end(false);
                this.jw.writeEol(" while (changed)");
                this.jw.beginIf("firstNSAddition");
                this.jw.writeEol("firstNSAddition = false");
                this.jw.comment("Copy on write");
                this.jw.writeEol("namespaceMap = new java.util.HashMap(namespaceMap)");
                this.jw.end();
                this.jw.writeEol("namespaceMap.put(", attr, ".getNamespaceURI(), prefix)");
                this.jw.writeEol("out.write(\" xmlns:\")");
                this.jw.writeEol("out.write(prefix)");
                this.jw.writeEol("out.write(\"='\")");
                this.jw.writeEol("out.write(", attr, ".getNamespaceURI())");
                this.jw.writeEol("out.write(\"'\")");
                this.jw.end();
                this.jw.end();
                if (!indexed) continue;
                this.jw.end();
                continue;
            }
            if (a.getNamespace() == null || a.getNamespace().equals(this.getDefaultNamespace()) || a.getNamespace().equals("http://www.w3.org/XML/1998/namespace") || namespaceToPrefixTable.containsKey(a.getNamespace())) continue;
            if (firstNS) {
                firstNS = false;
                this.jw.comment("Work out any namespaces.");
                this.jw.writeEol("boolean firstNSAddition = true");
            }
            if ((prefix = SchemaRep.prefixOf(a.dtdName)) == null) {
                prefix = this.prefixGuesser.guessPrefixFromURI(a.getNamespace());
            }
            this.jw.beginIf("namespaceMap.get(", JavaUtil.instanceFrom("String", a.getNamespace()), ") == null");
            this.jw.beginIf("firstNSAddition");
            this.jw.writeEol("firstNSAddition = false");
            this.jw.comment("Copy on write");
            this.jw.write("namespaceMap = new java.util.HashMap");
            if (this.config.jdkTarget >= 150) {
                this.jw.write("<String, String>");
            }
            this.jw.writeEol("(namespaceMap)");
            this.jw.end();
            this.jw.writeEol("namespaceMap.put(", JavaUtil.instanceFrom("String", a.getNamespace()), ", \"", prefix + "\")");
            this.outWrite(" xmlns:" + prefix + "='");
            this.outWrite(a.getNamespace());
            this.outWrite("'");
            this.jw.end();
            namespaceToPrefixTable.put(a.getNamespace(), prefix);
        }
        LinkedList<AbstractCodeGeneratorClass.Property> directAttributes = new LinkedList<AbstractCodeGeneratorClass.Property>();
        LinkedList<AbstractCodeGeneratorClass.Property> nonDirectAttributes = new LinkedList<AbstractCodeGeneratorClass.Property>();
        boolean hasSubElements = false;
        if (size > 0) {
            for (int i = 0; i < size; ++i) {
                AbstractCodeGeneratorClass.Property a = (AbstractCodeGeneratorClass.Property)this.attrList.get(i);
                if (!a.isAttribute()) {
                    hasSubElements = true;
                    continue;
                }
                if (!a.isDirectChild()) {
                    nonDirectAttributes.add(a);
                    continue;
                }
                directAttributes.add(a);
            }
        }
        this.jw.writeEol("writeNodeAttributes(out, nodeName, namespace, indent, namespaceMap)");
        if (hasSubElements) {
            this.geneol("out.write(\">\\n\")");
        }
        this.jw.writeEol("writeNodeChildren(out, nodeName, namespace, indent, namespaceMap)");
        if (hasSubElements) {
            this.geneol("out.write(indent)");
            this.outWrite("</");
            this.jw.beginIf("namespace != null");
            this.jw.writeEol("out.write((String)namespaceMap.get(namespace))");
            this.outWrite(":");
            this.jw.end();
            this.jw.writeEol("out.write(nodeName)");
            this.outWrite(">\n");
        } else {
            this.geneol("out.write(\"/>\\n\")");
        }
        this.jw.endMethod();
        this.jw.beginMethod("writeNodeAttributes", writeNodeArgs, "java.io.IOException", "void", 1 | 0x200 | 0x400);
        for (AbstractCodeGeneratorClass.Property prop : directAttributes) {
            this.genWriteAttr(prop);
        }
        if (this.config.isRespectExtension() && this.beanElement.getExtension() != null) {
            this.comment("extension is: " + this.beanElement.getExtension());
            this.jw.writeEol("super.writeNodeAttributes(out, nodeName, namespace, indent, namespaceMap)");
        }
        this.jw.endMethod();
        this.jw.beginMethod("writeNodeChildren", writeNodeArgs, "java.io.IOException", "void", 1 | 0x200 | 0x400);
        if (this.config.isRespectExtension() && this.beanElement.getExtension() != null) {
            this.jw.writeEol("super.writeNodeChildren(out, nodeName, namespace, indent, namespaceMap)");
        }
        if (hasSubElements) {
            this.geneol("String nextIndent = indent + \"" + this.jw.getIndent() + "\"");
            if (this.config.isKeepElementPositions()) {
                this.jw.beginFor("int position = 0, count = fetchChildCount()", "position < count", "++position");
                this.jw.writeEol("java.lang.Object child = elementsByPosition[position]");
                this.jw.writeEol("int elementType = elementTypesByPosition[position]");
                this.jw.write("switch (elementType) ");
                this.jw.begin();
            }
            boolean firstUseOfIndex = true;
            for (int i = 0; i < size; ++i) {
                String type;
                String attr;
                AbstractCodeGeneratorClass.Property a = (AbstractCodeGeneratorClass.Property)this.attrList.get(i);
                if (a.isAttribute()) continue;
                boolean indexed = a.isIndexed();
                String baseAttr = attr = "_" + a.name;
                boolean isScalar = a.isScalar();
                boolean isNamespaceSignificant = a.getNamespace() != null && !a.getNamespace().equals(this.getDefaultNamespace()) && !a.getNamespace().equals("http://www.w3.org/XML/1998/namespace");
                String baseType = type = a.getType().intern();
                if (indexed) {
                    type = (baseType + "[]").intern();
                }
                if (this.config.isKeepElementPositions()) {
                    this.jw.writecr("case " + i + ":");
                    this.jw.indentRight();
                    this.jw.writeEol(baseType + " a" + a.name + " = " + JavaUtil.fromObject(baseType, "child"));
                    attr = "a" + a.name;
                } else {
                    if (indexed) {
                        if (!a.isBean && a.attributes != null && a.attributes.length > 0) {
                            if (firstUseOfIndex) {
                                firstUseOfIndex = false;
                                this.jw.writeEol("int index = 0");
                            } else {
                                this.jw.writeEol("index = 0");
                            }
                        }
                        this.beginAttrIterator(attr, a, "element");
                        attr = "element";
                    }
                    if (!isScalar) {
                        this.jw.beginIf(attr, " != null");
                    } else if (!indexed && this.config.isOptionalScalars() && isScalar) {
                        this.jw.beginIf(a.getScalarIsSet());
                    }
                }
                if (a.isBean) {
                    this.jw.write(attr, ".writeNode(out, \"", a.dtdName);
                    this.jw.write("\", ");
                    if (isNamespaceSignificant) {
                        this.jw.write(JavaUtil.instanceFrom("String", a.getNamespace()));
                    } else {
                        this.jw.write("null");
                    }
                    this.jw.writeEol(", nextIndent, namespaceMap)");
                } else if (a.type == 3840) {
                    this.jw.writeEol("out.write(nextIndent)");
                    this.jw.writeEol("out.write(\"<!--\")");
                    this.jw.writeEol("out.write(", attr, ")");
                    this.jw.writeEol("out.write(\"-->\\n\")");
                } else if ("org.w3c.dom.Element".equals(type)) {
                    this.jw.writeEol("out.write(nextIndent)");
                    if (this.config.isUseRuntime()) {
                        this.jw.writeEol("org.netbeans.modules.schema2beans.XMLUtil.DOMWriter domWriter = new org.netbeans.modules.schema2beans.XMLUtil.DOMWriter()");
                        this.jw.writeEol("domWriter.setWriter(out)");
                        this.jw.writeEol("domWriter.write(", attr, ")");
                    } else {
                        this.jw.writeEol("out.write(", attr, ".toString())");
                    }
                    this.outWrite("\n");
                } else {
                    boolean needEndTag = true;
                    if (baseType == "boolean" && a.getCanBeEmpty()) {
                        this.jw.beginIf(attr);
                        needEndTag = false;
                    }
                    if (!a.dtdName.equals("#PCDATA")) {
                        this.jw.writeEol("out.write(nextIndent)");
                        if (isNamespaceSignificant) {
                            this.outWrite("<");
                            this.jw.writeEol("out.write((String)namespaceMap.get(", JavaUtil.instanceFrom("String", a.getNamespace()), "))");
                            this.jw.write("out.write(\":", a.dtdName, "\")");
                        } else {
                            this.jw.write("out.write(\"<", a.dtdName, "\")");
                        }
                        this.eolNoI18N();
                        if (this.isTypeQName(baseType)) {
                            this.jw.writeEol("String nsPrefix", attr, " = null");
                            this.jw.beginIf(attr + ".getNamespaceURI() != null && !\"\".equals(", attr, ".getNamespaceURI())");
                            this.jw.write("nsPrefix", attr, " = (String) namespaceMap.get(");
                            this.jw.writeEol(attr, ".getNamespaceURI())");
                            this.jw.end();
                        }
                        for (int attrNum = 0; attrNum < a.attributes.length; ++attrNum) {
                            AttrProp myAttrProp = a.attributes[attrNum];
                            for (AbstractCodeGeneratorClass.Property attrProperty : nonDirectAttributes) {
                                String varName;
                                AttrProp attrProp = attrProperty.getAttrProp();
                                if (myAttrProp != attrProp) continue;
                                if (attrProperty.isIndexed()) {
                                    this.jw.beginIf("index < size" + attrProperty.name + "()");
                                    varName = attrProperty.getReadMethod(true) + "(index)";
                                } else {
                                    varName = "_" + attrProperty.name;
                                }
                                this.genWriteAttr(attrProperty, varName);
                                if (!attrProperty.isIndexed()) continue;
                                this.jw.end();
                            }
                        }
                        if (needEndTag) {
                            this.gen("out.write(\">\")");
                            this.eolNoI18N();
                        }
                    }
                    if (needEndTag) {
                        this.genWriteType(a, attr, false);
                    }
                    if (!needEndTag) {
                        this.gen("out.write(\"/>\\n\")");
                        this.eolNoI18N();
                        this.end();
                    } else if (!a.dtdName.equals("#PCDATA")) {
                        if (isNamespaceSignificant) {
                            this.outWrite("</");
                            this.jw.writeEol("out.write((String)namespaceMap.get(", JavaUtil.instanceFrom("String", a.getNamespace()), "))");
                            this.jw.write("out.write(\":", a.dtdName, ">\\n\")");
                        } else {
                            this.jw.write("out.write(\"</" + a.dtdName, ">\\n\")");
                        }
                        this.eolNoI18N();
                    }
                }
                if (this.config.isKeepElementPositions()) {
                    this.jw.writeEol("break");
                    this.jw.indentLeft();
                    continue;
                }
                if (a.isNillable() && !isScalar) {
                    this.jw.endElseBegin();
                    this.jw.writeEol("out.write(nextIndent)");
                    this.jw.writeEol("out.write(\"<", a.dtdName, " xmlns:xsi='http://www.w3.org/2001/XMLSchema-instance' xsi:nil='true'/>\\n\")");
                }
                if (!isScalar || !indexed && this.config.isOptionalScalars() && isScalar) {
                    this.end();
                }
                if (!indexed) continue;
                if (!a.isBean && a.attributes != null && a.attributes.length > 0) {
                    this.jw.writeEol("++index");
                }
                this.end();
            }
            if (this.config.isKeepElementPositions()) {
                this.jw.end();
                this.jw.end();
            }
        }
        this.jw.endMethod();
        if (this.beanElement.isRoot) {
            String exceps = "javax.xml.parsers.ParserConfigurationException, org.xml.sax.SAXException, java.io.IOException";
            if (this.config.isVetoable()) {
                exceps = exceps + ", java.beans.PropertyVetoException";
            }
            if (!this.config.isStandalone()) {
                this.jw.beginMethod("read", "org.openide.filesystems.FileObject fo", exceps, this.className, 0 | 0x10 | 0x200);
                this.jw.writeEol("java.io.InputStream in = fo.getInputStream()");
                this.jw.beginTry();
                this.jw.writeEol("return read(in)");
                this.jw.endFinallyBegin();
                this.jw.writeEol("in.close()");
                this.jw.end();
                this.jw.endMethod();
            }
            this.jw.beginMethod("read", "java.io.File f", exceps, this.className, 0 | 0x10 | 0x200);
            this.jw.writeEol("java.io.InputStream in = new java.io.FileInputStream(f)");
            this.jw.beginTry();
            this.jw.writeEol("return read(in)");
            this.jw.endFinallyBegin();
            this.jw.writeEol("in.close()");
            this.jw.end();
            this.jw.endMethod();
            this.jw.beginMethod("read", "java.io.InputStream in", exceps, this.className, 0 | 0x10 | 0x200);
            this.geneol("return read(new org.xml.sax.InputSource(in), false, null, null)");
            this.end();
            this.cr();
            this.jw.bigComment("Warning: in readNoEntityResolver character and entity references will\nnot be read from any DTD in the XML source.\nHowever, this way is faster since no DTDs are looked up\n(possibly skipping network access) or parsed.");
            this.jw.beginMethod("readNoEntityResolver", "java.io.InputStream in", exceps, this.className, 0 | 0x10 | 0x200);
            this.gencr("return read(new org.xml.sax.InputSource(in), false,");
            this.tabIn();
            this.gen("new org.xml.sax.EntityResolver() ");
            this.begin();
            this.gen("public org.xml.sax.InputSource resolveEntity(String publicId, String systemId) ");
            this.begin();
            this.geneol("java.io.ByteArrayInputStream bin = new java.io.ByteArrayInputStream(new byte[0])");
            this.geneol("return new org.xml.sax.InputSource(bin)");
            this.end();
            this.end();
            this.tabIn();
            this.geneol(", null)");
            this.end();
            this.cr();
            this.jw.beginMethod("read", "org.xml.sax.InputSource in, boolean validate, org.xml.sax.EntityResolver er, org.xml.sax.ErrorHandler eh", exceps, this.className, 0 | 0x10 | 0x200);
            this.geneol("javax.xml.parsers.DocumentBuilderFactory dbf = javax.xml.parsers.DocumentBuilderFactory.newInstance()");
            this.geneol("dbf.setValidating(validate)");
            this.geneol("dbf.setNamespaceAware(true)");
            this.geneol("javax.xml.parsers.DocumentBuilder db = dbf.newDocumentBuilder()");
            this.gen("if (er != null)");
            this.tabIn();
            this.geneol("db.setEntityResolver(er)");
            this.gen("if (eh != null)");
            this.tabIn();
            this.geneol("db.setErrorHandler(eh)");
            this.geneol("org.w3c.dom.Document doc = db.parse(in)");
            this.geneol("return read(doc)");
            this.end();
            this.cr();
            exceps = null;
            if (this.config.isVetoable()) {
                exceps = "java.beans.PropertyVetoException";
            }
            this.jw.beginMethod("read", "org.w3c.dom.Document document", exceps, this.className, 0 | 0x10 | 0x200);
            this.jw.writeEol(this.className, " a", this.className, " = new " + this.className + "()");
            this.jw.writeEol("a", this.className, ".readFromDocument(document)");
            this.jw.writeEol("return a", this.className);
            this.jw.endMethod();
            this.jw.beginMethod("readFromDocument", "org.w3c.dom.Document document", exceps, "void", 1);
            if (this.config.isProcessDocType()) {
                String fullDocTypeName = this.packageName == null ? this.className + ".DocType" : this.packageName + "." + this.className + ".DocType";
                this.jw.writeEol("org.w3c.dom.NodeList children = document.getChildNodes()");
                this.jw.writeEol("int length = children.getLength()");
                this.jw.beginFor("int i = 0", "i < length", "++i");
                this.jw.beginIf("children.item(i) instanceof org.w3c.dom.DocumentType");
                this.jw.writeEol("docType = new " + fullDocTypeName + "((org.w3c.dom.DocumentType)children.item(i))");
                this.jw.writeEol("break");
                this.jw.end();
                this.jw.end();
            }
            this.geneol("readNode(document.getDocumentElement())");
            this.end();
            this.cr();
        }
        if (this.beanElement.isRoot) {
            this.jw.write("protected static class ReadState ");
            this.jw.begin();
            this.jw.writeEol("int lastElementType");
            this.jw.writeEol("int elementPosition");
            this.jw.end();
            this.jw.cr();
        }
        this.jw.beginMethod("readNode", "org.w3c.dom.Node node", this.config.isVetoable() ? "java.beans.PropertyVetoException" : null, "void", 0 | 0x200);
        this.jw.write("readNode(node, new java.util.HashMap");
        if (this.config.jdkTarget >= 150) {
            this.jw.write("<String, String>");
        }
        this.jw.writeEol("())");
        this.jw.endMethod();
        String namespacePrefixesFormalParameter = this.config.jdkTarget >= 150 ? "java.util.Map<String, String> namespacePrefixes" : "java.util.Map namespacePrefixes";
        String readNodeArgs = "org.w3c.dom.Node node, " + namespacePrefixesFormalParameter;
        this.jw.beginMethod("readNode", readNodeArgs, this.config.isVetoable() ? "java.beans.PropertyVetoException" : null, "void", 0 | 0x200);
        this.beginAttrProcessing("node");
        this.jw.writeEol("boolean firstNamespaceDef = true");
        this.genUpdateNamespaces("namespacePrefixes", "firstNamespaceDef");
        int attrCount = 0;
        if (this.beanElement.isRoot) {
            ++attrCount;
            this.jw.writeEol("String xsiPrefix = \"xsi\"");
            this.jw.beginFor("java.util.Iterator it = namespacePrefixes.entrySet().iterator()", "it.hasNext()", "");
            this.jw.writeEol("java.util.Map.Entry entry = (java.util.Map.Entry) it.next()");
            this.jw.writeEol("String prefix = (String) entry.getKey()");
            this.jw.writeEol("String ns = (String) entry.getValue()");
            this.jw.beginIf("\"http://www.w3.org/2001/XMLSchema-instance\".equals(ns)");
            this.jw.writeEol("xsiPrefix = prefix");
            this.jw.writeEol("break");
            this.jw.end();
            this.jw.end();
            this.genReadAttr("schemaLocation", "String", "\"+xsiPrefix+\":schemaLocation", "node", null, false, null, false, null);
        }
        this.jw.writeEol("readNodeAttributes(node, namespacePrefixes, attrs)");
        this.jw.end();
        this.jw.writeEol("readNodeChildren(node, namespacePrefixes)");
        this.jw.endMethod();
        this.jw.beginMethod("readNodeAttributes", readNodeArgs + ", org.w3c.dom.NamedNodeMap attrs", this.config.isVetoable() ? "java.beans.PropertyVetoException" : null, "void", 1 | 0x200);
        if (this.config.isRespectExtension() && this.beanElement.getExtension() != null) {
            this.jw.writeEol("super.readNodeAttributes(node, namespacePrefixes, attrs)");
        }
        this.jw.writeEol("org.w3c.dom.Attr attr");
        this.jw.writeEol("java.lang.String attrValue");
        boolean hasNillableElement = false;
        for (int i = 0; i < size; ++i) {
            AbstractCodeGeneratorClass.Property a = (AbstractCodeGeneratorClass.Property)this.attrList.get(i);
            if (a.isNillable()) {
                hasNillableElement = true;
            }
            if (!a.isAttribute() || !a.isDirectChild()) continue;
            ++attrCount;
            this.genReadAttr(a, "node");
        }
        this.jw.endMethod();
        this.jw.beginMethod("readNodeChildren", readNodeArgs, this.config.isVetoable() ? "java.beans.PropertyVetoException" : null, "void", 1 | 0x200);
        if (hasSubElements) {
            HashMap<String, AbstractCodeGeneratorClass.Property> dtdNames = new HashMap<String, AbstractCodeGeneratorClass.Property>();
            boolean hasDuplicateDtdNames = this.config.isKeepElementPositions();
            boolean hasQNameType = false;
            boolean hasNonElementTypes = false;
            for (int i = 0; i < size; ++i) {
                AbstractCodeGeneratorClass.Property a = (AbstractCodeGeneratorClass.Property)this.attrList.get(i);
                if (this.isTypeQName(a.getType())) {
                    hasQNameType = true;
                }
                if (a.type == 3840 || a.dtdName.equals("#PCDATA")) {
                    hasNonElementTypes = true;
                    continue;
                }
                if (a.isAttribute()) continue;
                if (dtdNames.containsKey(a.dtdName)) {
                    hasDuplicateDtdNames = true;
                }
                dtdNames.put(a.dtdName, a);
            }
            this.geneol("org.w3c.dom.NodeList children = node.getChildNodes()");
            boolean hasReadState = false;
            if (hasDuplicateDtdNames || this.config.isKeepElementPositions()) {
                hasReadState = true;
                this.jw.writeEol(this.getRootClassName(), ".ReadState readState = new ", this.getRootClassName(), ".ReadState()");
            }
            if (hasDuplicateDtdNames) {
                this.jw.writeEol("readState.lastElementType = -1");
            }
            if (this.config.isKeepElementPositions()) {
                this.jw.writeEol("readState.elementPosition = 0");
                this.jw.writeEol("elementsByPosition = new java.lang.Object[children.getLength()]");
                this.jw.writeEol("elementTypesByPosition = new int[children.getLength()]");
            }
            this.jw.beginFor("int i = 0, size = children.getLength()", "i < size", "++i");
            this.geneol("org.w3c.dom.Node childNode = children.item(i)");
            if (!(hasNonElementTypes || this.config.isRespectExtension() && this.beanElement.getExtension() != null)) {
                this.jw.beginIf("!(childNode instanceof org.w3c.dom.Element)");
                this.jw.writeEol("continue");
                this.jw.end();
            }
            this.geneol("String childNodeName = (childNode.getLocalName() == null ? childNode.getNodeName().intern() : childNode.getLocalName().intern())");
            this.geneol("String childNodeValue = \"\"");
            this.jw.beginIf("childNode.getFirstChild() != null");
            this.geneol("childNodeValue = childNode.getFirstChild().getNodeValue()");
            this.jw.end();
            this.jw.write("boolean recognized = readNodeChild(childNode, childNodeName, childNodeValue, namespacePrefixes");
            if (hasReadState) {
                this.jw.write(", readState");
            }
            this.jw.writeEol(")");
            this.jw.beginIf("!recognized");
            if (!this.config.isLogSuspicious()) {
                this.comment("Found extra unrecognized childNode");
            } else {
                this.jw.beginIf("childNode instanceof org.w3c.dom.Element");
                this.declareLogger();
                this.jw.writeEol("_logger.info(\"Found extra unrecognized childNode '\"+childNodeName+\"'\")");
                this.jw.end();
            }
            this.jw.end();
            this.jw.end();
            if (this.config.isKeepElementPositions()) {
                this.jw.beginFor("", "readState.elementPosition < elementTypesByPosition.length", "++readState.elementPosition");
                this.jw.writeEol("elementTypesByPosition[readState.elementPosition] = -1");
                this.jw.end();
            }
            this.jw.endMethod();
            this.jw.beginMethod("readNodeChild", "org.w3c.dom.Node childNode, String childNodeName, String childNodeValue, " + namespacePrefixesFormalParameter + (hasReadState ? ", " + this.getRootClassName() + ".ReadState readState" : ""), this.config.isVetoable() ? "java.beans.PropertyVetoException" : null, "boolean", 1 | 0x200);
            this.jw.comment("assert childNodeName == childNodeName.intern()");
            if (hasNillableElement || hasQNameType || nonDirectAttributes.size() > 0) {
                this.declareAttrsForRead("childNode");
            }
            boolean first = true;
            AbstractCodeGeneratorClass.Property anyProp = null;
            for (int i = 0; i < size; ++i) {
                String var;
                String type;
                String attr;
                AbstractCodeGeneratorClass.Property a = (AbstractCodeGeneratorClass.Property)this.attrList.get(i);
                if (a.isAttribute()) continue;
                boolean indexed = a.isIndexed();
                String baseAttr = attr = "_" + a.name;
                boolean isScalar = a.isScalar();
                String baseType = type = a.getType().intern();
                if (indexed) {
                    type = (baseType + "[]").intern();
                }
                if (baseType == "org.w3c.dom.Element") {
                    anyProp = a;
                    continue;
                }
                if (first) {
                    first = false;
                } else {
                    this.gen("else ");
                }
                this.jw.write("if (");
                if (hasDuplicateDtdNames && dtdNames.get(a.dtdName) != a) {
                    int alwaysBeforeElementType = indexed ? i + 1 : i;
                    this.jw.write("readState.lastElementType < " + alwaysBeforeElementType, " && ");
                }
                if (a.dtdName.equals("#PCDATA")) {
                    this.jw.write("childNode instanceof org.w3c.dom.CharacterData");
                } else if (a.type == 3840) {
                    this.jw.write("childNode instanceof org.w3c.dom.Comment");
                } else {
                    this.jw.write("\"" + a.dtdName + "\".equals(childNodeName)");
                }
                this.jw.write(") ");
                this.begin();
                if (a.isNillable()) {
                    this.jw.writeEol("org.w3c.dom.Attr nilAttr = (org.w3c.dom.Attr) attrs.getNamedItem(\"xsi:nil\")");
                    this.jw.beginIf("nilAttr == null || !\"true\".equals(nilAttr.getValue())");
                }
                if (indexed) {
                    var = "a" + a.name;
                    if (a.isBean) {
                        this.jw.write(baseType, " ");
                    } else {
                        this.geneol(baseType + " " + var);
                    }
                } else {
                    var = attr;
                }
                if (a.isBean) {
                    this.jw.write(var, " = ");
                    this.genNewDefault(a, true);
                    this.jw.eol();
                    if (this.config.isGeneratePropertyEvents()) {
                        this.geneol(var + "._setPropertyChangeSupport(eventListeners)");
                        if (this.config.isVetoable()) {
                            this.geneol(var + "._setVetoableChangeSupport(vetos)");
                        }
                    }
                    if (this.config.isGenerateParentRefs()) {
                        this.jw.writeEol(var + "._setParent(this)");
                    }
                }
                boolean generatedSet = true;
                if (a.isBean) {
                    this.geneol(var + ".readNode(childNode, namespacePrefixes)");
                } else if (a.dtdName.equals("#PCDATA")) {
                    this.geneol(var + " = ((org.w3c.dom.CharacterData)childNode).getData()");
                } else if (a.type == 3840) {
                    this.geneol(var + " = ((org.w3c.dom.CharacterData)childNode).getData()");
                } else {
                    List exceps;
                    if (this.config.isTrimNonStrings() && baseType != "String" && baseType != "java.lang.String") {
                        this.jw.writeEol("childNodeValue = childNodeValue.trim()");
                    }
                    if (!(exceps = JavaUtil.exceptionsFromParsingText(baseType)).isEmpty()) {
                        this.jw.beginTry();
                    }
                    if (baseType == "boolean" || baseType == "java.lang.Boolean") {
                        this.gencr("if (childNode.getFirstChild() == null)");
                        this.tabIn();
                        if (baseType == "boolean") {
                            this.geneol(var + " = true");
                        } else {
                            this.geneol(var + " = Boolean.TRUE");
                        }
                        this.gencr("else");
                        this.tabIn();
                    }
                    generatedSet = this.genReadType(baseType, var, "childNodeValue", false, null, isScalar, (SchemaRep.EncodingStyle)a.searchExtraData(SchemaRep.EncodingStyle.class));
                    SchemaRep.WhiteSpace ws = (SchemaRep.WhiteSpace)a.searchExtraData(SchemaRep.WhiteSpace.class);
                    if (ws != null) {
                        this.genWhiteSpaceRestriction(ws, var, baseType);
                    }
                    if (!indexed && this.config.isOptionalScalars() && isScalar) {
                        this.jw.writeEol(a.getScalarIsSet(), " = true");
                    }
                    int directAttrCount = 0;
                    for (int attrNum = 0; attrNum < a.attributes.length; ++attrNum) {
                        AttrProp myAttrProp = a.attributes[attrNum];
                        for (AbstractCodeGeneratorClass.Property attrProperty : nonDirectAttributes) {
                            AttrProp attrProp = attrProperty.getAttrProp();
                            if (myAttrProp != attrProp) continue;
                            ++directAttrCount;
                            this.genReadAttr(attrProperty, "childNode");
                        }
                    }
                    if (!exceps.isEmpty()) {
                        this.end();
                        this.genRethrowExceptions(exceps);
                    }
                }
                if (indexed && generatedSet) {
                    this.jw.writeEol(attr, ".add(", JavaUtil.toObject(var, baseType, this.config.isForME(), this.config.isJava5()), ")");
                }
                if (a.isNillable()) {
                    this.jw.endElseBegin();
                    if (indexed) {
                        this.jw.writeEol(attr, ".add(null)");
                    } else {
                        this.jw.writeEol(var, " = ", JavaUtil.nullValueForType(baseType));
                    }
                    this.jw.end();
                }
                if (hasDuplicateDtdNames) {
                    this.jw.writeEol("readState.lastElementType = " + i);
                }
                if (this.config.isKeepElementPositions()) {
                    this.jw.writeEol("elementsByPosition[readState.elementPosition] = " + JavaUtil.toObject(var, type, this.config.isForME(), this.config.isJava5()));
                    this.jw.writeEol("elementTypesByPosition[readState.elementPosition++] = " + i);
                }
                this.end();
            }
            if (anyProp != null) {
                String attr = "_" + anyProp.name;
                boolean indexed = anyProp.isIndexed();
                if (first) {
                    first = false;
                } else {
                    this.gen("else ");
                }
                this.jw.beginIf("childNode instanceof org.w3c.dom.Element");
                if (indexed) {
                    this.jw.writeEol(attr, ".add((org.w3c.dom.Element)childNode)");
                } else {
                    this.jw.writeEol(attr, " = (org.w3c.dom.Element) childNode");
                }
                this.jw.end();
            }
            if (!first) {
                this.gen("else ");
                this.begin();
                if (this.config.isRespectExtension() && this.beanElement.getExtension() != null) {
                    this.jw.write("return super.readNodeChild(childNode, childNodeName, childNodeValue, namespacePrefixes");
                    if (hasReadState) {
                        this.jw.write(", readState");
                    }
                    this.jw.writeEol(")");
                } else {
                    this.jw.writeEol("return false");
                }
                this.end();
            }
            this.jw.writeEol("return true");
        } else if (this.config.isRespectExtension() && this.beanElement.getExtension() != null) {
            this.jw.writeEol("super.readNodeChildren(node, namespacePrefixes)");
        }
        this.jw.endMethod();
        if (this.beanElement.isRoot) {
            if (!this.config.isUseRuntime()) {
                this.genPrintXML();
            }
            this.genSpecialTypes();
        }
    }

    protected void genFetchXMLEventReader() throws IOException {
        this.jw.select(this.BODY_SECTION);
        String commonBean = this.commonBeanType();
        String beanName = this.beanElement.node.getName();
        if (this.beanElement.isRoot) {
            String beanQNameName = this.declareQName(this.beanElement.getNamespace(), beanName, null);
            this.jw.beginMethod("fetchXMLEventReader", "", null, "javax.xml.stream.XMLEventReader");
            this.jw.writeEol("return new ", this.getRootClassName() + ".XMLEventStateManager(this, ", beanQNameName, ")");
            this.jw.endMethod();
            this.jw.write("static class XMLEventStateManager implements javax.xml.stream.XMLEventReader");
            this.jw.begin();
            this.jw.writeEol("private java.util.Stack<" + commonBean + "> beans = new java.util.Stack<" + commonBean + ">()");
            this.jw.writeEol("private java.util.Stack<javax.xml.namespace.QName> nodeNames = new java.util.Stack<javax.xml.namespace.QName>()");
            this.jw.writeEol("private java.util.Stack<Integer> eventNumbers = new java.util.Stack<Integer>()");
            this.jw.writeEol("private java.util.Stack<Integer> arrayIndices = new java.util.Stack<Integer>()");
            this.jw.writeEol("private java.util.Stack<Integer> elementNumbers = new java.util.Stack<Integer>()");
            this.jw.writeEol("private " + commonBean + " currentBean");
            this.jw.writeEol("private javax.xml.namespace.QName currentNodeName");
            this.jw.writeEol("private int currentEventNumber");
            this.jw.writeEol("private int currentArrayIndex");
            this.jw.writeEol("private int currentElementNumber");
            this.jw.writeEol("private javax.xml.stream.events.XMLEvent next");
            this.jw.cr();
            this.jw.write("public XMLEventStateManager(" + commonBean + " bean, javax.xml.namespace.QName nodeName)");
            this.jw.begin();
            this.jw.writeEol("currentBean = bean");
            this.jw.writeEol("this.currentNodeName = nodeName");
            this.jw.writeEol("currentEventNumber = 0");
            this.jw.writeEol("currentArrayIndex = 0");
            this.jw.writeEol("currentElementNumber = 0");
            this.jw.end();
            this.jw.cr();
            this.jw.write("public int getEventNumber()");
            this.jw.begin();
            this.jw.writeEol("return currentEventNumber");
            this.jw.end();
            this.jw.cr();
            this.jw.write("public void nextEventNumber()");
            this.jw.begin();
            this.jw.writeEol("++currentEventNumber");
            this.jw.writeEol("currentArrayIndex = 0");
            this.jw.writeEol("currentElementNumber = 0");
            this.jw.end();
            this.jw.cr();
            this.jw.write("public int getArrayIndex()");
            this.jw.begin();
            this.jw.writeEol("return currentArrayIndex");
            this.jw.end();
            this.jw.cr();
            this.jw.write("public void nextArrayIndex()");
            this.jw.begin();
            this.jw.writeEol("++currentArrayIndex");
            this.jw.writeEol("currentElementNumber = 0");
            this.jw.end();
            this.jw.cr();
            this.jw.write("public int getElementNumber()");
            this.jw.begin();
            this.jw.writeEol("return currentElementNumber");
            this.jw.end();
            this.jw.cr();
            this.jw.write("public void nextElementNumber()");
            this.jw.begin();
            this.jw.writeEol("++currentElementNumber");
            this.jw.end();
            this.jw.cr();
            this.jw.write("public javax.xml.namespace.QName getNodeName()");
            this.jw.begin();
            this.jw.writeEol("return currentNodeName");
            this.jw.end();
            this.jw.cr();
            this.jw.write("public void enterChildBean(" + commonBean + " bean, javax.xml.namespace.QName nodeName)");
            this.jw.begin();
            this.jw.writeEol("beans.push(currentBean)");
            this.jw.writeEol("eventNumbers.push(currentEventNumber)");
            this.jw.writeEol("arrayIndices.push(currentArrayIndex)");
            this.jw.writeEol("elementNumbers.push(currentElementNumber)");
            this.jw.writeEol("nodeNames.push(currentNodeName)");
            this.jw.writeEol("currentBean = bean");
            this.jw.writeEol("currentEventNumber = 0");
            this.jw.writeEol("currentArrayIndex = 0");
            this.jw.writeEol("currentElementNumber = 0");
            this.jw.writeEol("currentNodeName = nodeName");
            this.jw.end();
            this.jw.cr();
            this.jw.write("public void doneWithBean()");
            this.jw.begin();
            this.jw.write("if (beans.isEmpty())");
            this.jw.begin();
            this.jw.writeEol("currentBean = null");
            this.jw.writeEol("currentEventNumber = -1");
            this.jw.end();
            this.jw.write("else");
            this.jw.begin();
            this.jw.writeEol("currentBean = beans.pop()");
            this.jw.writeEol("currentEventNumber = eventNumbers.pop()");
            this.jw.writeEol("currentArrayIndex = arrayIndices.pop()");
            this.jw.writeEol("currentElementNumber = elementNumbers.pop()");
            this.jw.writeEol("currentNodeName = nodeNames.pop()");
            this.jw.end();
            this.jw.end();
            this.jw.cr();
            this.jw.write("public Object getProperty(String name) throws IllegalArgumentException");
            this.jw.begin();
            this.jw.writeEol("throw new IllegalArgumentException(\"Got no properties\")");
            this.jw.end();
            this.jw.cr();
            this.jw.write("public void remove()");
            this.jw.begin();
            this.jw.writeEol("throw new UnsupportedOperationException()");
            this.jw.end();
            this.jw.cr();
            this.jw.write("public javax.xml.stream.events.XMLEvent peek() throws javax.xml.stream.XMLStreamException");
            this.jw.begin();
            this.jw.beginIf("next != null");
            this.jw.writeEol("return next");
            this.jw.end();
            this.jw.writeEol("setNextEvent()");
            this.jw.writeEol("return next");
            this.jw.end();
            this.jw.cr();
            this.jw.write("public javax.xml.stream.events.XMLEvent nextTag() throws javax.xml.stream.XMLStreamException");
            this.jw.begin();
            this.jw.writeEol("throw new IllegalArgumentException()");
            this.jw.end();
            this.jw.cr();
            this.jw.write("public javax.xml.stream.events.XMLEvent nextEvent() throws javax.xml.stream.XMLStreamException");
            this.jw.begin();
            this.jw.writeEol("javax.xml.stream.events.XMLEvent result = null");
            this.jw.write("if (next != null)");
            this.jw.begin();
            this.jw.writeEol("result = next");
            this.jw.writeEol("next = null");
            this.jw.writeEol("return result");
            this.jw.end();
            this.jw.writeEol("setNextEvent()");
            this.jw.beginIf("next == null");
            this.jw.writeEol("throw new java.util.NoSuchElementException()");
            this.jw.end();
            this.jw.writeEol("result = next");
            this.jw.writeEol("next = null");
            this.jw.writeEol("return result");
            this.jw.end();
            this.jw.cr();
            this.jw.write("private void setNextEvent() throws javax.xml.stream.XMLStreamException");
            this.jw.begin();
            this.jw.write("while (next == null && currentEventNumber >= 0)");
            this.jw.begin();
            this.jw.writeEol("next = currentBean.getXMLEvent(this)");
            this.jw.end();
            this.jw.end();
            this.jw.cr();
            this.jw.write("public Object next()");
            this.jw.begin();
            this.jw.beginTry();
            this.jw.writeEol("return nextEvent()");
            this.jw.write("} catch (javax.xml.stream.XMLStreamException e)");
            this.jw.begin();
            this.jw.writeEol("throw new RuntimeException(e)");
            this.jw.end();
            this.jw.end();
            this.jw.cr();
            this.jw.write("public boolean hasNext()");
            this.jw.begin();
            this.jw.beginIf("next != null");
            this.jw.writeEol("return true");
            this.jw.end();
            this.jw.beginTry();
            this.jw.writeEol("setNextEvent()");
            this.jw.endCatch("javax.xml.stream.XMLStreamException e");
            this.jw.writeEol("throw new RuntimeException(e)");
            this.jw.end();
            this.jw.writeEol("return (next != null)");
            this.jw.end();
            this.jw.cr();
            this.jw.write("public String getElementText() throws javax.xml.stream.XMLStreamException");
            this.jw.begin();
            this.jw.writeEol("throw new IllegalArgumentException()");
            this.jw.end();
            this.jw.cr();
            this.jw.write("public void close() throws javax.xml.stream.XMLStreamException");
            this.jw.begin();
            this.jw.writeEol("currentEventNumber = -1");
            this.jw.writeEol("beans.clear()");
            this.jw.writeEol("eventNumbers.clear()");
            this.jw.writeEol("arrayIndices.clear()");
            this.jw.writeEol("nodeNames.clear()");
            this.jw.end();
            this.jw.end();
            this.jw.write("static abstract class BaseXMLEvent implements javax.xml.stream.events.XMLEvent ");
            this.jw.begin();
            this.jw.write("public void writeAsEncodedUnicode(java.io.Writer writer) throws javax.xml.stream.XMLStreamException ");
            this.jw.begin();
            this.jw.writeEol("throw new UnsupportedOperationException()");
            this.jw.end();
            this.jw.cr();
            this.jw.write("public boolean isStartElement() ");
            this.jw.begin();
            this.jw.writeEol("return false");
            this.jw.end();
            this.jw.cr();
            this.jw.write("public boolean isStartDocument() ");
            this.jw.begin();
            this.jw.writeEol("return false");
            this.jw.end();
            this.jw.cr();
            this.jw.write("public javax.xml.stream.events.Characters asCharacters() ");
            this.jw.begin();
            this.jw.writeEol("return (javax.xml.stream.events.Characters) this");
            this.jw.end();
            this.jw.cr();
            this.jw.write("public javax.xml.stream.events.EndElement asEndElement() ");
            this.jw.begin();
            this.jw.writeEol("return (javax.xml.stream.events.EndElement) this");
            this.jw.end();
            this.jw.cr();
            this.jw.write("public javax.xml.stream.events.StartElement asStartElement() ");
            this.jw.begin();
            this.jw.writeEol("return (javax.xml.stream.events.StartElement) this");
            this.jw.end();
            this.jw.cr();
            this.jw.write("public javax.xml.stream.Location getLocation() ");
            this.jw.begin();
            this.jw.writeEol("throw new UnsupportedOperationException()");
            this.jw.end();
            this.jw.cr();
            this.jw.write("public javax.xml.namespace.QName getSchemaType() ");
            this.jw.begin();
            this.jw.writeEol("return null");
            this.jw.end();
            this.jw.cr();
            this.jw.write("public boolean isAttribute() ");
            this.jw.begin();
            this.jw.writeEol("return false");
            this.jw.end();
            this.jw.cr();
            this.jw.write("public boolean isCharacters() ");
            this.jw.begin();
            this.jw.writeEol("return false");
            this.jw.end();
            this.jw.cr();
            this.jw.write("public boolean isEndDocument() ");
            this.jw.begin();
            this.jw.writeEol("return false");
            this.jw.end();
            this.jw.cr();
            this.jw.write("public boolean isEndElement() ");
            this.jw.begin();
            this.jw.writeEol("return false");
            this.jw.end();
            this.jw.cr();
            this.jw.write("public boolean isEntityReference() ");
            this.jw.begin();
            this.jw.writeEol("return false");
            this.jw.end();
            this.jw.cr();
            this.jw.write("public boolean isNamespace() ");
            this.jw.begin();
            this.jw.writeEol("return false");
            this.jw.end();
            this.jw.cr();
            this.jw.write("public boolean isProcessingInstruction() ");
            this.jw.begin();
            this.jw.writeEol("return false");
            this.jw.end();
            this.jw.cr();
            this.jw.end();
            this.jw.cr();
            this.jw.write("static class ThisStartDocument extends BaseXMLEvent implements javax.xml.stream.events.StartDocument ");
            this.jw.begin();
            this.jw.write("public int getEventType() ");
            this.jw.begin();
            this.jw.writeEol("return javax.xml.stream.XMLStreamConstants.START_DOCUMENT");
            this.jw.end();
            this.jw.cr();
            this.jw.write("public boolean isStartDocument() ");
            this.jw.begin();
            this.jw.writeEol("return true");
            this.jw.end();
            this.jw.cr();
            this.jw.write("public boolean standaloneSet() ");
            this.jw.begin();
            this.jw.writeEol("return false");
            this.jw.end();
            this.jw.cr();
            this.jw.write("public boolean isStandalone() ");
            this.jw.begin();
            this.jw.writeEol("return false");
            this.jw.end();
            this.jw.cr();
            this.jw.write("public String getVersion() ");
            this.jw.begin();
            this.jw.writeEol("return \"1.0\"");
            this.jw.end();
            this.jw.cr();
            this.jw.write("public String getSystemId() ");
            this.jw.begin();
            this.jw.writeEol("return null");
            this.jw.end();
            this.jw.cr();
            this.jw.write("public String getCharacterEncodingScheme() ");
            this.jw.begin();
            this.jw.writeEol("return \"UTF-8\"");
            this.jw.end();
            this.jw.cr();
            this.jw.write("public boolean encodingSet() ");
            this.jw.begin();
            this.jw.writeEol("return true");
            this.jw.end();
            this.jw.end();
            this.jw.cr();
            this.jw.write("static class ThisAttribute extends BaseXMLEvent implements javax.xml.stream.events.Attribute ");
            this.jw.begin();
            this.jw.writeEol("private javax.xml.namespace.QName name");
            this.jw.writeEol("private String value");
            this.jw.writeEol("private String dtdType");
            this.jw.writeEol("private javax.xml.namespace.QName schemaType");
            this.jw.cr();
            this.jw.write("public ThisAttribute(javax.xml.namespace.QName name, String value, String dtdType, javax.xml.namespace.QName schemaType) ");
            this.jw.begin();
            this.jw.writeEol("this.name = name");
            this.jw.writeEol("this.value = value");
            this.jw.writeEol("this.dtdType = dtdType");
            this.jw.writeEol("this.schemaType = schemaType");
            this.jw.end();
            this.jw.cr();
            this.jw.write("public int getEventType() ");
            this.jw.begin();
            this.jw.writeEol("return javax.xml.stream.XMLStreamConstants.ATTRIBUTE");
            this.jw.end();
            this.jw.cr();
            this.jw.write("public boolean isSpecified() ");
            this.jw.begin();
            this.jw.writeEol("return true");
            this.jw.end();
            this.jw.cr();
            this.jw.write("public String getValue() ");
            this.jw.begin();
            this.jw.writeEol("return value");
            this.jw.end();
            this.jw.cr();
            this.jw.write("public javax.xml.namespace.QName getName() ");
            this.jw.begin();
            this.jw.writeEol("return name");
            this.jw.end();
            this.jw.cr();
            this.jw.write("public String getDTDType() ");
            this.jw.begin();
            this.jw.writeEol("return dtdType");
            this.jw.end();
            this.jw.cr();
            this.jw.write("public javax.xml.namespace.QName getSchemaType() ");
            this.jw.begin();
            this.jw.writeEol("return schemaType");
            this.jw.end();
            this.jw.end();
            this.jw.cr();
            this.jw.write("static class ThisNamespace extends ThisAttribute implements javax.xml.stream.events.Namespace ");
            this.jw.begin();
            this.jw.writeEol("private String prefix");
            this.jw.cr();
            this.jw.write("public ThisNamespace(String prefix, String uri) ");
            this.jw.begin();
            this.jw.writeEol("super(new javax.xml.namespace.QName(\"http://FIXME/xmlns\", prefix, \"xmlns\"), uri, null, null)");
            this.jw.writeEol("this.prefix = prefix");
            this.jw.end();
            this.jw.cr();
            this.jw.write("public boolean isDefaultNamespaceDeclaration() ");
            this.jw.begin();
            this.jw.writeEol("return \"\".equals(prefix)");
            this.jw.end();
            this.jw.cr();
            this.jw.write("public String getPrefix() ");
            this.jw.begin();
            this.jw.writeEol("return prefix");
            this.jw.end();
            this.jw.cr();
            this.jw.write("public String getNamespaceURI() ");
            this.jw.begin();
            this.jw.writeEol("return getValue()");
            this.jw.end();
            this.jw.end();
            this.jw.cr();
            this.jw.write("static class ThisStartElement extends BaseXMLEvent implements javax.xml.stream.events.StartElement ");
            this.jw.begin();
            this.jw.writeEol("private javax.xml.namespace.QName name");
            this.jw.writeEol("private java.util.Map<javax.xml.namespace.QName, ThisAttribute> attributes = new java.util.HashMap<javax.xml.namespace.QName, ThisAttribute>()");
            this.jw.writeEol("private java.util.Map<String, ThisNamespace> namespaces = new java.util.HashMap<String, ThisNamespace>()");
            this.jw.cr();
            this.jw.write("public ThisStartElement(javax.xml.namespace.QName name) ");
            this.jw.begin();
            this.jw.writeEol("this.name = name");
            this.jw.end();
            this.jw.cr();
            this.jw.write("public void addAttribute(javax.xml.namespace.QName attrName, String attrValue, String dtdType, javax.xml.namespace.QName schemaType) ");
            this.jw.begin();
            this.jw.writeEol("attributes.put(attrName, new ThisAttribute(attrName, attrValue, dtdType, schemaType))");
            this.jw.end();
            this.jw.cr();
            this.jw.write("public void addNamespace(String prefix, String uri) ");
            this.jw.begin();
            this.jw.writeEol("namespaces.put(prefix, new ThisNamespace(prefix, uri))");
            this.jw.end();
            this.jw.cr();
            this.jw.write("public int getEventType() ");
            this.jw.begin();
            this.jw.writeEol("return javax.xml.stream.XMLStreamConstants.START_ELEMENT");
            this.jw.end();
            this.jw.cr();
            this.jw.write("public boolean isStartElement() ");
            this.jw.begin();
            this.jw.writeEol("return true");
            this.jw.end();
            this.jw.cr();
            this.jw.write("public String getNamespaceURI(String prefix) ");
            this.jw.begin();
            this.jw.writeEol("return namespaces.get(prefix).getNamespaceURI()");
            this.jw.end();
            this.jw.cr();
            this.jw.write("public javax.xml.stream.events.Attribute getAttributeByName(javax.xml.namespace.QName name) ");
            this.jw.begin();
            this.jw.writeEol("return attributes.get(name)");
            this.jw.end();
            this.jw.cr();
            this.jw.write("public java.util.Iterator getNamespaces() ");
            this.jw.begin();
            this.jw.writeEol("return namespaces.values().iterator()");
            this.jw.end();
            this.jw.cr();
            this.jw.write("public javax.xml.namespace.NamespaceContext getNamespaceContext() ");
            this.jw.begin();
            this.jw.writeEol("throw new UnsupportedOperationException()");
            this.jw.end();
            this.jw.cr();
            this.jw.write("public javax.xml.namespace.QName getName() ");
            this.jw.begin();
            this.jw.writeEol("return name");
            this.jw.end();
            this.jw.cr();
            this.jw.write("public java.util.Iterator getAttributes() ");
            this.jw.begin();
            this.jw.writeEol("return attributes.values().iterator()");
            this.jw.end();
            this.jw.write("public String toString() ");
            this.jw.begin();
            this.jw.writeEol("return \"StartElement: \"+name.toString()");
            this.jw.end();
            this.jw.end();
            this.jw.cr();
            this.jw.write("static class ThisEndElement extends BaseXMLEvent implements javax.xml.stream.events.EndElement ");
            this.jw.begin();
            this.jw.writeEol("private javax.xml.namespace.QName name");
            this.jw.cr();
            this.jw.write("public ThisEndElement(javax.xml.namespace.QName name) ");
            this.jw.begin();
            this.jw.writeEol("this.name = name");
            this.jw.end();
            this.jw.cr();
            this.jw.write("public int getEventType() ");
            this.jw.begin();
            this.jw.writeEol("return javax.xml.stream.XMLStreamConstants.END_ELEMENT");
            this.jw.end();
            this.jw.cr();
            this.jw.write("public boolean isEndElement() ");
            this.jw.begin();
            this.jw.writeEol("return true");
            this.jw.end();
            this.jw.cr();
            this.jw.write("public java.util.Iterator getNamespaces() ");
            this.jw.begin();
            this.jw.writeEol("throw new UnsupportedOperationException()");
            this.jw.end();
            this.jw.cr();
            this.jw.write("public javax.xml.namespace.QName getName() ");
            this.jw.begin();
            this.jw.writeEol("return name");
            this.jw.end();
            this.jw.write("public String toString() ");
            this.jw.begin();
            this.jw.writeEol("return \"EndElement: \"+name.toString()");
            this.jw.end();
            this.jw.end();
            this.jw.cr();
            this.jw.write("static class ThisCharacters extends BaseXMLEvent implements javax.xml.stream.events.Characters ");
            this.jw.begin();
            this.jw.writeEol("private String data");
            this.jw.cr();
            this.jw.write("public ThisCharacters(String data) ");
            this.jw.begin();
            this.jw.writeEol("this.data = data");
            this.jw.end();
            this.jw.cr();
            this.jw.write("public int getEventType() ");
            this.jw.begin();
            this.jw.writeEol("return javax.xml.stream.XMLStreamConstants.CHARACTERS");
            this.jw.end();
            this.jw.cr();
            this.jw.write("public boolean isCharacters() ");
            this.jw.begin();
            this.jw.writeEol("return true");
            this.jw.end();
            this.jw.cr();
            this.jw.write("public boolean isWhiteSpace() ");
            this.jw.begin();
            this.jw.write("for (int i = 0; i < data.length(); ++i) ");
            this.jw.begin();
            this.jw.writeEol("char c = data.charAt(i)");
            this.jw.writeEol("if (!Character.isWhitespace(c))");
            this.jw.writeEol("return false");
            this.jw.end();
            this.jw.writeEol("return true");
            this.jw.end();
            this.jw.cr();
            this.jw.write("public boolean isIgnorableWhiteSpace() ");
            this.jw.begin();
            this.jw.writeEol("return false");
            this.jw.end();
            this.jw.cr();
            this.jw.write("public boolean isCData() ");
            this.jw.begin();
            this.jw.writeEol("return false");
            this.jw.end();
            this.jw.cr();
            this.jw.write("public String getData() ");
            this.jw.begin();
            this.jw.writeEol("return data");
            this.jw.end();
            this.jw.write("public String toString() ");
            this.jw.begin();
            this.jw.writeEol("return \"Characters: \"+data");
            this.jw.end();
            this.jw.end();
            this.jw.cr();
            this.jw.write("static class ThisEndDocument extends BaseXMLEvent implements javax.xml.stream.events.EndDocument ");
            this.jw.begin();
            this.jw.write("public int getEventType() ");
            this.jw.begin();
            this.jw.writeEol("return javax.xml.stream.XMLStreamConstants.END_DOCUMENT");
            this.jw.end();
            this.jw.cr();
            this.jw.write("public boolean isEndDocument() ");
            this.jw.begin();
            this.jw.writeEol("return true");
            this.jw.end();
            this.jw.end();
            this.jw.cr();
        }
        this.jw.beginMethod("getXMLEvent", this.getRootClassName() + ".XMLEventStateManager state", null, "javax.xml.stream.events.XMLEvent");
        this.jw.write("switch (state.getEventNumber()) ");
        this.jw.begin();
        int caseNum = 0;
        if (this.beanElement.isRoot) {
            this.jw.writecr("case " + caseNum++, ":");
            this.jw.indentRight();
            this.jw.writeEol("state.nextEventNumber()");
            this.jw.writeEol("return new ThisStartDocument()");
            this.jw.indentLeft();
        }
        this.jw.writecr("case " + caseNum++, ":");
        this.jw.begin();
        this.jw.writeEol("state.nextEventNumber()");
        this.jw.writeEol(this.getRootClassName() + ".ThisStartElement startElement = new ", this.getRootClassName(), ".ThisStartElement(state.getNodeName())");
        int size = this.attrList.size();
        for (int i = 0; i < size; ++i) {
            AbstractCodeGeneratorClass.Property a = (AbstractCodeGeneratorClass.Property)this.attrList.get(i);
            if (!a.isAttribute() || !a.isDirectChild()) continue;
            String qNameName = this.declareQName(a.getNamespace(), a.dtdName, null);
            SchemaRep schemaRep = new SchemaRep();
            String xmlSchemaType = schemaRep.javaType2XMLSchemaTypeComplex(a.getType());
            String typeQNameName = this.declareQName(schemaRep.getNamespaceURI(SchemaRep.prefixOf(xmlSchemaType)), SchemaRep.removePrefix(xmlSchemaType), null);
            String varName = "_" + a.name;
            if (!a.isScalar()) {
                this.jw.beginIf(varName + " != null");
            } else if (this.config.isOptionalScalars() && a.isScalar()) {
                this.jw.beginIf(a.getScalarIsSet());
            }
            this.jw.write("startElement.addAttribute(", qNameName, ", ");
            this.jw.write(JavaUtil.typeToString(a.getType(), varName));
            this.jw.writeEol(", \"CDATA\", ", typeQNameName, ")");
            if (a.isScalar() && (!this.config.isOptionalScalars() || !a.isScalar())) continue;
            this.jw.end();
        }
        if (this.beanElement.isRoot) {
            this.jw.beginIf("schemaLocation != null");
            String slQNameName = this.declareQName("http://www.w3.org/2001/XMLSchema-instance", "schemaLocation", "xsi");
            String typeQNameName = this.declareQName("http://www.w3.org/2001/XMLSchema", "string", "xsd");
            this.jw.write("startElement.addAttribute(", slQNameName, ", ");
            this.jw.writeEol("schemaLocation, \"CDATA\", ", typeQNameName, ")");
            this.jw.end();
        }
        this.jw.writeEol("return startElement");
        this.jw.end();
        int numberOfNonAttributeProperties = this.countNumberOfNonAttributeProperties();
        this.comment("Number of non attribute properties: " + numberOfNonAttributeProperties);
        int childStartCaseNum = caseNum;
        if (caseNum < childStartCaseNum + numberOfNonAttributeProperties) {
            while (caseNum < childStartCaseNum + numberOfNonAttributeProperties) {
                this.jw.writecr("case " + caseNum++, ":");
            }
            this.jw.indentRight();
            this.jw.writeEol("javax.xml.stream.events.XMLEvent event = getXMLEventChildren(state, state.getEventNumber() - " + childStartCaseNum + ")");
            this.jw.writeEol("return event");
            this.jw.indentLeft();
        }
        this.jw.writecr("case " + caseNum++, ":");
        this.jw.indentRight();
        this.jw.writeEol("state.nextEventNumber()");
        this.jw.writeEol("return new ", this.getRootClassName(), ".ThisEndElement(state.getNodeName())");
        this.jw.indentLeft();
        if (this.beanElement.isRoot) {
            this.jw.writecr("case " + caseNum++, ":");
            this.jw.indentRight();
            this.jw.writeEol("state.nextEventNumber()");
            this.jw.writeEol("return new ThisEndDocument()");
            this.jw.indentLeft();
        }
        this.jw.writecr("default:");
        this.jw.indentRight();
        this.jw.writeEol("state.doneWithBean()");
        this.jw.writeEol("break");
        this.jw.indentLeft();
        this.jw.end();
        this.jw.writeEol("return null");
        this.jw.endMethod();
        this.jw.beginMethod("getXMLEventChildren", this.getRootClassName() + ".XMLEventStateManager state, int eventNumber", null, "javax.xml.stream.events.XMLEvent", 1);
        caseNum = 0;
        this.jw.write("switch (eventNumber) ");
        this.jw.begin();
        if (this.config.isRespectExtension() && this.beanElement.getExtension() != null) {
            this.jw.writecr("default:");
            this.jw.indentRight();
            this.jw.writeEol("javax.xml.stream.events.XMLEvent event = super.getXMLEventChildren(state, eventNumber)");
            this.jw.beginIf("true");
            this.jw.writeEol("return event");
            this.jw.end();
            this.jw.indentLeft();
            caseNum = this.countNumberOfNonAttributePropertiesRecurse(this.beanElement.getExtension());
        }
        for (int i = 0; i < size; ++i) {
            AbstractCodeGeneratorClass.Property a = (AbstractCodeGeneratorClass.Property)this.attrList.get(i);
            if (a.isAttribute()) continue;
            boolean indexed = a.isIndexed();
            String varName = "_" + a.name;
            String qNameName = this.declareQName(a.getNamespace(), a.dtdName, null);
            this.jw.writecr("case " + caseNum++, ":");
            this.jw.begin();
            if (indexed) {
                varName = "element";
                this.jw.writeEol(a.getTypeFullClassName(this.packageName), " element = null");
                if (!a.isBean) {
                    this.jw.beginIf("state.getElementNumber() == 0");
                }
                this.jw.beginWhile("state.getArrayIndex() < size" + a.name + "()");
                this.jw.writeEol("element = ", a.getReadMethod(true), "(state.getArrayIndex())");
                this.jw.beginIf("element != null");
                this.jw.writeEol("break");
                this.jw.end();
                this.jw.writeEol("state.nextArrayIndex()");
                this.jw.end();
                if (!a.isBean) {
                    this.jw.endElseBegin();
                    this.jw.writeEol("element = ", a.getReadMethod(true), "(state.getArrayIndex())");
                    this.jw.writeEol("assert element != null");
                    this.jw.end();
                }
            }
            if (a.isBean) {
                this.jw.beginIf(varName + " != null");
                if (indexed) {
                    this.jw.writeEol("state.nextArrayIndex()");
                } else {
                    this.jw.writeEol("state.nextEventNumber()");
                }
                this.jw.write("state.enterChildBean(", varName, ", ");
                this.jw.writeEol(qNameName, ")");
                this.jw.writeEol("return ", varName, ".getXMLEvent(state)");
                this.jw.endElseBegin();
                this.jw.writeEol("state.nextEventNumber()");
                this.jw.end();
                this.jw.writeEol("break");
                this.jw.end();
                continue;
            }
            if (!a.isScalar()) {
                this.jw.beginIf(varName + " != null");
            } else if (this.config.isOptionalScalars() && a.isScalar()) {
                this.jw.beginIf(a.getScalarIsSet());
            }
            this.jw.writeEol("state.nextElementNumber()");
            this.jw.write("switch (state.getElementNumber()) ");
            this.jw.begin();
            this.jw.writecr("case 1:");
            this.jw.indentRight();
            this.jw.write(this.getRootClassName(), ".ThisStartElement startElement = new ", this.getRootClassName());
            this.jw.writeEol(".ThisStartElement(", qNameName, ")");
            for (int attrNum = 0; attrNum < a.attributes.length; ++attrNum) {
                AttrProp attr = a.attributes[attrNum];
                AbstractCodeGeneratorClass.Property prop = this.findProperty(attr);
                String qNameNameAttr = this.declareQName(prop.getNamespace(), prop.dtdName, null);
                SchemaRep schemaRep = new SchemaRep();
                String xmlSchemaType = schemaRep.javaType2XMLSchemaTypeComplex(a.getType());
                String typeQNameNameAttr = this.declareQName(schemaRep.getNamespaceURI(SchemaRep.prefixOf(xmlSchemaType)), SchemaRep.removePrefix(xmlSchemaType), null);
                String varNameAttr = "_" + prop.name;
                if (!a.isScalar()) {
                    this.jw.beginIf(varNameAttr + " != null");
                } else if (this.config.isOptionalScalars() && a.isScalar()) {
                    this.jw.beginIf(a.getScalarIsSet());
                }
                this.jw.write("startElement.addAttribute(" + qNameNameAttr + ", ");
                this.jw.write(JavaUtil.typeToString(a.getType(), varNameAttr));
                this.jw.writeEol(", \"CDATA\", ", typeQNameNameAttr, ")");
                if (a.isScalar() && (!this.config.isOptionalScalars() || !a.isScalar())) continue;
                this.jw.end();
            }
            this.jw.writeEol("return startElement");
            this.jw.indentLeft();
            this.jw.writecr("case 2:");
            this.jw.indentRight();
            this.jw.write("return new ", this.getRootClassName(), ".ThisCharacters(");
            if (this.isTypeQName(a.getType())) {
                this.jw.write(a.getType());
            } else if ("byte[]".equals(a.getType())) {
                SchemaRep.EncodingStyle style = (SchemaRep.EncodingStyle)a.searchExtraData(SchemaRep.EncodingStyle.class);
                if (!(style instanceof SchemaRep.HexBinary)) {
                    if (style instanceof SchemaRep.Base64Binary) {
                        this.jw.write(this.getRootClassName(), ".encodeBase64BinaryString(");
                        this.jw.writeEol(varName, "))");
                    } else {
                        this.config.messageOut.println("Unknown encoding style for " + a.getType() + " for property " + a.name);
                    }
                }
            } else {
                this.jw.write(JavaUtil.typeToString(a.getType(), varName));
                this.jw.writeEol(")");
            }
            this.jw.indentLeft();
            this.jw.writecr("case 3:");
            this.jw.indentRight();
            this.jw.write("return new ", this.getRootClassName(), ".ThisEndElement(", qNameName);
            this.jw.writeEol(")");
            this.jw.indentLeft();
            this.jw.writecr("default:");
            this.jw.indentRight();
            if (indexed) {
                this.jw.writeEol("state.nextArrayIndex()");
                this.jw.writeEol("return getXMLEvent(state)");
            } else {
                this.jw.writeEol("break");
            }
            this.jw.indentLeft();
            this.jw.end();
            if (!a.isScalar() || this.config.isOptionalScalars() && a.isScalar()) {
                if (indexed) {
                    this.jw.endElse();
                    this.jw.cr();
                    this.jw.indentOneLevel();
                } else {
                    this.jw.end();
                }
            }
            this.jw.writeEol("state.nextEventNumber()");
            this.jw.writeEol("break");
            this.jw.end();
        }
        this.jw.end();
        this.jw.writeEol("return null");
        this.jw.endMethod();
    }

    protected String declareQName(String namespaceUri, String localPart, String prefix) throws IOException {
        QName qname;
        if ("http://www.w3.org/XML/1998/namespace".equals(namespaceUri)) {
            if (prefix == null) {
                prefix = "xml";
            }
            if (localPart.startsWith("xml:")) {
                localPart = localPart.substring(4);
            }
        }
        if (this.declaredQNames.containsKey(qname = new QName(namespaceUri, localPart, prefix))) {
            return (String)this.declaredQNames.get(qname);
        }
        this.jw.pushSelect(this.DECL_SECTION);
        if (this.declaredQNames.size() == 0) {
            this.jw.cr();
        }
        String qNameName = "QNAME_" + Common.constName(localPart);
        while (this.declaredQNames.containsKey(qNameName)) {
            qNameName = qNameName + "2";
        }
        this.declaredQNames.put(qname, qNameName);
        this.jw.write("public static final javax.xml.namespace.QName ");
        this.jw.write(qNameName);
        this.jw.write(" = new javax.xml.namespace.QName(");
        if (namespaceUri == null) {
            this.jw.write("null");
        } else {
            this.jw.write(JavaUtil.instanceFrom("String", namespaceUri));
        }
        this.jw.write(", \"");
        this.jw.write(localPart);
        this.jw.write("\"");
        if (prefix != null) {
            this.jw.write(", ", JavaUtil.instanceFrom("String", prefix));
        }
        this.jw.writeEolNoI18N(")");
        this.jw.popSelect();
        return qNameName;
    }

    protected void declareLogger() throws IOException {
        if (this.loggerDeclared) {
            return;
        }
        this.jw.pushSelect(this.DECL_SECTION);
        this.jw.writeEol("private static final java.util.logging.Logger _logger = java.util.logging.Logger.getLogger(\"" + this.fullClassName + "\")");
        this.jw.popSelect();
        this.loggerDeclared = true;
    }

    protected void genUpdateNamespaces(String namespaceMapName, String firstNamespaceVarName) throws IOException {
        this.jw.beginFor("int attrNum = 0", "attrNum < attrs.getLength()", "++attrNum");
        this.jw.writeEol("attr = (org.w3c.dom.Attr) attrs.item(attrNum)");
        this.jw.writeEol("String attrName = attr.getName()");
        this.jw.beginIf("attrName.startsWith(\"xmlns:\")");
        if (firstNamespaceVarName != null) {
            this.jw.beginIf(firstNamespaceVarName);
            this.jw.writeEol(firstNamespaceVarName, " = false");
            this.jw.comment("Dup prefix map, so as to not write over previous values, and to make it easy to clear out our entries.");
            this.jw.write(namespaceMapName, " = new java.util.HashMap");
            if (this.config.jdkTarget >= 150) {
                this.jw.write("<String, String>");
            }
            this.jw.writeEol("(", namespaceMapName, ")");
            this.jw.end();
        }
        this.jw.writeEol("String attrNSPrefix = attrName.substring(6)");
        this.jw.writeEol(namespaceMapName, ".put(attrNSPrefix, attr.getValue())");
        this.jw.end();
        this.jw.end();
    }

    protected void genWriteAttr(AbstractCodeGeneratorClass.Property a) throws IOException {
        this.genWriteAttr(a, "_" + a.name);
    }

    protected void genWriteAttr(AbstractCodeGeneratorClass.Property a, String varName) throws IOException {
        boolean isScalar = a.isScalar();
        String dtdName = a.dtdName;
        String namespace = a.getNamespace();
        this.comment(dtdName + " is an attribute with namespace " + namespace);
        if (!isScalar) {
            this.gen("if (" + varName + " != null) ");
            this.begin();
        }
        if (namespace != null && !namespace.equals(this.getDefaultNamespace()) && !namespace.equals("http://www.w3.org/XML/1998/namespace")) {
            dtdName = SchemaRep.removePrefix(dtdName);
            this.outWrite(" ");
            this.jw.writeEol("out.write((String)namespaceMap.get(", JavaUtil.instanceFrom("String", namespace), "))");
            this.jw.writeEol("out.write(\":", dtdName, "='\")");
        } else {
            this.jw.writeEol("out.write(\" ", dtdName, "='\")");
        }
        this.genWriteType(a, varName, true);
        this.gen("out.write(\"'\")");
        this.eolNoI18N();
        if (!isScalar) {
            this.end();
        }
    }

    protected void genWriteType(AbstractCodeGeneratorClass.Property a, String varName, boolean isAttribute) throws IOException {
        String type = a.getType();
        boolean isScalar = a.isScalar();
        if (isScalar || JavaUtil.canProduceNoXMLMetaChars(type)) {
            this.jw.write("out.write(" + JavaUtil.typeToString(type, varName));
            this.jw.writeEol(")");
        } else if (this.isTypeQName(type)) {
            this.jw.beginIf(varName + ".getNamespaceURI() != null && !\"\".equals(", varName, ".getNamespaceURI())");
            this.jw.writeEol("out.write((String) namespaceMap.get(", varName, ".getNamespaceURI()))");
            this.jw.writeEol("out.write(\":\")");
            this.jw.end();
            if (this.config.isUseRuntime()) {
                this.jw.write("org.netbeans.modules.schema2beans.XMLUtil");
            } else {
                this.jw.write(this.getRootClassName());
            }
            this.jw.write(".writeXML(out, ");
            this.jw.write(varName, ".getLocalPart(), " + isAttribute);
            this.jw.writeEol(")");
        } else if ("byte[]".equals(type)) {
            SchemaRep.EncodingStyle style = (SchemaRep.EncodingStyle)a.searchExtraData(SchemaRep.EncodingStyle.class);
            if (style instanceof SchemaRep.HexBinary) {
                this.jw.beginFor("int byteIndex = 0", "byteIndex < " + varName + ".length", "++byteIndex");
                this.jw.writeEol("int belement = (int) ", varName, "[byteIndex]");
                this.jw.beginIf("belement < 0");
                this.jw.writeEol("belement += 256");
                this.jw.end();
                this.jw.beginIf("belement < 16");
                this.jw.writeEol("out.write(\"0\")");
                this.jw.end();
                this.jw.writeEol("out.write(Integer.toHexString(belement).toUpperCase())");
                this.jw.end();
            } else if (style instanceof SchemaRep.Base64Binary) {
                this.jw.write("out.write(");
                this.jw.write(this.getRootClassName());
                this.jw.write(".encodeBase64BinaryString(");
                this.jw.write(varName);
                this.jw.write(")");
                this.jw.writeEol(")");
            } else {
                this.config.messageOut.println("Unknown encoding style for " + type + " for property " + a.name);
            }
        } else {
            if (this.config.isUseRuntime()) {
                this.jw.write("org.netbeans.modules.schema2beans.XMLUtil");
            } else {
                this.jw.write(this.getRootClassName());
            }
            this.jw.write(".writeXML(out, ");
            if ("java.util.Calendar".equals(type)) {
                this.jw.write(this.getRootClassName());
                this.jw.write(".calendarToString(");
                this.jw.write(varName);
                this.jw.write(")");
            } else {
                this.jw.write(JavaUtil.typeToString(type, varName));
            }
            this.jw.write(", " + isAttribute);
            this.jw.writeEol(")");
        }
    }

    protected void beginAttrProcessing(String nodeName) throws IOException {
        this.jw.beginIf(nodeName, ".hasAttributes()");
        this.declareAttrsForRead(nodeName);
    }

    protected void genReadAttr(AbstractCodeGeneratorClass.Property a, String nodeName) throws IOException {
        this.genReadAttr("_" + a.name, a.getType().intern(), a.dtdName, nodeName, (SchemaRep.WhiteSpace)a.searchExtraData(SchemaRep.WhiteSpace.class), a.isIndexed(), a.getAddMethod(), a.isScalar(), (SchemaRep.EncodingStyle)a.searchExtraData(SchemaRep.EncodingStyle.class));
    }

    protected void genReadAttr(String attr, String type, String dtdName, String nodeName, SchemaRep.WhiteSpace ws, boolean isIndexed, String addMethod, boolean isScalar, SchemaRep.EncodingStyle style) throws IOException {
        String baseType = type;
        this.jw.writeEol("attr = (org.w3c.dom.Attr) attrs.getNamedItem(\"", dtdName, "\")");
        List exceps = JavaUtil.exceptionsFromParsingText(baseType);
        String var = "attrValue";
        this.jw.beginIf("attr != null");
        this.jw.writeEol("attrValue = attr.getValue()");
        if (ws != null) {
            this.genWhiteSpaceRestriction(ws, var, "java.lang.String");
        }
        if (isIndexed) {
            this.jw.endElseBegin();
            this.jw.writeEol("attrValue = null");
            this.jw.end();
        }
        if (!exceps.isEmpty()) {
            this.jw.beginTry();
        }
        this.genReadType(baseType, attr, var, isIndexed, addMethod, isScalar, style);
        if (!exceps.isEmpty()) {
            this.jw.end();
            this.genRethrowExceptions(exceps);
        }
        if (!isIndexed) {
            this.jw.end();
        }
    }

    protected boolean genReadType(String type, String var, String expr, boolean isIndexed, String addMethod, boolean isScalar, SchemaRep.EncodingStyle style) throws IOException {
        type = type.intern();
        if (isIndexed) {
            this.jw.writeEol(type, " processedValueFor", var);
            if (this.genReadType(type, "processedValueFor" + var, expr, false, null, isScalar, style)) {
                this.jw.writeEol(addMethod, "(processedValueFor", var, ")");
            }
        } else if (this.isTypeQName(type)) {
            this.jw.writeEol("int colonPos = ", expr, ".indexOf(':')");
            this.jw.beginIf("colonPos < 0");
            this.jw.write(var, " = new ", type);
            this.jw.writeEol("(", expr, ")");
            this.jw.endElseBegin();
            this.jw.writeEol("java.util.Map nsPrefixes = new java.util.HashMap(namespacePrefixes)");
            this.genUpdateNamespaces("nsPrefixes", null);
            this.jw.writeEol("String prefix = ", expr, ".substring(0, colonPos)");
            this.jw.writeEol("String ns = (String) nsPrefixes.get(prefix)");
            this.jw.write("String localPart = ", expr);
            this.jw.writeEol(".substring(colonPos+1, ", expr, ".length())");
            this.jw.writeEol(var, " = new ", type, "(ns, localPart, prefix)");
            this.jw.end();
        } else if (type == "byte[]") {
            if (style instanceof SchemaRep.HexBinary) {
                this.jw.writeEol(var, " = new byte[(childNodeValue.length()+1) / 2]");
                this.jw.beginFor("int byteIndex = 0", "byteIndex < " + var + ".length", "++byteIndex");
                this.jw.writeEol("String octet = childNodeValue.substring(byteIndex * 2, byteIndex * 2 + 2)");
                this.jw.writeEol(var, "[byteIndex] = Integer.valueOf(octet, 16).byteValue()");
                this.jw.end();
            } else if (style instanceof SchemaRep.Base64Binary) {
                this.jw.write(var, " = ");
                this.jw.write(this.getRootClassName());
                this.jw.writeEol(".decodeBase64BinaryString(childNodeValue)");
            } else {
                this.config.messageOut.println("Unknown encoding style for " + type + " for " + var);
            }
        } else {
            if (!isScalar && !JavaUtil.isInstantiable(type) && type != "java.util.Calendar" || type == "org.netbeans.modules.schema2beansdev.beangraph.BeanGraph" || type == "org.netbeans.modules.schema2beansdev.metadd.MetaDD" || type == "java.io.PrintStream") {
                this.config.messageOut.println("Warning: Don't know how to create a " + type);
                this.jw.comment("Don't know how to create a " + type);
                return false;
            }
            if (type == "java.util.Calendar") {
                this.jw.write(var, " = ");
                this.jw.write(this.getRootClassName());
                this.jw.writeEol(".stringToCalendar(", expr, ")");
            } else {
                this.jw.writecr(JavaUtil.genParseText(type, expr, var, this.config.isForME()));
            }
        }
        return true;
    }

    protected void declareAttrsForRead(String nodeName) throws IOException {
        this.jw.writeEol("org.w3c.dom.NamedNodeMap attrs = ", nodeName, ".getAttributes()");
        this.jw.writeEol("org.w3c.dom.Attr attr");
        this.jw.writeEol("java.lang.String attrValue");
    }

    public void genPrintXML() throws IOException {
        this.jw.bigComment("Takes some text to be printed into an XML stream and escapes any\ncharacters that might make it invalid XML (like '<').");
        this.jw.beginMethod("writeXML", "java.io.Writer out, String msg", "java.io.IOException", "void", 0 | 0x10 | 0x200);
        this.geneol("writeXML(out, msg, true)");
        this.end();
        this.cr();
        this.jw.beginMethod("writeXML", "java.io.Writer out, String msg, boolean attribute", "java.io.IOException", "void", 0 | 0x10 | 0x200);
        this.gencr("if (msg == null)");
        this.tabIn();
        this.geneol("return");
        this.geneol("int msgLength = msg.length()");
        this.jw.beginFor("int i = 0", "i < msgLength", "++i");
        this.geneol("char c = msg.charAt(i)");
        this.geneol("writeXML(out, c, attribute)");
        this.end();
        this.end();
        this.cr();
        this.jw.beginMethod("writeXML", "java.io.Writer out, char msg, boolean attribute", "java.io.IOException", "void", 0 | 0x10 | 0x200);
        this.gencr("if (msg == '&')");
        this.tabIn();
        this.geneol("out.write(\"&amp;\")");
        this.gencr("else if (msg == '<')");
        this.tabIn();
        this.geneol("out.write(\"&lt;\")");
        this.gencr("else if (msg == '>')");
        this.tabIn();
        this.geneol("out.write(\"&gt;\")");
        this.gen("else ");
        this.jw.beginIf("attribute");
        this.gencr("if (msg == '\"')");
        this.tabIn();
        this.geneol("out.write(\"&quot;\")");
        this.gencr("else if (msg == '\\'')");
        this.tabIn();
        this.geneol("out.write(\"&apos;\")");
        this.gencr("else if (msg == '\\n')");
        this.tabIn();
        this.geneol("out.write(\"&#xA;\")");
        this.gencr("else if (msg == '\\t')");
        this.tabIn();
        this.geneol("out.write(\"&#x9;\")");
        this.gencr("else");
        this.tabIn();
        this.geneol("out.write(msg)");
        this.jw.end();
        this.gencr("else");
        this.tabIn();
        this.geneol("out.write(msg)");
        this.jw.endMethod();
    }

    protected void outWrite(String text) throws IOException {
        this.jw.writeEol("out.write(", JavaUtil.instanceFrom("String", text), ")");
    }

    public void genSpecialTypes() throws IOException {
        if (this.rootBeanElement.isUsedType("java.util.Calendar")) {
            JavaBeansUtil.genReadType(this.jw, "java.util.Calendar");
            JavaBeansUtil.genWriteType(this.jw, "java.util.Calendar");
            this.jw.cr();
        }
        if (this.rootBeanElement.isUsedType("byte[]")) {
            JavaBeansUtil.genReadType(this.jw, "base64Binary");
            JavaBeansUtil.genWriteType(this.jw, "base64Binary");
            this.jw.cr();
        }
    }

    public void genValidate() throws IOException {
        this.select(this.BODY_SECTION);
        if (this.beanElement.isRoot && !this.config.isUseRuntime()) {
            String commonBeanType = this.commonBeanType();
            this.jw.write("public static class ValidateException extends Exception ");
            this.jw.begin();
            this.jw.write("private ", commonBeanType);
            this.jw.writeEol(" failedBean");
            this.jw.writeEol("private String failedPropertyName");
            this.jw.writeEol("private FailureType failureType");
            this.jw.write("public ValidateException(String msg, String failedPropertyName, ", commonBeanType, " failedBean) ");
            this.jw.begin();
            this.jw.writeEol("super(msg)");
            this.jw.writeEol("this.failedBean = failedBean");
            this.jw.writeEol("this.failedPropertyName = failedPropertyName");
            this.jw.end();
            this.jw.write("public ValidateException(String msg, FailureType ft, String failedPropertyName, ", commonBeanType, " failedBean) ");
            this.jw.begin();
            this.jw.writeEol("super(msg)");
            this.jw.writeEol("this.failureType = ft");
            this.jw.writeEol("this.failedBean = failedBean");
            this.jw.writeEol("this.failedPropertyName = failedPropertyName");
            this.jw.end();
            this.jw.writecr("public String getFailedPropertyName() {return failedPropertyName;}");
            this.jw.writecr("public FailureType getFailureType() {return failureType;}");
            this.jw.write("public ", commonBeanType);
            this.jw.writecr(" getFailedBean() {return failedBean;}");
            this.jw.write("public static class FailureType ");
            this.jw.begin();
            this.jw.writeEol("private final String name");
            this.jw.writecr("private FailureType(String name) {this.name = name;}");
            this.jw.writecr("public String toString() { return name;}");
            this.jw.writeEol("public static final FailureType NULL_VALUE = new FailureType(\"NULL_VALUE\")");
            this.jw.writeEol("public static final FailureType DATA_RESTRICTION = new FailureType(\"DATA_RESTRICTION\")");
            this.jw.writeEol("public static final FailureType ENUM_RESTRICTION = new FailureType(\"ENUM_RESTRICTION\")");
            this.jw.writeEol("public static final FailureType ALL_RESTRICTIONS = new FailureType(\"ALL_RESTRICTIONS\")");
            this.jw.writeEol("public static final FailureType MUTUALLY_EXCLUSIVE = new FailureType(\"MUTUALLY_EXCLUSIVE\")");
            this.jw.end();
            this.jw.end();
            this.jw.cr();
        }
        this.jw.beginMethod("validate", "", (this.config.isUseRuntime() ? "org.netbeans.modules.schema2beans" : this.getRootClassName()) + ".ValidateException", "void", 0);
        this.genValidateProperties();
        if (this.config.isRespectExtension() && this.beanElement.getExtension() != null) {
            this.jw.writeEol("super.validate()");
        }
        this.jw.endMethod();
    }

    @Override
    protected void genValidateFail(String detail, String name, boolean quoteDetail, ValidateException.FailureType ft, JavaWriter out) throws IOException {
        out.write("throw new ");
        String validateException = this.config.isUseRuntime() ? "org.netbeans.modules.schema2beans.ValidateException" : this.getRootClassName() + ".ValidateException";
        out.write(validateException);
        out.write("(");
        if (quoteDetail) {
            out.write('\"');
        }
        out.write(detail);
        if (quoteDetail) {
            out.write('\"');
        }
        out.write(", ", validateException + ".FailureType.", ft.toString());
        out.writeEolNoI18N(", \"" + name + "\", this)");
    }

    public void genPropertyEvents() throws IOException {
        this.select(this.DECL_SECTION);
        this.gen(1, "java.beans.PropertyChangeSupport", "eventListeners");
        this.eol();
        this.select(this.BODY_SECTION);
        this.jw.beginMethod("addPropertyChangeListener", "java.beans.PropertyChangeListener listener", null, "void", 0 | 0x100);
        this.jw.beginIf("eventListeners == null");
        this.geneol("eventListeners = new java.beans.PropertyChangeSupport(this)");
        this.end();
        this.geneol("eventListeners.addPropertyChangeListener(listener)");
        this.genCallMethodOnBeans(".addPropertyChangeListener(listener)");
        this.jw.endMethod();
        this.jw.beginMethod("removePropertyChangeListener", "java.beans.PropertyChangeListener listener", null, "void", 0 | 0x100);
        this.genCallMethodOnBeans(".removePropertyChangeListener(listener)");
        this.jw.beginIf("eventListeners == null");
        this.geneol("return");
        this.end();
        this.geneol("eventListeners.removePropertyChangeListener(listener)");
        this.jw.beginIf("!eventListeners.hasListeners(null)");
        this.geneol("eventListeners = null");
        this.jw.end();
        this.jw.endMethod();
        this.jw.beginMethod("_setPropertyChangeSupport", "java.beans.PropertyChangeSupport listeners", null, "void", 0);
        this.jw.writeEol("eventListeners = listeners");
        this.genCallMethodOnBeans("._setPropertyChangeSupport(listeners)");
        this.jw.endMethod();
    }

    protected void genCallMethodOnBeans(String methodParams) throws IOException {
        int size = this.attrList.size();
        for (int i = 0; i < size; ++i) {
            String type;
            AbstractCodeGeneratorClass.Property a = (AbstractCodeGeneratorClass.Property)this.attrList.get(i);
            if (!a.isBean) continue;
            boolean indexed = a.isIndexed();
            String attr = "_" + a.name;
            String baseType = type = a.getType().intern();
            if (indexed) {
                this.beginAttrIterator(attr, a, "element");
                attr = "element";
            }
            this.jw.beginIf(attr, " != null");
            this.jw.writeEol(attr, methodParams);
            this.jw.end();
            if (!indexed) continue;
            this.jw.end();
        }
    }

    public void genStoreEvents() throws IOException {
        this.select(this.DECL_SECTION);
        this.gen(11, "boolean", "storeEvents = false");
        this.eol();
        this.gen(1, "java.util.List", "storedEvents = new java.util.LinkedList()");
        this.eol();
        this.select(this.BODY_SECTION);
        this.jw.beginMethod("fireStoredEvents");
        this.jw.beginIf("eventListeners == null");
        this.geneol("storedEvents.clear()");
        this.geneol("return");
        this.end();
        this.jw.beginFor("java.util.Iterator it = storedEvents.iterator()", "it.hasNext()", "");
        this.geneol("java.beans.PropertyChangeEvent event = (java.beans.PropertyChangeEvent) it.next()");
        this.geneol("eventListeners.firePropertyChange(event)");
        this.end();
        this.geneol("storedEvents.clear()");
        this.end();
        this.cr();
    }

    public void genVetoable() throws IOException {
        this.select(this.DECL_SECTION);
        this.gen(1, "java.beans.VetoableChangeSupport", "vetos");
        this.eol();
        this.select(this.BODY_SECTION);
        this.jw.beginMethod("addVetoableChangeListener", "java.beans.VetoableChangeListener listener", null, "void", 0 | 0x100);
        this.jw.beginIf("vetos == null");
        this.geneol("vetos = new java.beans.VetoableChangeSupport(this)");
        this.end();
        this.geneol("vetos.addVetoableChangeListener(listener)");
        this.end();
        this.cr();
        this.jw.beginMethod("removePropertyChangeListener", "java.beans.VetoableChangeListener listener", null, "void", 0 | 0x100);
        this.jw.beginIf("vetos == null");
        this.geneol("return");
        this.end();
        this.geneol("vetos.removeVetoableChangeListener(listener)");
        this.jw.beginIf("!vetos.hasListeners(null)");
        this.geneol("vetos = null");
        this.end();
        this.end();
        this.cr();
        this.jw.beginMethod("_setVetoableChangeSupport", "java.beans.VetoableChangeSupport vs", null, "void", 2);
        this.geneol("vetos = vs");
        this.end();
        this.cr();
    }

    public void genElementPositions() throws IOException {
        this.select(this.BODY_SECTION);
        this.jw.beginMethod("fetchChildByPosition", "int position", null, "java.lang.Object", 0);
        this.jw.beginIf("elementTypesByPosition[position] == -1");
        this.jw.writeEol("throw new IndexOutOfBoundsException(\"position \"+position+\" out of bounds\")");
        this.jw.end();
        this.jw.writeEol("return elementsByPosition[position]");
        this.jw.endMethod();
        this.jw.beginMethod("fetchChildCount", "", null, "int", 0);
        this.jw.writeEol("int position = elementTypesByPosition.length");
        this.jw.beginFor("", "position > 0 && elementTypesByPosition[position-1] == -1", "--position");
        this.jw.writeEol("");
        this.jw.end();
        this.jw.writeEol("return position");
        this.jw.endMethod();
        this.jw.beginMethod("expandElementsByPosition", "int size", null, "void", 1);
        this.jw.beginIf("elementTypesByPosition.length >= size");
        this.jw.writeEol("return");
        this.jw.end();
        this.jw.writeEol("int newSize = elementTypesByPosition.length+8");
        this.jw.writeEol("java.lang.Object[] newElementsByPosition = new java.lang.Object[newSize]");
        this.jw.writeEol("int[] newElementTypesByPosition = new int[newSize]");
        this.jw.writeEol("System.arraycopy(elementsByPosition, 0, newElementsByPosition, 0, elementTypesByPosition.length)");
        this.jw.writeEol("System.arraycopy(elementTypesByPosition, 0, newElementTypesByPosition, 0, elementTypesByPosition.length)");
        this.jw.beginFor("int i = elementTypesByPosition.length", "i < newSize", "++i");
        this.jw.writeEol("newElementTypesByPosition[i] = -1");
        this.jw.end();
        this.jw.writeEol("elementTypesByPosition = newElementTypesByPosition");
        this.jw.writeEol("elementsByPosition = newElementsByPosition");
        this.jw.endMethod();
        this.jw.beginMethod("insertElementByPosition", "int position, Object element, int elementType", null, "void", 1);
        this.jw.writeEol("int childCount = fetchChildCount()");
        this.jw.writeEol("expandElementsByPosition(childCount+1)");
        this.jw.writeEol("int i = childCount - 1");
        this.jw.beginFor("", "i >= position", "--i");
        this.jw.writeEol("elementsByPosition[i + 1] = elementsByPosition[i]");
        this.jw.writeEol("elementTypesByPosition[i + 1] = elementTypesByPosition[i]");
        this.jw.end();
        this.jw.writeEol("elementTypesByPosition[position] = elementType");
        this.jw.writeEol("elementsByPosition[position] = element");
        this.jw.comment("assert childCount == fetchChildCount() + 1;");
        this.jw.endMethod();
        this.jw.beginMethod("deleteElement", "int position", null, "void", 1);
        this.jw.writeEol("int i = position+1");
        this.jw.writeEol("int size = elementTypesByPosition.length");
        this.jw.beginFor("", "i < size && elementTypesByPosition[i] != -1", "++i");
        this.jw.writeEol("elementsByPosition[i - 1] = elementsByPosition[i]");
        this.jw.writeEol("elementTypesByPosition[i - 1] = elementTypesByPosition[i]");
        this.jw.end();
        this.jw.writeEol("elementTypesByPosition[i-1] = -1");
        this.jw.writeEol("elementsByPosition[i - 1] = null");
        this.jw.comment("assert size == fetchChildCount() - 1;");
        this.jw.endMethod();
        this.jw.beginMethod("findFirstOfElementType", "int elementType", null, "int", 1);
        this.jw.writeEol("int maxPos = elementTypesByPosition.length");
        this.jw.writeEol("int pos = 0");
        this.jw.beginFor("", "pos < maxPos && elementTypesByPosition[pos] < elementType", "++pos");
        this.jw.end();
        this.jw.writeEol("return pos");
        this.jw.endMethod();
        this.jw.beginMethod("findElementType", "int elementType, int index", null, "int", 1);
        this.jw.writeEol("int maxPos = elementTypesByPosition.length");
        this.jw.writeEol("int pos = 0");
        this.jw.beginFor("", "pos < maxPos", "++pos");
        this.jw.beginIf("elementTypesByPosition[pos] == elementType");
        this.jw.beginIf("index <= 0");
        this.jw.writeEol("return pos");
        this.jw.end();
        this.jw.writeEol("--index");
        this.jw.end();
        this.jw.end();
        this.jw.writeEol("return pos");
        this.jw.endMethod();
        this.jw.beginMethod("findLastOfElementType", "int elementType", null, "int", 1);
        this.jw.writeEol("int childCount = elementTypesByPosition.length");
        this.jw.writeEol("int pos = childCount - 1");
        this.jw.beginFor("", "pos >=0", "--pos");
        this.jw.beginIf("elementTypesByPosition[pos] == -1");
        this.jw.writeEol("--childCount");
        this.jw.writeEol("continue");
        this.jw.end();
        this.jw.beginIf("elementTypesByPosition[pos] <= elementType");
        this.jw.writeEol("return pos");
        this.jw.end();
        this.jw.end();
        this.jw.writeEol("return childCount");
        this.jw.endMethod();
    }

    protected void genProcessDocType(boolean java5) throws IOException {
        String fullDocTypeName = this.fullClassName + ".DocType";
        this.select(this.DECL_SECTION);
        this.jw.writeEol("private " + fullDocTypeName + " docType = null");
        this.select(this.ACCESS_SECTION);
        this.jw.beginMethod("fetchDocType", "", null, fullDocTypeName, 0);
        this.jw.writeEol("return docType");
        this.jw.endMethod();
        this.jw.beginMethod("changeDocType", fullDocTypeName + " dt", null, "void", 0);
        this.jw.writeEol("docType = dt");
        this.jw.endMethod();
        this.jw.beginMethod("changeDocType", "String publicId, String systemId", null, "void", 0);
        this.jw.writeEol("docType = new ", fullDocTypeName, "(publicId, systemId)");
        this.jw.endMethod();
        this.select(this.BODY_SECTION);
        this.jw.write("public static class DocType ");
        this.jw.begin();
        this.jw.writeEol("private org.w3c.dom.NamedNodeMap entities");
        this.jw.writeEol("private String internalSubset");
        this.jw.writeEol("private String name");
        this.jw.writeEol("private org.w3c.dom.NamedNodeMap notations");
        this.jw.writeEol("private String publicId");
        this.jw.writeEol("private String systemId");
        this.jw.cr();
        this.jw.write("public DocType(" + fullDocTypeName + " docType) ");
        this.jw.begin();
        this.jw.writeEol("entities = docType.getEntities()");
        this.jw.writeEol("internalSubset = docType.getInternalSubset()");
        this.jw.writeEol("name = docType.getName()");
        this.jw.writeEol("notations = docType.getNotations()");
        this.jw.writeEol("publicId = docType.getPublicId()");
        this.jw.writeEol("systemId = docType.getSystemId()");
        this.jw.endMethod();
        this.jw.write("public DocType(org.w3c.dom.DocumentType docType) ");
        this.jw.begin();
        this.jw.writeEol("entities = docType.getEntities()");
        this.jw.writeEol("internalSubset = docType.getInternalSubset()");
        this.jw.writeEol("name = docType.getName()");
        this.jw.writeEol("notations = docType.getNotations()");
        this.jw.writeEol("publicId = docType.getPublicId()");
        this.jw.writeEol("systemId = docType.getSystemId()");
        this.jw.endMethod();
        this.jw.write("public DocType(String publicId, String systemId) ");
        this.jw.begin();
        this.jw.writeEol("this(\"", this.beanElement.node.getName(), "\", publicId, systemId)");
        this.jw.end();
        this.jw.cr();
        this.jw.write("public DocType(String name, String publicId, String systemId) ");
        this.jw.begin();
        this.jw.writeEol("this.name = name");
        this.jw.writeEol("this.publicId = publicId");
        this.jw.writeEol("this.systemId = systemId");
        this.jw.endMethod();
        this.jw.write("public org.w3c.dom.NamedNodeMap getEntities() ");
        this.jw.begin();
        this.jw.writeEol("return entities");
        this.jw.endMethod();
        this.jw.write("public String getInternalSubset() ");
        this.jw.begin();
        this.jw.writeEol("return internalSubset");
        this.jw.endMethod();
        this.jw.write("public String getName() ");
        this.jw.begin();
        this.jw.writeEol("return name");
        this.jw.endMethod();
        this.jw.write("public org.w3c.dom.NamedNodeMap getNotations() ");
        this.jw.begin();
        this.jw.writeEol("return notations");
        this.jw.endMethod();
        this.jw.write("public String getPublicId() ");
        this.jw.begin();
        this.jw.writeEol("return publicId");
        this.jw.endMethod();
        this.jw.write("public String getSystemId() ");
        this.jw.begin();
        this.jw.writeEol("return systemId");
        this.jw.endMethod();
        this.jw.write("public String toString() ");
        this.jw.begin();
        if (java5) {
            this.jw.writeEol("java.lang.StringBuilder result = new java.lang.StringBuilder(\"<!DOCTYPE \")");
        } else {
            this.jw.writeEol("java.lang.StringBuffer result = new java.lang.StringBuffer(\"<!DOCTYPE \")");
        }
        this.jw.writeEol("result.append(name)");
        this.jw.beginIf("publicId != null");
        this.jw.writeEol("result.append(\" PUBLIC \\\"\")");
        this.jw.writeEol("result.append(publicId)");
        this.jw.writeEol("result.append(\"\\\"\")");
        this.jw.beginIf("systemId == null");
        this.jw.writeEol("systemId = \"SYSTEM\"");
        this.jw.end();
        this.jw.end();
        this.jw.beginIf("systemId != null");
        this.jw.writeEol("result.append(\" \\\"\")");
        this.jw.writeEol("result.append(systemId)");
        this.jw.writeEol("result.append(\"\\\"\")");
        this.jw.end();
        this.jw.beginIf("entities != null");
        this.jw.writeEol("int length = entities.getLength()");
        this.jw.beginIf("length > 0");
        this.jw.writeEol("result.append(\" [\")");
        this.jw.beginFor("int i = 0", "i < length", "++i");
        this.jw.writeEol("org.w3c.dom.Node node = entities.item(i)");
        this.jw.writeEol("result.append(\"<\"+node.getNodeName()+\">\")");
        this.jw.writeEol("result.append(node.getNodeValue())");
        this.jw.writeEol("result.append(\"</\"+node.getNodeName()+\">\")");
        this.jw.end();
        this.jw.writeEol("result.append(\"]\")");
        this.jw.end();
        this.jw.end();
        this.jw.writeEol("result.append(\">\")");
        this.jw.writeEol("return result.toString()");
        this.jw.end();
        this.jw.endMethod();
    }

    public void genTransactions() throws IOException {
        this.select(this.BODY_SECTION);
        this.jw.beginMethod("beginTransaction");
        this.geneol("storeEvents = true");
        this.comment("Tell each child bean to also beginTransaction");
        this.genCallMethodOnSubBeans("beginTransaction()");
        this.end();
        this.cr();
        this.jw.beginMethod("commit");
        this.geneol("storeEvents = false");
        this.comment("Tell each child bean to also commit");
        this.genCallMethodOnSubBeans("commit()");
        this.geneol("fireStoredEvents()");
        this.end();
        this.cr();
        this.jw.beginMethod("rollback");
        this.comment("Go over all of the events and put them back");
        this.geneol("java.beans.PropertyChangeEvent[] events = new java.beans.PropertyChangeEvent[storedEvents.size()]");
        this.jw.beginFor("int i = events.length-1", "i >= 0", "--i");
        this.geneol("java.beans.PropertyChangeEvent event = events[i]");
        this.geneol("changePropertyByName(event.getPropertyName(), event.getOldValue())");
        this.end();
        this.geneol("storeEvents = false");
        this.geneol("storedEvents.clear()");
        this.comment("Tell each child bean to also rollback");
        this.genCallMethodOnSubBeans("rollback()");
        this.end();
        this.cr();
    }

    protected void genCallMethodOnSubBeans(String methodName) throws IOException {
        int size = this.attrList.size();
        for (int i = 0; i < size; ++i) {
            AbstractCodeGeneratorClass.Property a = (AbstractCodeGeneratorClass.Property)this.attrList.get(i);
            boolean indexed = a.isIndexed();
            String attr = "_" + a.name;
            String type = a.getType();
            if (!a.isBean) continue;
            String value = attr;
            if (indexed) {
                this.beginAttrIterator(attr, a, "element");
                value = "element";
            }
            this.gencr("if (" + value + " != null)");
            this.tabIn();
            this.gen(value);
            this.gen(".");
            this.geneol(methodName);
            if (!indexed) continue;
            this.end();
        }
    }

    public void genPropertiesByName() throws IOException {
        boolean indexed;
        AbstractCodeGeneratorClass.Property a;
        int i;
        this.jw.beginMethod("changePropertyByName", "String name, Object value", null, "void", 0);
        this.geneol("if (name == null) return");
        this.geneol("name = name.intern()");
        int size = this.attrList.size();
        for (i = 0; i < size; ++i) {
            a = (AbstractCodeGeneratorClass.Property)this.attrList.get(i);
            indexed = a.isIndexed();
            boolean isScalar = a.isScalar();
            String attr = "_" + a.name;
            String type = a.getType();
            if (i > 0) {
                this.gen("else ");
            }
            this.gencr("if (\"" + a.beanIntrospectorName() + "\".equals(name))");
            this.tabIn();
            if (indexed) {
                this.gen("add" + a.name);
                this.geneol("(" + JavaUtil.fromObject(type, "value") + ")");
                this.gen("else ");
                this.gencr("if (\"" + a.beanIntrospectorName() + "[]\".equals(name))");
                this.tabIn();
                this.gen(a.getWriteMethod() + "(");
                this.geneol("(" + type + "[]) value)");
                continue;
            }
            this.gen(a.getWriteMethod() + "(");
            this.gen(JavaUtil.fromObject(type, "value"));
            this.geneol(")");
        }
        if (size > 0) {
            this.gencr("else");
            this.tabIn();
            if (this.config.isRespectExtension() && this.beanElement.getExtension() != null) {
                this.jw.writeEol("super.changePropertyByName(name, value)");
            } else {
                this.genInvalidName("name");
            }
        }
        this.genMadeChange();
        this.end();
        this.cr();
        this.jw.beginMethod("fetchPropertyByName", "String name", null, "Object", 0);
        for (i = 0; i < size; ++i) {
            a = (AbstractCodeGeneratorClass.Property)this.attrList.get(i);
            indexed = a.isIndexed();
            String type = a.getType();
            this.gen("if (\"" + a.beanIntrospectorName());
            if (indexed) {
                this.gen("[]");
            }
            this.gencr("\".equals(name))");
            this.tabIn();
            this.jw.write("return ");
            if (indexed) {
                this.jw.writeEol(a.getReadMethod(false) + "()");
                continue;
            }
            this.jw.writeEol(JavaUtil.toObject(a.getReadMethod(false) + "()", type, this.config.isForME(), this.config.isJava5()));
        }
        if (this.config.isRespectExtension() && this.beanElement.getExtension() != null) {
            this.jw.writeEol("return super.fetchPropertyByName(name)");
        } else {
            this.genInvalidName("name");
        }
        this.jw.endMethod();
    }

    public void genEqualsHashCode() throws IOException {
        this.select(this.EQUALS_SECTION);
        this.jw.beginMethod("equals", "Object o", null, "boolean", 0);
        this.jw.write("return o instanceof ", this.fullClassName);
        this.jw.writeEol(" && equals((", this.fullClassName, ") o)");
        this.jw.endMethod();
        this.jw.beginMethod("equals", this.fullClassName + " inst", null, "boolean", 0);
        this.jw.beginIf("inst == this");
        this.jw.writeEol("return true");
        this.jw.end();
        this.jw.beginIf("inst == null");
        this.jw.writeEol("return false");
        this.jw.end();
        this.select(this.HASHCODE_SECTION);
        this.jw.beginMethod("hashCode", "", null, "int", 0);
        this.geneol("int result = 17");
        boolean isArrayStyle = this.config.getIndexedPropertyType() == null;
        int size = this.attrList.size();
        for (int i = 0; i < size; ++i) {
            String attr;
            String type;
            AbstractCodeGeneratorClass.Property a = (AbstractCodeGeneratorClass.Property)this.attrList.get(i);
            boolean indexed = a.isIndexed();
            boolean isWrapper = false;
            MetaElement me = this.getMetaElement(a);
            boolean isScalar = a.isScalar();
            String baseType = type = a.getType().intern();
            if (indexed) {
                type = (baseType + "[]").intern();
            }
            String baseAttr = attr = "_" + a.name;
            String otherAttr = "inst." + attr;
            this.select(this.EQUALS_SECTION);
            if (indexed) {
                this.gen("if (size" + a.name + "() != inst.size" + a.name + "())");
                this.cr();
                this.tabIn();
                this.gen("return false");
                this.eol();
                this.comment("Compare every element.");
                String fullType = this.getTypeFullClassName(a);
                if (isArrayStyle) {
                    this.jw.beginFor("int pos = 0, size = size" + a.name + "()", "pos < size", "++pos");
                    attr = attr + "[pos]";
                    otherAttr = otherAttr + "[pos]";
                } else {
                    this.jw.beginFor("java.util.Iterator it = " + attr + ".iterator(), it2 = inst." + attr + ".iterator()", "it.hasNext() && it2.hasNext()", "");
                    this.gen(fullType);
                    this.gen(" element = ");
                    this.geneol(JavaUtil.fromObject(fullType, "it.next()"));
                    this.gen(fullType);
                    this.gen(" element2 = ");
                    this.geneol(JavaUtil.fromObject(fullType, "it2.next()"));
                    attr = "element";
                    otherAttr = "element2";
                }
            }
            if (!indexed && this.config.isOptionalScalars() && a.isScalar()) {
                this.jw.beginIf(a.getScalarIsSet() + " != inst." + a.getScalarIsSet());
                this.jw.writeEol("return false");
                this.jw.end();
                this.jw.beginIf(a.getScalarIsSet());
            }
            this.jw.beginIf("!(" + JavaUtil.genEquals(baseType, attr, otherAttr) + ")");
            this.jw.writeEol("return false");
            this.jw.end();
            if (!indexed && this.config.isOptionalScalars() && a.isScalar()) {
                this.jw.end();
            }
            if (indexed) {
                this.end();
            }
            this.select(this.HASHCODE_SECTION);
            this.gen("result = 37*result + (");
            if (isScalar) {
                if (!indexed && this.config.isOptionalScalars() && a.isScalar()) {
                    this.gen(a.getScalarIsSet(), " ? 0 : (");
                }
                this.gen(JavaUtil.exprToInt(type, baseAttr));
                if (!indexed && this.config.isOptionalScalars() && a.isScalar()) {
                    this.gen(")");
                }
            } else {
                this.gen(baseAttr + " == null ? 0 : " + baseAttr + ".hashCode()");
            }
            this.gen(")");
            this.eol();
        }
        this.select(this.EQUALS_SECTION);
        if (this.config.isRespectExtension() && this.beanElement.getExtension() != null) {
            this.jw.writeEol("return super.equals(inst)");
        } else {
            this.jw.writeEol("return true");
        }
        this.jw.endMethod();
        this.select(this.HASHCODE_SECTION);
        if (this.config.isRespectExtension() && this.beanElement.getExtension() != null) {
            this.jw.writeEol("result = 37*result + super.hashCode()");
        }
        this.jw.writeEol("return result");
        this.jw.endMethod();
    }

    void genDeepCopy() throws IOException {
        this.select(this.CONSTRUCTOR_SECTION);
        this.jw.bigComment("Deep copy");
        this.jw.beginConstructor(this.className, this.fullClassName + " source");
        this.jw.writeEol("this(source, false)");
        this.jw.end();
        this.jw.cr();
        this.jw.bigComment("Deep copy\n@param justData just copy the XML relevant data");
        this.jw.beginConstructor(this.className, this.fullClassName + " source, boolean justData");
        if (this.config.isGenerateParentRefs()) {
            this.jw.writeEol("this(source, null, justData)");
            this.jw.end();
            this.jw.cr();
            this.jw.bigComment("Deep copy");
            this.jw.beginConstructor(this.className, this.fullClassName + " source, " + this.parentBeanType() + " parent, boolean justData");
        }
        if (this.config.isRespectExtension() && this.beanElement.getExtension() != null) {
            if (this.config.isGenerateParentRefs()) {
                this.jw.writeEol("super(source, parent, justData)");
            } else {
                this.jw.writeEol("super(source, justData)");
            }
        }
        this.genExtendBaseBeanConstructor();
        if (this.config.isGenerateParentRefs()) {
            this.jw.writeEol("this.parent = parent");
        }
        int size = this.attrList.size();
        for (int i = 0; i < size; ++i) {
            String getter;
            AbstractCodeGeneratorClass.Property a = (AbstractCodeGeneratorClass.Property)this.attrList.get(i);
            boolean indexed = a.isIndexed();
            boolean isScalar = a.isScalar();
            String attr = "_" + a.name;
            String type = a.getType().intern();
            String fullClassType = this.getTypeFullClassName(a);
            boolean isArrayStyle = this.config.getIndexedPropertyType() == null;
            String nextElement = "it.next()";
            if (indexed) {
                if (isArrayStyle) {
                    this.jw.writeEol(attr, " = new ", fullClassType, "[source." + attr + ".length]");
                    this.jw.beginFor("int index = 0", "index < source." + attr + ".length", "++index");
                    nextElement = "source." + attr + "[index]";
                } else {
                    this.jw.beginFor("java.util.Iterator it = source." + attr + ".iterator()", "it.hasNext()", "");
                }
            }
            if (indexed) {
                getter = "srcElement";
                if (isScalar) {
                    if (this.config.jdkTarget < 150) {
                        this.jw.write("Object");
                    } else {
                        this.jw.write(JavaUtil.toObjectType(fullClassType));
                    }
                    this.jw.write(" ", getter, " = ");
                    if (this.config.jdkTarget >= 150) {
                        this.jw.write("(" + JavaUtil.toObjectType(fullClassType) + ") ");
                    }
                    this.jw.writeEol(nextElement);
                } else {
                    this.jw.writeEol(fullClassType + " ", getter, " = ", isArrayStyle ? nextElement : JavaUtil.fromObject(fullClassType, nextElement));
                }
            } else {
                getter = "source." + attr;
            }
            if (type == "byte[]") {
                this.jw.writeEol("byte[] destElement" + attr, " = new byte[", getter, ".length]");
                this.jw.writeEol("System.arraycopy(", getter + ", 0, destElement" + attr + ", 0, ", getter, ".length)");
            }
            this.gen(attr);
            if (indexed) {
                if (isArrayStyle) {
                    this.jw.write("[index] = ");
                } else {
                    this.gen(".add(");
                }
            } else {
                this.gen(" = ");
            }
            if (type == "byte[]") {
                this.jw.write("destElement", attr);
            } else {
                this.genCopy(getter, a, "justData");
            }
            if (indexed && !isArrayStyle) {
                this.jw.write(")");
            }
            this.jw.eol();
            if (!indexed && this.config.isOptionalScalars() && a.isScalar()) {
                this.jw.writeEol(a.getScalarIsSet(), " = source.", a.getScalarIsSet());
            }
            if (!indexed) continue;
            this.jw.end();
        }
        if (this.beanElement.isRoot && this.config.isProcessDocType()) {
            String fullDocTypeName = this.packageName == null ? this.className + ".DocType" : this.packageName + "." + this.className + ".DocType";
            this.jw.beginIf("source.docType != null");
            this.jw.writeEol("docType = new " + fullDocTypeName + "(source.docType)");
            this.jw.end();
        }
        if (this.beanElement.isRoot) {
            this.jw.writeEol("schemaLocation = source.schemaLocation");
        }
        boolean firstJustData = true;
        if (this.config.isGenerateStoreEvents()) {
            if (firstJustData) {
                firstJustData = false;
                this.jw.beginIf("!justData");
            }
            this.geneol("storeEvents = source.storeEvents");
        }
        if (this.config.isVetoable()) {
            if (firstJustData) {
                firstJustData = false;
                this.jw.beginIf("!justData");
            }
            this.geneol("vetos = source.vetos");
        }
        if (this.config.isGeneratePropertyEvents()) {
            if (firstJustData) {
                firstJustData = false;
                this.jw.beginIf("!justData");
            }
            this.jw.beginIf("source.eventListeners != null");
            this.jw.writeEol("eventListeners = new java.beans.PropertyChangeSupport(this)");
            this.jw.writeEol("java.beans.PropertyChangeListener[] theListeners = source.eventListeners.getPropertyChangeListeners()");
            this.jw.beginFor("int i = 0", "i < theListeners.length", "++i");
            this.jw.writeEol("eventListeners.addPropertyChangeListener(theListeners[i])");
            this.jw.end();
            this.jw.end();
        }
        if (!firstJustData) {
            this.jw.end();
        }
        this.end();
        this.cr();
    }

    public void genHasChanged() throws IOException {
        if (this.beanElement.isRoot) {
            this.select(this.DECL_SECTION);
            this.jw.writeEol("private boolean changed");
        }
        this.select(this.BODY_SECTION);
        this.jw.bigComment("Change the result of _hasChanged().\nThis is done automatically when a value in this bean graph gets changed.");
        this.jw.beginMethod("_setChanged", "boolean changed", null, "void", 0);
        if (this.beanElement.isRoot) {
            this.jw.writeEol("this.changed = changed");
        } else {
            this.jw.beginIf("parent != null");
            this.jw.writeEol("parent._setChanged(changed)");
            this.jw.end();
        }
        this.jw.endMethod();
        if (this.beanElement.isRoot) {
            this.jw.bigComment("@return true if something has changed in this bean graph.");
            this.jw.beginMethod("_hasChanged", "", null, "boolean", 0);
            this.jw.writeEol("return changed");
            this.jw.endMethod();
        }
    }

    public void genChildBeans() throws IOException {
        this.select(this.BODY_SECTION);
        this.jw.bigComment("Return an array of all of the properties that are beans and are set.");
        String cb = this.config.isExtendBaseBean() ? "org.netbeans.modules.schema2beans.BaseBean" : this.commonBeanType();
        this.jw.beginMethod("childBeans", "boolean recursive", null, cb + "[]", 0);
        this.jw.write("java.util.List");
        if (this.config.jdkTarget >= 150) {
            this.jw.write("<", cb, ">");
        }
        this.jw.write(" children = new java.util.LinkedList");
        if (this.config.jdkTarget >= 150) {
            this.jw.write("<", cb, ">");
        }
        this.jw.writeEol("()");
        this.jw.writeEol("childBeans(recursive, children)");
        this.jw.writeEol(cb + "[] result = new " + cb + "[children.size()]");
        this.jw.writeEol("return (" + cb + "[]) children.toArray(result)");
        this.jw.endMethod();
        this.jw.bigComment("Put all child beans into the beans list.");
        String childBeansArgs = "boolean recursive, java.util.List";
        if (this.config.jdkTarget >= 150) {
            childBeansArgs = childBeansArgs + "<" + cb + ">";
        }
        childBeansArgs = childBeansArgs + " beans";
        this.jw.beginMethod("childBeans", childBeansArgs, null, "void", 0);
        int size = this.attrList.size();
        for (int i = 0; i < size; ++i) {
            AbstractCodeGeneratorClass.Property a = (AbstractCodeGeneratorClass.Property)this.attrList.get(i);
            if (!a.isBean) continue;
            boolean indexed = a.isIndexed();
            String type = a.getType().intern();
            String attr = "_" + a.name;
            if (indexed) {
                this.beginAttrIterator(attr, a, "element");
                attr = "element";
            }
            this.jw.beginIf(attr + " != null");
            this.jw.beginIf("recursive");
            this.jw.writeEol(attr + ".childBeans(true, beans)");
            this.jw.end();
            this.jw.writeEol("beans.add(" + attr + ")");
            this.jw.end();
            if (!indexed) continue;
            this.jw.end();
        }
        if (this.config.isRespectExtension() && this.beanElement.getExtension() != null) {
            this.jw.writeEol("super.childBeans(recursive, beans)");
        }
        this.jw.endMethod();
    }

    public void genName() throws IOException {
        this.select(this.BODY_SECTION);
        this.jw.beginMethod("nameSelf", "", null, "String", 0);
        if (this.config.isGenerateParentRefs()) {
            this.jw.beginIf("parent != null");
            this.jw.writeEol("String parentName = parent.nameSelf()");
            this.jw.writeEol("String myName = parent.nameChild(this, false, false)");
            this.jw.writeEol("return parentName + \"/\" + myName");
            this.jw.end();
        }
        String beanName = Common.convertName(this.beanElement.node.getName());
        if (this.beanElement.isRoot) {
            this.jw.writeEol("return \"/" + beanName + "\"");
        } else {
            this.jw.writeEol("return \"" + beanName + "\"");
        }
        this.jw.endMethod();
        this.jw.beginMethod("nameChild", "Object childObj", null, "String", 0);
        this.jw.writeEol("return nameChild(childObj, false, false)");
        this.jw.endMethod();
        this.jw.bigComment("@param childObj  The child object to search for\n@param returnSchemaName  Whether or not the schema name should be returned or the property name\n@return null if not found");
        this.jw.beginMethod("nameChild", "Object childObj, boolean returnConstName, boolean returnSchemaName", null, "String", 0);
        this.jw.writeEol("return nameChild(childObj, returnConstName, returnSchemaName, false)");
        this.jw.endMethod();
        this.jw.bigComment("@param childObj  The child object to search for\n@param returnSchemaName  Whether or not the schema name should be returned or the property name\n@return null if not found");
        this.jw.beginMethod("nameChild", "Object childObj, boolean returnConstName, boolean returnSchemaName, boolean returnXPathName", null, "String", 0);
        HashMap<String, LinkedList<AbstractCodeGeneratorClass.Property>> typeMap = new HashMap<String, LinkedList<AbstractCodeGeneratorClass.Property>>();
        int size = this.attrList.size();
        for (int i = 0; i < size; ++i) {
            LinkedList<AbstractCodeGeneratorClass.Property> lst;
            AbstractCodeGeneratorClass.Property prop = (AbstractCodeGeneratorClass.Property)this.attrList.get(i);
            String type = JavaUtil.toObjectType(prop.getType());
            if (type.equals("String")) {
                type = "java.lang.String";
            }
            if ((lst = (LinkedList<AbstractCodeGeneratorClass.Property>)typeMap.get(type)) == null) {
                lst = new LinkedList<AbstractCodeGeneratorClass.Property>();
                typeMap.put(type, lst);
            }
            lst.add(prop);
        }
        for (String type : typeMap.keySet()) {
            boolean isString = type != null && type.equals("java.lang.String");
            this.jw.beginIf("childObj instanceof " + type);
            this.jw.writeEol(type, " child = (", type, ") childObj");
            boolean firstUseOfIndex = true;
            for (AbstractCodeGeneratorClass.Property prop : (List)typeMap.get(type)) {
                String attr = "_" + prop.name;
                String childExpr = "child";
                if (JavaUtil.isPrimitiveType(prop.getType())) {
                    childExpr = JavaUtil.fromObject(prop.getType(), "child");
                }
                if (prop.isIndexed()) {
                    if (firstUseOfIndex) {
                        firstUseOfIndex = false;
                        this.jw.writeEol("int index = 0");
                    } else {
                        this.jw.writeEol("index = 0");
                    }
                    this.beginAttrIterator(attr, prop, "element");
                    if (isString) {
                        this.jw.beginIf(childExpr + ".equals(element)");
                    } else {
                        this.jw.beginIf(childExpr + " == element");
                    }
                    this.jw.beginIf("returnConstName");
                    this.jw.writeEol("return ", prop.constName);
                    if (prop.type != 3840) {
                        this.jw.endElseBeginIf("returnSchemaName");
                        this.jw.writeEol("return \"", prop.dtdName, "\"");
                        this.jw.endElseBeginIf("returnXPathName");
                        this.jw.write("return \"");
                        if (prop.isAttribute()) {
                            this.jw.write("@");
                        }
                        this.jw.writeEol(prop.dtdName, "[position()=\"+index+\"]\"");
                    }
                    this.jw.endElseBegin();
                    this.jw.writeEol("return \"" + prop.getEventName() + ".\"+Integer.toHexString(index)");
                    this.jw.end();
                    this.jw.end();
                    this.jw.writeEol("++index");
                    this.jw.end();
                    continue;
                }
                if (isString) {
                    this.jw.beginIf(childExpr + ".equals(" + attr + ")");
                } else {
                    this.jw.beginIf(childExpr + " == " + attr);
                }
                this.jw.beginIf("returnConstName");
                this.jw.writeEol("return ", prop.constName);
                if (prop.type != 3840) {
                    this.jw.endElseBeginIf("returnSchemaName");
                    this.jw.writeEol("return \"", prop.dtdName, "\"");
                    this.jw.endElseBeginIf("returnXPathName");
                    this.jw.write("return \"");
                    if (prop.isAttribute()) {
                        this.jw.write("@");
                    }
                    this.jw.writeEol(prop.dtdName, "\"");
                }
                this.jw.endElseBegin();
                this.jw.writeEol("return \"" + prop.getEventName() + "\"");
                this.jw.end();
                this.jw.end();
            }
            this.jw.end();
        }
        if (this.config.isRespectExtension() && this.beanElement.getExtension() != null) {
            this.jw.writeEol("return super.nameChild(childObj, returnConstName, returnSchemaName, returnXPathName)");
        } else {
            this.jw.writeEol("return null");
        }
        this.jw.endMethod();
    }

    public void genToString() throws IOException {
        this.jw.beginMethod("toString", "", null, "String", 0);
        this.jw.writeEol("java.io.StringWriter sw = new java.io.StringWriter()");
        this.jw.beginTry();
        this.jw.writeEol("writeNode(sw)");
        this.jw.endCatch("java.io.IOException e");
        this.jw.comment("How can we actually get an IOException on a StringWriter?");
        this.jw.writeEol("throw new RuntimeException(e)");
        this.jw.end();
        this.jw.writeEol("return sw.toString()");
        this.jw.endMethod();
    }

    public void genExtendBaseBean() throws IOException {
        int i;
        int i2;
        int size = this.attrList.size();
        this.jw.beginMethod("dump", "StringBuffer str, String indent", null, "void", 0);
        this.jw.writeEol("str.append(toString())");
        this.jw.endMethod();
        this.jw.pushSelect(this.jw.DECL_SECTION);
        Object[] propByNameKeys = new String[size + 1];
        for (int i3 = 0; i3 < size; ++i3) {
            AbstractCodeGeneratorClass.Property a = (AbstractCodeGeneratorClass.Property)this.attrList.get(i3);
            propByNameKeys[i3] = a.name;
        }
        propByNameKeys[size] = "";
        this.jw.writeEol("private java.util.Map propByName = new java.util.HashMap(" + JavaUtil.getOptimialHashMapSize(propByNameKeys), ", 1.0f)");
        this.jw.popSelect();
        this.jw.beginMethod("beanProp", "String name", null, "org.netbeans.modules.schema2beans.BeanProp", 0);
        this.jw.writeEol("if (name == null) return null");
        this.jw.writeEol("org.netbeans.modules.schema2beans.BeanProp prop = (org.netbeans.modules.schema2beans.BeanProp) propByName.get(name)");
        this.jw.beginIf("prop == null");
        this.jw.writeEol("name = name.intern()");
        this.jw.writeEol("boolean indexed");
        this.jw.writeEol("int options");
        this.jw.writeEol("String constName");
        this.jw.writeEol("String schemaName");
        this.jw.writeEol("java.lang.reflect.Method writer = null");
        this.jw.writeEol("java.lang.reflect.Method arrayWriter = null");
        this.jw.writeEol("java.lang.reflect.Method reader = null");
        this.jw.writeEol("java.lang.reflect.Method arrayReader = null");
        this.jw.writeEol("java.lang.reflect.Method adder = null");
        this.jw.writeEol("java.lang.reflect.Method remover = null");
        boolean defaultKey = true;
        if (this.metaElement != null) {
            MetaProperty[] mp = this.metaElement.getMetaProperty();
            for (i2 = 0; i2 < mp.length; ++i2) {
                if (!mp[i2].isKey()) continue;
                defaultKey = false;
                break;
            }
        }
        this.jw.beginTry();
        for (i = 0; i < size; ++i) {
            MetaElement me;
            AbstractCodeGeneratorClass.Property a = (AbstractCodeGeneratorClass.Property)this.attrList.get(i);
            boolean indexed = a.isIndexed();
            String type = a.getType();
            MetaProperty mp = this.getMetaProperty(a.name);
            boolean keyedElement = defaultKey;
            boolean genVetoable = this.config.isVetoable();
            if (mp != null) {
                keyedElement = mp.isKey() ? true : defaultKey;
                boolean bl = genVetoable = mp.isVetoable() ? true : genVetoable;
            }
            if ((me = this.getMetaElement(a)) != null) {
                boolean bl = genVetoable = me.isVetoable() ? true : genVetoable;
            }
            if (a.isBean) {
                genVetoable = false;
            }
            String signatureType = a.getSignatureType(this.packageName);
            this.jw.beginIf("name == " + a.constName + "");
            this.jw.writeEol("indexed = " + indexed);
            this.jw.writeEol("constName = ", a.constName, "");
            this.jw.writeEol("schemaName = \"", a.dtdName, "\"");
            this.jw.write("options = ");
            if (a.ored) {
                this.jw.write("org.netbeans.modules.schema2beans.Common.SEQUENCE_OR | ");
            }
            if (genVetoable) {
                this.jw.write("org.netbeans.modules.schema2beans.Common.TYPE_VETOABLE |");
            }
            if (a.type == 768 && !a.getCanBeEmpty()) {
                this.gen("org.netbeans.modules.schema2beans.Common.TYPE_SHOULD_NOT_BE_EMPTY | ");
            }
            if (keyedElement) {
                this.gen("org.netbeans.modules.schema2beans.Common.TYPE_KEY | ");
            }
            this.jw.writeEol("org.netbeans.modules.schema2beans.Common.", Common.instanceToCommonString(a.elementInstance), "|org.netbeans.modules.schema2beans.Common.", Common.typeToString(a.type));
            if (indexed) {
                this.jw.writeEol("reader = getClass().getMethod(\"", a.getReadMethod(true), "\", new Class[] {Integer.TYPE})");
                this.jw.writeEol("arrayReader = getClass().getMethod(\"", a.getReadMethod(false), "\", new Class[] {})");
                this.jw.writeEol("writer = getClass().getMethod(\"", a.getWriteMethod(), "\", new Class[] {Integer.TYPE, ", signatureType + ".class})");
                this.jw.writeEol("arrayWriter = getClass().getMethod(\"", a.getWriteMethod(), "\", new Class[] {", signatureType + "[].class})");
                this.jw.writeEol("adder = getClass().getMethod(\"", a.getAddMethod(), "\", new Class[] {", signatureType + ".class})");
                this.jw.writeEol("remover = getClass().getMethod(\"", a.getRemoveMethod(), "\", new Class[] {", signatureType + ".class})");
            } else {
                this.jw.writeEol("writer = getClass().getMethod(\"", a.getWriteMethod(), "\", new Class[] {", signatureType + ".class})");
                this.jw.writeEol("reader = getClass().getMethod(\"", a.getReadMethod(false), "\", new Class[] {})");
            }
            this.jw.end(false);
            this.jw.write(" else ");
        }
        this.jw.begin();
        this.jw.comment("Check if name is a schema name.");
        for (i = 0; i < size; ++i) {
            AbstractCodeGeneratorClass.Property a = (AbstractCodeGeneratorClass.Property)this.attrList.get(i);
            if (a.dtdName.equals(a.name)) continue;
            this.jw.beginIf("name == \"" + a.dtdName + "\"");
            this.jw.writeEol("prop = beanProp(", a.constName, ")");
            this.jw.writeEol("propByName.put(name, prop)");
            this.jw.writeEol("return prop");
            this.jw.end();
        }
        this.genInvalidName("name");
        this.jw.end();
        this.jw.endCatch("java.lang.NoSuchMethodException e");
        this.jw.writeEol("throw new RuntimeException(e)");
        this.jw.end();
        this.jw.write("prop = new org.netbeans.modules.schema2beans.ReflectiveBeanProp(this, schemaName, ");
        this.jw.write("constName, options, getClass(), ");
        this.jw.writeEol("" + this.beanElement.isRoot, ", writer, arrayWriter, reader, arrayReader, adder, remover)");
        this.jw.writeEol("propByName.put(name, prop)");
        this.jw.end();
        this.jw.writeEol("return prop");
        this.jw.endMethod();
        this.jw.beginMethod("beanProp", "", null, "org.netbeans.modules.schema2beans.BeanProp", 0);
        this.jw.beginIf("parent == null");
        this.jw.writeEol("org.netbeans.modules.schema2beans.BeanProp prop = (org.netbeans.modules.schema2beans.BeanProp) propByName.get(\"\")");
        this.jw.beginIf("prop == null");
        this.jw.write("prop = new org.netbeans.modules.schema2beans.ReflectiveBeanProp(this, \"", this.beanElement.node.getName(), "\", \"", this.className);
        this.jw.writeEol("\", org.netbeans.modules.schema2beans.Common.TYPE_1 | org.netbeans.modules.schema2beans.Common.TYPE_BEAN, ", this.className, ".class, isRoot(), null, null, null, null, null, null)");
        this.jw.writeEol("propByName.put(\"\", prop)");
        this.jw.end();
        this.jw.writeEol("return prop");
        this.jw.end();
        this.jw.writeEol("String myConstName = parent.nameChild(this, true, false)");
        this.jw.writeEol("return parent.beanProp(myConstName)");
        this.jw.endMethod();
        this.jw.beginMethod("beanProp", "int order", null, "org.netbeans.modules.schema2beans.BeanProp", 0 | 0x400);
        this.jw.writeEol("prepareBeanPropList()");
        this.jw.writeEol("return (org.netbeans.modules.schema2beans.BeanProp) beanPropList.get(order)");
        this.jw.endMethod();
        this.jw.beginMethod("parent", "", null, "org.netbeans.modules.schema2beans.BaseBean", 0);
        this.jw.writeEol("return (org.netbeans.modules.schema2beans.BaseBean) parent");
        this.jw.endMethod();
        this.jw.beginMethod("_getParent", "", null, "org.netbeans.modules.schema2beans.Bean", 0);
        this.jw.writeEol("return parent");
        this.jw.endMethod();
        this.jw.beginMethod("newInstance", "String name", null, "org.netbeans.modules.schema2beans.BaseBean", 0 | 0x400);
        this.jw.writeEol("throw new UnsupportedOperationException(\"Not implemented\")");
        this.jw.endMethod();
        this.jw.beginMethod("dtdName", "", null, "String", 0);
        this.jw.beginIf("parent == null");
        if (!this.beanElement.isRoot()) {
            this.jw.comment("Not necessarily the right schema name, but make a good guess.");
        }
        this.jw.writeEol("return \"", this.beanElement.node.getName(), "\"");
        this.jw.end();
        this.jw.writeEol("return parent.nameChild(this, false, true)");
        this.jw.endMethod();
        this.jw.beginMethod("comments", "", null, "org.w3c.dom.Comment[]", 0 | 0x400);
        this.jw.writeEol("throw new UnsupportedOperationException(\"Not implemented\")");
        this.jw.endMethod();
        this.jw.beginMethod("addComment", "String comment", null, "org.w3c.dom.Comment", 0 | 0x400);
        this.jw.writeEol("throw new UnsupportedOperationException(\"Not implemented\")");
        this.jw.endMethod();
        this.jw.beginMethod("removeComment", "org.w3c.dom.Comment comment", null, "void", 0 | 0x400);
        this.jw.writeEol("throw new UnsupportedOperationException(\"Not implemented\")");
        this.jw.endMethod();
        this.jw.beginMethod("createProperty", "String dtdName, String beanName, Class type", null, "void", 0 | 0x400);
        this.jw.writeEol("throw new UnsupportedOperationException(\"Not implemented\")");
        this.jw.endMethod();
        this.jw.beginMethod("createProperty", "String dtdName, String beanName, int option, Class type", null, "void", 0 | 0x400);
        this.jw.writeEol("throw new UnsupportedOperationException(\"Not implemented\")");
        this.jw.endMethod();
        this.jw.beginMethod("createRoot", "String dtdName, String beanName, int option, Class type", null, "void", 0 | 0x400);
        this.jw.writeEol("throw new UnsupportedOperationException(\"Not implemented\")");
        this.jw.endMethod();
        this.jw.beginMethod("knownValues", "String name", null, "Object[]", 0 | 0x400);
        this.jw.writeEol("throw new UnsupportedOperationException(\"Not implemented\")");
        this.jw.endMethod();
        this.jw.beginMethod("addKnownValue", "String name, Object value", null, "void", 0 | 0x400);
        this.jw.writeEol("throw new UnsupportedOperationException(\"Not implemented\")");
        this.jw.endMethod();
        this.jw.beginMethod("createAttribute", "String dtdName, String name, int type, String[] values, String defValue", null, "void", 0 | 0x400);
        this.jw.writeEol("throw new UnsupportedOperationException(\"Not implemented\")");
        this.jw.endMethod();
        this.jw.beginMethod("createAttribute", "String propName, String dtdName, String name, int type, String[] values, String defValue", null, "void", 0 | 0x400);
        this.jw.writeEol("throw new UnsupportedOperationException(\"Not implemented\")");
        this.jw.endMethod();
        this.jw.beginMethod("setAttributeValue", "String propName, String name, String value", null, "void", 0 | 0x400);
        this.jw.writeEol("throw new UnsupportedOperationException(\"Not implemented\")");
        this.jw.endMethod();
        this.jw.beginMethod("setAttributeValue", "String name, String value", null, "void", 0 | 0x400);
        this.jw.writeEol("throw new UnsupportedOperationException(\"Not implemented\")");
        this.jw.endMethod();
        this.jw.beginMethod("getAttributeValue", "String name", null, "String", 0 | 0x400);
        this.jw.writeEol("throw new UnsupportedOperationException(\"Not implemented\")");
        this.jw.endMethod();
        this.jw.beginMethod("getAttributeValue", "String propName, String name", null, "String", 0 | 0x400);
        this.jw.writeEol("throw new UnsupportedOperationException(\"Not implemented\")");
        this.jw.endMethod();
        this.jw.beginMethod("setAttributeValue", "String propName, int index, String name, String value", null, "void", 0 | 0x400);
        this.jw.writeEol("throw new UnsupportedOperationException(\"Not implemented\")");
        this.jw.endMethod();
        this.jw.beginMethod("getAttributeValue", "String propName, int index, String name", null, "String", 0 | 0x400);
        this.jw.writeEol("throw new UnsupportedOperationException(\"Not implemented\")");
        this.jw.endMethod();
        this.jw.beginMethod("getAttributeNames", "String propName", null, "String[]", 0);
        this.jw.writeEol("return new String[] {}");
        this.jw.endMethod();
        this.jw.beginMethod("getAttributeNames", "", null, "String[]", 0);
        this.jw.writeEol("return new String[] {}");
        this.jw.endMethod();
        this.jw.beginMethod("listAttributes", "String propName", null, "org.netbeans.modules.schema2beans.BaseAttribute[]", 0);
        this.jw.writeEol("return new org.netbeans.modules.schema2beans.BaseAttribute[] {}");
        this.jw.endMethod();
        this.jw.beginMethod("listAttributes", "", null, "org.netbeans.modules.schema2beans.BaseAttribute[]", 0);
        this.jw.writeEol("return new org.netbeans.modules.schema2beans.BaseAttribute[] {}");
        this.jw.endMethod();
        this.jw.beginMethod("findAttributeValue", "String attrName, String value", null, "String[]", 0);
        this.jw.writeEol("return new String[] {}");
        this.jw.endMethod();
        this.jw.beginMethod("findPropertyValue", "String propName, Object value", null, "String[]", 0 | 0x400);
        this.jw.writeEol("throw new UnsupportedOperationException(\"Not implemented\")");
        this.jw.endMethod();
        this.jw.beginMethod("findValue", "Object value", null, "String[]", 0 | 0x400);
        this.jw.writeEol("throw new UnsupportedOperationException(\"Not implemented\")");
        this.jw.endMethod();
        this.jw.beginMethod("buildPathName", "StringBuffer str", null, "void", 1);
        this.jw.writeEol("str.append(nameSelf())");
        this.jw.endMethod();
        this.jw.beginMethod("graphManager", "", null, "org.netbeans.modules.schema2beans.GraphManager", 0);
        this.jw.beginIf("graphManager == null");
        this.jw.beginIf("parent == null");
        this.jw.writeEol("graphManager = new org.netbeans.modules.schema2beans.GraphManager(this)");
        this.jw.endElseBegin();
        this.jw.writeEol("graphManager = parent.graphManager()");
        this.jw.end();
        this.jw.end();
        this.jw.writeEol("return graphManager");
        this.jw.endMethod();
        this.jw.beginMethod("clone", "", null, "Object", 0 | 0x100);
        this.jw.writeEol("return new ", this.className, "(this, null, false)");
        this.jw.endMethod();
        this.jw.beginMethod("cloneData", "", null, "Object", 0 | 0x100);
        this.jw.writeEol("return new ", this.className, "(this, null, true)");
        this.jw.endMethod();
        this.jw.pushSelect(this.DECL_SECTION);
        this.jw.write("private java.util.List beanPropList = null");
        this.jw.eol(false);
        this.jw.write("\t");
        this.jw.comment("List<org.netbeans.modules.schema2beans.BeanProp>");
        this.jw.popSelect();
        this.jw.beginMethod("prepareBeanPropList", "", null, "void", 3);
        this.jw.beginIf("beanPropList == null");
        this.jw.writeEol("beanPropList = new java.util.ArrayList(" + size + ")");
        for (i = 0; i < size; ++i) {
            AbstractCodeGeneratorClass.Property a = (AbstractCodeGeneratorClass.Property)this.attrList.get(i);
            this.jw.writeEol("beanPropList.add(beanProp(", a.constName, "))");
        }
        this.jw.end();
        this.jw.endMethod();
        this.jw.beginMethod("beanPropsIterator", "", null, "java.util.Iterator", 1);
        this.jw.writeEol("prepareBeanPropList()");
        this.jw.writeEol("return beanPropList.iterator()");
        this.jw.endMethod();
        this.jw.beginMethod("beanProps", "", null, "org.netbeans.modules.schema2beans.BeanProp[]", 0);
        this.jw.writeEol("prepareBeanPropList()");
        this.jw.writeEol("org.netbeans.modules.schema2beans.BeanProp[] ret = new org.netbeans.modules.schema2beans.BeanProp[" + size + "]");
        this.jw.writeEol("ret = (org.netbeans.modules.schema2beans.BeanProp[]) beanPropList.toArray(ret)");
        this.jw.writeEol("return ret");
        this.jw.endMethod();
        this.jw.beginMethod("setValue", "String name, Object value", null, "void", 0);
        new AbstractCodeGeneratorClass.NamePropertyVisitor("name"){

            @Override
            public void generateProp() throws IOException {
                if (this.curProp.isIndexed()) {
                    JavaBeanClass.this.jw.write(this.curProp.getWriteMethod(), "(");
                    JavaBeanClass.this.jw.writeEol("(", this.curProp.getType(), "[]) value)");
                } else {
                    JavaBeanClass.this.jw.write(this.curProp.getWriteMethod(), "(");
                    JavaBeanClass.this.jw.write(JavaUtil.fromObject(this.curProp.getType(), "value"));
                    JavaBeanClass.this.jw.writeEol(")");
                }
            }
        }.generate();
        this.jw.endMethod();
        this.jw.beginMethod("setValue", "String name, int index, Object value", null, "void", 0);
        new AbstractCodeGeneratorClass.NamePropertyVisitor("name"){

            @Override
            public void generateProp() throws IOException {
                if (this.curProp.isIndexed()) {
                    JavaBeanClass.this.jw.write(this.curProp.getWriteMethod(), "(index, ");
                    JavaBeanClass.this.jw.write(JavaUtil.fromObject(this.curProp.getType(), "value"));
                    JavaBeanClass.this.jw.writeEol(")");
                } else {
                    JavaBeanClass.this.jw.writeEol("throw new IllegalArgumentException(name+\" is not an indexed property for ", JavaBeanClass.this.className, "\")");
                }
            }
        }.generate();
        this.jw.endMethod();
        this.jw.beginMethod("getValue", "String name", null, "Object", 0);
        new AbstractCodeGeneratorClass.NamePropertyVisitor("name"){

            @Override
            public void generateProp() throws IOException {
                JavaBeanClass.this.jw.write("return ");
                if (this.curProp.isIndexed()) {
                    JavaBeanClass.this.jw.writeEol(this.curProp.getReadMethod(false) + "()");
                } else {
                    JavaBeanClass.this.jw.writeEol(JavaUtil.toObject(this.curProp.getReadMethod(false) + "()", this.curProp.getType(), JavaBeanClass.this.config.isForME(), JavaBeanClass.this.config.isJava5()));
                }
            }
        }.generate();
        this.jw.endMethod();
        this.jw.beginMethod("getValue", "String name, int index", null, "Object", 0);
        new AbstractCodeGeneratorClass.NamePropertyVisitor("name"){

            @Override
            public boolean skip() {
                return !this.curProp.isIndexed();
            }

            @Override
            public void generateProp() throws IOException {
                JavaBeanClass.this.jw.write("return ");
                JavaBeanClass.this.jw.writeEol(JavaUtil.toObject(this.curProp.getReadMethod(true) + "(index)", this.curProp.getType(), JavaBeanClass.this.config.isForME(), JavaBeanClass.this.config.isJava5()));
            }

            @Override
            public void postGenerate() throws IOException {
            }
        }.generate();
        new AbstractCodeGeneratorClass.NamePropertyVisitor("name"){

            @Override
            public void preGenerate() throws IOException {
            }

            @Override
            public boolean skip() {
                return this.curProp.isIndexed();
            }

            @Override
            public void generateProp() throws IOException {
                JavaBeanClass.this.jw.beginIf("index > 0");
                JavaBeanClass.this.jw.writeEol("throw new IllegalArgumentException(\"index > 0\")");
                JavaBeanClass.this.jw.end();
                JavaBeanClass.this.jw.write("return ");
                JavaBeanClass.this.jw.writeEol(JavaUtil.toObject(this.curProp.getReadMethod(false) + "()", this.curProp.getType(), JavaBeanClass.this.config.isForME(), JavaBeanClass.this.config.isJava5()));
            }
        }.generate();
        this.jw.endMethod();
        this.jw.beginMethod("mergeUpdate", "org.netbeans.modules.schema2beans.BaseBean sourceBean", null, "void", 0);
        this.jw.writeEol(this.fullClassName, " source = (", this.fullClassName, ") sourceBean");
        boolean isArrayStyle = this.config.getIndexedPropertyType() == null;
        for (i2 = 0; i2 < size; ++i2) {
            AbstractCodeGeneratorClass.Property a = (AbstractCodeGeneratorClass.Property)this.attrList.get(i2);
            boolean indexed = a.isIndexed();
            String type = a.getType().intern();
            boolean willCopy = this.genCopyWillCopy(a);
            String getter = "source." + a.getReadMethod(false) + "()";
            String signatureType = a.getSignatureType(this.packageName);
            String baseFullClassName = a.getTypeFullClassName(this.packageName);
            String fullClassName = indexed ? baseFullClassName + "[]" : baseFullClassName;
            this.jw.begin();
            this.jw.write(fullClassName, " srcProperty = ");
            if (!signatureType.equals(baseFullClassName)) {
                this.jw.write("(", fullClassName, ") ");
            }
            this.jw.writeEol(getter);
            String srcProperty = "srcProperty";
            if (a.isBean) {
                if (indexed) {
                    this.jw.writeEol("int destSize = ", a.getSizeMethod(), "()");
                    this.jw.beginIf("destSize == srcProperty.length");
                    srcProperty = "srcProperty[i]";
                    this.jw.beginFor("int i = 0", "i < srcProperty.length", "++i");
                    this.genMergeUpdateBean(a, srcProperty, indexed, signatureType, baseFullClassName, isArrayStyle, true);
                    this.jw.endElseBegin();
                    this.jw.writeEol(fullClassName, " destArray = new ", baseFullClassName, "[srcProperty.length]");
                    this.jw.beginFor("int i = 0", "i < srcProperty.length", "++i");
                    this.genMergeUpdateBean(a, srcProperty, indexed, signatureType, baseFullClassName, isArrayStyle, false);
                    this.jw.end();
                    this.jw.writeEol(a.getWriteMethod(), "(destArray)");
                    this.jw.end();
                } else {
                    this.genMergeUpdateBean(a, srcProperty, indexed, signatureType, baseFullClassName, isArrayStyle, false);
                }
            } else if (indexed && (willCopy || isArrayStyle)) {
                this.jw.writeEol(fullClassName, " destArray = new ", baseFullClassName, "[srcProperty.length]");
                this.jw.beginFor("int i = 0", "i < srcProperty.length", "++i");
                srcProperty = "srcProperty[i]";
                this.jw.write("destArray[i] = ");
                this.genCopy(srcProperty, a, "false");
                this.jw.eol();
                this.jw.end();
                this.jw.writeEol(a.getWriteMethod(), "(destArray)");
            } else {
                this.jw.write(a.getWriteMethod(), "(");
                this.genCopy(srcProperty, a, "false");
                this.jw.writeEol(")");
            }
            this.jw.end();
        }
        this.jw.endMethod();
        if (this.beanElement.isRoot()) {
            this.jw.beginMethod("isRoot", "", null, "boolean", 0);
            this.jw.writeEol("return true");
            this.jw.endMethod();
            this.jw.beginMethod("createGraph", "java.io.InputStream in, boolean validate", "java.io.IOException, javax.xml.parsers.ParserConfigurationException, org.xml.sax.SAXException", this.className, 0 | 0x10 | 0x200);
            this.jw.writeEol("return read(new org.xml.sax.InputSource(in), validate, null, null)");
            this.jw.endMethod();
            this.jw.beginMethod("createGraph", "java.io.InputStream in", "java.io.IOException, javax.xml.parsers.ParserConfigurationException, org.xml.sax.SAXException", this.className, 0 | 0x10 | 0x200);
            this.jw.writeEol("return createGraph(in, false)");
            this.jw.endMethod();
            this.jw.beginMethod("createGraph", "", null, this.className, 0 | 0x10 | 0x200);
            this.jw.writeEol("return new ", this.className, "()");
            this.jw.endMethod();
            this.jw.beginMethod("createGraph", "org.w3c.dom.Document document", null, this.className, 0 | 0x10);
            this.jw.writeEol("return read(document)");
            this.jw.endMethod();
            this.jw.pushSelect(this.CONSTRUCTOR_SECTION);
            this.jw.beginConstructor(this.className, "org.w3c.dom.Node doc, int currentlyUnusedOptions");
            this.jw.writeEol("this()");
            this.jw.writeEol("readFromDocument((org.w3c.dom.Document) doc)");
            this.jw.end();
            this.jw.cr();
            this.jw.popSelect();
        } else {
            this.jw.bigComment("@deprecated");
            this.jw.beginMethod("write", "java.io.Writer out, String encoding", "java.io.IOException", "void", 0 | 0x200);
            this.jw.writeEol("writeNode(out)");
            this.jw.endMethod();
            this.jw.bigComment("@deprecated");
            this.jw.beginMethod("write", "java.io.OutputStream out", "java.io.IOException", "void", 0 | 0x200);
            if (this.config.isJava5()) {
                this.jw.writeEol("java.io.PrintWriter pw = new java.io.PrintWriter(new java.io.OutputStreamWriter(out, java.nio.charset.Charset.defaultCharset()))");
            } else {
                this.jw.writeEol("java.io.PrintWriter pw = new java.io.PrintWriter(out)");
            }
            this.jw.writeEol("writeNode(pw)");
            this.jw.writeEol("pw.flush()");
            this.jw.endMethod();
        }
    }

    private void genMergeUpdateBean(AbstractCodeGeneratorClass.Property a, String srcProperty, boolean indexed, String signatureType, String baseFullClassName, boolean isArrayStyle, boolean mergeEach) throws IOException {
        String attr = "_" + a.name;
        this.jw.writeEol(baseFullClassName, " dest");
        if (!indexed) {
            this.jw.writeEol("boolean needToSet = false");
        }
        this.jw.beginIf(srcProperty + " == null");
        this.jw.writeEol("dest = null");
        if (!indexed) {
            this.jw.writeEol("needToSet = true");
        }
        this.jw.endElseBegin();
        if (indexed) {
            this.jw.beginIf("i < destSize");
        }
        this.jw.write("dest = ");
        if (!signatureType.equals(baseFullClassName)) {
            this.jw.write("(", baseFullClassName, ") ");
        }
        this.jw.write(a.getReadMethod(indexed), "(");
        if (indexed) {
            this.jw.write("i");
        }
        this.jw.writeEol(")");
        if (indexed) {
            if (!mergeEach) {
                this.jw.beginIf("!" + srcProperty + ".equals(dest)");
                this.jw.comment("It's different, so have it just dup the source one.");
                this.jw.writeEol("dest = null");
                this.jw.end();
            }
            this.jw.endElseBegin();
            this.jw.writeEol("dest = null");
            this.jw.end();
        }
        this.jw.beginIf("dest == null");
        this.jw.comment("Use a temp variable, and store it after we've merged everything into it, so as to make it only 1 change event.");
        this.jw.writeEol("dest = new ", baseFullClassName, "(", srcProperty + ", this, false)");
        if (!indexed) {
            this.jw.writeEol("needToSet = true");
            this.jw.endElseBegin();
            this.jw.writeEol("dest.mergeUpdate(", srcProperty, ")");
            this.jw.end();
        } else if (mergeEach) {
            this.jw.endElseBegin();
            this.jw.writeEol("dest.mergeUpdate(", srcProperty, ")");
            this.jw.end();
        }
        this.jw.end();
        if (indexed) {
            if (mergeEach) {
                this.jw.comment("Merge events were generated by the above dest.mergeUpdate, so just set it directly now.");
                if (isArrayStyle) {
                    this.jw.writeEol(attr, "[index] = value");
                } else {
                    this.jw.writeEol(attr, ".set(i, dest)");
                }
            } else {
                this.jw.writeEol("destArray[i] = dest");
            }
            this.jw.end();
        } else {
            this.jw.beginIf("needToSet");
            this.jw.write(a.getWriteMethod(), "(");
            this.jw.writeEol("dest)");
            this.jw.end();
        }
    }

    public void genTrailer(int out) {
        this.select(out);
        if (this.metaElement != null && this.metaElement.getUserCode() != null) {
            String userCode = this.metaElement.getUserCode();
            this.cr();
            this.gencr(userCode);
        }
    }

    public void genFinishClass(int out) {
        this.select(out);
        this.end();
        this.cr();
    }

    @Override
    public void setInvalidPropertyNames(Map invalidNames) {
        invalidNames.put("Class", null);
        if (this.config.isExtendBaseBean()) {
            invalidNames.put("Property", null);
            invalidNames.put("AttributeNames", null);
        }
    }

    protected void beginAttrIterator(String attr, AbstractCodeGeneratorClass.Property a, String elementName) throws IOException {
        boolean isArrayStyle;
        String fullType = this.getTypeFullClassName(a);
        boolean bl = isArrayStyle = this.config.getIndexedPropertyType() == null;
        if (isArrayStyle) {
            this.jw.beginFor("int elementIndex = 0", "elementIndex < " + attr + ".length", "++elementIndex");
        } else {
            this.jw.beginFor("java.util.Iterator it = " + attr + ".iterator()", "it.hasNext()", "");
        }
        this.jw.write(fullType);
        this.jw.write(" ", elementName, " = ");
        if (isArrayStyle) {
            this.jw.writeEol(attr, "[elementIndex]");
        } else {
            this.jw.writeEol(JavaUtil.fromObject(fullType, "it.next()"));
        }
    }

    protected void genNewEvent(AbstractCodeGeneratorClass.Property a, String index, String oldValue, String newValue, String type) throws IOException {
        this.jw.write("new java.beans.PropertyChangeEvent(this, nameSelf()+\"/");
        this.jw.write(a.getEventName());
        if (index.equals("")) {
            this.jw.write("\"");
        } else if (index.equals("-1")) {
            this.jw.write(".", index, "\"");
        } else {
            this.jw.write(".\"+Integer.toHexString(", index, ")");
        }
        this.jw.write(", ");
        if ("null".equals(oldValue)) {
            this.jw.write("null");
        } else {
            this.jw.write(JavaUtil.toObject(oldValue, type, this.config.isForME(), this.config.isJava5()));
        }
        this.jw.write(", ");
        if ("null".equals(newValue)) {
            this.jw.write("null");
        } else {
            this.jw.write(JavaUtil.toObject(newValue, type, this.config.isForME(), this.config.isJava5()));
        }
        this.jw.write(")");
    }

    @Override
    protected boolean hasDeepCopyConstructor() {
        return true;
    }
}

