/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript.cdtdebug.ui.actions;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.debugger.ActionsManager;
import org.netbeans.lib.chrome_devtools_protocol.CDTUtil;
import org.netbeans.lib.chrome_devtools_protocol.debugger.CallFrame;
import org.netbeans.lib.chrome_devtools_protocol.debugger.ContinueToLocationRequest;
import org.netbeans.lib.chrome_devtools_protocol.debugger.Location;
import org.netbeans.modules.javascript.cdtdebug.CDTDebugger;
import org.netbeans.modules.javascript.cdtdebug.CDTScript;
import org.netbeans.modules.javascript2.debug.ui.JSUtils;
import org.netbeans.spi.debugger.ActionsProviderSupport;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.debugger.ui.CodeEvaluator;
import org.netbeans.spi.debugger.ui.EditorContextDispatcher;
import org.openide.filesystems.FileObject;
import org.openide.text.Line;

public class CDTDebugActionsProvider
extends ActionsProviderSupport
implements CDTDebugger.Listener {
    private static final Logger LOG = Logger.getLogger(CDTDebugActionsProvider.class.getName());
    private static final Set<Object> ACTIONS = Collections.unmodifiableSet(new HashSet<Object>(Arrays.asList(ActionsManager.ACTION_RUN_TO_CURSOR, ActionsManager.ACTION_EVALUATE)));
    private final CDTDebugger dbg;
    private final PropertyChangeListener jsFileContextListener = new JSFileContextListener();

    public CDTDebugActionsProvider(ContextProvider contextProvider) {
        this.dbg = (CDTDebugger)contextProvider.lookupFirst(null, CDTDebugger.class);
        this.dbg.addListener((CDTDebugger.Listener)this);
        this.notifySuspended(false);
    }

    public void postAction(Object action, Runnable actionPerformedNotifier) {
        if (action == ActionsManager.ACTION_EVALUATE) {
            CodeEvaluator.getDefault().open();
            actionPerformedNotifier.run();
        } else {
            super.postAction(action, actionPerformedNotifier);
        }
    }

    public void doAction(Object action) {
        Line currentLine;
        LOG.log(Level.FINE, "doAction({0})", action);
        if (action == ActionsManager.ACTION_RUN_TO_CURSOR && (currentLine = JSUtils.getCurrentLine()) != null) {
            FileObject fo = (FileObject)currentLine.getLookup().lookup(FileObject.class);
            URI foUri = fo.toURI();
            String scriptId = null;
            for (CDTScript s : this.dbg.getScriptsHandler().getScripts()) {
                if (!s.getUrl().equals(foUri)) continue;
                scriptId = s.getScriptId();
                break;
            }
            if (scriptId == null) {
                return;
            }
            CDTUtil.toNodeUrl((URI)fo.toURI());
            ContinueToLocationRequest ctlr = new ContinueToLocationRequest();
            Location location = new Location();
            location.setScriptId(scriptId);
            location.setLineNumber(currentLine.getLineNumber());
            ctlr.setLocation(location);
            this.dbg.getConnection().getDebugger().continueToLocation(ctlr);
        }
    }

    public Set getActions() {
        return ACTIONS;
    }

    public void notifySuspended(boolean suspended) {
        this.setEnabled(ActionsManager.ACTION_EVALUATE, suspended);
        if (suspended) {
            EditorContextDispatcher.getDefault().addPropertyChangeListener("text/javascript", this.jsFileContextListener);
            this.setEnabled(ActionsManager.ACTION_RUN_TO_CURSOR, JSUtils.getCurrentLine() != null);
        } else {
            EditorContextDispatcher.getDefault().removePropertyChangeListener(this.jsFileContextListener);
            this.setEnabled(ActionsManager.ACTION_RUN_TO_CURSOR, false);
        }
    }

    public void notifyCurrentFrame(CallFrame cf) {
    }

    public void notifyFinished() {
        EditorContextDispatcher.getDefault().removePropertyChangeListener(this.jsFileContextListener);
    }

    private class JSFileContextListener
    implements PropertyChangeListener {
        private JSFileContextListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            CDTDebugActionsProvider.this.setEnabled(ActionsManager.ACTION_RUN_TO_CURSOR, JSUtils.getCurrentLine() != null);
        }
    }
}

