/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript.cdtdebug.ui.eval;

import java.util.List;
import javax.swing.JEditorPane;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.lib.chrome_devtools_protocol.debugger.CallFrame;
import org.netbeans.lib.chrome_devtools_protocol.runtime.RemoteObject;
import org.netbeans.modules.javascript.cdtdebug.CDTDebugger;
import org.netbeans.modules.javascript.cdtdebug.ScriptsHandler;
import org.netbeans.modules.javascript.cdtdebug.ui.EditorUtils;
import org.netbeans.modules.javascript.cdtdebug.ui.eval.VarOrError;
import org.netbeans.modules.javascript.cdtdebug.vars.CDTEvaluator;
import org.netbeans.modules.javascript.cdtdebug.vars.EvaluationError;
import org.netbeans.modules.javascript.cdtdebug.vars.Variable;
import org.netbeans.modules.javascript2.debug.ui.EditorContextSetter;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.debugger.ui.CodeEvaluator;
import org.openide.filesystems.FileObject;
import org.openide.text.Line;
import org.openide.util.RequestProcessor;

public class CDTCodeEvaluator
extends CodeEvaluator.EvaluatorService {
    private static RequestProcessor rp = new RequestProcessor("Debugger Evaluator", 1);
    private final CDTDebugger dbg;
    private final CDTContextProvider contextProvider = new CDTContextProvider();
    private final CodeEvaluator.DefaultExpressionsHistoryPersistence historyPersistence;
    private final CodeEvaluator.Result<VarOrError, CodeEvaluator.Result.DefaultHistoryItem> result;
    private final RequestProcessor.Task evalTask = rp.create((Runnable)new EvaluateTask());
    private String expression;

    public CDTCodeEvaluator(ContextProvider contextProvider) {
        this.dbg = (CDTDebugger)contextProvider.lookupFirst(null, CDTDebugger.class);
        this.historyPersistence = CodeEvaluator.DefaultExpressionsHistoryPersistence.create((String)"javascript-cdtengine");
        this.result = CodeEvaluator.Result.get((DebuggerEngine)((DebuggerEngine)contextProvider.lookupFirst(null, DebuggerEngine.class)));
    }

    public void setupContext(JEditorPane editorPane, Runnable setUpCallback) {
        EditorContextSetter.setContext((JEditorPane)editorPane, (EditorContextSetter.EditorContextProvider)this.contextProvider, (Runnable)setUpCallback);
    }

    public boolean canEvaluate() {
        return this.dbg.isSuspended();
    }

    public void evaluate(String expression) {
        this.expression = expression;
        this.evalTask.schedule(0);
    }

    private String getExpression() {
        return this.expression;
    }

    public List<String> getExpressionsHistory() {
        return this.historyPersistence.getExpressions();
    }

    private class CDTContextProvider
    implements EditorContextSetter.EditorContextProvider {
        private CDTContextProvider() {
        }

        public Line.Part getContext() {
            FileObject file;
            CallFrame frame = CDTCodeEvaluator.this.dbg.getCurrentFrame();
            ScriptsHandler sh = CDTCodeEvaluator.this.dbg.getScriptsHandler();
            if (frame != null && (file = sh.getFile(frame.getLocation().getScriptId())) != null) {
                Line l;
                Integer column;
                int line = frame.getLocation().getLineNumber();
                if (line < 0) {
                    line = 0;
                }
                if ((column = frame.getLocation().getColumnNumber()) == null || column < 0) {
                    column = 0;
                }
                if ((l = EditorUtils.getLine(CDTCodeEvaluator.this.dbg, file, line, column)) != null) {
                    return l.createPart(column.intValue(), 0);
                }
            }
            return null;
        }
    }

    private class EvaluateTask
    implements Runnable {
        private EvaluateTask() {
        }

        @Override
        public void run() {
            VarOrError voe;
            String exp = CDTCodeEvaluator.this.getExpression();
            if (exp == null || "".equals(exp)) {
                return;
            }
            CallFrame frame = CDTCodeEvaluator.this.dbg.getCurrentFrame();
            if (frame == null) {
                return;
            }
            try {
                RemoteObject value = CDTEvaluator.evaluate((CDTDebugger)CDTCodeEvaluator.this.dbg, (String)CDTCodeEvaluator.this.expression);
                Variable var = new Variable("<EvaluationResult>", value);
                voe = new VarOrError(var);
            }
            catch (EvaluationError ex) {
                voe = new VarOrError(ex.getMessage());
            }
            CDTCodeEvaluator.this.result.setAndOpen(exp, (Object)voe, (Object)this.getHistoryItem(exp, voe));
            CDTCodeEvaluator.this.historyPersistence.addExpression(exp);
            CDTCodeEvaluator.this.firePropertyChange("expressionsHistory", null, null);
        }

        private CodeEvaluator.Result.DefaultHistoryItem getHistoryItem(String expr, VarOrError voe) {
            if (voe != null) {
                if (voe.hasVar()) {
                    Variable var = voe.getVar();
                    RemoteObject value = var.getValue();
                    String type = CDTEvaluator.getStringType((RemoteObject)value);
                    String stringValue = CDTEvaluator.getStringValue((RemoteObject)value);
                    return new CodeEvaluator.Result.DefaultHistoryItem(expr, type, stringValue, stringValue);
                }
                return null;
            }
            return null;
        }
    }
}

