/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.j2ee.ear;

import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.apache.maven.artifact.Artifact;
import org.netbeans.modules.j2ee.dd.api.common.RootInterface;
import org.netbeans.modules.j2ee.dd.api.ejb.DDProvider;
import org.netbeans.modules.j2ee.dd.api.ejb.EjbJarMetadata;
import org.netbeans.modules.j2ee.dd.api.web.WebAppMetadata;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleImplementation2;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModel;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class NonProjectJ2eeModule
implements J2eeModuleImplementation2 {
    private static final String WAR = "war";
    private static final String EAR = "ear";
    private static final String EJB = "ejb";
    private String moduleVersion;
    private Artifact artifact;

    public NonProjectJ2eeModule(Artifact art, String modVer) {
        this.artifact = art;
        this.moduleVersion = modVer;
    }

    public String getModuleVersion() {
        return this.moduleVersion;
    }

    public J2eeModule.Type getModuleType() {
        String type = this.artifact.getType();
        if (WAR.equals(type)) {
            return J2eeModule.Type.WAR;
        }
        if (EJB.equals(type)) {
            return J2eeModule.Type.EJB;
        }
        if (EAR.equals(type)) {
            return J2eeModule.Type.EAR;
        }
        return J2eeModule.Type.CAR;
    }

    public String getUrl() {
        return this.artifact.getFile().getName();
    }

    public FileObject getArchive() throws IOException {
        return FileUtil.toFileObject((File)FileUtil.normalizeFile((File)this.artifact.getFile()));
    }

    public Iterator<J2eeModule.RootedEntry> getArchiveContents() throws IOException {
        return new ContentIterator(FileUtil.getArchiveRoot((FileObject)this.getArchive()));
    }

    public FileObject getContentDirectory() throws IOException {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RootInterface getDeploymentDescriptor(String location) {
        if ("application.xml".equals(location)) {
            location = "META-INF/application.xml";
        }
        if ("ejb-jar.xml".equals(location)) {
            location = "META-INF/ejb-jar.xml";
        }
        if ("web.xml".equals(location)) {
            location = "WEB-INF/web.xml";
        }
        InputStream str = null;
        try {
            JarFile fil = new JarFile(this.artifact.getFile());
            ZipEntry entry = fil.getEntry(location);
            if (entry != null) {
                str = fil.getInputStream(entry);
                RootInterface rootInterface = this.readBaseBean(str);
                return rootInterface;
            }
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        finally {
            if (str != null) {
                try {
                    str.close();
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        }
        return null;
    }

    private RootInterface readBaseBean(InputStream str) {
        block12: {
            String type = this.artifact.getType();
            if (WAR.equals(type)) {
                try {
                    FileObject root = FileUtil.getArchiveRoot((FileObject)this.getArchive());
                    return org.netbeans.modules.j2ee.dd.api.web.DDProvider.getDefault().getDDRoot(root.getFileObject("WEB-INF/web.xml"));
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            } else {
                if (EJB.equals(type)) {
                    try {
                        return DDProvider.getDefault().getDDRoot(new InputSource(str));
                    }
                    catch (SAXException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                        break block12;
                    }
                    catch (IOException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                        break block12;
                    }
                }
                if (EAR.equals(type)) {
                    try {
                        return org.netbeans.modules.j2ee.dd.api.application.DDProvider.getDefault().getDDRoot(new InputSource(str));
                    }
                    catch (SAXException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                    catch (IOException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
            }
        }
        return null;
    }

    public File getResourceDirectory() {
        return null;
    }

    public File getDeploymentConfigurationFile(String name) {
        return null;
    }

    public void addPropertyChangeListener(PropertyChangeListener arg0) {
    }

    public void removePropertyChangeListener(PropertyChangeListener arg0) {
    }

    public synchronized MetadataModel<EjbJarMetadata> getMetadataModel() {
        return null;
    }

    public <T> MetadataModel<T> getMetadataModel(Class<T> type) {
        if (type == EjbJarMetadata.class) {
            MetadataModel<EjbJarMetadata> model = this.getMetadataModel();
            return model;
        }
        if (type == WebAppMetadata.class) {
            MetadataModel<WebAppMetadata> model = this.getAnnotationMetadataModel();
            return model;
        }
        return null;
    }

    public synchronized MetadataModel<WebAppMetadata> getAnnotationMetadataModel() {
        return null;
    }

    private static final class ContentIterator
    implements Iterator<J2eeModule.RootedEntry> {
        private ArrayList<FileObject> ch = new ArrayList();
        private FileObject root;

        private ContentIterator(FileObject f) {
            this.ch.add(f);
            this.root = f;
        }

        @Override
        public boolean hasNext() {
            return !this.ch.isEmpty();
        }

        @Override
        public J2eeModule.RootedEntry next() {
            FileObject f = this.ch.get(0);
            this.ch.remove(0);
            if (f.isFolder()) {
                f.refresh();
                FileObject[] chArr = f.getChildren();
                for (int i = 0; i < chArr.length; ++i) {
                    this.ch.add(chArr[i]);
                }
            }
            return new FSRootRE(this.root, f);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static final class FSRootRE
    implements J2eeModule.RootedEntry {
        private FileObject f;
        private FileObject root;

        FSRootRE(FileObject rt, FileObject fo) {
            this.f = fo;
            this.root = rt;
        }

        public FileObject getFileObject() {
            return this.f;
        }

        public String getRelativePath() {
            return FileUtil.getRelativePath((FileObject)this.root, (FileObject)this.f);
        }
    }
}

