/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.alerting;

import java.lang.invoke.LambdaMetafactory;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.coroutines.CoroutineName;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.SupervisorKt;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.OpenSearchException;
import org.opensearch.action.DocWriteRequest;
import org.opensearch.action.DocWriteResponse;
import org.opensearch.action.get.GetRequest;
import org.opensearch.action.get.GetResponse;
import org.opensearch.action.index.IndexRequest;
import org.opensearch.action.index.IndexResponse;
import org.opensearch.action.support.WriteRequest;
import org.opensearch.alerting.WorkflowMetadataService;
import org.opensearch.alerting.opensearchapi.OpenSearchExtensionsKt;
import org.opensearch.alerting.settings.AlertingSettings;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.common.xcontent.LoggingDeprecationHandler;
import org.opensearch.common.xcontent.XContentFactory;
import org.opensearch.common.xcontent.XContentHelper;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.commons.alerting.model.CompositeInput;
import org.opensearch.commons.alerting.model.Workflow;
import org.opensearch.commons.alerting.model.WorkflowMetadata;
import org.opensearch.commons.alerting.util.AlertingException;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.common.bytes.BytesReference;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.DeprecationHandler;
import org.opensearch.core.xcontent.MediaType;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.transport.client.Client;
import org.opensearch.transport.client.OpenSearchClient;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J&\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000eJ\u001e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0017H\u0086@\u00a2\u0006\u0002\u0010\u0018J4\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00170\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\b\b\u0002\u0010\u001d\u001a\u00020\u00172\u0006\u0010\u001e\u001a\u00020\u001fH\u0086@\u00a2\u0006\u0002\u0010 J\u0018\u0010!\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u001b\u001a\u00020\u001cH\u0082@\u00a2\u0006\u0002\u0010\"J \u0010#\u001a\u00020\u00142\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010$\u001a\u00020\u0017H\u0002R\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082.\u00a2\u0006\u0002\n\u0000R\u0012\u0010%\u001a\u00020&X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b'\u0010(\u00a8\u0006)"}, d2={"Lorg/opensearch/alerting/WorkflowMetadataService;", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "()V", "log", "Lorg/apache/logging/log4j/Logger;", "kotlin.jvm.PlatformType", "client", "Lorg/opensearch/transport/client/Client;", "xContentRegistry", "Lorg/opensearch/core/xcontent/NamedXContentRegistry;", "clusterService", "Lorg/opensearch/cluster/service/ClusterService;", "settings", "Lorg/opensearch/common/settings/Settings;", "indexTimeout", "Lorg/opensearch/common/unit/TimeValue;", "initialize", "", "upsertWorkflowMetadata", "Lorg/opensearch/commons/alerting/model/WorkflowMetadata;", "metadata", "updating", "", "(Lorg/opensearch/commons/alerting/model/WorkflowMetadata;ZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getOrCreateWorkflowMetadata", "Lkotlin/Pair;", "workflow", "Lorg/opensearch/commons/alerting/model/Workflow;", "skipIndex", "executionId", "", "(Lorg/opensearch/commons/alerting/model/Workflow;ZLjava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getWorkflowMetadata", "(Lorg/opensearch/commons/alerting/model/Workflow;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "createNewWorkflowMetadata", "isTempWorkflow", "coroutineContext", "Lkotlin/coroutines/CoroutineContext;", "getCoroutineContext", "()Lkotlin/coroutines/CoroutineContext;", "opensearch-alerting"})
public final class WorkflowMetadataService
implements CoroutineScope {
    @NotNull
    public static final WorkflowMetadataService INSTANCE = new WorkflowMetadataService();
    private final /* synthetic */ CoroutineScope $$delegate_0;
    private static final Logger log = LogManager.getLogger(INSTANCE.getClass());
    private static Client client;
    private static NamedXContentRegistry xContentRegistry;
    private static ClusterService clusterService;
    private static Settings settings;
    private static volatile TimeValue indexTimeout;

    private WorkflowMetadataService() {
        this.$$delegate_0 = CoroutineScopeKt.CoroutineScope((CoroutineContext)SupervisorKt.SupervisorJob$default(null, (int)1, null).plus((CoroutineContext)Dispatchers.getDefault()).plus((CoroutineContext)new CoroutineName("WorkflowMetadataService")));
    }

    public final void initialize(@NotNull Client client, @NotNull ClusterService clusterService, @NotNull NamedXContentRegistry xContentRegistry, @NotNull Settings settings) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)clusterService, (String)"clusterService");
        Intrinsics.checkNotNullParameter((Object)xContentRegistry, (String)"xContentRegistry");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        WorkflowMetadataService.clusterService = clusterService;
        WorkflowMetadataService.client = client;
        WorkflowMetadataService.xContentRegistry = xContentRegistry;
        WorkflowMetadataService.settings = settings;
        Object object = AlertingSettings.Companion.getINDEX_TIMEOUT().get(settings);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        indexTimeout = (TimeValue)object;
        ClusterService clusterService2 = WorkflowMetadataService.clusterService;
        if (clusterService2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"clusterService");
            clusterService2 = null;
        }
        clusterService2.getClusterSettings().addSettingsUpdateConsumer(AlertingSettings.Companion.getINDEX_TIMEOUT(), WorkflowMetadataService::initialize$lambda$0);
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object upsertWorkflowMetadata(@NotNull WorkflowMetadata metadata, boolean updating, @NotNull Continuation<? super WorkflowMetadata> $completion) {
        if (!($completion instanceof upsertWorkflowMetadata.1)) ** GOTO lbl-1000
        var8_4 = $completion;
        if ((var8_4.label & -2147483648) != 0) {
            var8_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                boolean Z$0;
                /* synthetic */ Object result;
                final /* synthetic */ WorkflowMetadataService this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.upsertWorkflowMetadata(null, false, (Continuation<? super WorkflowMetadata>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var9_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                v0 = (IndexRequest)new IndexRequest(".opendistro-alerting-config").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
                v1 = XContentFactory.jsonBuilder();
                Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"jsonBuilder(...)");
                v2 = v0.source(metadata.toXContent(v1, (ToXContent.Params)new ToXContent.MapParams(MapsKt.mapOf((Pair)TuplesKt.to((Object)"with_type", (Object)"true"))))).id(metadata.getId()).routing(metadata.getWorkflowId());
                v3 = WorkflowMetadataService.indexTimeout;
                if (v3 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"indexTimeout");
                    v3 = null;
                }
                indexRequest = (IndexRequest)v2.timeout(v3);
                v4 = updating != false ? indexRequest.id(metadata.getId()) : indexRequest.opType(DocWriteRequest.OpType.CREATE);
                v5 = WorkflowMetadataService.client;
                if (v5 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"client");
                    v5 = null;
                }
                $continuation.L$0 = metadata;
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)indexRequest);
                $continuation.Z$0 = updating;
                $continuation.label = 1;
                v6 = OpenSearchExtensionsKt.suspendUntil((OpenSearchClient)((OpenSearchClient)v5), (Function2)(Function2)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;, upsertWorkflowMetadata$lambda$1(org.opensearch.action.index.IndexRequest org.opensearch.transport.client.Client org.opensearch.core.action.ActionListener ), (Lorg/opensearch/transport/client/Client;Lorg/opensearch/core/action/ActionListener;)Lkotlin/Unit;)((IndexRequest)indexRequest), (Continuation)$continuation);
                ** if (v6 != var9_6) goto lbl35
lbl34:
                // 1 sources

                return var9_6;
lbl35:
                // 1 sources

                ** GOTO lbl44
            }
            case 1: {
                updating = $continuation.Z$0;
                indexRequest = (IndexRequest)$continuation.L$1;
                metadata = (WorkflowMetadata)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v6 = $result;
lbl44:
                    // 2 sources

                    response = (IndexResponse)v6;
                    v7 = response.getResult();
                    switch (v7 == null ? -1 : WhenMappings.$EnumSwitchMapping$0[v7.ordinal()]) {
                        case -1: 
                        case 1: 
                        case 2: 
                        case 3: {
                            v8 = response.getResult();
                            failureReason = "The upsert metadata call failed with a " + (v8 != null ? v8.getLowercase() : null) + " result";
                            WorkflowMetadataService.log.error(failureReason);
                            throw new AlertingException(failureReason, RestStatus.INTERNAL_SERVER_ERROR, (Exception)new IllegalStateException(failureReason));
                        }
                        case 4: 
                        case 5: {
                            WorkflowMetadataService.log.debug("Successfully upserted WorkflowMetadata:" + metadata.getId() + " ");
                            break;
                        }
                        default: {
                            throw new NoWhenBranchMatchedException();
                        }
                    }
                    return metadata;
                }
                catch (Exception e) {
                    if (!(e instanceof OpenSearchException) || ((OpenSearchException)e).status() != RestStatus.CONFLICT || updating) break;
                    WorkflowMetadataService.log.debug("Metadata with " + metadata.getId() + " for workflow " + metadata.getWorkflowId() + " already exist. Instead of creating new, updating existing metadata will be performed");
                    $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)metadata);
                    $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)e);
                    $continuation.Z$0 = updating;
                    $continuation.label = 2;
                    v9 = this.upsertWorkflowMetadata(metadata, true, (Continuation<? super WorkflowMetadata>)$continuation);
                    if (v9 == var9_6) {
                        return var9_6;
                    }
                    ** GOTO lbl75
                }
            }
            case 2: {
                updating = $continuation.Z$0;
                e = (Exception)$continuation.L$1;
                metadata = (WorkflowMetadata)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v9 = $result;
lbl75:
                // 2 sources

                return v9;
            }
        }
        WorkflowMetadataService.log.error("Error saving metadata", (Throwable)e);
        throw AlertingException.Companion.wrap(e);
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object getOrCreateWorkflowMetadata(@NotNull Workflow workflow, boolean skipIndex, @NotNull String executionId, @NotNull Continuation<? super Pair<WorkflowMetadata, Boolean>> $completion) {
        if (!($completion instanceof getOrCreateWorkflowMetadata.1)) ** GOTO lbl-1000
        var9_5 = $completion;
        if ((var9_5.label & -2147483648) != 0) {
            var9_5.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                boolean Z$0;
                int I$0;
                /* synthetic */ Object result;
                final /* synthetic */ WorkflowMetadataService this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.getOrCreateWorkflowMetadata(null, false, null, (Continuation<? super Pair<WorkflowMetadata, Boolean>>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var10_7 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                created = 1;
                $continuation.L$0 = workflow;
                $continuation.L$1 = executionId;
                $continuation.Z$0 = skipIndex;
                $continuation.I$0 = created;
                $continuation.label = 1;
                v0 = this.getWorkflowMetadata(workflow, (Continuation<? super WorkflowMetadata>)$continuation);
                ** if (v0 != var10_7) goto lbl23
lbl22:
                // 1 sources

                return var10_7;
lbl23:
                // 1 sources

                ** GOTO lbl33
            }
            case 1: {
                created = $continuation.I$0;
                skipIndex = $continuation.Z$0;
                executionId = (String)$continuation.L$1;
                workflow = (Workflow)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl33:
                // 2 sources

                if ((metadata = (WorkflowMetadata)v0) == null) ** GOTO lbl36
                v1 = TuplesKt.to((Object)metadata, (Object)Boxing.boxBoolean((boolean)(created == 0)));
                ** GOTO lbl63
lbl36:
                // 1 sources

                newMetadata = this.createNewWorkflowMetadata(workflow, executionId, skipIndex != false);
                if (!skipIndex) ** GOTO lbl40
                v1 = TuplesKt.to((Object)newMetadata, (Object)Boxing.boxBoolean((boolean)(created != 0)));
                ** GOTO lbl63
lbl40:
                // 1 sources

                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)workflow);
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)executionId);
                $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)metadata);
                $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)newMetadata);
                $continuation.Z$0 = skipIndex;
                $continuation.I$0 = created;
                $continuation.label = 2;
                v2 = this.upsertWorkflowMetadata(newMetadata, false, (Continuation<? super WorkflowMetadata>)$continuation);
                ** if (v2 != var10_7) goto lbl50
lbl49:
                // 1 sources

                return var10_7;
lbl50:
                // 1 sources

                ** GOTO lbl62
            }
            case 2: {
                created = $continuation.I$0;
                skipIndex = $continuation.Z$0;
                newMetadata = (WorkflowMetadata)$continuation.L$3;
                metadata = (WorkflowMetadata)$continuation.L$2;
                executionId = (String)$continuation.L$1;
                workflow = (Workflow)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v2 = $result;
lbl62:
                    // 2 sources

                    v1 = TuplesKt.to((Object)v2, (Object)Boxing.boxBoolean((boolean)(created != 0)));
lbl63:
                    // 3 sources

                    return v1;
                }
                catch (Exception e) {
                    throw AlertingException.Companion.wrap(e);
                }
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public static /* synthetic */ Object getOrCreateWorkflowMetadata$default(WorkflowMetadataService workflowMetadataService, Workflow workflow, boolean bl, String string, Continuation continuation, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return workflowMetadataService.getOrCreateWorkflowMetadata(workflow, bl, string, (Continuation<? super Pair<WorkflowMetadata, Boolean>>)continuation);
    }

    /*
     * Unable to fully structure code
     */
    private final Object getWorkflowMetadata(Workflow workflow, Continuation<? super WorkflowMetadata> $completion) {
        if (!($completion instanceof getWorkflowMetadata.1)) ** GOTO lbl-1000
        var8_3 = $completion;
        if ((var8_3.label & -2147483648) != 0) {
            var8_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                /* synthetic */ Object result;
                final /* synthetic */ WorkflowMetadataService this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return WorkflowMetadataService.access$getWorkflowMetadata(this.this$0, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var9_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                metadataId = WorkflowMetadata.Companion.getId(workflow.getId());
                getRequest = new GetRequest(".opendistro-alerting-config", metadataId).routing(workflow.getId());
                v0 = WorkflowMetadataService.client;
                if (v0 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"client");
                    v0 = null;
                }
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)workflow);
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)metadataId);
                $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)getRequest);
                $continuation.label = 1;
                v1 = OpenSearchExtensionsKt.suspendUntil((OpenSearchClient)((OpenSearchClient)v0), (Function2)(Function2)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;, getWorkflowMetadata$lambda$2(org.opensearch.action.get.GetRequest org.opensearch.transport.client.Client org.opensearch.core.action.ActionListener ), (Lorg/opensearch/transport/client/Client;Lorg/opensearch/core/action/ActionListener;)Lkotlin/Unit;)((GetRequest)getRequest), (Continuation)$continuation);
                ** if (v1 != var9_5) goto lbl27
lbl26:
                // 1 sources

                return var9_5;
lbl27:
                // 1 sources

                ** GOTO lbl36
            }
            case 1: {
                getRequest = (GetRequest)$continuation.L$2;
                metadataId = (String)$continuation.L$1;
                workflow = (Workflow)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v1 = $result;
lbl36:
                    // 2 sources

                    if ((getResponse = (GetResponse)v1).isExists()) {
                        v2 = WorkflowMetadataService.xContentRegistry;
                        if (v2 == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"xContentRegistry");
                            v2 = null;
                        }
                        xcp = XContentHelper.createParser((NamedXContentRegistry)v2, (DeprecationHandler)((DeprecationHandler)LoggingDeprecationHandler.INSTANCE), (BytesReference)getResponse.getSourceAsBytesRef(), (MediaType)((MediaType)XContentType.JSON));
                        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)xcp.nextToken(), (XContentParser)xcp);
                        Intrinsics.checkNotNull((Object)xcp);
                        v3 = WorkflowMetadata.Companion.parse(xcp);
                    } else {
                        v3 = null;
                    }
                    return v3;
                }
                catch (Exception e) {
                    v4 = e.getMessage();
                    v5 = v4 != null ? StringsKt.contains$default((CharSequence)v4, (CharSequence)"no such index", (boolean)false, (int)2, null) : false;
                    if (v5) {
                        return null;
                    }
                    throw AlertingException.Companion.wrap(e);
                }
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final WorkflowMetadata createNewWorkflowMetadata(Workflow workflow, String executionId, boolean isTempWorkflow) {
        String id = isTempWorkflow ? "" + LocalDateTime.now(ZoneOffset.UTC) + UUID.randomUUID() : workflow.getId();
        String string = WorkflowMetadata.Companion.getId(id);
        String string2 = workflow.getId();
        Object e = workflow.getInputs().get(0);
        Intrinsics.checkNotNull(e, (String)"null cannot be cast to non-null type org.opensearch.commons.alerting.model.CompositeInput");
        List list = ((CompositeInput)e).getMonitorIds();
        Instant instant = Instant.now();
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"now(...)");
        return new WorkflowMetadata(string, string2, list, instant, executionId);
    }

    @NotNull
    public CoroutineContext getCoroutineContext() {
        return this.$$delegate_0.getCoroutineContext();
    }

    private static final void initialize$lambda$0(TimeValue it) {
        Intrinsics.checkNotNull((Object)it);
        indexTimeout = it;
    }

    private static final Unit upsertWorkflowMetadata$lambda$1(IndexRequest $indexRequest, Client $this$suspendUntil, ActionListener it) {
        Intrinsics.checkNotNullParameter((Object)$this$suspendUntil, (String)"$this$suspendUntil");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $this$suspendUntil.index($indexRequest, it);
        return Unit.INSTANCE;
    }

    private static final Unit getWorkflowMetadata$lambda$2(GetRequest $getRequest, Client $this$suspendUntil, ActionListener it) {
        Intrinsics.checkNotNullParameter((Object)$this$suspendUntil, (String)"$this$suspendUntil");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $this$suspendUntil.get($getRequest, it);
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ Object access$getWorkflowMetadata(WorkflowMetadataService $this, Workflow workflow, Continuation $completion) {
        return $this.getWorkflowMetadata(workflow, (Continuation<? super WorkflowMetadata>)$completion);
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[DocWriteResponse.Result.values().length];
            try {
                nArray[DocWriteResponse.Result.DELETED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DocWriteResponse.Result.NOOP.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DocWriteResponse.Result.NOT_FOUND.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DocWriteResponse.Result.CREATED.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DocWriteResponse.Result.UPDATED.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

