"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ML_COMMONS_NODE_API = exports.FORECAST_NODE_API = exports.FORECAST_BASE_NODE_API_PATH = exports.DAILY_INSIGHTS_ENABLED = exports.BASE_NODE_API_PATH = exports.ALERTING_NODE_API = exports.AD_NODE_API = void 0;
/*
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 *
 * Modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */

const BASE_NODE_API_PATH = exports.BASE_NODE_API_PATH = '/api/anomaly_detectors';
const AD_NODE_API = exports.AD_NODE_API = Object.freeze({
  _SEARCH: `${BASE_NODE_API_PATH}/_search`,
  _INDICES: `${BASE_NODE_API_PATH}/_indices`,
  _ALIASES: `${BASE_NODE_API_PATH}/_aliases`,
  _MAPPINGS: `${BASE_NODE_API_PATH}/_mappings`,
  DETECTOR: `${BASE_NODE_API_PATH}/detectors`,
  CREATE_INDEX: `${BASE_NODE_API_PATH}/create_index`,
  BULK: `${BASE_NODE_API_PATH}/bulk`,
  DELETE_INDEX: `${BASE_NODE_API_PATH}/delete_index`,
  CREATE_SAMPLE_DATA: `${BASE_NODE_API_PATH}/create_sample_data`,
  GET_CLUSTERS_INFO: `${BASE_NODE_API_PATH}/_remote/info`,
  GET_INDICES_AND_ALIASES: `${BASE_NODE_API_PATH}/_indices_and_aliases`,
  INSIGHTS_START: `${BASE_NODE_API_PATH}/insights/_start`,
  INSIGHTS_STOP: `${BASE_NODE_API_PATH}/insights/_stop`,
  INSIGHTS_STATUS: `${BASE_NODE_API_PATH}/insights/_status`,
  INSIGHTS_RESULTS: `${BASE_NODE_API_PATH}/insights/_results`
});
const ALERTING_NODE_API = exports.ALERTING_NODE_API = Object.freeze({
  _SEARCH: `${BASE_NODE_API_PATH}/monitors/_search`,
  ALERTS: `${BASE_NODE_API_PATH}/monitors/alerts`,
  MONITORS: `${BASE_NODE_API_PATH}/monitors`
});
const ML_COMMONS_NODE_API = exports.ML_COMMONS_NODE_API = Object.freeze({
  AGENT_EXECUTE: `/api/ml/agents`
});
const FORECAST_BASE_NODE_API_PATH = exports.FORECAST_BASE_NODE_API_PATH = '/api/forecasting';
const FORECAST_NODE_API = exports.FORECAST_NODE_API = Object.freeze({
  _SEARCH: `${FORECAST_BASE_NODE_API_PATH}/_search`,
  _INDICES: `${FORECAST_BASE_NODE_API_PATH}/_indices`,
  _ALIASES: `${FORECAST_BASE_NODE_API_PATH}/_aliases`,
  _MAPPINGS: `${FORECAST_BASE_NODE_API_PATH}/_mappings`,
  FORECASTER: `${FORECAST_BASE_NODE_API_PATH}/forecasters`,
  CREATE_INDEX: `${FORECAST_BASE_NODE_API_PATH}/create_index`,
  BULK: `${FORECAST_BASE_NODE_API_PATH}/bulk`,
  DELETE_INDEX: `${FORECAST_BASE_NODE_API_PATH}/delete_index`,
  CREATE_SAMPLE_DATA: `${FORECAST_BASE_NODE_API_PATH}/create_sample_data`,
  GET_CLUSTERS_INFO: `${FORECAST_BASE_NODE_API_PATH}/_remote/info`,
  GET_INDICES_AND_ALIASES: `${FORECAST_BASE_NODE_API_PATH}/_indices_and_aliases`
});

// Feature Flags
const DAILY_INSIGHTS_ENABLED = exports.DAILY_INSIGHTS_ENABLED = 'anomalyDetection:dailyInsightsEnabled';
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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