/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.html.charsetdetector;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import org.apache.commons.io.input.BoundedInputStream;
import org.apache.tika.config.Field;
import org.apache.tika.detect.EncodingDetector;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.html.charsetdetector.CharsetAliases;
import org.apache.tika.parser.html.charsetdetector.PreScanner;

public final class StandardHtmlEncodingDetector
implements EncodingDetector {
    private static final int META_TAG_BUFFER_SIZE = 8192;
    @Field
    private int markLimit = 8192;

    private static Charset charsetFromContentType(Metadata metadata) {
        String contentType = metadata.get("Content-Type");
        MediaType mediatype = MediaType.parse((String)contentType);
        if (mediatype == null) {
            return null;
        }
        String charsetLabel = (String)mediatype.getParameters().get("charset");
        return CharsetAliases.getCharsetByLabel(charsetLabel);
    }

    public Charset detect(InputStream input, Metadata metadata) throws IOException {
        int limit = this.getMarkLimit();
        input.mark(limit);
        BoundedInputStream limitedStream = ((BoundedInputStream.Builder)((BoundedInputStream.Builder)BoundedInputStream.builder().setInputStream(input)).setMaxCount((long)limit)).get();
        PreScanner preScanner = new PreScanner((InputStream)limitedStream);
        Charset detectedCharset = preScanner.detectBOM();
        if (detectedCharset == null) {
            detectedCharset = StandardHtmlEncodingDetector.charsetFromContentType(metadata);
        }
        if (detectedCharset == null) {
            detectedCharset = preScanner.scan();
        }
        input.reset();
        return detectedCharset;
    }

    public int getMarkLimit() {
        return this.markLimit;
    }

    @Field
    public void setMarkLimit(int markLimit) {
        this.markLimit = markLimit;
    }
}

