/*
 * Decompiled with CFR 0.152.
 */
package com.google.uzaygezen.core;

import com.google.uzaygezen.core.AdditiveValue;
import com.google.uzaygezen.core.MapNode;
import com.google.uzaygezen.core.StreamingRollup;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.PriorityQueue;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import shaded.com.google.common.base.Preconditions;
import shaded.com.google.common.collect.ImmutableMap;
import shaded.com.google.common.collect.Maps;

public class BoundedRollup<K, V extends AdditiveValue<V>>
implements StreamingRollup<K, V> {
    private int nodeCount;
    private final int maxNodes;
    private final PriorityQueue<ComparableTreeNode> minHeap;
    private TreeNode root;
    private final Deque<TreeNode> rightmostPath = new ArrayDeque<TreeNode>();
    private boolean finished;

    public static <K, V extends AdditiveValue<V>> BoundedRollup<K, V> create(V emptyValue, int maxNodes) {
        return new BoundedRollup<K, V>(maxNodes);
    }

    private BoundedRollup(int maxNodes) {
        Preconditions.checkArgument(maxNodes > 0, "maxNodes must be positive");
        this.maxNodes = maxNodes;
        this.minHeap = new PriorityQueue();
    }

    @Override
    public void feedRow(Iterator<K> leafPath, V v) {
        this.checkNotFinished();
        Preconditions.checkArgument(!v.isZero(), "v must not be zero.");
        if (this.root == null) {
            this.firstTime(leafPath, v);
        } else {
            TreeNode child;
            assert (this.rightmostPath.peek() == this.root);
            Iterator<TreeNode> rightmostPathIterator = this.rightmostPath.iterator();
            TreeNode node = this.root;
            this.root.value.add(v);
            TreeNode rightmostNode = rightmostPathIterator.next();
            Object key = null;
            while (leafPath.hasNext()) {
                key = leafPath.next();
                if (node.children == null) {
                    node.value.add(v);
                    rightmostNode = node;
                    break;
                }
                child = node.children.get(key);
                if (child != (rightmostNode = rightmostPathIterator.next())) break;
                child.value.add(v);
                node = child;
            }
            if (node != rightmostNode) {
                assert (node == rightmostNode.parent && key != null);
                this.removeTail(rightmostPathIterator, rightmostNode);
                child = new TreeNode(this, key, node, (AdditiveValue)v.clone(), leafPath.hasNext() ? this.createChildrenMap() : null);
                this.rightmostPath.addLast(child);
                node.children.put(key, child);
                node = child;
                this.completeNewPath(leafPath, node, v);
            } else {
                Preconditions.checkState(!rightmostPathIterator.hasNext());
            }
        }
        this.fixSizeIfNeededAndPossible();
    }

    private void fixSizeIfNeededAndPossible() {
        ComparableTreeNode minNode;
        while (this.maxNodes < this.nodeCount && (minNode = this.minHeap.poll()) != null) {
            minNode.node.removeChildrenAndSeal();
            if (((ComparableTreeNode)minNode).node.parent == null || !((ComparableTreeNode)minNode).node.parent.allChildrenOfThisInternalNodeAreLeaves() || this.rightmostPath.contains(((ComparableTreeNode)minNode).node.parent)) continue;
            this.minHeap.add(new ComparableTreeNode(((ComparableTreeNode)minNode).node.parent));
        }
    }

    private void removeTail(Iterator<TreeNode> iterator2, TreeNode currentNode) {
        TreeNode previousToLast = iterator2.hasNext() ? currentNode : null;
        iterator2.remove();
        while (iterator2.hasNext()) {
            TreeNode node = iterator2.next();
            if (iterator2.hasNext()) {
                previousToLast = node;
            }
            iterator2.remove();
        }
        if (previousToLast != null && previousToLast.allChildrenOfThisInternalNodeAreLeaves()) {
            Preconditions.checkState(this.minHeap.offer(new ComparableTreeNode(previousToLast)));
        }
    }

    private void firstTime(Iterator<K> leafPath, V v) {
        assert (this.rightmostPath.isEmpty());
        this.root = new TreeNode(this, (AdditiveValue)v.clone(), leafPath.hasNext() ? this.createChildrenMap() : null);
        this.rightmostPath.addLast(this.root);
        TreeNode node = this.root;
        while (leafPath.hasNext()) {
            K key = leafPath.next();
            TreeNode child = leafPath.hasNext() ? new TreeNode(this, key, node, (AdditiveValue)v.clone(), this.createChildrenMap()) : new TreeNode(this, key, node, (AdditiveValue)v.clone(), null);
            this.rightmostPath.addLast(child);
            node = child;
        }
        Preconditions.checkState(this.nodeCount == this.rightmostPath.size());
    }

    private void completeNewPath(Iterator<K> leafPath, TreeNode node, V v) {
        while (leafPath.hasNext()) {
            K key = leafPath.next();
            TreeNode freshChild = new TreeNode(this, key, node, (AdditiveValue)v.clone(), leafPath.hasNext() ? this.createChildrenMap() : null);
            this.rightmostPath.addLast(freshChild);
            node.children.put(key, freshChild);
            node = freshChild;
        }
    }

    private void checkNotFinished() {
        Preconditions.checkState(!this.finished, "finished() has been called already");
    }

    private HashMap<K, TreeNode> createChildrenMap() {
        return Maps.newHashMap();
    }

    @Override
    public MapNode<K, V> finish() {
        this.checkNotFinished();
        if (this.root == null) {
            return null;
        }
        Iterator<TreeNode> rightmostPathIterator = this.rightmostPath.iterator();
        Preconditions.checkState(rightmostPathIterator.next() == this.root);
        this.removeTail(rightmostPathIterator, this.root);
        Preconditions.checkState(this.rightmostPath.isEmpty());
        this.fixSizeIfNeededAndPossible();
        this.minHeap.clear();
        Preconditions.checkState(this.nodeCount <= this.maxNodes, "nodeCount=%s should be less than or equal to maxNodes=%s", new Object[]{this.nodeCount, this.maxNodes});
        MapNode<K, V> mapNode = this.moveNode(this.root);
        this.root = null;
        this.finished = true;
        return mapNode;
    }

    private MapNode<K, V> moveNode(TreeNode subtree) {
        MapNode mapNode;
        assert (subtree != null);
        if (subtree.children == null) {
            mapNode = MapNode.create(subtree.value, ImmutableMap.of());
        } else {
            HashMap children = Maps.newHashMapWithExpectedSize(subtree.children.size());
            Iterator iterator2 = subtree.children.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry entry = iterator2.next();
                MapNode<K, V> old = children.put(entry.getKey(), this.moveNode(entry.getValue()));
                Preconditions.checkState(old == null);
                iterator2.remove();
            }
            mapNode = MapNode.create(subtree.value, children);
        }
        return mapNode;
    }

    public String toString() {
        return ReflectionToStringBuilder.toString(this, ToStringStyle.SHORT_PREFIX_STYLE);
    }

    class ComparableTreeNode
    implements Comparable<ComparableTreeNode> {
        private TreeNode node;

        public ComparableTreeNode(TreeNode node) {
            Preconditions.checkArgument(!node.children.isEmpty(), "Leaves are not to be put in the heap.");
            this.node = Preconditions.checkNotNull(node);
        }

        @Override
        public int compareTo(ComparableTreeNode o) {
            return this.node.value.compareTo(o.node.value);
        }

        public void swap(ComparableTreeNode other) {
            if (other != this) {
                Preconditions.checkArgument(this.node.value.compareTo(other.node.value) == 0);
                TreeNode tmp = this.node;
                this.node = other.node;
                other.node = tmp;
            }
        }
    }

    static class TreeNode {
        final V value;
        Map<K, TreeNode> children;
        final TreeNode parent;
        final /* synthetic */ BoundedRollup this$0;

        public TreeNode(V value, Map<K, TreeNode> children) {
            this.this$0 = var1_1;
            this.parent = null;
            this.value = (AdditiveValue)Preconditions.checkNotNull(value);
            this.children = children;
            ((BoundedRollup)var1_1).nodeCount++;
        }

        public boolean allChildrenOfThisInternalNodeAreLeaves() {
            Preconditions.checkState(this.children != null & !this.children.isEmpty());
            for (TreeNode child : this.children.values()) {
                if (child.children == null) continue;
                return false;
            }
            return true;
        }

        public TreeNode(K key, TreeNode parent, V value, Map<K, TreeNode> children) {
            this.this$0 = var1_1;
            this.parent = Preconditions.checkNotNull(parent);
            this.value = (AdditiveValue)Preconditions.checkNotNull(value);
            this.children = children;
            TreeNode old = parent.children.put(key, this);
            Preconditions.checkArgument(old == null, "Node already there.");
            ((BoundedRollup)var1_1).nodeCount++;
        }

        public void removeChildrenAndSeal() {
            Preconditions.checkState(!this.children.isEmpty());
            this.this$0.nodeCount -= this.children.size();
            this.children = null;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            this.appendStringInto(sb, 0);
            return sb.toString();
        }

        private void appendStringInto(StringBuilder sb, int level) {
            sb.append('\n');
            for (int i = 0; i < level; ++i) {
                sb.append(' ');
            }
            sb.append(this.value);
            if (this.children != null) {
                for (Map.Entry entry : this.children.entrySet()) {
                    int i;
                    sb.append('\n');
                    for (i = 0; i < level; ++i) {
                        sb.append(' ');
                    }
                    sb.append("key=");
                    sb.append(entry.getKey());
                    sb.append('\n');
                    for (i = 0; i < level; ++i) {
                        sb.append(' ');
                    }
                    sb.append("child=");
                    entry.getValue().appendStringInto(sb, level + 1);
                }
            }
        }
    }
}

