/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.avatica.util;

import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.SQLDataException;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import org.apache.calcite.avatica.AvaticaSite;
import org.apache.calcite.avatica.AvaticaUtils;
import org.apache.calcite.avatica.ColumnMetaData;
import org.apache.calcite.avatica.util.ArrayImpl;
import org.apache.calcite.avatica.util.ByteString;
import org.apache.calcite.avatica.util.Cursor;
import org.apache.calcite.avatica.util.DateTimeUtils;
import org.apache.calcite.avatica.util.Spacer;
import org.apache.calcite.avatica.util.StructImpl;
import org.apache.calcite.avatica.util.TimeUnitRange;

public abstract class AbstractCursor
implements Cursor {
    protected final boolean[] wasNull = new boolean[]{false};

    protected AbstractCursor() {
    }

    @Override
    public boolean wasNull() {
        return this.wasNull[0];
    }

    @Override
    public List<Cursor.Accessor> createAccessors(List<ColumnMetaData> types, Calendar localCalendar, ArrayImpl.Factory factory2) {
        ArrayList<Cursor.Accessor> accessors = new ArrayList<Cursor.Accessor>();
        for (ColumnMetaData type2 : types) {
            accessors.add(this.createAccessor(type2, accessors.size(), localCalendar, factory2));
        }
        return accessors;
    }

    protected Cursor.Accessor createAccessor(ColumnMetaData columnMetaData, int ordinal, Calendar localCalendar, ArrayImpl.Factory factory2) {
        Getter getter = this.createGetter(ordinal);
        return this.createAccessor(columnMetaData, getter, localCalendar, factory2);
    }

    protected Cursor.Accessor createAccessor(ColumnMetaData columnMetaData, Getter getter, Calendar localCalendar, ArrayImpl.Factory factory2) {
        switch (columnMetaData.type.rep) {
            case NUMBER: {
                switch (columnMetaData.type.id) {
                    case -6: 
                    case -5: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: {
                        return new NumberAccessor(getter, columnMetaData.scale);
                    }
                }
            }
        }
        switch (columnMetaData.type.id) {
            case -6: {
                return new ByteAccessor(getter);
            }
            case 5: {
                return new ShortAccessor(getter);
            }
            case 4: {
                return new IntAccessor(getter);
            }
            case -5: {
                return new LongAccessor(getter);
            }
            case -7: 
            case 16: {
                return new BooleanAccessor(getter);
            }
            case 7: {
                return new FloatAccessor(getter);
            }
            case 6: 
            case 8: {
                return new DoubleAccessor(getter);
            }
            case 3: {
                return new NumberAccessor(getter, columnMetaData.scale);
            }
            case 1: {
                switch (columnMetaData.type.rep) {
                    case PRIMITIVE_CHAR: 
                    case CHARACTER: {
                        return new StringFromCharAccessor(getter, columnMetaData.displaySize);
                    }
                }
                return new FixedStringAccessor(getter, columnMetaData.displaySize);
            }
            case -9: 
            case 12: {
                return new StringAccessor(getter);
            }
            case -3: 
            case -2: {
                switch (columnMetaData.type.rep) {
                    case STRING: {
                        return new BinaryFromStringAccessor(getter);
                    }
                }
                return new BinaryAccessor(getter);
            }
            case 91: {
                switch (columnMetaData.type.rep) {
                    case NUMBER: 
                    case PRIMITIVE_INT: 
                    case INTEGER: {
                        return new DateFromNumberAccessor(getter, localCalendar);
                    }
                    case JAVA_SQL_DATE: {
                        return new DateAccessor(getter, localCalendar);
                    }
                }
                throw new AssertionError((Object)("bad " + (Object)((Object)columnMetaData.type.rep)));
            }
            case 92: {
                switch (columnMetaData.type.rep) {
                    case NUMBER: 
                    case PRIMITIVE_INT: 
                    case INTEGER: {
                        return new TimeFromNumberAccessor(getter, localCalendar, columnMetaData.precision);
                    }
                    case JAVA_SQL_TIME: {
                        return new TimeAccessor(getter, localCalendar);
                    }
                }
                throw new AssertionError((Object)("bad " + (Object)((Object)columnMetaData.type.rep)));
            }
            case 93: {
                switch (columnMetaData.type.rep) {
                    case NUMBER: 
                    case PRIMITIVE_LONG: 
                    case LONG: {
                        return new TimestampFromNumberAccessor(getter, localCalendar, columnMetaData.precision);
                    }
                    case JAVA_SQL_TIMESTAMP: {
                        return new TimestampAccessor(getter, localCalendar, columnMetaData.precision);
                    }
                    case JAVA_UTIL_DATE: {
                        return new TimestampFromUtilDateAccessor(getter, localCalendar, columnMetaData.precision);
                    }
                }
                throw new AssertionError((Object)("bad " + (Object)((Object)columnMetaData.type.rep)));
            }
            case 2013: {
                switch (columnMetaData.type.rep) {
                    case STRING: {
                        return new StringAccessor(getter);
                    }
                }
                throw new AssertionError((Object)("bad " + (Object)((Object)columnMetaData.type.rep)));
            }
            case 2014: {
                switch (columnMetaData.type.rep) {
                    case STRING: {
                        return new StringAccessor(getter);
                    }
                }
                throw new AssertionError((Object)("bad " + (Object)((Object)columnMetaData.type.rep)));
            }
            case 2003: {
                ColumnMetaData.ArrayType arrayType = (ColumnMetaData.ArrayType)columnMetaData.type;
                SlotGetter componentGetter = new SlotGetter();
                Cursor.Accessor componentAccessor = this.createAccessor(ColumnMetaData.dummy(arrayType.getComponent(), true), componentGetter, localCalendar, factory2);
                return new ArrayAccessor(getter, arrayType.getComponent(), componentAccessor, componentGetter, factory2);
            }
            case 2002: {
                switch (columnMetaData.type.rep) {
                    case OBJECT: {
                        ColumnMetaData.StructType structType = (ColumnMetaData.StructType)columnMetaData.type;
                        ArrayList<Cursor.Accessor> accessors = new ArrayList<Cursor.Accessor>();
                        for (ColumnMetaData column : structType.columns) {
                            accessors.add(this.createAccessor(column, new StructGetter(getter, column), localCalendar, factory2));
                        }
                        return new StructAccessor(getter, accessors);
                    }
                }
                throw new AssertionError((Object)("bad " + (Object)((Object)columnMetaData.type.rep)));
            }
            case 0: 
            case 1111: 
            case 2000: {
                if (columnMetaData.type.getName().startsWith("INTERVAL_")) {
                    TimeUnitRange range;
                    int end = columnMetaData.type.getName().indexOf("(");
                    if (end < 0) {
                        end = columnMetaData.type.getName().length();
                    }
                    if ((range = TimeUnitRange.valueOf(columnMetaData.type.getName().substring("INTERVAL_".length(), end))).monthly()) {
                        return new IntervalYearMonthAccessor(getter, range);
                    }
                    return new IntervalDayTimeAccessor(getter, range, columnMetaData.scale);
                }
                return new ObjectAccessor(getter);
            }
        }
        throw new RuntimeException("unknown type " + columnMetaData.type.id);
    }

    protected abstract Getter createGetter(int var1);

    @Override
    public abstract boolean next();

    private static String timestampAsString(long v, Calendar calendar, int precision) {
        if (calendar != null) {
            v -= (long)calendar.getTimeZone().getOffset(v);
        }
        return DateTimeUtils.unixTimestampToString(v, precision);
    }

    private static String dateAsString(int v, Calendar calendar) {
        AvaticaUtils.discard(calendar);
        return DateTimeUtils.unixDateToString(v);
    }

    private static String timeAsString(int v, Calendar calendar, int precision) {
        if (calendar != null) {
            v -= calendar.getTimeZone().getOffset(v);
        }
        return DateTimeUtils.unixTimeToString(v, precision);
    }

    public class StructGetter
    implements Getter {
        public final Getter getter;
        private final ColumnMetaData columnMetaData;

        public StructGetter(Getter getter, ColumnMetaData columnMetaData) {
            this.getter = getter;
            this.columnMetaData = columnMetaData;
        }

        @Override
        public Object getObject() throws SQLException {
            try {
                Object o = this.getter.getObject();
                if (o instanceof Object[]) {
                    Object[] objects = (Object[])o;
                    return objects[this.columnMetaData.ordinal];
                }
                Field field = o.getClass().getField(this.columnMetaData.label);
                return field.get(this.getter.getObject());
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                throw new SQLException(e);
            }
        }

        @Override
        public boolean wasNull() throws SQLException {
            return this.getObject() == null;
        }
    }

    public class SlotGetter
    implements Getter {
        public Object slot;

        @Override
        public Object getObject() throws SQLException {
            return this.slot;
        }

        @Override
        public boolean wasNull() throws SQLException {
            return this.slot == null;
        }
    }

    protected abstract class AbstractGetter
    implements Getter {
        protected AbstractGetter() {
        }

        @Override
        public boolean wasNull() throws SQLException {
            return AbstractCursor.this.wasNull[0];
        }
    }

    protected static interface Getter {
        public Object getObject() throws SQLException;

        public boolean wasNull() throws SQLException;
    }

    private static class ObjectAccessor
    extends AccessorImpl {
        private ObjectAccessor(Getter getter) {
            super(getter);
        }
    }

    private static class StructAccessor
    extends AccessorImpl {
        private final List<Cursor.Accessor> fieldAccessors;

        private StructAccessor(Getter getter, List<Cursor.Accessor> fieldAccessors) {
            super(getter);
            this.fieldAccessors = fieldAccessors;
        }

        @Override
        public Object getObject() throws SQLException {
            return this.getStruct();
        }

        @Override
        public <T> T getObject(Class<T> clz) throws SQLException {
            if (clz.equals(Struct.class)) {
                return (T)this.getStruct();
            }
            return super.getObject(clz);
        }

        @Override
        public Struct getStruct() throws SQLException {
            Object o = super.getObject();
            if (o == null) {
                return null;
            }
            if (o instanceof StructImpl) {
                return (StructImpl)o;
            }
            if (o instanceof List) {
                return new StructImpl((List)o);
            }
            ArrayList<Object> list = new ArrayList<Object>();
            for (Cursor.Accessor fieldAccessor : this.fieldAccessors) {
                list.add(fieldAccessor.getObject());
            }
            return new StructImpl(list);
        }
    }

    public static class ArrayAccessor
    extends AccessorImpl {
        final ColumnMetaData.AvaticaType componentType;
        final Cursor.Accessor componentAccessor;
        final SlotGetter componentSlotGetter;
        final ArrayImpl.Factory factory;

        public ArrayAccessor(Getter getter, ColumnMetaData.AvaticaType componentType, Cursor.Accessor componentAccessor, SlotGetter componentSlotGetter, ArrayImpl.Factory factory2) {
            super(getter);
            this.componentType = componentType;
            this.componentAccessor = componentAccessor;
            this.componentSlotGetter = componentSlotGetter;
            this.factory = factory2;
        }

        @Override
        public Object getObject() throws SQLException {
            Object object = super.getObject();
            if (object == null || object instanceof ArrayImpl) {
                return object;
            }
            if (object instanceof List) {
                List list = (List)object;
                ArrayList<Object> convertedValues = new ArrayList<Object>(list.size());
                for (Object val : list) {
                    if (null == val) {
                        convertedValues.add(null);
                        continue;
                    }
                    this.componentSlotGetter.slot = val instanceof Object[] && this.componentType.id != 2002 ? ((Object[])val)[0] : val;
                    convertedValues.add(this.convertValue());
                }
                return convertedValues;
            }
            return AvaticaUtils.primitiveList(object);
        }

        private Object convertValue() throws SQLException {
            switch (this.componentType.id) {
                case -7: 
                case 16: {
                    return this.componentAccessor.getBoolean();
                }
                case -6: {
                    return this.componentAccessor.getByte();
                }
                case 5: {
                    return this.componentAccessor.getShort();
                }
                case 4: {
                    return this.componentAccessor.getInt();
                }
                case -5: {
                    return this.componentAccessor.getLong();
                }
                case 7: {
                    return Float.valueOf(this.componentAccessor.getFloat());
                }
                case 6: 
                case 8: {
                    return this.componentAccessor.getDouble();
                }
                case 2003: {
                    return this.componentAccessor.getArray();
                }
                case -16: 
                case -15: 
                case -1: 
                case 1: 
                case 12: {
                    return this.componentAccessor.getString();
                }
                case -4: 
                case -3: 
                case -2: {
                    return this.componentAccessor.getBytes();
                }
                case 3: {
                    return this.componentAccessor.getBigDecimal();
                }
                case 91: 
                case 92: 
                case 93: 
                case 1111: 
                case 2000: 
                case 2002: {
                    return this.componentAccessor.getObject();
                }
            }
            throw new IllegalStateException("Unhandled ARRAY component type: " + (Object)((Object)this.componentType.rep) + ", id: " + this.componentType.id);
        }

        @Override
        public Array getArray() throws SQLException {
            Object o = this.getObject();
            if (o == null) {
                return null;
            }
            if (o instanceof ArrayImpl) {
                return (ArrayImpl)o;
            }
            return new ArrayImpl((List)o, this);
        }

        @Override
        public String getString() throws SQLException {
            Array array = this.getArray();
            return array == null ? null : array.toString();
        }
    }

    private static class IntervalDayTimeAccessor
    extends LongAccessor {
        private final TimeUnitRange range;
        private final int scale;

        private IntervalDayTimeAccessor(Getter getter, TimeUnitRange range, int scale) {
            super(getter);
            this.range = range;
            this.scale = scale;
        }

        @Override
        public String getString() throws SQLException {
            long v = this.getLong();
            if (v == 0L && this.wasNull()) {
                return null;
            }
            return DateTimeUtils.intervalDayTimeToString(v, this.range, this.scale);
        }
    }

    private static class IntervalYearMonthAccessor
    extends IntAccessor {
        private final TimeUnitRange range;

        private IntervalYearMonthAccessor(Getter getter, TimeUnitRange range) {
            super(getter);
            this.range = range;
        }

        @Override
        public String getString() throws SQLException {
            int v = this.getInt();
            if (v == 0 && this.wasNull()) {
                return null;
            }
            return DateTimeUtils.intervalYearMonthToString(v, this.range);
        }
    }

    static class TimestampFromUtilDateAccessor
    extends ObjectAccessor {
        private final Calendar localCalendar;
        private final int precision;

        TimestampFromUtilDateAccessor(Getter getter, Calendar localCalendar, int precision) {
            super(getter);
            this.localCalendar = localCalendar;
            this.precision = precision;
        }

        @Override
        public Timestamp getTimestamp(Calendar calendar) throws SQLException {
            java.util.Date date = (java.util.Date)this.getObject();
            if (date == null) {
                return null;
            }
            long v = date.getTime();
            if (calendar != null) {
                v -= (long)calendar.getTimeZone().getOffset(v);
            }
            return new Timestamp(v);
        }

        @Override
        public Date getDate(Calendar calendar) throws SQLException {
            Timestamp timestamp = this.getTimestamp(calendar);
            if (timestamp == null) {
                return null;
            }
            return new Date(timestamp.getTime());
        }

        @Override
        public Time getTime(Calendar calendar) throws SQLException {
            Timestamp timestamp = this.getTimestamp(calendar);
            if (timestamp == null) {
                return null;
            }
            return new Time(timestamp.getTime());
        }

        @Override
        public String getString() throws SQLException {
            java.util.Date date = (java.util.Date)this.getObject();
            if (date == null) {
                return null;
            }
            long unix = DateTimeUtils.utilDateToUnixTimestamp(date, this.localCalendar);
            return AbstractCursor.timestampAsString(unix, null, this.precision);
        }

        @Override
        public long getLong() throws SQLException {
            Timestamp timestamp = this.getTimestamp(this.localCalendar);
            return timestamp == null ? 0L : timestamp.getTime();
        }
    }

    static class TimestampAccessor
    extends ObjectAccessor {
        private final Calendar localCalendar;
        private final int precision;

        TimestampAccessor(Getter getter, Calendar localCalendar, int precision) {
            super(getter);
            this.localCalendar = localCalendar;
            this.precision = precision;
        }

        @Override
        public Timestamp getTimestamp(Calendar calendar) throws SQLException {
            Timestamp timestamp = (Timestamp)this.getObject();
            if (timestamp == null) {
                return null;
            }
            if (calendar != null) {
                long v = timestamp.getTime();
                v -= (long)calendar.getTimeZone().getOffset(v);
                timestamp = new Timestamp(v);
            }
            return timestamp;
        }

        @Override
        public Date getDate(Calendar calendar) throws SQLException {
            Timestamp timestamp = this.getTimestamp(calendar);
            if (timestamp == null) {
                return null;
            }
            return new Date(timestamp.getTime());
        }

        @Override
        public Time getTime(Calendar calendar) throws SQLException {
            Timestamp timestamp = this.getTimestamp(calendar);
            if (timestamp == null) {
                return null;
            }
            return new Time(timestamp.getTime());
        }

        @Override
        public String getString() throws SQLException {
            Timestamp timestamp = this.getTimestamp(null);
            if (timestamp == null) {
                return null;
            }
            long unix = DateTimeUtils.sqlTimestampToUnixTimestamp(timestamp, this.localCalendar);
            return AbstractCursor.timestampAsString(unix, null, this.precision);
        }

        @Override
        public long getLong() throws SQLException {
            Timestamp timestamp = this.getTimestamp(null);
            return timestamp == null ? 0L : timestamp.getTime();
        }
    }

    static class TimeAccessor
    extends ObjectAccessor {
        private final Calendar localCalendar;

        TimeAccessor(Getter getter, Calendar localCalendar) {
            super(getter);
            this.localCalendar = localCalendar;
        }

        @Override
        public Time getTime(Calendar calendar) throws SQLException {
            Time date = (Time)this.getObject();
            if (date == null) {
                return null;
            }
            if (calendar != null) {
                long v = date.getTime();
                v -= (long)calendar.getTimeZone().getOffset(v);
                date = new Time(v);
            }
            return date;
        }

        @Override
        public String getString() throws SQLException {
            Time time = this.getTime(null);
            if (time == null) {
                return null;
            }
            int unix = DateTimeUtils.sqlTimeToUnixTime(time, this.localCalendar);
            return AbstractCursor.timeAsString(unix, null, 0);
        }

        @Override
        public long getLong() throws SQLException {
            Time time = this.getTime(null);
            return time == null ? 0L : time.getTime() % 86400000L;
        }
    }

    static class DateAccessor
    extends ObjectAccessor {
        private final Calendar localCalendar;

        DateAccessor(Getter getter, Calendar localCalendar) {
            super(getter);
            this.localCalendar = localCalendar;
        }

        @Override
        public Date getDate(Calendar calendar) throws SQLException {
            Date date = (Date)this.getObject();
            if (date == null) {
                return null;
            }
            if (calendar != null) {
                long v = date.getTime();
                v -= (long)calendar.getTimeZone().getOffset(v);
                date = new Date(v);
            }
            return date;
        }

        @Override
        public String getString() throws SQLException {
            Date date = this.getDate(null);
            if (date == null) {
                return null;
            }
            int unix = DateTimeUtils.sqlDateToUnixDate(date, this.localCalendar);
            return AbstractCursor.dateAsString(unix, null);
        }

        @Override
        public long getLong() throws SQLException {
            Date date = this.getDate(null);
            return date == null ? 0L : date.getTime() / 86400000L;
        }
    }

    static class TimestampFromNumberAccessor
    extends NumberAccessor {
        private final Calendar localCalendar;
        private final int precision;

        TimestampFromNumberAccessor(Getter getter, Calendar localCalendar, int precision) {
            super(getter, 0);
            this.localCalendar = localCalendar;
            this.precision = precision;
        }

        @Override
        public Object getObject() throws SQLException {
            return this.getTimestamp(this.localCalendar);
        }

        @Override
        public Timestamp getTimestamp(Calendar calendar) throws SQLException {
            Number v = this.getNumber();
            if (v == null) {
                return null;
            }
            return DateTimeUtils.unixTimestampToSqlTimestamp(v.longValue(), calendar);
        }

        @Override
        public Date getDate(Calendar calendar) throws SQLException {
            Timestamp timestamp = this.getTimestamp(calendar);
            if (timestamp == null) {
                return null;
            }
            return new Date(timestamp.getTime());
        }

        @Override
        public Time getTime(Calendar calendar) throws SQLException {
            Timestamp timestamp = this.getTimestamp(calendar);
            if (timestamp == null) {
                return null;
            }
            return new Time(timestamp.getTime());
        }

        @Override
        public String getString() throws SQLException {
            Number v = this.getNumber();
            if (v == null) {
                return null;
            }
            return AbstractCursor.timestampAsString(v.longValue(), null, this.precision);
        }

        @Override
        protected Number getNumber() throws SQLException {
            Object v = super.getObject();
            if (v == null) {
                return null;
            }
            if (v instanceof Timestamp) {
                return ((Timestamp)v).getTime();
            }
            return (Number)v;
        }
    }

    static class TimeFromNumberAccessor
    extends NumberAccessor {
        private final Calendar localCalendar;
        private final int precision;

        TimeFromNumberAccessor(Getter getter, Calendar localCalendar, int precision) {
            super(getter, 0);
            this.localCalendar = localCalendar;
            this.precision = precision;
        }

        @Override
        public Object getObject() throws SQLException {
            return this.getTime(this.localCalendar);
        }

        @Override
        public Time getTime(Calendar calendar) throws SQLException {
            Number v = this.getNumber();
            if (v == null) {
                return null;
            }
            return DateTimeUtils.unixTimeToSqlTime(v.intValue(), calendar);
        }

        @Override
        public Timestamp getTimestamp(Calendar calendar) throws SQLException {
            Number v = this.getNumber();
            if (v == null) {
                return null;
            }
            return DateTimeUtils.unixTimestampToSqlTimestamp(v.longValue(), calendar);
        }

        @Override
        public String getString() throws SQLException {
            Number v = this.getNumber();
            if (v == null) {
                return null;
            }
            return AbstractCursor.timeAsString(v.intValue(), null, this.precision);
        }

        @Override
        protected Number getNumber() throws SQLException {
            Object v = super.getObject();
            if (v == null) {
                return null;
            }
            if (v instanceof Time) {
                return ((Time)v).getTime();
            }
            return (Number)v;
        }
    }

    static class DateFromNumberAccessor
    extends NumberAccessor {
        private final Calendar localCalendar;

        DateFromNumberAccessor(Getter getter, Calendar localCalendar) {
            super(getter, 0);
            this.localCalendar = localCalendar;
        }

        @Override
        public Object getObject() throws SQLException {
            return this.getDate(this.localCalendar);
        }

        @Override
        public Date getDate(Calendar calendar) throws SQLException {
            Number v = this.getNumber();
            if (v == null) {
                return null;
            }
            return DateTimeUtils.unixDateToSqlDate(v.intValue(), calendar);
        }

        @Override
        public Timestamp getTimestamp(Calendar calendar) throws SQLException {
            Number v = this.getNumber();
            if (v == null) {
                return null;
            }
            return DateTimeUtils.unixTimestampToSqlTimestamp(v.longValue() * 86400000L, calendar);
        }

        @Override
        public String getString() throws SQLException {
            Number v = this.getNumber();
            if (v == null) {
                return null;
            }
            return AbstractCursor.dateAsString(v.intValue(), null);
        }

        @Override
        protected Number getNumber() throws SQLException {
            Object value = super.getObject();
            if (value == null) {
                return null;
            }
            if (value instanceof Date) {
                long time = ((Date)value).getTime();
                time -= (long)this.localCalendar.getTimeZone().getOffset(time);
                return time / 86400000L;
            }
            return (Number)value;
        }
    }

    private static class BinaryFromStringAccessor
    extends StringAccessor {
        private BinaryFromStringAccessor(Getter getter) {
            super(getter);
        }

        @Override
        public Object getObject() throws SQLException {
            return super.getObject();
        }

        @Override
        public byte[] getBytes() throws SQLException {
            Object obj = this.getObject();
            if (obj instanceof byte[]) {
                return (byte[])obj;
            }
            return this.getBase64Decoded();
        }

        private byte[] getBase64Decoded() throws SQLException {
            String string = super.getString();
            if (null == string) {
                return null;
            }
            return ByteString.parseBase64(string);
        }

        @Override
        public String getString() throws SQLException {
            byte[] bytes = this.getBase64Decoded();
            if (null == bytes) {
                return null;
            }
            return AvaticaUtils.newStringUtf8(bytes);
        }
    }

    private static class BinaryAccessor
    extends AccessorImpl {
        private BinaryAccessor(Getter getter) {
            super(getter);
        }

        @Override
        public byte[] getBytes() throws SQLException {
            Object obj = this.getObject();
            if (null == obj) {
                return null;
            }
            if (obj instanceof ByteString) {
                return ((ByteString)obj).getBytes();
            }
            if (obj instanceof String) {
                return ByteString.parseBase64((String)obj);
            }
            if (obj instanceof byte[]) {
                return (byte[])obj;
            }
            throw new RuntimeException("Cannot handle " + obj.getClass() + " as bytes");
        }

        @Override
        public String getString() throws SQLException {
            Object o = this.getObject();
            if (null == o) {
                return null;
            }
            if (o instanceof byte[]) {
                return AvaticaUtils.newStringUtf8((byte[])o);
            }
            if (o instanceof ByteString) {
                return ((ByteString)o).toString();
            }
            throw new IllegalStateException("Unhandled value type: " + o.getClass());
        }
    }

    private static class StringFromCharAccessor
    extends FixedStringAccessor {
        private StringFromCharAccessor(Getter getter, int length) {
            super(getter, length);
        }

        @Override
        public String getString() throws SQLException {
            Character s2 = (Character)super.getObject();
            if (s2 == null) {
                return null;
            }
            return this.spacer.padRight(s2.toString());
        }
    }

    private static class FixedStringAccessor
    extends StringAccessor {
        protected final Spacer spacer;

        private FixedStringAccessor(Getter getter, int length) {
            super(getter);
            this.spacer = new Spacer(length);
        }

        @Override
        public String getString() throws SQLException {
            String s2 = super.getString();
            if (s2 == null) {
                return null;
            }
            return this.spacer.padRight(s2);
        }
    }

    private static class StringAccessor
    extends AccessorImpl {
        private StringAccessor(Getter getter) {
            super(getter);
        }

        @Override
        public String getString() throws SQLException {
            Object obj = this.getObject();
            if (obj instanceof String) {
                return (String)obj;
            }
            return null == obj ? null : obj.toString();
        }

        @Override
        public byte[] getBytes() throws SQLException {
            return super.getBytes();
        }
    }

    static class NumberAccessor
    extends BigNumberAccessor {
        private final int scale;

        NumberAccessor(Getter getter, int scale) {
            super(getter);
            this.scale = scale;
        }

        @Override
        protected Number getNumber() throws SQLException {
            return (Number)super.getObject();
        }

        @Override
        public BigDecimal getBigDecimal(int scale) throws SQLException {
            Number n = this.getNumber();
            if (n == null) {
                return null;
            }
            BigDecimal decimal = AvaticaSite.toBigDecimal(n);
            if (0 != scale && !(n instanceof BigDecimal)) {
                return decimal.setScale(scale, RoundingMode.DOWN);
            }
            return decimal;
        }

        @Override
        public BigDecimal getBigDecimal() throws SQLException {
            return this.getBigDecimal(this.scale);
        }
    }

    private static class BigDecimalAccessor
    extends BigNumberAccessor {
        private BigDecimalAccessor(Getter getter) {
            super(getter);
        }

        @Override
        protected Number getNumber() throws SQLException {
            return (Number)this.getObject();
        }

        @Override
        public BigDecimal getBigDecimal(int scale) throws SQLException {
            Number number = this.getNumber();
            return number == null || number instanceof BigDecimal ? (BigDecimal)number : BigDecimal.valueOf(number.longValue());
        }

        @Override
        public BigDecimal getBigDecimal() throws SQLException {
            Number number = this.getNumber();
            return number == null || number instanceof BigDecimal ? (BigDecimal)number : BigDecimal.valueOf(number.longValue());
        }
    }

    private static abstract class BigNumberAccessor
    extends AccessorImpl {
        private BigNumberAccessor(Getter getter) {
            super(getter);
        }

        protected abstract Number getNumber() throws SQLException;

        @Override
        public double getDouble() throws SQLException {
            Number number = this.getNumber();
            return number == null ? 0.0 : number.doubleValue();
        }

        @Override
        public float getFloat() throws SQLException {
            Number number = this.getNumber();
            return number == null ? 0.0f : number.floatValue();
        }

        @Override
        public long getLong() throws SQLException {
            Number number = this.getNumber();
            return number == null ? 0L : number.longValue();
        }

        @Override
        public int getInt() throws SQLException {
            Number number = this.getNumber();
            return number == null ? 0 : number.intValue();
        }

        @Override
        public short getShort() throws SQLException {
            Number number = this.getNumber();
            return number == null ? (short)0 : number.shortValue();
        }

        @Override
        public byte getByte() throws SQLException {
            Number number = this.getNumber();
            return number == null ? (byte)0 : number.byteValue();
        }

        @Override
        public boolean getBoolean() throws SQLException {
            Number number = this.getNumber();
            return number != null && number.doubleValue() != 0.0;
        }
    }

    private static class DoubleAccessor
    extends ApproximateNumericAccessor {
        private DoubleAccessor(Getter getter) {
            super(getter);
        }

        @Override
        public double getDouble() throws SQLException {
            Object obj = this.getObject();
            if (null == obj) {
                return 0.0;
            }
            if (obj instanceof BigDecimal) {
                return ((BigDecimal)obj).doubleValue();
            }
            return (Double)obj;
        }
    }

    private static class FloatAccessor
    extends ApproximateNumericAccessor {
        private FloatAccessor(Getter getter) {
            super(getter);
        }

        @Override
        public float getFloat() throws SQLException {
            Float o = (Float)this.getObject();
            return o == null ? 0.0f : o.floatValue();
        }

        @Override
        public double getDouble() throws SQLException {
            return this.getFloat();
        }
    }

    private static abstract class ApproximateNumericAccessor
    extends AccessorImpl {
        private ApproximateNumericAccessor(Getter getter) {
            super(getter);
        }

        @Override
        public BigDecimal getBigDecimal(int scale) throws SQLException {
            double v = this.getDouble();
            if (v == 0.0 && this.getter.wasNull()) {
                return null;
            }
            return BigDecimal.valueOf(v).setScale(scale, RoundingMode.DOWN);
        }

        @Override
        public BigDecimal getBigDecimal() throws SQLException {
            double v = this.getDouble();
            if (v == 0.0 && this.getter.wasNull()) {
                return null;
            }
            return BigDecimal.valueOf(v);
        }

        @Override
        public abstract double getDouble() throws SQLException;

        @Override
        public long getLong() throws SQLException {
            return (long)this.getDouble();
        }
    }

    private static class LongAccessor
    extends ExactNumericAccessor {
        private LongAccessor(Getter getter) {
            super(getter);
        }

        @Override
        public long getLong() throws SQLException {
            Long o = (Long)super.getObject();
            return o == null ? 0L : o;
        }
    }

    private static class IntAccessor
    extends ExactNumericAccessor {
        private IntAccessor(Getter getter) {
            super(getter);
        }

        @Override
        public int getInt() throws SQLException {
            Integer o = (Integer)super.getObject();
            return o == null ? 0 : o;
        }

        @Override
        public long getLong() throws SQLException {
            return this.getInt();
        }
    }

    private static class ShortAccessor
    extends ExactNumericAccessor {
        private ShortAccessor(Getter getter) {
            super(getter);
        }

        @Override
        public short getShort() throws SQLException {
            Object obj = this.getObject();
            if (null == obj) {
                return 0;
            }
            if (obj instanceof Integer) {
                return ((Integer)obj).shortValue();
            }
            return (Short)obj;
        }

        @Override
        public long getLong() throws SQLException {
            return this.getShort();
        }
    }

    private static class ByteAccessor
    extends ExactNumericAccessor {
        private ByteAccessor(Getter getter) {
            super(getter);
        }

        @Override
        public byte getByte() throws SQLException {
            Object obj = this.getObject();
            if (null == obj) {
                return 0;
            }
            if (obj instanceof Integer) {
                return ((Integer)obj).byteValue();
            }
            return (Byte)obj;
        }

        @Override
        public long getLong() throws SQLException {
            return this.getByte();
        }
    }

    private static class BooleanAccessor
    extends ExactNumericAccessor {
        private BooleanAccessor(Getter getter) {
            super(getter);
        }

        @Override
        public boolean getBoolean() throws SQLException {
            Boolean o = (Boolean)this.getObject();
            return o != null && o != false;
        }

        @Override
        public long getLong() throws SQLException {
            return this.getBoolean() ? 1L : 0L;
        }
    }

    private static abstract class ExactNumericAccessor
    extends AccessorImpl {
        private ExactNumericAccessor(Getter getter) {
            super(getter);
        }

        @Override
        public BigDecimal getBigDecimal(int scale) throws SQLException {
            long v = this.getLong();
            if (v == 0L && this.getter.wasNull()) {
                return null;
            }
            return BigDecimal.valueOf(v).setScale(scale, RoundingMode.DOWN);
        }

        @Override
        public BigDecimal getBigDecimal() throws SQLException {
            long val = this.getLong();
            if (val == 0L && this.getter.wasNull()) {
                return null;
            }
            return BigDecimal.valueOf(val);
        }

        @Override
        public double getDouble() throws SQLException {
            return this.getLong();
        }

        @Override
        public float getFloat() throws SQLException {
            return this.getLong();
        }

        @Override
        public abstract long getLong() throws SQLException;
    }

    static class AccessorImpl
    implements Cursor.Accessor {
        protected final Getter getter;

        AccessorImpl(Getter getter) {
            assert (getter != null);
            this.getter = getter;
        }

        @Override
        public boolean wasNull() throws SQLException {
            return this.getter.wasNull();
        }

        @Override
        public String getString() throws SQLException {
            Object o = this.getObject();
            return o == null ? null : o.toString();
        }

        @Override
        public boolean getBoolean() throws SQLException {
            return this.getLong() != 0L;
        }

        @Override
        public byte getByte() throws SQLException {
            return (byte)this.getLong();
        }

        @Override
        public short getShort() throws SQLException {
            return (short)this.getLong();
        }

        @Override
        public int getInt() throws SQLException {
            return (int)this.getLong();
        }

        @Override
        public long getLong() throws SQLException {
            throw this.cannotConvert("long");
        }

        @Override
        public float getFloat() throws SQLException {
            return (float)this.getDouble();
        }

        @Override
        public double getDouble() throws SQLException {
            throw this.cannotConvert("double");
        }

        @Override
        public BigDecimal getBigDecimal() throws SQLException {
            throw this.cannotConvert("BigDecimal");
        }

        @Override
        public BigDecimal getBigDecimal(int scale) throws SQLException {
            throw this.cannotConvert("BigDecimal with scale");
        }

        @Override
        public byte[] getBytes() throws SQLException {
            throw this.cannotConvert("byte[]");
        }

        @Override
        public InputStream getAsciiStream() throws SQLException {
            throw this.cannotConvert("InputStream (ascii)");
        }

        @Override
        public InputStream getUnicodeStream() throws SQLException {
            throw this.cannotConvert("InputStream (unicode)");
        }

        @Override
        public InputStream getBinaryStream() throws SQLException {
            throw this.cannotConvert("InputStream (binary)");
        }

        @Override
        public Object getObject() throws SQLException {
            return this.getter.getObject();
        }

        @Override
        public Reader getCharacterStream() throws SQLException {
            throw this.cannotConvert("Reader");
        }

        private SQLException cannotConvert(String targetType) throws SQLException {
            return new SQLDataException("cannot convert to " + targetType + " (" + this + ")");
        }

        @Override
        public Object getObject(Map<String, Class<?>> map) throws SQLException {
            throw this.cannotConvert("Object (with map)");
        }

        @Override
        public Ref getRef() throws SQLException {
            throw this.cannotConvert("Ref");
        }

        @Override
        public Blob getBlob() throws SQLException {
            throw this.cannotConvert("Blob");
        }

        @Override
        public Clob getClob() throws SQLException {
            throw this.cannotConvert("Clob");
        }

        @Override
        public Array getArray() throws SQLException {
            throw this.cannotConvert("Array");
        }

        @Override
        public Struct getStruct() throws SQLException {
            throw this.cannotConvert("Struct");
        }

        @Override
        public Date getDate(Calendar calendar) throws SQLException {
            throw this.cannotConvert("Date");
        }

        @Override
        public Time getTime(Calendar calendar) throws SQLException {
            throw this.cannotConvert("Time");
        }

        @Override
        public Timestamp getTimestamp(Calendar calendar) throws SQLException {
            throw this.cannotConvert("Timestamp");
        }

        @Override
        public URL getURL() throws SQLException {
            throw this.cannotConvert("URL");
        }

        @Override
        public NClob getNClob() throws SQLException {
            throw this.cannotConvert("NClob");
        }

        @Override
        public SQLXML getSQLXML() throws SQLException {
            throw this.cannotConvert("SQLXML");
        }

        @Override
        public String getNString() throws SQLException {
            throw this.cannotConvert("NString");
        }

        @Override
        public Reader getNCharacterStream() throws SQLException {
            throw this.cannotConvert("NCharacterStream");
        }

        @Override
        public <T> T getObject(Class<T> type2) throws SQLException {
            throw this.cannotConvert("Object (with type)");
        }
    }
}

