/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql;

import java.math.BigDecimal;
import java.util.Objects;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.util.Util;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.dataflow.qual.Pure;

public class SqlNumericLiteral
extends SqlLiteral {
    private final @Nullable Integer prec;
    private final @Nullable Integer scale;
    private final boolean exact;

    protected SqlNumericLiteral(BigDecimal value, @Nullable Integer prec, @Nullable Integer scale, boolean exact, SqlParserPos pos) {
        super(value, exact ? SqlTypeName.DECIMAL : SqlTypeName.DOUBLE, pos);
        this.prec = prec;
        this.scale = scale;
        this.exact = exact;
    }

    private BigDecimal getValueNonNull() {
        return (BigDecimal)Objects.requireNonNull(this.value, "value");
    }

    public @Nullable Integer getPrec() {
        return this.prec;
    }

    @Pure
    public @Nullable Integer getScale() {
        return this.scale;
    }

    public boolean isExact() {
        return this.exact;
    }

    @Override
    public SqlNumericLiteral clone(SqlParserPos pos) {
        return new SqlNumericLiteral(this.getValueNonNull(), this.getPrec(), this.getScale(), this.exact, pos);
    }

    @Override
    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        writer.literal(this.toValue());
    }

    @Override
    public String toValue() {
        BigDecimal bd = this.getValueNonNull();
        if (this.exact) {
            return bd.toPlainString();
        }
        return Util.toScientificNotation(bd);
    }

    @Override
    public RelDataType createSqlType(RelDataTypeFactory typeFactory) {
        if (this.exact) {
            int scaleValue = Objects.requireNonNull(this.scale, "scale");
            if (0 == scaleValue) {
                try {
                    BigDecimal bd = this.getValueNonNull();
                    long l = bd.longValueExact();
                    SqlTypeName result2 = l >= Integer.MIN_VALUE && l <= Integer.MAX_VALUE ? SqlTypeName.INTEGER : SqlTypeName.BIGINT;
                    return typeFactory.createSqlType(result2);
                }
                catch (ArithmeticException arithmeticException) {
                    // empty catch block
                }
            }
            return typeFactory.createSqlType(SqlTypeName.DECIMAL, Objects.requireNonNull(this.prec, "prec"), scaleValue);
        }
        return typeFactory.createSqlType(SqlTypeName.DOUBLE);
    }

    public boolean isInteger() {
        return this.scale != null && 0 == this.scale;
    }
}

