/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.geo.search.aggregations.bucket.geogrid;

import java.io.IOException;
import java.util.Map;
import org.opensearch.common.geo.GeoBoundingBox;
import org.opensearch.common.geo.GeoUtils;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.xcontent.ObjectParser;
import org.opensearch.geo.search.aggregations.bucket.geogrid.GeoGridAggregationBuilder;
import org.opensearch.geo.search.aggregations.bucket.geogrid.GeoGridAggregatorSupplier;
import org.opensearch.geo.search.aggregations.bucket.geogrid.GeoHashGridAggregatorFactory;
import org.opensearch.index.query.QueryShardContext;
import org.opensearch.search.aggregations.AggregationBuilder;
import org.opensearch.search.aggregations.AggregatorFactories;
import org.opensearch.search.aggregations.AggregatorFactory;
import org.opensearch.search.aggregations.support.ValuesSourceAggregatorFactory;
import org.opensearch.search.aggregations.support.ValuesSourceConfig;
import org.opensearch.search.aggregations.support.ValuesSourceRegistry;

public class GeoHashGridAggregationBuilder
extends GeoGridAggregationBuilder {
    public static final String NAME = "geohash_grid";
    public static final int DEFAULT_PRECISION = 5;
    public static final int DEFAULT_MAX_NUM_CELLS = 10000;
    public static final ValuesSourceRegistry.RegistryKey<GeoGridAggregatorSupplier> REGISTRY_KEY = new ValuesSourceRegistry.RegistryKey("geohash_grid", GeoGridAggregatorSupplier.class);
    public static final ObjectParser<GeoHashGridAggregationBuilder, String> PARSER = GeoHashGridAggregationBuilder.createParser("geohash_grid", GeoUtils::parsePrecision, GeoHashGridAggregationBuilder::new);

    public GeoHashGridAggregationBuilder(String name) {
        super(name);
        this.precision(5);
        this.size(10000);
        this.shardSize = -1;
    }

    public GeoHashGridAggregationBuilder(StreamInput in) throws IOException {
        super(in);
    }

    public static void registerAggregators(ValuesSourceRegistry.Builder builder) {
        GeoHashGridAggregatorFactory.registerAggregators(builder);
    }

    @Override
    public GeoGridAggregationBuilder precision(int precision) {
        this.precision = GeoUtils.checkPrecisionRange((int)precision);
        return this;
    }

    @Override
    protected ValuesSourceAggregatorFactory createFactory(String name, ValuesSourceConfig config, int precision, int requiredSize, int shardSize, GeoBoundingBox geoBoundingBox, QueryShardContext queryShardContext, AggregatorFactory parent, AggregatorFactories.Builder subFactoriesBuilder, Map<String, Object> metadata2) throws IOException {
        return new GeoHashGridAggregatorFactory(name, config, precision, requiredSize, shardSize, geoBoundingBox, queryShardContext, parent, subFactoriesBuilder, metadata2);
    }

    private GeoHashGridAggregationBuilder(GeoHashGridAggregationBuilder clone, AggregatorFactories.Builder factoriesBuilder, Map<String, Object> metadata2) {
        super(clone, factoriesBuilder, metadata2);
    }

    protected AggregationBuilder shallowCopy(AggregatorFactories.Builder factoriesBuilder, Map<String, Object> metadata2) {
        return new GeoHashGridAggregationBuilder(this, factoriesBuilder, metadata2);
    }

    public String getType() {
        return NAME;
    }

    protected ValuesSourceRegistry.RegistryKey<?> getRegistryKey() {
        return REGISTRY_KEY;
    }
}

