/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.common.dataframe;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import lombok.Generated;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.ml.common.dataframe.BooleanValue;
import org.opensearch.ml.common.dataframe.ColumnValue;
import org.opensearch.ml.common.dataframe.ColumnValueReader;
import org.opensearch.ml.common.dataframe.DoubleValue;
import org.opensearch.ml.common.dataframe.FloatValue;
import org.opensearch.ml.common.dataframe.IntValue;
import org.opensearch.ml.common.dataframe.LongValue;
import org.opensearch.ml.common.dataframe.NullValue;
import org.opensearch.ml.common.dataframe.ShortValue;
import org.opensearch.ml.common.dataframe.StringValue;

public class Row
implements Iterable<ColumnValue>,
Writeable,
ToXContentObject {
    private final ColumnValue[] values;

    Row(int size) {
        this.values = new ColumnValue[size];
        Arrays.fill(this.values, new NullValue());
    }

    public Row(ColumnValue[] values2) {
        this.values = values2;
    }

    Row(StreamInput input) throws IOException {
        this.values = (ColumnValue[])input.readArray((Writeable.Reader)new ColumnValueReader(), ColumnValue[]::new);
    }

    void setValue(int index, ColumnValue value) {
        if (index < 0 || index > this.size() - 1) {
            throw new IllegalArgumentException("index is out of scope, index:" + index + "; row size:" + this.size());
        }
        this.values[index] = value;
    }

    public ColumnValue getValue(int index) {
        if (index < 0 || index > this.size() - 1) {
            throw new IllegalArgumentException("index is out of scope, index:" + index + "; row size:" + this.size());
        }
        return this.values[index];
    }

    @Override
    public Iterator<ColumnValue> iterator() {
        return Arrays.stream(this.values).iterator();
    }

    public int size() {
        return this.values.length;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeArray((Writeable[])this.values);
    }

    Row remove(int removedIndex) {
        if (removedIndex < 0 || removedIndex >= this.values.length) {
            throw new IllegalArgumentException("removed index can't be negative or bigger than row's values length:" + this.values.length);
        }
        ColumnValue[] newValues = new ColumnValue[Math.max(this.values.length - 1, 0)];
        int index = 0;
        for (int i = 0; i < this.values.length && i != removedIndex; ++i) {
            newValues[index++] = this.values[i];
        }
        return new Row(newValues);
    }

    Row select(int[] columns) {
        ColumnValue[] newValues = new ColumnValue[columns.length];
        int index = 0;
        for (int col : columns) {
            newValues[index++] = this.values[col];
        }
        return new Row(newValues);
    }

    public static Row parse(XContentParser parser) throws IOException {
        ArrayList<ColumnValue> values2 = new ArrayList<ColumnValue>();
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
        block26: while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = parser.currentName();
            parser.nextToken();
            switch (fieldName) {
                case "values": {
                    XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
                    while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
                        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
                        if (parser.nextToken() == XContentParser.Token.END_OBJECT) continue;
                        String columnTypeField = parser.currentName();
                        if (!"column_type".equals(columnTypeField)) {
                            throw new IllegalArgumentException("wrong column type, expect column_type field but got " + columnTypeField);
                        }
                        parser.nextToken();
                        String columnType = parser.text();
                        if (!"NULL".equals(columnType)) {
                            parser.nextToken();
                            String valueField = parser.currentName();
                            if (!"value".equals(valueField)) {
                                throw new IllegalArgumentException("wrong column value, expect value field but got " + valueField);
                            }
                            parser.nextToken();
                        }
                        switch (columnType) {
                            case "NULL": {
                                values2.add(new NullValue());
                                break;
                            }
                            case "BOOLEAN": {
                                values2.add(new BooleanValue(parser.booleanValue()));
                                break;
                            }
                            case "STRING": {
                                values2.add(new StringValue(parser.text()));
                                break;
                            }
                            case "SHORT": {
                                values2.add(new ShortValue(parser.shortValue()));
                                break;
                            }
                            case "INTEGER": {
                                values2.add(new IntValue(parser.intValue()));
                                break;
                            }
                            case "LONG": {
                                values2.add(new LongValue(parser.longValue()));
                                break;
                            }
                            case "FLOAT": {
                                values2.add(new FloatValue(parser.floatValue()));
                                break;
                            }
                            case "DOUBLE": {
                                values2.add(new DoubleValue(parser.doubleValue()));
                                break;
                            }
                        }
                        parser.skipChildren();
                        parser.nextToken();
                    }
                    continue block26;
                }
            }
            parser.skipChildren();
        }
        return new Row(values2.toArray(new ColumnValue[0]));
    }

    public XContentBuilder toXContent(XContentBuilder builder) throws IOException {
        return this.toXContent(builder, EMPTY_PARAMS);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.startArray("values");
        for (ColumnValue value : this.values) {
            value.toXContent(builder, params);
        }
        builder.endArray();
        builder.endObject();
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Row other = (Row)o;
        if (this.size() != other.size()) {
            return false;
        }
        for (int i = 0; i < this.size(); ++i) {
            if (this.getValue(i).equals(other.getValue(i))) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Row other) {
        if (this.size() != other.size()) {
            return false;
        }
        for (int i = 0; i < this.size(); ++i) {
            if (this.getValue(i).equals(other.getValue(i))) continue;
            return false;
        }
        return true;
    }

    @Generated
    public String toString() {
        return "Row(values=" + Arrays.deepToString(this.values) + ")";
    }
}

