/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.common.memorycontainer;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public enum MemoryType {
    SESSIONS("sessions", "sessions"),
    WORKING("working", "working"),
    LONG_TERM("long-term", "long-term"),
    HISTORY("history", "history");

    private final String value;
    private final String indexSuffix;

    private MemoryType(String value, String indexSuffix) {
        this.value = value;
        this.indexSuffix = indexSuffix;
    }

    public String getValue() {
        return this.value;
    }

    public String getIndexSuffix() {
        return this.indexSuffix;
    }

    public boolean isDisableable() {
        return this == SESSIONS || this == HISTORY;
    }

    public String toIndexName(String prefix) {
        return prefix + this.indexSuffix;
    }

    public static MemoryType fromString(String value) {
        if (value == null) {
            return null;
        }
        String normalizedValue = value.toLowerCase();
        for (MemoryType type2 : MemoryType.values()) {
            if (!type2.value.equalsIgnoreCase(normalizedValue)) continue;
            return type2;
        }
        throw new IllegalArgumentException("Invalid memory type: " + value + ". Must be one of: " + MemoryType.getAllValuesAsString());
    }

    public static boolean isValid(String value) {
        try {
            return MemoryType.fromString(value) != null;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public static List<String> getAllValues() {
        return Arrays.stream(MemoryType.values()).map(MemoryType::getValue).collect(Collectors.toList());
    }

    public static String getAllValuesAsString() {
        return String.join((CharSequence)", ", MemoryType.getAllValues());
    }

    public String toString() {
        return this.value;
    }
}

