/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.common.utils;

import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.ml.common.utils.StringUtils;
import org.opensearch.ml.repackage.com.google.common.base.Charsets;
import org.opensearch.ml.repackage.com.google.common.io.Resources;

public class IndexUtils {
    @Generated
    private static final Logger log = LogManager.getLogger(IndexUtils.class);
    public static final Map<String, Object> DEFAULT_INDEX_SETTINGS = Map.of("index.number_of_shards", "1", "index.auto_expand_replicas", "0-1");
    public static final Map<String, Object> ALL_NODES_REPLICA_INDEX_SETTINGS = Map.of("index.number_of_shards", "1", "index.auto_expand_replicas", "0-all");
    public static final Map<String, Object> UPDATED_DEFAULT_INDEX_SETTINGS = Map.of("index.auto_expand_replicas", "0-1");
    public static final Map<String, Object> UPDATED_ALL_NODES_REPLICA_INDEX_SETTINGS = Map.of("index.auto_expand_replicas", "0-all");
    public static final String MAPPING_SCHEMA_PATH = "index-mappings/schema.json";
    private static final String USER_PLACEHOLDER = "USER_MAPPING_PLACEHOLDER";
    private static final String CONNECTOR_PLACEHOLDER = "CONNECTOR_MAPPING_PLACEHOLDER";
    public static final Map<String, String> MAPPING_PLACEHOLDERS = Map.of("USER_MAPPING_PLACEHOLDER", "index-mappings/placeholders/user.json", "CONNECTOR_MAPPING_PLACEHOLDER", "index-mappings/placeholders/connector.json");

    public static String getMappingFromFile(String path) throws IOException {
        URL url = IndexUtils.class.getClassLoader().getResource(path);
        if (url == null) {
            throw new IOException("Resource not found: " + path);
        }
        String mapping = Resources.toString(url, Charsets.UTF_8).trim();
        if (mapping.isEmpty()) {
            throw new IllegalArgumentException("Empty mapping found at: " + path);
        }
        mapping = IndexUtils.replacePlaceholders(mapping);
        IndexUtils.validateMapping(mapping);
        return mapping;
    }

    public static String replacePlaceholders(String mapping) throws IOException {
        if (mapping == null || mapping.isBlank()) {
            throw new IllegalArgumentException("Mapping cannot be null or empty");
        }
        HashMap<String, String> loadedPlaceholders = new HashMap<String, String>();
        for (Map.Entry<String, String> placeholder : MAPPING_PLACEHOLDERS.entrySet()) {
            URL url = IndexUtils.class.getClassLoader().getResource(placeholder.getValue());
            if (url == null) {
                throw new IOException("Resource not found: " + placeholder.getValue());
            }
            loadedPlaceholders.put(placeholder.getKey(), Resources.toString(url, Charsets.UTF_8));
        }
        StringBuilder result2 = new StringBuilder(mapping);
        for (Map.Entry entry : loadedPlaceholders.entrySet()) {
            int index;
            String placeholder = (String)entry.getKey();
            String replacement = (String)entry.getValue();
            while ((index = result2.indexOf(placeholder)) != -1) {
                result2.replace(index, index + placeholder.length(), replacement);
            }
        }
        return result2.toString();
    }

    public static void validateMapping(String mapping) throws IOException {
        if (mapping.isBlank() || !StringUtils.isJson(mapping)) {
            throw new IllegalArgumentException("Invalid or non-JSON mapping found: " + mapping);
        }
        URL url = IndexUtils.class.getClassLoader().getResource(MAPPING_SCHEMA_PATH);
        if (url == null) {
            throw new IOException("Resource not found: index-mappings/schema.json");
        }
        String schema = Resources.toString(url, Charsets.UTF_8);
        StringUtils.validateSchema(schema, mapping);
    }

    public static Integer getVersionFromMapping(String mapping) {
        if (mapping == null || mapping.isBlank()) {
            throw new IllegalArgumentException("Mapping cannot be null or empty");
        }
        JsonObject mappingJson = StringUtils.getJsonObjectFromString(mapping);
        if (mappingJson == null || !mappingJson.has("_meta")) {
            throw new JsonParseException("Failed to find \"_meta\" object in mapping: " + mapping);
        }
        JsonObject metaObject = mappingJson.getAsJsonObject("_meta");
        if (metaObject == null || !metaObject.has("schema_version")) {
            throw new JsonParseException("Failed to find \"schema_version\" in \"_meta\" object for mapping: " + mapping);
        }
        try {
            return metaObject.get("schema_version").getAsInt();
        }
        catch (ClassCastException | NumberFormatException e) {
            throw new JsonParseException("Invalid \"schema_version\" value in mapping: " + mapping, e);
        }
    }
}

