/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.expression.function.udf.condition;

import java.util.List;
import java.util.function.Supplier;
import org.apache.calcite.adapter.enumerable.NotNullImplementor;
import org.apache.calcite.adapter.enumerable.NullPolicy;
import org.apache.calcite.linq4j.tree.ConstantExpression;
import org.apache.calcite.linq4j.tree.Expression;
import org.apache.calcite.linq4j.tree.Expressions;
import org.apache.calcite.linq4j.tree.MethodCallExpression;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.sql.type.SqlReturnTypeInference;
import org.apache.calcite.sql.type.SqlTypeName;
import org.opensearch.sql.data.model.ExprValue;
import org.opensearch.sql.data.model.ExprValueUtils;
import org.opensearch.sql.expression.function.ImplementorUDF;
import org.opensearch.sql.expression.function.UDFOperandMetadata;

public class EnhancedCoalesceFunction
extends ImplementorUDF {
    public EnhancedCoalesceFunction() {
        super(EnhancedCoalesceFunction.createImplementor(), NullPolicy.NONE);
    }

    private static NotNullImplementor createImplementor() {
        return (translator, call, translatedOperands) -> {
            List<Expression> exprValues = translatedOperands.stream().map(operand -> Expressions.call(ExprValueUtils.class, "fromObjectValue", new Expression[]{Expressions.convert_(operand, Object.class)})).toList();
            ConstantExpression returnTypeName = Expressions.constant(call.getType().getSqlTypeName().toString());
            MethodCallExpression result2 = Expressions.call(EnhancedCoalesceFunction.class, "enhancedCoalesceWithType", new Expression[]{Expressions.newArrayInit(ExprValue.class, exprValues), returnTypeName});
            return Expressions.call((Expression)result2, "valueForCalcite", new Expression[0]);
        };
    }

    public static ExprValue enhancedCoalesceWithType(ExprValue[] args2, String returnTypeName) {
        for (ExprValue arg : args2) {
            if (arg == null || arg.isNull() || arg.isMissing()) continue;
            return EnhancedCoalesceFunction.coerceToType(arg, returnTypeName);
        }
        return ExprValueUtils.nullValue();
    }

    private static ExprValue coerceToType(ExprValue value, String typeName) {
        return switch (typeName) {
            case "INTEGER" -> EnhancedCoalesceFunction.tryConvert(() -> ExprValueUtils.integerValue(value.integerValue()), value);
            case "BIGINT" -> EnhancedCoalesceFunction.tryConvert(() -> ExprValueUtils.longValue(value.longValue()), value);
            case "SMALLINT", "TINYINT" -> EnhancedCoalesceFunction.tryConvert(() -> ExprValueUtils.integerValue(value.integerValue()), value);
            case "DOUBLE" -> EnhancedCoalesceFunction.tryConvert(() -> ExprValueUtils.doubleValue(value.doubleValue()), value);
            case "FLOAT", "REAL" -> EnhancedCoalesceFunction.tryConvert(() -> ExprValueUtils.floatValue(value.floatValue()), value);
            case "BOOLEAN" -> EnhancedCoalesceFunction.tryConvert(() -> ExprValueUtils.booleanValue(value.booleanValue()), value);
            case "VARCHAR", "CHAR" -> EnhancedCoalesceFunction.tryConvert(() -> ExprValueUtils.stringValue(String.valueOf(value.value())), value);
            case "DATE" -> EnhancedCoalesceFunction.tryConvert(() -> ExprValueUtils.dateValue(value.dateValue()), value);
            case "TIME" -> EnhancedCoalesceFunction.tryConvert(() -> ExprValueUtils.timeValue(value.timeValue()), value);
            case "TIMESTAMP" -> EnhancedCoalesceFunction.tryConvert(() -> ExprValueUtils.timestampValue(value.timestampValue()), value);
            case "DECIMAL" -> EnhancedCoalesceFunction.tryConvert(() -> ExprValueUtils.doubleValue(value.doubleValue()), value);
            default -> value;
        };
    }

    private static ExprValue tryConvert(Supplier<ExprValue> converter, ExprValue fallbackValue) {
        try {
            return converter.get();
        }
        catch (Exception e) {
            return ExprValueUtils.stringValue(String.valueOf(fallbackValue.value()));
        }
    }

    @Override
    public SqlReturnTypeInference getReturnTypeInference() {
        return opBinding -> {
            List<RelDataType> operandTypes = opBinding.collectOperandTypes();
            RelDataType commonType = opBinding.getTypeFactory().leastRestrictive(operandTypes);
            return commonType != null ? commonType : opBinding.getTypeFactory().createSqlType(SqlTypeName.VARCHAR);
        };
    }

    @Override
    public UDFOperandMetadata getOperandMetadata() {
        return null;
    }
}

