/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.legacy.expression.core;

import java.util.List;
import java.util.Map;
import org.opensearch.sql.legacy.expression.core.Expression;
import org.opensearch.sql.legacy.expression.core.builder.ArithmeticFunctionFactory;
import org.opensearch.sql.legacy.expression.core.builder.ExpressionBuilder;
import org.opensearch.sql.legacy.expression.core.operator.ScalarOperation;
import org.opensearch.sql.legacy.expression.domain.BindingTuple;
import org.opensearch.sql.legacy.expression.model.ExprValue;
import shaded.com.google.common.collect.ImmutableMap;

public class ExpressionFactory {
    private static final Map<ScalarOperation, ExpressionBuilder> operationExpressionBuilderMap = new ImmutableMap.Builder<ScalarOperation, ExpressionBuilder>().put(ScalarOperation.ADD, ArithmeticFunctionFactory.add()).put(ScalarOperation.SUBTRACT, ArithmeticFunctionFactory.subtract()).put(ScalarOperation.MULTIPLY, ArithmeticFunctionFactory.multiply()).put(ScalarOperation.DIVIDE, ArithmeticFunctionFactory.divide()).put(ScalarOperation.MODULES, ArithmeticFunctionFactory.modules()).put(ScalarOperation.ABS, ArithmeticFunctionFactory.abs()).put(ScalarOperation.ACOS, ArithmeticFunctionFactory.acos()).put(ScalarOperation.ASIN, ArithmeticFunctionFactory.asin()).put(ScalarOperation.ATAN, ArithmeticFunctionFactory.atan()).put(ScalarOperation.ATAN2, ArithmeticFunctionFactory.atan2()).put(ScalarOperation.TAN, ArithmeticFunctionFactory.tan()).put(ScalarOperation.CBRT, ArithmeticFunctionFactory.cbrt()).put(ScalarOperation.CEIL, ArithmeticFunctionFactory.ceil()).put(ScalarOperation.COS, ArithmeticFunctionFactory.cos()).put(ScalarOperation.COSH, ArithmeticFunctionFactory.cosh()).put(ScalarOperation.EXP, ArithmeticFunctionFactory.exp()).put(ScalarOperation.FLOOR, ArithmeticFunctionFactory.floor()).put(ScalarOperation.LN, ArithmeticFunctionFactory.ln()).put(ScalarOperation.LOG, ArithmeticFunctionFactory.log()).put(ScalarOperation.LOG2, ArithmeticFunctionFactory.log2()).put(ScalarOperation.LOG10, ArithmeticFunctionFactory.log10()).build();

    public static Expression of(ScalarOperation op, List<Expression> expressions) {
        return operationExpressionBuilderMap.get((Object)op).build(expressions);
    }

    public static Expression ref(final String bindingName) {
        return new Expression(){

            @Override
            public ExprValue valueOf(BindingTuple tuple) {
                return tuple.resolve(bindingName);
            }

            public String toString() {
                return String.format("%s", bindingName);
            }
        };
    }

    public static Expression literal(final ExprValue value) {
        return new Expression(){

            @Override
            public ExprValue valueOf(BindingTuple tuple) {
                return value;
            }

            public String toString() {
                return String.format("%s", value);
            }
        };
    }

    public static Expression cast(final Expression expr) {
        return new Expression(){

            @Override
            public ExprValue valueOf(BindingTuple tuple) {
                return expr.valueOf(tuple);
            }

            public String toString() {
                return String.format("cast(%s)", expr);
            }
        };
    }
}

