/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.opensearch.response.agg;

import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.opensearch.search.SearchHits;
import org.opensearch.search.aggregations.Aggregation;
import org.opensearch.search.aggregations.Aggregations;
import org.opensearch.search.aggregations.bucket.MultiBucketsAggregation;
import org.opensearch.sql.opensearch.response.agg.MetricParser;
import org.opensearch.sql.opensearch.response.agg.MetricParserHelper;
import org.opensearch.sql.opensearch.response.agg.OpenSearchAggregationResponseParser;

public class BucketAggregationParser
implements OpenSearchAggregationResponseParser {
    private final MetricParserHelper metricsParser;

    public BucketAggregationParser(MetricParser ... metricParserList) {
        this.metricsParser = new MetricParserHelper(Arrays.asList(metricParserList));
    }

    public BucketAggregationParser(List<MetricParser> metricParserList) {
        this.metricsParser = new MetricParserHelper(metricParserList);
    }

    @Override
    public List<Map<String, Object>> parse(Aggregations aggregations) {
        Aggregation agg = (Aggregation)aggregations.asList().getFirst();
        return ((MultiBucketsAggregation)agg).getBuckets().stream().map(b -> this.parse((MultiBucketsAggregation.Bucket)b, agg.getName())).collect(Collectors.toList());
    }

    private Map<String, Object> parse(MultiBucketsAggregation.Bucket bucket, String keyName) {
        LinkedHashMap<String, Object> resultMap = new LinkedHashMap<String, Object>();
        resultMap.put(keyName, bucket.getKey());
        resultMap.putAll(this.metricsParser.parse(bucket.getAggregations()));
        return resultMap;
    }

    @Override
    public List<Map<String, Object>> parse(SearchHits hits) {
        throw new UnsupportedOperationException("BucketAggregationParser doesn't support parse(SearchHits)");
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BucketAggregationParser)) {
            return false;
        }
        BucketAggregationParser other = (BucketAggregationParser)o;
        if (!other.canEqual(this)) {
            return false;
        }
        MetricParserHelper this$metricsParser = this.metricsParser;
        MetricParserHelper other$metricsParser = other.metricsParser;
        return !(this$metricsParser == null ? other$metricsParser != null : !((Object)this$metricsParser).equals(other$metricsParser));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof BucketAggregationParser;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result2 = 1;
        MetricParserHelper $metricsParser = this.metricsParser;
        result2 = result2 * 59 + ($metricsParser == null ? 43 : ((Object)$metricsParser).hashCode());
        return result2;
    }
}

